/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"davinci/html/html.plugin":function(){
define("davinci/html/html.plugin",["require"],function(_1){
return {id:"davinci.html","davinci.editor":[{id:"HTMLEditor",name:"HTML Editor",extensions:"html",isDefault:false,editorClass:"davinci/html/ui/HTMLEditor",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]},{id:"CSSEditor",name:"CSS Editor",extensions:"css",isDefault:true,editorClass:"davinci/html/ui/CSSEditor",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]},{id:"ImageViewer",name:"Image Viewer",extensions:"jpg,gif,jpeg,png",isDefault:true,editorClass:"davinci/html/ui/ImageViewer",palettePerspective:"davinci.html.htmlEditor",expandPalettes:["left"]}],"davinci.editorActions":{editorContribution:{targetID:"davinci.html.CSSEditor",actions:[{id:"savecombo",className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",type:"ComboButton",run:function(){
_1(["../Workbench"],function(_2){
_1("../ui/Resource").save();
});
},isEnabled:function(_3){
return _1("../Workbench").getOpenEditor();
},menu:[{iconClass:"saveIcon",run:function(){
_1("../ui/Resource").save();
},isEnabled:function(_4){
return _1("../Workbench").getOpenEditor();
},label:"Save",keyBinding:{accel:true,charOrCode:"s",allowGlobal:true}},{iconClass:"saveAsIcon",run:function(){
_1("../ui/Resource").saveAs("html");
},isEnabled:function(_5){
return _1("../Workbench").getOpenEditor();
},label:"Save As",keyBinding:{accel:true,shift:true,charOrCode:"s",allowGlobal:true}}]}]}},"davinci.preferences":[{name:"HTML",id:"general",category:""}],"davinci.fileType":[{extension:"html",iconClass:"htmlFileIcon",type:"text"},{extension:"css",iconClass:"cssFileIcon",type:"text"},{extension:"jpeg",iconClass:"imageFileIcon",type:"image"},{extension:"jpg",iconClass:"imageFileIcon",type:"image"},{extension:"png",iconClass:"imageFileIcon",type:"image"},{extension:"gif",iconClass:"imageFileIcon",type:"image"}],"davinci.perspective":[{id:"htmlEditor",title:"HTML Editor",views:[{viewID:"davinci.ve.Palette",position:"left",hidden:true},{viewID:"davinci.ui.outline",position:"left",hidden:true},{viewID:"davinci.ve.style",position:"right"},{viewID:"davinci.ui.comment",position:"right",hidden:true},{viewID:"davinci.ve.states",position:"right-bottom",hidden:true},{viewID:"davinci.ui.navigator",position:"left-bottom",selected:true},{viewID:"davinci.review.reviewNavigator",position:"left"}]}]};
});
},"davinci/ve/actions/EditValueAction":function(){
define("davinci/ve/actions/EditValueAction",["dojo/_base/declare","davinci/ve/actions/ContextAction"],function(_6,_7){
return _6("davinci.ve.actions.EditValueAction",[_7],{run:function(_8){
_8=this.fixupContext(_8);
if(_8){
if(_8.declaredClass!=="davinci.ve.Context"){
return;
}
var _9=_8.getSelection();
if(_9.length!==1){
return;
}
_8.select(_9[0],false,true);
}
},isEnabled:function(_a){
_a=this.fixupContext(_a);
return (_a&&_a.getSelection().length>0);
},shouldShow:function(_b){
_b=this.fixupContext(_b);
var _c=_b?_b.editor:null;
return (_c&&_c.declaredClass=="davinci.ve.PageEditor");
}});
});
},"davinci/ve/commands/ModifyRichTextCommand":function(){
define("davinci/ve/commands/ModifyRichTextCommand",["dojo/_base/declare"],function(_d){
return _d("davinci.ve.commands.ModifyRichTextCommand",null,{name:"modify",constructor:function(_e,_f,_10,_11){
this._oldId=_e?_e.id:undefined;
this._properties=_f=(_f||{});
if(_f.richText){
this._richText=true;
this._newText=_f.richText;
this._children=_f.richText;
delete _f.richText;
}else{
this._children=_f._children;
}
this._context=_11||_e.getContext();
},setContext:function(_12){
this._context=_12;
},add:function(_13){
if(!_13||_13._oldId!=this._oldId){
return;
}
if(_13._properties){
dojo.mixin(this._properties,_13._properties);
}
if(_13._children){
this._children=_13._children;
}
},execute:function(){
if(!this._oldId||!this._properties){
return;
}
var _14=require("davinci/ve/widget");
var _15=_14.byId(this._oldId);
if(!_15){
return;
}
this._parentWidget=_15.getParent();
if(!this._oldText){
this._oldText=_15._srcElement.getElementText(this._context);
if(this._oldText&&(typeof this._oldText=="string")){
this._oldText=this._oldText.replace(/\n/g,"");
}
}
if(!this._oldData){
this._oldData=_15.getData();
this._oldData.context=this._context;
this._newData={type:this._oldData.type,properties:dojo.mixin({},this._oldData.properties,this._properties),children:this._newText,maqStates:this._oldData.maqStates,maqDeltas:this._oldData.maqDeltas,context:this._context};
this._oldData={type:this._oldData.type,properties:dojo.mixin({},this._oldData.properties,this._properties),children:this._oldText,maqStates:this._oldData.maqStates,maqDeltas:this._oldData.maqDeltas,context:this._context};
}
var _16=this._context;
if(_16){
_16.detach(_15);
}
if(this._properties.id){
delete this._newData.properties.isTempID;
}
if(!this._newId_isTempID){
this._newId_isTempID=this._newData.properties.isTempID;
}
if(!this._oldId_isTempID){
this._oldId_isTempID=this._oldData.properties.isTempID;
}
var _17=null;
var _18=this._parentWidget.indexOf(_15);
this._parentWidget.removeChild(_15);
_15.destroyWidget();
if(this._newId){
this._newData.properties.id=this._newId;
}
if(this._newId_isTempID){
this._newData.properties.isTempID=this._newId_isTempID;
}
_17=_14.createWidget(this._newData);
if(!_17){
return;
}
this._parentWidget.addChild(_17,_18);
this._newId=_17.id;
if(this._context){
this._refresh(_17);
}
if(_16){
_16.widgetAddedOrDeleted();
if(this._oldId!=this._newId){
_16.widgetChanged(_16.WIDGET_ID_CHANGED,_17,this._oldId);
}
_16.widgetChanged(_16.WIDGET_MODIFIED,_17);
}
this.newWidget=_17;
dojo.publish("/davinci/ui/widget/replaced",[_17,_15]);
var _19=require("davinci/ve/States");
_19.resetState(_17.domNode);
},undo:function(){
if(!this._newId||!this._oldData){
return;
}
var _1a=require("davinci/ve/widget");
var _1b=_1a.byId(this._newId);
if(!_1b){
return;
}
var _1c=dojo.indexOf(this._parentWidget.getChildren(),_1b);
if(_1c<0){
return;
}
var _1d=this._parentWidget.getContext();
if(_1d){
_1d.detach(_1b);
}
this._parentWidget.removeChild(_1b);
_1b.destroyWidget();
this._oldData.children=this._oldText;
this._oldData.properties.id=this._oldId;
var _1e=_1a.createWidget(this._oldData);
this._parentWidget.addChild(_1e,_1c);
if(_1d){
this._refresh(_1e);
}
_1d.widgetAddedOrDeleted();
_1d.widgetChanged(_1d.WIDGET_MODIFIED,_1e);
dojo.publish("/davinci/ui/widget/replaced",[_1e,_1b]);
var _1f=require("davinci/ve/States");
_1f.resetState(_1e.domNode);
},_refresh:function(_20){
var _21=_20.getContainerNode();
if(_21){
this._context.getGlobal()["require"]("dojo/parser").parse(_21);
}
this._context.attach(_20);
_20.startup();
_20.renderWidget();
if(_21){
this._context._attachChildren(_21);
}
}});
});
},"davinci/library":function(){
define("davinci/library",["dojo/_base/xhr","dojo/Deferred","./Runtime","./model/Path","./ve/themeEditor/metadata/CSSThemeProvider","./ve/themeEditor/metadata/query","./workbench/Preferences",],function(xhr,_22,_23,_24,_25,_26,_27){
var _28={_customWidgets:{}},_29={},_2a={},_2b={},_2c={};
dojo.subscribe("/davinci/ui/libraryChanged/start",this,function(){
_2c={};
_2b={};
});
dojo.subscribe("/davinci/resource/resourceChanged",this,function(_2d,_2e){
var _2f=require("davinci/Workbench");
var _30=_2f.getProject();
if(_2d=="deleted"||_2d=="renamed"){
var _31=_27.getPreferences("davinci.ui.ProjectPrefs",_30);
var _32=new _24(_30).append(_31.themeFolder);
var _33=new _24(_2e.getPath());
if(_33.startsWith(_32)){
delete _29[_30];
}
}
if(_2e.elementType=="File"&&_2e.extension=="theme"){
if(_2d=="modified"){
_2e.getContent().then(function(_34){
var t=JSON.parse(_34);
t.path=[_2e.getPath()];
t.getFile=function(){
return system.resource.findResource(this.path[0]);
}.bind(t);
for(var i=0;i<_29[_30].length;i++){
if(_29[_30][i].name==t.name){
_29[_30][i]=t;
return;
}
}
_29[_30].push(t);
}.bind(this));
}
}
});
_28={themesChanged:function(_35){
_29[_35]=_35?null:[];
},getThemes:function(_36,_37,_38){
if(_38){
delete _29[_36];
}
function _39(){
var rlt=[];
if(_29[_36]){
rlt=_37?_29[_36].filter(function(_3a){
return !_3a.getFile().isVirtual();
}):_29[_36];
}
return rlt;
};
if(_29[_36]){
return _39();
}
var _3b=_27.getPreferences("davinci.ui.ProjectPrefs",_36),_3c=new _24(_36).append(_3b.themeFolder);
var _3d=_23.serverJSONRequest({url:"cmd/getThemes",handleAs:"json",content:{path:"*.theme",ignoreCase:true,workspaceOnly:false,inFolder:_3c.toString()},sync:true});
_3d.forEach(function(_3e){
_3e.getFile=function(){
return system.resource.findResource(this.path[0]);
}.bind(_3e);
}.bind(this));
_29[_36]=_3d;
return _39();
},getThemeMetadata:function(_3f){
if(_2a[_3f.name]){
return _2a[_3f.name];
}
var _40=new _24(_3f.getFile().getPath()).removeLastSegments();
var _41=_3f.files.filter(function(_42){
return _42.indexOf(".css")>-1;
}).map(_40.append,_40);
var _43=_3f.meta.map(function(_44){
var _45=_40.append(_44);
return system.resource.findResource(_45.toString());
});
var _46=new _25(_43,_3f);
_2a[_3f.name]={loader:new _26(_43),css:_41,metadata:_46};
return _2a[_3f.name];
},addCustomWidgets:function(_47,_48,_49,_4a){
var _4b=_27.getPreferences("davinci.ui.ProjectPrefs",_47);
if(!_4b.widgetFolder){
_4b.widgetFolder="./lib/custom";
_27.savePreferences("davinci.ui.ProjectPrefs",_47,_4b);
}
var _4c=_48.getParentFolder();
var _4d=_4c.getPath();
var _4e=new _24(_4d);
var _4f=require("davinci/ve/metadata").parseMetaData(_4a.name,_4a,_4e,_49);
if(!_28._customWidgets[_47].hasOwnProperty("name")){
_28._customWidgets[_47].name="custom";
_28._customWidgets[_47].metaPath=_4b.widgetFolder;
_28._customWidgets[_47].localPath=true;
}
_28._customWidgets[_47]=_4f;
dojo.publish("/davinci/ui/addedCustomWidget",[_4f]);
return _4f;
},getCustomWidgets:function(_50){
if(!_28._customWidgets||!_28._customWidgets[_50]){
if(!_28._customWidgets){
_28._customWidgets={};
}
if(!_28._customWidgets[_50]){
_28._customWidgets[_50]=[];
}
var _51=_27.getPreferences("davinci.ui.ProjectPrefs",_50);
if(!_51.widgetFolder){
_51.widgetFolder="./lib/custom";
_27.savePreferences("davinci.ui.ProjectPrefs",_50,_51);
}
var _52=new _24(_50).append(_51.widgetFolder);
var _53=_52.getSegments();
var _54=system.resource.findResource(_53[0]);
for(var i=1;i<_53.length;i++){
var _55=_54.getChildSync(_53[i]);
if(_55){
_54=_55;
}else{
_54=_54.createResource(_53[i],true);
}
}
var _56;
_54.getChildrenSync(function onComplete(_57){
_56=_57;
},true);
this._customWidgetPackages=[];
var _58={};
for(var i=0;i<_56.length;i++){
var _59=_56[i];
if(_59.elementType=="Folder"){
_58[_59.name]=_59.getPath();
var _5a="maq-lib-custom-"+_59.name;
var url=_59.getURL();
require({packages:[{name:_5a,location:url}]});
this._customWidgetPackages.push({name:_59.name,location:url});
}
}
var _5b=system.resource.findResource("*_widgets.json",false,_54);
this._customWidgetDescriptors={};
for(var i=0;i<_5b.length;i++){
var _5c=_5b[i];
var _5d=_5c.getParentFolder();
var _5e=_54.getURL();
var _5f=_5d.getURL();
var _60=_5f.substr(_5e.length+1);
var _61=null;
try{
_61=dojo.fromJson(_5c.getContentSync());
}
catch(e){
}
if(!_61){
console.warn("No metadata loaded for custom widget: "+_60);
continue;
}
if(!_61.customWidgetSpec){
console.warn("Unsupported older custom widget spec version ("+_61.customWidgetSpec+") for custom widget: "+_60);
continue;
}
var _62=_60.split("/").shift();
_61.__metadataModuleId="maq-lib-custom-"+_62;
_28.addCustomWidgets(_50,_5c,_58[_62],_61);
if(!_2c[_50]){
_2c[_50]={};
}
if(!_2c[_50][_5d.name]){
_2c[_50][_5d.name]={};
}
_2c[_50][_5d.name][_61.version]=_5f;
if(_61&&_61.widgets){
for(var j=0;j<_61.widgets.length;j++){
var _63=_61.widgets[j].type;
if(_63){
this._customWidgetDescriptors[_63]={name:_62,location:_5f,descriptor:_61};
}
}
}
}
}
return {custom:_28._customWidgets[_50]};
},getCustomWidgetPackages:function(){
return this._customWidgetPackages||[];
},getCustomWidgetDescriptors:function(){
return this._customWidgetDescriptors?this._customWidgetDescriptors:{};
},getInstalledLibs:function(){
if(!_28._serverLibs){
_28._serverLibs=_23.serverJSONRequest({url:"cmd/listLibs",handleAs:"json",content:{},sync:true})[0].userLibs;
}
return _28._serverLibs;
},getUserLibs:function(_64){
if(_2b.base){
return _2b.base;
}
_2b.base=_23.serverJSONRequest({url:"cmd/getUserLibs",handleAs:"json",content:{base:_64},sync:true})[0].userLibs;
return _2b.base;
},getLibRoot:function(id,_65,_66){
var d=new _22();
var _67=_2c;
if(_67[_66]&&_67[_66][id]&&_67[_66][id][_65]!==undefined){
return d.resolve(_67[_66][id][_65]||"");
}
if(!_67[_66]){
_67[_66]={};
}
if(!_67[_66][id]){
_67[_66][id]={};
}
return xhr.get({url:"cmd/getLibRoots",handleAs:"json",content:{libId:id,version:_65,base:_66}}).then(function(_68){
var _69=_68?_68[0].libRoot.root:null;
if(!_67[id]){
_67[id]={};
}
_67[_66][id][_65]=_69;
return d.resolve(_69||"");
});
},modifyLib:function(_6a){
return _23.serverJSONRequest({url:"cmd/modifyLib",handleAs:"text",content:{libChanges:JSON.stringify(_6a)},sync:true});
},addLib:function(id,_6b){
return _23.serverJSONRequest({url:"cmd/getLibRoots",handleAs:"json",content:{libId:id,version:_6b},sync:true})[0].libRoot.root;
},getLibraryId:function(_6c,_6d){
var _6e={sketch:"sketch",claro:"claro"};
return _6e[_6c]+(_6d||"");
},getLibraryName:function(lib){
var _6f;
var _70;
for(var _71 in lib){
_6f=_71;
_70=lib[_6f];
}
return _6f;
}};
return _28;
});
},"dojo/date":function(){
define("dojo/date",["./has","./_base/lang"],function(has,_72){
var _73={};
_73.getDaysInMonth=function(_74){
var _75=_74.getMonth();
var _76=[31,28,31,30,31,30,31,31,30,31,30,31];
if(_75==1&&_73.isLeapYear(_74)){
return 29;
}
return _76[_75];
};
_73.isLeapYear=function(_77){
var _78=_77.getFullYear();
return !(_78%400)||(!(_78%4)&&!!(_78%100));
};
_73.getTimezoneName=function(_79){
var str=_79.toString();
var tz="";
var _7a;
var pos=str.indexOf("(");
if(pos>-1){
tz=str.substring(++pos,str.indexOf(")"));
}else{
var pat=/([A-Z\/]+) \d{4}$/;
if((_7a=str.match(pat))){
tz=_7a[1];
}else{
str=_79.toLocaleString();
pat=/ ([A-Z\/]+)$/;
if((_7a=str.match(pat))){
tz=_7a[1];
}
}
}
return (tz=="AM"||tz=="PM")?"":tz;
};
_73.compare=function(_7b,_7c,_7d){
_7b=new Date(+_7b);
_7c=new Date(+(_7c||new Date()));
if(_7d=="date"){
_7b.setHours(0,0,0,0);
_7c.setHours(0,0,0,0);
}else{
if(_7d=="time"){
_7b.setFullYear(0,0,0);
_7c.setFullYear(0,0,0);
}
}
if(_7b>_7c){
return 1;
}
if(_7b<_7c){
return -1;
}
return 0;
};
_73.add=function(_7e,_7f,_80){
var sum=new Date(+_7e);
var _81=false;
var _82="Date";
switch(_7f){
case "day":
break;
case "weekday":
var _83,_84;
var mod=_80%5;
if(!mod){
_83=(_80>0)?5:-5;
_84=(_80>0)?((_80-5)/5):((_80+5)/5);
}else{
_83=mod;
_84=parseInt(_80/5);
}
var _85=_7e.getDay();
var adj=0;
if(_85==6&&_80>0){
adj=1;
}else{
if(_85==0&&_80<0){
adj=-1;
}
}
var _86=_85+_83;
if(_86==0||_86==6){
adj=(_80>0)?2:-2;
}
_80=(7*_84)+_83+adj;
break;
case "year":
_82="FullYear";
_81=true;
break;
case "week":
_80*=7;
break;
case "quarter":
_80*=3;
case "month":
_81=true;
_82="Month";
break;
default:
_82="UTC"+_7f.charAt(0).toUpperCase()+_7f.substring(1)+"s";
}
if(_82){
sum["set"+_82](sum["get"+_82]()+_80);
}
if(_81&&(sum.getDate()<_7e.getDate())){
sum.setDate(0);
}
return sum;
};
_73.difference=function(_87,_88,_89){
_88=_88||new Date();
_89=_89||"day";
var _8a=_88.getFullYear()-_87.getFullYear();
var _8b=1;
switch(_89){
case "quarter":
var m1=_87.getMonth();
var m2=_88.getMonth();
var q1=Math.floor(m1/3)+1;
var q2=Math.floor(m2/3)+1;
q2+=(_8a*4);
_8b=q2-q1;
break;
case "weekday":
var _8c=Math.round(_73.difference(_87,_88,"day"));
var _8d=parseInt(_73.difference(_87,_88,"week"));
var mod=_8c%7;
if(mod==0){
_8c=_8d*5;
}else{
var adj=0;
var _8e=_87.getDay();
var _8f=_88.getDay();
_8d=parseInt(_8c/7);
mod=_8c%7;
var _90=new Date(_87);
_90.setDate(_90.getDate()+(_8d*7));
var _91=_90.getDay();
if(_8c>0){
switch(true){
case _8e==6:
adj=-1;
break;
case _8e==0:
adj=0;
break;
case _8f==6:
adj=-1;
break;
case _8f==0:
adj=-2;
break;
case (_91+mod)>5:
adj=-2;
}
}else{
if(_8c<0){
switch(true){
case _8e==6:
adj=0;
break;
case _8e==0:
adj=1;
break;
case _8f==6:
adj=2;
break;
case _8f==0:
adj=1;
break;
case (_91+mod)<0:
adj=2;
}
}
}
_8c+=adj;
_8c-=(_8d*2);
}
_8b=_8c;
break;
case "year":
_8b=_8a;
break;
case "month":
_8b=(_88.getMonth()-_87.getMonth())+(_8a*12);
break;
case "week":
_8b=parseInt(_73.difference(_87,_88,"day")/7);
break;
case "day":
_8b/=24;
case "hour":
_8b/=60;
case "minute":
_8b/=60;
case "second":
_8b/=1000;
case "millisecond":
_8b*=_88.getTime()-_87.getTime();
}
return Math.round(_8b);
};
1&&_72.mixin(_72.getObject("dojo.date",true),_73);
return _73;
});
},"url:davinci/ui/templates/SaveAsWidgetForm.html":"<div class='dvSaveAsWidgetForm'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<p class=\"dvSawfDesc\">${descriptionString}</p>\n\t\t<p>\n\t\t\t<span class=\"dvSawfLabel\">${nameString}:</span>\n\t\t\t<input dojoType='dijit.form.ValidationTextBox' dojoAttachPoint=\"nameInputNode\" trim=\"true\"\n\t\t\t\t\tpromptMessage=\"${namePromptString}\"></input>\n\t\t</p>\n\t\t<p>\n\t\t\t<span class=\"dvSawfLabel\"><span class=\"dvRequired\">*</span>${idString}:</span>\n\t\t\t<input dojoType='dijit.form.ValidationTextBox' dojoAttachPoint=\"idInputNode\" trim=\"true\"\n\t\t\t\t\trequired=\"true\" intermediateChanges=\"true\" promptMessage=\"${idPromptString}\"></input>\n\t\t</p>\n\t\t<p>\n\t\t\t<span class=\"dvSawfLabel\">${versionString}:</span>\n\t\t\t<input dojoType='dijit.form.ValidationTextBox' dojoAttachPoint=\"versionInputNode\"\n\t\t\t\t\ttrim=\"true\"></input>\n\t\t</p>\n\t\t<h4 class=\"dvRequired\">*${requiredString}</h4>\n\t\n\t\t<div dojoType=\"dijit.TitlePane\" title=\"${metadataTitle}\" open=\"false\">\n\t\t\t<textarea dojoType=\"dijit.form.SimpleTextarea\" dojoAttachPoint=\"textareaNode\" name=\"metadata\"\n\t\t\t\t\trows=\"15\" cols=\"50\" intermediateChanges=\"true\">${initialTextareaContent}</textarea>\n\t\t</div>\n\t</div>\n  <div class=\"dijitDialogPaneActionBar\">\n    <button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"buttonSave\" class=\"maqPrimaryButton\" type=\"submit\" disabled=\"true\">${saveString}</button>\n    <button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"buttonCancel\" type=\"button\" class=\"maqSecondaryButton\">${cancelString}</button>\n  </div>\n</div>\n","davinci/ui/widgets/AddFilesZip":function(){
define("davinci/ui/widgets/AddFilesZip",["dojo/_base/declare","./AddFiles","../../model/Path","system/resource","dijit/ProgressBar","dojo/i18n!../nls/ui"],function(_92,_93,_94,_95,_96,_97){
return _92(_93,{_getCommand:function(){
return this.inherited(arguments)+"&explodeZip=1";
},onClose:function(){
},postCreate:function(){
dojo.style(this.zipWarning,"display","block");
var _98=_95.getRoot();
if(this.selectedResource){
_98=this.selectedResource.elementType=="Folder"?this.selectedResource:this.selectedResource.parent;
}
this.fileDialogParentFolder.innerHTML=_98.getPath();
this.uploader.set("multiple",false);
this.uploader.set("label",_97.selectZip);
this.uploader.set("url",this._getCommand(_98));
var _99,_9a=this.uploadBtn;
_9a.set("disabled",true);
var _9b=this.uploader;
dojo.connect(this.uploader,"onChange",function(_9c){
if(_99){
dojo.disconnect(_99);
}
_99=dojo.connect(_9a,"onClick",this,function(){
_9b.set("disabled",true);
this.progress=new _96({},this.zipWarning);
_9b.upload();
});
if(_9a.oldText){
_9a.containerNode.innerText=_9a.oldText;
}
var _9d=_9c[0].name,_9e=/\.zip$/i.test(_9d);
this.filelist.innerText=_9e?dojo.replace("Selected: {0}",[_9d]):"";
_9a.set("disabled",!_9e);
}.bind(this));
var _9f=function(){
dojo.disconnect(_99);
this.onClose();
}.bind(this);
dojo.connect(this.uploader,"onProgress",this,function(obj){
this.progress.set("value",obj.percent);
});
dojo.connect(this.uploader,"onComplete",function(_a0){
_a0.forEach(function(_a1){
var _a2,_a3=new _94(_98.getPath());
if(_a1.file.indexOf("/")==-1){
_98._appendFiles([{isDir:false,isLib:false,isNew:false,name:_a1.file}]);
_a3.append(_a1.file);
_a2="updated";
}else{
_98.getChildrenSync(function(){
},true);
_a2="reload";
}
_95.resourceChanged(_a2,_a3.toString());
});
_9f();
});
dojo.connect(this.uploader,"onError",function(_a4){
console.error("Upload error: ",_a4);
_9f();
});
}});
});
},"davinci/ve/actions/OtherAction":function(){
define("davinci/ve/actions/OtherAction",["dojo/_base/declare","./_ReorderAction","davinci/commands/CompoundCommand","davinci/ve/commands/ReparentCommand"],function(_a5,_a6,_a7,_a8){
return _a5("davinci.ve.actions.OtherAction",[_a6],{run:function(_a9){
},isEnabled:function(_aa){
return true;
},shouldShow:function(_ab){
_ab=this.fixupContext(_ab);
var _ac=_ab?_ab.editor:null;
return (_ac&&_ac.declaredClass=="davinci.ve.PageEditor");
}});
});
},"davinci/workbench/ViewLite":function(){
define("davinci/workbench/ViewLite",["dojo/_base/declare","./WidgetLite","../ve/States"],function(_ad,_ae){
return _ad("davinci.workbench.ViewLite",[_ae],{_editor:null,_widget:null,_subWidget:null,constructor:function(_af,_b0){
this.subscriptions=[];
this.publishing={};
dojo.subscribe("/davinci/ui/editorSelected",dojo.hitch(this,this._editorSelected));
dojo.subscribe("/davinci/ui/widgetSelected",dojo.hitch(this,this._widgetSelectionChanged));
},_widgetSelectionChanged:function(_b1){
if(!this._editor){
return;
}
var _b2=_b1[0];
if(_b2&&this._widget==_b2&&this._subwidget==_b2.subwidget){
return false;
}
this._widget=_b2;
this._subwidget=_b2&&_b2.subwidget;
if(this.onWidgetSelectionChange){
this.onWidgetSelectionChange();
}
},_editorSelected:function(_b3){
this._editor=_b3.editor;
if(this.onEditorSelected){
this.onEditorSelected(this._editor);
}
},subscribe:function(_b4,_b5){
this.subscriptions.push(dojo.subscribe(_b4,this,_b5));
},publish:function(_b6,_b7){
this.publishing[_b6]=true;
try{
dojo.publish(_b6,_b7);
}
catch(e){
console.error(e);
}
delete this.publishing[_b6];
},destroy:function(){
dojo.forEach(this.subscriptions,dojo.unsubscribe);
delete this.subscriptions;
}});
});
},"url:davinci/ui/templates/NewProject.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table class=\"NewProjectDialogTable\">\n\t\t<tr>\n\t\t\t<td class=\"NewProjectDialogLabel\"><label for=\"new-project-name\">${newProjectName}</label></td>\n\t\t\t<td>\n\t\t\t\t<input class='templateInput' id=\"new-project-name\" data-dojo-type=\"dijit.form.ValidationTextBox\" type='text' dojoAttachPoint=\"_projectName\">\n\t\t\t</td>\n\t\t\t<td><div dojoAttachPoint='_error4'></div></td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td colspan=\"2\" class=\"NewProjectUseTemplateCell\">\n\t\t\t\t<input type=\"checkbox\" dojoAttachPoint=\"_useProjectTemplate\" id=\"new-project-template\">\n\t\t\t\t<label class=\"NewProjectDialogLabel NewProjectUseTemplateLabel\" for=\"new-project-template\">${newProjectUseProjectTemplate}</label>\n\t\t\t\t<select class=\"NewProjectTemplateSelect\" dojoType=\"dijit.form.Select\" dojoAttachPoint=\"projectTemplates\" dojoAttachEvent=\"onChange: _onChangeTemplate\">\n\t\t\t\t\t<!-- Menu created dynamically -->\n\t\t\t\t</select>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td colspan=\"2\" class=\"NewProjectCloneExistingCell\">\n\t\t\t\t<input type=\"checkbox\" dojoAttachPoint=\"_cloneExistingProject\" id=\"new-project-clone\">\n\t\t\t\t<label class=\"NewProjectDialogLabel\" for=\"new-project-clone\">${newProjectCloneExistingProject}</label>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td colspan=\"2\" class=\"NewProjectEclipseSupportCell\">\n\t\t\t\t<input type=\"checkbox\" dojoAttachPoint=\"_eclipseSupport\" id=\"new-project-eclipse\">\n\t\t\t\t<label class=\"NewProjectDialogLabel\" for=\"new-project-eclipse\">${newProjectEclipseSupport}</label>\n\t\t\t</td>\n\t\t</tr>\n\t\t</table>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='${create}' class=\"maqPrimaryButton\" type=\"submit\" disabled></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n","davinci/ve/widgets/MultiInputDropDown":function(){
define("davinci/ve/widgets/MultiInputDropDown",["dojo/_base/declare","dijit/_WidgetBase","davinci/ve/widgets/MutableStore","dijit/form/ComboBox","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common"],function(_b8,_b9,_ba,_bb,_bc,_bd){
var _be=_b8("davinci.ve.widgets.MultiInputDropDown",[_b9],{numberDelta:1,insertPosition:1,data:null,postCreate:function(){
this.domNode.removeAttribute("data-dojo-type");
this.domNode.removeAttribute("dojoType");
var _bf=dojo.doc.createElement("div");
this._run={};
if(!this.data){
this.data=[{value:""},{value:"auto"},{value:"0px"},{value:_be.divider},{value:"Remove Value",run:function(){
this.set("value","");
}},{value:_be.divider},{value:"Help",run:function(){
alert("help!");
}}];
}else{
this.data.push({value:_be.divider});
this.data.push({value:"Remove Value",run:function(){
this.set("value","");
}});
}
var _c0=[];
for(var i=0;i<this.data.length;i++){
_c0.push(this.data[i].value);
if(this.data[i].run){
this._run[this.data[i].value]=this.data[i].run;
}
}
this._store=new _ba({values:_c0,divider:_be.divider});
this._dropDown=new _bb({store:this._store,required:false,style:"width:100%"});
var _c1=dojo.doc.createElement("div");
dojo.style(_c1,"float","right");
this._plus=dojo.doc.createElement("button");
dojo.addClass(this._plus,"incrementButton");
dojo.addClass(this._plus,"propertyButton");
_c1.appendChild(this._plus);
this._minus=dojo.doc.createElement("button");
dojo.addClass(this._minus,"decrementButton");
dojo.addClass(this._minus,"propertyButton");
_c1.appendChild(this._minus);
_bf.appendChild(_c1);
var div=dojo.create("div",{"class":"propInputWithIncrDecrButtons"});
div.appendChild(this._dropDown.domNode);
_bf.appendChild(div);
div=dojo.doc.createElement("div");
dojo.style(div,"clear","both");
_bf.appendChild(div);
this._currentValue=this._store.getItemNumber(0);
dojo.connect(this._dropDown,"onKeyUp",this,"_updateSpinner");
dojo.connect(this._dropDown,"onChange",this,"_onChange");
dojo.connect(this._plus,"onclick",this,"_plusButton",false);
dojo.connect(this._minus,"onclick",this,"_minusButton",false);
this._updateSpinner();
this.domNode.appendChild(_bf);
},_setReadOnlyAttr:function(_c2){
this._isReadOnly=_c2;
this._dropDown.set("disabled",_c2);
dojo.attr(this._plus,"disabled",_c2);
dojo.attr(this._minus,"disabled",_c2);
},onChange:function(_c3){
},_getValueAttr:function(){
return this._dropDown.get("value");
},_setValueAttr:function(_c4,_c5){
this._dropDown.set("value",_c4,true);
this._currentValue=this._dropDown.get("value");
this._onChange(this._currentValue);
if(!_c5){
this.onChange();
}
},_changeValue:function(_c6,_c7){
var _c8=_c6.split(" ");
var _c9="";
for(var i=0;i<_c8.length;i++){
if(i>0){
_c9+=" ";
}
var _ca=_c8[i].match(/([-\d\.]+)([a-zA-Z%]*)/);
if(!_ca){
_c9+=_c8[i];
}else{
if(_ca.length==1){
_c9+=_ca[0];
}else{
for(var z=1;z<_ca.length;z++){
if(!isNaN(_ca[z])&&_ca[z]!=""){
_c9+=parseFloat(_ca[z])+_c7;
}else{
_c9+=_ca[z];
}
}
}
}
}
return _c9;
},_plusButton:function(){
var _cb=this._dropDown.get("value");
var _cc=this._changeValue(_cb,this.numberDelta);
this._store.modifyItem(_cb,_cc);
this._dropDown.set("value",_cc);
},_minusButton:function(){
var _cd=this._dropDown.get("value");
var _ce=this._changeValue(_cd,-1*this.numberDelta);
this._store.modifyItem(_cd,_ce);
this._dropDown.set("value",_ce);
},_updateSpinner:function(){
var _cf=this._dropDown.get("value");
var _d0=/(-?)(\d+){1}/;
var _d1=_d0.exec(_cf);
if(_d1&&_d1.length){
this._minus.disabled=this._plus.disabled=false;
}else{
this._minus.disabled=this._plus.disabled=true;
}
return true;
},_onChange:function(_d2){
var _d3;
if(_d2 in this._run){
this._dropDown.get("value",this._store.getItemNumber(0));
dojo.hitch(this,this._run[_d2])();
}else{
if(_d2==_be.divider){
this._dropDown.get("value",this._store.getItemNumber(0));
}else{
if(_d3=this._store.findSimilar(_d2)){
this._store.modifyItem(_d3,_d2);
}else{
if(!this._store.contains(_d2)){
this._store.insert(this.insertPosition,_d2);
}
}
}
}
if(this._currentValue!=this._dropDown.get("value")){
this._currentValue=this._dropDown.get("value");
this.onChange(_d2);
}
this._updateSpinner();
}});
return dojo.mixin(_be,{divider:"---"});
});
},"dojox/grid/DataGrid":function(){
require({cache:{"dojo/i18n":function(){
define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(_d4,_d5,has,_d6,_d7,_d8,xhr,_d9,_da){
has.add("dojo-preload-i18n-Api",1);
1||has.add("dojo-v1x-i18n-Api",1);
var _db=_d4.i18n={},_dc=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_dd=function(_de,_df,_e0,_e1){
for(var _e2=[_e0+_e1],_e3=_df.split("-"),_e4="",i=0;i<_e3.length;i++){
_e4+=(_e4?"-":"")+_e3[i];
if(!_de||_de[_e4]){
_e2.push(_e0+_e4+"/"+_e1);
}
}
return _e2;
},_e5={},_e6=function(_e7,_e8,_e9){
_e9=_e9?_e9.toLowerCase():_d4.locale;
_e7=_e7.replace(/\./g,"/");
_e8=_e8.replace(/\./g,"/");
return (/root/i.test(_e9))?(_e7+"/nls/"+_e8):(_e7+"/nls/"+_e9+"/"+_e8);
},_ea=_d4.getL10nName=function(_eb,_ec,_ed){
return _eb=_da.id+"!"+_e6(_eb,_ec,_ed);
},_ee=function(_ef,_f0,_f1,_f2,_f3,_f4){
_ef([_f0],function(_f5){
var _f6=_d8.clone(_f5.root),_f7=_dd(!_f5._v1x&&_f5,_f3,_f1,_f2);
_ef(_f7,function(){
for(var i=1;i<_f7.length;i++){
_f6=_d8.mixin(_d8.clone(_f6),arguments[i]);
}
var _f8=_f0+"/"+_f3;
_e5[_f8]=_f6;
_f4();
});
});
},_f9=function(id,_fa){
return /^\./.test(id)?_fa(id):id;
},_fb=function(_fc){
var _fd=_d7.extraLocale||[];
_fd=_d8.isArray(_fd)?_fd:[_fd];
_fd.push(_fc);
return _fd;
},_fe=function(id,_ff,load){
if(has("dojo-preload-i18n-Api")){
var _100=id.split("*"),_101=_100[1]=="preload";
if(_101){
if(!_e5[id]){
_e5[id]=1;
_102(_100[2],_d9.parse(_100[3]),1,_ff);
}
load(1);
}
if(_101||_103(id,_ff,load)){
return;
}
}
var _104=_dc.exec(id),_105=_104[1]+"/",_106=_104[5]||_104[4],_107=_105+_106,_108=(_104[5]&&_104[4]),_109=_108||_d4.locale,_10a=_107+"/"+_109,_10b=_108?[_109]:_fb(_109),_10c=_10b.length,_10d=function(){
if(!--_10c){
load(_d8.delegate(_e5[_10a]));
}
};
_d6.forEach(_10b,function(_10e){
var _10f=_107+"/"+_10e;
if(has("dojo-preload-i18n-Api")){
_110(_10f);
}
if(!_e5[_10f]){
_ee(_ff,_107,_105,_106,_10e,_10d);
}else{
_10d();
}
});
};
if(has("dojo-unit-tests")){
var _111=_db.unitTests=[];
}
if(has("dojo-preload-i18n-Api")||1){
var _112=_db.normalizeLocale=function(_113){
var _114=_113?_113.toLowerCase():_d4.locale;
return _114=="root"?"ROOT":_114;
},isXd=function(mid,_115){
return (1&&1)?_115.isXdUrl(_d5.toUrl(mid+".js")):true;
},_116=0,_117=[],_102=_db._preloadLocalizations=function(_118,_119,_11a,_11b){
_11b=_11b||_d5;
function _11c(mid,_11d){
if(isXd(mid,_11b)||_11a){
_11b([mid],_11d);
}else{
_127([mid],_11d,_11b);
}
};
function _11e(_11f,func){
var _120=_11f.split("-");
while(_120.length){
if(func(_120.join("-"))){
return;
}
_120.pop();
}
func("ROOT");
};
function _121(_122){
_122=_112(_122);
_11e(_122,function(loc){
if(_d6.indexOf(_119,loc)>=0){
var mid=_118.replace(/\./g,"/")+"_"+loc;
_116++;
_11c(mid,function(_123){
for(var p in _123){
_e5[_d5.toAbsMid(p)+"/"+loc]=_123[p];
}
--_116;
while(!_116&&_117.length){
_fe.apply(null,_117.shift());
}
});
return true;
}
return false;
});
};
_121();
_d6.forEach(_d4.config.extraLocale,_121);
},_103=function(id,_124,load){
if(_116){
_117.push([id,_124,load]);
}
return _116;
},_110=function(){
};
}
if(1){
var _125={},_126=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}"),_127=function(deps,_128,_129){
var _12a=[];
_d6.forEach(deps,function(mid){
var url=_129.toUrl(mid+".js");
function _fe(text){
var _12b=_126(text,_110,mid,_125);
if(_12b===_125){
_12a.push(_e5[url]=_125.result);
}else{
if(_12b instanceof Error){
console.error("failed to evaluate i18n bundle; url="+url,_12b);
_12b={};
}
_12a.push(_e5[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_12b:{root:_12b,_v1x:1}));
}
};
if(_e5[url]){
_12a.push(_e5[url]);
}else{
var _12c=_129.syncLoadNls(mid);
if(_12c){
_12a.push(_12c);
}else{
if(!xhr){
try{
_129.getText(url,true,_fe);
}
catch(e){
_12a.push(_e5[url]={});
}
}else{
xhr.get({url:url,sync:true,load:_fe,error:function(){
_12a.push(_e5[url]={});
}});
}
}
}
});
_128&&_128.apply(null,_12a);
};
_110=function(_12d){
for(var _12e,_12f=_12d.split("/"),_130=_d4.global[_12f[0]],i=1;_130&&i<_12f.length-1;_130=_130[_12f[i++]]){
}
if(_130){
_12e=_130[_12f[i]];
if(!_12e){
_12e=_130[_12f[i].replace(/-/g,"_")];
}
if(_12e){
_e5[_12d]=_12e;
}
}
return _12e;
};
_db.getLocalization=function(_131,_132,_133){
var _134,_135=_e6(_131,_132,_133);
_fe(_135,(!isXd(_135,_d5)?function(deps,_136){
_127(deps,_136,_d5);
}:_d5),function(_137){
_134=_137;
});
return _134;
};
if(has("dojo-unit-tests")){
_111.push(function(doh){
doh.register("tests.i18n.unit",function(t){
var _138;
_138=_126("{prop:1}",_110,"nonsense",_125);
t.is({prop:1},_138);
t.is(undefined,_138[1]);
_138=_126("({prop:1})",_110,"nonsense",_125);
t.is({prop:1},_138);
t.is(undefined,_138[1]);
_138=_126("{'prop-x':1}",_110,"nonsense",_125);
t.is({"prop-x":1},_138);
t.is(undefined,_138[1]);
_138=_126("({'prop-x':1})",_110,"nonsense",_125);
t.is({"prop-x":1},_138);
t.is(undefined,_138[1]);
_138=_126("define({'prop-x':1})",_110,"nonsense",_125);
t.is(_125,_138);
t.is({"prop-x":1},_125.result);
_138=_126("define('some/module', {'prop-x':1})",_110,"nonsense",_125);
t.is(_125,_138);
t.is({"prop-x":1},_125.result);
_138=_126("this is total nonsense and should throw an error",_110,"nonsense",_125);
t.is(_138 instanceof Error,true);
});
});
}
}
return _d8.mixin(_db,{dynamic:true,normalize:_f9,load:_fe,cache:_e5});
});
},"dojo/string":function(){
define(["./_base/kernel","./_base/lang"],function(_139,lang){
var _13a={};
lang.setObject("dojo.string",_13a);
_13a.rep=function(str,num){
if(num<=0||!str){
return "";
}
var buf=[];
for(;;){
if(num&1){
buf.push(str);
}
if(!(num>>=1)){
break;
}
str+=str;
}
return buf.join("");
};
_13a.pad=function(text,size,ch,end){
if(!ch){
ch="0";
}
var out=String(text),pad=_13a.rep(ch,Math.ceil((size-out.length)/ch.length));
return end?out+pad:pad+out;
};
_13a.substitute=function(_13b,map,_13c,_13d){
_13d=_13d||_139.global;
_13c=_13c?lang.hitch(_13d,_13c):function(v){
return v;
};
return _13b.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_13e,key,_13f){
var _140=lang.getObject(key,false,map);
if(_13f){
_140=lang.getObject(_13f,false,_13d).call(_13d,_140,key);
}
return _13c(_140,key).toString();
});
};
_13a.trim=String.prototype.trim?lang.trim:function(str){
str=str.replace(/^\s+/,"");
for(var i=str.length-1;i>=0;i--){
if(/\S/.test(str.charAt(i))){
str=str.substring(0,i+1);
break;
}
}
return str;
};
return _13a;
});
},"dijit/a11y":function(){
define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/sniff","./main"],function(_141,_142,_143,dom,_144,_145,has,_146){
var _147=(_146._isElementShown=function(elem){
var s=_145.get(elem);
return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_144.get(elem,"type")!="hidden");
});
_146.hasDefaultTabStop=function(elem){
switch(elem.nodeName.toLowerCase()){
case "a":
return _144.has(elem,"href");
case "area":
case "button":
case "input":
case "object":
case "select":
case "textarea":
return true;
case "iframe":
var body;
try{
var _148=elem.contentDocument;
if("designMode" in _148&&_148.designMode=="on"){
return true;
}
body=_148.body;
}
catch(e1){
try{
body=elem.contentWindow.document.body;
}
catch(e2){
return false;
}
}
return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));
default:
return elem.contentEditable=="true";
}
};
var _149=(_146.isTabNavigable=function(elem){
if(_144.get(elem,"disabled")){
return false;
}else{
if(_144.has(elem,"tabIndex")){
return _144.get(elem,"tabIndex")>=0;
}else{
return _146.hasDefaultTabStop(elem);
}
}
});
_146._getTabNavigable=function(root){
var _14a,last,_14b,_14c,_14d,_14e,_14f={};
function _150(node){
return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();
};
var _151=function(_152){
for(var _153=_152.firstChild;_153;_153=_153.nextSibling){
if(_153.nodeType!=1||(has("ie")<=9&&_153.scopeName!=="HTML")||!_147(_153)){
continue;
}
if(_149(_153)){
var _154=+_144.get(_153,"tabIndex");
if(!_144.has(_153,"tabIndex")||_154==0){
if(!_14a){
_14a=_153;
}
last=_153;
}else{
if(_154>0){
if(!_14b||_154<_14c){
_14c=_154;
_14b=_153;
}
if(!_14d||_154>=_14e){
_14e=_154;
_14d=_153;
}
}
}
var rn=_150(_153);
if(_144.get(_153,"checked")&&rn){
_14f[rn]=_153;
}
}
if(_153.nodeName.toUpperCase()!="SELECT"){
_151(_153);
}
}
};
if(_147(root)){
_151(root);
}
function rs(node){
return _14f[_150(node)]||node;
};
return {first:rs(_14a),last:rs(last),lowest:rs(_14b),highest:rs(_14d)};
};
_146.getFirstInTabbingOrder=function(root,doc){
var _155=_146._getTabNavigable(dom.byId(root,doc));
return _155.lowest?_155.lowest:_155.first;
};
_146.getLastInTabbingOrder=function(root,doc){
var _156=_146._getTabNavigable(dom.byId(root,doc));
return _156.last?_156.last:_156.highest;
};
return {hasDefaultTabStop:_146.hasDefaultTabStop,isTabNavigable:_146.isTabNavigable,_getTabNavigable:_146._getTabNavigable,getFirstInTabbingOrder:_146.getFirstInTabbingOrder,getLastInTabbingOrder:_146.getLastInTabbingOrder};
});
},"dojo/dnd/autoscroll":function(){
define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_157,_158,_159){
var _15a={};
lang.setObject("dojo.dnd.autoscroll",_15a);
_15a.getViewport=_159.getBox;
_15a.V_TRIGGER_AUTOSCROLL=32;
_15a.H_TRIGGER_AUTOSCROLL=32;
_15a.V_AUTOSCROLL_VALUE=16;
_15a.H_AUTOSCROLL_VALUE=16;
var _15b,doc=win.doc,_15c=Infinity,_15d=Infinity;
_15a.autoScrollStart=function(d){
doc=d;
_15b=_159.getBox(doc);
var html=win.body(doc).parentNode;
_15c=Math.max(html.scrollHeight-_15b.h,0);
_15d=Math.max(html.scrollWidth-_15b.w,0);
};
_15a.autoScroll=function(e){
var v=_15b||_159.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;
if(e.clientX<_15a.H_TRIGGER_AUTOSCROLL){
dx=-_15a.H_AUTOSCROLL_VALUE;
}else{
if(e.clientX>v.w-_15a.H_TRIGGER_AUTOSCROLL){
dx=Math.min(_15a.H_AUTOSCROLL_VALUE,_15d-html.scrollLeft);
}
}
if(e.clientY<_15a.V_TRIGGER_AUTOSCROLL){
dy=-_15a.V_AUTOSCROLL_VALUE;
}else{
if(e.clientY>v.h-_15a.V_TRIGGER_AUTOSCROLL){
dy=Math.min(_15a.V_AUTOSCROLL_VALUE,_15c-html.scrollTop);
}
}
window.scrollBy(dx,dy);
};
_15a._validNodes={"div":1,"p":1,"td":1};
_15a._validOverflow={"auto":1,"scroll":1};
_15a.autoScrollNodes=function(e){
var b,t,w,h,rx,ry,dx=0,dy=0,_15e,_15f;
for(var n=e.target;n;){
if(n.nodeType==1&&(n.tagName.toLowerCase() in _15a._validNodes)){
var s=_158.getComputedStyle(n),_160=(s.overflow.toLowerCase() in _15a._validOverflow),_161=(s.overflowX.toLowerCase() in _15a._validOverflow),_162=(s.overflowY.toLowerCase() in _15a._validOverflow);
if(_160||_161||_162){
b=_157.getContentBox(n,s);
t=_157.position(n,true);
}
if(_160||_161){
w=Math.min(_15a.H_TRIGGER_AUTOSCROLL,b.w/2);
rx=e.pageX-t.x;
if(has("webkit")||has("opera")){
rx+=win.body().scrollLeft;
}
dx=0;
if(rx>0&&rx<b.w){
if(rx<w){
dx=-w;
}else{
if(rx>b.w-w){
dx=w;
}
}
_15e=n.scrollLeft;
n.scrollLeft=n.scrollLeft+dx;
}
}
if(_160||_162){
h=Math.min(_15a.V_TRIGGER_AUTOSCROLL,b.h/2);
ry=e.pageY-t.y;
if(has("webkit")||has("opera")){
ry+=win.body().scrollTop;
}
dy=0;
if(ry>0&&ry<b.h){
if(ry<h){
dy=-h;
}else{
if(ry>b.h-h){
dy=h;
}
}
_15f=n.scrollTop;
n.scrollTop=n.scrollTop+dy;
}
}
if(dx||dy){
return;
}
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
_15a.autoScroll(e);
};
return _15a;
});
},"dojox/grid/_View":function(){
define(["dojo","dijit/registry","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/connect","dojo/_base/sniff","dojo/query","dojo/_base/window","dojo/text!./resources/View.html","dojo/dnd/Source","dijit/_Widget","dijit/_TemplatedMixin","dojox/html/metrics","./util","dojo/_base/html","./_Builder","dojo/dnd/Avatar","dojo/dnd/Manager"],function(dojo,_163,_164,_165,_166,lang,_167,has,_168,win,_169,_16a,_16b,_16c,_16d,util,html,_16e,_16f,_170){
var _171=function(_172,_173){
return _172.style.cssText==undefined?_172.getAttribute("style"):_172.style.cssText;
};
var _174=_165("dojox.grid._View",[_16b,_16c],{defaultWidth:"18em",viewWidth:"",templateString:_169,classTag:"dojoxGrid",marginBottom:0,rowPad:2,_togglingColumn:-1,_headerBuilderClass:_16e._HeaderBuilder,_contentBuilderClass:_16e._ContentBuilder,postMixInProperties:function(){
this.rowNodes={};
},postCreate:function(){
this.connect(this.scrollboxNode,"onscroll","doscroll");
util.funnelEvents(this.contentNode,this,"doContentEvent",["mouseover","mouseout","click","dblclick","contextmenu","mousedown"]);
util.funnelEvents(this.headerNode,this,"doHeaderEvent",["dblclick","mouseover","mouseout","mousemove","mousedown","click","contextmenu"]);
this.content=new this._contentBuilderClass(this);
this.header=new this._headerBuilderClass(this);
if(!this.grid.isLeftToRight()){
this.headerNodeContainer.style.width="";
}
},destroy:function(){
html.destroy(this.headerNode);
delete this.headerNode;
for(var i in this.rowNodes){
this._cleanupRowWidgets(this.rowNodes[i]);
html.destroy(this.rowNodes[i]);
}
this.rowNodes={};
if(this.source){
this.source.destroy();
}
this.inherited(arguments);
},focus:function(){
if(has("ie")||has("webkit")||has("opera")){
this.hiddenFocusNode.focus();
}else{
this.scrollboxNode.focus();
}
},setStructure:function(_175){
var vs=(this.structure=_175);
if(vs.width&&!isNaN(vs.width)){
this.viewWidth=vs.width+"em";
}else{
this.viewWidth=vs.width||(vs.noscroll?"auto":this.viewWidth);
}
this._onBeforeRow=vs.onBeforeRow||function(){
};
this._onAfterRow=vs.onAfterRow||function(){
};
this.noscroll=vs.noscroll;
if(this.noscroll){
this.scrollboxNode.style.overflow="hidden";
}
this.simpleStructure=Boolean(vs.cells.length==1);
this.testFlexCells();
this.updateStructure();
},_cleanupRowWidgets:function(_176){
if(_176){
_166.forEach(_168("[widgetId]",_176).map(_163.byNode),function(w){
if(w._destroyOnRemove){
w.destroy();
delete w;
}else{
if(w.domNode&&w.domNode.parentNode){
w.domNode.parentNode.removeChild(w.domNode);
}
}
});
}
},onBeforeRow:function(_177,_178){
this._onBeforeRow(_177,_178);
if(_177>=0){
this._cleanupRowWidgets(this.getRowNode(_177));
}
},onAfterRow:function(_179,_17a,_17b){
this._onAfterRow(_179,_17a,_17b);
var g=this.grid;
_166.forEach(_168(".dojoxGridStubNode",_17b),function(n){
if(n&&n.parentNode){
var lw=n.getAttribute("linkWidget");
var _17c=window.parseInt(html.attr(n,"cellIdx"),10);
var _17d=g.getCell(_17c);
var w=_163.byId(lw);
if(w){
n.parentNode.replaceChild(w.domNode,n);
if(!w._started){
w.startup();
}
dojo.destroy(n);
}else{
n.innerHTML="";
}
}
},this);
},testFlexCells:function(){
this.flexCells=false;
for(var j=0,row;(row=this.structure.cells[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
cell.view=this;
this.flexCells=this.flexCells||cell.isFlex();
}
}
return this.flexCells;
},updateStructure:function(){
this.header.update();
this.content.update();
},getScrollbarWidth:function(){
var _17e=this.hasVScrollbar();
var _17f=html.style(this.scrollboxNode,"overflow");
if(this.noscroll||!_17f||_17f=="hidden"){
_17e=false;
}else{
if(_17f=="scroll"){
_17e=true;
}
}
return (_17e?_16d.getScrollbar().w:0);
},getColumnsWidth:function(){
var h=this.headerContentNode;
return h&&h.firstChild?(h.firstChild.offsetWidth||html.style(h.firstChild,"width")):0;
},setColumnsWidth:function(_180){
this.headerContentNode.firstChild.style.width=_180+"px";
if(this.viewWidth){
this.viewWidth=_180+"px";
}
},getWidth:function(){
return this.viewWidth||(this.getColumnsWidth()+this.getScrollbarWidth())+"px";
},getContentWidth:function(){
return Math.max(0,html._getContentBox(this.domNode).w-this.getScrollbarWidth())+"px";
},render:function(){
this.scrollboxNode.style.height="";
this.renderHeader();
if(this._togglingColumn>=0){
this.setColumnsWidth(this.getColumnsWidth()-this._togglingColumn);
this._togglingColumn=-1;
}
var _181=this.grid.layout.cells;
var _182=lang.hitch(this,function(node,_183){
!this.grid.isLeftToRight()&&(_183=!_183);
var inc=_183?-1:1;
var idx=this.header.getCellNodeIndex(node)+inc;
var cell=_181[idx];
while(cell&&cell.getHeaderNode()&&cell.getHeaderNode().style.display=="none"){
idx+=inc;
cell=_181[idx];
}
if(cell){
return cell.getHeaderNode();
}
return null;
});
if(this.grid.columnReordering&&this.simpleStructure){
if(this.source){
this.source.destroy();
}
var _184="dojoxGrid_bottomMarker";
var _185="dojoxGrid_topMarker";
if(this.bottomMarker){
html.destroy(this.bottomMarker);
}
this.bottomMarker=html.byId(_184);
if(this.topMarker){
html.destroy(this.topMarker);
}
this.topMarker=html.byId(_185);
if(!this.bottomMarker){
this.bottomMarker=html.create("div",{"id":_184,"class":"dojoxGridColPlaceBottom"},win.body());
this._hide(this.bottomMarker);
this.topMarker=html.create("div",{"id":_185,"class":"dojoxGridColPlaceTop"},win.body());
this._hide(this.topMarker);
}
this.arrowDim=html.contentBox(this.bottomMarker);
var _186=html.contentBox(this.headerContentNode.firstChild.rows[0]).h;
this.source=new _16a(this.headerContentNode.firstChild.rows[0],{horizontal:true,accept:["gridColumn_"+this.grid.id],viewIndex:this.index,generateText:false,onMouseDown:lang.hitch(this,function(e){
this.header.decorateEvent(e);
if((this.header.overRightResizeArea(e)||this.header.overLeftResizeArea(e))&&this.header.canResize(e)&&!this.header.moveable){
this.header.beginColumnResize(e);
}else{
if(this.grid.headerMenu){
this.grid.headerMenu.onCancel(true);
}
if(e.button===(has("ie")<9?1:0)){
_16a.prototype.onMouseDown.call(this.source,e);
}
}
}),onMouseOver:lang.hitch(this,function(e){
var src=this.source;
if(src._getChildByEvent(e)){
_16a.prototype.onMouseOver.apply(src,arguments);
}
}),_markTargetAnchor:lang.hitch(this,function(_187){
var src=this.source;
if(src.current==src.targetAnchor&&src.before==_187){
return;
}
if(src.targetAnchor&&_182(src.targetAnchor,src.before)){
src._removeItemClass(_182(src.targetAnchor,src.before),src.before?"After":"Before");
}
_16a.prototype._markTargetAnchor.call(src,_187);
var _188=_187?src.targetAnchor:_182(src.targetAnchor,src.before);
var _189=0;
if(!_188){
_188=src.targetAnchor;
_189=html.contentBox(_188).w+this.arrowDim.w/2+2;
}
var pos=html.position(_188,true);
var left=Math.floor(pos.x-this.arrowDim.w/2+_189);
html.style(this.bottomMarker,"visibility","visible");
html.style(this.topMarker,"visibility","visible");
html.style(this.bottomMarker,{"left":left+"px","top":(_186+pos.y)+"px"});
html.style(this.topMarker,{"left":left+"px","top":(pos.y-this.arrowDim.h)+"px"});
if(src.targetAnchor&&_182(src.targetAnchor,src.before)){
src._addItemClass(_182(src.targetAnchor,src.before),src.before?"After":"Before");
}
}),_unmarkTargetAnchor:lang.hitch(this,function(){
var src=this.source;
if(!src.targetAnchor){
return;
}
if(src.targetAnchor&&_182(src.targetAnchor,src.before)){
src._removeItemClass(_182(src.targetAnchor,src.before),src.before?"After":"Before");
}
this._hide(this.bottomMarker);
this._hide(this.topMarker);
_16a.prototype._unmarkTargetAnchor.call(src);
}),destroy:lang.hitch(this,function(){
_167.disconnect(this._source_conn);
_167.unsubscribe(this._source_sub);
_16a.prototype.destroy.call(this.source);
if(this.bottomMarker){
html.destroy(this.bottomMarker);
delete this.bottomMarker;
}
if(this.topMarker){
html.destroy(this.topMarker);
delete this.topMarker;
}
}),onDndCancel:lang.hitch(this,function(){
_16a.prototype.onDndCancel.call(this.source);
this._hide(this.bottomMarker);
this._hide(this.topMarker);
})});
this._source_conn=_167.connect(this.source,"onDndDrop",this,"_onDndDrop");
this._source_sub=_167.subscribe("/dnd/drop/before",this,"_onDndDropBefore");
this.source.startup();
}
},_hide:function(node){
html.style(node,{top:"-10000px","visibility":"hidden"});
},_onDndDropBefore:function(_18a,_18b,copy){
if(_170.manager().target!==this.source){
return;
}
this.source._targetNode=this.source.targetAnchor;
this.source._beforeTarget=this.source.before;
var _18c=this.grid.views.views;
var _18d=_18c[_18a.viewIndex];
var _18e=_18c[this.index];
if(_18e!=_18d){
_18d.convertColPctToFixed();
_18e.convertColPctToFixed();
}
},_onDndDrop:function(_18f,_190,copy){
if(_170.manager().target!==this.source){
if(_170.manager().source===this.source){
this._removingColumn=true;
}
return;
}
this._hide(this.bottomMarker);
this._hide(this.topMarker);
var _191=function(n){
return n?html.attr(n,"idx"):null;
};
var w=html.marginBox(_190[0]).w;
if(_18f.viewIndex!==this.index){
var _192=this.grid.views.views;
var _193=_192[_18f.viewIndex];
var _194=_192[this.index];
if(_193.viewWidth&&_193.viewWidth!="auto"){
_193.setColumnsWidth(_193.getColumnsWidth()-w);
}
if(_194.viewWidth&&_194.viewWidth!="auto"){
_194.setColumnsWidth(_194.getColumnsWidth());
}
}
var stn=this.source._targetNode;
var stb=this.source._beforeTarget;
!this.grid.isLeftToRight()&&(stb=!stb);
var _195=this.grid.layout;
var idx=this.index;
delete this.source._targetNode;
delete this.source._beforeTarget;
_195.moveColumn(_18f.viewIndex,idx,_191(_190[0]),_191(stn),stb);
},renderHeader:function(){
this.headerContentNode.innerHTML=this.header.generateHtml(this._getHeaderContent);
if(this.flexCells){
this.contentWidth=this.getContentWidth();
this.headerContentNode.firstChild.style.width=this.contentWidth;
}
util.fire(this,"onAfterRow",[-1,this.structure.cells,this.headerContentNode]);
},_getHeaderContent:function(_196){
var n=_196.name||_196.grid.getCellName(_196);
if(/^\s+$/.test(n)){
n="&nbsp;";
}
var ret=["<div class=\"dojoxGridSortNode"];
if(_196.index!=_196.grid.getSortIndex()){
ret.push("\">");
}else{
ret=ret.concat([" ",_196.grid.sortInfo>0?"dojoxGridSortUp":"dojoxGridSortDown","\"><div class=\"dojoxGridArrowButtonChar\">",_196.grid.sortInfo>0?"&#9650;":"&#9660;","</div><div class=\"dojoxGridArrowButtonNode\" role=\"presentation\"></div>","<div class=\"dojoxGridColCaption\">"]);
}
ret=ret.concat([n,"</div></div>"]);
return ret.join("");
},resize:function(){
this.adaptHeight();
this.adaptWidth();
},hasHScrollbar:function(_197){
var _198=this._hasHScroll||false;
if(this._hasHScroll==undefined||_197){
if(this.noscroll){
this._hasHScroll=false;
}else{
var _199=html.style(this.scrollboxNode,"overflow");
if(_199=="hidden"){
this._hasHScroll=false;
}else{
if(_199=="scroll"){
this._hasHScroll=true;
}else{
this._hasHScroll=(this.scrollboxNode.offsetWidth-this.getScrollbarWidth()<this.contentNode.offsetWidth);
}
}
}
}
if(_198!==this._hasHScroll){
this.grid.update();
}
return this._hasHScroll;
},hasVScrollbar:function(_19a){
var _19b=this._hasVScroll||false;
if(this._hasVScroll==undefined||_19a){
if(this.noscroll){
this._hasVScroll=false;
}else{
var _19c=html.style(this.scrollboxNode,"overflow");
if(_19c=="hidden"){
this._hasVScroll=false;
}else{
if(_19c=="scroll"){
this._hasVScroll=true;
}else{
this._hasVScroll=(this.scrollboxNode.scrollHeight>this.scrollboxNode.clientHeight);
}
}
}
}
if(_19b!==this._hasVScroll){
this.grid.update();
}
return this._hasVScroll;
},convertColPctToFixed:function(){
var _19d=false;
this.grid.initialWidth="";
var _19e=_168("th",this.headerContentNode);
var _19f=_166.map(_19e,function(c,vIdx){
var w=c.style.width;
html.attr(c,"vIdx",vIdx);
if(w&&w.slice(-1)=="%"){
_19d=true;
}else{
if(w&&w.slice(-2)=="px"){
return window.parseInt(w,10);
}
}
return html.contentBox(c).w;
});
if(_19d){
_166.forEach(this.grid.layout.cells,function(cell,idx){
if(cell.view==this){
var _1a0=cell.view.getHeaderCellNode(cell.index);
if(_1a0&&html.hasAttr(_1a0,"vIdx")){
var vIdx=window.parseInt(html.attr(_1a0,"vIdx"));
this.setColWidth(idx,_19f[vIdx]);
html.removeAttr(_1a0,"vIdx");
}
}
},this);
return true;
}
return false;
},adaptHeight:function(_1a1){
if(!this.grid._autoHeight){
var h=(this.domNode.style.height&&parseInt(this.domNode.style.height.replace(/px/,""),10))||this.domNode.clientHeight;
var self=this;
var _1a2=function(){
var v;
for(var i in self.grid.views.views){
v=self.grid.views.views[i];
if(v!==self&&v.hasHScrollbar()){
return true;
}
}
return false;
};
if(_1a1||(this.noscroll&&_1a2())){
h-=_16d.getScrollbar().h;
}
util.setStyleHeightPx(this.scrollboxNode,h);
}
this.hasVScrollbar(true);
},adaptWidth:function(){
if(this.flexCells){
this.contentWidth=this.getContentWidth();
this.headerContentNode.firstChild.style.width=this.contentWidth;
}
var w=this.scrollboxNode.offsetWidth-this.getScrollbarWidth();
if(!this._removingColumn){
w=Math.max(w,this.getColumnsWidth())+"px";
}else{
w=Math.min(w,this.getColumnsWidth())+"px";
this._removingColumn=false;
}
var cn=this.contentNode;
cn.style.width=w;
this.hasHScrollbar(true);
},setSize:function(w,h){
var ds=this.domNode.style;
var hs=this.headerNode.style;
if(w){
ds.width=w;
hs.width=w;
}
ds.height=(h>=0?h+"px":"");
},renderRow:function(_1a3){
var _1a4=this.createRowNode(_1a3);
this.buildRow(_1a3,_1a4);
return _1a4;
},createRowNode:function(_1a5){
var node=document.createElement("div");
node.className=this.classTag+"Row";
if(this instanceof _164.grid._RowSelector){
html.attr(node,"role","presentation");
}else{
html.attr(node,"role","row");
if(this.grid.selectionMode!="none"){
node.setAttribute("aria-selected","false");
}
}
node[util.gridViewTag]=this.id;
node[util.rowIndexTag]=_1a5;
this.rowNodes[_1a5]=node;
return node;
},buildRow:function(_1a6,_1a7){
this.buildRowContent(_1a6,_1a7);
this.styleRow(_1a6,_1a7);
},buildRowContent:function(_1a8,_1a9){
_1a9.innerHTML=this.content.generateHtml(_1a8,_1a8);
if(this.flexCells&&this.contentWidth){
_1a9.firstChild.style.width=this.contentWidth;
}
util.fire(this,"onAfterRow",[_1a8,this.structure.cells,_1a9]);
},rowRemoved:function(_1aa){
if(_1aa>=0){
this._cleanupRowWidgets(this.getRowNode(_1aa));
}
this.grid.edit.save(this,_1aa);
delete this.rowNodes[_1aa];
},getRowNode:function(_1ab){
return this.rowNodes[_1ab];
},getCellNode:function(_1ac,_1ad){
var row=this.getRowNode(_1ac);
if(row){
return this.content.getCellNode(row,_1ad);
}
},getHeaderCellNode:function(_1ae){
if(this.headerContentNode){
return this.header.getCellNode(this.headerContentNode,_1ae);
}
},styleRow:function(_1af,_1b0){
_1b0._style=_171(_1b0);
this.styleRowNode(_1af,_1b0);
},styleRowNode:function(_1b1,_1b2){
if(_1b2){
this.doStyleRowNode(_1b1,_1b2);
}
},doStyleRowNode:function(_1b3,_1b4){
this.grid.styleRowNode(_1b3,_1b4);
},updateRow:function(_1b5){
var _1b6=this.getRowNode(_1b5);
if(_1b6){
_1b6.style.height="";
this.buildRow(_1b5,_1b6);
}
return _1b6;
},updateRowStyles:function(_1b7){
this.styleRowNode(_1b7,this.getRowNode(_1b7));
},lastTop:0,firstScroll:0,_nativeScroll:false,doscroll:function(_1b8){
if(has("ff")>=13){
this._nativeScroll=true;
}
var _1b9=this.grid.isLeftToRight();
if(this.firstScroll<2){
if((!_1b9&&this.firstScroll==1)||(_1b9&&this.firstScroll===0)){
var s=html.marginBox(this.headerNodeContainer);
if(has("ie")){
this.headerNodeContainer.style.width=s.w+this.getScrollbarWidth()+"px";
}else{
if(has("mozilla")){
this.headerNodeContainer.style.width=s.w-this.getScrollbarWidth()+"px";
this.scrollboxNode.scrollLeft=_1b9?this.scrollboxNode.clientWidth-this.scrollboxNode.scrollWidth:this.scrollboxNode.scrollWidth-this.scrollboxNode.clientWidth;
}
}
}
this.firstScroll++;
}
this.headerNode.scrollLeft=this.scrollboxNode.scrollLeft;
var top=this.scrollboxNode.scrollTop;
if(top!==this.lastTop){
this.grid.scrollTo(top);
}
this._nativeScroll=false;
},setScrollTop:function(_1ba){
this.lastTop=_1ba;
if(!this._nativeScroll){
this.scrollboxNode.scrollTop=_1ba;
}
return this.scrollboxNode.scrollTop;
},doContentEvent:function(e){
if(this.content.decorateEvent(e)){
this.grid.onContentEvent(e);
}
},doHeaderEvent:function(e){
if(this.header.decorateEvent(e)){
this.grid.onHeaderEvent(e);
}
},dispatchContentEvent:function(e){
return this.content.dispatchEvent(e);
},dispatchHeaderEvent:function(e){
return this.header.dispatchEvent(e);
},setColWidth:function(_1bb,_1bc){
this.grid.setCellWidth(_1bb,_1bc+"px");
},update:function(){
if(!this.domNode){
return;
}
this.content.update();
this.grid.update();
var left=this.scrollboxNode.scrollLeft;
this.scrollboxNode.scrollLeft=left;
this.headerNode.scrollLeft=left;
}});
var _1bd=_165("dojox.grid._GridAvatar",_16f,{construct:function(){
var dd=win.doc;
var a=dd.createElement("table");
a.cellPadding=a.cellSpacing="0";
a.className="dojoxGridDndAvatar";
a.style.position="absolute";
a.style.zIndex=1999;
a.style.margin="0px";
var b=dd.createElement("tbody");
var tr=dd.createElement("tr");
var td=dd.createElement("td");
var img=dd.createElement("td");
tr.className="dojoxGridDndAvatarItem";
img.className="dojoxGridDndAvatarItemImage";
img.style.width="16px";
var _1be=this.manager.source,node;
if(_1be.creator){
node=_1be._normalizedCreator(_1be.getItem(this.manager.nodes[0].id).data,"avatar").node;
}else{
node=this.manager.nodes[0].cloneNode(true);
var _1bf,_1c0;
if(node.tagName.toLowerCase()=="tr"){
_1bf=dd.createElement("table");
_1c0=dd.createElement("tbody");
_1c0.appendChild(node);
_1bf.appendChild(_1c0);
node=_1bf;
}else{
if(node.tagName.toLowerCase()=="th"){
_1bf=dd.createElement("table");
_1c0=dd.createElement("tbody");
var r=dd.createElement("tr");
_1bf.cellPadding=_1bf.cellSpacing="0";
r.appendChild(node);
_1c0.appendChild(r);
_1bf.appendChild(_1c0);
node=_1bf;
}
}
}
node.id="";
td.appendChild(node);
tr.appendChild(img);
tr.appendChild(td);
html.style(tr,"opacity",0.9);
b.appendChild(tr);
a.appendChild(b);
this.node=a;
var m=_170.manager();
this.oldOffsetY=m.OFFSET_Y;
m.OFFSET_Y=1;
},destroy:function(){
_170.manager().OFFSET_Y=this.oldOffsetY;
this.inherited(arguments);
}});
var _1c1=_170.manager().makeAvatar;
_170.manager().makeAvatar=function(){
var src=this.source;
if(src.viewIndex!==undefined&&!html.hasClass(win.body(),"dijit_a11y")){
return new _1bd(this);
}
return _1c1.call(_170.manager());
};
return _174;
});
},"dijit/CheckedMenuItem":function(){
define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_1c2,_1c3,_1c4,_1c5){
return _1c2("dijit.CheckedMenuItem",_1c4,{templateString:_1c5,checked:false,_setCheckedAttr:function(_1c6){
_1c3.toggle(this.domNode,"dijitCheckedMenuItemChecked",_1c6);
this.domNode.setAttribute("aria-checked",_1c6?"true":"false");
this._set("checked",_1c6);
},iconClass:"",onChange:function(){
},_onClick:function(evt){
if(!this.disabled){
this.set("checked",!this.checked);
this.onChange(this.checked);
}
this.onClick(evt);
}});
});
},"dojo/hccss":function(){
define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_1c7,_1c8,_1c9,_1ca,has,_1cb,win){
has.add("highcontrast",function(){
var div=win.doc.createElement("div");
div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_1c8.blankGif||_1c7.toUrl("./resources/blank.gif"))+");";
win.body().appendChild(div);
var cs=_1ca.getComputedStyle(div),_1cc=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_1cc&&(_1cc=="none"||_1cc=="url(invalid-url:)"));
if(has("ie")<=8){
div.outerHTML="";
}else{
win.body().removeChild(div);
}
return hc;
});
_1cb(90,function(){
if(has("highcontrast")){
_1c9.add(win.body(),"dj_a11y");
}
});
return has;
});
},"dijit/_WidgetBase":function(){
define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_1cd,_1ce,_1cf,_1d0,_1d1,_1d2,dom,_1d3,_1d4,_1d5,_1d6,_1d7,has,_1d8,lang,on,_1d9,_1da,_1db,win,_1dc,_1dd){
has.add("dijit-legacy-requires",!_1d8.isAsync);
if(has("dijit-legacy-requires")){
_1d9(0,function(){
var _1de=["dijit/_base/manager"];
_1cd(_1de);
});
}
var _1df={};
function _1e0(obj){
var ret={};
for(var attr in obj){
ret[attr.toLowerCase()]=true;
}
return ret;
};
function _1e1(attr){
return function(val){
_1d3[val?"set":"remove"](this.domNode,attr,val);
this._set(attr,val);
};
};
return _1d2("dijit._WidgetBase",[_1da,_1dc],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_1e1("lang"),dir:"",_setDirAttr:_1e1("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){
this._set("ownerDocument",val);
},attributeMap:{},_blankGif:_1d0.blankGif||_1cd.toUrl("dojo/resources/blank.gif"),postscript:function(_1e2,_1e3){
this.create(_1e2,_1e3);
},create:function(_1e4,_1e5){
this.srcNodeRef=dom.byId(_1e5);
this._connects=[];
this._supportingWidgets=[];
if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){
this.id=this.srcNodeRef.id;
}
if(_1e4){
this.params=_1e4;
lang.mixin(this,_1e4);
}
this.postMixInProperties();
if(!this.id){
this.id=_1dd.getUniqueId(this.declaredClass.replace(/\./g,"_"));
if(this.params){
delete this.params.id;
}
}
this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);
this.ownerDocumentBody=win.body(this.ownerDocument);
_1dd.add(this);
this.buildRendering();
var _1e6;
if(this.domNode){
this._applyAttributes();
var _1e7=this.srcNodeRef;
if(_1e7&&_1e7.parentNode&&this.domNode!==_1e7){
_1e7.parentNode.replaceChild(this.domNode,_1e7);
_1e6=true;
}
this.domNode.setAttribute("widgetId",this.id);
}
this.postCreate();
if(_1e6){
delete this.srcNodeRef;
}
this._created=true;
},_applyAttributes:function(){
var ctor=this.constructor,list=ctor._setterAttrs;
if(!list){
list=(ctor._setterAttrs=[]);
for(var attr in this.attributeMap){
list.push(attr);
}
var _1e8=ctor.prototype;
for(var _1e9 in _1e8){
if(_1e9 in this.attributeMap){
continue;
}
var _1ea="_set"+_1e9.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
})+"Attr";
if(_1ea in _1e8){
list.push(_1e9);
}
}
}
var _1eb={};
for(var key in this.params||{}){
_1eb[key]=this[key];
}
_1ce.forEach(list,function(attr){
if(attr in _1eb){
}else{
if(this[attr]){
this.set(attr,this[attr]);
}
}
},this);
for(key in _1eb){
this.set(key,_1eb[key]);
}
},postMixInProperties:function(){
},buildRendering:function(){
if(!this.domNode){
this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");
}
if(this.baseClass){
var _1ec=this.baseClass.split(" ");
if(!this.isLeftToRight()){
_1ec=_1ec.concat(_1ce.map(_1ec,function(name){
return name+"Rtl";
}));
}
_1d4.add(this.domNode,_1ec);
}
},postCreate:function(){
},startup:function(){
if(this._started){
return;
}
this._started=true;
_1ce.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
},destroyRecursive:function(_1ed){
this._beingDestroyed=true;
this.destroyDescendants(_1ed);
this.destroy(_1ed);
},destroy:function(_1ee){
this._beingDestroyed=true;
this.uninitialize();
function _1ef(w){
if(w.destroyRecursive){
w.destroyRecursive(_1ee);
}else{
if(w.destroy){
w.destroy(_1ee);
}
}
};
_1ce.forEach(this._connects,lang.hitch(this,"disconnect"));
_1ce.forEach(this._supportingWidgets,_1ef);
if(this.domNode){
_1ce.forEach(_1dd.findWidgets(this.domNode,this.containerNode),_1ef);
}
this.destroyRendering(_1ee);
_1dd.remove(this.id);
this._destroyed=true;
},destroyRendering:function(_1f0){
if(this.bgIframe){
this.bgIframe.destroy(_1f0);
delete this.bgIframe;
}
if(this.domNode){
if(_1f0){
_1d3.remove(this.domNode,"widgetId");
}else{
_1d5.destroy(this.domNode);
}
delete this.domNode;
}
if(this.srcNodeRef){
if(!_1f0){
_1d5.destroy(this.srcNodeRef);
}
delete this.srcNodeRef;
}
},destroyDescendants:function(_1f1){
_1ce.forEach(this.getChildren(),function(_1f2){
if(_1f2.destroyRecursive){
_1f2.destroyRecursive(_1f1);
}
});
},uninitialize:function(){
return false;
},_setStyleAttr:function(_1f3){
var _1f4=this.domNode;
if(lang.isObject(_1f3)){
_1d7.set(_1f4,_1f3);
}else{
if(_1f4.style.cssText){
_1f4.style.cssText+="; "+_1f3;
}else{
_1f4.style.cssText=_1f3;
}
}
this._set("style",_1f3);
},_attrToDom:function(attr,_1f5,_1f6){
_1f6=arguments.length>=3?_1f6:this.attributeMap[attr];
_1ce.forEach(lang.isArray(_1f6)?_1f6:[_1f6],function(_1f7){
var _1f8=this[_1f7.node||_1f7||"domNode"];
var type=_1f7.type||"attribute";
switch(type){
case "attribute":
if(lang.isFunction(_1f5)){
_1f5=lang.hitch(this,_1f5);
}
var _1f9=_1f7.attribute?_1f7.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);
if(_1f8.tagName){
_1d3.set(_1f8,_1f9,_1f5);
}else{
_1f8.set(_1f9,_1f5);
}
break;
case "innerText":
_1f8.innerHTML="";
_1f8.appendChild(this.ownerDocument.createTextNode(_1f5));
break;
case "innerHTML":
_1f8.innerHTML=_1f5;
break;
case "class":
_1d4.replace(_1f8,_1f5,this[attr]);
break;
}
},this);
},get:function(name){
var _1fa=this._getAttrNames(name);
return this[_1fa.g]?this[_1fa.g]():this[name];
},set:function(name,_1fb){
if(typeof name==="object"){
for(var x in name){
this.set(x,name[x]);
}
return this;
}
var _1fc=this._getAttrNames(name),_1fd=this[_1fc.s];
if(lang.isFunction(_1fd)){
var _1fe=_1fd.apply(this,Array.prototype.slice.call(arguments,1));
}else{
var _1ff=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_1ff].tagName,_200=_1df[tag]||(_1df[tag]=_1e0(this[_1ff])),map=name in this.attributeMap?this.attributeMap[name]:_1fc.s in this?this[_1fc.s]:((_1fc.l in _200&&typeof _1fb!="function")||/^aria-|^data-|^role$/.test(name))?_1ff:null;
if(map!=null){
this._attrToDom(name,_1fb,map);
}
this._set(name,_1fb);
}
return _1fe||this;
},_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
});
return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});
},_set:function(name,_201){
var _202=this[name];
this[name]=_201;
if(this._created&&_201!==_202){
if(this._watchCallbacks){
this._watchCallbacks(name,_202,_201);
}
this.emit("attrmodified-"+name,{detail:{prevValue:_202,newValue:_201}});
}
},emit:function(type,_203,_204){
_203=_203||{};
if(_203.bubbles===undefined){
_203.bubbles=true;
}
if(_203.cancelable===undefined){
_203.cancelable=true;
}
if(!_203.detail){
_203.detail={};
}
_203.detail.widget=this;
var ret,_205=this["on"+type];
if(_205){
ret=_205.apply(this,_204?_204:[_203]);
}
if(this._started&&!this._beingDestroyed){
on.emit(this.domNode,type.toLowerCase(),_203);
}
return ret;
},on:function(type,func){
var _206=this._onMap(type);
if(_206){
return _1cf.after(this,_206,func,true);
}
return this.own(on(this.domNode,type,func))[0];
},_onMap:function(type){
var ctor=this.constructor,map=ctor._onMap;
if(!map){
map=(ctor._onMap={});
for(var attr in ctor.prototype){
if(/^on/.test(attr)){
map[attr.replace(/^on/,"").toLowerCase()]=attr;
}
}
}
return map[typeof type=="string"&&type.toLowerCase()];
},toString:function(){
return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";
},getChildren:function(){
return this.containerNode?_1dd.findWidgets(this.containerNode):[];
},getParent:function(){
return _1dd.getEnclosingWidget(this.domNode.parentNode);
},connect:function(obj,_207,_208){
return this.own(_1d1.connect(obj,_207,this,_208))[0];
},disconnect:function(_209){
_209.remove();
},subscribe:function(t,_20a){
return this.own(_1db.subscribe(t,lang.hitch(this,_20a)))[0];
},unsubscribe:function(_20b){
_20b.remove();
},isLeftToRight:function(){
return this.dir?(this.dir=="ltr"):_1d6.isBodyLtr(this.ownerDocument);
},isFocusable:function(){
return this.focus&&(_1d7.get(this.domNode,"display")!="none");
},placeAt:function(_20c,_20d){
var _20e=!_20c.tagName&&_1dd.byId(_20c);
if(_20e&&_20e.addChild&&(!_20d||typeof _20d==="number")){
_20e.addChild(this,_20d);
}else{
var ref=_20e?(_20e.containerNode&&!/after|before|replace/.test(_20d||"")?_20e.containerNode:_20e.domNode):dom.byId(_20c,this.ownerDocument);
_1d5.place(this.domNode,ref,_20d);
if(!this._started&&(this.getParent()||{})._started){
this.startup();
}
}
return this;
},getTextDir:function(text,_20f){
return _20f;
},applyTextDir:function(){
},defer:function(fcn,_210){
var _211=setTimeout(lang.hitch(this,function(){
_211=null;
if(!this._destroyed){
lang.hitch(this,fcn)();
}
}),_210||0);
return {remove:function(){
if(_211){
clearTimeout(_211);
_211=null;
}
return null;
}};
}});
});
},"dojo/dnd/common":function(){
define(["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_212,_213,lang,dom){
var _214=lang.getObject("dojo.dnd",true);
_214.getCopyKeyState=_212.isCopyKey;
_214._uniqueId=0;
_214.getUniqueId=function(){
var id;
do{
id=_213._scopeName+"Unique"+(++_214._uniqueId);
}while(dom.byId(id));
return id;
};
_214._empty={};
_214.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _214;
});
},"dojox/main":function(){
define("dojox/main",["dojo/_base/kernel"],function(dojo){
return dojo.dojox;
});
},"dojo/touch":function(){
define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./ready","./_base/window"],function(dojo,_215,dom,on,has,_216,_217,win){
var _218=has("touch");
var ios4=false;
if(has("ios")){
var ua=navigator.userAgent;
var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";
var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));
ios4=os<5;
}
var _219,_21a;
if(_218){
_217(function(){
_21a=win.body();
win.doc.addEventListener("touchstart",function(evt){
var _21b=_21a;
_21a=evt.target;
on.emit(_21b,"dojotouchout",{target:_21b,relatedTarget:_21a,bubbles:true});
on.emit(_21a,"dojotouchover",{target:_21a,relatedTarget:_21b,bubbles:true});
},true);
on(win.doc,"touchmove",function(evt){
var _21c=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));
if(_21c&&_21a!==_21c){
on.emit(_21a,"dojotouchout",{target:_21a,relatedTarget:_21c,bubbles:true});
on.emit(_21c,"dojotouchover",{target:_21c,relatedTarget:_21a,bubbles:true});
_21a=_21c;
}
});
});
_219=function(node,_21d){
return on(win.doc,"touchmove",function(evt){
if(node===win.doc||dom.isDescendant(_21a,node)){
evt.target=_21a;
_21d.call(this,evt);
}
});
};
}
function _21e(type){
return function(node,_21f){
return on(node,type,_21f);
};
};
var _220={press:_21e(_218?"touchstart":"mousedown"),move:_218?_219:_21e("mousemove"),release:_21e(_218?"touchend":"mouseup"),cancel:_218?_21e("touchcancel"):_216.leave,over:_21e(_218?"dojotouchover":"mouseover"),out:_21e(_218?"dojotouchout":"mouseout"),enter:_216._eventHandler(_218?"dojotouchover":"mouseover"),leave:_216._eventHandler(_218?"dojotouchout":"mouseout")};
1&&(dojo.touch=_220);
return _220;
});
},"dojox/grid/cells/_base":function(){
define("dojox/grid/cells/_base",["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/event","dojo/_base/connect","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dijit/_Widget","../util"],function(dojo,_221,lang,_222,_223,_224,has,dom,_225,_226,_227,util){
var _228=_221("dojox.grid._DeferredTextWidget",_227,{deferred:null,_destroyOnRemove:true,postCreate:function(){
if(this.deferred){
this.deferred.addBoth(lang.hitch(this,function(text){
if(this.domNode){
this.domNode.innerHTML=text;
}
}));
}
}});
var _229=function(_22a){
try{
util.fire(_22a,"focus");
util.fire(_22a,"select");
}
catch(e){
}
};
var _22b=function(){
setTimeout(lang.hitch.apply(dojo,arguments),0);
};
var _22c=_221("dojox.grid.cells._Base",null,{styles:"",classes:"",editable:false,alwaysEditing:false,formatter:null,defaultValue:"...",value:null,hidden:false,noresize:false,draggable:true,_valueProp:"value",_formatPending:false,constructor:function(_22d){
this._props=_22d||{};
lang.mixin(this,_22d);
if(this.draggable===undefined){
this.draggable=true;
}
},_defaultFormat:function(_22e,_22f){
var s=this.grid.formatterScope||this;
var f=this.formatter;
if(f&&s&&typeof f=="string"){
f=this.formatter=s[f];
}
var v=(_22e!=this.defaultValue&&f)?f.apply(s,_22f):_22e;
if(typeof v=="undefined"){
return this.defaultValue;
}
if(v&&v.addBoth){
v=new _228({deferred:v},_226.create("span",{innerHTML:this.defaultValue}));
}
if(v&&v.declaredClass&&v.startup){
return "<div class='dojoxGridStubNode' linkWidget='"+v.id+"' cellIdx='"+this.index+"'>"+this.defaultValue+"</div>";
}
return v;
},format:function(_230,_231){
var f,i=this.grid.edit.info,d=this.get?this.get(_230,_231):(this.value||this.defaultValue);
d=(d&&d.replace&&this.grid.escapeHTMLInData)?d.replace(/&/g,"&amp;").replace(/</g,"&lt;"):d;
if(this.editable&&(this.alwaysEditing||(i.rowIndex==_230&&i.cell==this))){
return this.formatEditing(d,_230);
}else{
return this._defaultFormat(d,[d,_230,this]);
}
},formatEditing:function(_232,_233){
},getNode:function(_234){
return this.view.getCellNode(_234,this.index);
},getHeaderNode:function(){
return this.view.getHeaderCellNode(this.index);
},getEditNode:function(_235){
return (this.getNode(_235)||0).firstChild||0;
},canResize:function(){
var uw=this.unitWidth;
return uw&&(uw!=="auto");
},isFlex:function(){
var uw=this.unitWidth;
return uw&&lang.isString(uw)&&(uw=="auto"||uw.slice(-1)=="%");
},applyEdit:function(_236,_237){
if(this.getNode(_237)){
this.grid.edit.applyCellEdit(_236,this,_237);
}
},cancelEdit:function(_238){
this.grid.doCancelEdit(_238);
},_onEditBlur:function(_239){
if(this.grid.edit.isEditCell(_239,this.index)){
this.grid.edit.apply();
}
},registerOnBlur:function(_23a,_23b){
if(this.commitOnBlur){
_223.connect(_23a,"onblur",function(e){
setTimeout(lang.hitch(this,"_onEditBlur",_23b),250);
});
}
},needFormatNode:function(_23c,_23d){
this._formatPending=true;
_22b(this,"_formatNode",_23c,_23d);
},cancelFormatNode:function(){
this._formatPending=false;
},_formatNode:function(_23e,_23f){
if(this._formatPending){
this._formatPending=false;
if(!has("ie")){
dom.setSelectable(this.grid.domNode,true);
}
this.formatNode(this.getEditNode(_23f),_23e,_23f);
}
},formatNode:function(_240,_241,_242){
if(has("ie")){
_22b(this,"focus",_242,_240);
}else{
this.focus(_242,_240);
}
},dispatchEvent:function(m,e){
if(m in this){
return this[m](e);
}
},getValue:function(_243){
return this.getEditNode(_243)[this._valueProp];
},setValue:function(_244,_245){
var n=this.getEditNode(_244);
if(n){
n[this._valueProp]=_245;
}
},focus:function(_246,_247){
_229(_247||this.getEditNode(_246));
},save:function(_248){
this.value=this.value||this.getValue(_248);
},restore:function(_249){
this.setValue(_249,this.value);
},_finish:function(_24a){
dom.setSelectable(this.grid.domNode,false);
this.cancelFormatNode();
},apply:function(_24b){
this.applyEdit(this.getValue(_24b),_24b);
this._finish(_24b);
},cancel:function(_24c){
this.cancelEdit(_24c);
this._finish(_24c);
}});
_22c.markupFactory=function(node,_24d){
var _24e=lang.trim(_225.get(node,"formatter")||"");
if(_24e){
_24d.formatter=lang.getObject(_24e)||_24e;
}
var get=lang.trim(_225.get(node,"get")||"");
if(get){
_24d.get=lang.getObject(get);
}
var _24f=function(attr,cell,_250){
var _251=lang.trim(_225.get(node,attr)||"");
if(_251){
cell[_250||attr]=!(_251.toLowerCase()=="false");
}
};
_24f("sortDesc",_24d);
_24f("editable",_24d);
_24f("alwaysEditing",_24d);
_24f("noresize",_24d);
_24f("draggable",_24d);
var _252=lang.trim(_225.get(node,"loadingText")||_225.get(node,"defaultValue")||"");
if(_252){
_24d.defaultValue=_252;
}
var _253=function(attr,cell,_254){
var _255=lang.trim(_225.get(node,attr)||"")||undefined;
if(_255){
cell[_254||attr]=_255;
}
};
_253("styles",_24d);
_253("headerStyles",_24d);
_253("cellStyles",_24d);
_253("classes",_24d);
_253("headerClasses",_24d);
_253("cellClasses",_24d);
};
var Cell=_221("dojox.grid.cells.Cell",_22c,{constructor:function(){
this.keyFilter=this.keyFilter;
},keyFilter:null,formatEditing:function(_256,_257){
this.needFormatNode(_256,_257);
return "<input class=\"dojoxGridInput\" type=\"text\" value=\""+_256+"\">";
},formatNode:function(_258,_259,_25a){
this.inherited(arguments);
this.registerOnBlur(_258,_25a);
},doKey:function(e){
if(this.keyFilter){
var key=String.fromCharCode(e.charCode);
if(key.search(this.keyFilter)==-1){
_222.stop(e);
}
}
},_finish:function(_25b){
this.inherited(arguments);
var n=this.getEditNode(_25b);
try{
util.fire(n,"blur");
}
catch(e){
}
}});
Cell.markupFactory=function(node,_25c){
_22c.markupFactory(node,_25c);
var _25d=lang.trim(_225.get(node,"keyFilter")||"");
if(_25d){
_25c.keyFilter=new RegExp(_25d);
}
};
var _25e=_221("dojox.grid.cells.RowIndex",Cell,{name:"Row",postscript:function(){
this.editable=false;
},get:function(_25f){
return _25f+1;
}});
_25e.markupFactory=function(node,_260){
Cell.markupFactory(node,_260);
};
var _261=_221("dojox.grid.cells.Select",Cell,{options:null,values:null,returnIndex:-1,constructor:function(_262){
this.values=this.values||this.options;
},formatEditing:function(_263,_264){
this.needFormatNode(_263,_264);
var h=["<select class=\"dojoxGridSelect\">"];
for(var i=0,o,v;((o=this.options[i])!==undefined)&&((v=this.values[i])!==undefined);i++){
v=v.replace?v.replace(/&/g,"&amp;").replace(/</g,"&lt;"):v;
o=o.replace?o.replace(/&/g,"&amp;").replace(/</g,"&lt;"):o;
h.push("<option",(_263==v?" selected":"")," value=\""+v+"\"",">",o,"</option>");
}
h.push("</select>");
return h.join("");
},_defaultFormat:function(_265,_266){
var v=this.inherited(arguments);
if(!this.formatter&&this.values&&this.options){
var i=_224.indexOf(this.values,v);
if(i>=0){
v=this.options[i];
}
}
return v;
},getValue:function(_267){
var n=this.getEditNode(_267);
if(n){
var i=n.selectedIndex,o=n.options[i];
return this.returnIndex>-1?i:o.value||o.innerHTML;
}
}});
_261.markupFactory=function(node,cell){
Cell.markupFactory(node,cell);
var _268=lang.trim(_225.get(node,"options")||"");
if(_268){
var o=_268.split(",");
if(o[0]!=_268){
cell.options=o;
}
}
var _269=lang.trim(_225.get(node,"values")||"");
if(_269){
var v=_269.split(",");
if(v[0]!=_269){
cell.values=v;
}
}
};
var _26a=_221("dojox.grid.cells.AlwaysEdit",Cell,{alwaysEditing:true,_formatNode:function(_26b,_26c){
this.formatNode(this.getEditNode(_26c),_26b,_26c);
},applyStaticValue:function(_26d){
var e=this.grid.edit;
e.applyCellEdit(this.getValue(_26d),this,_26d);
e.start(this,_26d,true);
}});
_26a.markupFactory=function(node,cell){
Cell.markupFactory(node,cell);
};
var Bool=_221("dojox.grid.cells.Bool",_26a,{_valueProp:"checked",formatEditing:function(_26e,_26f){
return "<input class=\"dojoxGridInput\" type=\"checkbox\""+(_26e?" checked=\"checked\"":"")+" style=\"width: auto\" />";
},doclick:function(e){
if(e.target.tagName=="INPUT"){
this.applyStaticValue(e.rowIndex);
}
}});
Bool.markupFactory=function(node,cell){
_26a.markupFactory(node,cell);
};
return _22c;
});
},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" role=\"presentation\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" role=\"presentation\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","dojo/Stateful":function(){
define(["./_base/declare","./_base/lang","./_base/array","dojo/when"],function(_270,lang,_271,when){
return _270("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});
},postscript:function(_272){
if(_272){
this.set(_272);
}
},_get:function(name,_273){
return typeof this[_273.g]==="function"?this[_273.g]():this[name];
},get:function(name){
return this._get(name,this._getAttrNames(name));
},set:function(name,_274){
if(typeof name==="object"){
for(var x in name){
if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){
this.set(x,name[x]);
}
}
return this;
}
var _275=this._getAttrNames(name),_276=this._get(name,_275),_277=this[_275.s],_278;
if(typeof _277==="function"){
_278=_277.apply(this,Array.prototype.slice.call(arguments,1));
}else{
this[name]=_274;
}
if(this._watchCallbacks){
var self=this;
when(_278,function(){
self._watchCallbacks(name,_276,_274);
});
}
return this;
},_changeAttrValue:function(name,_279){
var _27a=this.get(name);
this[name]=_279;
if(this._watchCallbacks){
this._watchCallbacks(name,_27a,_279);
}
return this;
},watch:function(name,_27b){
var _27c=this._watchCallbacks;
if(!_27c){
var self=this;
_27c=this._watchCallbacks=function(name,_27d,_27e,_27f){
var _280=function(_281){
if(_281){
_281=_281.slice();
for(var i=0,l=_281.length;i<l;i++){
_281[i].call(self,name,_27d,_27e);
}
}
};
_280(_27c["_"+name]);
if(!_27f){
_280(_27c["*"]);
}
};
}
if(!_27b&&typeof name==="function"){
_27b=name;
name="*";
}else{
name="_"+name;
}
var _282=_27c[name];
if(typeof _282!=="object"){
_282=_27c[name]=[];
}
_282.push(_27b);
var _283={};
_283.unwatch=_283.remove=function(){
var _284=_271.indexOf(_282,_27b);
if(_284>-1){
_282.splice(_284,1);
}
};
return _283;
}});
});
},"dijit/_CssStateMixin":function(){
define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/window","./registry"],function(_285,_286,dom,_287,has,lang,on,_288,win,_289){
var _28a=_286("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){
this.inherited(arguments);
_285.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){
this.watch(attr,lang.hitch(this,"_setStateClass"));
},this);
for(var ap in this.cssStateNodes){
this._trackMouseState(this[ap],this.cssStateNodes[ap]);
}
this._trackMouseState(this.domNode,this.baseClass);
this._setStateClass();
},_cssMouseEvent:function(_28b){
if(!this.disabled){
switch(_28b.type){
case "mouseover":
this._set("hovering",true);
this._set("active",this._mouseDown);
break;
case "mouseout":
this._set("hovering",false);
this._set("active",false);
break;
case "mousedown":
case "touchstart":
this._set("active",true);
break;
case "mouseup":
case "touchend":
this._set("active",false);
break;
}
}
},_setStateClass:function(){
var _28c=this.baseClass.split(" ");
function _28d(_28e){
_28c=_28c.concat(_285.map(_28c,function(c){
return c+_28e;
}),"dijit"+_28e);
};
if(!this.isLeftToRight()){
_28d("Rtl");
}
var _28f=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");
if(this.checked){
_28d(_28f);
}
if(this.state){
_28d(this.state);
}
if(this.selected){
_28d("Selected");
}
if(this._opened){
_28d("Opened");
}
if(this.disabled){
_28d("Disabled");
}else{
if(this.readOnly){
_28d("ReadOnly");
}else{
if(this.active){
_28d("Active");
}else{
if(this.hovering){
_28d("Hover");
}
}
}
}
if(this.focused){
_28d("Focused");
}
var tn=this.stateNode||this.domNode,_290={};
_285.forEach(tn.className.split(" "),function(c){
_290[c]=true;
});
if("_stateClasses" in this){
_285.forEach(this._stateClasses,function(c){
delete _290[c];
});
}
_285.forEach(_28c,function(c){
_290[c]=true;
});
var _291=[];
for(var c in _290){
_291.push(c);
}
tn.className=_291.join(" ");
this._stateClasses=_28c;
},_subnodeCssMouseEvent:function(node,_292,evt){
if(this.disabled||this.readOnly){
return;
}
function _293(_294){
_287.toggle(node,_292+"Hover",_294);
};
function _295(_296){
_287.toggle(node,_292+"Active",_296);
};
function _297(_298){
_287.toggle(node,_292+"Focused",_298);
};
switch(evt.type){
case "mouseover":
_293(true);
break;
case "mouseout":
_293(false);
_295(false);
break;
case "mousedown":
case "touchstart":
_295(true);
break;
case "mouseup":
case "touchend":
_295(false);
break;
case "focus":
case "focusin":
_297(true);
break;
case "blur":
case "focusout":
_297(false);
break;
}
},_trackMouseState:function(node,_299){
node._cssState=_299;
}});
_288(function(){
function _29a(evt){
if(!dom.isDescendant(evt.relatedTarget,evt.target)){
for(var node=evt.target;node&&node!=evt.relatedTarget;node=node.parentNode){
if(node._cssState){
var _29b=_289.getEnclosingWidget(node);
if(_29b){
if(node==_29b.domNode){
_29b._cssMouseEvent(evt);
}else{
_29b._subnodeCssMouseEvent(node,node._cssState,evt);
}
}
}
}
}
};
function _29c(evt){
evt.target=evt.srcElement;
_29a(evt);
};
var body=win.body(),_29d=(has("touch")?[]:["mouseover","mouseout"]).concat(["mousedown","touchstart","mouseup","touchend"]);
_285.forEach(_29d,function(type){
if(body.addEventListener){
body.addEventListener(type,_29a,true);
}else{
body.attachEvent("on"+type,_29c);
}
});
on(body,"focusin, focusout",function(evt){
var node=evt.target;
if(node._cssState&&!node.getAttribute("widgetId")){
var _29e=_289.getEnclosingWidget(node);
_29e._subnodeCssMouseEvent(node,node._cssState,evt);
}
});
});
return _28a;
});
},"dojo/dnd/Moveable":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_29f,_2a0,_2a1,lang,dom,_2a2,_2a3,on,_2a4,_2a5,dnd,_2a6,win){
var _2a7=_2a0("dojo.dnd.Moveable",[_2a3],{handle:"",delay:0,skip:false,constructor:function(node,_2a8){
this.node=dom.byId(node);
if(!_2a8){
_2a8={};
}
this.handle=_2a8.handle?dom.byId(_2a8.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_2a8.delay>0?_2a8.delay:0;
this.skip=_2a8.skip;
this.mover=_2a8.mover?_2a8.mover:_2a6;
this.events=[on(this.handle,_2a5.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_2a9,node,Ctor){
return new Ctor(node,_2a9);
},destroy:function(){
_29f.forEach(this.events,function(_2aa){
_2aa.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,_2a5.move,lang.hitch(this,"onMouseMove")),on(this.handle,_2a5.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
_2a1.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
_2a1.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
_2a1.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
_2a1.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(_2ab){
_2a4.publish("/dnd/move/start",_2ab);
_2a2.add(win.body(),"dojoMove");
_2a2.add(this.node,"dojoMoveItem");
},onMoveStop:function(_2ac){
_2a4.publish("/dnd/move/stop",_2ac);
_2a2.remove(win.body(),"dojoMove");
_2a2.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(_2ad,_2ae){
this.onMoving(_2ad,_2ae);
var s=_2ad.node.style;
s.left=_2ae.l+"px";
s.top=_2ae.t+"px";
this.onMoved(_2ad,_2ae);
},onMoving:function(){
},onMoved:function(){
}});
return _2a7;
});
},"dojox/grid/Selection":function(){
define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-attr"],function(_2af,_2b0,lang,_2b1){
return _2af("dojox.grid.Selection",null,{constructor:function(_2b2){
this.grid=_2b2;
this.selected=[];
this.setMode(_2b2.selectionMode);
},mode:"extended",selected:null,updating:0,selectedIndex:-1,rangeStartIndex:-1,setMode:function(mode){
if(this.selected.length){
this.deselectAll();
}
if(mode!="extended"&&mode!="multiple"&&mode!="single"&&mode!="none"){
this.mode="extended";
}else{
this.mode=mode;
}
},onCanSelect:function(_2b3){
return this.grid.onCanSelect(_2b3);
},onCanDeselect:function(_2b4){
return this.grid.onCanDeselect(_2b4);
},onSelected:function(_2b5){
},onDeselected:function(_2b6){
},onChanging:function(){
},onChanged:function(){
},isSelected:function(_2b7){
if(this.mode=="none"){
return false;
}
return this.selected[_2b7];
},getFirstSelected:function(){
if(!this.selected.length||this.mode=="none"){
return -1;
}
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
return i;
}
}
return -1;
},getNextSelected:function(_2b8){
if(this.mode=="none"){
return -1;
}
for(var i=_2b8+1,l=this.selected.length;i<l;i++){
if(this.selected[i]){
return i;
}
}
return -1;
},getSelected:function(){
var _2b9=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_2b9.push(i);
}
}
return _2b9;
},getSelectedCount:function(){
var c=0;
for(var i=0;i<this.selected.length;i++){
if(this.selected[i]){
c++;
}
}
return c;
},_beginUpdate:function(){
if(this.updating===0){
this.onChanging();
}
this.updating++;
},_endUpdate:function(){
this.updating--;
if(this.updating===0){
this.onChanged();
}
},select:function(_2ba){
if(this.mode=="none"){
return;
}
if(this.mode!="multiple"){
this.deselectAll(_2ba);
this.addToSelection(_2ba);
}else{
this.toggleSelect(_2ba);
}
},addToSelection:function(_2bb){
if(this.mode=="none"){
return;
}
if(lang.isArray(_2bb)){
_2b0.forEach(_2bb,this.addToSelection,this);
return;
}
_2bb=Number(_2bb);
if(this.selected[_2bb]){
this.selectedIndex=_2bb;
}else{
if(this.onCanSelect(_2bb)!==false){
this.selectedIndex=_2bb;
var _2bc=this.grid.getRowNode(_2bb);
if(_2bc){
_2b1.set(_2bc,"aria-selected","true");
}
this._beginUpdate();
this.selected[_2bb]=true;
this.onSelected(_2bb);
this._endUpdate();
}
}
},deselect:function(_2bd){
if(this.mode=="none"){
return;
}
if(lang.isArray(_2bd)){
_2b0.forEach(_2bd,this.deselect,this);
return;
}
_2bd=Number(_2bd);
if(this.selectedIndex==_2bd){
this.selectedIndex=-1;
}
if(this.selected[_2bd]){
if(this.onCanDeselect(_2bd)===false){
return;
}
var _2be=this.grid.getRowNode(_2bd);
if(_2be){
_2b1.set(_2be,"aria-selected","false");
}
this._beginUpdate();
delete this.selected[_2bd];
this.onDeselected(_2bd);
this._endUpdate();
}
},setSelected:function(_2bf,_2c0){
this[(_2c0?"addToSelection":"deselect")](_2bf);
},toggleSelect:function(_2c1){
if(lang.isArray(_2c1)){
_2b0.forEach(_2c1,this.toggleSelect,this);
return;
}
this.setSelected(_2c1,!this.selected[_2c1]);
},_range:function(_2c2,inTo,func){
var s=(_2c2>=0?_2c2:inTo),e=inTo;
if(s>e){
e=s;
s=inTo;
}
for(var i=s;i<=e;i++){
func(i);
}
},selectRange:function(_2c3,inTo){
this._range(_2c3,inTo,lang.hitch(this,"addToSelection"));
},deselectRange:function(_2c4,inTo){
this._range(_2c4,inTo,lang.hitch(this,"deselect"));
},insert:function(_2c5){
this.selected.splice(_2c5,0,false);
if(this.selectedIndex>=_2c5){
this.selectedIndex++;
}
},remove:function(_2c6){
this.selected.splice(_2c6,1);
if(this.selectedIndex>=_2c6){
this.selectedIndex--;
}
},deselectAll:function(_2c7){
for(var i in this.selected){
if((i!=_2c7)&&(this.selected[i]===true)){
this.deselect(i);
}
}
},clickSelect:function(_2c8,_2c9,_2ca){
if(this.mode=="none"){
return;
}
this._beginUpdate();
if(this.mode!="extended"){
this.select(_2c8);
}else{
if(!_2ca||this.rangeStartIndex<0){
this.rangeStartIndex=_2c8;
}
if(!_2c9){
this.deselectAll(_2c8);
}
if(_2ca){
this.selectRange(this.rangeStartIndex,_2c8);
}else{
if(_2c9){
this.toggleSelect(_2c8);
}else{
this.addToSelection(_2c8);
}
}
}
this._endUpdate();
},clickSelectEvent:function(e){
this.clickSelect(e.rowIndex,dojo.isCopyKey(e),e.shiftKey);
},clear:function(){
this._beginUpdate();
this.deselectAll();
this._endUpdate();
}});
});
},"dojox/grid/_Grid":function(){
require({cache:{"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n"}});
define("dojox/grid/_Grid",["dojo/_base/kernel","../main","dojo/_base/declare","./_Events","./_Scroller","./_Layout","./_View","./_ViewManager","./_RowManager","./_FocusManager","./_EditManager","./Selection","./_RowSelector","./util","dijit/_Widget","dijit/_TemplatedMixin","dijit/CheckedMenuItem","dojo/text!./resources/_Grid.html","dojo/string","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojox/html/metrics","dojo/_base/html","dojo/query","dojo/dnd/common","dojo/i18n!dijit/nls/loading"],function(dojo,_2cb,_2cc,_2cd,_2ce,_2cf,_2d0,_2d1,_2d2,_2d3,_2d4,_2d5,_2d6,util,_2d7,_2d8,_2d9,_2da,_2db,_2dc,lang,has,_2dd,html,_2de){
if(!dojo.isCopyKey){
dojo.isCopyKey=dojo.dnd.getCopyKeyState;
}
var _2df=_2cc("dojox.grid._Grid",[_2d7,_2d8,_2cd],{templateString:_2da,classTag:"dojoxGrid",rowCount:5,keepRows:75,rowsPerPage:25,autoWidth:false,initialWidth:"",autoHeight:"",rowHeight:0,autoRender:true,defaultHeight:"15em",height:"",structure:null,elasticView:-1,singleClickEdit:false,selectionMode:"extended",rowSelector:"",columnReordering:false,headerMenu:null,placeholderLabel:"GridColumns",selectable:false,_click:null,loadingMessage:"<span class='dojoxGridLoading'>${loadingState}</span>",errorMessage:"<span class='dojoxGridError'>${errorState}</span>",noDataMessage:"",escapeHTMLInData:true,formatterScope:null,editable:false,summary:"",_setSummaryAttr:"domNode",sortInfo:0,_placeholders:null,_layoutClass:_2cf,buildRendering:function(){
this.inherited(arguments);
if(!this.domNode.getAttribute("tabIndex")){
this.domNode.tabIndex="0";
}
this.createScroller();
this.createLayout();
this.createViews();
this.createManagers();
this.createSelection();
this.connect(this.selection,"onSelected","onSelected");
this.connect(this.selection,"onDeselected","onDeselected");
this.connect(this.selection,"onChanged","onSelectionChanged");
_2dd.initOnFontResize();
this.connect(_2dd,"onFontResize","textSizeChanged");
util.funnelEvents(this.domNode,this,"doKeyEvent",util.keyEvents);
if(this.selectionMode!="none"){
this.domNode.setAttribute("aria-multiselectable",this.selectionMode=="single"?"false":"true");
}
html.addClass(this.domNode,this.classTag);
if(!this.isLeftToRight()){
html.addClass(this.domNode,this.classTag+"Rtl");
}
if(this.rowHeight>0){
html.addClass(this.viewsNode,this.classTag+"FixedRowHeight");
}
},postMixInProperties:function(){
this.inherited(arguments);
var _2e0=dojo.i18n.getLocalization("dijit","loading",this.lang);
this.loadingMessage=_2db.substitute(this.loadingMessage,_2e0);
this.errorMessage=_2db.substitute(this.errorMessage,_2e0);
if(this.srcNodeRef&&this.srcNodeRef.style.height){
this.height=this.srcNodeRef.style.height;
}
this._setAutoHeightAttr(this.autoHeight,true);
this.lastScrollTop=this.scrollTop=0;
},postCreate:function(){
this._placeholders=[];
this._setHeaderMenuAttr(this.headerMenu);
this._setStructureAttr(this.structure);
this._click=[];
this.inherited(arguments);
if(this.domNode&&this.autoWidth&&this.initialWidth){
this.domNode.style.width=this.initialWidth;
}
if(this.domNode&&!this.editable){
html.attr(this.domNode,"aria-readonly","true");
}
},destroy:function(){
this.domNode.onReveal=null;
this.domNode.onSizeChange=null;
delete this._click;
if(this.scroller){
this.scroller.destroy();
delete this.scroller;
}
this.edit.destroy();
delete this.edit;
this.views.destroyViews();
if(this.focus){
this.focus.destroy();
delete this.focus;
}
if(this.headerMenu&&this._placeholders.length){
_2dc.forEach(this._placeholders,function(p){
p.unReplace(true);
});
this.headerMenu.unBindDomNode(this.viewsHeaderNode);
}
this.inherited(arguments);
},_setAutoHeightAttr:function(ah,_2e1){
if(typeof ah=="string"){
if(!ah||ah=="false"){
ah=false;
}else{
if(ah=="true"){
ah=true;
}else{
ah=window.parseInt(ah,10);
}
}
}
if(typeof ah=="number"){
if(isNaN(ah)){
ah=false;
}
if(ah<0){
ah=true;
}else{
if(ah===0){
ah=false;
}
}
}
this.autoHeight=ah;
if(typeof ah=="boolean"){
this._autoHeight=ah;
}else{
if(typeof ah=="number"){
this._autoHeight=(ah>=this.get("rowCount"));
}else{
this._autoHeight=false;
}
}
if(this._started&&!_2e1){
this.render();
}
},_getRowCountAttr:function(){
return this.updating&&this.invalidated&&this.invalidated.rowCount!=undefined?this.invalidated.rowCount:this.rowCount;
},textSizeChanged:function(){
this.render();
},sizeChange:function(){
this.update();
},createManagers:function(){
this.rows=new _2d2(this);
this.focus=new _2d3(this);
this.edit=new _2d4(this);
},createSelection:function(){
this.selection=new _2d5(this);
},createScroller:function(){
this.scroller=new _2ce();
this.scroller.grid=this;
this.scroller.renderRow=lang.hitch(this,"renderRow");
this.scroller.removeRow=lang.hitch(this,"rowRemoved");
},createLayout:function(){
this.layout=new this._layoutClass(this);
this.connect(this.layout,"moveColumn","onMoveColumn");
},onMoveColumn:function(){
this.update();
},onResizeColumn:function(_2e2){
},createViews:function(){
this.views=new _2d1(this);
this.views.createView=lang.hitch(this,"createView");
},createView:function(_2e3,idx){
var c=lang.getObject(_2e3);
var view=new c({grid:this,index:idx});
this.viewsNode.appendChild(view.domNode);
this.viewsHeaderNode.appendChild(view.headerNode);
this.views.addView(view);
html.attr(this.domNode,"align",this.isLeftToRight()?"left":"right");
return view;
},buildViews:function(){
for(var i=0,vs;(vs=this.layout.structure[i]);i++){
this.createView(vs.type||_2cb._scopeName+".grid._View",i).setStructure(vs);
}
this.scroller.setContentNodes(this.views.getContentNodes());
},_setStructureAttr:function(_2e4){
var s=_2e4;
if(s&&lang.isString(s)){
dojo.deprecated("dojox.grid._Grid.set('structure', 'objVar')","use dojox.grid._Grid.set('structure', objVar) instead","2.0");
s=lang.getObject(s);
}
this.structure=s;
if(!s){
if(this.layout.structure){
s=this.layout.structure;
}else{
return;
}
}
this.views.destroyViews();
this.focus.focusView=null;
if(s!==this.layout.structure){
this.layout.setStructure(s);
}
this._structureChanged();
},setStructure:function(_2e5){
dojo.deprecated("dojox.grid._Grid.setStructure(obj)","use dojox.grid._Grid.set('structure', obj) instead.","2.0");
this._setStructureAttr(_2e5);
},getColumnTogglingItems:function(){
var _2e6,_2e7=[];
_2e6=_2dc.map(this.layout.cells,function(cell){
if(!cell.menuItems){
cell.menuItems=[];
}
var self=this;
var item=new _2d9({label:cell.name,checked:!cell.hidden,_gridCell:cell,onChange:function(_2e8){
if(self.layout.setColumnVisibility(this._gridCell.index,_2e8)){
var _2e9=this._gridCell.menuItems;
if(_2e9.length>1){
_2dc.forEach(_2e9,function(item){
if(item!==this){
item.setAttribute("checked",_2e8);
}
},this);
}
_2e8=_2dc.filter(self.layout.cells,function(c){
if(c.menuItems.length>1){
_2dc.forEach(c.menuItems,"item.set('disabled', false);");
}else{
c.menuItems[0].set("disabled",false);
}
return !c.hidden;
});
if(_2e8.length==1){
_2dc.forEach(_2e8[0].menuItems,"item.set('disabled', true);");
}
}
},destroy:function(){
var _2ea=_2dc.indexOf(this._gridCell.menuItems,this);
this._gridCell.menuItems.splice(_2ea,1);
delete this._gridCell;
_2d9.prototype.destroy.apply(this,arguments);
}});
cell.menuItems.push(item);
if(!cell.hidden){
_2e7.push(item);
}
return item;
},this);
if(_2e7.length==1){
_2e7[0].set("disabled",true);
}
return _2e6;
},_setHeaderMenuAttr:function(menu){
if(this._placeholders&&this._placeholders.length){
_2dc.forEach(this._placeholders,function(p){
p.unReplace(true);
});
this._placeholders=[];
}
if(this.headerMenu){
this.headerMenu.unBindDomNode(this.viewsHeaderNode);
}
this.headerMenu=menu;
if(!menu){
return;
}
this.headerMenu.bindDomNode(this.viewsHeaderNode);
if(this.headerMenu.getPlaceholders){
this._placeholders=this.headerMenu.getPlaceholders(this.placeholderLabel);
}
},setHeaderMenu:function(menu){
dojo.deprecated("dojox.grid._Grid.setHeaderMenu(obj)","use dojox.grid._Grid.set('headerMenu', obj) instead.","2.0");
this._setHeaderMenuAttr(menu);
},setupHeaderMenu:function(){
if(this._placeholders&&this._placeholders.length){
_2dc.forEach(this._placeholders,function(p){
if(p._replaced){
p.unReplace(true);
}
p.replace(this.getColumnTogglingItems());
},this);
}
},_fetch:function(_2eb){
this.setScrollTop(0);
},getItem:function(_2ec){
return null;
},showMessage:function(_2ed){
if(_2ed){
this.messagesNode.innerHTML=_2ed;
this.messagesNode.style.display="";
}else{
this.messagesNode.innerHTML="";
this.messagesNode.style.display="none";
}
},_structureChanged:function(){
this.buildViews();
if(this.autoRender&&this._started){
this.render();
}
},hasLayout:function(){
return this.layout.cells.length;
},resize:function(_2ee,_2ef){
this._pendingChangeSize=_2ee;
this._pendingResultSize=_2ef;
this.sizeChange();
},_getPadBorder:function(){
this._padBorder=this._padBorder||html._getPadBorderExtents(this.domNode);
return this._padBorder;
},_getHeaderHeight:function(){
var vns=this.viewsHeaderNode.style,t=vns.display=="none"?0:this.views.measureHeader();
vns.height=t+"px";
this.views.normalizeHeaderNodeHeight();
return t;
},_resize:function(_2f0,_2f1){
_2f0=_2f0||this._pendingChangeSize;
_2f1=_2f1||this._pendingResultSize;
delete this._pendingChangeSize;
delete this._pendingResultSize;
if(!this.domNode){
return;
}
var pn=this.domNode.parentNode;
if(!pn||pn.nodeType!=1||!this.hasLayout()||pn.style.visibility=="hidden"||pn.style.display=="none"){
return;
}
var _2f2=this._getPadBorder();
var hh=undefined;
var h;
if(this._autoHeight){
this.domNode.style.height="auto";
}else{
if(typeof this.autoHeight=="number"){
h=hh=this._getHeaderHeight();
h+=(this.scroller.averageRowHeight*this.autoHeight);
this.domNode.style.height=h+"px";
}else{
if(this.domNode.clientHeight<=_2f2.h){
if(pn==document.body){
this.domNode.style.height=this.defaultHeight;
}else{
if(this.height){
this.domNode.style.height=this.height;
}else{
this.fitTo="parent";
}
}
}
}
}
if(_2f1){
_2f0=_2f1;
}
if(!this._autoHeight&&_2f0){
html.marginBox(this.domNode,_2f0);
this.height=this.domNode.style.height;
delete this.fitTo;
}else{
if(this.fitTo=="parent"){
h=this._parentContentBoxHeight=(this._parentContentBoxHeight>0?this._parentContentBoxHeight:html._getContentBox(pn).h);
this.domNode.style.height=Math.max(0,h)+"px";
}
}
var _2f3=_2dc.some(this.views.views,function(v){
return v.flexCells;
});
if(!this._autoHeight&&(h||html._getContentBox(this.domNode).h)===0){
this.viewsHeaderNode.style.display="none";
}else{
this.viewsHeaderNode.style.display="block";
if(!_2f3&&hh===undefined){
hh=this._getHeaderHeight();
}
}
if(_2f3){
hh=undefined;
}
this.adaptWidth();
this.adaptHeight(hh);
this.postresize();
},adaptWidth:function(){
var _2f4=(!this.initialWidth&&this.autoWidth);
var w=_2f4?0:this.domNode.clientWidth||(this.domNode.offsetWidth-this._getPadBorder().w),vw=this.views.arrange(1,w);
this.views.onEach("adaptWidth");
if(_2f4){
this.domNode.style.width=vw+"px";
}
},adaptHeight:function(_2f5){
var t=_2f5===undefined?this._getHeaderHeight():_2f5;
var h=(this._autoHeight?-1:Math.max(this.domNode.clientHeight-t,0)||0);
this.views.onEach("setSize",[0,h]);
this.views.onEach("adaptHeight");
if(!this._autoHeight){
var _2f6=0,_2f7=0;
var _2f8=_2dc.filter(this.views.views,function(v){
var has=v.hasHScrollbar();
if(has){
_2f6++;
}else{
_2f7++;
}
return (!has);
});
if(_2f6>0&&_2f7>0){
_2dc.forEach(_2f8,function(v){
v.adaptHeight(true);
});
}
}
if(this.autoHeight===true||h!=-1||(typeof this.autoHeight=="number"&&this.autoHeight>=this.get("rowCount"))){
this.scroller.windowHeight=h;
}else{
this.scroller.windowHeight=Math.max(this.domNode.clientHeight-t,0);
}
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
if(this.autoRender){
this.render();
}
},render:function(){
if(!this.domNode){
return;
}
if(!this._started){
return;
}
if(!this.hasLayout()){
this.scroller.init(0,this.keepRows,this.rowsPerPage);
return;
}
this.update=this.defaultUpdate;
this._render();
},_render:function(){
this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);
this.prerender();
this.setScrollTop(0);
this.postrender();
},prerender:function(){
this.keepRows=this._autoHeight?0:this.keepRows;
this.scroller.setKeepInfo(this.keepRows);
this.views.render();
this._resize();
},postrender:function(){
this.postresize();
this.focus.initFocusView();
html.setSelectable(this.domNode,this.selectable);
},postresize:function(){
if(this._autoHeight){
var size=Math.max(this.views.measureContent())+"px";
this.viewsNode.style.height=size;
}
},renderRow:function(_2f9,_2fa){
this.views.renderRow(_2f9,_2fa,this._skipRowRenormalize);
},rowRemoved:function(_2fb){
this.views.rowRemoved(_2fb);
},invalidated:null,updating:false,beginUpdate:function(){
this.invalidated=[];
this.updating=true;
},endUpdate:function(){
this.updating=false;
var i=this.invalidated,r;
if(i.all){
this.update();
}else{
if(i.rowCount!=undefined){
this.updateRowCount(i.rowCount);
}else{
for(r in i){
this.updateRow(Number(r));
}
}
}
this.invalidated=[];
},defaultUpdate:function(){
if(!this.domNode){
return;
}
if(this.updating){
this.invalidated.all=true;
return;
}
this.lastScrollTop=this.scrollTop;
this.prerender();
this.scroller.invalidateNodes();
this.setScrollTop(this.lastScrollTop);
this.postrender();
},update:function(){
this.render();
},updateRow:function(_2fc){
_2fc=Number(_2fc);
if(this.updating){
this.invalidated[_2fc]=true;
}else{
this.views.updateRow(_2fc);
this.scroller.rowHeightChanged(_2fc);
}
},updateRows:function(_2fd,_2fe){
_2fd=Number(_2fd);
_2fe=Number(_2fe);
var i;
if(this.updating){
for(i=0;i<_2fe;i++){
this.invalidated[i+_2fd]=true;
}
}else{
for(i=0;i<_2fe;i++){
this.views.updateRow(i+_2fd,this._skipRowRenormalize);
}
this.scroller.rowHeightChanged(_2fd);
}
},updateRowCount:function(_2ff){
if(this.updating){
this.invalidated.rowCount=_2ff;
}else{
this.rowCount=_2ff;
this._setAutoHeightAttr(this.autoHeight,true);
if(this.layout.cells.length){
this.scroller.updateRowCount(_2ff);
}
this._resize();
if(this.layout.cells.length){
this.setScrollTop(this.scrollTop);
}
}
},updateRowStyles:function(_300){
this.views.updateRowStyles(_300);
},getRowNode:function(_301){
if(this.focus.focusView&&!(this.focus.focusView instanceof _2d6)){
return this.focus.focusView.rowNodes[_301];
}else{
for(var i=0,_302;(_302=this.views.views[i]);i++){
if(!(_302 instanceof _2d6)){
return _302.rowNodes[_301];
}
}
}
return null;
},rowHeightChanged:function(_303){
this.views.renormalizeRow(_303);
this.scroller.rowHeightChanged(_303);
},fastScroll:true,delayScroll:false,scrollRedrawThreshold:(has("ie")?100:50),scrollTo:function(_304){
if(!this.fastScroll){
this.setScrollTop(_304);
return;
}
var _305=Math.abs(this.lastScrollTop-_304);
this.lastScrollTop=_304;
if(_305>this.scrollRedrawThreshold||this.delayScroll){
this.delayScroll=true;
this.scrollTop=_304;
this.views.setScrollTop(_304);
if(this._pendingScroll){
window.clearTimeout(this._pendingScroll);
}
var _306=this;
this._pendingScroll=window.setTimeout(function(){
delete _306._pendingScroll;
_306.finishScrollJob();
},200);
}else{
this.setScrollTop(_304);
}
},finishScrollJob:function(){
this.delayScroll=false;
this.setScrollTop(this.scrollTop);
},setScrollTop:function(_307){
this.scroller.scroll(this.views.setScrollTop(_307));
},scrollToRow:function(_308){
this.setScrollTop(this.scroller.findScrollTop(_308)+1);
},styleRowNode:function(_309,_30a){
if(_30a){
this.rows.styleRowNode(_309,_30a);
}
},_mouseOut:function(e){
this.rows.setOverRow(-2);
},getCell:function(_30b){
return this.layout.cells[_30b];
},setCellWidth:function(_30c,_30d){
this.getCell(_30c).unitWidth=_30d;
},getCellName:function(_30e){
return "Cell "+_30e.index;
},canSort:function(_30f){
},sort:function(){
},getSortAsc:function(_310){
_310=_310==undefined?this.sortInfo:_310;
return Boolean(_310>0);
},getSortIndex:function(_311){
_311=_311==undefined?this.sortInfo:_311;
return Math.abs(_311)-1;
},setSortIndex:function(_312,_313){
var si=_312+1;
if(_313!=undefined){
si*=(_313?1:-1);
}else{
if(this.getSortIndex()==_312){
si=-this.sortInfo;
}
}
this.setSortInfo(si);
},setSortInfo:function(_314){
if(this.canSort(_314)){
this.sortInfo=_314;
this.sort();
this.update();
}
},doKeyEvent:function(e){
e.dispatch="do"+e.type;
this.onKeyEvent(e);
},_dispatch:function(m,e){
if(m in this){
return this[m](e);
}
return false;
},dispatchKeyEvent:function(e){
this._dispatch(e.dispatch,e);
},dispatchContentEvent:function(e){
this.edit.dispatchEvent(e)||e.sourceView.dispatchContentEvent(e)||this._dispatch(e.dispatch,e);
},dispatchHeaderEvent:function(e){
e.sourceView.dispatchHeaderEvent(e)||this._dispatch("doheader"+e.type,e);
},dokeydown:function(e){
this.onKeyDown(e);
},doclick:function(e){
if(e.cellNode){
this.onCellClick(e);
}else{
this.onRowClick(e);
}
},dodblclick:function(e){
if(e.cellNode){
this.onCellDblClick(e);
}else{
this.onRowDblClick(e);
}
},docontextmenu:function(e){
if(e.cellNode){
this.onCellContextMenu(e);
}else{
this.onRowContextMenu(e);
}
},doheaderclick:function(e){
if(e.cellNode){
this.onHeaderCellClick(e);
}else{
this.onHeaderClick(e);
}
},doheaderdblclick:function(e){
if(e.cellNode){
this.onHeaderCellDblClick(e);
}else{
this.onHeaderDblClick(e);
}
},doheadercontextmenu:function(e){
if(e.cellNode){
this.onHeaderCellContextMenu(e);
}else{
this.onHeaderContextMenu(e);
}
},doStartEdit:function(_315,_316){
this.onStartEdit(_315,_316);
},doApplyCellEdit:function(_317,_318,_319){
this.onApplyCellEdit(_317,_318,_319);
},doCancelEdit:function(_31a){
this.onCancelEdit(_31a);
},doApplyEdit:function(_31b){
this.onApplyEdit(_31b);
},addRow:function(){
this.updateRowCount(this.get("rowCount")+1);
},removeSelectedRows:function(){
if(this.allItemsSelected){
this.updateRowCount(0);
}else{
this.updateRowCount(Math.max(0,this.get("rowCount")-this.selection.getSelected().length));
}
this.selection.clear();
}});
_2df.markupFactory=function(_31c,node,ctor,_31d){
var _31e=function(n){
var w=html.attr(n,"width")||"auto";
if((w!="auto")&&(w.slice(-2)!="em")&&(w.slice(-1)!="%")){
w=parseInt(w,10)+"px";
}
return w;
};
if(!_31c.structure&&node.nodeName.toLowerCase()=="table"){
_31c.structure=_2de("> colgroup",node).map(function(cg){
var sv=html.attr(cg,"span");
var v={noscroll:(html.attr(cg,"noscroll")=="true")?true:false,__span:(!!sv?parseInt(sv,10):1),cells:[]};
if(html.hasAttr(cg,"width")){
v.width=_31e(cg);
}
return v;
});
if(!_31c.structure.length){
_31c.structure.push({__span:Infinity,cells:[]});
}
_2de("thead > tr",node).forEach(function(tr,_31f){
var _320=0;
var _321=0;
var _322;
var _323=null;
_2de("> th",tr).map(function(th){
if(!_323){
_322=0;
_323=_31c.structure[0];
}else{
if(_320>=(_322+_323.__span)){
_321++;
_322+=_323.__span;
var _324=_323;
_323=_31c.structure[_321];
}
}
var cell={name:lang.trim(html.attr(th,"name")||th.innerHTML),colSpan:parseInt(html.attr(th,"colspan")||1,10),type:lang.trim(html.attr(th,"cellType")||""),id:lang.trim(html.attr(th,"id")||"")};
_320+=cell.colSpan;
var _325=html.attr(th,"rowspan");
if(_325){
cell.rowSpan=_325;
}
if(html.hasAttr(th,"width")){
cell.width=_31e(th);
}
if(html.hasAttr(th,"relWidth")){
cell.relWidth=window.parseInt(html.attr(th,"relWidth"),10);
}
if(html.hasAttr(th,"hidden")){
cell.hidden=(html.attr(th,"hidden")=="true"||html.attr(th,"hidden")===true);
}
if(_31d){
_31d(th,cell);
}
cell.type=cell.type?lang.getObject(cell.type):_2cb.grid.cells.Cell;
if(cell.type&&cell.type.markupFactory){
cell.type.markupFactory(th,cell);
}
if(!_323.cells[_31f]){
_323.cells[_31f]=[];
}
_323.cells[_31f].push(cell);
});
});
}
return new ctor(_31c,node);
};
return _2df;
});
},"dojo/dnd/Selector":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../dom","../dom-construct","../mouse","../_base/NodeList","../on","../touch","./common","./Container"],function(_326,_327,_328,_329,lang,dom,_32a,_32b,_32c,on,_32d,dnd,_32e){
var _32f=_327("dojo.dnd.Selector",_32e,{constructor:function(node,_330){
if(!_330){
_330={};
}
this.singular=_330.singular;
this.autoSync=_330.autoSync;
this.selection={};
this.anchor=null;
this.simpleSelection=false;
this.events.push(on(this.node,_32d.press,lang.hitch(this,"onMouseDown")),on(this.node,_32d.release,lang.hitch(this,"onMouseUp")));
},singular:false,getSelectedNodes:function(){
var t=new _32c();
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
t.push(dom.byId(i));
}
return t;
},selectNone:function(){
return this._removeSelection()._removeAnchor();
},selectAll:function(){
this.forInItems(function(data,id){
this._addItemClass(dom.byId(id),"Selected");
this.selection[id]=1;
},this);
return this._removeAnchor();
},deleteSelectedNodes:function(){
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
var n=dom.byId(i);
this.delItem(i);
_32a.destroy(n);
}
this.anchor=null;
this.selection={};
return this;
},forInSelectedItems:function(f,o){
o=o||_329.global;
var s=this.selection,e=dnd._empty;
for(var i in s){
if(i in e){
continue;
}
f.call(o,this.getItem(i),i,this);
}
},sync:function(){
_32f.superclass.sync.call(this);
if(this.anchor){
if(!this.getItem(this.anchor.id)){
this.anchor=null;
}
}
var t=[],e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
if(!this.getItem(i)){
t.push(i);
}
}
_326.forEach(t,function(i){
delete this.selection[i];
},this);
return this;
},insertNodes:function(_331,data,_332,_333){
var _334=this._normalizedCreator;
this._normalizedCreator=function(item,hint){
var t=_334.call(this,item,hint);
if(_331){
if(!this.anchor){
this.anchor=t.node;
this._removeItemClass(t.node,"Selected");
this._addItemClass(this.anchor,"Anchor");
}else{
if(this.anchor!=t.node){
this._removeItemClass(t.node,"Anchor");
this._addItemClass(t.node,"Selected");
}
}
this.selection[t.node.id]=1;
}else{
this._removeItemClass(t.node,"Selected");
this._removeItemClass(t.node,"Anchor");
}
return t;
};
_32f.superclass.insertNodes.call(this,data,_332,_333);
this._normalizedCreator=_334;
return this;
},destroy:function(){
_32f.superclass.destroy.call(this);
this.selection=this.anchor=null;
},onMouseDown:function(e){
if(this.autoSync){
this.sync();
}
if(!this.current){
return;
}
if(!this.singular&&!dnd.getCopyKeyState(e)&&!e.shiftKey&&(this.current.id in this.selection)){
this.simpleSelection=true;
if(_32b.isLeft(e)){
_328.stop(e);
}
return;
}
if(!this.singular&&e.shiftKey){
if(!dnd.getCopyKeyState(e)){
this._removeSelection();
}
var c=this.getAllNodes();
if(c.length){
if(!this.anchor){
this.anchor=c[0];
this._addItemClass(this.anchor,"Anchor");
}
this.selection[this.anchor.id]=1;
if(this.anchor!=this.current){
var i=0,node;
for(;i<c.length;++i){
node=c[i];
if(node==this.anchor||node==this.current){
break;
}
}
for(++i;i<c.length;++i){
node=c[i];
if(node==this.anchor||node==this.current){
break;
}
this._addItemClass(node,"Selected");
this.selection[node.id]=1;
}
this._addItemClass(this.current,"Selected");
this.selection[this.current.id]=1;
}
}
}else{
if(this.singular){
if(this.anchor==this.current){
if(dnd.getCopyKeyState(e)){
this.selectNone();
}
}else{
this.selectNone();
this.anchor=this.current;
this._addItemClass(this.anchor,"Anchor");
this.selection[this.current.id]=1;
}
}else{
if(dnd.getCopyKeyState(e)){
if(this.anchor==this.current){
delete this.selection[this.anchor.id];
this._removeAnchor();
}else{
if(this.current.id in this.selection){
this._removeItemClass(this.current,"Selected");
delete this.selection[this.current.id];
}else{
if(this.anchor){
this._removeItemClass(this.anchor,"Anchor");
this._addItemClass(this.anchor,"Selected");
}
this.anchor=this.current;
this._addItemClass(this.current,"Anchor");
this.selection[this.current.id]=1;
}
}
}else{
if(!(this.current.id in this.selection)){
this.selectNone();
this.anchor=this.current;
this._addItemClass(this.current,"Anchor");
this.selection[this.current.id]=1;
}
}
}
}
_328.stop(e);
},onMouseUp:function(){
if(!this.simpleSelection){
return;
}
this.simpleSelection=false;
this.selectNone();
if(this.current){
this.anchor=this.current;
this._addItemClass(this.anchor,"Anchor");
this.selection[this.current.id]=1;
}
},onMouseMove:function(){
this.simpleSelection=false;
},onOverEvent:function(){
this.onmousemoveEvent=on(this.node,_32d.move,lang.hitch(this,"onMouseMove"));
},onOutEvent:function(){
if(this.onmousemoveEvent){
this.onmousemoveEvent.remove();
delete this.onmousemoveEvent;
}
},_removeSelection:function(){
var e=dnd._empty;
for(var i in this.selection){
if(i in e){
continue;
}
var node=dom.byId(i);
if(node){
this._removeItemClass(node,"Selected");
}
}
this.selection={};
return this;
},_removeAnchor:function(){
if(this.anchor){
this._removeItemClass(this.anchor,"Anchor");
this.anchor=null;
}
return this;
}});
return _32f;
});
},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","dojo/text":function(){
define(["./_base/kernel","require","./has","./_base/xhr"],function(dojo,_335,has,xhr){
var _336;
if(1){
_336=function(url,sync,load){
xhr("GET",{url:url,sync:!!sync,load:load,headers:dojo.config.textPluginHeaders||{}});
};
}else{
if(_335.getText){
_336=_335.getText;
}else{
console.error("dojo/text plugin failed to load because loader does not support getText");
}
}
var _337={},_338=function(text){
if(text){
text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _339=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_339){
text=_339[1];
}
}else{
text="";
}
return text;
},_33a={},_33b={};
dojo.cache=function(_33c,url,_33d){
var key;
if(typeof _33c=="string"){
if(/\//.test(_33c)){
key=_33c;
_33d=url;
}else{
key=_335.toUrl(_33c.replace(/\./g,"/")+(url?("/"+url):""));
}
}else{
key=_33c+"";
_33d=url;
}
var val=(_33d!=undefined&&typeof _33d!="string")?_33d.value:_33d,_33e=_33d&&_33d.sanitize;
if(typeof val=="string"){
_337[key]=val;
return _33e?_338(val):val;
}else{
if(val===null){
delete _337[key];
return null;
}else{
if(!(key in _337)){
_336(key,true,function(text){
_337[key]=text;
});
}
return _33e?_338(_337[key]):_337[key];
}
}
};
return {dynamic:true,normalize:function(id,_33f){
var _340=id.split("!"),url=_340[0];
return (/^\./.test(url)?_33f(url):url)+(_340[1]?"!"+_340[1]:"");
},load:function(id,_341,load){
var _342=id.split("!"),_343=_342.length>1,_344=_342[0],url=_341.toUrl(_342[0]),_345="url:"+url,text=_33a,_346=function(text){
load(_343?_338(text):text);
};
if(_344 in _337){
text=_337[_344];
}else{
if(_345 in _341.cache){
text=_341.cache[_345];
}else{
if(url in _337){
text=_337[url];
}
}
}
if(text===_33a){
if(_33b[url]){
_33b[url].push(_346);
}else{
var _347=_33b[url]=[_346];
_336(url,!_341.async,function(text){
_337[_344]=_337[url]=text;
for(var i=0;i<_347.length;){
_347[i++](text);
}
delete _33b[url];
});
}
}else{
_346(text);
}
}};
});
},"dijit/registry":function(){
define(["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_348,has,_349,win,_34a){
var _34b={},hash={};
var _34c={length:0,add:function(_34d){
if(hash[_34d.id]){
throw new Error("Tried to register widget with id=="+_34d.id+" but that id is already registered");
}
hash[_34d.id]=_34d;
this.length++;
},remove:function(id){
if(hash[id]){
delete hash[id];
this.length--;
}
},byId:function(id){
return typeof id=="string"?hash[id]:id;
},byNode:function(node){
return hash[node.getAttribute("widgetId")];
},toArray:function(){
var ar=[];
for(var id in hash){
ar.push(hash[id]);
}
return ar;
},getUniqueId:function(_34e){
var id;
do{
id=_34e+"_"+(_34e in _34b?++_34b[_34e]:_34b[_34e]=0);
}while(hash[id]);
return _34a._scopeName=="dijit"?id:_34a._scopeName+"_"+id;
},findWidgets:function(root,_34f){
var _350=[];
function _351(root){
for(var node=root.firstChild;node;node=node.nextSibling){
if(node.nodeType==1){
var _352=node.getAttribute("widgetId");
if(_352){
var _353=hash[_352];
if(_353){
_350.push(_353);
}
}else{
if(node!==_34f){
_351(node);
}
}
}
}
};
_351(root);
return _350;
},_destroyAll:function(){
_34a._curFocus=null;
_34a._prevFocus=null;
_34a._activeStack=[];
_348.forEach(_34c.findWidgets(win.body()),function(_354){
if(!_354._destroyed){
if(_354.destroyRecursive){
_354.destroyRecursive();
}else{
if(_354.destroy){
_354.destroy();
}
}
}
});
},getEnclosingWidget:function(node){
while(node){
var id=node.nodeType==1&&node.getAttribute("widgetId");
if(id){
return hash[id];
}
node=node.parentNode;
}
return null;
},_hash:hash};
_34a.registry=_34c;
return _34c;
});
},"dojo/uacss":function(){
define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_355,lang,_356,has,_357){
var html=_357.doc.documentElement,ie=has("ie"),_358=has("opera"),maj=Math.floor,ff=has("ff"),_359=_355.boxModel.replace(/-/,""),_35a={"dj_quirks":has("quirks"),"dj_opera":_358,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};
if(ie){
_35a["dj_ie"]=true;
_35a["dj_ie"+maj(ie)]=true;
_35a["dj_iequirks"]=has("quirks");
}
if(ff){
_35a["dj_ff"+maj(ff)]=true;
}
_35a["dj_"+_359]=true;
var _35b="";
for(var clz in _35a){
if(_35a[clz]){
_35b+=clz+" ";
}
}
html.className=lang.trim(html.className+" "+_35b);
_356(90,function(){
if(!_355.isBodyLtr()){
var _35c="dj_rtl dijitRtl "+_35b.replace(/ /g,"-rtl ");
html.className=lang.trim(html.className+" "+_35c+"dj_rtl dijitRtl "+_35b.replace(/ /g,"-rtl "));
}
});
return has;
});
},"dojo/window":function(){
define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(lang,has,_35d,dom,geom,_35e){
var _35f={getBox:function(doc){
doc=doc||_35d.doc;
var _360=(doc.compatMode=="BackCompat")?_35d.body(doc):doc.documentElement,_361=geom.docScroll(doc),w,h;
if(has("touch")){
var _362=_35f.get(doc);
w=_362.innerWidth||_360.clientWidth;
h=_362.innerHeight||_360.clientHeight;
}else{
w=_360.clientWidth;
h=_360.clientHeight;
}
return {l:_361.x,t:_361.y,w:w,h:h};
},get:function(doc){
if(has("ie")&&_35f!==document.parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc.parentWindow||doc.defaultView;
},scrollIntoView:function(node,pos){
try{
node=dom.byId(node);
var doc=node.ownerDocument||_35d.doc,body=_35d.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");
if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){
node.scrollIntoView(false);
return;
}
var _363=doc.compatMode=="BackCompat",_364=(isIE>=9&&"frameElement" in node.ownerDocument.parentWindow)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_363?body:html),_365=isWK?body:_364,_366=_364.clientWidth,_367=_364.clientHeight,rtl=!geom.isBodyLtr(doc),_368=pos||geom.position(node),el=node.parentNode,_369=function(el){
return ((isIE<=6||(isIE&&_363))?false:(_35e.get(el,"position").toLowerCase()=="fixed"));
};
if(_369(node)){
return;
}
while(el){
if(el==body){
el=_365;
}
var _36a=geom.position(el),_36b=_369(el);
if(el==_365){
_36a.w=_366;
_36a.h=_367;
if(_365==html&&isIE&&rtl){
_36a.x+=_365.offsetWidth-_36a.w;
}
if(_36a.x<0||!isIE){
_36a.x=0;
}
if(_36a.y<0||!isIE){
_36a.y=0;
}
}else{
var pb=geom.getPadBorderExtents(el);
_36a.w-=pb.w;
_36a.h-=pb.h;
_36a.x+=pb.l;
_36a.y+=pb.t;
var _36c=el.clientWidth,_36d=_36a.w-_36c;
if(_36c>0&&_36d>0){
_36a.w=_36c;
_36a.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_36d:0;
}
_36c=el.clientHeight;
_36d=_36a.h-_36c;
if(_36c>0&&_36d>0){
_36a.h=_36c;
}
}
if(_36b){
if(_36a.y<0){
_36a.h+=_36a.y;
_36a.y=0;
}
if(_36a.x<0){
_36a.w+=_36a.x;
_36a.x=0;
}
if(_36a.y+_36a.h>_367){
_36a.h=_367-_36a.y;
}
if(_36a.x+_36a.w>_366){
_36a.w=_366-_36a.x;
}
}
var l=_368.x-_36a.x,t=_368.y-Math.max(_36a.y,0),r=l+_368.w-_36a.w,bot=t+_368.h-_36a.h;
if(r*l>0){
var s=Math[l<0?"max":"min"](l,r);
if(rtl&&((isIE==8&&!_363)||isIE>=9)){
s=-s;
}
_368.x+=el.scrollLeft;
el.scrollLeft+=s;
_368.x-=el.scrollLeft;
}
if(bot*t>0){
_368.y+=el.scrollTop;
el.scrollTop+=Math[t<0?"max":"min"](t,bot);
_368.y-=el.scrollTop;
}
el=(el!=_365)&&!_36b&&el.parentNode;
}
}
catch(error){
console.error("scrollIntoView: "+error);
node.scrollIntoView(false);
}
}};
1&&lang.setObject("dojo.window",_35f);
return _35f;
});
},"dojo/dnd/Mover":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_36e,_36f,_370,lang,has,win,dom,_371,_372,_373,on,_374,dnd,_375){
return _36f("dojo.dnd.Mover",[_373],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,_374.move,lang.hitch(this,"onFirstMove")),on(d,_374.move,lang.hitch(this,"onMouseMove")),on(d,_374.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_370.stop),on(d.body,"selectstart",_370.stop)];
_375.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_375.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
_370.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
_370.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_371.getMarginBox(this.node);
var b=win.doc.body;
var bs=_372.getComputedStyle(b);
var bm=_371.getMarginBox(b,bs);
var bc=_371.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
_36e.forEach(this.events,function(_376){
_376.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n","dojox/grid/_EditManager":function(){
define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect","dojo/_base/sniff","./util"],function(lang,_377,_378,_379,has,util){
return _378("dojox.grid._EditManager",null,{constructor:function(_37a){
this.grid=_37a;
if(has("ie")){
this.connections=[_379.connect(document.body,"onfocus",lang.hitch(this,"_boomerangFocus"))];
}else{
this.connections=[_379.connect(this.grid,"onBlur",this,"apply")];
}
},info:{},destroy:function(){
_377.forEach(this.connections,_379.disconnect);
},cellFocus:function(_37b,_37c){
if(this.grid.singleClickEdit||this.isEditRow(_37c)){
this.setEditCell(_37b,_37c);
}else{
this.apply();
}
if(this.isEditing()||(_37b&&_37b.editable&&_37b.alwaysEditing)){
this._focusEditor(_37b,_37c);
}
},rowClick:function(e){
if(this.isEditing()&&!this.isEditRow(e.rowIndex)){
this.apply();
}
},styleRow:function(_37d){
if(_37d.index==this.info.rowIndex){
_37d.customClasses+=" dojoxGridRowEditing";
}
},dispatchEvent:function(e){
var c=e.cell,ed=(c&&c["editable"])?c:0;
return ed&&ed.dispatchEvent(e.dispatch,e);
},isEditing:function(){
return this.info.rowIndex!==undefined;
},isEditCell:function(_37e,_37f){
return (this.info.rowIndex===_37e)&&(this.info.cell.index==_37f);
},isEditRow:function(_380){
return this.info.rowIndex===_380;
},setEditCell:function(_381,_382){
if(!this.isEditCell(_382,_381.index)&&this.grid.canEdit&&this.grid.canEdit(_381,_382)){
this.start(_381,_382,this.isEditRow(_382)||_381.editable);
}
},_focusEditor:function(_383,_384){
util.fire(_383,"focus",[_384]);
},focusEditor:function(){
if(this.isEditing()){
this._focusEditor(this.info.cell,this.info.rowIndex);
}
},_boomerangWindow:500,_shouldCatchBoomerang:function(){
return this._catchBoomerang>new Date().getTime();
},_boomerangFocus:function(){
if(this._shouldCatchBoomerang()){
this.grid.focus.focusGrid();
this.focusEditor();
this._catchBoomerang=0;
}
},_doCatchBoomerang:function(){
if(has("ie")){
this._catchBoomerang=new Date().getTime()+this._boomerangWindow;
}
},start:function(_385,_386,_387){
if(!this._isValidInput()){
return;
}
this.grid.beginUpdate();
this.editorApply();
if(this.isEditing()&&!this.isEditRow(_386)){
this.applyRowEdit();
this.grid.updateRow(_386);
}
if(_387){
this.info={cell:_385,rowIndex:_386};
this.grid.doStartEdit(_385,_386);
this.grid.updateRow(_386);
}else{
this.info={};
}
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._focusEditor(_385,_386);
this._doCatchBoomerang();
},_editorDo:function(_388){
var c=this.info.cell;
if(c&&c.editable){
c[_388](this.info.rowIndex);
}
},editorApply:function(){
this._editorDo("apply");
},editorCancel:function(){
this._editorDo("cancel");
},applyCellEdit:function(_389,_38a,_38b){
if(this.grid.canEdit(_38a,_38b)){
this.grid.doApplyCellEdit(_389,_38b,_38a.field);
}
},applyRowEdit:function(){
this.grid.doApplyEdit(this.info.rowIndex,this.info.cell.field);
},apply:function(){
if(this.isEditing()&&this._isValidInput()){
this.grid.beginUpdate();
this.editorApply();
this.applyRowEdit();
this.info={};
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._doCatchBoomerang();
}
},cancel:function(){
if(this.isEditing()){
this.grid.beginUpdate();
this.editorCancel();
this.info={};
this.grid.endUpdate();
this.grid.focus.focusGrid();
this._doCatchBoomerang();
}
},save:function(_38c,_38d){
var c=this.info.cell;
if(this.isEditRow(_38c)&&(!_38d||c.view==_38d)&&c.editable){
c.save(c,this.info.rowIndex);
}
},restore:function(_38e,_38f){
var c=this.info.cell;
if(this.isEditRow(_38f)&&c.view==_38e&&c.editable){
c.restore(this.info.rowIndex);
}
},_isValidInput:function(){
var w=(this.info.cell||{}).widget;
if(!w||!w.isValid){
return true;
}
w.focused=true;
return w.isValid(true);
}});
});
},"dojox/grid/DataSelection":function(){
define("dojox/grid/DataSelection",["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_390,_391,_392){
return _390("dojox.grid.DataSelection",_392,{constructor:function(grid){
if(grid.keepSelection){
this.preserver=new _391(this);
}
},destroy:function(){
if(this.preserver){
this.preserver.destroy();
}
},getFirstSelected:function(){
var idx=_392.prototype.getFirstSelected.call(this);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getNextSelected:function(_393){
var _394=this.grid.getItemIndex(_393);
var idx=_392.prototype.getNextSelected.call(this,_394);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getSelected:function(){
var _395=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_395.push(this.grid.getItem(i));
}
}
return _395;
},addToSelection:function(_396){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _396=="number"||typeof _396=="string"){
idx=_396;
}else{
idx=this.grid.getItemIndex(_396);
}
_392.prototype.addToSelection.call(this,idx);
},deselect:function(_397){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _397=="number"||typeof _397=="string"){
idx=_397;
}else{
idx=this.grid.getItemIndex(_397);
}
_392.prototype.deselect.call(this,idx);
},deselectAll:function(_398){
var idx=null;
if(_398||typeof _398=="number"){
if(typeof _398=="number"||typeof _398=="string"){
idx=_398;
}else{
idx=this.grid.getItemIndex(_398);
}
_392.prototype.deselectAll.call(this,idx);
}else{
this.inherited(arguments);
}
}});
});
},"dojox/grid/_ViewManager":function(){
define(["dojo/_base/declare","dojo/_base/sniff","dojo/dom-class"],function(_399,has,_39a){
return _399("dojox.grid._ViewManager",null,{constructor:function(_39b){
this.grid=_39b;
},defaultWidth:200,views:[],resize:function(){
this.onEach("resize");
},render:function(){
this.onEach("render");
},addView:function(_39c){
_39c.idx=this.views.length;
this.views.push(_39c);
},destroyViews:function(){
for(var i=0,v;v=this.views[i];i++){
v.destroy();
}
this.views=[];
},getContentNodes:function(){
var _39d=[];
for(var i=0,v;v=this.views[i];i++){
_39d.push(v.contentNode);
}
return _39d;
},forEach:function(_39e){
for(var i=0,v;v=this.views[i];i++){
_39e(v,i);
}
},onEach:function(_39f,_3a0){
_3a0=_3a0||[];
for(var i=0,v;v=this.views[i];i++){
if(_39f in v){
v[_39f].apply(v,_3a0);
}
}
},normalizeHeaderNodeHeight:function(){
var _3a1=[];
for(var i=0,v;(v=this.views[i]);i++){
if(v.headerContentNode.firstChild){
_3a1.push(v.headerContentNode);
}
}
this.normalizeRowNodeHeights(_3a1);
},normalizeRowNodeHeights:function(_3a2){
var h=0;
var _3a3=[];
if(this.grid.rowHeight){
h=this.grid.rowHeight;
}else{
if(_3a2.length<=1){
return;
}
for(var i=0,n;(n=_3a2[i]);i++){
if(!_39a.contains(n,"dojoxGridNonNormalizedCell")){
_3a3[i]=n.firstChild.offsetHeight;
h=Math.max(h,_3a3[i]);
}
}
h=(h>=0?h:0);
if((has("mozilla")||has("ie")>8)&&h){
h++;
}
}
for(i=0;(n=_3a2[i]);i++){
if(_3a3[i]!=h){
n.firstChild.style.height=h+"px";
}
}
},resetHeaderNodeHeight:function(){
for(var i=0,v,n;(v=this.views[i]);i++){
n=v.headerContentNode.firstChild;
if(n){
n.style.height="";
}
}
},renormalizeRow:function(_3a4){
var _3a5=[];
for(var i=0,v,n;(v=this.views[i])&&(n=v.getRowNode(_3a4));i++){
n.firstChild.style.height="";
_3a5.push(n);
}
this.normalizeRowNodeHeights(_3a5);
},getViewWidth:function(_3a6){
return this.views[_3a6].getWidth()||this.defaultWidth;
},measureHeader:function(){
this.resetHeaderNodeHeight();
this.forEach(function(_3a7){
_3a7.headerContentNode.style.height="";
});
var h=0;
this.forEach(function(_3a8){
h=Math.max(_3a8.headerNode.offsetHeight,h);
});
return h;
},measureContent:function(){
var h=0;
this.forEach(function(_3a9){
h=Math.max(_3a9.domNode.offsetHeight,h);
});
return h;
},findClient:function(_3aa){
var c=this.grid.elasticView||-1;
if(c<0){
for(var i=1,v;(v=this.views[i]);i++){
if(v.viewWidth){
for(i=1;(v=this.views[i]);i++){
if(!v.viewWidth){
c=i;
break;
}
}
break;
}
}
}
if(c<0){
c=Math.floor(this.views.length/2);
}
return c;
},arrange:function(l,w){
var i,v,vw,len=this.views.length,self=this;
var c=(w<=0?len:this.findClient());
var _3ab=function(v,l){
var ds=v.domNode.style;
var hs=v.headerNode.style;
if(!self.grid.isLeftToRight()){
ds.right=l+"px";
if(has("ff")<4){
hs.right=l+v.getScrollbarWidth()+"px";
}else{
hs.right=l+"px";
}
if(!has("webkit")){
hs.width=parseInt(hs.width,10)-v.getScrollbarWidth()+"px";
}
}else{
ds.left=l+"px";
hs.left=l+"px";
}
ds.top=0+"px";
hs.top=0;
};
for(i=0;(v=this.views[i])&&(i<c);i++){
vw=this.getViewWidth(i);
v.setSize(vw,0);
_3ab(v,l);
if(v.headerContentNode&&v.headerContentNode.firstChild){
vw=v.getColumnsWidth()+v.getScrollbarWidth();
}else{
vw=v.domNode.offsetWidth;
}
l+=vw;
}
i++;
var r=w;
for(var j=len-1;(v=this.views[j])&&(i<=j);j--){
vw=this.getViewWidth(j);
v.setSize(vw,0);
vw=v.domNode.offsetWidth;
r-=vw;
_3ab(v,r);
}
if(c<len){
v=this.views[c];
vw=Math.max(1,r-l);
v.setSize(vw+"px",0);
_3ab(v,l);
}
return l;
},renderRow:function(_3ac,_3ad,_3ae){
var _3af=[];
for(var i=0,v,n,_3b0;(v=this.views[i])&&(n=_3ad[i]);i++){
_3b0=v.renderRow(_3ac);
n.appendChild(_3b0);
_3af.push(_3b0);
}
if(!_3ae){
this.normalizeRowNodeHeights(_3af);
}
},rowRemoved:function(_3b1){
this.onEach("rowRemoved",[_3b1]);
},updateRow:function(_3b2,_3b3){
for(var i=0,v;v=this.views[i];i++){
v.updateRow(_3b2);
}
if(!_3b3){
this.renormalizeRow(_3b2);
}
},updateRowStyles:function(_3b4){
this.onEach("updateRowStyles",[_3b4]);
},setScrollTop:function(_3b5){
var top=_3b5;
for(var i=0,v;v=this.views[i];i++){
top=v.setScrollTop(_3b5);
if(has("ie")&&v.headerNode&&v.scrollboxNode){
v.headerNode.scrollLeft=v.scrollboxNode.scrollLeft;
}
}
return top;
},getFirstScrollingView:function(){
for(var i=0,v;(v=this.views[i]);i++){
if(v.hasHScrollbar()||v.hasVScrollbar()){
return v;
}
}
return null;
}});
});
},"dijit/_OnDijitClickMixin":function(){
define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_3b6,keys,_3b7,has,_3b8,win,_3b9){
var ret=_3b7("dijit._OnDijitClickMixin",null,{connect:function(obj,_3ba,_3bb){
return this.inherited(arguments,[obj,_3ba=="ondijitclick"?_3b9:_3ba,_3bb]);
}});
ret.a11yclick=_3b9;
return ret;
});
},"dojox/grid/util":function(){
define("dojox/grid/util",["../main","dojo/_base/lang","dojo/dom"],function(_3bc,lang,dom){
var dgu=lang.getObject("grid.util",true,_3bc);
dgu.na="...";
dgu.rowIndexTag="gridRowIndex";
dgu.gridViewTag="gridView";
dgu.fire=function(ob,ev,args){
var fn=ob&&ev&&ob[ev];
return fn&&(args?fn.apply(ob,args):ob[ev]());
};
dgu.setStyleHeightPx=function(_3bd,_3be){
if(_3be>=0){
var s=_3bd.style;
var v=_3be+"px";
if(_3bd&&s["height"]!=v){
s["height"]=v;
}
}
};
dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];
dgu.keyEvents=["keyup","keydown","keypress"];
dgu.funnelEvents=function(_3bf,_3c0,_3c1,_3c2){
var evts=(_3c2?_3c2:dgu.mouseEvents.concat(dgu.keyEvents));
for(var i=0,l=evts.length;i<l;i++){
_3c0.connect(_3bf,"on"+evts[i],_3c1);
}
};
dgu.removeNode=function(_3c3){
_3c3=dom.byId(_3c3);
_3c3&&_3c3.parentNode&&_3c3.parentNode.removeChild(_3c3);
return _3c3;
};
dgu.arrayCompare=function(inA,inB){
for(var i=0,l=inA.length;i<l;i++){
if(inA[i]!=inB[i]){
return false;
}
}
return (inA.length==inB.length);
};
dgu.arrayInsert=function(_3c4,_3c5,_3c6){
if(_3c4.length<=_3c5){
_3c4[_3c5]=_3c6;
}else{
_3c4.splice(_3c5,0,_3c6);
}
};
dgu.arrayRemove=function(_3c7,_3c8){
_3c7.splice(_3c8,1);
};
dgu.arraySwap=function(_3c9,inI,inJ){
var _3ca=_3c9[inI];
_3c9[inI]=_3c9[inJ];
_3c9[inJ]=_3ca;
};
return dgu;
});
},"dijit/a11yclick":function(){
define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window"],function(on,_3cb,keys,_3cc,has,_3cd,win){
var _3ce=null;
if(has("dom-addeventlistener")){
win.doc.addEventListener("keydown",function(evt){
_3ce=evt.target;
},true);
}else{
(function(){
var _3cf=function(evt){
_3ce=evt.srcElement;
};
win.doc.attachEvent("onkeydown",_3cf);
_3cd.addOnWindowUnload(function(){
win.doc.detachEvent("onkeydown",_3cf);
});
})();
}
function _3d0(e){
return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;
};
return function(node,_3d1){
if(/input|button/i.test(node.nodeName)){
return on(node,"click",_3d1);
}else{
var _3d2=[on(node,"keydown",function(e){
if(_3d0(e)){
_3ce=e.target;
e.preventDefault();
}
}),on(node,"keyup",function(e){
if(_3d0(e)&&e.target==_3ce){
_3ce=null;
on.emit(e.target,"click",{cancelable:true,bubbles:true});
}
}),on(node,"click",function(e){
_3d1.call(this,e);
})];
if(has("touch")){
var _3d3;
_3d2.push(on(node,"touchend",function(e){
var _3d4=e.target;
_3d3=setTimeout(function(){
_3d3=null;
on.emit(_3d4,"click",{cancelable:true,bubbles:true});
},600);
}),on(node,"click",function(e){
if(_3d3){
clearTimeout(_3d3);
}
}));
}
return {remove:function(){
_3cb.forEach(_3d2,function(h){
h.remove();
});
if(_3d3){
clearTimeout(_3d3);
_3d3=null;
}
}};
}
};
return ret;
});
},"dijit/hccss":function(){
define(["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_3d5,has,_3d6,win){
_3d6(90,function(){
if(has("highcontrast")){
_3d5.add(win.body(),"dijit_a11y");
}
});
return has;
});
},"dojox/grid/cells":function(){
define("dojox/grid/cells",["../main","./cells/_base"],function(_3d7){
return _3d7.grid.cells;
});
},"dijit/_TemplatedMixin":function(){
define(["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_3d8,_3d9,_3da,_3db,_3dc,_3dd,_3de,has,_3df){
var _3e0=_3dd("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){
this._attachPoints=[];
this._attachEvents=[];
},_stringRepl:function(tmpl){
var _3e1=this.declaredClass,_3e2=this;
return _3da.substitute(tmpl,this,function(_3e3,key){
if(key.charAt(0)=="!"){
_3e3=lang.getObject(key.substr(1),false,_3e2);
}
if(typeof _3e3=="undefined"){
throw new Error(_3e1+" template:"+key);
}
if(_3e3==null){
return "";
}
return key.charAt(0)=="!"?_3e3:_3e3.toString().replace(/"/g,"&quot;");
},this);
},buildRendering:function(){
if(!this.templateString){
this.templateString=_3db(this.templatePath,{sanitize:true});
}
var _3e4=_3e0.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);
var node;
if(lang.isString(_3e4)){
node=_3de.toDom(this._stringRepl(_3e4),this.ownerDocument);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_3e4);
}
}else{
node=_3e4.cloneNode(true);
}
this.domNode=node;
this.inherited(arguments);
this._attachTemplateNodes(node,function(n,p){
return n.getAttribute(p);
});
this._beforeFillContent();
this._fillContent(this.srcNodeRef);
},_beforeFillContent:function(){
},_fillContent:function(_3e5){
var dest=this.containerNode;
if(_3e5&&dest){
while(_3e5.hasChildNodes()){
dest.appendChild(_3e5.firstChild);
}
}
},_attachTemplateNodes:function(_3e6,_3e7){
var _3e8=lang.isArray(_3e6)?_3e6:(_3e6.all||_3e6.getElementsByTagName("*"));
var x=lang.isArray(_3e6)?0:-1;
for(;x<0||_3e8[x];x++){
var _3e9=(x==-1)?_3e6:_3e8[x];
if(this.widgetsInTemplate&&(_3e7(_3e9,"dojoType")||_3e7(_3e9,"data-dojo-type"))){
continue;
}
var _3ea=_3e7(_3e9,"dojoAttachPoint")||_3e7(_3e9,"data-dojo-attach-point");
if(_3ea){
var _3eb,_3ec=_3ea.split(/\s*,\s*/);
while((_3eb=_3ec.shift())){
if(lang.isArray(this[_3eb])){
this[_3eb].push(_3e9);
}else{
this[_3eb]=_3e9;
}
this._attachPoints.push(_3eb);
}
}
var _3ed=_3e7(_3e9,"dojoAttachEvent")||_3e7(_3e9,"data-dojo-attach-event");
if(_3ed){
var _3ee,_3ef=_3ed.split(/\s*,\s*/);
var trim=lang.trim;
while((_3ee=_3ef.shift())){
if(_3ee){
var _3f0=null;
if(_3ee.indexOf(":")!=-1){
var _3f1=_3ee.split(":");
_3ee=trim(_3f1[0]);
_3f0=trim(_3f1[1]);
}else{
_3ee=trim(_3ee);
}
if(!_3f0){
_3f0=_3ee;
}
this._attachEvents.push(this.connect(_3e9,_3d8[_3ee]||_3ee,_3f0));
}
}
}
}
},destroyRendering:function(){
_3dc.forEach(this._attachPoints,function(_3f2){
delete this[_3f2];
},this);
this._attachPoints=[];
_3dc.forEach(this._attachEvents,this.disconnect,this);
this._attachEvents=[];
this.inherited(arguments);
}});
_3e0._templateCache={};
_3e0.getCachedTemplate=function(_3f3,_3f4,doc){
var _3f5=_3e0._templateCache;
var key=_3f3;
var _3f6=_3f5[key];
if(_3f6){
try{
if(!_3f6.ownerDocument||_3f6.ownerDocument==(doc||document)){
return _3f6;
}
}
catch(e){
}
_3de.destroy(_3f6);
}
_3f3=_3da.trim(_3f3);
if(_3f4||_3f3.match(/\$\{([^\}]+)\}/g)){
return (_3f5[key]=_3f3);
}else{
var node=_3de.toDom(_3f3,doc);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_3f3);
}
return (_3f5[key]=node);
}
};
if(has("ie")){
_3df.addOnWindowUnload(function(){
var _3f7=_3e0._templateCache;
for(var key in _3f7){
var _3f8=_3f7[key];
if(typeof _3f8=="object"){
_3de.destroy(_3f8);
}
delete _3f7[key];
}
});
}
lang.extend(_3d9,{dojoAttachEvent:"",dojoAttachPoint:""});
return _3e0;
});
},"dojox/html/metrics":function(){
define("dojox/html/metrics",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_3f9,lang,has,_3fa,_3fb,_3fc,_3fd){
var dhm=lang.getObject("dojox.html.metrics",true);
var _3fe=lang.getObject("dojox");
dhm.getFontMeasurements=function(){
var _3ff={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};
if(has("ie")){
_3fc.doc.documentElement.style.fontSize="100%";
}
var div=_3fc.doc.createElement("div");
var ds=div.style;
ds.position="absolute";
ds.left="-100px";
ds.top="0";
ds.width="30px";
ds.height="1000em";
ds.borderWidth="0";
ds.margin="0";
ds.padding="0";
ds.outline="0";
ds.lineHeight="1";
ds.overflow="hidden";
_3fc.body().appendChild(div);
for(var p in _3ff){
ds.fontSize=p;
_3ff[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;
}
_3fc.body().removeChild(div);
div=null;
return _3ff;
};
var _400=null;
dhm.getCachedFontMeasurements=function(_401){
if(_401||!_400){
_400=dhm.getFontMeasurements();
}
return _400;
};
var _402=null,_403={};
dhm.getTextBox=function(text,_404,_405){
var m,s;
if(!_402){
m=_402=_3fc.doc.createElement("div");
var c=_3fc.doc.createElement("div");
c.appendChild(m);
s=c.style;
s.overflow="scroll";
s.position="absolute";
s.left="0px";
s.top="-10000px";
s.width="1px";
s.height="1px";
s.visibility="hidden";
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
_3fc.body().appendChild(c);
}else{
m=_402;
}
m.className="";
s=m.style;
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
if(arguments.length>1&&_404){
for(var i in _404){
if(i in _403){
continue;
}
s[i]=_404[i];
}
}
if(arguments.length>2&&_405){
m.className=_405;
}
m.innerHTML=text;
var box=_3fd.position(m);
box.w=m.parentNode.scrollWidth;
return box;
};
var _406={w:16,h:16};
dhm.getScrollbar=function(){
return {w:_406.w,h:_406.h};
};
dhm._fontResizeNode=null;
dhm.initOnFontResize=function(_407){
var f=dhm._fontResizeNode=_3fc.doc.createElement("iframe");
var fs=f.style;
fs.position="absolute";
fs.width="5em";
fs.height="10em";
fs.top="-10000px";
fs.display="none";
if(has("ie")){
f.onreadystatechange=function(){
if(f.contentWindow.document.readyState=="complete"){
f.onresize=f.contentWindow.parent[_3fe._scopeName].html.metrics._fontresize;
}
};
}else{
f.onload=function(){
f.contentWindow.onresize=f.contentWindow.parent[_3fe._scopeName].html.metrics._fontresize;
};
}
f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");
_3fc.body().appendChild(f);
dhm.initOnFontResize=function(){
};
};
dhm.onFontResize=function(){
};
dhm._fontresize=function(){
dhm.onFontResize();
};
_3fb.addOnUnload(function(){
var f=dhm._fontResizeNode;
if(f){
if(has("ie")&&f.onresize){
f.onresize=null;
}else{
if(f.contentWindow&&f.contentWindow.onresize){
f.contentWindow.onresize=null;
}
}
dhm._fontResizeNode=null;
}
});
_3fa(function(){
try{
var n=_3fc.doc.createElement("div");
n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";
_3fc.body().appendChild(n);
_406.w=n.offsetWidth-n.clientWidth;
_406.h=n.offsetHeight-n.clientHeight;
_3fc.body().removeChild(n);
delete n;
}
catch(e){
}
if("fontSizeWatch" in _3f9.config&&!!_3f9.config.fontSizeWatch){
dhm.initOnFontResize();
}
});
return dhm;
});
},"dojox/grid/_Builder":function(){
define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html"],function(_408,_409,lang,win,_40a,has,_40b,_40c,_40d,util,html){
var dg=_408.grid;
var _40e=function(td){
return td.cellIndex>=0?td.cellIndex:_409.indexOf(td.parentNode.cells,td);
};
var _40f=function(tr){
return tr.rowIndex>=0?tr.rowIndex:_409.indexOf(tr.parentNode.childNodes,tr);
};
var _410=function(_411,_412){
return _411&&((_411.rows||0)[_412]||_411.childNodes[_412]);
};
var _413=function(node){
for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){
}
return n;
};
var _414=function(_415,_416){
for(var n=_415;n&&_416(n);n=n.parentNode){
}
return n;
};
var _417=function(_418){
var name=_418.toUpperCase();
return function(node){
return node.tagName!=name;
};
};
var _419=util.rowIndexTag;
var _41a=util.gridViewTag;
var _41b=dg._Builder=lang.extend(function(view){
if(view){
this.view=view;
this.grid=view.grid;
}
},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){
var html=[this._table];
if(this.view.viewWidth){
html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));
}
html.push(">");
return html;
},generateCellMarkup:function(_41c,_41d,_41e,_41f){
var _420=[],html;
if(_41f){
var _421=_41c.index!=_41c.grid.getSortIndex()?"":_41c.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";
if(!_41c.id){
_41c.id=this.grid.id+"Hdr"+_41c.index;
}
html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_421,"id=\"",_41c.id,"\""];
}else{
var _422=this.grid.editable&&!_41c.editable?"aria-readonly=\"true\"":"";
html=["<td tabIndex=\"-1\" role=\"gridcell\"",_422];
}
if(_41c.colSpan){
html.push(" colspan=\"",_41c.colSpan,"\"");
}
if(_41c.rowSpan){
html.push(" rowspan=\"",_41c.rowSpan,"\"");
}
html.push(" class=\"dojoxGridCell ");
if(_41c.classes){
html.push(_41c.classes," ");
}
if(_41e){
html.push(_41e," ");
}
_420.push(html.join(""));
_420.push("");
html=["\" idx=\"",_41c.index,"\" style=\""];
if(_41d&&_41d[_41d.length-1]!=";"){
_41d+=";";
}
html.push(_41c.styles,_41d||"",_41c.hidden?"display:none;":"");
if(_41c.unitWidth){
html.push("width:",_41c.unitWidth,";");
}
_420.push(html.join(""));
_420.push("");
html=["\""];
if(_41c.attrs){
html.push(" ",_41c.attrs);
}
html.push(">");
_420.push(html.join(""));
_420.push("");
_420.push(_41f?"</th>":"</td>");
return _420;
},isCellNode:function(_423){
return Boolean(_423&&_423!=win.doc&&html.attr(_423,"idx"));
},getCellNodeIndex:function(_424){
return _424?Number(html.attr(_424,"idx")):-1;
},getCellNode:function(_425,_426){
for(var i=0,row;((row=_410(_425.firstChild,i))&&row.cells);i++){
for(var j=0,cell;(cell=row.cells[j]);j++){
if(this.getCellNodeIndex(cell)==_426){
return cell;
}
}
}
return null;
},findCellTarget:function(_427,_428){
var n=_427;
while(n&&(!this.isCellNode(n)||(n.offsetParent&&_41a in n.offsetParent.parentNode&&n.offsetParent.parentNode[_41a]!=this.view.id))&&(n!=_428)){
n=n.parentNode;
}
return n!=_428?n:null;
},baseDecorateEvent:function(e){
e.dispatch="do"+e.type;
e.grid=this.grid;
e.sourceView=this.view;
e.cellNode=this.findCellTarget(e.target,e.rowNode);
e.cellIndex=this.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
},findTarget:function(_429,_42a){
var n=_429;
while(n&&(n!=this.domNode)&&(!(_42a in n)||(_41a in n&&n[_41a]!=this.view.id))){
n=n.parentNode;
}
return (n!=this.domNode)?n:null;
},findRowTarget:function(_42b){
return this.findTarget(_42b,_419);
},isIntraNodeEvent:function(e){
try{
return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));
}
catch(x){
return false;
}
},isIntraRowEvent:function(e){
try{
var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);
return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);
}
catch(x){
return false;
}
},dispatchEvent:function(e){
if(e.dispatch in this){
return this[e.dispatch](e);
}
return false;
},domouseover:function(e){
if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){
this.lastOverCellNode=e.cellNode;
this.grid.onMouseOver(e);
}
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){
this.lastOverCellNode=null;
this.grid.onMouseOut(e);
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}
},domousedown:function(e){
if(e.cellNode){
this.grid.onMouseDown(e);
}
this.grid.onMouseDownRow(e);
}});
var _42c=dg._ContentBuilder=lang.extend(function(view){
_41b.call(this,view);
},_41b.prototype,{update:function(){
this.prepareHtml();
},prepareHtml:function(){
var _42d=this.grid.get,_42e=this.view.structure.cells;
for(var j=0,row;(row=_42e[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
cell.get=cell.get||(cell.value==undefined)&&_42d;
cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);
if(!this.grid.editable&&cell.editable){
this.grid.editable=true;
}
}
}
},generateHtml:function(_42f,_430){
var html=this.getTableArray(),v=this.view,_431=v.structure.cells,item=this.grid.getItem(_430);
util.fire(this.view,"onBeforeRow",[_430,_431]);
for(var j=0,row;(row=_431[j]);j++){
if(row.hidden||row.header){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){
m=cell.markup;
cc=cell.customClasses=[];
cs=cell.customStyles=[];
m[5]=cell.format(_430,item);
m[1]=cc.join(" ");
m[3]=cs.join(";");
html.push.apply(html,m);
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},decorateEvent:function(e){
e.rowNode=this.findRowTarget(e.target);
if(!e.rowNode){
return false;
}
e.rowIndex=e.rowNode[_419];
this.baseDecorateEvent(e);
e.cell=this.grid.getCell(e.cellIndex);
return true;
}});
var _432=dg._HeaderBuilder=lang.extend(function(view){
this.moveable=null;
_41b.call(this,view);
},_41b.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){
if(this.tableMap){
this.tableMap.mapRows(this.view.structure.cells);
}else{
this.tableMap=new dg._TableMap(this.view.structure.cells);
}
},generateHtml:function(_433,_434){
var html=this.getTableArray(),_435=this.view.structure.cells;
util.fire(this.view,"onBeforeRow",[-1,_435]);
for(var j=0,row;(row=_435[j]);j++){
if(row.hidden){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,_436;(cell=row[i]);i++){
cell.customClasses=[];
cell.customStyles=[];
if(this.view.simpleStructure){
if(cell.draggable){
if(cell.headerClasses){
if(cell.headerClasses.indexOf("dojoDndItem")==-1){
cell.headerClasses+=" dojoDndItem";
}
}else{
cell.headerClasses="dojoDndItem";
}
}
if(cell.attrs){
if(cell.attrs.indexOf("dndType='gridColumn_")==-1){
cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";
}
}else{
cell.attrs="dndType='gridColumn_"+this.grid.id+"'";
}
}
_436=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);
_436[5]=(_434!=undefined?_434:_433(cell));
_436[3]=cell.customStyles.join(";");
_436[1]=cell.customClasses.join(" ");
html.push(_436.join(""));
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},getCellX:function(e){
var n,x=e.layerX;
if(has("mozilla")||has("ie")>=9){
n=_414(e.target,_417("th"));
x-=(n&&n.offsetLeft)||0;
var t=e.sourceView.getScrollbarWidth();
if(!this.grid.isLeftToRight()){
table=_414(n,_417("table"));
x-=(table&&table.offsetLeft)||0;
}
}
n=_414(e.target,function(){
if(!n||n==e.cellNode){
return false;
}
x+=(n.offsetLeft<0?0:n.offsetLeft);
return true;
});
return x;
},decorateEvent:function(e){
this.baseDecorateEvent(e);
e.rowIndex=-1;
e.cellX=this.getCellX(e);
return true;
},prepareResize:function(e,mod){
do{
var i=e.cellIndex;
e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);
e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);
}while(e.cellNode&&e.cellNode.style.display=="none");
return Boolean(e.cellNode);
},canResize:function(e){
if(!e.cellNode||e.cellNode.colSpan>1){
return false;
}
var cell=this.grid.getCell(e.cellIndex);
return !cell.noresize&&cell.canResize();
},overLeftResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);
}
var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);
return t;
},overRightResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);
}
return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);
},domousemove:function(e){
if(!this.moveable){
var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));
if(c&&!this.canResize(e)){
c="dojoxGridColNoResize";
}
html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));
html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));
if(c){
_40a.stop(e);
}
}
},domousedown:function(e){
if(!this.moveable){
if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){
this.beginColumnResize(e);
}else{
this.grid.onMouseDown(e);
this.grid.onMouseOverRow(e);
}
}
},doclick:function(e){
if(this._skipBogusClicks){
_40a.stop(e);
return true;
}
return false;
},colResizeSetup:function(e,_437){
var _438=html.contentBox(e.sourceView.headerNode);
if(_437){
this.lineDiv=document.createElement("div");
var vw=html.position(e.sourceView.headerNode,true);
var _439=html.contentBox(e.sourceView.domNode);
var l=e.pageX;
if(!this.grid.isLeftToRight()&&has("ie")<8){
l-=_40d.getScrollbar().w;
}
html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_439.h+_438.h)+"px"});
html.addClass(this.lineDiv,"dojoxGridResizeColLine");
this.lineDiv._origLeft=l;
win.body().appendChild(this.lineDiv);
}
var _43a=[],_43b=this.tableMap.findOverlappingNodes(e.cellNode);
for(var i=0,cell;(cell=_43b[i]);i++){
_43a.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});
}
var view=e.sourceView;
var adj=this.grid.isLeftToRight()?1:-1;
var _43c=e.grid.views.views;
var _43d=[];
for(var j=view.idx+adj,_43e;(_43e=_43c[j]);j=j+adj){
_43d.push({node:_43e.headerNode,left:window.parseInt(_43e.headerNode.style.left)});
}
var _43f=view.headerContentNode.firstChild;
var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_438.w,table:_43f,tw:html.contentBox(_43f).w,spanners:_43a,followers:_43d};
return drag;
},beginColumnResize:function(e){
this.moverDiv=document.createElement("div");
html.style(this.moverDiv,{position:"absolute",left:0});
win.body().appendChild(this.moverDiv);
html.addClass(this.grid.domNode,"dojoxGridColumnResizing");
var m=(this.moveable=new _40c(this.moverDiv));
var drag=this.colResizeSetup(e,true);
m.onMove=lang.hitch(this,"doResizeColumn",drag);
_40b.connect(m,"onMoveStop",lang.hitch(this,function(){
this.endResizeColumn(drag);
if(drag.node.releaseCapture){
drag.node.releaseCapture();
}
this.moveable.destroy();
delete this.moveable;
this.moveable=null;
html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");
}));
if(e.cellNode.setCapture){
e.cellNode.setCapture();
}
m.onMouseDown(e);
},doResizeColumn:function(_440,_441,_442){
var _443=_442.l;
var data={deltaX:_443,w:_440.w+(this.grid.isLeftToRight()?_443:-_443),vw:_440.vw+_443,tw:_440.tw+_443};
this.dragRecord={inDrag:_440,mover:_441,leftTop:_442};
if(data.w>=this.minColWidth){
if(!_441){
this.doResizeNow(_440,data);
}else{
html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");
}
}
},endResizeColumn:function(_444){
if(this.dragRecord){
var _445=this.dragRecord.leftTop;
var _446=this.grid.isLeftToRight()?_445.l:-_445.l;
_446+=Math.max(_444.w+_446,this.minColWidth)-(_444.w+_446);
if(has("webkit")&&_444.spanners.length){
_446+=html._getPadBorderExtents(_444.spanners[0].node).w;
}
var data={deltaX:_446,w:_444.w+_446,vw:_444.vw+_446,tw:_444.tw+_446};
this.doResizeNow(_444,data);
delete this.dragRecord;
}
html.destroy(this.lineDiv);
html.destroy(this.moverDiv);
html.destroy(this.moverDiv);
delete this.moverDiv;
this._skipBogusClicks=true;
_444.view.update();
this._skipBogusClicks=false;
this.grid.onResizeColumn(_444.index);
},doResizeNow:function(_447,data){
_447.view.convertColPctToFixed();
if(_447.view.flexCells&&!_447.view.testFlexCells()){
var t=_413(_447.node);
if(t){
(t.style.width="");
}
}
var i,s,sw,f,fl;
for(i=0;(s=_447.spanners[i]);i++){
sw=s.width+data.deltaX;
if(sw>0){
s.node.style.width=sw+"px";
_447.view.setColWidth(s.index,sw);
}
}
if(this.grid.isLeftToRight()||!has("ie")){
for(i=0;(f=_447.followers[i]);i++){
fl=f.left+data.deltaX;
f.node.style.left=fl+"px";
}
}
_447.node.style.width=data.w+"px";
_447.view.setColWidth(_447.index,data.w);
_447.view.headerNode.style.width=data.vw+"px";
_447.view.setColumnsWidth(data.tw);
if(!this.grid.isLeftToRight()){
_447.view.headerNode.scrollLeft=_447.scrollLeft+data.deltaX;
}
}});
dg._TableMap=lang.extend(function(rows){
this.mapRows(rows);
},{map:null,mapRows:function(_448){
var _449=_448.length;
if(!_449){
return;
}
this.map=[];
var row;
for(var k=0;(row=_448[k]);k++){
this.map[k]=[];
}
for(var j=0;(row=_448[j]);j++){
for(var i=0,x=0,cell,_44a,_44b;(cell=row[i]);i++){
while(this.map[j][x]){
x++;
}
this.map[j][x]={c:i,r:j};
_44b=cell.rowSpan||1;
_44a=cell.colSpan||1;
for(var y=0;y<_44b;y++){
for(var s=0;s<_44a;s++){
this.map[j+y][x+s]=this.map[j][x];
}
}
x+=_44a;
}
}
},dumpMap:function(){
for(var j=0,row,h="";(row=this.map[j]);j++,h=""){
for(var i=0,cell;(cell=row[i]);i++){
h+=cell.r+","+cell.c+"   ";
}
}
},getMapCoords:function(_44c,_44d){
for(var j=0,row;(row=this.map[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
if(cell.c==_44d&&cell.r==_44c){
return {j:j,i:i};
}
}
}
return {j:-1,i:-1};
},getNode:function(_44e,_44f,_450){
var row=_44e&&_44e.rows[_44f];
return row&&row.cells[_450];
},_findOverlappingNodes:function(_451,_452,_453){
var _454=[];
var m=this.getMapCoords(_452,_453);
for(var j=0,row;(row=this.map[j]);j++){
if(j==m.j){
continue;
}
var rw=row[m.i];
var n=(rw?this.getNode(_451,rw.r,rw.c):null);
if(n){
_454.push(n);
}
}
return _454;
},findOverlappingNodes:function(_455){
return this._findOverlappingNodes(_413(_455),_40f(_455.parentNode),_40e(_455));
}});
return {_Builder:_41b,_HeaderBuilder:_432,_ContentBuilder:_42c};
});
},"dojox/grid/_Scroller":function(){
define("dojox/grid/_Scroller",["dijit/registry","dojo/_base/declare","dojo/_base/lang","./util","dojo/_base/html"],function(_456,_457,lang,util,html){
var _458=function(_459){
var i=0,n,p=_459.parentNode;
while((n=p.childNodes[i++])){
if(n==_459){
return i-1;
}
}
return -1;
};
var _45a=function(_45b){
if(!_45b){
return;
}
dojo.forEach(_456.toArray(),function(w){
if(w.domNode&&html.isDescendant(w.domNode,_45b,true)){
w.destroy();
}
});
};
var _45c=function(_45d){
var node=html.byId(_45d);
return (node&&node.tagName?node.tagName.toLowerCase():"");
};
var _45e=function(_45f,_460){
var _461=[];
var i=0,n;
while((n=_45f.childNodes[i])){
i++;
if(_45c(n)==_460){
_461.push(n);
}
}
return _461;
};
var _462=function(_463){
return _45e(_463,"div");
};
return _457("dojox.grid._Scroller",null,{constructor:function(_464){
this.setContentNodes(_464);
this.pageHeights=[];
this.pageNodes=[];
this.stack=[];
},rowCount:0,defaultRowHeight:32,keepRows:100,contentNode:null,scrollboxNode:null,defaultPageHeight:0,keepPages:10,pageCount:0,windowHeight:0,firstVisibleRow:0,lastVisibleRow:0,averageRowHeight:0,page:0,pageTop:0,init:function(_465,_466,_467){
switch(arguments.length){
case 3:
this.rowsPerPage=_467;
case 2:
this.keepRows=_466;
case 1:
this.rowCount=_465;
default:
break;
}
this.defaultPageHeight=(this.grid.rowHeight>0?this.grid.rowHeight:this.defaultRowHeight)*this.rowsPerPage;
this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);
this.setKeepInfo(this.keepRows);
this.invalidate();
if(this.scrollboxNode){
this.scrollboxNode.scrollTop=0;
this.scroll(0);
this.scrollboxNode.onscroll=lang.hitch(this,"onscroll");
}
},_getPageCount:function(_468,_469){
return _468?(Math.ceil(_468/_469)||1):0;
},destroy:function(){
this.invalidateNodes();
delete this.contentNodes;
delete this.contentNode;
delete this.scrollboxNode;
},setKeepInfo:function(_46a){
this.keepRows=_46a;
this.keepPages=!this.keepRows?this.keepPages:Math.max(Math.ceil(this.keepRows/this.rowsPerPage),2);
},setContentNodes:function(_46b){
this.contentNodes=_46b;
this.colCount=(this.contentNodes?this.contentNodes.length:0);
this.pageNodes=[];
for(var i=0;i<this.colCount;i++){
this.pageNodes[i]=[];
}
},getDefaultNodes:function(){
return this.pageNodes[0]||[];
},invalidate:function(){
this._invalidating=true;
this.invalidateNodes();
this.pageHeights=[];
this.height=(this.pageCount?(this.pageCount-1)*this.defaultPageHeight+this.calcLastPageHeight():0);
this.resize();
this._invalidating=false;
},updateRowCount:function(_46c){
this.invalidateNodes();
this.rowCount=_46c;
var _46d=this.pageCount;
if(_46d===0){
this.height=1;
}
this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);
if(this.pageCount<_46d){
for(var i=_46d-1;i>=this.pageCount;i--){
this.height-=this.getPageHeight(i);
delete this.pageHeights[i];
}
}else{
if(this.pageCount>_46d){
this.height+=this.defaultPageHeight*(this.pageCount-_46d-1)+this.calcLastPageHeight();
}
}
this.resize();
},pageExists:function(_46e){
return Boolean(this.getDefaultPageNode(_46e));
},measurePage:function(_46f){
if(this.grid.rowHeight){
return ((_46f+1)*this.rowsPerPage>this.rowCount?this.rowCount-_46f*this.rowsPerPage:this.rowsPerPage)*this.grid.rowHeight;
}
var n=this.getDefaultPageNode(_46f);
return (n&&n.innerHTML)?n.offsetHeight:undefined;
},positionPage:function(_470,_471){
for(var i=0;i<this.colCount;i++){
this.pageNodes[i][_470].style.top=_471+"px";
}
},repositionPages:function(_472){
var _473=this.getDefaultNodes();
var last=0;
for(var i=0;i<this.stack.length;i++){
last=Math.max(this.stack[i],last);
}
var n=_473[_472];
var y=(n?this.getPageNodePosition(n)+this.getPageHeight(_472):0);
for(var p=_472+1;p<=last;p++){
n=_473[p];
if(n){
if(this.getPageNodePosition(n)==y){
return;
}
this.positionPage(p,y);
}
y+=this.getPageHeight(p);
}
},installPage:function(_474){
for(var i=0;i<this.colCount;i++){
this.contentNodes[i].appendChild(this.pageNodes[i][_474]);
}
},preparePage:function(_475,_476){
var p=(_476?this.popPage():null);
for(var i=0;i<this.colCount;i++){
var _477=this.pageNodes[i];
var _478=(p===null?this.createPageNode():this.invalidatePageNode(p,_477));
_478.pageIndex=_475;
_477[_475]=_478;
}
},renderPage:function(_479){
var _47a=[];
var i,j;
for(i=0;i<this.colCount;i++){
_47a[i]=this.pageNodes[i][_479];
}
for(i=0,j=_479*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){
this.renderRow(j,_47a);
}
},removePage:function(_47b){
for(var i=0,j=_47b*this.rowsPerPage;i<this.rowsPerPage;i++,j++){
this.removeRow(j);
}
},destroyPage:function(_47c){
for(var i=0;i<this.colCount;i++){
var n=this.invalidatePageNode(_47c,this.pageNodes[i]);
if(n){
html.destroy(n);
}
}
},pacify:function(_47d){
},pacifying:false,pacifyTicks:200,setPacifying:function(_47e){
if(this.pacifying!=_47e){
this.pacifying=_47e;
this.pacify(this.pacifying);
}
},startPacify:function(){
this.startPacifyTicks=new Date().getTime();
},doPacify:function(){
var _47f=(new Date().getTime()-this.startPacifyTicks)>this.pacifyTicks;
this.setPacifying(true);
this.startPacify();
return _47f;
},endPacify:function(){
this.setPacifying(false);
},resize:function(){
if(this.scrollboxNode){
this.windowHeight=this.scrollboxNode.clientHeight;
}
for(var i=0;i<this.colCount;i++){
util.setStyleHeightPx(this.contentNodes[i],Math.max(1,this.height));
}
var _480=(!this._invalidating);
if(!_480){
var ah=this.grid.get("autoHeight");
if(typeof ah=="number"&&ah<=Math.min(this.rowsPerPage,this.rowCount)){
_480=true;
}
}
if(_480){
this.needPage(this.page,this.pageTop);
}
var _481=(this.page<this.pageCount-1)?this.rowsPerPage:((this.rowCount%this.rowsPerPage)||this.rowsPerPage);
var _482=this.getPageHeight(this.page);
this.averageRowHeight=(_482>0&&_481>0)?(_482/_481):0;
},calcLastPageHeight:function(){
if(!this.pageCount){
return 0;
}
var _483=this.pageCount-1;
var _484=((this.rowCount%this.rowsPerPage)||(this.rowsPerPage))*this.defaultRowHeight;
this.pageHeights[_483]=_484;
return _484;
},updateContentHeight:function(inDh){
this.height+=inDh;
this.resize();
},updatePageHeight:function(_485,_486,_487){
if(this.pageExists(_485)){
var oh=this.getPageHeight(_485);
var h=(this.measurePage(_485));
if(h===undefined){
h=oh;
}
this.pageHeights[_485]=h;
if(oh!=h){
this.updateContentHeight(h-oh);
var ah=this.grid.get("autoHeight");
if((typeof ah=="number"&&ah>this.rowCount)||(ah===true&&!_486)){
if(!_487){
this.grid.sizeChange();
}else{
var ns=this.grid.viewsNode.style;
ns.height=parseInt(ns.height)+h-oh+"px";
this.repositionPages(_485);
}
}else{
this.repositionPages(_485);
}
}
return h;
}
return 0;
},rowHeightChanged:function(_488,_489){
this.updatePageHeight(Math.floor(_488/this.rowsPerPage),false,_489);
},invalidateNodes:function(){
while(this.stack.length){
this.destroyPage(this.popPage());
}
},createPageNode:function(){
var p=document.createElement("div");
html.attr(p,"role","presentation");
p.style.position="absolute";
p.style[this.grid.isLeftToRight()?"left":"right"]="0";
return p;
},getPageHeight:function(_48a){
var ph=this.pageHeights[_48a];
return (ph!==undefined?ph:this.defaultPageHeight);
},pushPage:function(_48b){
return this.stack.push(_48b);
},popPage:function(){
return this.stack.shift();
},findPage:function(_48c){
var i=0,h=0;
for(var ph=0;i<this.pageCount;i++,h+=ph){
ph=this.getPageHeight(i);
if(h+ph>=_48c){
break;
}
}
this.page=i;
this.pageTop=h;
},buildPage:function(_48d,_48e,_48f){
this.preparePage(_48d,_48e);
this.positionPage(_48d,_48f);
this.installPage(_48d);
this.renderPage(_48d);
this.pushPage(_48d);
},needPage:function(_490,_491){
var h=this.getPageHeight(_490),oh=h;
if(!this.pageExists(_490)){
this.buildPage(_490,(!this.grid._autoHeight&&this.keepPages&&(this.stack.length>=this.keepPages)),_491);
h=this.updatePageHeight(_490,true);
}else{
this.positionPage(_490,_491);
}
return h;
},onscroll:function(){
this.scroll(this.scrollboxNode.scrollTop);
},scroll:function(_492){
this.grid.scrollTop=_492;
if(this.colCount){
this.startPacify();
this.findPage(_492);
var h=this.height;
var b=this.getScrollBottom(_492);
for(var p=this.page,y=this.pageTop;(p<this.pageCount)&&((b<0)||(y<b));p++){
y+=this.needPage(p,y);
}
this.firstVisibleRow=this.getFirstVisibleRow(this.page,this.pageTop,_492);
this.lastVisibleRow=this.getLastVisibleRow(p-1,y,b);
if(h!=this.height){
this.repositionPages(p-1);
}
this.endPacify();
}
},getScrollBottom:function(_493){
return (this.windowHeight>=0?_493+this.windowHeight:-1);
},processNodeEvent:function(e,_494){
var t=e.target;
while(t&&(t!=_494)&&t.parentNode&&(t.parentNode.parentNode!=_494)){
t=t.parentNode;
}
if(!t||!t.parentNode||(t.parentNode.parentNode!=_494)){
return false;
}
var page=t.parentNode;
e.topRowIndex=page.pageIndex*this.rowsPerPage;
e.rowIndex=e.topRowIndex+_458(t);
e.rowTarget=t;
return true;
},processEvent:function(e){
return this.processNodeEvent(e,this.contentNode);
},renderRow:function(_495,_496){
},removeRow:function(_497){
},getDefaultPageNode:function(_498){
return this.getDefaultNodes()[_498];
},positionPageNode:function(_499,_49a){
},getPageNodePosition:function(_49b){
return _49b.offsetTop;
},invalidatePageNode:function(_49c,_49d){
var p=_49d[_49c];
if(p){
delete _49d[_49c];
this.removePage(_49c,p);
_45a(p);
p.innerHTML="";
}
return p;
},getPageRow:function(_49e){
return _49e*this.rowsPerPage;
},getLastPageRow:function(_49f){
return Math.min(this.rowCount,this.getPageRow(_49f+1))-1;
},getFirstVisibleRow:function(_4a0,_4a1,_4a2){
if(!this.pageExists(_4a0)){
return 0;
}
var row=this.getPageRow(_4a0);
var _4a3=this.getDefaultNodes();
var rows=_462(_4a3[_4a0]);
for(var i=0,l=rows.length;i<l&&_4a1<_4a2;i++,row++){
_4a1+=rows[i].offsetHeight;
}
return (row?row-1:row);
},getLastVisibleRow:function(_4a4,_4a5,_4a6){
if(!this.pageExists(_4a4)){
return 0;
}
var _4a7=this.getDefaultNodes();
var row=this.getLastPageRow(_4a4);
var rows=_462(_4a7[_4a4]);
for(var i=rows.length-1;i>=0&&_4a5>_4a6;i--,row--){
_4a5-=rows[i].offsetHeight;
}
return row+1;
},findTopRow:function(_4a8){
var _4a9=this.getDefaultNodes();
var rows=_462(_4a9[this.page]);
for(var i=0,l=rows.length,t=this.pageTop,h;i<l;i++){
h=rows[i].offsetHeight;
t+=h;
if(t>=_4a8){
this.offset=h-(t-_4a8);
return i+this.page*this.rowsPerPage;
}
}
return -1;
},findScrollTop:function(_4aa){
var _4ab=Math.floor(_4aa/this.rowsPerPage);
var t=0;
var i,l;
for(i=0;i<_4ab;i++){
t+=this.getPageHeight(i);
}
this.pageTop=t;
this.page=_4ab;
this.needPage(_4ab,this.pageTop);
var _4ac=this.getDefaultNodes();
var rows=_462(_4ac[_4ab]);
var r=_4aa-this.rowsPerPage*_4ab;
for(i=0,l=rows.length;i<l&&i<r;i++){
t+=rows[i].offsetHeight;
}
return t;
},dummy:0});
});
},"dojox/grid/_Layout":function(){
define("dojox/grid/_Layout",["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_4ad,_4ae,_4af,lang,_4b0){
return _4ae("dojox.grid._Layout",null,{constructor:function(_4b1){
this.grid=_4b1;
},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_4b2,_4b3,_4b4,_4b5,_4b6){
var _4b7=this.structure[_4b2].cells[0];
var _4b8=this.structure[_4b3].cells[0];
var cell=null;
var _4b9=0;
var _4ba=0;
for(var i=0,c;c=_4b7[i];i++){
if(c.index==_4b4){
_4b9=i;
break;
}
}
cell=_4b7.splice(_4b9,1)[0];
cell.view=this.grid.views.views[_4b3];
for(i=0,c=null;c=_4b8[i];i++){
if(c.index==_4b5){
_4ba=i;
break;
}
}
if(!_4b6){
_4ba+=1;
}
_4b8.splice(_4ba,0,cell);
var _4bb=this.grid.getCell(this.grid.getSortIndex());
if(_4bb){
_4bb._currentlySorted=this.grid.getSortAsc();
}
this.cells=[];
_4b4=0;
var v;
for(i=0;v=this.structure[i];i++){
for(var j=0,cs;cs=v.cells[j];j++){
for(var k=0;c=cs[k];k++){
c.index=_4b4;
this.cells.push(c);
if("_currentlySorted" in c){
var si=_4b4+1;
si*=c._currentlySorted?1:-1;
this.grid.sortInfo=si;
delete c._currentlySorted;
}
_4b4++;
}
}
}
_4af.forEach(this.cells,function(c){
var _4bc=c.markup[2].split(" ");
var _4bd=parseInt(_4bc[1].substring(5));
if(_4bd!=c.index){
_4bc[1]="idx=\""+c.index+"\"";
c.markup[2]=_4bc.join(" ");
}
});
this.grid.setupHeaderMenu();
},setColumnVisibility:function(_4be,_4bf){
var cell=this.cells[_4be];
if(cell.hidden==_4bf){
cell.hidden=!_4bf;
var v=cell.view,w=v.viewWidth;
if(w&&w!="auto"){
v._togglingColumn=_4b0.getMarginBox(cell.getHeaderNode()).w||0;
}
v.update();
return true;
}else{
return false;
}
},addCellDef:function(_4c0,_4c1,_4c2){
var self=this;
var _4c3=function(_4c4){
var w=0;
if(_4c4.colSpan>1){
w=0;
}else{
w=_4c4.width||self._defaultCellProps.width||self.defaultWidth;
if(!isNaN(w)){
w=w+"em";
}
}
return w;
};
var _4c5={grid:this.grid,subrow:_4c0,layoutIndex:_4c1,index:this.cells.length};
if(_4c2&&_4c2 instanceof _4ad.grid.cells._Base){
var _4c6=lang.clone(_4c2);
_4c5.unitWidth=_4c3(_4c6._props);
_4c6=lang.mixin(_4c6,this._defaultCellProps,_4c2._props,_4c5);
return _4c6;
}
var _4c7=_4c2.type||_4c2.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_4ad.grid.cells.Cell;
if(lang.isString(_4c7)){
_4c7=lang.getObject(_4c7);
}
_4c5.unitWidth=_4c3(_4c2);
return new _4c7(lang.mixin({},this._defaultCellProps,_4c2,_4c5));
},addRowDef:function(_4c8,_4c9){
var _4ca=[];
var _4cb=0,_4cc=0,_4cd=true;
for(var i=0,def,cell;(def=_4c9[i]);i++){
cell=this.addCellDef(_4c8,i,def);
_4ca.push(cell);
this.cells.push(cell);
if(_4cd&&cell.relWidth){
_4cb+=cell.relWidth;
}else{
if(cell.width){
var w=cell.width;
if(typeof w=="string"&&w.slice(-1)=="%"){
_4cc+=window.parseInt(w,10);
}else{
if(w=="auto"){
_4cd=false;
}
}
}
}
}
if(_4cb&&_4cd){
_4af.forEach(_4ca,function(cell){
if(cell.relWidth){
cell.width=cell.unitWidth=((cell.relWidth/_4cb)*(100-_4cc))+"%";
}
});
}
return _4ca;
},addRowsDef:function(_4ce){
var _4cf=[];
if(lang.isArray(_4ce)){
if(lang.isArray(_4ce[0])){
for(var i=0,row;_4ce&&(row=_4ce[i]);i++){
_4cf.push(this.addRowDef(i,row));
}
}else{
_4cf.push(this.addRowDef(0,_4ce));
}
}
return _4cf;
},addViewDef:function(_4d0){
this._defaultCellProps=_4d0.defaultCell||{};
if(_4d0.width&&_4d0.width=="auto"){
delete _4d0.width;
}
return lang.mixin({},_4d0,{cells:this.addRowsDef(_4d0.rows||_4d0.cells)});
},setStructure:function(_4d1){
this.fieldIndex=0;
this.cells=[];
var s=this.structure=[];
if(this.grid.rowSelector){
var sel={type:_4ad._scopeName+".grid._RowSelector"};
if(lang.isString(this.grid.rowSelector)){
var _4d2=this.grid.rowSelector;
if(_4d2=="false"){
sel=null;
}else{
if(_4d2!="true"){
sel["width"]=_4d2;
}
}
}else{
if(!this.grid.rowSelector){
sel=null;
}
}
if(sel){
s.push(this.addViewDef(sel));
}
}
var _4d3=function(def){
return ("name" in def||"field" in def||"get" in def);
};
var _4d4=function(def){
if(lang.isArray(def)){
if(lang.isArray(def[0])||_4d3(def[0])){
return true;
}
}
return false;
};
var _4d5=function(def){
return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_4d3(def))));
};
if(lang.isArray(_4d1)){
var _4d6=false;
for(var i=0,st;(st=_4d1[i]);i++){
if(_4d5(st)){
_4d6=true;
break;
}
}
if(!_4d6){
s.push(this.addViewDef({cells:_4d1}));
}else{
for(i=0;(st=_4d1[i]);i++){
if(_4d4(st)){
s.push(this.addViewDef({cells:st}));
}else{
if(_4d5(st)){
s.push(this.addViewDef(st));
}
}
}
}
}else{
if(_4d5(_4d1)){
s.push(this.addViewDef(_4d1));
}
}
this.cellCount=this.cells.length;
this.grid.setupHeaderMenu();
}});
});
},"dojo/dnd/Source":function(){
define(["../_base/array","../_base/connect","../_base/declare","../_base/kernel","../_base/lang","../dom-class","../dom-geometry","../mouse","../ready","../topic","./common","./Selector","./Manager"],function(_4d7,_4d8,_4d9,_4da,lang,_4db,_4dc,_4dd,_4de,_4df,dnd,_4e0,_4e1){
if(!_4da.isAsync){
_4de(0,function(){
var _4e2=["dojo/dnd/AutoSource","dojo/dnd/Target"];
require(_4e2);
});
}
var _4e3=_4d9("dojo.dnd.Source",_4e0,{isSource:true,horizontal:false,copyOnly:false,selfCopy:false,selfAccept:true,skipForm:false,withHandles:false,autoSync:false,delay:0,accept:["text"],generateText:true,constructor:function(node,_4e4){
lang.mixin(this,lang.mixin({},_4e4));
var type=this.accept;
if(type.length){
this.accept={};
for(var i=0;i<type.length;++i){
this.accept[type[i]]=1;
}
}
this.isDragging=false;
this.mouseDown=false;
this.targetAnchor=null;
this.targetBox=null;
this.before=true;
this._lastX=0;
this._lastY=0;
this.sourceState="";
if(this.isSource){
_4db.add(this.node,"dojoDndSource");
}
this.targetState="";
if(this.accept){
_4db.add(this.node,"dojoDndTarget");
}
if(this.horizontal){
_4db.add(this.node,"dojoDndHorizontal");
}
this.topics=[_4df.subscribe("/dnd/source/over",lang.hitch(this,"onDndSourceOver")),_4df.subscribe("/dnd/start",lang.hitch(this,"onDndStart")),_4df.subscribe("/dnd/drop",lang.hitch(this,"onDndDrop")),_4df.subscribe("/dnd/cancel",lang.hitch(this,"onDndCancel"))];
},checkAcceptance:function(_4e5,_4e6){
if(this==_4e5){
return !this.copyOnly||this.selfAccept;
}
for(var i=0;i<_4e6.length;++i){
var type=_4e5.getItem(_4e6[i].id).type;
var flag=false;
for(var j=0;j<type.length;++j){
if(type[j] in this.accept){
flag=true;
break;
}
}
if(!flag){
return false;
}
}
return true;
},copyState:function(_4e7,self){
if(_4e7){
return true;
}
if(arguments.length<2){
self=this==_4e1.manager().target;
}
if(self){
if(this.copyOnly){
return this.selfCopy;
}
}else{
return this.copyOnly;
}
return false;
},destroy:function(){
_4e3.superclass.destroy.call(this);
_4d7.forEach(this.topics,function(t){
t.remove();
});
this.targetAnchor=null;
},onMouseMove:function(e){
if(this.isDragging&&this.targetState=="Disabled"){
return;
}
_4e3.superclass.onMouseMove.call(this,e);
var m=_4e1.manager();
if(!this.isDragging){
if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay)){
var _4e8=this.getSelectedNodes();
if(_4e8.length){
m.startDrag(this,_4e8,this.copyState(dnd.getCopyKeyState(e),true));
}
}
}
if(this.isDragging){
var _4e9=false;
if(this.current){
if(!this.targetBox||this.targetAnchor!=this.current){
this.targetBox=_4dc.position(this.current,true);
}
if(this.horizontal){
_4e9=(e.pageX-this.targetBox.x<this.targetBox.w/2)==_4dc.isBodyLtr(this.current.ownerDocument);
}else{
_4e9=(e.pageY-this.targetBox.y)<(this.targetBox.h/2);
}
}
if(this.current!=this.targetAnchor||_4e9!=this.before){
this._markTargetAnchor(_4e9);
m.canDrop(!this.current||m.source!=this||!(this.current.id in this.selection));
}
}
},onMouseDown:function(e){
if(!this.mouseDown&&this._legalMouseDown(e)&&(!this.skipForm||!dnd.isFormElement(e))){
this.mouseDown=true;
this._lastX=e.pageX;
this._lastY=e.pageY;
_4e3.superclass.onMouseDown.call(this,e);
}
},onMouseUp:function(e){
if(this.mouseDown){
this.mouseDown=false;
_4e3.superclass.onMouseUp.call(this,e);
}
},onDndSourceOver:function(_4ea){
if(this!==_4ea){
this.mouseDown=false;
if(this.targetAnchor){
this._unmarkTargetAnchor();
}
}else{
if(this.isDragging){
var m=_4e1.manager();
m.canDrop(this.targetState!="Disabled"&&(!this.current||m.source!=this||!(this.current.id in this.selection)));
}
}
},onDndStart:function(_4eb,_4ec,copy){
if(this.autoSync){
this.sync();
}
if(this.isSource){
this._changeState("Source",this==_4eb?(copy?"Copied":"Moved"):"");
}
var _4ed=this.accept&&this.checkAcceptance(_4eb,_4ec);
this._changeState("Target",_4ed?"":"Disabled");
if(this==_4eb){
_4e1.manager().overSource(this);
}
this.isDragging=true;
},onDndDrop:function(_4ee,_4ef,copy,_4f0){
if(this==_4f0){
this.onDrop(_4ee,_4ef,copy);
}
this.onDndCancel();
},onDndCancel:function(){
if(this.targetAnchor){
this._unmarkTargetAnchor();
this.targetAnchor=null;
}
this.before=true;
this.isDragging=false;
this.mouseDown=false;
this._changeState("Source","");
this._changeState("Target","");
},onDrop:function(_4f1,_4f2,copy){
if(this!=_4f1){
this.onDropExternal(_4f1,_4f2,copy);
}else{
this.onDropInternal(_4f2,copy);
}
},onDropExternal:function(_4f3,_4f4,copy){
var _4f5=this._normalizedCreator;
if(this.creator){
this._normalizedCreator=function(node,hint){
return _4f5.call(this,_4f3.getItem(node.id).data,hint);
};
}else{
if(copy){
this._normalizedCreator=function(node){
var t=_4f3.getItem(node.id);
var n=node.cloneNode(true);
n.id=dnd.getUniqueId();
return {node:n,data:t.data,type:t.type};
};
}else{
this._normalizedCreator=function(node){
var t=_4f3.getItem(node.id);
_4f3.delItem(node.id);
return {node:node,data:t.data,type:t.type};
};
}
}
this.selectNone();
if(!copy&&!this.creator){
_4f3.selectNone();
}
this.insertNodes(true,_4f4,this.before,this.current);
if(!copy&&this.creator){
_4f3.deleteSelectedNodes();
}
this._normalizedCreator=_4f5;
},onDropInternal:function(_4f6,copy){
var _4f7=this._normalizedCreator;
if(this.current&&this.current.id in this.selection){
return;
}
if(copy){
if(this.creator){
this._normalizedCreator=function(node,hint){
return _4f7.call(this,this.getItem(node.id).data,hint);
};
}else{
this._normalizedCreator=function(node){
var t=this.getItem(node.id);
var n=node.cloneNode(true);
n.id=dnd.getUniqueId();
return {node:n,data:t.data,type:t.type};
};
}
}else{
if(!this.current){
return;
}
this._normalizedCreator=function(node){
var t=this.getItem(node.id);
return {node:node,data:t.data,type:t.type};
};
}
this._removeSelection();
this.insertNodes(true,_4f6,this.before,this.current);
this._normalizedCreator=_4f7;
},onDraggingOver:function(){
},onDraggingOut:function(){
},onOverEvent:function(){
_4e3.superclass.onOverEvent.call(this);
_4e1.manager().overSource(this);
if(this.isDragging&&this.targetState!="Disabled"){
this.onDraggingOver();
}
},onOutEvent:function(){
_4e3.superclass.onOutEvent.call(this);
_4e1.manager().outSource(this);
if(this.isDragging&&this.targetState!="Disabled"){
this.onDraggingOut();
}
},_markTargetAnchor:function(_4f8){
if(this.current==this.targetAnchor&&this.before==_4f8){
return;
}
if(this.targetAnchor){
this._removeItemClass(this.targetAnchor,this.before?"Before":"After");
}
this.targetAnchor=this.current;
this.targetBox=null;
this.before=_4f8;
if(this.targetAnchor){
this._addItemClass(this.targetAnchor,this.before?"Before":"After");
}
},_unmarkTargetAnchor:function(){
if(!this.targetAnchor){
return;
}
this._removeItemClass(this.targetAnchor,this.before?"Before":"After");
this.targetAnchor=null;
this.targetBox=null;
this.before=true;
},_markDndStatus:function(copy){
this._changeState("Source",copy?"Copied":"Moved");
},_legalMouseDown:function(e){
if(e.type!="touchstart"&&!_4dd.isLeft(e)){
return false;
}
if(!this.withHandles){
return true;
}
for(var node=e.target;node&&node!==this.node;node=node.parentNode){
if(_4db.contains(node,"dojoDndHandle")){
return true;
}
if(_4db.contains(node,"dojoDndItem")||_4db.contains(node,"dojoDndIgnore")){
break;
}
}
return false;
}});
return _4e3;
});
},"dijit/_Widget":function(){
define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_4f9,_4fa,_4fb,_4fc,has,_4fd,lang,_4fe,_4ff,_500,_501,_502,_503){
function _504(){
};
function _505(_506){
return function(obj,_507,_508,_509){
if(obj&&typeof _507=="string"&&obj[_507]==_504){
return obj.on(_507.substring(2).toLowerCase(),lang.hitch(_508,_509));
}
return _506.apply(_4fb,arguments);
};
};
_4f9.around(_4fb,"connect",_505);
if(_4fd.connect){
_4f9.around(_4fd,"connect",_505);
}
var _50a=_4fc("dijit._Widget",[_501,_502,_503],{onClick:_504,onDblClick:_504,onKeyDown:_504,onKeyPress:_504,onKeyUp:_504,onMouseDown:_504,onMouseMove:_504,onMouseOut:_504,onMouseOver:_504,onMouseLeave:_504,onMouseEnter:_504,onMouseUp:_504,constructor:function(_50b){
this._toConnect={};
for(var name in _50b){
if(this[name]===_504){
this._toConnect[name.replace(/^on/,"").toLowerCase()]=_50b[name];
delete _50b[name];
}
}
},postCreate:function(){
this.inherited(arguments);
for(var name in this._toConnect){
this.on(name,this._toConnect[name]);
}
delete this._toConnect;
},on:function(type,func){
if(this[this._onMap(type)]===_504){
return _4fb.connect(this.domNode,type.toLowerCase(),this,func);
}
return this.inherited(arguments);
},_setFocusedAttr:function(val){
this._focused=val;
this._set("focused",val);
},setAttribute:function(attr,_50c){
_4fd.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");
this.set(attr,_50c);
},attr:function(name,_50d){
if(_4fa.isDebug){
var _50e=arguments.callee._ach||(arguments.callee._ach={}),_50f=(arguments.callee.caller||"unknown caller").toString();
if(!_50e[_50f]){
_4fd.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_50f,"","2.0");
_50e[_50f]=true;
}
}
var args=arguments.length;
if(args>=2||typeof name==="object"){
return this.set.apply(this,arguments);
}else{
return this.get(name);
}
},getDescendants:function(){
_4fd.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");
return this.containerNode?_4fe("[widgetId]",this.containerNode).map(_500.byNode):[];
},_onShow:function(){
this.onShow();
},onShow:function(){
},onHide:function(){
},onClose:function(){
return true;
}});
if(has("dijit-legacy-requires")){
_4ff(0,function(){
var _510=["dijit/_base"];
require(_510);
});
}
return _50a;
});
},"dijit/_FocusMixin":function(){
define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_511,_512,_513,lang){
lang.extend(_512,{focused:false,onFocus:function(){
},onBlur:function(){
},_onFocus:function(){
this.onFocus();
},_onBlur:function(){
this.onBlur();
}});
return _513("dijit._FocusMixin",null,{_focusManager:_511});
});
},"dijit/focus":function(){
define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_514,_515,dom,_516,_517,_518,lang,on,_519,has,_51a,_51b,win,_51c,a11y,_51d,_51e){
var _51f=_515([_51a,_518],{curNode:null,activeStack:[],constructor:function(){
var _520=lang.hitch(this,function(node){
if(dom.isDescendant(this.curNode,node)){
this.set("curNode",null);
}
if(dom.isDescendant(this.prevNode,node)){
this.set("prevNode",null);
}
});
_514.before(_517,"empty",_520);
_514.before(_517,"destroy",_520);
},registerIframe:function(_521){
return this.registerWin(_521.contentWindow,_521);
},registerWin:function(_522,_523){
var _524=this;
var _525=function(evt){
_524._justMouseDowned=true;
setTimeout(function(){
_524._justMouseDowned=false;
},0);
if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){
return;
}
_524._onTouchNode(_523||evt.target||evt.srcElement,"mouse");
};
var doc=has("ie")?_522.document.documentElement:_522.document;
if(doc){
if(has("ie")){
_522.document.body.attachEvent("onmousedown",_525);
var _526=function(evt){
var tag=evt.srcElement.tagName.toLowerCase();
if(tag=="#document"||tag=="body"){
return;
}
if(a11y.isTabNavigable(evt.srcElement)){
_524._onFocusNode(_523||evt.srcElement);
}else{
_524._onTouchNode(_523||evt.srcElement);
}
};
doc.attachEvent("onfocusin",_526);
var _527=function(evt){
_524._onBlurNode(_523||evt.srcElement);
};
doc.attachEvent("onfocusout",_527);
return {remove:function(){
_522.document.detachEvent("onmousedown",_525);
doc.detachEvent("onfocusin",_526);
doc.detachEvent("onfocusout",_527);
doc=null;
}};
}else{
doc.body.addEventListener("mousedown",_525,true);
doc.body.addEventListener("touchstart",_525,true);
var _528=function(evt){
_524._onFocusNode(_523||evt.target);
};
doc.addEventListener("focus",_528,true);
var _529=function(evt){
_524._onBlurNode(_523||evt.target);
};
doc.addEventListener("blur",_529,true);
return {remove:function(){
doc.body.removeEventListener("mousedown",_525,true);
doc.body.removeEventListener("touchstart",_525,true);
doc.removeEventListener("focus",_528,true);
doc.removeEventListener("blur",_529,true);
doc=null;
}};
}
}
},_onBlurNode:function(node){
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
}
this._clearFocusTimer=setTimeout(lang.hitch(this,function(){
this.set("prevNode",this.curNode);
this.set("curNode",null);
}),0);
if(this._justMouseDowned){
return;
}
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
}
this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){
delete this._clearActiveWidgetsTimer;
this._setStack([]);
}),0);
},_onTouchNode:function(node,by){
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
delete this._clearActiveWidgetsTimer;
}
var _52a=[];
try{
while(node){
var _52b=_516.get(node,"dijitPopupParent");
if(_52b){
node=_51d.byId(_52b).domNode;
}else{
if(node.tagName&&node.tagName.toLowerCase()=="body"){
if(node===win.body()){
break;
}
node=_51c.get(node.ownerDocument).frameElement;
}else{
var id=node.getAttribute&&node.getAttribute("widgetId"),_52c=id&&_51d.byId(id);
if(_52c&&!(by=="mouse"&&_52c.get("disabled"))){
_52a.unshift(id);
}
node=node.parentNode;
}
}
}
}
catch(e){
}
this._setStack(_52a,by);
},_onFocusNode:function(node){
if(!node){
return;
}
if(node.nodeType==9){
return;
}
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
delete this._clearFocusTimer;
}
this._onTouchNode(node);
if(node==this.curNode){
return;
}
this.set("prevNode",this.curNode);
this.set("curNode",node);
},_setStack:function(_52d,by){
var _52e=this.activeStack;
this.set("activeStack",_52d);
for(var _52f=0;_52f<Math.min(_52e.length,_52d.length);_52f++){
if(_52e[_52f]!=_52d[_52f]){
break;
}
}
var _530;
for(var i=_52e.length-1;i>=_52f;i--){
_530=_51d.byId(_52e[i]);
if(_530){
_530._hasBeenBlurred=true;
_530.set("focused",false);
if(_530._focusManager==this){
_530._onBlur(by);
}
this.emit("widget-blur",_530,by);
}
}
for(i=_52f;i<_52d.length;i++){
_530=_51d.byId(_52d[i]);
if(_530){
_530.set("focused",true);
if(_530._focusManager==this){
_530._onFocus(by);
}
this.emit("widget-focus",_530,by);
}
}
},focus:function(node){
if(node){
try{
node.focus();
}
catch(e){
}
}
}});
var _531=new _51f();
_519(function(){
var _532=_531.registerWin(_51c.get(win.doc));
if(has("ie")){
_51b.addOnWindowUnload(function(){
if(_532){
_532.remove();
_532=null;
}
});
}
});
_51e.focus=function(node){
_531.focus(node);
};
for(var attr in _531){
if(!/^_/.test(attr)){
_51e.focus[attr]=typeof _531[attr]=="function"?lang.hitch(_531,attr):_531[attr];
}
}
_531.watch(function(attr,_533,_534){
_51e.focus[attr]=_534;
});
return _531;
});
},"dijit/_Contained":function(){
define(["dojo/_base/declare","./registry"],function(_535,_536){
return _535("dijit._Contained",null,{_getSibling:function(_537){
var node=this.domNode;
do{
node=node[_537+"Sibling"];
}while(node&&node.nodeType!=1);
return node&&_536.byNode(node);
},getPreviousSibling:function(){
return this._getSibling("previous");
},getNextSibling:function(){
return this._getSibling("next");
},getIndexInParent:function(){
var p=this.getParent();
if(!p||!p.getIndexOfChild){
return -1;
}
return p.getIndexOfChild(this);
}});
});
},"dojox/grid/_RowManager":function(){
define(["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_538,lang,_539){
var _53a=function(_53b,_53c){
if(_53b.style.cssText==undefined){
_53b.setAttribute("style",_53c);
}else{
_53b.style.cssText=_53c;
}
};
return _538("dojox.grid._RowManager",null,{constructor:function(_53d){
this.grid=_53d;
},linesToEms:2,overRow:-2,prepareStylingRow:function(_53e,_53f){
return {index:_53e,node:_53f,odd:Boolean(_53e&1),selected:!!this.grid.selection.isSelected(_53e),over:this.isOver(_53e),customStyles:"",customClasses:"dojoxGridRow"};
},styleRowNode:function(_540,_541){
var row=this.prepareStylingRow(_540,_541);
this.grid.onStyleRow(row);
this.applyStyles(row);
},applyStyles:function(_542){
var i=_542;
i.node.className=i.customClasses;
var h=i.node.style.height;
_53a(i.node,i.customStyles+";"+(i.node._style||""));
i.node.style.height=h;
},updateStyles:function(_543){
this.grid.updateRowStyles(_543);
},setOverRow:function(_544){
var last=this.overRow;
this.overRow=_544;
if((last!=this.overRow)&&(lang.isString(last)||last>=0)){
this.updateStyles(last);
}
this.updateStyles(this.overRow);
},isOver:function(_545){
return (this.overRow==_545&&!_539.contains(this.grid.domNode,"dojoxGridColumnResizing"));
}});
});
},"dijit/main":function(){
define(["dojo/_base/kernel"],function(dojo){
return dojo.dijit;
});
},"dijit/Destroyable":function(){
define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_546,_547,_548){
return _548("dijit.Destroyable",null,{destroy:function(_549){
this._destroyed=true;
},own:function(){
_546.forEach(arguments,function(_54a){
var _54b="destroyRecursive" in _54a?"destroyRecursive":"destroy" in _54a?"destroy":"remove";
var odh=_547.before(this,"destroy",function(_54c){
_54a[_54b](_54c);
});
var hdh=_547.after(_54a,_54b,function(){
odh.remove();
hdh.remove();
},true);
},this);
return arguments;
}});
});
},"dojo/dnd/Container":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../_base/window","../dom","../dom-class","../dom-construct","../Evented","../has","../on","../query","../ready","../touch","./common"],function(_54d,_54e,_54f,_550,lang,win,dom,_551,_552,_553,has,on,_554,_555,_556,dnd){
var _557=_54e("dojo.dnd.Container",_553,{skipForm:false,allowNested:false,constructor:function(node,_558){
this.node=dom.byId(node);
if(!_558){
_558={};
}
this.creator=_558.creator||null;
this.skipForm=_558.skipForm;
this.parent=_558.dropParent&&dom.byId(_558.dropParent);
this.map={};
this.current=null;
this.containerState="";
_551.add(this.node,"dojoDndContainer");
if(!(_558&&_558._skipStartup)){
this.startup();
}
this.events=[on(this.node,_556.over,lang.hitch(this,"onMouseOver")),on(this.node,_556.out,lang.hitch(this,"onMouseOut")),on(this.node,"dragstart",lang.hitch(this,"onSelectStart")),on(this.node,"selectstart",lang.hitch(this,"onSelectStart"))];
},creator:function(){
},getItem:function(key){
return this.map[key];
},setItem:function(key,data){
this.map[key]=data;
},delItem:function(key){
delete this.map[key];
},forInItems:function(f,o){
o=o||_550.global;
var m=this.map,e=dnd._empty;
for(var i in m){
if(i in e){
continue;
}
f.call(o,m[i],i,this);
}
return o;
},clearItems:function(){
this.map={};
},getAllNodes:function(){
return _554((this.allowNested?"":"> ")+".dojoDndItem",this.parent);
},sync:function(){
var map={};
this.getAllNodes().forEach(function(node){
if(node.id){
var item=this.getItem(node.id);
if(item){
map[node.id]=item;
return;
}
}else{
node.id=dnd.getUniqueId();
}
var type=node.getAttribute("dndType"),data=node.getAttribute("dndData");
map[node.id]={data:data||node.innerHTML,type:type?type.split(/\s*,\s*/):["text"]};
},this);
this.map=map;
return this;
},insertNodes:function(data,_559,_55a){
if(!this.parent.firstChild){
_55a=null;
}else{
if(_559){
if(!_55a){
_55a=this.parent.firstChild;
}
}else{
if(_55a){
_55a=_55a.nextSibling;
}
}
}
var i,t;
if(_55a){
for(i=0;i<data.length;++i){
t=this._normalizedCreator(data[i]);
this.setItem(t.node.id,{data:t.data,type:t.type});
_55a.parentNode.insertBefore(t.node,_55a);
}
}else{
for(i=0;i<data.length;++i){
t=this._normalizedCreator(data[i]);
this.setItem(t.node.id,{data:t.data,type:t.type});
this.parent.appendChild(t.node);
}
}
return this;
},destroy:function(){
_54d.forEach(this.events,function(_55b){
_55b.remove();
});
this.clearItems();
this.node=this.parent=this.current=null;
},markupFactory:function(_55c,node,Ctor){
_55c._skipStartup=true;
return new Ctor(node,_55c);
},startup:function(){
if(!this.parent){
this.parent=this.node;
if(this.parent.tagName.toLowerCase()=="table"){
var c=this.parent.getElementsByTagName("tbody");
if(c&&c.length){
this.parent=c[0];
}
}
}
this.defaultCreator=dnd._defaultCreator(this.parent);
this.sync();
},onMouseOver:function(e){
var n=e.relatedTarget;
while(n){
if(n==this.node){
break;
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
if(!n){
this._changeState("Container","Over");
this.onOverEvent();
}
n=this._getChildByEvent(e);
if(this.current==n){
return;
}
if(this.current){
this._removeItemClass(this.current,"Over");
}
if(n){
this._addItemClass(n,"Over");
}
this.current=n;
},onMouseOut:function(e){
for(var n=e.relatedTarget;n;){
if(n==this.node){
return;
}
try{
n=n.parentNode;
}
catch(x){
n=null;
}
}
if(this.current){
this._removeItemClass(this.current,"Over");
this.current=null;
}
this._changeState("Container","");
this.onOutEvent();
},onSelectStart:function(e){
if(!this.skipForm||!dnd.isFormElement(e)){
_54f.stop(e);
}
},onOverEvent:function(){
},onOutEvent:function(){
},_changeState:function(type,_55d){
var _55e="dojoDnd"+type;
var _55f=type.toLowerCase()+"State";
_551.replace(this.node,_55e+_55d,_55e+this[_55f]);
this[_55f]=_55d;
},_addItemClass:function(node,type){
_551.add(node,"dojoDndItem"+type);
},_removeItemClass:function(node,type){
_551.remove(node,"dojoDndItem"+type);
},_getChildByEvent:function(e){
var node=e.target;
if(node){
for(var _560=node.parentNode;_560;node=_560,_560=node.parentNode){
if((_560==this.parent||this.allowNested)&&_551.contains(node,"dojoDndItem")){
return node;
}
}
}
return null;
},_normalizedCreator:function(item,hint){
var t=(this.creator||this.defaultCreator).call(this,item,hint);
if(!lang.isArray(t.type)){
t.type=["text"];
}
if(!t.node.id){
t.node.id=dnd.getUniqueId();
}
_551.add(t.node,"dojoDndItem");
return t;
}});
dnd._createNode=function(tag){
if(!tag){
return dnd._createSpan;
}
return function(text){
return _552.create(tag,{innerHTML:text});
};
};
dnd._createTrTd=function(text){
var tr=_552.create("tr");
_552.create("td",{innerHTML:text},tr);
return tr;
};
dnd._createSpan=function(text){
return _552.create("span",{innerHTML:text});
};
dnd._defaultCreatorNodes={ul:"li",ol:"li",div:"div",p:"div"};
dnd._defaultCreator=function(node){
var tag=node.tagName.toLowerCase();
var c=tag=="tbody"||tag=="thead"?dnd._createTrTd:dnd._createNode(dnd._defaultCreatorNodes[tag]);
return function(item,hint){
var _561=item&&lang.isObject(item),data,type,n;
if(_561&&item.tagName&&item.nodeType&&item.getAttribute){
data=item.getAttribute("dndData")||item.innerHTML;
type=item.getAttribute("dndType");
type=type?type.split(/\s*,\s*/):["text"];
n=item;
}else{
data=(_561&&item.data)?item.data:item;
type=(_561&&item.type)?item.type:["text"];
n=(hint=="avatar"?dnd._createSpan:c)(String(data));
}
if(!n.id){
n.id=dnd.getUniqueId();
}
return {node:n,data:data,type:type};
};
};
return _557;
});
},"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","dojo/cache":function(){
define(["./_base/kernel","./text"],function(dojo){
return dojo.cache;
});
},"dojo/dnd/Manager":function(){
define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(_562,_563,_564,lang,win,_565,_566,has,keys,on,_567,_568,dnd,_569,_56a){
var _56b=_563("dojo.dnd.Manager",[_566],{constructor:function(){
this.avatar=null;
this.source=null;
this.nodes=[];
this.copy=true;
this.target=null;
this.canDropFlag=false;
this.events=[];
},OFFSET_X:has("touch")?0:16,OFFSET_Y:has("touch")?-64:16,overSource:function(_56c){
if(this.avatar){
this.target=(_56c&&_56c.targetState!="Disabled")?_56c:null;
this.canDropFlag=Boolean(this.target);
this.avatar.update();
}
_567.publish("/dnd/source/over",_56c);
},outSource:function(_56d){
if(this.avatar){
if(this.target==_56d){
this.target=null;
this.canDropFlag=false;
this.avatar.update();
_567.publish("/dnd/source/over",null);
}
}else{
_567.publish("/dnd/source/over",null);
}
},startDrag:function(_56e,_56f,copy){
_569.autoScrollStart(win.doc);
this.source=_56e;
this.nodes=_56f;
this.copy=Boolean(copy);
this.avatar=this.makeAvatar();
win.body().appendChild(this.avatar.node);
_567.publish("/dnd/start",_56e,_56f,this.copy);
this.events=[on(win.doc,_568.move,lang.hitch(this,"onMouseMove")),on(win.doc,_568.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",_564.stop),on(win.body(),"selectstart",_564.stop)];
var c="dojoDnd"+(copy?"Copy":"Move");
_565.add(win.body(),c);
},canDrop:function(flag){
var _570=Boolean(this.target&&flag);
if(this.canDropFlag!=_570){
this.canDropFlag=_570;
this.avatar.update();
}
},stopDrag:function(){
_565.remove(win.body(),["dojoDndCopy","dojoDndMove"]);
_562.forEach(this.events,function(_571){
_571.remove();
});
this.events=[];
this.avatar.destroy();
this.avatar=null;
this.source=this.target=null;
this.nodes=[];
},makeAvatar:function(){
return new _56a(this);
},updateAvatar:function(){
this.avatar.update();
},onMouseMove:function(e){
var a=this.avatar;
if(a){
_569.autoScrollNodes(e);
var s=a.node.style;
s.left=(e.pageX+this.OFFSET_X)+"px";
s.top=(e.pageY+this.OFFSET_Y)+"px";
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
if(has("touch")){
e.preventDefault();
}
},onMouseUp:function(e){
if(this.avatar){
if(this.target&&this.canDropFlag){
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
_567.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);
_567.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);
}else{
_567.publish("/dnd/cancel");
}
this.stopDrag();
}
},onKeyDown:function(e){
if(this.avatar){
switch(e.keyCode){
case keys.CTRL:
var copy=Boolean(this.source.copyState(true));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
break;
case keys.ESCAPE:
_567.publish("/dnd/cancel");
this.stopDrag();
break;
}
}
},onKeyUp:function(e){
if(this.avatar&&e.keyCode==keys.CTRL){
var copy=Boolean(this.source.copyState(false));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
},_setCopyStatus:function(copy){
this.copy=copy;
this.source._markDndStatus(this.copy);
this.updateAvatar();
_565.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));
}});
dnd._manager=null;
_56b.manager=dnd.manager=function(){
if(!dnd._manager){
dnd._manager=new _56b();
}
return dnd._manager;
};
return _56b;
});
},"dojo/dnd/Avatar":function(){
define(["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_572,win,dom,_573,_574,_575,has,_576){
return _572("dojo.dnd.Avatar",null,{constructor:function(_577){
this.manager=_577;
this.construct();
},construct:function(){
var a=_575.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_578=this.manager.source,node,b=_575.create("tbody",null,a),tr=_575.create("tr",null,b),td=_575.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;
if(has("highcontrast")){
_575.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);
}
_575.create("span",{innerHTML:_578.generateText?this._generateText():""},td);
_573.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});
for(;i<k;++i){
if(_578.creator){
node=_578._normalizedCreator(_578.getItem(this.manager.nodes[i].id).data,"avatar").node;
}else{
node=this.manager.nodes[i].cloneNode(true);
if(node.tagName.toLowerCase()=="tr"){
var _579=_575.create("table"),_57a=_575.create("tbody",null,_579);
_57a.appendChild(node);
node=_579;
}
}
node.id="";
tr=_575.create("tr",null,b);
td=_575.create("td",null,tr);
td.appendChild(node);
_573.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});
}
this.node=a;
},destroy:function(){
_575.destroy(this.node);
this.node=false;
},update:function(){
_574.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);
if(has("highcontrast")){
var icon=dom.byId("a11yIcon");
var text="+";
if(this.manager.canDropFlag&&!this.manager.copy){
text="< ";
}else{
if(!this.manager.canDropFlag&&!this.manager.copy){
text="o";
}else{
if(!this.manager.canDropFlag){
text="x";
}
}
}
icon.innerHTML=text;
}
_576(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){
node.innerHTML=this.manager.source.generateText?this._generateText():"";
},this);
},_generateText:function(){
return this.manager.nodes.length.toString();
}});
});
},"dojox/grid/_SelectionPreserver":function(){
define("dojox/grid/_SelectionPreserver",["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array"],function(_57b,_57c,lang,_57d){
return _57b("dojox.grid._SelectionPreserver",null,{constructor:function(_57e){
this.selection=_57e;
var grid=this.grid=_57e.grid;
this.reset();
this._connects=[_57c.connect(grid,"_setStore",this,"reset"),_57c.connect(grid,"_addItem",this,"_reSelectById"),_57c.connect(_57e,"onSelected",lang.hitch(this,"_selectById",true)),_57c.connect(_57e,"onDeselected",lang.hitch(this,"_selectById",false)),_57c.connect(_57e,"deselectAll",this,"reset")];
},destroy:function(){
this.reset();
_57d.forEach(this._connects,_57c.disconnect);
delete this._connects;
},reset:function(){
this._selectedById={};
},_reSelectById:function(item,_57f){
if(item&&this.grid._hasIdentity){
this.selection.selected[_57f]=this._selectedById[this.grid.store.getIdentity(item)];
}
},_selectById:function(_580,_581){
if(this.selection.mode=="none"||!this.grid._hasIdentity){
return;
}
var item=_581,g=this.grid;
if(typeof _581=="number"||typeof _581=="string"){
var _582=g._by_idx[_581];
item=_582&&_582.item;
}
if(item){
this._selectedById[g.store.getIdentity(item)]=!!_580;
}
return item;
}});
});
},"dojox/grid/_FocusManager":function(){
define("dojox/grid/_FocusManager",["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(_583,lang,_584,_585,_586,has,_587,util,html){
return _584("dojox.grid._FocusManager",null,{constructor:function(_588){
this.grid=_588;
this.cell=null;
this.rowIndex=-1;
this._connects=[];
this._headerConnects=[];
this.headerMenu=this.grid.headerMenu;
this._connects.push(_585.connect(this.grid.domNode,"onfocus",this,"doFocus"));
this._connects.push(_585.connect(this.grid.domNode,"onblur",this,"doBlur"));
this._connects.push(_585.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));
this._connects.push(_585.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));
this._connects.push(_585.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));
this._connects.push(_585.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));
this._connects.push(_585.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));
this._connects.push(_585.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));
this._connects.push(_585.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));
},destroy:function(){
_583.forEach(this._connects,_585.disconnect);
_583.forEach(this._headerConnects,_585.disconnect);
delete this.grid;
delete this.cell;
},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){
this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];
this._initColumnHeaders();
},isFocusCell:function(_589,_58a){
return (this.cell==_589)&&(this.rowIndex==_58a);
},isLastFocusCell:function(){
if(this.cell){
return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);
}
return false;
},isFirstFocusCell:function(){
if(this.cell){
return (this.rowIndex===0)&&(this.cell.index===0);
}
return false;
},isNoFocusCell:function(){
return (this.rowIndex<0)||!this.cell;
},isNavHeader:function(){
return (!!this._colHeadNode);
},getHeaderIndex:function(){
if(this._colHeadNode){
return _583.indexOf(this._findHeaderCells(),this._colHeadNode);
}else{
return -1;
}
},_focusifyCellNode:function(_58b){
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
html.toggleClass(n,this.focusClass,_58b);
if(_58b){
var sl=this.scrollIntoView();
try{
if(has("webkit")||!this.grid.edit.isEditing()){
util.fire(n,"focus");
if(sl){
this.cell.view.scrollboxNode.scrollLeft=sl;
}
}
}
catch(e){
}
}
}
},_delayedCellFocus:function(){
if(this.isNavHeader()||!this.grid.focused){
return;
}
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
try{
if(!this.grid.edit.isEditing()){
html.toggleClass(n,this.focusClass,true);
if(this._colHeadNode){
this.blurHeader();
}
util.fire(n,"focus");
}
}
catch(e){
}
}
},_delayedHeaderFocus:function(){
if(this.isNavHeader()){
this.focusHeader();
}
},_initColumnHeaders:function(){
_583.forEach(this._headerConnects,_585.disconnect);
this._headerConnects=[];
var _58c=this._findHeaderCells();
for(var i=0;i<_58c.length;i++){
this._headerConnects.push(_585.connect(_58c[i],"onfocus",this,"doColHeaderFocus"));
this._headerConnects.push(_585.connect(_58c[i],"onblur",this,"doColHeaderBlur"));
}
},_findHeaderCells:function(){
var _58d=_587("th",this.grid.viewsHeaderNode);
var _58e=[];
for(var i=0;i<_58d.length;i++){
var _58f=_58d[i];
var _590=html.hasAttr(_58f,"tabIndex");
var _591=html.attr(_58f,"tabIndex");
if(_590&&_591<0){
_58e.push(_58f);
}
}
return _58e;
},_setActiveColHeader:function(_592,_593,_594){
this.grid.domNode.setAttribute("aria-activedescendant",_592.id);
if(_594!=null&&_594>=0&&_594!=_593){
html.toggleClass(this._findHeaderCells()[_594],this.focusClass,false);
}
html.toggleClass(_592,this.focusClass,true);
this._colHeadNode=_592;
this._colHeadFocusIdx=_593;
this._scrollHeader(this._colHeadFocusIdx);
},scrollIntoView:function(){
var info=(this.cell?this._scrollInfo(this.cell):null);
if(!info||!info.s){
return null;
}
var rt=this.grid.scroller.findScrollTop(this.rowIndex);
if(info.n&&info.sr){
if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}
}
}
if(info.r&&info.sr){
if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){
this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);
}else{
if(rt<info.sr.t){
this.grid.setScrollTop(rt);
}
}
}
return info.s.scrollLeft;
},_scrollInfo:function(cell,_595){
if(cell){
var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);
return {c:cl,s:sbn,sr:sbnr,n:(_595?_595:cell.getNode(this.rowIndex)),r:rn};
}
return null;
},_scrollHeader:function(_596){
var info=null;
if(this._colHeadNode){
var cell=this.grid.getCell(_596);
if(!cell){
return;
}
info=this._scrollInfo(cell,cell.getNode(0));
}
if(info&&info.s&&info.sr&&info.n){
var _597=info.sr.l+info.sr.w;
if(info.n.offsetLeft+info.n.offsetWidth>_597){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}else{
if(has("ie")<=7&&cell&&cell.view.headerNode){
cell.view.headerNode.scrollLeft=info.s.scrollLeft;
}
}
}
}
},_isHeaderHidden:function(){
var _598=this.focusView;
if(!_598){
for(var i=0,_599;(_599=this.grid.views.views[i]);i++){
if(_599.headerNode){
_598=_599;
break;
}
}
}
return (_598&&html.getComputedStyle(_598.headerNode).display=="none");
},colSizeAdjust:function(e,_59a,_59b){
var _59c=this._findHeaderCells();
var view=this.focusView;
if(!view||!view.header.tableMap.map){
for(var i=0,_59d;(_59d=this.grid.views.views[i]);i++){
if(_59d.header.tableMap.map){
view=_59d;
break;
}
}
}
var _59e=_59c[_59a];
if(!view||(_59a==_59c.length-1&&_59a===0)){
return;
}
view.content.baseDecorateEvent(e);
e.cellNode=_59e;
e.cellIndex=view.content.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
if(view.header.canResize(e)){
var _59f={l:_59b};
var drag=view.header.colResizeSetup(e,false);
view.header.doResizeColumn(drag,null,_59f);
view.update();
}
},styleRow:function(_5a0){
return;
},setFocusIndex:function(_5a1,_5a2){
this.setFocusCell(this.grid.getCell(_5a2),_5a1);
},setFocusCell:function(_5a3,_5a4){
if(_5a3&&!this.isFocusCell(_5a3,_5a4)){
this.tabbingOut=false;
if(this._colHeadNode){
this.blurHeader();
}
this._colHeadNode=this._colHeadFocusIdx=null;
this.focusGridView();
this._focusifyCellNode(false);
this.cell=_5a3;
this.rowIndex=_5a4;
this._focusifyCellNode(true);
}
if(has("opera")){
setTimeout(lang.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);
}else{
this.grid.onCellFocus(this.cell,this.rowIndex);
}
},next:function(){
if(this.cell){
var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;
if(col>cc){
col=0;
row++;
}
if(row>rc){
col=cc;
row=rc;
}
if(this.grid.edit.isEditing()){
var _5a5=this.grid.getCell(col);
if(!this.isLastFocusCell()&&(!_5a5.editable||this.grid.canEdit&&!this.grid.canEdit(_5a5,row))){
this.cell=_5a5;
this.rowIndex=row;
this.next();
return;
}
}
this.setFocusIndex(row,col);
}
},previous:function(){
if(this.cell){
var row=(this.rowIndex||0),col=(this.cell.index||0)-1;
if(col<0){
col=this.grid.layout.cellCount-1;
row--;
}
if(row<0){
row=0;
col=0;
}
if(this.grid.edit.isEditing()){
var _5a6=this.grid.getCell(col);
if(!this.isFirstFocusCell()&&!_5a6.editable){
this.cell=_5a6;
this.rowIndex=row;
this.previous();
return;
}
}
this.setFocusIndex(row,col);
}
},move:function(_5a7,_5a8){
var _5a9=_5a8<0?-1:1;
if(this.isNavHeader()){
var _5aa=this._findHeaderCells();
var _5ab=currentIdx=_583.indexOf(_5aa,this._colHeadNode);
currentIdx+=_5a8;
while(currentIdx>=0&&currentIdx<_5aa.length&&_5aa[currentIdx].style.display=="none"){
currentIdx+=_5a9;
}
if((currentIdx>=0)&&(currentIdx<_5aa.length)){
this._setActiveColHeader(_5aa[currentIdx],currentIdx,_5ab);
}
}else{
if(this.cell){
var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_5a7));
if(_5a7){
if(_5a7>0){
if(row>sc.getLastPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));
}
}else{
if(_5a7<0){
if(row<=sc.getPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));
}
}
}
}
var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_5a8));
var cell=this.grid.getCell(col);
while(col>=0&&col<cc&&cell&&cell.hidden===true){
col+=_5a9;
cell=this.grid.getCell(col);
}
if(!cell||cell.hidden===true){
col=i;
}
var n=cell.getNode(row);
if(!n&&_5a7){
if((row+_5a7)>=0&&(row+_5a7)<=rc){
this.move(_5a7>0?++_5a7:--_5a7,_5a8);
}
return;
}else{
if((!n||html.style(n,"display")==="none")&&_5a8){
if((col+_5a8)>=0&&(col+_5a8)<=cc){
this.move(_5a7,_5a8>0?++_5a8:--_5a8);
}
return;
}
}
this.setFocusIndex(row,col);
if(_5a7){
this.grid.updateRow(r);
}
}
}
},previousKey:function(e){
if(this.grid.edit.isEditing()){
_586.stop(e);
this.previous();
}else{
if(!this.isNavHeader()&&!this._isHeaderHidden()){
this.grid.domNode.focus();
_586.stop(e);
}else{
this.tabOut(this.grid.domNode);
if(this._colHeadFocusIdx!=null){
html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);
this._colHeadFocusIdx=null;
}
this._focusifyCellNode(false);
}
}
},nextKey:function(e){
var _5ac=(this.grid.rowCount===0);
if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){
this.focusHeader();
_586.stop(e);
}else{
if(this.isNavHeader()){
this.blurHeader();
if(!this.findAndFocusGridCell()){
this.tabOut(this.grid.lastFocusNode);
}
this._colHeadNode=this._colHeadFocusIdx=null;
}else{
if(this.grid.edit.isEditing()){
_586.stop(e);
this.next();
}else{
this.tabOut(this.grid.lastFocusNode);
}
}
}
},tabOut:function(_5ad){
this.tabbingOut=true;
_5ad.focus();
},focusGridView:function(){
util.fire(this.focusView,"focus");
},focusGrid:function(_5ae){
this.focusGridView();
this._focusifyCellNode(true);
},findAndFocusGridCell:function(){
var _5af=true;
var _5b0=(this.grid.rowCount===0);
if(this.isNoFocusCell()&&!_5b0){
var _5b1=0;
var cell=this.grid.getCell(_5b1);
if(cell.hidden){
_5b1=this.isNavHeader()?this._colHeadFocusIdx:0;
}
this.setFocusIndex(0,_5b1);
}else{
if(this.cell&&!_5b0){
if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){
this.grid.scrollToRow(this.rowIndex);
}
this.focusGrid();
}else{
_5af=false;
}
}
this._colHeadNode=this._colHeadFocusIdx=null;
return _5af;
},focusHeader:function(){
var _5b2=this._findHeaderCells();
var _5b3=this._colHeadFocusIdx;
if(this._isHeaderHidden()){
this.findAndFocusGridCell();
}else{
if(!this._colHeadFocusIdx){
if(this.isNoFocusCell()){
this._colHeadFocusIdx=0;
}else{
this._colHeadFocusIdx=this.cell.index;
}
}
}
this._colHeadNode=_5b2[this._colHeadFocusIdx];
while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_5b2.length&&this._colHeadNode.style.display=="none"){
this._colHeadFocusIdx++;
this._colHeadNode=_5b2[this._colHeadFocusIdx];
}
if(this._colHeadNode&&this._colHeadNode.style.display!="none"){
if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){
this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);
this.headerMenu.bindDomNode(this.grid.domNode);
this._contextMenuBindNode=this.grid.domNode;
}
this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_5b3);
this._scrollHeader(this._colHeadFocusIdx);
this._focusifyCellNode(false);
}else{
this.findAndFocusGridCell();
}
},blurHeader:function(){
html.removeClass(this._colHeadNode,this.focusClass);
html.removeAttr(this.grid.domNode,"aria-activedescendant");
if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){
var _5b4=this.grid.viewsHeaderNode;
this.headerMenu.unBindDomNode(this.grid.domNode);
this.headerMenu.bindDomNode(_5b4);
this._contextMenuBindNode=_5b4;
}
},doFocus:function(e){
if(e&&e.target!=e.currentTarget){
_586.stop(e);
return;
}
if(this._clickFocus){
return;
}
if(!this.tabbingOut){
this.focusHeader();
}
this.tabbingOut=false;
_586.stop(e);
},doBlur:function(e){
_586.stop(e);
},doContextMenu:function(e){
if(!this.headerMenu){
_586.stop(e);
}
},doLastNodeFocus:function(e){
if(this.tabbingOut){
this._focusifyCellNode(false);
}else{
if(this.grid.rowCount>0){
if(this.isNoFocusCell()){
this.setFocusIndex(0,0);
}
this._focusifyCellNode(true);
}else{
this.focusHeader();
}
}
this.tabbingOut=false;
_586.stop(e);
},doLastNodeBlur:function(e){
_586.stop(e);
},doColHeaderFocus:function(e){
this._setActiveColHeader(e.target,html.attr(e.target,"idx"),this._colHeadFocusIdx);
this._scrollHeader(this.getHeaderIndex());
_586.stop(e);
},doColHeaderBlur:function(e){
html.toggleClass(e.target,this.focusClass,false);
},_mouseDown:function(e){
this._clickFocus=dojo.some(this.grid.views.views,function(v){
return v.scrollboxNode===e.target;
});
},_mouseUp:function(e){
this._clickFocus=false;
}});
});
},"dojox/grid/_Events":function(){
define("dojox/grid/_Events",["dojo/keys","dojo/dom-class","dojo/_base/declare","dojo/_base/event","dojo/_base/sniff"],function(keys,_5b5,_5b6,_5b7,has){
return _5b6("dojox.grid._Events",null,{cellOverClass:"dojoxGridCellOver",onKeyEvent:function(e){
this.dispatchKeyEvent(e);
},onContentEvent:function(e){
this.dispatchContentEvent(e);
},onHeaderEvent:function(e){
this.dispatchHeaderEvent(e);
},onStyleRow:function(_5b8){
var i=_5b8;
i.customClasses+=(i.odd?" dojoxGridRowOdd":"")+(i.selected?" dojoxGridRowSelected":"")+(i.over?" dojoxGridRowOver":"");
this.focus.styleRow(_5b8);
this.edit.styleRow(_5b8);
},onKeyDown:function(e){
if(e.altKey||e.metaKey){
return;
}
var _5b9;
switch(e.keyCode){
case keys.ESCAPE:
this.edit.cancel();
break;
case keys.ENTER:
if(!this.edit.isEditing()){
_5b9=this.focus.getHeaderIndex();
if(_5b9>=0){
this.setSortIndex(_5b9);
break;
}else{
this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);
}
_5b7.stop(e);
}
if(!e.shiftKey){
var _5ba=this.edit.isEditing();
this.edit.apply();
if(!_5ba){
this.edit.setEditCell(this.focus.cell,this.focus.rowIndex);
}
}
if(!this.edit.isEditing()){
var _5bb=this.focus.focusView||this.views.views[0];
_5bb.content.decorateEvent(e);
this.onRowClick(e);
_5b7.stop(e);
}
break;
case keys.SPACE:
if(!this.edit.isEditing()){
_5b9=this.focus.getHeaderIndex();
if(_5b9>=0){
this.setSortIndex(_5b9);
break;
}else{
this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);
}
_5b7.stop(e);
}
break;
case keys.TAB:
this.focus[e.shiftKey?"previousKey":"nextKey"](e);
break;
case keys.LEFT_ARROW:
case keys.RIGHT_ARROW:
if(!this.edit.isEditing()){
var _5bc=e.keyCode;
_5b7.stop(e);
_5b9=this.focus.getHeaderIndex();
if(_5b9>=0&&(e.shiftKey&&e.ctrlKey)){
this.focus.colSizeAdjust(e,_5b9,(_5bc==keys.LEFT_ARROW?-1:1)*5);
}else{
var _5bd=(_5bc==keys.LEFT_ARROW)?1:-1;
if(this.isLeftToRight()){
_5bd*=-1;
}
this.focus.move(0,_5bd);
}
}
break;
case keys.UP_ARROW:
if(!this.edit.isEditing()&&this.focus.rowIndex!==0){
_5b7.stop(e);
this.focus.move(-1,0);
}
break;
case keys.DOWN_ARROW:
if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){
_5b7.stop(e);
this.focus.move(1,0);
}
break;
case keys.PAGE_UP:
if(!this.edit.isEditing()&&this.focus.rowIndex!==0){
_5b7.stop(e);
if(this.focus.rowIndex!=this.scroller.firstVisibleRow+1){
this.focus.move(this.scroller.firstVisibleRow-this.focus.rowIndex,0);
}else{
this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex-1));
this.focus.move(this.scroller.firstVisibleRow-this.scroller.lastVisibleRow+1,0);
}
}
break;
case keys.PAGE_DOWN:
if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){
_5b7.stop(e);
if(this.focus.rowIndex!=this.scroller.lastVisibleRow-1){
this.focus.move(this.scroller.lastVisibleRow-this.focus.rowIndex-1,0);
}else{
this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex+1));
this.focus.move(this.scroller.lastVisibleRow-this.scroller.firstVisibleRow-1,0);
}
}
break;
default:
break;
}
},onMouseOver:function(e){
e.rowIndex==-1?this.onHeaderCellMouseOver(e):this.onCellMouseOver(e);
},onMouseOut:function(e){
e.rowIndex==-1?this.onHeaderCellMouseOut(e):this.onCellMouseOut(e);
},onMouseDown:function(e){
e.rowIndex==-1?this.onHeaderCellMouseDown(e):this.onCellMouseDown(e);
},onMouseOverRow:function(e){
if(!this.rows.isOver(e.rowIndex)){
this.rows.setOverRow(e.rowIndex);
e.rowIndex==-1?this.onHeaderMouseOver(e):this.onRowMouseOver(e);
}
},onMouseOutRow:function(e){
if(this.rows.isOver(-1)){
this.onHeaderMouseOut(e);
}else{
if(!this.rows.isOver(-2)){
this.rows.setOverRow(-2);
this.onRowMouseOut(e);
}
}
},onMouseDownRow:function(e){
if(e.rowIndex!=-1){
this.onRowMouseDown(e);
}
},onCellMouseOver:function(e){
if(e.cellNode){
_5b5.add(e.cellNode,this.cellOverClass);
}
},onCellMouseOut:function(e){
if(e.cellNode){
_5b5.remove(e.cellNode,this.cellOverClass);
}
},onCellMouseDown:function(e){
},onCellClick:function(e){
this._click[0]=this._click[1];
this._click[1]=e;
if(!this.edit.isEditCell(e.rowIndex,e.cellIndex)){
this.focus.setFocusCell(e.cell,e.rowIndex);
}
if(this._click.length>1&&this._click[0]==null){
this._click.shift();
}
this.onRowClick(e);
},onCellDblClick:function(e){
var _5be;
if(this._click.length>1&&has("ie")){
_5be=this._click[1];
}else{
if(this._click.length>1&&this._click[0].rowIndex!=this._click[1].rowIndex){
_5be=this._click[0];
}else{
_5be=e;
}
}
this.focus.setFocusCell(_5be.cell,_5be.rowIndex);
this.onRowClick(_5be);
this.edit.setEditCell(_5be.cell,_5be.rowIndex);
this.onRowDblClick(e);
},onCellContextMenu:function(e){
this.onRowContextMenu(e);
},onCellFocus:function(_5bf,_5c0){
this.edit.cellFocus(_5bf,_5c0);
},onRowClick:function(e){
this.edit.rowClick(e);
this.selection.clickSelectEvent(e);
},onRowDblClick:function(e){
},onRowMouseOver:function(e){
},onRowMouseOut:function(e){
},onRowMouseDown:function(e){
},onRowContextMenu:function(e){
_5b7.stop(e);
},onHeaderMouseOver:function(e){
},onHeaderMouseOut:function(e){
},onHeaderCellMouseOver:function(e){
if(e.cellNode){
_5b5.add(e.cellNode,this.cellOverClass);
}
},onHeaderCellMouseOut:function(e){
if(e.cellNode){
_5b5.remove(e.cellNode,this.cellOverClass);
}
},onHeaderCellMouseDown:function(e){
},onHeaderClick:function(e){
},onHeaderCellClick:function(e){
this.setSortIndex(e.cell.index);
this.onHeaderClick(e);
},onHeaderDblClick:function(e){
},onHeaderCellDblClick:function(e){
this.onHeaderDblClick(e);
},onHeaderCellContextMenu:function(e){
this.onHeaderContextMenu(e);
},onHeaderContextMenu:function(e){
if(!this.headerMenu){
_5b7.stop(e);
}
},onStartEdit:function(_5c1,_5c2){
},onApplyCellEdit:function(_5c3,_5c4,_5c5){
},onCancelEdit:function(_5c6){
},onApplyEdit:function(_5c7){
},onCanSelect:function(_5c8){
return true;
},onCanDeselect:function(_5c9){
return true;
},onSelected:function(_5ca){
this.updateRowStyles(_5ca);
},onDeselected:function(_5cb){
this.updateRowStyles(_5cb);
},onSelectionChanged:function(){
}});
});
},"dijit/MenuItem":function(){
define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_5cc,dom,_5cd,_5ce,_5cf,has,_5d0,_5d1,_5d2,_5d3,_5d4){
return _5cc("dijit.MenuItem",[_5d0,_5d1,_5d2,_5d3],{templateString:_5d4,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){
this.containerNode.innerHTML=val;
this._set("label",val);
if(this.textDir==="auto"){
this.applyTextDir(this.focusNode,this.label);
}
},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_5d5){
if(_5d5&&!("label" in this.params)){
this.set("label",_5d5.innerHTML);
}
},buildRendering:function(){
this.inherited(arguments);
var _5d6=this.id+"_text";
_5cd.set(this.containerNode,"id",_5d6);
if(this.accelKeyNode){
_5cd.set(this.accelKeyNode,"id",this.id+"_accel");
_5d6+=" "+this.id+"_accel";
}
this.domNode.setAttribute("aria-labelledby",_5d6);
dom.setSelectable(this.domNode,false);
},onClick:function(){
},focus:function(){
try{
if(has("ie")==8){
this.containerNode.focus();
}
this.focusNode.focus();
}
catch(e){
}
},_onFocus:function(){
this._setSelected(true);
this.getParent()._onItemFocus(this);
this.inherited(arguments);
},_setSelected:function(_5d7){
_5ce.toggle(this.domNode,"dijitMenuItemSelected",_5d7);
},setLabel:function(_5d8){
_5cf.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");
this.set("label",_5d8);
},setDisabled:function(_5d9){
_5cf.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_5d9);
},_setDisabledAttr:function(_5da){
this.focusNode.setAttribute("aria-disabled",_5da?"true":"false");
this._set("disabled",_5da);
},_setAccelKeyAttr:function(_5db){
this.accelKeyNode.style.display=_5db?"":"none";
this.accelKeyNode.innerHTML=_5db;
_5cd.set(this.containerNode,"colSpan",_5db?"1":"2");
this._set("accelKey",_5db);
},_setTextDirAttr:function(_5dc){
if(!this._created||this.textDir!=_5dc){
this._set("textDir",_5dc);
this.applyTextDir(this.focusNode,this.label);
}
}});
});
},"dojox/grid/_RowSelector":function(){
define(["dojo/_base/declare","./_View"],function(_5dd,_5de){
return _5dd("dojox.grid._RowSelector",_5de,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){
this.inherited("buildRendering",arguments);
this.scrollboxNode.style.overflow="hidden";
this.headerNode.style.visibility="hidden";
},getWidth:function(){
return this.viewWidth||this.defaultWidth;
},buildRowContent:function(_5df,_5e0){
var w=this.contentWidth||0;
_5e0.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";
},renderHeader:function(){
},updateRow:function(){
},resize:function(){
this.adaptHeight();
},adaptWidth:function(){
if(!("contentWidth" in this)&&this.contentNode&&this.contentNode.offsetWidth>0){
this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;
}
},doStyleRowNode:function(_5e1,_5e2){
var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];
if(this.grid.rows.isOver(_5e1)){
n.push("dojoxGridRowbarOver");
}
if(this.grid.selection.isSelected(_5e1)){
n.push("dojoxGridRowbarSelected");
}
_5e2.className=n.join(" ");
},domouseover:function(e){
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}});
});
},"*now":function(r){
r(["dojo/i18n!*preload*dojox/grid/nls/DataGrid*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);
}}});
define("dojox/grid/DataGrid",["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/sniff","dojo/_base/declare","./_Grid","./DataSelection","dojo/_base/html"],function(_5e3,_5e4,lang,json,has,_5e5,_5e6,_5e7,html){
var _5e8=_5e5("dojox.grid.DataGrid",_5e6,{store:null,query:null,queryOptions:null,fetchText:"...",sortFields:null,updateDelay:1,items:null,_store_connects:null,_by_idty:null,_by_idx:null,_cache:null,_pages:null,_pending_requests:null,_bop:-1,_eop:-1,_requests:0,rowCount:0,_isLoaded:false,_isLoading:false,keepSelection:false,postCreate:function(){
this._pages=[];
this._store_connects=[];
this._by_idty={};
this._by_idx=[];
this._cache=[];
this._pending_requests={};
this._setStore(this.store);
this.inherited(arguments);
},destroy:function(){
this.selection.destroy();
this.inherited(arguments);
},createSelection:function(){
this.selection=new _5e7(this);
},get:function(_5e9,_5ea){
if(_5ea&&this.field=="_item"&&!this.fields){
return _5ea;
}else{
if(_5ea&&this.fields){
var ret=[];
var s=this.grid.store;
_5e4.forEach(this.fields,function(f){
ret=ret.concat(s.getValues(_5ea,f));
});
return ret;
}else{
if(!_5ea&&typeof _5e9==="string"){
return this.inherited(arguments);
}
}
}
return (!_5ea?this.defaultValue:(!this.field?this.value:(this.field=="_item"?_5ea:this.grid.store.getValue(_5ea,this.field))));
},_checkUpdateStatus:function(){
if(this.updateDelay>0){
var _5eb=false;
if(this._endUpdateDelay){
clearTimeout(this._endUpdateDelay);
delete this._endUpdateDelay;
_5eb=true;
}
if(!this.updating){
this.beginUpdate();
_5eb=true;
}
if(_5eb){
var _5ec=this;
this._endUpdateDelay=setTimeout(function(){
delete _5ec._endUpdateDelay;
_5ec.endUpdate();
},this.updateDelay);
}
}
},_onSet:function(item,_5ed,_5ee,_5ef){
this._checkUpdateStatus();
var idx=this.getItemIndex(item);
if(idx>-1){
this.updateRow(idx);
}
},_createItem:function(item,_5f0){
var idty=this._hasIdentity?this.store.getIdentity(item):json.toJson(this.query)+":idx:"+_5f0+":sort:"+json.toJson(this.getSortProps());
var o=this._by_idty[idty]={idty:idty,item:item};
return o;
},_addItem:function(item,_5f1,_5f2){
this._by_idx[_5f1]=this._createItem(item,_5f1);
if(!_5f2){
this.updateRow(_5f1);
}
},_onNew:function(item,_5f3){
this._checkUpdateStatus();
var _5f4=this.get("rowCount");
this._addingItem=true;
this.updateRowCount(_5f4+1);
this._addingItem=false;
this._addItem(item,_5f4);
this.showMessage();
},_onDelete:function(item){
this._checkUpdateStatus();
var idx=this._getItemIndex(item,true);
if(idx>=0){
this._pages=[];
this._bop=-1;
this._eop=-1;
var o=this._by_idx[idx];
this._by_idx.splice(idx,1);
delete this._by_idty[o.idty];
this.updateRowCount(this.get("rowCount")-1);
if(this.get("rowCount")===0){
this.showMessage(this.noDataMessage);
}
}
if(this.selection.isSelected(idx)){
this.selection.deselect(idx);
this.selection.selected.splice(idx,1);
}
},_onRevert:function(){
this._refresh();
},setStore:function(_5f5,_5f6,_5f7){
if(this._requestsPending(0)){
return;
}
this._setQuery(_5f6,_5f7);
this._setStore(_5f5);
this._refresh(true);
},setQuery:function(_5f8,_5f9){
if(this._requestsPending(0)){
return;
}
this._setQuery(_5f8,_5f9);
this._refresh(true);
},setItems:function(_5fa){
this.items=_5fa;
this._setStore(this.store);
this._refresh(true);
},_setQuery:function(_5fb,_5fc){
this.query=_5fb;
this.queryOptions=_5fc||this.queryOptions;
},_setStore:function(_5fd){
if(this.store&&this._store_connects){
_5e4.forEach(this._store_connects,this.disconnect,this);
}
this.store=_5fd;
if(this.store){
var f=this.store.getFeatures();
var h=[];
this._canEdit=!!f["dojo.data.api.Write"]&&!!f["dojo.data.api.Identity"];
this._hasIdentity=!!f["dojo.data.api.Identity"];
if(!!f["dojo.data.api.Notification"]&&!this.items){
h.push(this.connect(this.store,"onSet","_onSet"));
h.push(this.connect(this.store,"onNew","_onNew"));
h.push(this.connect(this.store,"onDelete","_onDelete"));
}
if(this._canEdit){
h.push(this.connect(this.store,"revert","_onRevert"));
}
this._store_connects=h;
}
},_onFetchBegin:function(size,req){
if(!this.scroller){
return;
}
if(this.rowCount!=size){
if(req.isRender){
this.scroller.init(size,this.keepRows,this.rowsPerPage);
this.rowCount=size;
this._setAutoHeightAttr(this.autoHeight,true);
this._skipRowRenormalize=true;
this.prerender();
this._skipRowRenormalize=false;
}else{
this.updateRowCount(size);
}
}
if(!size){
this.views.render();
this._resize();
this.showMessage(this.noDataMessage);
this.focus.initFocusView();
}else{
this.showMessage();
}
},_onFetchComplete:function(_5fe,req){
if(!this.scroller){
return;
}
if(_5fe&&_5fe.length>0){
_5e4.forEach(_5fe,function(item,idx){
this._addItem(item,req.start+idx,true);
},this);
this.updateRows(req.start,_5fe.length);
if(req.isRender){
this.setScrollTop(0);
this.postrender();
}else{
if(this._lastScrollTop){
this.setScrollTop(this._lastScrollTop);
}
}
if(has("ie")){
html.setSelectable(this.domNode,this.selectable);
}
}
delete this._lastScrollTop;
if(!this._isLoaded){
this._isLoading=false;
this._isLoaded=true;
}
this._pending_requests[req.start]=false;
},_onFetchError:function(err,req){
delete this._lastScrollTop;
if(!this._isLoaded){
this._isLoading=false;
this._isLoaded=true;
this.showMessage(this.errorMessage);
}
this._pending_requests[req.start]=false;
this.onFetchError(err,req);
},onFetchError:function(err,req){
},_fetch:function(_5ff,_600){
_5ff=_5ff||0;
if(this.store&&!this._pending_requests[_5ff]){
if(!this._isLoaded&&!this._isLoading){
this._isLoading=true;
this.showMessage(this.loadingMessage);
}
this._pending_requests[_5ff]=true;
try{
if(this.items){
var _601=this.items;
var _602=this.store;
this.rowsPerPage=_601.length;
var req={start:_5ff,count:this.rowsPerPage,isRender:_600};
this._onFetchBegin(_601.length,req);
var _603=0;
_5e4.forEach(_601,function(i){
if(!_602.isItemLoaded(i)){
_603++;
}
});
if(_603===0){
this._onFetchComplete(_601,req);
}else{
var _604=function(item){
_603--;
if(_603===0){
this._onFetchComplete(_601,req);
}
};
_5e4.forEach(_601,function(i){
if(!_602.isItemLoaded(i)){
_602.loadItem({item:i,onItem:_604,scope:this});
}
},this);
}
}else{
this.store.fetch({start:_5ff,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_600,onBegin:lang.hitch(this,"_onFetchBegin"),onComplete:lang.hitch(this,"_onFetchComplete"),onError:lang.hitch(this,"_onFetchError")});
}
}
catch(e){
this._onFetchError(e,{start:_5ff,count:this.rowsPerPage});
}
}
},_clearData:function(){
this.updateRowCount(0);
this._by_idty={};
this._by_idx=[];
this._pages=[];
this._bop=this._eop=-1;
this._isLoaded=false;
this._isLoading=false;
},getItem:function(idx){
var data=this._by_idx[idx];
if(!data||(data&&!data.item)){
this._preparePage(idx);
return null;
}
return data.item;
},getItemIndex:function(item){
return this._getItemIndex(item,false);
},_getItemIndex:function(item,_605){
if(!_605&&!this.store.isItem(item)){
return -1;
}
var idty=this._hasIdentity?this.store.getIdentity(item):null;
for(var i=0,l=this._by_idx.length;i<l;i++){
var d=this._by_idx[i];
if(d&&((idty&&d.idty==idty)||(d.item===item))){
return i;
}
}
return -1;
},filter:function(_606,_607){
this.query=_606;
if(_607){
this._clearData();
}
this._fetch();
},_getItemAttr:function(idx,attr){
var item=this.getItem(idx);
return (!item?this.fetchText:this.store.getValue(item,attr));
},_render:function(){
if(this.domNode.parentNode){
this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);
this.prerender();
this._fetch(0,true);
}
},_requestsPending:function(_608){
return this._pending_requests[_608];
},_rowToPage:function(_609){
return (this.rowsPerPage?Math.floor(_609/this.rowsPerPage):_609);
},_pageToRow:function(_60a){
return (this.rowsPerPage?this.rowsPerPage*_60a:_60a);
},_preparePage:function(_60b){
if((_60b<this._bop||_60b>=this._eop)&&!this._addingItem){
var _60c=this._rowToPage(_60b);
this._needPage(_60c);
this._bop=_60c*this.rowsPerPage;
this._eop=this._bop+(this.rowsPerPage||this.get("rowCount"));
}
},_needPage:function(_60d){
if(!this._pages[_60d]){
this._pages[_60d]=true;
this._requestPage(_60d);
}
},_requestPage:function(_60e){
var row=this._pageToRow(_60e);
var _60f=Math.min(this.rowsPerPage,this.get("rowCount")-row);
if(_60f>0){
this._requests++;
if(!this._requestsPending(row)){
setTimeout(lang.hitch(this,"_fetch",row,false),1);
}
}
},getCellName:function(_610){
return _610.field;
},_refresh:function(_611){
this._clearData();
this._fetch(0,_611);
},sort:function(){
this.edit.apply();
this._lastScrollTop=this.scrollTop;
this._refresh();
},canSort:function(){
return (!this._isLoading);
},getSortProps:function(){
var c=this.getCell(this.getSortIndex());
if(!c){
if(this.sortFields){
return this.sortFields;
}
return null;
}else{
var desc=c["sortDesc"];
var si=!(this.sortInfo>0);
if(typeof desc=="undefined"){
desc=si;
}else{
desc=si?!desc:desc;
}
return [{attribute:c.field,descending:desc}];
}
},styleRowState:function(_612){
if(this.store&&this.store.getState){
var _613=this.store.getState(_612.index),c="";
for(var i=0,ss=["inflight","error","inserting"],s;s=ss[i];i++){
if(_613[s]){
c=" dojoxGridRow-"+s;
break;
}
}
_612.customClasses+=c;
}
},onStyleRow:function(_614){
this.styleRowState(_614);
this.inherited(arguments);
},canEdit:function(_615,_616){
return this._canEdit;
},_copyAttr:function(idx,attr){
var row={};
var _617={};
var src=this.getItem(idx);
return this.store.getValue(src,attr);
},doStartEdit:function(_618,_619){
if(!this._cache[_619]){
this._cache[_619]=this._copyAttr(_619,_618.field);
}
this.onStartEdit(_618,_619);
},doApplyCellEdit:function(_61a,_61b,_61c){
this.store.fetchItemByIdentity({identity:this._by_idx[_61b].idty,onItem:lang.hitch(this,function(item){
var _61d=this.store.getValue(item,_61c);
if(typeof _61d=="number"){
_61a=isNaN(_61a)?_61a:parseFloat(_61a);
}else{
if(typeof _61d=="boolean"){
_61a=_61a=="true"?true:_61a=="false"?false:_61a;
}else{
if(_61d instanceof Date){
var _61e=new Date(_61a);
_61a=isNaN(_61e.getTime())?_61a:_61e;
}
}
}
this.store.setValue(item,_61c,_61a);
this.onApplyCellEdit(_61a,_61b,_61c);
})});
},doCancelEdit:function(_61f){
var _620=this._cache[_61f];
if(_620){
this.updateRow(_61f);
delete this._cache[_61f];
}
this.onCancelEdit.apply(this,arguments);
},doApplyEdit:function(_621,_622){
var _623=this._cache[_621];
this.onApplyEdit(_621);
},removeSelectedRows:function(){
if(this._canEdit){
this.edit.apply();
var fx=lang.hitch(this,function(_624){
if(_624.length){
_5e4.forEach(_624,this.store.deleteItem,this.store);
this.selection.clear();
}
});
if(this.allItemsSelected){
this.store.fetch({query:this.query,queryOptions:this.queryOptions,onComplete:fx});
}else{
fx(this.selection.getSelected());
}
}
}});
_5e8.cell_markupFactory=function(_625,node,_626){
var _627=lang.trim(html.attr(node,"field")||"");
if(_627){
_626.field=_627;
}
_626.field=_626.field||_626.name;
var _628=lang.trim(html.attr(node,"fields")||"");
if(_628){
_626.fields=_628.split(",");
}
if(_625){
_625(node,_626);
}
};
_5e8.markupFactory=function(_629,node,ctor,_62a){
return _5e6.markupFactory(_629,node,ctor,lang.partial(_5e8.cell_markupFactory,_62a));
};
return _5e8;
});
},"url:davinci/ui/templates/downloadSelected.html":"<div class='downloadDialog'>\t \n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div style=\"margin-bottom: 20px\">\n\t\t  ${fileName}: <input data-dojo-type='dijit/form/ValidationTextBox' type=\"text\" maxLength='${_fileNameMaxLength}' data-dojo-attach-point=\"__fileName\" value='${_projectName}.zip' data-dojo-props=\"regExp:'${_fileNameValidationRegExp}', required:true, invalidMessage:'${invalidDownloadFileName}'\"></input>\n\t\t</div>\n\t\t\n\t\t<div data-dojo-attach-point=\"_selectionDiv\"></div>\n\n  </div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-point=\"_okButton\" data-dojo-attach-event='onClick:okButton' label='${downloadButtonLabel}' class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-event='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>","davinci/actions/DownloadAction":function(){
define("davinci/actions/DownloadAction",["dojo/_base/declare","./Action","../Workbench","../ui/DownloadSelected","system/resource","davinci/ui/Resource","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!./nls/actions","dijit/form/ValidationTextBox"],function(_62b,_62c,_62d,_62e,_62f,_630,_631){
return _62b("davinci.actions.DownloadAction",_62c,{run:function(){
_62d.showModal(new _62e(),_631.downloadFile,{width:"400px"});
},isEnabled:function(_632){
var _633=_630.getSelectedResources();
return _633&&_633.length>0;
}});
});
},"dijit/MenuBar":function(){
require({cache:{"url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\"  role=\"menubar\" tabIndex=\"${tabIndex}\" data-dojo-attach-event=\"onkeypress: _onKeyPress\"></div>\n"}});
define("dijit/MenuBar",["dojo/_base/declare","dojo/_base/event","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_634,_635,keys,_636,_637){
return _634("dijit.MenuBar",_636,{templateString:_637,baseClass:"dijitMenuBar",_isMenuBar:true,postCreate:function(){
this.inherited(arguments);
var l=this.isLeftToRight();
this.connectKeyNavHandlers(l?[keys.LEFT_ARROW]:[keys.RIGHT_ARROW],l?[keys.RIGHT_ARROW]:[keys.LEFT_ARROW]);
this._orient=["below"];
},_moveToPopup:function(evt){
if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){
this.onItemClick(this.focusedChild,evt);
}
},focusChild:function(item){
var _638=this.focusedChild,_639=_638&&_638.popup&&_638.popup.isShowingNow;
this.inherited(arguments);
if(_639&&item.popup&&!item.disabled){
this._openPopup(true);
}
},_onKeyPress:function(evt){
if(evt.ctrlKey||evt.altKey){
return;
}
switch(evt.charOrCode){
case keys.DOWN_ARROW:
this._moveToPopup(evt);
_635.stop(evt);
}
},onItemClick:function(item,evt){
if(item.popup&&item.popup.isShowingNow&&(evt.type!=="keypress"||evt.keyCode!==keys.DOWN_ARROW)){
item.popup.onCancel();
}else{
this.inherited(arguments);
}
}});
});
},"url:davinci/ui/widgets/templates/AddFiles.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<label for=\"fileDialogParentFolder\">${uiNLS.parentFolder}</label>\n\t\t<div data-dojo-attach-point=\"fileDialogParentFolder\"></div>\n\t\t<div style=\"margin: 1em 0 1em 0\">\n\t\t\t<input data-dojo-attach-point=\"uploader\" multiple=\"true\" type=\"file\" data-dojo-type=\"dojox.form.Uploader\"/>\n\t\t</div>\n\t\t<div data-dojo-attach-point=\"filelist\"></div>\n\t\t<div data-dojo-attach-point=\"zipWarning\" style=\"display:none; margin-top: 1em; background:yellow\">${uiNLS.explodeZipWarning}</div>\n\t</div>\n\n  <div class=\"dijitDialogPaneActionBar\">\n  \t<button data-dojo-attach-point=\"uploadBtn\" data-dojo-type=\"dijit/form/Button\" class=\"maqPrimaryButton\">${uiNLS.upload}</button>\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-event='onClick:_cancelButton' class=\"maqSecondaryButton\">${uiNLS.cancelButtonLabel}</button>\n\t</div>\n</div>\n","system/resource":function(){
define("system/resource",["require","dojo/_base/declare","dojo/_base/xhr","dojo/Deferred","davinci/model/Path","davinci/Runtime","davinci/model/resource/Folder"],function(_63a,_63b,xhr,_63c,Path,_63d,_63e){
var _63f={root:null,__CASE_SENSITIVE:false,resourceChanged:function(type,_640){
if(type!=="deleted"&&_640==system.resource.getRoot()){
_640.reload();
system.resource.getRoot().getChildrenSync(dojo.hitch(system.resource,function(_641){
system.resource.onChildrenChange(system.resource.getRoot(),_641);
}));
return system.resource.getRoot();
}else{
if(type=="created"||type=="deleted"||type=="renamed"||type=="updated"||type=="reload"){
var _642,_643;
if(_640.parent){
_642=_640.parent;
_643=_640.getPath();
}else{
var p1=new Path(_640).removeLastSegments();
_642=system.resource.findResource(p1.toString())||system.resource.getRoot();
_643=_640;
}
if(type=="deleted"&&_640.elementType=="Folder"){
system.resource.onChildrenChange(_640,[]);
}
if(_642.elementType=="Folder"&&type=="reload"){
_642.reload();
}
if(type=="renamed"){
system.resource.onChange(_640);
}
_642.getChildrenSync(function(_644){
system.resource.onChildrenChange(_642,_644);
},function(e){
console.error(e);
});
}
}
if(type=="deleted"){
var _645=dijit.byId("resourceTree");
_645.attr("selectedItem",null);
}
},createText:function(type,_646){
return "";
},createResource:function(_647,_648,_649){
var _64a=_647.split("/");
_649=_649||system.resource.getWorkspace();
var _64b=!_648?_64a.length-1:_64a.length;
for(var i=0;i<_64b;i++){
if(_64a[i]=="."||_64a[i]==""){
continue;
}
var _64c=_649.getChildSync(_64a[i]);
if(_64c!=null){
_649=_64c;
}else{
_649=_649.createResource(_64a[i],true);
}
}
if(!_648){
_649=_649.createResource(_64a[_64a.length-1]);
}
return _649;
},listProjects:function(_64d,_64e){
var _64f=system.resource.getRoot();
if(_64f.parent){
_64f=_64f.parent;
}
_64f.getChildren(_64d,_64e);
},createProject:function(_650){
return xhr.get({url:"cmd/createProject",handleAs:"text",content:{name:_650.newProjectName,projectToClone:_650.projectToClone,eclipseSupport:!!_650.eclipseSupport,projectTemplate:_650.projectTemplateName}});
},newItem:function(args,_651){
},pasteItem:function(_652,_653,_654,_655){
},onChange:function(item){
},onChildrenChange:function(_656,_657){
},getLabel:function(item){
var _658=item.getName();
if(item.link){
_658=_658+"  ["+item.link+"]";
}
return _658;
},getIdentity:function(item){
return item.getId();
},destroy:function(){
system.resource.subscriptions.forEach(dojo.unsubscribe);
},mayHaveChildren:function(item){
return item.elementType=="Folder";
},getRoot:function(_659,_65a){
if(!system.resource.root){
var _65b=system.resource.getWorkspace(),_65c=_63a("davinci/Workbench");
if(_65c.singleProjectMode()){
var _65d=_65c.getProject();
system.resource.root=system.resource.findResource(_65d,false,_65b);
}else{
system.resource.root=_65b;
}
system.resource.root._readOnly=false;
}
if(_659){
_659(system.resource.root);
}else{
return system.resource.root;
}
},getWorkspace:function(){
if(!this.workspace){
this.workspace=new _63e(".",null);
}
return this.workspace;
},getChildren:function(_65e,_65f,_660){
_65e.getChildren(_65f,_660);
},copy:function(_661,_662,_663){
var path=_661.getPath?_661.getPath():_661;
var _664=_662.getPath?_662.getPath():_662;
var _665=_63d.serverJSONRequest({url:"cmd/copy",handleAs:"text",sync:true,content:{source:path,dest:_664,recurse:String(_663)}});
system.resource.resourceChanged("reload",_662);
},download:function(_666,_667,root,_668,_669){
var _66a="";
var _66b="";
if(_668){
_66a="&libs="+encodeURIComponent(dojo.toJson(_668));
}
if(root){
_66b="&root="+encodeURIComponent(root);
}
if(_669){
for(var name in _669){
_66b+="&"+encodeURIComponent(name)+"="+encodeURIComponent(_669[name]);
}
}
window.location.href="cmd/download?fileName="+_667+_66b+"&resources="+encodeURIComponent(dojo.toJson(_666))+_66a;
},findResourceAsync:function(name,_66c,_66d,_66e){
var _66f=new _63c();
var _670=this.findResource(name,_66c,_66d,_66e);
if(_670){
_66f.resolve(_670);
}else{
_66f.reject();
}
return _66f;
},findResource:function(name,_671,_672,_673){
_671=_671||!system.resource.__CASE_SENSITIVE;
var seg1=0,_674;
var _675=system.resource.getWorkspace();
if(_672){
if(typeof _672=="string"){
var _676=_672;
_672=system.resource.findResource(_672,_671);
if(!_672){
console.error("resource.findResoure: Folder "+_676+" not found");
return null;
}
}
_675=_672;
}
if(typeof name=="string"){
_674=name.split("/");
if(_674[0]=="."){
seg1=1;
}
}else{
if(name.getSegments){
_674=name.getSegments();
name=name.toString();
}
}
var _677=_674.some(function(_678){
return _678.indexOf("*")!=-1;
});
var _679;
function _67a(){
for(var i=seg1;i<_674.length;i++){
var _67b=null;
if(!_675._isLoaded){
_679=true;
break;
}
if(_674[i]==".."){
_67b=_675=_675.parent;
}else{
if(_674[i]!="."){
_67b=_675=_675.getChildSync(_674[i]);
}
}
if(!_67b){
return;
}
}
return _67b;
};
var _67c;
if(!_677){
_67c=_67a();
}
var _67d=[];
if(!_67c&&(_679||_677)){
var _67e=_63d.serverJSONRequest({url:"cmd/findResource",content:{path:name,ignoreCase:_671,workspaceOnly:_673,inFolder:_672?_672.getPath():null},sync:true});
if(_67e&&_67e.length){
_67d=_67e.map(function(_67f){
var _680=system.resource.getWorkspace();
for(var j=0;j<_67f.parents.length;j++){
if(!_680._isLoaded){
_680.setChildrenSync(_67f.parents[j].members);
}
if(j+1<_67f.parents.length){
var name=_67f.parents[j+1].name;
var _681=_680.getChildSync(name);
if(!_681){
_681=new _63e(name,_680);
}
_680=_681;
}
}
_675=system.resource.getWorkspace();
seg1=0;
_674=_67f.file.split("/");
if(_674[0]=="."){
seg1=1;
}
return _67a();
});
}
}else{
_67d=[_67c];
}
return _677?_67d:_67d[0];
},alphabeticalSort:function(_682){
return _682.sort(function(a,b){
a=a.name.toLowerCase();
b=b.name.toLowerCase();
return a<b?-1:(a>b?1:0);
});
}};
var _683=[dojo.subscribe("/davinci/resource/resourceChanged",_63f,function(){
return _63f.resourceChanged;
}())];
return dojo.setObject("system.resource",_63f);
});
},"orion/editor/keyBinding":function(){
define("orion/editor/keyBinding",["orion/editor/util"],function(util){
function _684(_685,mod1,mod2,mod3,mod4){
if(typeof (_685)==="string"){
this.keyCode=_685.toUpperCase().charCodeAt(0);
}else{
this.keyCode=_685;
}
this.mod1=mod1!==undefined&&mod1!==null?mod1:false;
this.mod2=mod2!==undefined&&mod2!==null?mod2:false;
this.mod3=mod3!==undefined&&mod3!==null?mod3:false;
this.mod4=mod4!==undefined&&mod4!==null?mod4:false;
};
_684.prototype={match:function(e){
if(this.keyCode===e.keyCode){
var mod1=util.isMac?e.metaKey:e.ctrlKey;
if(this.mod1!==mod1){
return false;
}
if(this.mod2!==e.shiftKey){
return false;
}
if(this.mod3!==e.altKey){
return false;
}
if(util.isMac&&this.mod4!==e.ctrlKey){
return false;
}
return true;
}
return false;
},equals:function(kb){
if(!kb){
return false;
}
if(this.keyCode!==kb.keyCode){
return false;
}
if(this.mod1!==kb.mod1){
return false;
}
if(this.mod2!==kb.mod2){
return false;
}
if(this.mod3!==kb.mod3){
return false;
}
if(this.mod4!==kb.mod4){
return false;
}
return true;
}};
return {KeyBinding:_684};
});
},"davinci/html/CSSAtRule":function(){
define("davinci/html/CSSAtRule",["dojo/_base/declare","davinci/html/CSSElement"],function(_686,_687){
return _686("davinci.html.CSSAtRule",_687,{constructor:function(){
this.elementType="CSSAtRule";
},getCSSFile:function(){
return this.parent;
},getText:function(_688){
s="@";
s=s+this.name+" "+this.value+"\n";
return s;
}});
});
},"dijit/Dialog":function(){
require({cache:{"url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n"}});
define("dijit/Dialog",["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","./main","dojo/i18n!./nls/common"],function(_689,_68a,_68b,_68c,_68d,dom,_68e,_68f,_690,_691,fx,i18n,keys,lang,on,_692,has,_693,_694,_695,_696,_697,_698,_699,_69a,_69b,_69c,_69d,_69e,_69f,_6a0){
var _6a1=_68c("dijit._DialogBase",[_699,_69b,_69c,_69a],{templateString:_69f,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}],open:false,duration:_697.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){
this._set("draggable",val);
},"aria-describedby":"",maxRatio:0.9,postMixInProperties:function(){
var _6a2=i18n.getLocalization("dijit","common");
lang.mixin(this,_6a2);
this.inherited(arguments);
},postCreate:function(){
_690.set(this.domNode,{display:"none",position:"absolute"});
this.ownerDocumentBody.appendChild(this.domNode);
this.inherited(arguments);
this.connect(this,"onExecute","hide");
this.connect(this,"onCancel","hide");
this._modalconnects=[];
},onLoad:function(){
this._position();
if(this.autofocus&&_6a3.isTop(this)){
this._getFocusItems(this.domNode);
_696.focus(this._firstFocusItem);
}
this.inherited(arguments);
},_onBlur:function(by){
this.inherited(arguments);
var _6a4=lang.hitch(this,function(){
if(this.open&&!this._destroyed&&_6a3.isTop(this)){
this._getFocusItems(this.domNode);
_696.focus(this._firstFocusItem);
}
});
if(by=="mouse"){
on.once(this.ownerDocument,"mouseup",_6a4);
}else{
_6a4();
}
},_endDrag:function(){
var _6a5=_68f.position(this.domNode),_6a6=_693.getBox(this.ownerDocument);
_6a5.y=Math.min(Math.max(_6a5.y,0),(_6a6.h-_6a5.h));
_6a5.x=Math.min(Math.max(_6a5.x,0),(_6a6.w-_6a5.w));
this._relativePosition=_6a5;
this._position();
},_setup:function(){
var node=this.domNode;
if(this.titleBar&&this.draggable){
this._moveable=new ((has("ie")==6)?_695:_694)(node,{handle:this.titleBar});
this.connect(this._moveable,"onMoveStop","_endDrag");
}else{
_68e.add(node,"dijitDialogFixed");
}
this.underlayAttrs={dialogId:this.id,"class":_68a.map(this["class"].split(/\s/),function(s){
return s+"_underlay";
}).join(" "),ownerDocument:this.ownerDocument};
},_size:function(){
this._checkIfSingleChild();
if(this._singleChild){
if(typeof this._singleChildOriginalStyle!="undefined"){
this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;
delete this._singleChildOriginalStyle;
}
}else{
_690.set(this.containerNode,{width:"auto",height:"auto"});
}
var bb=_68f.position(this.domNode);
var _6a7=_693.getBox(this.ownerDocument);
_6a7.w*=this.maxRatio;
_6a7.h*=this.maxRatio;
if(bb.w>=_6a7.w||bb.h>=_6a7.h){
var _6a8=_68f.position(this.containerNode),w=Math.min(bb.w,_6a7.w)-(bb.w-_6a8.w),h=Math.min(bb.h,_6a7.h)-(bb.h-_6a8.h);
if(this._singleChild&&this._singleChild.resize){
if(typeof this._singleChildOriginalStyle=="undefined"){
this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;
}
this._singleChild.resize({w:w,h:h});
}else{
_690.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});
}
}else{
if(this._singleChild&&this._singleChild.resize){
this._singleChild.resize();
}
}
},_position:function(){
if(!_68e.contains(this.ownerDocumentBody,"dojoMove")){
var node=this.domNode,_6a9=_693.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_68f.position(node),l=Math.floor(_6a9.l+(p?p.x:(_6a9.w-bb.w)/2)),t=Math.floor(_6a9.t+(p?p.y:(_6a9.h-bb.h)/2));
_690.set(node,{left:l+"px",top:t+"px"});
}
},_onKey:function(evt){
if(evt.charOrCode){
var node=evt.target;
if(evt.charOrCode===keys.TAB){
this._getFocusItems(this.domNode);
}
var _6aa=(this._firstFocusItem==this._lastFocusItem);
if(node==this._firstFocusItem&&evt.shiftKey&&evt.charOrCode===keys.TAB){
if(!_6aa){
_696.focus(this._lastFocusItem);
}
_691.stop(evt);
}else{
if(node==this._lastFocusItem&&evt.charOrCode===keys.TAB&&!evt.shiftKey){
if(!_6aa){
_696.focus(this._firstFocusItem);
}
_691.stop(evt);
}else{
while(node){
if(node==this.domNode||_68e.contains(node,"dijitPopup")){
if(evt.charOrCode==keys.ESCAPE){
this.onCancel();
}else{
return;
}
}
node=node.parentNode;
}
if(evt.charOrCode!==keys.TAB){
_691.stop(evt);
}else{
if(!has("opera")){
try{
this._firstFocusItem.focus();
}
catch(e){
}
}
}
}
}
}
},show:function(){
if(this.open){
return;
}
if(!this._started){
this.startup();
}
if(!this._alreadyInitialized){
this._setup();
this._alreadyInitialized=true;
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
var win=_693.get(this.ownerDocument);
this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));
this._modalconnects.push(on(this.domNode,_68b._keypress,lang.hitch(this,"_onKey")));
_690.set(this.domNode,{opacity:0,display:""});
this._set("open",true);
this._onShow();
this._size();
this._position();
var _6ab;
this._fadeInDeferred=new _68d(lang.hitch(this,function(){
_6ab.stop();
delete this._fadeInDeferred;
}));
_6ab=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){
_6a3.show(this,this.underlayAttrs);
}),onEnd:lang.hitch(this,function(){
if(this.autofocus&&_6a3.isTop(this)){
this._getFocusItems(this.domNode);
_696.focus(this._firstFocusItem);
}
this._fadeInDeferred.resolve(true);
delete this._fadeInDeferred;
})}).play();
return this._fadeInDeferred;
},hide:function(){
if(!this._alreadyInitialized||!this.open){
return;
}
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
var _6ac;
this._fadeOutDeferred=new _68d(lang.hitch(this,function(){
_6ac.stop();
delete this._fadeOutDeferred;
}));
this._fadeOutDeferred.then(lang.hitch(this,"onHide"));
_6ac=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){
this.domNode.style.display="none";
_6a3.hide(this);
this._fadeOutDeferred.resolve(true);
delete this._fadeOutDeferred;
})}).play();
if(this._scrollConnected){
this._scrollConnected=false;
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
if(this._relativePosition){
delete this._relativePosition;
}
this._set("open",false);
return this._fadeOutDeferred;
},resize:function(){
if(this.domNode.style.display!="none"){
if(_69d._singleton){
_69d._singleton.layout();
}
this._position();
this._size();
}
},destroy:function(){
if(this._fadeInDeferred){
this._fadeInDeferred.cancel();
}
if(this._fadeOutDeferred){
this._fadeOutDeferred.cancel();
}
if(this._moveable){
this._moveable.destroy();
}
var h;
while(h=this._modalconnects.pop()){
h.remove();
}
_6a3.hide(this);
this.inherited(arguments);
}});
var _6ad=_68c("dijit.Dialog",[_69e,_6a1],{});
_6ad._DialogBase=_6a1;
var _6a3=_6ad._DialogLevelManager={_beginZIndex:950,show:function(_6ae,_6af){
ds[ds.length-1].focus=_696.curNode;
var _6b0=_69d._singleton;
if(!_6b0||_6b0._destroyed){
_6b0=_6a0._underlay=_69d._singleton=new _69d(_6af);
}else{
_6b0.set(_6ae.underlayAttrs);
}
var _6b1=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_6ad._DialogLevelManager._beginZIndex;
if(ds.length==1){
_6b0.show();
}
_690.set(_69d._singleton.domNode,"zIndex",_6b1-1);
_690.set(_6ae.domNode,"zIndex",_6b1);
ds.push({dialog:_6ae,underlayAttrs:_6af,zIndex:_6b1});
},hide:function(_6b2){
if(ds[ds.length-1].dialog==_6b2){
ds.pop();
var pd=ds[ds.length-1];
if(!_69d._singleton._destroyed){
if(ds.length==1){
_69d._singleton.hide();
}else{
_690.set(_69d._singleton.domNode,"zIndex",pd.zIndex-1);
_69d._singleton.set(pd.underlayAttrs);
}
}
if(_6b2.refocus){
var _6b3=pd.focus;
if(pd.dialog&&(!_6b3||!dom.isDescendant(_6b3,pd.dialog.domNode))){
pd.dialog._getFocusItems(pd.dialog.domNode);
_6b3=pd.dialog._firstFocusItem;
}
if(_6b3){
try{
_6b3.focus();
}
catch(e){
}
}
}
}else{
var idx=_68a.indexOf(_68a.map(ds,function(elem){
return elem.dialog;
}),_6b2);
if(idx!=-1){
ds.splice(idx,1);
}
}
},isTop:function(_6b4){
return ds[ds.length-1].dialog==_6b4;
}};
var ds=_6ad._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];
if(has("dijit-legacy-requires")){
_692(0,function(){
var _6b5=["dijit/TooltipDialog"];
_689(_6b5);
});
}
return _6ad;
});
},"davinci/ve/VisualEditor":function(){
require({cache:{"url:davinci/ve/template.html":"<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\" />\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n<title>Untitled</title>\n</head>\n<body>\n</body>\n</html>\n"}});
define("davinci/ve/VisualEditor",["dojo/_base/declare","dojo/_base/lang","dojo/_base/connect","dojo/dom-class","dojo/dom-construct","dojo/promise/all","dojo/text!./template.html","../Runtime","../Workbench","../model/Path","./metadata","./Context","preview/silhouetteiframe","preview/loadIndicator","../workbench/Preferences","./widget","../XPathUtils","../html/HtmlFileXPathAdapter","./utils/GeomUtils"],function(_6b6,lang,_6b7,_6b8,_6b9,all,_6ba,_6bb,_6bc,Path,_6bd,_6be,_6bf,_6c0,_6c1,_6c2,_6c3,_6c4,_6c5){
var _6c6=_6b6("davinci.ve.VisualEditor",null,{deviceName:"none",_orientation:"portrait",_subscriptions:[],constructor:function(_6c7,_6c8){
this._pageEditor=_6c8;
this.contentPane=dijit.getEnclosingWidget(_6c7);
this.loadingDiv=_6b9.create("div",{className:"loading",innerHTML:dojo.replace("<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;{0}</td></tr></table>",["Loading..."])},this.contentPane.domNode.parentNode,"first");
_6b8.add(this.contentPane.domNode,"fullPane");
var _6c9=_6b9.create("div",{className:"silhouette_div_container"},this.contentPane.domNode);
_6b9.create("span",{className:"silhouetteiframe_object_container"},_6c9);
this.silhouetteiframe=new _6bf({rootNode:_6c9,margin:20});
var _6ca=this;
this.contentPane.connect(this.contentPane,"resize",function(_6cb){
var _6cc=dojo.query(".designCP iframe",this._pageEditor.domNode)[0];
if(_6cc&&_6cc.contentDocument&&_6cc.contentDocument.body){
var _6cd=_6cc.contentDocument.body;
_6ca._resizeBody(_6cd,_6cb);
setTimeout(function(){
var _6ce=_6ca.getContext();
_6ce.clearCachedWidgetBounds();
_6ce.updateFocusAll();
_6ca._registerScrollHandlers();
},100);
}
}.bind(this));
this._pageEditor.deferreds=all(_6bd.getDeferreds());
this._subscriptions.push(dojo.subscribe("/davinci/ui/editorSelected",this._editorSelected.bind(this)));
this._subscriptions.push(dojo.subscribe("/davinci/ui/context/loaded",this._contextLoaded.bind(this)));
var _6cf=document.getElementById("visualEditorBorder");
if(!_6cf){
var _6d0=document.getElementById("editorsStackContainer");
_6cf=_6b9.create("div",{id:"visualEditorBorder"},_6d0);
_6b9.create("div",{id:"visualEditorBorderTopLeft"},_6cf);
_6b9.create("div",{id:"visualEditorBorderTopRight"},_6cf);
_6b9.create("div",{id:"visualEditorBorderTop"},_6cf);
_6b9.create("div",{id:"visualEditorBorderRight"},_6cf);
_6b9.create("div",{id:"visualEditorBorderLeft"},_6cf);
}
},getDevice:function(){
return this.deviceName;
},setDevice:function(_6d1,_6d2){
this.deviceName=_6d1;
var _6d3=this.getContext();
_6d3.setMobileMeta(_6d1);
if(!_6d2){
_6d3.setMobileTheme(_6d1);
}
var _6d4=_6d1=="none"?null:"app/preview/images/"+_6d1+".svg";
this.silhouetteiframe.setSVGFilename(_6d4);
_6d3.clearCachedWidgetBounds();
dojo.publish("/davinci/ui/deviceChanged",[_6d1]);
dojo.publish("/davinci/ui/repositionFocusContainer",[]);
},toggleOrientation:function(){
if(this.deviceName!="none"){
this.setOrientation(this._orientation=="landscape"?"portrait":"landscape");
}
this.getContext().clearCachedWidgetBounds();
},getOrientation:function(_6d5){
return this._orientation;
},setOrientation:function(_6d6){
if(this.deviceName!="none"&&this._orientation!=_6d6){
this._orientation=_6d6;
var _6d7=_6bc.getOpenEditor();
if(_6d7.editorContainer&&_6d7.editorContainer.updateToolbars){
_6d7.editorContainer.updateToolbars();
}
var _6d8=this.getContext();
_6d8.setMobileOrientation(this._orientation);
this.silhouetteiframe.setOrientation(this._orientation);
_6d7._visualChanged();
setTimeout(function(){
_6d8.clearCachedWidgetBounds();
_6d8.updateFocusAll();
},100);
}
},_objectPropertiesChange:function(_6d9){
if(!this.isActiveEditor()){
return;
}
var _6da=this.getContext();
var _6db=_6d9.command;
var _6dc=_6da.getCommandStack();
_6dc.execute(_6d9.compoundCommand||_6db);
if(_6db._newId){
var _6dd=_6c2.byId(_6db._newId,_6da.getDocument());
_6da.select(_6dd);
}else{
var _6de=_6da.getSelection();
var _6dd=_6de.length?_6de[_6de.length-1]:undefined;
if(_6de.length>1){
_6da.select(_6dd);
}
}
this._srcChanged();
},isActiveEditor:function(){
var _6df=_6bb.currentEditor;
return _6df&&_6df.declaredClass=="davinci.ve.PageEditor"&&_6df.visualEditor==this;
},_stylePropertiesChange:function(_6e0){
if(!this.isActiveEditor()){
return;
}
var _6e1=this.getContext().getCommandForStyleChange(_6e0);
if(_6e1){
this.getContext().getCommandStack().execute(_6e1);
if(_6e1._newId){
var _6e2=_6c2.byId(_6e1._newId,context.getDocument());
this.context.select(_6e2);
}
this._srcChanged();
dojo.publish("/davinci/ui/widgetValuesChanged",[_6e0]);
}
},_srcChanged:function(){
this.isDirty=true;
},getContext:function(){
return this.context;
},getTemplate:function(){
return _6ba;
},destroy:function(){
if(!this._handles){
return;
}
if(this._focusPopup){
this._focusPopup.destroyRecursive();
}
delete this._focusPopup;
this.context.destroy();
this._handles.forEach(dojo.disconnect);
if(this._iframeScrollHandler){
dojo.disconnect(this._iframeScrollHandler);
delete this._iframeScrollHandler;
}
if(this._designCPScrollHandler){
dojo.disconnect(this._designCPScrollHandler);
delete this._designCPScrollHandler;
}
this._subscriptions.forEach(dojo.unsubscribe);
this._subscriptions=[];
},setContent:function(_6e3,_6e4,_6e5){
this._onloadMessages=[];
this._setContent(_6e3,_6e4,_6e5);
},saveAs:function(_6e6,_6e7,_6e8){
this._setContent(_6e6,_6e8);
},_setContent:function(_6e9,_6ea,_6eb){
this._setContentRaw(_6e9,_6ea,_6eb);
},_setContentRaw:function(_6ec,_6ed,_6ee){
this.fileName=_6ec;
this.basePath=new Path(_6ec);
if(!this.initialSet){
var _6ef=_6bb.getUserWorkspaceUrl();
if(_6ec.indexOf("./")==0){
_6ec=_6ec.substring(2,_6ec.length);
}
var _6f0=_6ef+_6ec;
this._handles=[];
var _6f1=dojo.query(".silhouette_div_container",this.contentPane.domNode)[0];
this.context=new _6be({editor:this._pageEditor,visualEditor:this,containerNode:_6f1,model:_6ed,baseURL:_6f0,iframeattrs:{"class":"silhouetteiframe_iframe"}});
this.context._commandStack=this._commandStack;
this._commandStack._context=this.context;
var _6f2=_6c1.getPreferences("davinci.ve.editorPrefs",_6bc.getProject());
if(_6f2){
this.context.setPreferences(_6f2);
}
this._handles.push(dojo.connect(this.context,"onContentChange",this,this.onContentChange));
this.title=dojo.doc.title;
this.context._setSource(_6ed,this._connectCallback,this,_6ee);
this.context.getFlowLayout();
this.initialSet=true;
}else{
this.context.setSource(_6ed,this.context._restoreStates,this.context);
}
},_connectCallback:function(_6f3){
try{
if(_6f3 instanceof Error){
throw _6f3;
}
var _6f4=this.context,_6f5;
this.savePoint=0;
_6f4.activate();
_6f5=_6bc.createPopup({partID:"davinci.ve.visualEditor",domNode:_6f4.getContainerNode(),keysDomNode:_6f4.getDocument(),context:_6f4});
_6f5.adjustPosition=function(_6f6){
var _6f7=dojo.position(_6f4.frameNode);
dojo.withDoc(_6f4.getDocument(),function(){
var _6f8=dojo.docScroll();
_6f7.x-=_6f8.x;
_6f7.y-=_6f8.y;
});
return _6f7;
};
this._focusPopup=_6bc.createPopup({partID:"davinci.ve.visualEditor",domNode:_6f4.getFocusContainer(),keysDomNode:_6f4.getDocument(),context:_6f4});
_6f4.getTopWidgets().forEach(function(_6f9){
if(_6f9.resize){
_6f9.resize();
}
});
_6f4.anyDojoxMobileWidgets=undefined;
dojo.publish("/davinci/ui/context/pagebuilt",[_6f4]);
}
catch(e){
_6f3=e;
}
finally{
if(_6f3.errorMessage){
this.loadingDiv.innerHTML=_6f3.errorMessage||"(unknown)";
}else{
if(_6f3 instanceof Error){
var _6fa="Uh oh! An error has occurred:<br><b>"+_6f3.message+"</b>";
if(_6f3.fileName){
_6fa+="<br>file: "+_6f3.fileName+"<br>line: "+_6f3.lineNumber;
}
if(_6f3.stack){
_6fa+="<br><pre>"+_6f3.stack+"</pre>";
}
this.loadingDiv.innerHTML=_6fa;
_6b8.add(this.loadingDiv,"error");
}else{
if(this.loadingDiv.parentNode){
this.loadingDiv.parentNode.removeChild(this.loadingDiv);
}
delete this.loadingDiv;
}
}
}
},getSelectedWidget:function(){
var _6fb=this.getContext(),_6fc=_6fb.getSelection(),_6fd=_6fc.length?_6fc[_6fc.length-1]:undefined;
if(_6fc.length>1){
_6fb.select(_6fd);
}
return _6fd;
},getSelectedSubWidget:function(){
return this._selectedSubWidget;
},save:function(_6fe){
if(!this.context){
return;
}
var _6ff=[],_700=this.context.getModel();
_700.setDirty(true);
var _701={visit:function(node){
if((node.elementType=="HTMLFile"||node.elementType=="CSSFile")&&node.isDirty()){
_6ff.push(node.save(_6fe));
}
return false;
}};
_700.visit(_701);
_6ff=_6ff.concat(this.getContext().saveDynamicCssFiles(this.context.cssFiles,_6fe));
if(_6ff.length){
this.savePromise=all(_6ff);
}else{
delete this.savePromise;
}
return this.savePromise;
},removeWorkingCopy:function(){
},getDefaultContent:function(){
return this.getTemplate();
},previewInBrowser:function(){
var _702=this.deviceName,_703=_6bc.getOpenEditor().resourceFile.getURL(),_704=[];
if(_702!="none"){
_704=["preview=1","device="+encodeURIComponent(_702),"file="+encodeURIComponent(_703)];
_703=_6bc.location();
if(this._orientation=="landscape"){
_704.push("orientation="+this._orientation);
}
}
var _705=this.context.getPreference("zazl");
if(_705){
_704.push("zazl=true");
}
if(_704.length){
_703+="?"+_704.join("&");
}
var _706=function(){
var _707=window.open(_703,"preview_"+_703);
_6c0(_707,_6bb.location()+require.toUrl("dojox/image/resources/images/loading.gif"),"gray");
};
if(this.savePromise){
this.savePromise.then(_706);
}else{
_706();
}
},refresh:function(){
var _708=this.context,_709=_6c3.getXPath(_708.getSelection()[0]._srcElement,_6c4);
_708.setSource(_708.model);
var id=_708.model.evaluate(_709).getAttribute("id"),_70a=_6c2.byId(id,_708.getDocument());
setTimeout(function(){
_708.select(_70a);
},0);
},_contextLoaded:function(_70b){
if(_70b==this.getContext()){
this._registerScrollHandlers();
}
},_editorSelected:function(_70c){
var _70d=this.getContext();
var _70e=_70d?_70d.getFocusContainer():null;
if(_70c.oldEditor==this._pageEditor){
if(_70e&&this._focusPopup){
this._focusPopup.unBindDomNode(_70e);
}
}
if(_70c.editor==this._pageEditor){
this._registerScrollHandlers();
if(_70e&&this._focusPopup){
this._focusPopup.bindDomNode(_70e);
}
}
var _70f=document.getElementById("visualEditorBorder");
if(_70f){
if(!_70c.editor||_70c.editor.declaredClass!="davinci.ve.PageEditor"){
_70f.style.display="none";
}else{
_70f.style.display="block";
}
}
},_resizeBody:function(_710,size){
var _711=_6c5.getScrollLeft(_710);
var _712=_6c5.getScrollTop(_710);
if(_711>0){
_710.style.width=(size.w+_711)+"px";
}else{
_710.style.width="100%";
}
if(_712>0){
_710.style.height=(size.h+_712)+"px";
}else{
_710.style.height="100%";
}
},_scrollHandler:function(e){
var _713=dojo.query(".designCP iframe",this._pageEditor.domNode)[0];
if(_713&&_713.contentDocument&&_713.contentDocument.body){
var _714=_713.contentDocument.body;
this._resizeBody(_714,{w:dojo.style(this.contentPane.domNode,"width"),h:dojo.style(this.contentPane.domNode,"height")});
setTimeout(function(){
var _715=this.getContext();
_715.clearCachedWidgetBounds();
_715.updateFocusAll();
}.bind(this),100);
}
},_registerScrollHandlers:function(){
if(!this._iframeScrollHandler){
var _716=dojo.query(".designCP iframe",this._pageEditor.domNode)[0];
if(_716&&_716.contentDocument&&_716.contentDocument.body){
var _717=_716.contentDocument.body;
this._iframeScrollHandler=dojo.connect(_717.ownerDocument,"onscroll",this,this._scrollHandler);
}
}
if(!this._designCPScrollHandler){
var _718=dojo.query(".designCP",this._pageEditor.domNode)[0];
if(_718){
this._designCPScrollHandler=dojo.connect(_718,"onscroll",this,this._scrollHandler);
}
}
}});
return _6c6;
});
},"dojox/form/Uploader":function(){
require({cache:{"url:dojox/form/resources/Uploader.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdojoAttachEvent=\"ondijitclick:_onClick\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdojoAttachPoint=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" dojoAttachPoint=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdojoAttachPoint=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><!--no need to have this for Uploader \n\t<input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdojoAttachPoint=\"valueNode\"\n/--></span>\n"}});
define("dojox/form/Uploader",["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/array","dojo/_base/connect","dojo/_base/window","dojo/dom-style","dojo/dom-geometry","dojo/dom-attr","dojo/dom-construct","dojo/dom-form","dijit","dijit/form/Button","dojox/form/uploader/Base","dojo/i18n!./nls/Uploader","dojo/text!./resources/Uploader.html"],function(_719,_71a,lang,_71b,_71c,win,_71d,_71e,_71f,_720,_721,_722,_723,_724,res,_725){
_719.experimental("dojox.form.Uploader");
_71a("dojox.form.Uploader",[_724,_723],{uploadOnSelect:false,tabIndex:0,multiple:false,label:res.label,url:"",name:"uploadedfile",flashFieldName:"",uploadType:"form",showInput:"",_nameIndex:0,templateString:_725,baseClass:"dijitUploader "+_723.prototype.baseClass,postMixInProperties:function(){
this._inputs=[];
this._cons=[];
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
_71d.set(this.domNode,{overflow:"hidden",position:"relative"});
this._buildDisplay();
_71f.set(this.titleNode,"tabIndex",-1);
},_buildDisplay:function(){
if(this.showInput){
this.displayInput=dojo.create("input",{"class":"dijitUploadDisplayInput","tabIndex":-1,"autocomplete":"off"},this.containerNode,this.showInput);
this._attachPoints.push("displayInput");
this.connect(this,"onChange",function(_726){
var i=0,l=_726.length,f,r=[];
while((f=_726[i++])){
if(f&&f.name){
r.push(f.name);
}
}
this.displayInput.value=r.join(", ");
});
this.connect(this,"reset",function(){
this.displayInput.value="";
});
}
},startup:function(){
if(this._buildInitialized){
return;
}
this._buildInitialized=true;
this._getButtonStyle(this.domNode);
this._setButtonStyle();
this.inherited(arguments);
},onChange:function(_727){
},onBegin:function(_728){
},onProgress:function(_729){
},onComplete:function(_72a){
this.reset();
},onCancel:function(){
},onAbort:function(){
},onError:function(_72b){
},upload:function(_72c){
},submit:function(form){
form=!!form?form.tagName?form:this.getForm():this.getForm();
var data=_721.toObject(form);
this.upload(data);
},reset:function(){
delete this._files;
this._disconnectButton();
_71b.forEach(this._inputs,_720.destroy,dojo);
this._inputs=[];
this._nameIndex=0;
this._createInput();
},getFileList:function(){
var _72d=[];
if(this.supports("multiple")){
_71b.forEach(this._files,function(f,i){
_72d.push({index:i,name:f.name,size:f.size,type:f.type});
},this);
}else{
_71b.forEach(this._inputs,function(n,i){
if(n.value){
_72d.push({index:i,name:n.value.substring(n.value.lastIndexOf("\\")+1),size:0,type:n.value.substring(n.value.lastIndexOf(".")+1)});
}
},this);
}
return _72d;
},_getValueAttr:function(){
return this.getFileList();
},_setValueAttr:function(_72e){
console.error("Uploader value is read only");
},_setDisabledAttr:function(_72f){
if(this.disabled==_72f||!this.inputNode){
return;
}
this.inherited(arguments);
_71d.set(this.inputNode,"display",_72f?"none":"");
},_getButtonStyle:function(node){
this.btnSize={w:_71d.get(node,"width"),h:_71d.get(node,"height")};
},_setButtonStyle:function(){
this.inputNodeFontSize=Math.max(2,Math.max(Math.ceil(this.btnSize.w/60),Math.ceil(this.btnSize.h/15)));
this._createInput();
},_getFileFieldName:function(){
var name;
if(this.multiple&&this.supports("multiple")){
name=this.name+"s[]";
}else{
name=this.name+(this.multiple?this._nameIndex:"");
}
return name;
},_createInput:function(){
if(this._inputs.length){
_71d.set(this.inputNode,{top:"500px"});
this._disconnectButton();
this._nameIndex++;
}
var name=this._getFileFieldName();
this.focusNode=this.inputNode=_720.create("input",{type:"file",name:name},this.domNode,"first");
if(this.supports("multiple")&&this.multiple){
_71f.set(this.inputNode,"multiple",true);
}
this._inputs.push(this.inputNode);
_71d.set(this.inputNode,{position:"absolute",fontSize:this.inputNodeFontSize+"em",top:"-3px",right:"-3px",opacity:0});
this._connectButton();
},_connectButton:function(){
this._cons.push(_71c.connect(this.inputNode,"change",this,function(evt){
this._files=this.inputNode.files;
this.onChange(this.getFileList(evt));
if(!this.supports("multiple")&&this.multiple){
this._createInput();
}
}));
if(this.tabIndex>-1){
this.inputNode.tabIndex=this.tabIndex;
this._cons.push(_71c.connect(this.inputNode,"focus",this,function(){
this.titleNode.style.outline="1px dashed #ccc";
}));
this._cons.push(_71c.connect(this.inputNode,"blur",this,function(){
this.titleNode.style.outline="";
}));
}
},_disconnectButton:function(){
_71b.forEach(this._cons,_71c.disconnect);
this._cons.splice(0,this._cons.length);
}});
dojox.form.UploaderOrg=dojox.form.Uploader;
var _730=[dojox.form.UploaderOrg];
dojox.form.addUploaderPlugin=function(plug){
_730.push(plug);
_71a("dojox.form.Uploader",_730,{});
};
return dojox.form.Uploader;
});
},"orion/editor/undoStack":function(){
define("orion/editor/undoStack",[],function(){
function _731(_732,text,_733){
this.offset=_732;
this.text=text;
this.previousText=_733;
};
_731.prototype={undo:function(view,_734){
this._doUndoRedo(this.offset,this.previousText,this.text,view,_734);
},redo:function(view,_735){
this._doUndoRedo(this.offset,this.text,this.previousText,view,_735);
},_doUndoRedo:function(_736,text,_737,view,_738){
var _739=view.getModel();
if(_739.mapOffset&&view.annotationModel){
var _73a=_739.mapOffset(_736,true);
if(_73a<0){
var _73b=view.annotationModel;
var iter=_73b.getAnnotations(_736,_736+1);
while(iter.hasNext()){
var _73c=iter.next();
if(_73c.type==="orion.annotation.folding"){
_73c.expand();
_73a=_739.mapOffset(_736,true);
break;
}
}
}
if(_73a<0){
return;
}
_736=_73a;
}
view.setText(text,_736,_736+_737.length);
if(_738){
view.setSelection(_736,_736+text.length);
}
}};
function _73d(){
this.changes=[];
};
_73d.prototype={add:function(_73e){
this.changes.push(_73e);
},end:function(view){
this.endSelection=view.getSelection();
this.endCaret=view.getCaretOffset();
},undo:function(view,_73f){
for(var i=this.changes.length-1;i>=0;i--){
this.changes[i].undo(view,false);
}
if(_73f){
var _740=this.startSelection.start;
var end=this.startSelection.end;
view.setSelection(this.startCaret?_740:end,this.startCaret?end:_740);
}
},redo:function(view,_741){
for(var i=0;i<this.changes.length;i++){
this.changes[i].redo(view,false);
}
if(_741){
var _742=this.endSelection.start;
var end=this.endSelection.end;
view.setSelection(this.endCaret?_742:end,this.endCaret?end:_742);
}
},start:function(view){
this.startSelection=view.getSelection();
this.startCaret=view.getCaretOffset();
}};
function _743(view,size){
this.view=view;
this.size=size!==undefined?size:100;
this.reset();
var _744=view.getModel();
if(_744.getBaseModel){
_744=_744.getBaseModel();
}
this.model=_744;
var self=this;
this._listener={onChanging:function(e){
self._onChanging(e);
},onDestroy:function(e){
self._onDestroy(e);
}};
_744.addEventListener("Changing",this._listener.onChanging);
view.addEventListener("Destroy",this._listener.onDestroy);
};
_743.prototype={add:function(_745){
if(this.compoundChange){
this.compoundChange.add(_745);
}else{
var _746=this.stack.length;
this.stack.splice(this.index,_746-this.index,_745);
this.index++;
if(this.stack.length>this.size){
this.stack.shift();
this.index--;
this.cleanIndex--;
}
}
},markClean:function(){
this.endCompoundChange();
this._commitUndo();
this.cleanIndex=this.index;
},isClean:function(){
return this.cleanIndex===this.getSize().undo;
},canUndo:function(){
return this.getSize().undo>0;
},canRedo:function(){
return this.getSize().redo>0;
},endCompoundChange:function(){
if(this.compoundChange){
this.compoundChange.end(this.view);
}
this.compoundChange=undefined;
},getSize:function(){
var _747=this.index;
var _748=this.stack.length;
if(this._undoStart!==undefined){
_747++;
}
return {undo:_747,redo:(_748-_747)};
},undo:function(){
this._commitUndo();
if(this.index<=0){
return false;
}
var _749=this.stack[--this.index];
this._ignoreUndo=true;
_749.undo(this.view,true);
this._ignoreUndo=false;
return true;
},redo:function(){
this._commitUndo();
if(this.index>=this.stack.length){
return false;
}
var _74a=this.stack[this.index++];
this._ignoreUndo=true;
_74a.redo(this.view,true);
this._ignoreUndo=false;
return true;
},reset:function(){
this.index=this.cleanIndex=0;
this.stack=[];
this._undoStart=undefined;
this._undoText="";
this._undoType=0;
this._ignoreUndo=false;
this._compoundChange=undefined;
},startCompoundChange:function(){
this._commitUndo();
var _74b=new _73d();
this.add(_74b);
this.compoundChange=_74b;
this.compoundChange.start(this.view);
},_commitUndo:function(){
if(this._undoStart!==undefined){
if(this._undoType===-1){
this.add(new _731(this._undoStart,"",this._undoText));
}else{
this.add(new _731(this._undoStart,this._undoText,""));
}
this._undoStart=undefined;
this._undoText="";
this._undoType=0;
}
},_onDestroy:function(evt){
this.model.removeEventListener("Changing",this._listener.onChanging);
this.view.removeEventListener("Destroy",this._listener.onDestroy);
},_onChanging:function(e){
var _74c=e.text;
var _74d=e.start;
var _74e=e.removedCharCount;
var _74f=e.addedCharCount;
if(this._ignoreUndo){
return;
}
if(this._undoStart!==undefined&&!((_74f===1&&_74e===0&&this._undoType===1&&_74d===this._undoStart+this._undoText.length)||(_74f===0&&_74e===1&&this._undoType===-1&&(((_74d+1)===this._undoStart)||(_74d===this._undoStart))))){
this._commitUndo();
}
if(!this.compoundChange){
if(_74f===1&&_74e===0){
if(this._undoStart===undefined){
this._undoStart=_74d;
}
this._undoText=this._undoText+_74c;
this._undoType=1;
return;
}else{
if(_74f===0&&_74e===1){
var _750=this._undoText.length>0&&this._undoStart===_74d;
this._undoStart=_74d;
this._undoType=-1;
if(_750){
this._undoText=this._undoText+this.model.getText(_74d,_74d+_74e);
}else{
this._undoText=this.model.getText(_74d,_74d+_74e)+this._undoText;
}
return;
}
}
}
this.add(new _731(_74d,_74c,this.model.getText(_74d,_74d+_74e)));
}};
return {UndoStack:_743};
});
},"dojox/html/metrics":function(){
define("dojox/html/metrics",["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_751,lang,has,_752,_753,_754,_755){
var dhm=lang.getObject("dojox.html.metrics",true);
var _756=lang.getObject("dojox");
dhm.getFontMeasurements=function(){
var _757={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};
if(has("ie")){
_754.doc.documentElement.style.fontSize="100%";
}
var div=_754.doc.createElement("div");
var ds=div.style;
ds.position="absolute";
ds.left="-100px";
ds.top="0";
ds.width="30px";
ds.height="1000em";
ds.borderWidth="0";
ds.margin="0";
ds.padding="0";
ds.outline="0";
ds.lineHeight="1";
ds.overflow="hidden";
_754.body().appendChild(div);
for(var p in _757){
ds.fontSize=p;
_757[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;
}
_754.body().removeChild(div);
div=null;
return _757;
};
var _758=null;
dhm.getCachedFontMeasurements=function(_759){
if(_759||!_758){
_758=dhm.getFontMeasurements();
}
return _758;
};
var _75a=null,_75b={};
dhm.getTextBox=function(text,_75c,_75d){
var m,s;
if(!_75a){
m=_75a=_754.doc.createElement("div");
var c=_754.doc.createElement("div");
c.appendChild(m);
s=c.style;
s.overflow="scroll";
s.position="absolute";
s.left="0px";
s.top="-10000px";
s.width="1px";
s.height="1px";
s.visibility="hidden";
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
_754.body().appendChild(c);
}else{
m=_75a;
}
m.className="";
s=m.style;
s.borderWidth="0";
s.margin="0";
s.padding="0";
s.outline="0";
if(arguments.length>1&&_75c){
for(var i in _75c){
if(i in _75b){
continue;
}
s[i]=_75c[i];
}
}
if(arguments.length>2&&_75d){
m.className=_75d;
}
m.innerHTML=text;
var box=_755.position(m);
box.w=m.parentNode.scrollWidth;
return box;
};
var _75e={w:16,h:16};
dhm.getScrollbar=function(){
return {w:_75e.w,h:_75e.h};
};
dhm._fontResizeNode=null;
dhm.initOnFontResize=function(_75f){
var f=dhm._fontResizeNode=_754.doc.createElement("iframe");
var fs=f.style;
fs.position="absolute";
fs.width="5em";
fs.height="10em";
fs.top="-10000px";
fs.display="none";
if(has("ie")){
f.onreadystatechange=function(){
if(f.contentWindow.document.readyState=="complete"){
f.onresize=f.contentWindow.parent[_756._scopeName].html.metrics._fontresize;
}
};
}else{
f.onload=function(){
f.contentWindow.onresize=f.contentWindow.parent[_756._scopeName].html.metrics._fontresize;
};
}
f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");
_754.body().appendChild(f);
dhm.initOnFontResize=function(){
};
};
dhm.onFontResize=function(){
};
dhm._fontresize=function(){
dhm.onFontResize();
};
_753.addOnUnload(function(){
var f=dhm._fontResizeNode;
if(f){
if(has("ie")&&f.onresize){
f.onresize=null;
}else{
if(f.contentWindow&&f.contentWindow.onresize){
f.contentWindow.onresize=null;
}
}
dhm._fontResizeNode=null;
}
});
_752(function(){
try{
var n=_754.doc.createElement("div");
n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";
_754.body().appendChild(n);
_75e.w=n.offsetWidth-n.clientWidth;
_75e.h=n.offsetHeight-n.clientHeight;
_754.body().removeChild(n);
delete n;
}
catch(e){
}
if("fontSizeWatch" in _751.config&&!!_751.config.fontSizeWatch){
dhm.initOnFontResize();
}
});
return dhm;
});
},"url:davinci/ve/actions/templates/AddState.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div class='addStateNameDiv'>\n\t\t\t<label>${veNls.stateLabel}:</label><input dojoAttachPoint=\"input\" dojoType=\"dijit.form.TextBox\" dojoAttachEvent=\"onKeyUp:_onKeyPress\" type=\"text\"></input>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"okButton\" dojoAttachEvent='onClick:onOk' label='${veNls.createLabel}' class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:onCancel' label='${commonNls.buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n","orion/editor/textModel":function(){
define("orion/editor/textModel",["orion/editor/eventTarget","orion/editor/util"],function(_760,util){
function _761(text,_762){
this._lastLineIndex=-1;
this._text=[""];
this._lineOffsets=[0];
this.setText(text);
this.setLineDelimiter(_762);
};
_761.prototype={find:function(_763){
if(this._text.length>1){
this._text=[this._text.join("")];
}
var _764=_763.string;
var _765=_763.regex;
var _766=_764;
if(!_765&&_764){
_766=_764.replace(/([\\$\^*\/+?\.\(\)|{}\[\]])/g,"\\$&");
}
var _767=null,skip;
if(_766){
var _768=_763.reverse;
var wrap=_763.wrap;
var _769=_763.wholeWord;
var _76a=_763.caseInsensitive;
var _76b=_763.start||0;
var end=_763.end;
var _76c=_763.end!==undefined;
var _76d="";
if(_76d.indexOf("g")===-1){
_76d+="g";
}
if(_76a){
if(_76d.indexOf("i")===-1){
_76d+="i";
}
}
if(_769){
_766="\\b"+_766+"\\b";
}
var text=this._text[0],_76e,_76f,_770=0;
if(_76c){
text=text.substring(_76b,end);
_770=_76b;
}
var re=new RegExp(_766,_76d);
if(_768){
skip=function(){
var _771=null;
re.lastIndex=0;
while(true){
_76f=re.lastIndex;
_76e=re.exec(text);
if(_76f===re.lastIndex){
return null;
}
if(_76e){
if(_76e.index<_76b){
_771={start:_76e.index+_770,end:re.lastIndex+_770};
}else{
if(!wrap||_771){
break;
}
_76b=text.length;
_771={start:_76e.index+_770,end:re.lastIndex+_770};
}
}else{
break;
}
}
if(_771){
_76b=_771.start;
}
return _771;
};
}else{
if(!_76c){
re.lastIndex=_76b;
}
skip=function(){
while(true){
_76f=re.lastIndex;
_76e=re.exec(text);
if(_76f===re.lastIndex){
return null;
}
if(_76e){
return {start:_76e.index+_770,end:re.lastIndex+_770};
}
if(_76f!==0){
if(wrap){
continue;
}
}
break;
}
return null;
};
}
_767=skip();
}
return {next:function(){
var _772=_767;
if(_772){
_767=skip();
}
return _772;
},hasNext:function(){
return _767!==null;
}};
},getCharCount:function(){
var _773=0;
for(var i=0;i<this._text.length;i++){
_773+=this._text[i].length;
}
return _773;
},getLine:function(_774,_775){
var _776=this.getLineCount();
if(!(0<=_774&&_774<_776)){
return null;
}
var _777=this._lineOffsets[_774];
if(_774+1<_776){
var text=this.getText(_777,this._lineOffsets[_774+1]);
if(_775){
return text;
}
var end=text.length,c;
while(((c=text.charCodeAt(end-1))===10)||(c===13)){
end--;
}
return text.substring(0,end);
}else{
return this.getText(_777);
}
},getLineAtOffset:function(_778){
var _779=this.getCharCount();
if(!(0<=_778&&_778<=_779)){
return -1;
}
var _77a=this.getLineCount();
if(_778===_779){
return _77a-1;
}
var _77b,_77c;
var _77d=this._lastLineIndex;
if(0<=_77d&&_77d<_77a){
_77b=this._lineOffsets[_77d];
_77c=_77d+1<_77a?this._lineOffsets[_77d+1]:_779;
if(_77b<=_778&&_778<_77c){
return _77d;
}
}
var high=_77a;
var low=-1;
while(high-low>1){
_77d=Math.floor((high+low)/2);
_77b=this._lineOffsets[_77d];
_77c=_77d+1<_77a?this._lineOffsets[_77d+1]:_779;
if(_778<=_77b){
high=_77d;
}else{
if(_778<_77c){
high=_77d;
break;
}else{
low=_77d;
}
}
}
this._lastLineIndex=high;
return high;
},getLineCount:function(){
return this._lineOffsets.length;
},getLineDelimiter:function(){
return this._lineDelimiter;
},getLineEnd:function(_77e,_77f){
var _780=this.getLineCount();
if(!(0<=_77e&&_77e<_780)){
return -1;
}
if(_77e+1<_780){
var end=this._lineOffsets[_77e+1];
if(_77f){
return end;
}
var text=this.getText(Math.max(this._lineOffsets[_77e],end-2),end);
var i=text.length,c;
while(((c=text.charCodeAt(i-1))===10)||(c===13)){
i--;
}
return end-(text.length-i);
}else{
return this.getCharCount();
}
},getLineStart:function(_781){
if(!(0<=_781&&_781<this.getLineCount())){
return -1;
}
return this._lineOffsets[_781];
},getText:function(_782,end){
if(_782===undefined){
_782=0;
}
if(end===undefined){
end=this.getCharCount();
}
if(_782===end){
return "";
}
var _783=0,_784=0,_785;
while(_784<this._text.length){
_785=this._text[_784].length;
if(_782<=_783+_785){
break;
}
_783+=_785;
_784++;
}
var _786=_783;
var _787=_784;
while(_784<this._text.length){
_785=this._text[_784].length;
if(end<=_783+_785){
break;
}
_783+=_785;
_784++;
}
var _788=_783;
var _789=_784;
if(_787===_789){
return this._text[_787].substring(_782-_786,end-_788);
}
var _78a=this._text[_787].substring(_782-_786);
var _78b=this._text[_789].substring(0,end-_788);
return _78a+this._text.slice(_787+1,_789).join("")+_78b;
},onChanging:function(_78c){
return this.dispatchEvent(_78c);
},onChanged:function(_78d){
return this.dispatchEvent(_78d);
},setLineDelimiter:function(_78e,all){
if(_78e==="auto"){
_78e=undefined;
if(this.getLineCount()>1){
_78e=this.getText(this.getLineEnd(0),this.getLineEnd(0,true));
}
}
this._lineDelimiter=_78e?_78e:util.platformDelimiter;
if(all){
var _78f=this.getLineCount();
if(_78f>1){
var _790=new Array(_78f);
for(var i=0;i<_78f;i++){
_790[i]=this.getLine(i);
}
this.setText(_790.join(this._lineDelimiter));
}
}
},setText:function(text,_791,end){
if(text===undefined){
text="";
}
if(_791===undefined){
_791=0;
}
if(end===undefined){
end=this.getCharCount();
}
if(_791===end&&text===""){
return;
}
var _792=this.getLineAtOffset(_791);
var _793=this.getLineAtOffset(end);
var _794=_791;
var _795=end-_791;
var _796=_793-_792;
var _797=text.length;
var _798=0;
var _799=this.getLineCount();
var cr=0,lf=0,_79a=0;
var _79b=[];
while(true){
if(cr!==-1&&cr<=_79a){
cr=text.indexOf("\r",_79a);
}
if(lf!==-1&&lf<=_79a){
lf=text.indexOf("\n",_79a);
}
if(lf===-1&&cr===-1){
break;
}
if(cr!==-1&&lf!==-1){
if(cr+1===lf){
_79a=lf+1;
}else{
_79a=(cr<lf?cr:lf)+1;
}
}else{
if(cr!==-1){
_79a=cr+1;
}else{
_79a=lf+1;
}
}
_79b.push(_791+_79a);
_798++;
}
var _79c={type:"Changing",text:text,start:_794,removedCharCount:_795,addedCharCount:_797,removedLineCount:_796,addedLineCount:_798};
this.onChanging(_79c);
if(_79b.length===0){
var _79d=this.getLineStart(_792),_79e;
if(_793+1<_799){
_79e=this.getLineStart(_793+1);
}else{
_79e=this.getCharCount();
}
if(_791!==_79d){
text=this.getText(_79d,_791)+text;
_791=_79d;
}
if(end!==_79e){
text=text+this.getText(end,_79e);
end=_79e;
}
}
var _79f=_797-_795;
for(var j=_792+_796+1;j<_799;j++){
this._lineOffsets[j]+=_79f;
}
var args=[_792+1,_796].concat(_79b);
Array.prototype.splice.apply(this._lineOffsets,args);
var _7a0=0,_7a1=0,_7a2;
while(_7a1<this._text.length){
_7a2=this._text[_7a1].length;
if(_791<=_7a0+_7a2){
break;
}
_7a0+=_7a2;
_7a1++;
}
var _7a3=_7a0;
var _7a4=_7a1;
while(_7a1<this._text.length){
_7a2=this._text[_7a1].length;
if(end<=_7a0+_7a2){
break;
}
_7a0+=_7a2;
_7a1++;
}
var _7a5=_7a0;
var _7a6=_7a1;
var _7a7=this._text[_7a4];
var _7a8=this._text[_7a6];
var _7a9=_7a7.substring(0,_791-_7a3);
var _7aa=_7a8.substring(end-_7a5);
var _7ab=[_7a4,_7a6-_7a4+1];
if(_7a9){
_7ab.push(_7a9);
}
if(text){
_7ab.push(text);
}
if(_7aa){
_7ab.push(_7aa);
}
Array.prototype.splice.apply(this._text,_7ab);
if(this._text.length===0){
this._text=[""];
}
var _7ac={type:"Changed",start:_794,removedCharCount:_795,addedCharCount:_797,removedLineCount:_796,addedLineCount:_798};
this.onChanged(_7ac);
}};
_760.EventTarget.addMixin(_761.prototype);
return {TextModel:_761};
});
},"davinci/workbench/WidgetLite":function(){
define("davinci/workbench/WidgetLite",["dojo/_base/declare","dijit/_WidgetBase","dojo/parser"],function(_7ad,_7ae,_7af){
return _7ad("davinci.workbench.WidgetLite",[_7ae],{buildRendering:function(){
this.inherited(arguments);
if(/dojotype/i.test(this.domNode.innerHTML||"")){
this._startupWidgets=dojo.parser.parse(this.domNode,{noStart:!this._earlyTemplatedStartup,inherited:{dir:this.dir,lang:this.lang}});
}
},_destroyContent:function(){
var _7b0=(this.containerNode||this.domNode);
dojo.forEach(dojo.query("[widgetId]",_7b0).map(dijit.byNode),function(w){
w.destroy();
});
while(_7b0.firstChild){
dojo._destroyElement(_7b0.firstChild);
}
dojo.forEach(this._tooltips,function(t){
t.destroy();
});
delete this._tooltips;
},startup:function(){
dojo.forEach(this._startupWidgets,function(w){
if(w&&!w._started&&w.startup){
w.startup();
}
});
this.inherited(arguments);
}});
});
},"davinci/ve/widgets/MutableStore":function(){
define("davinci/ve/widgets/MutableStore",["dojo/_base/declare","dojo/data/ItemFileReadStore","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common"],function(_7b1,_7b2,_7b3,_7b4){
return _7b1("davinci.ve.widgets.MutableStore",_7b2,{constructor:function(args){
this.clearValues();
if(args.divider){
this.divider=args.divider;
}
if(args.values){
this.setValues(args.values);
}
},setValues:function(_7b5){
var _7b6=[];
var _7b7=0;
if(_7b5){
this._values=_7b5;
}
dojo.forEach(this._values,dojo.hitch(this,function(v){
_7b6.push({name:v,value:v,id:_7b7++});
}));
this._jsonData={identifier:"id",items:_7b6};
this._loadFinished=false;
},modifyItem:function(_7b8,_7b9){
for(var i=0;i<this._values.length;i++){
if(this._values[i]==_7b8){
this._values[i]=_7b9;
}
}
this.setValues();
},insert:function(_7ba,_7bb){
this._values.splice(_7ba,0,_7bb);
this.setValues();
},contains:function(item){
for(var i=0;i<this._values.length;i++){
if(this._values[i]==item){
return true;
}
}
return false;
},findSimilar:function(_7bc){
var _7bd=new RegExp(/(\D*)(-?)(\d+)(\D*)/);
var _7be=_7bd.exec(_7bc);
if(!_7be){
return;
}
var _7bf=new RegExp((_7be.length>0?_7be[1]:"")+"(-?)(\\d+)"+(_7be.length>3?_7be[4]:""));
for(var i=0;i<this._values.length;i++){
if(_7bf.test(this._values[i])){
return this._values[i];
}
}
},getItemNumber:function(_7c0){
return this._values[_7c0];
},clearValues:function(){
this._loadFinished=false;
}});
});
},"davinci/de/resource":function(){
define("davinci/de/resource",["davinci/de/widgets/NewDijit","davinci/Workbench","davinci/workbench/Preferences","system/resource","davinci/de/DijitTemplatedGenerator","davinci/library","davinci/ui/Dialog","davinci/ve/actions/ReplaceAction","dojo/promise/all"],function(_7c1,_7c2,_7c3,_7c4,_7c5,_7c6,_7c7,_7c8,all){
var dt={WIDGETS_JSON:{version:"1.0",localPath:true,customWidgetSpec:1,"categories":{"custom":{name:"Custom widget",description:"Custom widget",widgetClass:"dijit"}},widgets:[]},createDijiFromNewDialog:function(){
var _7c9=new _7c1({});
var _7ca=_7c2.getOpenEditor();
var _7cb=_7ca.fileName;
var _7cc=_7c4.findResource(_7cb);
var _7cd=_7ca.model;
var _7ce=_7c2.getOpenEditor();
var _7cf=_7ce.getContext();
var _7d0=_7cf.getSelection();
if(!dt.validWidget(_7d0)){
_7c7.showModal("Invalid Selection.  Please select a single container widget to create a new Widget","Error creating Widget...");
return;
}
_7c2.showModal(_7c9,"Dijit Widget...",{height:60,width:250},function(){
if(!_7c9.cancel){
var _7d1=_7c9.attr("value");
dt.createDijit(_7d1,_7cd,_7cc,_7cf,_7d0).then(function(){
if(_7d1.replaceSelection){
new _7c8().run(_7cf,_7d1.group+"."+_7d1.name);
}
window.location.reload(false);
});
}
return true;
});
},validWidget:function(_7d2){
if(_7d2==null||_7d2.length!=1){
return false;
}
var _7d3=_7d2[0];
return (_7d3.acceptsHTMLChildren);
},_createNameSpace:function(name,_7d4){
var _7d5=name.split(".");
var base=_7c2.getProject();
_7d4=_7d4||_7c4.findResource(base);
if(_7d5.length>1){
for(var i=0;i<_7d5.length-1;i++){
var _7d6=_7d4.getChildSync(_7d5[i]);
if(_7d6!=null){
_7d4=_7d6;
}else{
_7d4=_7d4.createResource(_7d5[i],true);
}
}
}
return _7d4;
},_createFolder:function(name,_7d7){
var _7d8=name.split("/");
var base=_7c2.getProject();
_7d7=_7d7||_7c4.findResource(base);
if(_7d8.length){
for(var i=0;i<_7d8.length;i++){
if(_7d8[i]=="."){
continue;
}
var _7d9=_7d7.getChildSync(_7d8[i]);
if(_7d9!=null){
_7d7=_7d9;
}else{
_7d7=_7d7.createResource(_7d8[i],true);
}
}
}
return _7d7;
},createDijit:function(_7da,_7db,_7dc,_7dd,_7de){
var _7df=_7da.name+"."+_7da.name;
var _7e0=_7da.name+"/"+_7da.name;
var base=_7c2.getProject();
var _7e1=_7c3.getPreferences("davinci.ui.ProjectPrefs",base);
if(!_7e1.widgetFolder){
_7e1.widgetFolder="WebContent/custom";
_7c3.savePreferences("davinci.ui.ProjectPrefs",base,_7e1);
}
var _7e2=dt._createFolder(_7e1.widgetFolder);
var _7e3=dt._createNameSpace(_7df,_7e2);
var _7e4=_7e3.getChildSync(_7da.name+"_widgets.json");
if(_7e4==null){
_7e4=_7e3.createResource(_7da.name+"_widgets.json");
}
var _7e5=dojo.clone(dt.WIDGETS_JSON);
_7e5.name=_7da.name;
_7e5.longName=_7da.name;
var _7e6={name:_7da.name,description:_7da.name,type:_7e0,category:"custom",iconLocal:true,icon:"app/davinci/img/maqetta.png"};
var _7e7=_7de[0]._srcElement;
for(var i=0,atts=_7e7.attributes,len=atts.length;i<len;i++){
var att=atts[i];
if(!att.noPersist){
if(!_7e6.properties){
_7e6.properties={};
}
_7e6.properties[att.name]=att.value;
}
}
_7e5.widgets.push(_7e6);
var _7e8=[_7e4.setContents(JSON.stringify(_7e5,undefined,"\t"))];
var _7e9=new _7c5({}).buildSource(_7db,_7e0,_7da.name,false,_7dd,_7de);
for(var type in _7e9){
switch(type){
case "amd":
break;
case "html":
var html=_7e3.createResource(_7da.name+".html");
_7e8.push(html.setContents(_7e9.html));
break;
case "js":
var _7ea=_7e3.createResource(_7da.name+".js");
_7e8.push(_7ea.setContents(_7e9.js));
break;
case "metadata":
var _7eb=_7e3.createResource(_7da.name+"_oam.json");
_7e8.push(_7eb.setContents(_7e9.metadata));
_7c6.addCustomWidgets(base,_7e4,_7e3.getPath(),_7e5);
break;
}
}
return all(_7e8);
}};
return dt;
});
},"dojo/date/locale":function(){
define("dojo/date/locale",["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_7ec,date,_7ed,i18n,_7ee,_7ef,_7f0,_7f1){
var _7f2={};
lang.setObject(_7f1.id.replace(/\//g,"."),_7f2);
function _7f3(_7f4,_7f5,_7f6,_7f7){
return _7f7.replace(/([a-z])\1*/ig,function(_7f8){
var s,pad,c=_7f8.charAt(0),l=_7f8.length,_7f9=["abbr","wide","narrow"];
switch(c){
case "G":
s=_7f5[(l<4)?"eraAbbr":"eraNames"][_7f4.getFullYear()<0?0:1];
break;
case "y":
s=_7f4.getFullYear();
switch(l){
case 1:
break;
case 2:
if(!_7f6.fullYear){
s=String(s);
s=s.substr(s.length-2);
break;
}
default:
pad=true;
}
break;
case "Q":
case "q":
s=Math.ceil((_7f4.getMonth()+1)/3);
pad=true;
break;
case "M":
case "L":
var m=_7f4.getMonth();
if(l<3){
s=m+1;
pad=true;
}else{
var _7fa=["months",c=="L"?"standAlone":"format",_7f9[l-3]].join("-");
s=_7f5[_7fa][m];
}
break;
case "w":
var _7fb=0;
s=_7f2._getWeekOfYear(_7f4,_7fb);
pad=true;
break;
case "d":
s=_7f4.getDate();
pad=true;
break;
case "D":
s=_7f2._getDayOfYear(_7f4);
pad=true;
break;
case "e":
case "c":
var d=_7f4.getDay();
if(l<2){
s=(d-_7ed.getFirstDayOfWeek(_7f6.locale)+8)%7;
break;
}
case "E":
d=_7f4.getDay();
if(l<3){
s=d+1;
pad=true;
}else{
var _7fc=["days",c=="c"?"standAlone":"format",_7f9[l-3]].join("-");
s=_7f5[_7fc][d];
}
break;
case "a":
var _7fd=_7f4.getHours()<12?"am":"pm";
s=_7f6[_7fd]||_7f5["dayPeriods-format-wide-"+_7fd];
break;
case "h":
case "H":
case "K":
case "k":
var h=_7f4.getHours();
switch(c){
case "h":
s=(h%12)||12;
break;
case "H":
s=h;
break;
case "K":
s=(h%12);
break;
case "k":
s=h||24;
break;
}
pad=true;
break;
case "m":
s=_7f4.getMinutes();
pad=true;
break;
case "s":
s=_7f4.getSeconds();
pad=true;
break;
case "S":
s=Math.round(_7f4.getMilliseconds()*Math.pow(10,l-3));
pad=true;
break;
case "v":
case "z":
s=_7f2._getZone(_7f4,true,_7f6);
if(s){
break;
}
l=4;
case "Z":
var _7fe=_7f2._getZone(_7f4,false,_7f6);
var tz=[(_7fe<=0?"+":"-"),_7ef.pad(Math.floor(Math.abs(_7fe)/60),2),_7ef.pad(Math.abs(_7fe)%60,2)];
if(l==4){
tz.splice(0,0,"GMT");
tz.splice(3,0,":");
}
s=tz.join("");
break;
default:
throw new Error("dojo.date.locale.format: invalid pattern char: "+_7f7);
}
if(pad){
s=_7ef.pad(s,l);
}
return s;
});
};
_7f2._getZone=function(_7ff,_800,_801){
if(_800){
return date.getTimezoneName(_7ff);
}else{
return _7ff.getTimezoneOffset();
}
};
_7f2.format=function(_802,_803){
_803=_803||{};
var _804=i18n.normalizeLocale(_803.locale),_805=_803.formatLength||"short",_806=_7f2._getGregorianBundle(_804),str=[],_807=lang.hitch(this,_7f3,_802,_806,_803);
if(_803.selector=="year"){
return _808(_806["dateFormatItem-yyyy"]||"yyyy",_807);
}
var _809;
if(_803.selector!="date"){
_809=_803.timePattern||_806["timeFormat-"+_805];
if(_809){
str.push(_808(_809,_807));
}
}
if(_803.selector!="time"){
_809=_803.datePattern||_806["dateFormat-"+_805];
if(_809){
str.push(_808(_809,_807));
}
}
return str.length==1?str[0]:_806["dateTimeFormat-"+_805].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_80a,key){
return str[key];
});
};
_7f2.regexp=function(_80b){
return _7f2._parseInfo(_80b).regexp;
};
_7f2._parseInfo=function(_80c){
_80c=_80c||{};
var _80d=i18n.normalizeLocale(_80c.locale),_80e=_7f2._getGregorianBundle(_80d),_80f=_80c.formatLength||"short",_810=_80c.datePattern||_80e["dateFormat-"+_80f],_811=_80c.timePattern||_80e["timeFormat-"+_80f],_812;
if(_80c.selector=="date"){
_812=_810;
}else{
if(_80c.selector=="time"){
_812=_811;
}else{
_812=_80e["dateTimeFormat-"+_80f].replace(/\{(\d+)\}/g,function(_813,key){
return [_811,_810][key];
});
}
}
var _814=[],re=_808(_812,lang.hitch(this,_815,_814,_80e,_80c));
return {regexp:re,tokens:_814,bundle:_80e};
};
_7f2.parse=function(_816,_817){
var _818=/[\u200E\u200F\u202A\u202E]/g,info=_7f2._parseInfo(_817),_819=info.tokens,_81a=info.bundle,re=new RegExp("^"+info.regexp.replace(_818,"")+"$",info.strict?"":"i"),_81b=re.exec(_816&&_816.replace(_818,""));
if(!_81b){
return null;
}
var _81c=["abbr","wide","narrow"],_81d=[1970,0,1,0,0,0,0],amPm="",_81e=_7ec.every(_81b,function(v,i){
if(!i){
return true;
}
var _81f=_819[i-1],l=_81f.length,c=_81f.charAt(0);
switch(c){
case "y":
if(l!=2&&_817.strict){
_81d[0]=v;
}else{
if(v<100){
v=Number(v);
var year=""+new Date().getFullYear(),_820=year.substring(0,2)*100,_821=Math.min(Number(year.substring(2,4))+20,99);
_81d[0]=(v<_821)?_820+v:_820-100+v;
}else{
if(_817.strict){
return false;
}
_81d[0]=v;
}
}
break;
case "M":
case "L":
if(l>2){
var _822=_81a["months-"+(c=="L"?"standAlone":"format")+"-"+_81c[l-3]].concat();
if(!_817.strict){
v=v.replace(".","").toLowerCase();
_822=_7ec.map(_822,function(s){
return s.replace(".","").toLowerCase();
});
}
v=_7ec.indexOf(_822,v);
if(v==-1){
return false;
}
}else{
v--;
}
_81d[1]=v;
break;
case "E":
case "e":
case "c":
var days=_81a["days-"+(c=="c"?"standAlone":"format")+"-"+_81c[l-3]].concat();
if(!_817.strict){
v=v.toLowerCase();
days=_7ec.map(days,function(d){
return d.toLowerCase();
});
}
v=_7ec.indexOf(days,v);
if(v==-1){
return false;
}
break;
case "D":
_81d[1]=0;
case "d":
_81d[2]=v;
break;
case "a":
var am=_817.am||_81a["dayPeriods-format-wide-am"],pm=_817.pm||_81a["dayPeriods-format-wide-pm"];
if(!_817.strict){
var _823=/\./g;
v=v.replace(_823,"").toLowerCase();
am=am.replace(_823,"").toLowerCase();
pm=pm.replace(_823,"").toLowerCase();
}
if(_817.strict&&v!=am&&v!=pm){
return false;
}
amPm=(v==pm)?"p":(v==am)?"a":"";
break;
case "K":
if(v==24){
v=0;
}
case "h":
case "H":
case "k":
if(v>23){
return false;
}
_81d[3]=v;
break;
case "m":
_81d[4]=v;
break;
case "s":
_81d[5]=v;
break;
case "S":
_81d[6]=v;
}
return true;
});
var _824=+_81d[3];
if(amPm==="p"&&_824<12){
_81d[3]=_824+12;
}else{
if(amPm==="a"&&_824==12){
_81d[3]=0;
}
}
var _825=new Date(_81d[0],_81d[1],_81d[2],_81d[3],_81d[4],_81d[5],_81d[6]);
if(_817.strict){
_825.setFullYear(_81d[0]);
}
var _826=_819.join(""),_827=_826.indexOf("d")!=-1,_828=_826.indexOf("M")!=-1;
if(!_81e||(_828&&_825.getMonth()>_81d[1])||(_827&&_825.getDate()>_81d[2])){
return null;
}
if((_828&&_825.getMonth()<_81d[1])||(_827&&_825.getDate()<_81d[2])){
_825=date.add(_825,"hour",1);
}
return _825;
};
function _808(_829,_82a,_82b,_82c){
var _82d=function(x){
return x;
};
_82a=_82a||_82d;
_82b=_82b||_82d;
_82c=_82c||_82d;
var _82e=_829.match(/(''|[^'])+/g),_82f=_829.charAt(0)=="'";
_7ec.forEach(_82e,function(_830,i){
if(!_830){
_82e[i]="";
}else{
_82e[i]=(_82f?_82b:_82a)(_830.replace(/''/g,"'"));
_82f=!_82f;
}
});
return _82c(_82e.join(""));
};
function _815(_831,_832,_833,_834){
_834=_7ee.escapeString(_834);
if(!_833.strict){
_834=_834.replace(" a"," ?a");
}
return _834.replace(/([a-z])\1*/ig,function(_835){
var s,c=_835.charAt(0),l=_835.length,p2="",p3="";
if(_833.strict){
if(l>1){
p2="0"+"{"+(l-1)+"}";
}
if(l>2){
p3="0"+"{"+(l-2)+"}";
}
}else{
p2="0?";
p3="0{0,2}";
}
switch(c){
case "y":
s="\\d{2,4}";
break;
case "M":
case "L":
s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";
break;
case "D":
s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";
break;
case "d":
s="3[01]|[12]\\d|"+p2+"[1-9]";
break;
case "w":
s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";
break;
case "E":
case "e":
case "c":
s="\\S+";
break;
case "h":
s="1[0-2]|"+p2+"[1-9]";
break;
case "k":
s="1[01]|"+p2+"\\d";
break;
case "H":
s="1\\d|2[0-3]|"+p2+"\\d";
break;
case "K":
s="1\\d|2[0-4]|"+p2+"[1-9]";
break;
case "m":
case "s":
s="[0-5]\\d";
break;
case "S":
s="\\d{"+l+"}";
break;
case "a":
var am=_833.am||_832["dayPeriods-format-wide-am"],pm=_833.pm||_832["dayPeriods-format-wide-pm"];
s=am+"|"+pm;
if(!_833.strict){
if(am!=am.toLowerCase()){
s+="|"+am.toLowerCase();
}
if(pm!=pm.toLowerCase()){
s+="|"+pm.toLowerCase();
}
if(s.indexOf(".")!=-1){
s+="|"+s.replace(/\./g,"");
}
}
s=s.replace(/\./g,"\\.");
break;
default:
s=".*";
}
if(_831){
_831.push(_835);
}
return "("+s+")";
}).replace(/[\xa0 ]/g,"[\\s\\xa0]");
};
var _836=[];
_7f2.addCustomFormats=function(_837,_838){
_836.push({pkg:_837,name:_838});
};
_7f2._getGregorianBundle=function(_839){
var _83a={};
_7ec.forEach(_836,function(desc){
var _83b=i18n.getLocalization(desc.pkg,desc.name,_839);
_83a=lang.mixin(_83a,_83b);
},this);
return _83a;
};
_7f2.addCustomFormats(_7f1.id.replace(/\/date\/locale$/,".cldr"),"gregorian");
_7f2.getNames=function(item,type,_83c,_83d){
var _83e,_83f=_7f2._getGregorianBundle(_83d),_840=[item,_83c,type];
if(_83c=="standAlone"){
var key=_840.join("-");
_83e=_83f[key];
if(_83e[0]==1){
_83e=undefined;
}
}
_840[1]="format";
return (_83e||_83f[_840.join("-")]).concat();
};
_7f2.isWeekend=function(_841,_842){
var _843=_7ed.getWeekend(_842),day=(_841||new Date()).getDay();
if(_843.end<_843.start){
_843.end+=7;
if(day<_843.start){
day+=7;
}
}
return day>=_843.start&&day<=_843.end;
};
_7f2._getDayOfYear=function(_844){
return date.difference(new Date(_844.getFullYear(),0,1,_844.getHours()),_844)+1;
};
_7f2._getWeekOfYear=function(_845,_846){
if(arguments.length==1){
_846=0;
}
var _847=new Date(_845.getFullYear(),0,1).getDay(),adj=(_847-_846+7)%7,week=Math.floor((_7f2._getDayOfYear(_845)+adj-1)/7);
if(_847==_846){
week++;
}
return week;
};
return _7f2;
});
},"davinci/html/CSSEditorContext":function(){
define("davinci/html/CSSEditorContext",["dojo/_base/declare","davinci/html/CSSEditorWidget"],function(_848,_849){
return _848("davinci.html.CSSEditorContext",null,{constructor:function(_84a){
this.editor=_84a;
this.connects=[];
this.subscriptions=[];
this.subscriptions.push(dojo.subscribe("/davinci/ui/selectionChanged",this,this._selection));
},_selection:function(_84b){
if(_84b[0]&&_84b[0].model){
var _84c=_84b[0].model;
var _84d;
if(_84c._edit_context){
return;
}
if(_84c.elementType.substring(0,3)=="CSS"){
var rule=_84c.getCSSRule();
var fire=rule!=this.selectedRule;
if(rule){
this.selectedWidget=new _849(this);
}else{
this.selectedWidget=null;
}
this.selectedRule=rule;
if(fire){
this.onSelectionChange();
}
}
}
},getSelection:function(){
if(this.selectedWidget){
return [this.selectedWidget];
}
return [];
},onSelectionChange:function(){
}});
});
},"davinci/ve/commands/ChangeThemeCommand":function(){
define("davinci/ve/commands/ChangeThemeCommand",["dojo/_base/declare","dojo/_base/lang","dojo/query","davinci/Theme","davinci/Workbench","davinci/library","davinci/html/CSSImport","davinci/html/HTMLElement","davinci/html/HTMLText","preview/silhouetteiframe","davinci/model/Factory",],function(_84e,lang,_84f,_850,_851,_852,_853,_854,_855,_856,_857){
return _84e("davinci.ve.commands.ChangeThemeCommand",null,{name:"changeTheme",constructor:function(_858,_859){
this._newTheme=_858;
this._context=_859;
this._oldTheme=_850.getThemeSet(this._context);
if(!this._oldTheme){
this._oldTheme=_850.dojoThemeSets.themeSets[0];
}
},execute:function(){
this._changeTheme(this._newTheme,this._oldTheme);
},undo:function(){
this._changeTheme(this._oldTheme,this._newTheme);
},_changeTheme:function(_85a,_85b){
if(!_85b.desktopTheme){
this.removeTheme(_85b);
}else{
this.removeThemeSet(_85b);
}
if(!_85a.desktopTheme){
this.addTheme(_85a);
}else{
this.addThemeSet(_85a);
}
var _85c=this._context,_85d=_85c.editor,text=_85c.getModel().getText();
_85d.setContent(_85d.fileName,text);
_85c.widgetAddedOrDeleted(true);
_85c._configDojoxMobile();
var _85e=_85c.getMobileDevice()||"none";
if(_85e!="none"){
_85e=_856.themeMap[_85e+".svg"];
}
var dm=lang.getObject("dojox.mobile",true,_85c.getGlobal());
if(dm&&dm.loadDeviceTheme){
dm.loadDeviceTheme(_85e);
}
window.setTimeout(function(){
this._context.resizeAllWidgets();
}.bind(this),50);
},removeTheme:function(_85f){
var _860=_850.getHelper(_85f);
if(_860&&_860.removeTheme){
_860.removeTheme(this._context,_85f);
}else{
var _861=this._context.getModel().getDocumentElement(),_862=_861.getChildElement("head"),_863=_861.getChildElement("body"),_864=dojo.clone(this._context.getHeader());
function _865(_866,file){
return (_866.indexOf(file)>-1);
};
var _867=_85f.files;
if(_85f.conditionalFiles){
_867=_867.concat(_85f.conditionalFiles);
}
for(var x=0;x<_867.length;x++){
var _868=_867[x];
for(var y=0;y<_864.styleSheets.length;y++){
if(_865(_864.styleSheets[y],_868)){
var _869=_863.getAttribute("class");
if(_869){
_869=_869.replace(_85f.className,"");
_864.bodyClasses=_869;
_863.removeAttribute("class");
if(_869.length>0){
_863.addAttribute("class",_869,false);
}
}
this._context.setHeader(_864);
var _86a=_862.find({elementType:"CSSImport"});
for(var i=0;i<_86a.length;i++){
if(_865(_86a[i].url,_868)){
var url=_86a[i].url,doc=this._context.getDocument();
_86a[i].url="x";
_86a[i].parent.removeChild(_86a[i]);
_86a[i].close();
_84f("link[href=\""+url+"\"]",doc).orphan();
this._context.theme=null;
break;
}
}
}
}
}
}
},addTheme:function(_86b){
var _86c=_850.getHelper(_86b);
if(_86c&&_86c.addTheme){
_86c.addTheme(this._context,_86b);
}else{
var _86d=this._context.getModel().getDocumentElement();
var _86e=_86d.getChildElement("head");
var _86f=_86d.getChildElement("body");
var _870=dojo.clone(this._context.getHeader());
var _871=this._context.getFullResourcePath();
var _872=new davinci.model.Path(_86b.getFile().parent.getPath()).append(_86b.files[0]);
var _873=_872.relativeTo(_871,true);
var _874=_873.toString();
_870.styleSheets[_870.styleSheets.length]=_874;
var _875=_86f.getAttribute("class");
if(!_875){
_875=" ";
}
_875=_875+" "+_86b.className;
_875=_875.trim();
_870.bodyClasses=_875;
_86f.removeAttribute("class");
_86f.addAttribute("class",_875,false);
this._context.setHeader(_870);
var _876=_86e.getChildElement("style");
if(!_876){
_876=new _854("style");
_86e.addChild(_876);
}
var css=new _853();
css.url=_874;
var _877=_857.getModel({url:_850.getBase()+"/"+css.url,includeImports:true,});
css.cssFile=_877;
_876.addChild(css,0);
this._context.theme=_86b;
}
},removeThemeSet:function(_878){
var _879=_852.getThemes(_851.getProject(),this.workspaceOnly);
if(_878.desktopTheme){
for(var i=0;i<_879.length;i++){
if(_879[i].name===_878.desktopTheme){
this.removeTheme(_879[i]);
}
}
}
if(_878.mobileTheme&&(!_850.themeSetEquals(_878.mobileTheme,_850.dojoMobileDefault))){
this._context.close();
this._dojoxMobileRemoveTheme(this._context);
}
},addThemeSet:function(_87a){
var _87b=_852.getThemes(_851.getProject(),this.workspaceOnly);
if(_87a.desktopTheme){
for(var i=0;i<_87b.length;i++){
if(_87b[i].name===_87a.desktopTheme){
this.addTheme(_87b[i]);
}
}
}
if(_87a.mobileTheme){
this._dojoxMobileAddTheme(this._context,_87a.mobileTheme);
}
},_dojoxMobileRemoveTheme:function(_87c){
_87c._updateDojoConfig({themeMap:null,mblLoadCompatPattern:null,mblThemeFiles:null});
},_dojoxMobileAddTheme:function(_87d,_87e,_87f){
var _880=_850.getThemeLocation().toString().replace(/\//g,"\\/");
var re="''";
_87d._updateDojoConfig({themeMap:_850.getDojoxMobileThemeMap(_87d,_87e),mblLoadCompatPattern:re,mblThemeFiles:[]});
}});
});
},"davinci/ui.plugin":function(){
define("davinci/ui.plugin",["require","davinci/css!./ui.css"],function(_881){
return {id:"davinci.ui","davinci.view":[{id:"navigator",title:"Files",viewClass:"davinci/workbench/Explorer",iconClass:"paletteIcon paletteIconFiles"},{id:"hierarchy",title:"Hierarchy"},{id:"outline",title:"Outline",viewClass:"davinci/workbench/OutlineView",iconClass:"paletteIcon paletteIconOutline"},{id:"comment",title:"Comments",viewClass:"davinci/review/view/CommentView",iconClass:"paletteIcon paletteIconComments"},{id:"scope",title:"Scope"},{id:"properties",title:"Properties",viewClass:"davinci/workbench/PropertyEditor"},{id:"problems",title:"Problems",viewClass:"davinci/workbench/ProblemsView"},{id:"console",title:"Console"},{id:"history",title:"History"},{id:"search",title:"Search"}],"davinci.preferences":[{name:"Project",id:"project",hide:true,category:"",pageContent:"Project Settings here"},{name:"Project Settings",id:"ProjectPrefs",category:"davinci.ui.project",pane:"davinci/ui/ProjectPreferences",defaultValues:{"webContentFolder":"","themeFolder":"themes","widgetFolder":"lib/custom"}}],"davinci.perspective":{id:"main",title:"AJAX IDE",views:[{viewID:"davinci.ui.navigator",position:"left-bottom"},{viewID:"davinci.ui.outline",position:"right"},{viewID:"davinci.ui.properties",position:"right-bottom"}]},"davinci.actionSets":[{id:"editorActions",visible:true,menu:[{__mainMenu:true,separator:["new",false,"open",false]},{label:"Create",path:"new",id:"davinci.new",separator:["newApp",true,"newSketch",true,"newFolder",true,"newTheme",true,"newProject",true,"additions",true]},{label:"Open",path:"open",id:"davinci.open",separator:["openFile",true,"openTheme",true,"openOrion",true,"additions",false]}],actions:[{id:"newHTMLMobile",run:function(){
_881(["./ui/Resource"],function(r){
r.newHTMLMobile();
});
},iconClass:"newOpenMenuItem newMobileAppMenuItem",label:"Mobile Application...",menubarPath:"davinci.new/newApp"},{id:"newHTMLDesktop",run:function(){
_881(["./ui/Resource"],function(r){
r.newHTMLDesktop();
});
},iconClass:"newOpenMenuItem newDesktopAppMenuItem",label:"Desktop Application...",menubarPath:"davinci.new/newApp"},{id:"newHTMLSketchHiFi",run:function(){
_881(["./ui/Resource"],function(r){
r.newHTMLSketchHiFi();
});
},iconClass:"newOpenMenuItem newSketchHiFiMenuItem",label:"Sketch (high-fidelity)...",menubarPath:"davinci.new/newSketch"},{id:"newHTMLSketchLoFi",run:function(){
_881(["./ui/Resource"],function(r){
r.newHTMLSketchLoFi();
});
},iconClass:"newOpenMenuItem newSketchLoFiMenuItem",label:"Sketch (low-fidelity)...",menubarPath:"davinci.new/newSketch"},{id:"newFolder",run:function(){
_881(["./ui/Resource"],function(r){
r.newFolder();
});
},iconClass:"newOpenMenuItem newFolderMenuItem",label:"Folder...",menubarPath:"davinci.new/newFolder"},{id:"newCSS",run:function(){
_881(["./ui/Resource"],function(r){
r.newCSS();
});
},iconClass:"newOpenMenuItem newCSSMenuItem",label:"CSS File...",menubarPath:"davinci.new/newFolder"},{id:"newJS",run:function(){
_881(["./ui/Resource"],function(r){
r.newJS();
});
},iconClass:"newOpenMenuItem newJSMenuItem",label:"JavaScript File...",menubarPath:"davinci.new/newFolder"},{id:"newTheme",run:function(){
_881(["davinci/Workbench","davinci/ui/NewTheme"],function(_882,_883){
_882.showModal(new _883(),"New Theme",{width:300},null,true);
});
},iconClass:"newOpenMenuItem newThemeMenuItem",label:"Theme...",menubarPath:"davinci.new/newTheme"},{id:"newProject",run:function(){
_881(["./ui/Resource"],function(r){
r.newProject();
});
},iconClass:"newOpenMenuItem newProjectMenuItem",label:"Project...",menubarPath:"davinci.new/newProject"},{id:"openFile",run:function(){
_881(["./ui/Resource"],function(r){
r.openFile();
});
},iconClass:"newOpenMenuItem openFileMenuItem",label:"File...",toolbarPath:"davinci.toolbar.main/edit",menubarPath:"davinci.open/openFile",keyBinding:{accel:true,charOrCode:"o"}},{id:"openThemeEditor",run:function(){
_881(["davinci/Workbench","davinci/ui/OpenThemeDialog"],function(_884,_885){
_884.showModal(new _885(),"Open Theme",{width:200},null,true);
});
},iconClass:"newOpenMenuItem openThemeMenuItem",label:"Theme Editor...",menubarPath:"davinci.open/openTheme"},{id:"openReview",run:function(){
_881(["./ui/Resource"],function(r){
r.openFile();
});
},run:function(){
_881(["davinci/Workbench","davinci/review/widgets/OpenReviewDialog"],function(_886,_887){
_886.showModal(new _887(),"Open Review",{width:350,height:250});
});
},iconClass:"newOpenMenuItem openReviewMenuItem",label:"Review...",menubarPath:"davinci.open/openTheme"},{id:"orionNavigator",run:function(){
window.open("../navigate/table.html#","_blank");
window.focus();
},iconClass:"newOpenMenuItem orionIcon",label:"Orion Navigator",menubarPath:"davinci.open/openOrion"}]},{id:"main",visible:true,menu:[{__mainMenu:true,separator:["usersettings",false,"settings",false,"additions",false,"help",false]},{label:"User settings",path:"usersettings",id:"davinci.usersettings",className:"userSettingsMenu",iconClass:"userSettingsMenuIcon",showLabel:false,separator:["username",true,"logout",true,"additions",false]},{label:"Settings",path:"settings",id:"davinci.settings",className:"appSettingsMenu",iconClass:"appSettingsMenuIcon",showLabel:false,separator:["settings",true,"additions",false]},{label:"Help",path:"help",id:"davinci.help",className:"helpMenu",iconClass:"helpMenuIcon",showLabel:false,separator:["help",true,"about",false,"additions",false]}],actions:[{id:"editPreferences",run:function(){
_881(["davinci/workbench/Preferences"],function(_888){
_888.showPreferencePage();
});
},label:"Preferences...",menubarPath:"davinci.settings/settings"},{id:"editThemeSets",run:function(){
_881(["davinci/ui/ThemeSetsDialog"],function(_889){
_889();
});
},label:"Theme sets...",menubarPath:"davinci.settings/settings"},{id:"showHelp",run:function(){
window.open("app/docs/index.html","MaqettaDocumentation");
},label:"Documentation",menubarPath:"davinci.help/help",keyBinding:{charOrCode:dojo.keys.F1}},{id:"showTutotials",run:function(){
window.open("app/docs/index.html#tutorials/tutorials","MaqettaTutorials");
},label:"Tutorials",menubarPath:"davinci.help/help"},{id:"showVideos",run:function(){
window.open("http://www.youtube.com/user/Maqetta/","MaqettaVideos");
},label:"Videos",menubarPath:"davinci.help/help"},{id:"showCheatSheets",run:function(){
window.open("app/docs/index.html#cheatsheets/cheatsheets","MaqettaCheatSheets");
},label:"Cheat sheets",menubarPath:"davinci.help/help"},{id:"showHowTo",run:function(){
window.open("https://www.ibm.com/search/csass/search/?sn=dw&en=utf&hpp=20&dws=dw&q=maqetta&Search=Search","MaqettaHowTo");
},label:"How-to articles",menubarPath:"davinci.help/help"},{id:"about",run:function(){
_881(["davinci/ui/about"],function(_88a){
_88a.show();
});
},label:"About Maqetta",menubarPath:"davinci.help/about"},{id:"username",action:"davinci/actions/UserNameAction",run:function(){
window.open("../settings/settings.html","_blank");
window.focus();
},label:"{user}",menubarPath:"davinci.usersettings/username"},{id:"logout",action:"davinci/actions/LogoutAction",label:"Logout",menubarPath:"davinci.usersettings/logout"}]},{id:"explorerActions",visible:true,actions:[{id:"davinci.ui.rename",label:"Rename...",iconClass:"renameIcon",run:function(){
_881(["./ui/Resource"],function(r){
r.renameAction();
});
},isEnabled:function(item){
return _881("./ui/Resource").canModify(item);
},menubarPath:"addFiles"},{id:"davinci.ui.delete",label:"Delete",iconClass:"deleteIcon",isEnabled:function(item){
return _881("./ui/Resource").canModify(item);
},run:function(){
_881(["./ui/Resource"],function(r){
r.deleteAction();
});
},menubarPath:"delete",keyBinding:{charOrCode:[dojo.keys.DELETE,dojo.keys.BACKSPACE]}},{id:"davinci.ui.download",label:"Download",iconClass:"downloadSomeIcon",action:"davinci/actions/DownloadAction",isEnabled:function(item){
return _881("./ui/Resource").canModify(item);
},menubarPath:"delete"}]}],"davinci.actionSetPartAssociations":[{targetID:"davinci.ui.editorActions",parts:["davinci.ui.editorMenuBar"]},{targetID:"davinci.ui.explorerActions",parts:["davinci.ui.navigator"]}],"davinci.viewActions":[{viewContribution:{targetID:"davinci.ui.problems",actions:[{id:"Copy2",iconClass:"copyIcon",run:function(){
alert("view toolbar");
},label:"Copy",toolbarPath:"davinci.toolbar.main/edit",menubarPath:"davinci.edit/cut"}]}},{viewContribution:{targetID:"workbench.Explorer",actions:[{id:"davinci.ui.newfile",label:"New folder...",iconClass:"newFolderIcon",className:"FilesToolbarNewFolder",run:function(){
_881(["./ui/Resource"],function(r){
r.newFolder();
});
},toolbarPath:"download"},{id:"davinci.ui.deletefile",label:"Delete file...",iconClass:"FilesToolbarDeleteFileIcon",className:"FilesToolbarDeleteFile",run:function(){
_881(["./ui/Resource"],function(r){
r.deleteAction();
});
},toolbarPath:"download"},{id:"davinci.ui.renamefile",label:"Rename file...",iconClass:"FilesToolbarRenameFileIcon",className:"FilesToolbarRenameFile",run:function(){
_881(["./ui/Resource"],function(r){
r.renameAction();
});
},toolbarPath:"download"},{id:"davinci.ui.addFiles",label:"Upload and Extract ZIP file...",iconClass:"uploadZipIcon",className:"FilesToolbarUploadZip",run:function(){
_881(["./ui/Resource"],function(r){
r.addFilesZip();
});
},isEnabled:function(item){
return !item||_881("./ui/Resource").canModify(item);
},toolbarPath:"download"},{id:"davinci.ui.addFiles",label:"Upload files...",iconClass:"uploadIcon",className:"FilesToolbarUploadFiles",run:function(){
_881(["./ui/Resource"],function(r){
r.addFiles();
});
},isEnabled:function(item){
return !item||_881("./ui/Resource").canModify(item);
},toolbarPath:"download"},{id:"download",iconClass:"downloadSomeIcon",className:"FilesToolbarDownloadSelected",run:function(){
_881(["./Workbench","./ui/DownloadSelected"],function(_88b,_88c){
_88b.showModal(new _88c(),"Download",{width:440});
});
},label:"Download Selected Files",toolbarPath:"download"},{id:"download",iconClass:"downloadAllIcon",className:"FilesToolbarDownloadAll",run:function(){
_881(["./Workbench","./ui/Download"],function(_88d,_88e){
_88d.showModal(new _88e(),"Download",{width:440});
});
},label:"Download Entire Project",toolbarPath:"download"}]}}]};
});
},"dijit/_Templated":function(){
define("dijit/_Templated",["./_WidgetBase","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojo/_base/kernel"],function(_88f,_890,_891,_892,_893,lang,_894){
lang.extend(_88f,{waiRole:"",waiState:""});
return _893("dijit._Templated",[_890,_891],{widgetsInTemplate:false,constructor:function(){
_894.deprecated(this.declaredClass+": dijit._Templated deprecated, use dijit._TemplatedMixin and if necessary dijit._WidgetsInTemplateMixin","","2.0");
},_attachTemplateNodes:function(_895,_896){
this.inherited(arguments);
var _897=lang.isArray(_895)?_895:(_895.all||_895.getElementsByTagName("*"));
var x=lang.isArray(_895)?0:-1;
for(;x<_897.length;x++){
var _898=(x==-1)?_895:_897[x];
var role=_896(_898,"waiRole");
if(role){
_898.setAttribute("role",role);
}
var _899=_896(_898,"waiState");
if(_899){
_892.forEach(_899.split(/\s*,\s*/),function(_89a){
if(_89a.indexOf("-")!=-1){
var pair=_89a.split("-");
_898.setAttribute("aria-"+pair[0],pair[1]);
}
});
}
}
}});
});
},"davinci/ve/actions/RotateDeviceAction":function(){
define("davinci/ve/actions/RotateDeviceAction",["dojo/_base/declare","davinci/Workbench","davinci/actions/Action"],function(_89b,_89c,_89d){
return _89b("davinci.ve.actions.RotateDeviceAction",[_89d],{run:function(_89e){
var e=davinci.Workbench.getOpenEditor();
var _89f=e.getContext();
_89f.visualEditor.toggleOrientation();
},isEnabled:function(_8a0){
var e=davinci.Workbench.getOpenEditor();
if(e&&e.getContext){
var _8a1=e.getContext();
if(_8a1.getMobileDevice){
var _8a2=_8a1.getMobileDevice();
return (_8a2&&_8a2!=""&&_8a2!="none"&&_8a2!="desktop");
}else{
return false;
}
}else{
return false;
}
},updateStyling:function(){
var _8a3=false;
var _8a4=davinci.Workbench.getOpenEditor();
if(_8a4){
var _8a5=_8a4.visualEditor;
if(_8a5&&_8a5.getOrientation){
var _8a6=_8a5.getOrientation();
_8a3=(_8a6=="landscape");
}
}
var _8a7="orientationLandscape";
if(_8a3){
dojo.addClass(document.body,_8a7);
}else{
dojo.removeClass(document.body,_8a7);
}
}});
});
},"orion/editor/util":function(){
define("orion/editor/util",function(){
var _8a8=navigator.userAgent;
var isIE=parseFloat(_8a8.split("MSIE")[1])||undefined;
var _8a9=parseFloat(_8a8.split("Firefox/")[1]||_8a8.split("Minefield/")[1])||undefined;
var _8aa=_8a8.indexOf("Opera")!==-1;
var _8ab=parseFloat(_8a8.split("Chrome/")[1])||undefined;
var _8ac=_8a8.indexOf("Safari")!==-1&&!_8ab;
var _8ad=parseFloat(_8a8.split("WebKit/")[1])||undefined;
var _8ae=_8a8.indexOf("Android")!==-1;
var _8af=_8a8.indexOf("iPad")!==-1;
var _8b0=_8a8.indexOf("iPhone")!==-1;
var _8b1=_8af||_8b0;
var _8b2=navigator.platform.indexOf("Mac")!==-1;
var _8b3=navigator.platform.indexOf("Win")!==-1;
var _8b4=navigator.platform.indexOf("Linux")!==-1;
var _8b5=_8b3?"\r\n":"\n";
function _8b6(msg){
var args=arguments;
return msg.replace(/\$\{([^\}]+)\}/g,function(str,_8b7){
return args[(_8b7<<0)+1];
});
};
var _8b8="http://www.w3.org/1999/xhtml";
function _8b9(_8ba,_8bb){
if(_8ba.createElementNS){
return _8ba.createElementNS(_8b8,_8bb);
}
return _8ba.createElement(_8bb);
};
return {formatMessage:_8b6,createElement:_8b9,isIE:isIE,isFirefox:_8a9,isOpera:_8aa,isChrome:_8ab,isSafari:_8ac,isWebkit:_8ad,isAndroid:_8ae,isIPad:_8af,isIPhone:_8b0,isIOS:_8b1,isMac:_8b2,isWindows:_8b3,isLinux:_8b4,platformDelimiter:_8b5};
});
},"davinci/review/model/Resource":function(){
define("davinci/review/model/Resource",["dojo/_base/declare","davinci/review/model/resource/root"],function(_8bc,root){
var _8bd=null;
return {getRoot:function(){
if(!_8bd){
_8bd=root;
}
return _8bd;
}};
});
},"dijit/ToolbarSeparator":function(){
define("dijit/ToolbarSeparator",["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_8be,dom,_8bf,_8c0){
return _8be("dijit.ToolbarSeparator",[_8bf,_8c0],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"dijit/form/RadioButton":function(){
define("dijit/form/RadioButton",["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_8c1,_8c2,_8c3){
return _8c1("dijit.form.RadioButton",[_8c2,_8c3],{baseClass:"dijitRadio"});
});
},"dijit/MenuSeparator":function(){
require({cache:{"url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>"}});
define("dijit/MenuSeparator",["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_8c4,dom,_8c5,_8c6,_8c7,_8c8){
return _8c4("dijit.MenuSeparator",[_8c5,_8c6,_8c7],{templateString:_8c8,buildRendering:function(){
this.inherited(arguments);
dom.setSelectable(this.domNode,false);
},isFocusable:function(){
return false;
}});
});
},"dijit/form/ToggleButton":function(){
define("dijit/form/ToggleButton",["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_8c9,_8ca,_8cb,_8cc){
return _8c9("dijit.form.ToggleButton",[_8cb,_8cc],{baseClass:"dijitToggleButton",setChecked:function(_8cd){
_8ca.deprecated("setChecked("+_8cd+") is deprecated. Use set('checked',"+_8cd+") instead.","","2.0");
this.set("checked",_8cd);
}});
});
},"dijit/CheckedMenuItem":function(){
require({cache:{"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n"}});
define("dijit/CheckedMenuItem",["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_8ce,_8cf,_8d0,_8d1){
return _8ce("dijit.CheckedMenuItem",_8d0,{templateString:_8d1,checked:false,_setCheckedAttr:function(_8d2){
_8cf.toggle(this.domNode,"dijitCheckedMenuItemChecked",_8d2);
this.domNode.setAttribute("aria-checked",_8d2?"true":"false");
this._set("checked",_8d2);
},iconClass:"",onChange:function(){
},_onClick:function(evt){
if(!this.disabled){
this.set("checked",!this.checked);
this.onChange(this.checked);
}
this.onClick(evt);
}});
});
},"davinci/ve/prefs/HTMLEditPreferences":function(){
require({cache:{"url:davinci/ve/prefs/HtmlEditPreferences.html":"<div>\n\t<table style='margin: 4px;' cellspacing='4'>\n\t\t<tbody>\n\t\t\t<!--\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.flowLayout}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='flowBoxNode'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t-->\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.snapToNearestWidget}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='snapNode'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.showPossibleParents}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='showPossibleParentsNode'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.warnOnCSSOverride}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='cssOverrideWarn'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.absoluteWidgetsZindex}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='absoluteWidgetsZindex'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<!-- FIXME: Disabled for now. Ultimately, UI for this option should go to widget palette\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.widgetPaletteLayout}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='widgetPaletteLayout'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t-->\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.zazl}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='zazl'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>"}});
define("davinci/ve/prefs/HTMLEditPreferences",["dojo/_base/declare","dijit/layout/ContentPane","dijit/_TemplatedMixin","dijit/form/CheckBox","dijit/form/TextBox","dijit/form/Select","dojo/i18n!../nls/common","dojo/text!./HtmlEditPreferences.html"],function(_8d3,_8d4,_8d5,_8d6,_8d7,_8d8,_8d9,_8da){
return _8d3([_8d4,_8d5],{templateString:_8da,postMixInProperties:function(){
this._loc=_8d9;
},postCreate:function(){
this._snap=new _8d6({},this.snapNode);
this._showPossibleParents=new _8d6({},this.showPossibleParentsNode);
this._cssOverrideWarn=new _8d6({},this.cssOverrideWarn);
this._absoluteWidgetsZindex=new _8d7({},this.absoluteWidgetsZindex);
this._zazl=new _8d6({},this.zazl);
if(!this.containerNode){
this.containerNode=this.domNode;
}
},getDefaults:function(){
},setDefaults:function(){
},doApply:function(){
},getPreferences:function(){
return {snap:this._snap.checked,showPossibleParents:this._showPossibleParents.checked,cssOverrideWarn:this._cssOverrideWarn.checked,absoluteWidgetsZindex:this._absoluteWidgetsZindex.value,zazl:this._zazl.checked};
},setPreferences:function(_8db){
_8db=_8db||{};
this._check(this._snap,!!_8db.snap);
this._check(this._showPossibleParents,!!_8db.showPossibleParents);
this._check(this._cssOverrideWarn,!!_8db.cssOverrideWarn);
this._absoluteWidgetsZindex.set("value",_8db.absoluteWidgetsZindex);
this._check(this._zazl,!!_8db.zazl);
},_check:function(_8dc,_8dd){
_8dc.set("checked",_8dd);
},save:function(_8de){
davinci.ve._preferences=_8de;
}});
});
},"url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","dojox/html/_base":function(){
define("dojox/html/_base",["dojo/_base/declare","dojo/Deferred","dojo/dom-construct","dojo/html","dojo/_base/kernel","dojo/_base/lang","dojo/ready","dojo/_base/sniff","dojo/_base/url","dojo/_base/xhr","dojo/when","dojo/_base/window"],function(_8df,_8e0,_8e1,_8e2,_8e3,lang,_8e4,has,_8e5,_8e6,when,_8e7){
var html=_8e3.getObject("dojox.html",true);
if(has("ie")){
var _8e8=/(AlphaImageLoader\([^)]*?src=(['"]))(?![a-z]+:|\/)([^\r\n;}]+?)(\2[^)]*\)\s*[;}]?)/g;
}
var _8e9=/(?:(?:@import\s*(['"])(?![a-z]+:|\/)([^\r\n;{]+?)\1)|url\(\s*(['"]?)(?![a-z]+:|\/)([^\r\n;]+?)\3\s*\))([a-z, \s]*[;}]?)/g;
var _8ea=html._adjustCssPaths=function(_8eb,_8ec){
if(!_8ec||!_8eb){
return;
}
if(_8e8){
_8ec=_8ec.replace(_8e8,function(_8ed,pre,_8ee,url,post){
return pre+(new _8e5(_8eb,"./"+url).toString())+post;
});
}
return _8ec.replace(_8e9,function(_8ef,_8f0,_8f1,_8f2,_8f3,_8f4){
if(_8f1){
return "@import \""+(new _8e5(_8eb,"./"+_8f1).toString())+"\""+_8f4;
}else{
return "url("+(new _8e5(_8eb,"./"+_8f3).toString())+")"+_8f4;
}
});
};
var _8f5=/(<[a-z][a-z0-9]*\s[^>]*)(?:(href|src)=(['"]?)([^>]*?)\3|style=(['"]?)([^>]*?)\5)([^>]*>)/gi;
var _8f6=html._adjustHtmlPaths=function(_8f7,cont){
var url=_8f7||"./";
return cont.replace(_8f5,function(tag,_8f8,name,_8f9,_8fa,_8fb,_8fc,end){
return _8f8+(name?(name+"="+_8f9+(new _8e5(url,_8fa).toString())+_8f9):("style="+_8fb+_8ea(url,_8fc)+_8fb))+end;
});
};
var _8fd=html._snarfStyles=function(_8fe,cont,_8ff){
_8ff.attributes=[];
cont=cont.replace(/<[!][-][-](.|\s)*?[-][-]>/g,function(_900){
return _900.replace(/<(\/?)style\b/ig,"&lt;$1Style").replace(/<(\/?)link\b/ig,"&lt;$1Link").replace(/@import "/ig,"@ import \"");
});
return cont.replace(/(?:<style([^>]*)>([\s\S]*?)<\/style>|<link\s+(?=[^>]*rel=['"]?stylesheet)([^>]*?href=(['"])([^>]*?)\4[^>\/]*)\/?>)/gi,function(_901,_902,_903,_904,_905,href){
var i,attr=(_902||_904||"").replace(/^\s*([\s\S]*?)\s*$/i,"$1");
if(_903){
i=_8ff.push(_8fe?_8ea(_8fe,_903):_903);
}else{
i=_8ff.push("@import \""+href+"\";");
attr=attr.replace(/\s*(?:rel|href)=(['"])?[^\s]*\1\s*/gi,"");
}
if(attr){
attr=attr.split(/\s+/);
var _906={},tmp;
for(var j=0,e=attr.length;j<e;j++){
tmp=attr[j].split("=");
_906[tmp[0]]=tmp[1].replace(/^\s*['"]?([\s\S]*?)['"]?\s*$/,"$1");
}
_8ff.attributes[i-1]=_906;
}
return "";
});
};
var _907=html._snarfScripts=function(cont,_908){
_908.code="";
cont=cont.replace(/<[!][-][-](.|\s)*?[-][-]>/g,function(_909){
return _909.replace(/<(\/?)script\b/ig,"&lt;$1Script");
});
function _90a(src){
if(_908.downloadRemote){
src=src.replace(/&([a-z0-9#]+);/g,function(m,name){
switch(name){
case "amp":
return "&";
case "gt":
return ">";
case "lt":
return "<";
default:
return name.charAt(0)=="#"?String.fromCharCode(name.substring(1)):"&"+name+";";
}
});
_8e6.get({url:src,sync:true,load:function(code){
_908.code+=code+";";
},error:_908.errBack});
}
};
return cont.replace(/<script\s*(?![^>]*type=['"]?(?:dojo\/|text\/html\b))[^>]*?(?:src=(['"]?)([^>]*?)\1[^>]*)?>([\s\S]*?)<\/script>/gi,function(_90b,_90c,src,code){
if(src){
_90a(src);
}else{
_908.code+=code;
}
return "";
});
};
var _90d=html.evalInGlobal=function(code,_90e){
_90e=_90e||_8e7.doc.body;
var n=_90e.ownerDocument.createElement("script");
n.type="text/javascript";
_90e.appendChild(n);
n.text=code;
};
html._ContentSetter=_8df(_8e2._ContentSetter,{adjustPaths:false,referencePath:".",renderStyles:false,executeScripts:false,scriptHasHooks:false,scriptHookReplacement:null,_renderStyles:function(_90f){
this._styleNodes=[];
var st,att,_910,doc=this.node.ownerDocument;
var head=doc.getElementsByTagName("head")[0];
for(var i=0,e=_90f.length;i<e;i++){
_910=_90f[i];
att=_90f.attributes[i];
st=doc.createElement("style");
st.setAttribute("type","text/css");
for(var x in att){
st.setAttribute(x,att[x]);
}
this._styleNodes.push(st);
head.appendChild(st);
if(st.styleSheet){
st.styleSheet.cssText=_910;
}else{
st.appendChild(doc.createTextNode(_910));
}
}
},empty:function(){
this.inherited("empty",arguments);
this._styles=[];
},onBegin:function(){
this.inherited("onBegin",arguments);
var cont=this.content,node=this.node;
var _911=this._styles;
if(lang.isString(cont)){
if(this.adjustPaths&&this.referencePath){
cont=_8f6(this.referencePath,cont);
}
if(this.renderStyles||this.cleanContent){
cont=_8fd(this.referencePath,cont,_911);
}
if(this.executeScripts){
var _912=this;
var _913={downloadRemote:true,errBack:function(e){
_912._onError.call(_912,"Exec","Error downloading remote script in \""+_912.id+"\"",e);
}};
cont=_907(cont,_913);
this._code=_913.code;
}
}
this.content=cont;
},onEnd:function(){
var code=this._code,_914=this._styles;
if(this._styleNodes&&this._styleNodes.length){
while(this._styleNodes.length){
_8e1.destroy(this._styleNodes.pop());
}
}
if(this.renderStyles&&_914&&_914.length){
this._renderStyles(_914);
}
var d=new _8e0();
var _915=this.getInherited(arguments),args=arguments,_916=lang.hitch(this,function(){
_915.apply(this,args);
when(this.parseDeferred,function(){
d.resolve();
});
});
if(this.executeScripts&&code){
if(this.cleanContent){
code=code.replace(/(<!--|(?:\/\/)?-->|<!\[CDATA\[|\]\]>)/g,"");
}
if(this.scriptHasHooks){
code=code.replace(/_container_(?!\s*=[^=])/g,this.scriptHookReplacement);
}
try{
_90d(code,this.node);
}
catch(e){
this._onError("Exec","Error eval script in "+this.id+", "+e.message,e);
}
_8e4(_916);
}else{
_916();
}
return d.promise;
},tearDown:function(){
this.inherited(arguments);
delete this._styles;
if(this._styleNodes&&this._styleNodes.length){
while(this._styleNodes.length){
_8e1.destroy(this._styleNodes.pop());
}
}
delete this._styleNodes;
lang.mixin(this,html._ContentSetter.prototype);
}});
html.set=function(node,cont,_917){
if(!_917){
return _8e2._setNodeContent(node,cont,true);
}else{
var op=new html._ContentSetter(lang.mixin(_917,{content:cont,node:node}));
return op.set();
}
};
return html;
});
},"davinci/ve/actions/DeleteAction":function(){
define("davinci/ve/actions/DeleteAction",["dojo/_base/declare","davinci/Workbench","davinci/ve/actions/ContextAction","davinci/commands/CompoundCommand","davinci/ve/commands/RemoveCommand"],function(_918,_919,_91a,_91b,_91c){
return _918("davinci.ve.actions.DeleteAction",[_91a],{run:function(_91d){
_91d=this.fixupContext(_91d);
if(_91d){
var _91e=this._normalizeSelection(_91d);
if(_91e.length>0){
var _91f=undefined;
if(_91e.length===1){
var w=_91e[0];
var _920=w.getHelper();
if(_920&&_920.getRemoveCommand){
_91f=_920.getRemoveCommand(w);
}else{
_91f=new _91c(w);
}
}else{
_91f=new _91b();
dojo.forEach(_91e,function(w){
var c;
var _921=w.getHelper();
if(_921&&_921.getRemoveCommand){
c=_921.getRemoveCommand(w);
}else{
c=new _91c(w);
}
_91f.add(c);
});
}
_91d.select(null);
_91d.getCommandStack().execute(_91f);
}
}
},isEnabled:function(_922){
_922=this.fixupContext(_922);
var e=_919.getOpenEditor();
if(e&&_922){
var _923=(_922.getSelection().length>0);
if(e.declaredClass=="davinci.ve.PageEditor"){
var _924=e.getDisplayMode();
return _923&&_924!="source";
}else{
return _923;
}
}else{
return false;
}
},shouldShow:function(_925){
_925=this.fixupContext(_925);
var _926=_925?_925.editor:null;
return (_926&&_926.declaredClass=="davinci.ve.PageEditor");
}});
});
},"davinci/css":function(){
define("davinci/css",["dojo/_base/window","dojo/dom-construct","dojo/dom-attr"],function(_927,_928){
var head=_927.doc.getElementsByTagName("head")[0],_929={};
return {load:function(id,_92a,_92b){
var url=_92a.toUrl(id);
if(url in _929){
_92b();
return;
}
_928.create("link",{rel:"stylesheet",type:"text/css",href:url},head);
_929[url]=1;
_92b();
}};
});
},"davinci/ve/commands/MoveCommand":function(){
define("davinci/ve/commands/MoveCommand",["dojo/_base/declare","dojo/dom-geometry","davinci/ve/widget","davinci/ve/States","davinci/ve/utils/StyleArray","davinci/ve/utils/GeomUtils"],function(_92c,_92d,_92e,_92f,_930,_931){
return _92c("davinci.ve.commands.MoveCommand",null,{name:"move",constructor:function(_932,left,top,_933,_934,_935,_936){
this._id=(_932?_932.id:undefined);
this._context=_932.getContext();
this._newBox={l:left,t:top};
this._commandForXYDeltas=_933;
this._oldBox=_934;
this._applyToStateIndex=(!_935||_935=="Normal"||_935=="undefined")?"undefined":_935;
this._disableSnapping=_936;
},execute:function(){
if(!this._id){
return;
}
var _937=_92e.byId(this._id);
if(!_937||!_937.domNode){
return;
}
var _938=this._context;
if(!this._oldBox){
var box=_937.getMarginBox();
this._oldBox={l:box.l,t:box.t,w:box.w,h:box.h};
}
if(!_937.domNode.offsetParent){
return;
}
var _939=dojo.position(_937.domNode.offsetParent,true);
if(!_939){
return;
}
if(this._commandForXYDeltas){
this._newBox.l=this._oldBox.l+this._commandForXYDeltas._deltaX;
this._newBox.t=this._oldBox.t+this._commandForXYDeltas._deltaY;
}else{
if(!this._disableSnapping&&_938&&_938._snapX){
var w=this._oldBox.w;
if(_938._snapX.typeRefObj=="left"){
this._newBox.l=_938._snapX.x;
}else{
if(w&&_938._snapX.typeRefObj=="right"){
this._newBox.l=_938._snapX.x-w;
}else{
if(w&&_938._snapX.typeRefObj=="center"){
this._newBox.l=_938._snapX.x-w/2;
}
}
}
}
if(!this._disableSnapping&&_938&&_938._snapY){
var h=this._oldBox.h;
if(_938._snapY.typeRefObj=="top"){
this._newBox.t=_938._snapY.y;
}else{
if(h&&_938._snapY.typeRefObj=="bottom"){
this._newBox.t=_938._snapY.y-h;
}else{
if(h&&_938._snapY.typeRefObj=="middle"){
this._newBox.t=_938._snapY.y-h/2;
}
}
}
}
}
this._deltaX=this._newBox.l-this._oldBox.l;
this._deltaY=this._newBox.t-this._oldBox.t;
var _93a=_931.getBorderBoxPageCoords(_937.domNode.offsetParent);
var _93b=_92d.getBorderExtents(_937.domNode.offsetParent);
var _93c=this._newBox.l-_93a.l-_93b.l;
var _93d=this._newBox.t-_93a.t-_93b.t;
var _93e=[{left:_93c+"px"},{top:_93d+"px"}];
var _93f=_937.getStyleValuesAllStates();
this._oldStyleValuesAllStates=dojo.clone(_93f);
if(this._oldBox){
var _940=this._oldBox.l-_93a.l-_93b.l;
var _941=this._oldBox.t-_93a.t-_93b.t;
this._oldStyleValuesAllStates[this._applyToStateIndex]=_930.mergeStyleArrays(this._oldStyleValuesAllStates[this._applyToStateIndex],[{left:_940+"px"},{top:_941+"px"}]);
}
if(_93f[this._applyToStateIndex]){
_93f[this._applyToStateIndex]=_930.mergeStyleArrays(_93f[this._applyToStateIndex],_93e);
}else{
_93f[this._applyToStateIndex]=_93e;
}
_937.setStyleValuesAllStates(_93f);
var _942=_92f.getStatesListCurrent(_937.domNode);
var _943=_930.mergeStyleArrays([],_93f["undefined"]);
for(var i=0;i<_942.length;i++){
if(_93f[_942[i]]){
_943=_930.mergeStyleArrays(_943,_93f[_942[i]]);
}
}
_937.setStyleValuesCanvas(_943);
_937.setStyleValuesModel(_93f["undefined"]);
_937.refresh();
_92f.resetState(_937.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_937]]);
},undo:function(){
if(!this._id){
return;
}
var _944=_92e.byId(this._id);
if(!_944){
return;
}
var _945=this._oldStyleValuesAllStates;
var _946=this._applyToStateIndex;
_944.setStyleValuesAllStates(_945);
var _947=_930.mergeStyleArrays(_945["undefined"],_945[_946]);
_944.setStyleValuesCanvas(_947);
_944.setStyleValuesModel(this._oldStyleValuesAllStates["undefined"]);
_944.refresh();
davinci.ve.states.resetState(_944.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_944]]);
}});
});
},"davinci/html/HTMLComment":function(){
define("davinci/html/HTMLComment",["dojo/_base/declare","davinci/html/HTMLItem"],function(_948,_949){
return _948("davinci.html.HTMLComment",_949,{constructor:function(_94a){
this.elementType="HTMLComment";
this.value=_94a||"";
},getText:function(_94b){
var dash=this.isProcessingInstruction?"":"--";
return "<!"+dash+this.value+dash+">";
}});
});
},"davinci/ve/actions/ModifyState":function(){
require({cache:{"url:davinci/ve/actions/templates/ModifyState.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div class='modify_state_container'>\n\t\t\t<div data-dojo-type=\"dijit.form.DropDownButton\" label='${veNls.renameLabel}' dojoAttachPoint=\"renameButton\" class=\"modify_state_rename_button\">\n\t\t\t\t\t<div data-dojo-type=\"dijit.TooltipDialog\" class='modify_state_rename_container' id='state_rename_tooltip_dialog'>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<label for=\"state_rename_new_name\">${veNls.newStateLabel}</label>\n\t\t\t\t\t\t\t<input data-dojo-type=\"dijit.form.ValidationTextBox\" id=\"state_rename_new_name\" name=\"state_rename_new_name\"></input>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div>\n\t\t\t\t\t\t\t<button id=\"state_rename_do_it\" dojoType='dijit.form.Button' label='${veNls.renameLabel}'></button>\n\t\t\t\t\t\t\t<button id=\"state_rename_cancel\" dojoType='dijit.form.Button' label='${veNls.cancelLabel}'></button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t${veNls.stateLabel}: <span id='modify_state_old_name'>aaa</span>\n\t\t</div>\n\t\t<div class='initial_state_row'>\n\t\t\t<input data-dojo-type=\"dijit.form.CheckBox\" dojoAttachPoint=\"initialState\" id=\"modify_state_initial_state\" name=\"modify_state_initial_state\"></input>\n\t\t\t<label for='modify_state_initial_state'>${veNls.initialStateCheckBoxLabel}</label>\n\t\t</div>\n\t</div>\n\t\t\t\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"okButton\" label='${veNls.modifyLabel}' class=\"maqPrimaryButton\"></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"cancelButton\" label='${commonNls.buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n"}});
define("davinci/ve/actions/ModifyState",["dojo/_base/declare","dojo/Deferred","dojo/_base/connect","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dijit/popup","dijit/focus","davinci/ve/States","davinci/ui/Dialog","davinci/Runtime","davinci/Workbench","davinci/actions/Action","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common","dojo/text!./templates/ModifyState.html","dijit/form/TextBox","dijit/form/ValidationTextBox","davinci/commands/CompoundCommand","davinci/ve/commands/AppStateCommand"],function(_94c,_94d,_94e,_94f,_950,_951,_952,_953,_954,_955,_956,_957,_958,_959,_95a,_95b,_95c,_95d,_95e,_95f){
var _960=null;
var _961=_94c("davinci.ve.actions.ModifyStateWidget",[_94f,_950,_951],{templateString:_95b,widgetsInTemplate:true,veNls:_959,commonNls:_95a,isNormalState:false,newName:null,oldInitialStateOn:null,postCreate:function(){
this._connections=[];
var _962=dijit.byId("state_rename_tooltip_dialog");
_960.then(function(){
if(!this._statesFocus.state||this._statesFocus.state===_954.NORMAL){
this.isNormalState=true;
}
var _963=dojo.byId("modify_state_old_name");
if(_963){
if(this._statesFocus&&this._statesFocus.state&&!this.isNormalState){
_963.innerHTML=this._statesFocus.state;
}else{
_963.innerHTML="<i>"+_954.NORMAL+"</i>";
this.renameButton.set("disabled",true);
}
}
var _964=(_954.getInitial(this._statesFocus.stateContainerNode)===this._statesFocus.state);
this.oldInitialStateOn=_964;
this.initialState.set("checked",_964);
if(_964&&this.isNormalState){
this.initialState.set("disabled",true);
}
this._dialog.connect(this._dialog,"hide",function(e){
this.onClose();
}.bind(this));
this.okButton.connect(this.okButton,"onClick",dojo.hitch(this,function(e){
this.onOk(e);
}));
this.cancelButton.connect(this.cancelButton,"onClick",dojo.hitch(this,function(e){
this.onCancel(e);
}));
var _965=dijit.byId("state_rename_tooltip_dialog");
if(_965){
_965.connect(_965,"onShow",function(e){
this.renameStateShowTooltipDialog(e);
}.bind(this));
_965.connect(_965,"onHide",function(e){
this.renameStateHideTooltipDialog(e);
}.bind(this));
}
}.bind(this));
},renameStateShowTooltipDialog:function(e){
var _966=dojo.byId("modify_state_old_name");
var _967=dojo.byId("state_rename_new_name");
var _968=dijit.byId("state_rename_new_name");
if(_966&&_968){
var _969=_966.innerText;
_968.set("value",_969);
}
_953.focus(_967);
var _96a=dijit.byId("state_rename_do_it");
var _96b=dijit.byId("state_rename_cancel");
_96a.connect(_96a,"onMouseDown",function(e){
e.stopPropagation();
});
_96b.connect(_96a,"onMouseDown",function(e){
e.stopPropagation();
});
_96a.connect(_96a,"onClick",function(e){
this.renameStateDoIt(e);
}.bind(this));
_96b.connect(_96b,"onClick",function(e){
var _96c=dijit.byId("state_rename_tooltip_dialog");
_952.close(_96c);
}.bind(this));
},renameStateDoIt:function(e){
var _96d=dojo.byId("modify_state_old_name");
var _96e=dijit.byId("state_rename_new_name");
var _96f=_96e?_96e.get("value"):null;
var _970=dijit.byId("state_rename_tooltip_dialog");
if(_96d&&_96f){
_96d.innerHTML=_96f;
this.newName=_96f;
}
if(_970){
_952.close(_970);
}
},renameStateHideTooltipDialog:function(e){
},onOk:function(e){
var _971,_972;
if(_956.currentEditor&&_956.currentEditor.currentEditor&&_956.currentEditor.currentEditor.context){
_972=_956.currentEditor;
_971=_956.currentEditor.currentEditor.context;
}else{
return;
}
var _973=_954.getFocus(_971.rootNode);
if(!_973||!_973.stateContainerNode){
return;
}
var _974;
if(this.newName&&this.newName!==this._statesFocus.state){
_974=this.newName;
}
var _975;
var _976=this.initialState.get("checked");
if(_976!==this.oldInitialStateOn){
var _977=_973.state?_973.state:"undefined";
_975=_976?_977:null;
}
if(_974||_975){
var _978=new _95e();
_978.add(new _95f({action:"modify",state:_973.state,stateContainerNode:_973.stateContainerNode,context:_971,newState:_974,initialState:_975}));
_971.getCommandStack().execute(_978);
}
this.onClose();
},onCancel:function(){
this.onClose();
},onClose:function(e){
var _979;
while(_979=this._connections.pop()){
_94e.disconnect(_979);
}
}});
return _94c("davinci.ve.actions.ModifyState",[_958],{run:function(){
var _97a;
if(_956.currentEditor&&_956.currentEditor.currentEditor&&_956.currentEditor.currentEditor.context){
_97a=_956.currentEditor.currentEditor.context;
}else{
return;
}
var _97b=_954.getFocus(_97a.rootNode);
if(!_97b){
return;
}
_960=new _94d();
var w=new davinci.ve.actions.ModifyStateWidget();
var _97c=_957.showModal(w,_959.modifyState);
this._dialog=w._dialog=_97c;
w._statesFocus=_97b;
_960.resolve();
}});
});
},"url:davinci/ui/templates/UserLibraries.html":"<div class='userLibDialog'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div dojoAttachPoint=\"_tableDiv\"></div>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' type='submit' dojoAttachEvent='onClick:okButton' label='${modify}' class=\"maqPrimaryButton\"></button> \n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button> \n\t</div> \n</div>","dijit/_DialogMixin":function(){
define("dijit/_DialogMixin",["dojo/_base/declare","./a11y"],function(_97d,a11y){
return _97d("dijit._DialogMixin",null,{execute:function(){
},onCancel:function(){
},onExecute:function(){
},_onSubmit:function(){
this.onExecute();
this.execute(this.get("value"));
},_getFocusItems:function(){
var _97e=a11y._getTabNavigable(this.containerNode);
this._firstFocusItem=_97e.lowest||_97e.first||this.closeButtonNode||this.domNode;
this._lastFocusItem=_97e.last||_97e.highest||this._firstFocusItem;
}});
});
},"davinci/ve/actions/CutAction":function(){
define("davinci/ve/actions/CutAction",["dojo/_base/declare","./_CutCopyAction","../../Runtime"],function(_97f,_980,_981){
return _97f("davinci.ve.actions.CutAction",[_980],{_invokeSourceEditorAction:function(_982){
_982.htmlEditor.cutAction.run();
},_executeAction:function(_983,_984,data,_985){
_981.clipboard=data;
_983.select(null);
_983.getCommandStack().execute(_985);
}});
});
},"davinci/Workbench":function(){
define("davinci/Workbench",["dojo/_base/lang","require","./Runtime","./model/Path","./workbench/ViewPart","./workbench/EditorContainer","./ui/Dialog","dijit/Toolbar","dijit/ToolbarSeparator","dijit/Menu","dijit/MenuBar","dijit/MenuItem","dijit/MenuSeparator","dijit/PopupMenuBarItem","dijit/form/Button","dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton","dijit/layout/BorderContainer","dijit/layout/StackController","dijit/layout/StackContainer","dijit/layout/ContentPane","dijit/layout/TabController","dijit/layout/TabContainer","system/resource","dojo/i18n!./nls/webContent","./ve/metadata","dojo/Deferred","dojo/promise/all","dojo/_base/declare","dojo/_base/connect","dojo/_base/xhr","./review/model/resource/root","dojo/i18n!./ve/nls/common","./ve/utils/GeomUtils","dojo/i18n!./ui/nls/common","davinci/review/model/resource/root"],function(lang,_986,_987,Path,_988,_989,_98a,_98b,_98c,Menu,_98d,_98e,_98f,_990,_991,_992,_993,_994,_995,_996,_997,_998,_999,_99a,_99b,_99c,_99d,_99e,all,_99f,_9a0,xhr,_9a1,_9a2,_9a3,_9a4,_9a5){
var _9a6=71;
var _9a7=20;
var _9a8={};
Function.prototype.bind=Function.prototype.bind||function(that){
return dojo.hitch(that,this);
};
var _9a9=function(_9aa){
return "editor-"+encodeURIComponent(_9aa.replace(/[\/| |\t]/g,"_")).replace(/%/g,":");
};
var _9ab=function(_9ac){
return _9ac.replace(/^editor/,"shadow");
};
var _9ad=function(_9ae){
return _9ae.replace(/^shadow/,"editor");
};
var _9af=function(_9b0,_9b1){
if(_9b1.status==401||_9b1.status==403){
_9b2();
}else{
if(_9b0.canceled===true){
var _9b3=new RegExp("(^|\\.\\/|"+document.baseURI+"\\/)cmd\\/");
var url=_9b0.ioArgs.url;
if(_9b3.test(url)){
if(url.indexOf("getBluePageInfo")>=0){
return;
}
}else{
return;
}
_987.handleError(_9b1.message);
console.warn("Failed to load url="+url+" message="+_9b1.message+" status="+_9b1.status);
}
}
};
var _9b2=function(){
var _9b4="welcome";
var _9b5=new _98a({title:_99c.sessionTimedOut});
var _9b6=dojo.string.substitute(_99c.sessionTimedOutMsg,{hrefLoc:_9b4});
_9b5.set("content",_9b6);
dojo.connect(_9b5,"onCancel",null,function(){
window.location.href=_9b4;
});
setTimeout(function(){
window.location.href=_9b4;
},10000);
_9b5.show();
};
var _9b7=function(){
davinci.Workbench._expandCollapsePaletteContainers(null,{dontPreserveWidth:true});
var _9b8=function(_9b9){
return _9b9.indexOf(".review")>-1;
};
var _9ba=function(_9bb){
return new Path(_9bb).segment(2);
};
var _9bc=function(_9bd){
return new Path(_9bd).removeFirstSegments(3);
};
var init=function(_9be){
dojo.publish("/davinci/ui/initialPerspectiveReady",[]);
if(_9be.project){
_9cf.setActiveProject(_9be.project);
}
if(_9be.editors){
_9be.version=davinci.version;
var _9bf,_9c0=_9cf.singleProjectMode();
if(_9c0){
_9bf=new Path(_9cf.getProject());
}
_9be.editors.forEach(function(_9c1){
var _9c2=_9b8(_9c1);
if(!_9c2&&_9c0){
if(!new Path(_9c1).startsWith(_9bf)){
return;
}
}
var _9c3=function(_9c4){
var _9c5=true;
if(_9c0){
var path=new Path(_9be.activeEditor);
if(!path.startsWith(_9bf)){
_9c5=false;
}
}
var _9c6=_9c1!=_9be.activeEditor;
if(_9c6&&!_9c5&&!_9b8(_9be.activeEditor)){
_9c6=false;
_9be.activeEditor=_9c1;
}
if(_9c4){
_9cf.openEditor({fileName:_9c4,noSelect:_9c6,isDirty:_9c4.isDirty(),startup:false,initializationTime:true});
}
};
if(_9c2){
var _9c7=_9ba(_9c1);
var _9c8=_9bc(_9c1).toString();
_9a1.findFile(_9c7,_9c8).then(function(_9c9){
_9c3(_9c9);
});
}else{
_9c3(_99b.findResource(_9c1));
}
});
}else{
_9be.editors=[];
}
};
if(!_9cf._state){
_9cf._state=_987.getWorkbenchState();
}
var _9ca=dojo.cookie("davinci_designer");
var _9cb=dojo.cookie("davinci_version");
dojo.cookie("davinci_designer",null,{expires:-1,path:"/"});
dojo.cookie("davinci_version",null,{expires:-1,path:"/"});
if(_9cb&&_9ca){
_9a5.findVersion(_9ca,_9cb).then(function(node){
if(node){
node.getChildren(function(_9cc){
_9cc.forEach(function(_9cd,_9ce){
var p=_9cd.getPath();
if(_9ce==0){
_9cf._state.activeEditor=p;
}
if(_9cf._state.editors.indexOf(p)<0){
_9cf._state.editors.push(p);
}
}.bind(this));
init(_9cf._state);
});
}
}.bind(this));
}else{
init(_9cf._state);
}
_9cf.setupGlobalKeyboardHandler();
};
var _9cf={activePerspective:"",actionScope:[],_DEFAULT_PROJECT:"project1",hideEditorTabs:true,_editorTabClosing:{},_shadowTabClosing:{},run:function(){
_987.run();
_9cf._initKeys();
_9cf._baseTitle=dojo.doc.title;
if(window.maqetta&&maqetta.TopBanner&&maqetta.TopBanner.setup){
maqetta.TopBanner.setup();
}
_987.subscribe("/davinci/resource/resourceChanged",function(type,_9d0){
if(type=="deleted"){
var _9d1=_9a9(_9d0.getPath());
var _9d2=_9ab(_9d1);
var _9d3=dijit.byId(_9d1);
var _9d4=dijit.byId(_9d2);
if(_9d3&&!_9d3._isClosing){
var _9d5=dijit.byId("editors_container");
var _9d6=dijit.byId("davinci_file_tabs");
_9d5.removeChild(_9d3);
_9d3.destroyRecursive();
_9d6.removeChild(_9d4);
_9d4.destroyRecursive();
}
}
});
_987.subscribe("/dojo/io/error",_9af);
_987.subscribe("/davinci/states/state/changed",function(e){
var _9d7=_987.currentEditor;
if((_9d7.declaredClass!="davinci.ve.themeEditor.ThemeEditor"&&_9d7.declaredClass!="davinci.review.editor.ReviewEditor")){
_9d7.visualEditor.onContentChange.apply(_9d7.visualEditor,arguments);
}
});
_987.subscribe("/davinci/ui/widgetPropertiesChanges",function(){
var ve=_987.currentEditor.visualEditor;
ve._objectPropertiesChange.apply(ve,arguments);
});
_9a0.subscribe("/davinci/states/state/changed",function(args){
var _9d8=(_987.currentEditor&&_987.currentEditor.declaredClass=="davinci.ve.PageEditor"&&_987.currentEditor.visualEditor&&_987.currentEditor.visualEditor.context);
if(!_9d8){
return;
}
var _9d9="_show:",_9da,_9db,_9dc;
var _9dd=_9d8?_9d8.getDijit():null;
var _9de=_986("davinci/ve/widget");
if(args.newState&&!args.newState.indexOf(_9d9)){
_9da=_9dd.byId(args.newState.substring(6));
_9db=_9de.getWidget(_9da.domNode);
_9dc=_9db.getHelper();
_9dc&&_9dc.popup&&_9dc.popup(_9db);
}
if(args.oldState&&!args.oldState.indexOf(_9d9)){
_9da=_9dd.byId(args.oldState.substring(6));
_9db=_9de.getWidget(_9da.domNode);
_9dc=_9db.getHelper();
_9dc&&_9dc.tearDown&&_9dc.tearDown(_9db);
}
});
_9a0.subscribe("/davinci/ui/repositionFocusContainer",function(args){
_9cf._repositionFocusContainer();
});
var d=xhr.get({url:"cmd/getInitializationInfo",handleAs:"json"}).then(function(_9df){
_987._initializationInfo=_9df;
var _9e0=_9df.userInfo;
_987.isLocalInstall=_9e0.userId=="maqettaUser";
_987.userName=_9e0.userId;
_987.userEmail=_9e0.email;
return _99d.init();
}).then(function(){
var _9e1=_987.initialPerspective||"davinci.ui.main";
dojo.query(".loading").orphan();
_9cf.showPerspective(_9e1);
_9cf._updateTitle();
_9b7();
}).otherwise(function(_9e2){
dojo.query("#load_screen").addContent(dojo.string.substitute(_99c.startupError,[_9e2.message]),"only");
});
_9cf._lastAutoSave=Date.now();
setInterval(dojo.hitch(this,"_autoSave"),30000);
return d;
},unload:function(){
_9cf._autoSave();
},logoff:function(args){
dojo.create("div",{"class":"loading",innerHTML:"<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;Logging off...</td></tr></table>"},dojo.body(),"first");
_9cf.unload();
return xhr.get({url:"cmd/logoff",handleAs:"text"}).then(function(_9e3){
location.href="welcome";
});
},_createToolBar:function(_9e4,_9e5,_9e6,_9e7){
var _9e8=[];
if(!_9e6){
_9e6=_987.getExtensions("davinci.actionSets");
}
for(var i=0,len=_9e6.length;i<len;i++){
var _9e9=_9e6[i].actions;
for(var k=0,len2=_9e9.length;k<len2;k++){
var _9ea=_9e9[k],_9eb=_9ea[_9e4];
if(_9eb){
if(!_9e8[_9eb]){
_9e8[_9eb]=[];
}
_9e8[_9eb].push(_9ea);
}
}
}
var _9ec=new _98b({"class":"davinciToolbar"},_9e5);
var _9ed={};
var _9ee=true;
for(var _9ef in _9e8){
if(!_9ee){
var _9f0=new _98c();
_9ec.addChild(_9f0);
}else{
_9ee=false;
}
var _9e9=_9e8[_9ef];
for(var p=0;p<_9e9.length;p++){
var _9ea=_9e9[p];
_9cf._loadActionClass(_9ea);
var _9f1={showLabel:false};
["label","showLabel","iconClass"].forEach(function(prop){
if(_9ea.hasOwnProperty(prop)){
_9f1[prop]=_9ea[prop];
}
});
if(_9ea.className){
_9f1["class"]=_9ea.className;
}
var _9f2;
var _9f3=new _99e();
if(_9ea.menu&&(_9ea.type=="DropDownButton"||_9ea.type=="ComboButton")){
var menu=new Menu({style:"display: none;"});
for(var _9f4=0;_9f4<_9ea.menu.length;_9f4++){
var _9f5=_9ea.menu[_9f4];
_9cf._loadActionClass(_9f5);
var _9f6={onClick:dojo.hitch(this,"_runAction",_9f5,_9e7)};
var _9f7=["label","iconClass"];
_9f7.forEach(function(prop){
if(_9f5[prop]){
_9f6[prop]=_9f5[prop];
}
});
var _9f8=new _98e(_9f6);
_9f8._maqAction=_9f5;
menu.addChild(_9f8);
}
_9f1.dropDown=menu;
if(_9ea.type=="DropDownButton"){
_9f2=new _992(_9f1);
}else{
_9f2=new _993(_9f1);
}
_9f2.onClick=dojo.hitch(this,"_runAction",_9ea,_9e7);
_9f2._maqAction=_9ea;
_9f3.resolve();
}else{
if(_9ea.toggle||_9ea.radioGroup){
_9f2=new _994(_9f1);
_9f2.item=_9ea;
_9f2.set("checked",_9ea.initialValue);
if(_9ea.radioGroup){
var _9f9=_9ed[_9ea.radioGroup];
if(!_9f9){
_9f9=_9ed[_9ea.radioGroup]=[];
}
_9f9.push(_9f2);
_9f2.onChange=dojo.hitch(this,"_toggleButton",_9f2,_9e7,_9f9);
}else{
_9f2.onChange=dojo.hitch(this,"_runAction",_9ea,_9e7);
}
_9f2._maqAction=_9ea;
_9f3.resolve();
}else{
if(_9ea.type){
_986([_9ea.type],function(_9fa){
_9f2=new _9fa();
_9f2._maqActiond=_9ea;
_9f3.resolve();
});
}else{
_9f2=new _991(_9f1);
_9f2.onClick=dojo.hitch(this,"_runAction",_9ea,_9e7);
_9f2._maqAction=_9ea;
_9f3.resolve();
}
}
}
if(_9ea.icon){
var _9fb=document.createElement("img");
_9fb.src=_9ea.icon;
_9fb.height=_9fb.width=18;
_9f2.domNode.appendChild(_9fb);
}
_9f3.then(function(){
_9ec.addChild(_9f2);
if(_9ea.isEnabled&&!_9ea.isEnabled()){
_9f2.isEnabled=_9ea.isEnabled;
_9f2.set("disabled",true);
}else{
_9f2.set("disabled",false);
}
});
}
}
return _9ec;
},showPerspective:function(_9fc){
_9cf.activePerspective=_9fc;
var _9fd=_9cf._createMenuTree();
_9cf._updateMainMenubar(dojo.byId("davinci_main_menu"),_9fd);
var o=this.getActionSets("davinci.ui.editorMenuBar");
var _9fe=o.clonedActionSets;
if(_9fe.length){
_9fd=_9cf._createMenuTree(_9fe);
_9cf._updateMainMenubar(dojo.byId("maq_banner_editor_commands"),_9fd);
}
var _9ff=dojo.byId("mainBody");
if(!_9ff.tabs){
_9ff.tabs=[];
}
var _a00=dijit.byId("mainBody");
if(!_a00){
_a00=new _995({gutters:false,region:"center",design:"sidebar"},_9ff);
}
var _a01=_987.getExtension("davinci.perspective",_9fc);
if(!_a01){
_987.handleError(dojo.string.substitute(_99c.perspectiveNotFound,[_9fc]));
}
_a01=dojo.clone(_a01);
var _a02=_987.getExtensions("davinci.perspectiveExtension",function(_a03){
return _a03.targetID===_9fc;
});
dojo.forEach(_a02,function(_a04){
dojo.forEach(_a04.views,function(view){
_a01.views.push(view);
});
});
if(!_9ff.editorsStackContainer){
_9cf.editorsStackContainer=_9ff.editorsStackContainer=new _997({region:"center",id:"editorsStackContainer",controllerWidget:"dijit.layout.StackController"});
}
_a00.addChild(_9ff.editorsStackContainer);
if(!_9ff.editorsWelcomePage){
_9cf.editorsWelcomePage=_9ff.editorsWelcomePage=new _998({id:"editorsWelcomePage",href:"app/davinci/ve/resources/welcome_to_maqetta.html"});
}
_9ff.editorsStackContainer.addChild(_9ff.editorsWelcomePage);
if(!_9ff.tabs.editors){
_9cf.editorTabs=_9ff.tabs.editors=new (_9cf.hideEditorTabs?_997:_99a)({id:"editors_container",controllerWidget:(_9cf.hideEditorTabs?"dijit.layout.StackController":"dijit.layout.TabController")});
_9cf.editorTabs.setTitle=function(_a05,_a06){
_a05.attr("title",_a06);
_a05.domNode.title="";
if(!_9cf.hideEditorTabs){
this.tablist.pane2button[_a05.id].attr("label",_a06);
}else{
var _a07=_a05.id;
var _a08=_9ab(_a07);
var _a09=dijit.byId("davinci_file_tabs");
var _a0a=_a06+(_a05.isDirty?"<span class=\"dirtyFileAsterisk\"></span>":"");
_a09.tablist.pane2button[_a08].attr("label",_a0a);
}
};
dojo.connect(_9ff.tabs.editors,"removeChild",this,_9cf._editorTabClosed);
}
_9ff.editorsStackContainer.addChild(_9ff.tabs.editors);
_9ff.editorsStackContainer.selectChild(_9ff.editorsWelcomePage);
dojo.connect(dijit.byId("editors_container"),"selectChild",function(_a0b){
if(!_9cf._processingSelectChild){
_9cf._processingSelectChild=true;
var _a0c=_a0b.id;
var _a0d=_9ab(_a0c);
var _a0e=dijit.byId(_a0d);
var _a0f=dijit.byId("davinci_file_tabs");
if(_a0e&&_a0f){
_a0f.selectChild(_a0e);
}
if(_a0b.editor){
_9cf._switchEditor(_a0b.editor);
}
_9cf._processingSelectChild=false;
}
});
_a00.startup();
var _a10=dijit.byId("davinci_app");
if(!_a10){
_a10=new _995({design:"headline",gutters:false,liveSplitters:false},"davinci_app");
var _a11=new _998({region:"top",layoutPriority:1},"davinci_top_bar");
var _a12=_9cf.mainStackContainer=_9ff.editorsStackContainer=new _997({region:"center",id:"mainStackContainer",controllerWidget:"dijit.layout.StackController"});
var _a13=_9cf.mainBorderContainer=new _995({design:"headline",gutters:false,id:"mainBorderContainer",liveSplitters:false});
var _a14=_9cf.shadowTabs=new _99a({id:"davinci_file_tabs",closable:true,region:"top",layoutPriority:1,style:"display:none"});
_9cf.shadowTabs.setTitle=function(tab,_a15){
tab.attr("title",_a15);
this.tablist.pane2button[tab.id].attr("label",_a15);
};
dojo.connect(_a14,"selectChild",function(_a16){
var _a17=_a16.id;
var _a18=_9ad(_a17);
var _a19=dijit.byId(_a18);
var _a1a=dijit.byId("editors_container");
if(_a1a&&_a19&&_a19.editor){
_a1a.selectChild(_a19);
}
});
dojo.connect(_a14,"removeChild",this,_9cf._shadowTabClosed);
var _a1b=new _998({id:"davinci_toolbar_pane",region:"top",layoutPriority:1,content:"<div id=\"davinci_toolbar_container\"></div>",style:"display:none"});
_a10.addChild(_a11);
_a10.addChild(_a12);
_a12.addChild(_a13);
_a12.selectChild(_a13);
_a13.addChild(_a14);
_a13.addChild(_a1b);
_a13.addChild(_a00);
_a10.layout();
_a10.startup();
_9cf._originalOnResize=window.onresize;
window.onresize=_9cf.onResize;
dojo.connect(_a00,"onMouseUp",this,"onResize");
var _a1c=dijit.byId("davinci_file_tabs_tablist_Menu");
if(_a1c){
_a1c.addChild(new dijit.MenuItem({label:_9a2.closeAllEditors,onClick:this.closeAllEditors}));
}
}
for(var _a1d in _9ff.tabs.perspective){
var view=_9ff.tabs.perspective[_a1d];
if(!view){
continue;
}
dojo.forEach(view.getChildren(),function(_a1e){
view.removeChild(_a1e);
if(_a1d!="left"&&_a1d!="right"){
_a1e.destroyRecursive(false);
}
});
view.destroyRecursive(false);
delete _9ff.tabs.perspective[_a1d];
}
this._showViewPromises=dojo.map(_a01.views,function(view){
return _9cf.showView(view.viewID,view.selected,view.hidden);
},this);
davinci.Workbench.focusContainer=dojo.create("div",{"class":"focusContainer",id:"focusContainer"},document.body);
setTimeout(function(){
_a10.resize();
dojo.publish("/davinci/workbench/ready",[]);
}.bind(this),3000);
},onResize:function(e){
var _a1f=e.explicitOriginalTarget?e.explicitOriginalTarget:e.srcElement;
if(e.type=="resize"||((_a1f.id&&(_a1f.id.indexOf("dijit_layout__Splitter_")>-1)||(_a1f.nextSibling&&_a1f.nextSibling.id&&_a1f.nextSibling.id.indexOf("dijit_layout__Splitter_")>-1)))){
var ed=davinci&&_987.currentEditor;
if(ed&&ed.onResize){
ed.onResize();
}
}
if(_9cf._originalOnResize){
_9cf._originalOnResize();
}
_9cf._repositionFocusContainer();
},updateMenubar:function(node,_a20){
var _a21=_9cf._createMenuTree(_a20);
var _a22=dijit.byId(node.id);
if(!_a22){
_a22=new _98d({"class":"dijitInline"},node);
}
_9cf._addItemsToMenubar(_a21,_a22);
},_updateMainMenubar:function(_a23,_a24){
for(var i=0;i<_a24.length;i++){
var _a25=_a24[i];
for(var j=0;j<_a25.menus.length;j++){
var menu=_a25.menus[j];
var _a26=_9cf._createMenu(menu);
menu.id=menu.id.replace(".","-");
if(window.maqetta&&maqetta.TopBanner&&maqetta.TopBanner.attachMenu){
maqetta.TopBanner.attachMenu(menu,_a26,_a23);
}else{
var _a27=dijit.byId(menu.id+"-dropdown");
if(!_a27){
var _a28={label:menu.label,dropDown:_a26,id:menu.id+"-dropdown"};
if(menu.hasOwnProperty("showLabel")){
_a28.showLabel=menu.showLabel;
}
if(menu.hasOwnProperty("iconClass")){
_a28.iconClass=menu.iconClass;
}
if(menu.hasOwnProperty("className")){
_a28["class"]=menu.className;
}
_a27=new _992(_a28);
_a23.appendChild(_a27.domNode);
}
}
}
}
},_addItemsToMenubar:function(_a29,_a2a){
dojo.forEach(_a29,function(m){
var _a2b=m.menus,_a2c=_a2b.length;
if(_a2c){
dojo.forEach(_a2b,function(menu){
menu.id=menu.id.replace(/\./g,"-");
var _a2d=_9cf._createMenu(menu),_a2e=dijit.byId(menu.id+"-dropdown");
if(!_a2e){
_a2e=new _990({label:menu.label,popup:_a2d,id:menu.id+"-dropdown"});
}
_a2a.addChild(_a2e);
},this);
}
},this);
},getOpenEditor:function(_a2f){
if(_a2f!=null){
var tab=dijit.byId(_9a9(_a2f.getPath()));
if(tab){
return tab.editor;
}
return null;
}
var _a30=dijit.byId("editors_container");
if(_a30&&_a30.selectedChildWidget&&_a30.selectedChildWidget.editor){
return _a30.selectedChildWidget.editor;
}
return null;
},closeActiveEditor:function(){
var _a31=dijit.byId("editors_container");
var _a32=dijit.byId("davinci_file_tabs");
if(_a31&&_a31.selectedChildWidget&&_a31.selectedChildWidget.editor){
var _a33=selectedChildWidget.id;
var _a34=_9ab(_a33);
_a31.closeChild(_a31.selectedChildWidget);
var _a35=dijit.byId(_a34);
if(_a35){
_a32.closeChild(_a35);
}
}
},closeAllEditors:function(){
var _a36=dijit.byId("editors_container");
if(_a36){
_a36.getChildren().forEach(function(_a37){
_a36.closeChild(_a37);
});
}
},getAllOpenEditorIds:function(){
},showModal:function(_a38,_a39,_a3a,_a3b,_a3c,_a3d){
return _98a.showModal(_a38,_a39,_a3a,_a3b,_a3c,_a3d);
},showMessage:function(_a3e,_a3f,_a40,_a41,_a42){
return _98a.showMessage(_a3e,_a3f,_a40,_a41,_a42);
},showDialog:function(_a43){
return _98a.showDialog(_a43);
},_createMenuTree:function(_a44,_a45){
if(!_a44){
_a44=_987.getExtensions("davinci.actionSets",function(_a46){
var _a47=_987.getExtensions("davinci.actionSetPartAssociations",function(_a48){
return _a48.targetID==_a46.id;
});
return _a47.length==0;
});
}
var _a49=[];
function _a4a(m,id){
for(var j=0,jLen=m.length;j<jLen;j++){
for(var k=0,kLen=m[j].menus.length;k<kLen;k++){
if(id==m[j].menus[k].id){
return m[j].menus[k].menus;
}
}
}
};
function _a4b(item,path,_a4c){
path=path||"additions";
path=path.split("/");
var m=_a49;
_9cf._loadActionClass(item);
var sep=path[path.length-1];
if(path.length>1){
for(var i=0,len=path.length-1;i<len;i++){
var k=_a4a(m,path[i]);
if(k){
m=k;
}
}
}
for(var i=0,len=m.length;i<len;i++){
if(m[i].id==sep){
var _a4d=m[i].menus;
_a4d.push(item);
if(item.separator){
var _a4e=false;
_a4d=item.menus=[];
for(var j=0;j<item.separator.length;j+=2){
var id=item.separator[j];
_a4e=id=="additions";
_a4d.push({id:id,isSeparator:item.separator[j+1],menus:[]});
}
if(!_a4e){
_a4d.push({id:"additions",isSeparator:false,menus:[]});
}
}
return;
}
}
if(_a4c){
_a49.push({id:sep,isSeparator:false,menus:[item]});
}
};
for(var _a4f=0,len=_a44.length;_a4f<len;_a4f++){
var _a50=_a44[_a4f];
if(_a50.visible){
if(_a50.menu){
for(var _a51=0,_a52=_a50.menu.length;_a51<_a52;_a51++){
var menu=_a50.menu[_a51];
if(menu.__mainMenu){
for(var j=0;j<menu.separator.length;j+=2){
_a49.push({id:menu.separator[j],isSeparator:menu.separator[j+1],menus:[]});
}
}else{
_a4b(menu,menu.path,_a45);
if(menu.populate instanceof Function){
var _a53=menu.populate();
for(var item in _a53){
_a4b(_a53[item],_a53[item].menubarPath);
}
}
}
}
}
}
}
for(var _a4f=0,len=_a44.length;_a4f<len;_a4f++){
var _a50=_a44[_a4f];
if(_a50.visible){
for(var _a54=0,_a55=_a50.actions.length;_a54<_a55;_a54++){
var _a56=_a50.actions[_a54];
if(_a56.menubarPath){
_a4b(_a56,_a56.menubarPath,_a45);
}
}
}
}
return _a49;
},_loadActionClass:function(item){
if(typeof item.action=="string"){
_986([item.action],function(_a57){
item.action=new _a57();
item.action.item=item;
});
}
},_createMenu:function(menu,_a58){
var _a59,_a5a,_a5b;
if(menu.menus){
_a59=new Menu({parentMenu:menu});
_a5a=menu.menus;
_a5b="onOpen";
}else{
_a59=new _a5c({});
_a5a=menu;
_a5b="menuOpened";
}
_a59.domNode.style.display="none";
_a59.actionContext=_a58;
this._rebuildMenu(_a59,_a5a);
dojo.connect(_a59,_a5b,this,function(evt){
if(_a59._widgetCallback){
_a59._widgetCallback(evt);
}
this._rebuildMenu(_a59,_a5a).focus();
});
return _a59;
},singleProjectMode:function(){
return true;
},getProject:function(){
return _9cf.getActiveProject()||_9cf._DEFAULT_PROJECT;
},loadProject:function(_a5d){
_9cf.setActiveProject(_a5d);
return _9cf.updateWorkbenchState().then(function(){
location.href="cmd/configProject?configOnly=true&project="+encodeURIComponent(_a5d);
});
},location:function(){
return _987.location();
},_rebuildMenu:function(_a5e,_a5f){
dojo.forEach(_a5e.getChildren(),function(_a60){
_a5e.removeChild(_a60);
_a60.destroy();
});
_a5e.focusedChild=null;
var _a61,_a62;
_a5f.forEach(function(menu,i){
if(menu.menus.length){
if(menu.isSeparator&&i>0){
_a61=true;
}
menu.menus.forEach(function(item){
if(_a61&&_a62){
_a5e.addChild(new _98f({}));
_a61=false;
}
_a62=true;
var _a63=item.label;
if(item.action&&item.action.getName){
_a63=item.action.getName();
}
if(item.separator){
var _a64=_9cf._createMenu(item);
var _a65=new _98e({label:_a63,popup:_a64,id:_a64.id+"item"});
_a65.actionContext=_a5e.actionContext;
_a5e.addChild(_a65);
}else{
var _a66=true;
if(item.isEnabled){
var _a67=_987.getSelection(),_a68=_a67[0]&&_a67[0].resource;
_a66=_a68?item.isEnabled(_a68):false;
}
if(item.action){
if(item.action.shouldShow&&!item.action.shouldShow(_a5e.actionContext,{menu:_a5e})){
return;
}
_a66=item.action.isEnabled&&item.action.isEnabled(_a5e.actionContext);
}
var _a69={label:_a63,id:item.id,disabled:!_a66,onClick:dojo.hitch(this,"_runAction",item,_a5e.actionContext)};
if(item.iconClass){
_a69.iconClass=item.iconClass;
}
_a5e.addChild(new _98e(_a69));
}
},this);
}
},this);
return _a5e;
},_toggleButton:function(_a6a,_a6b,_a6c,arg){
if(!_a6a.checked){
return;
}
_a6c.forEach(function(item){
if(item!=_a6a){
item.set("checked",false);
}
});
_9cf._runAction(_a6a.item,_a6b,_a6a.item.id);
},_runAction:function(item,_a6d,arg){
if(_a6d&&_987.currentEditor){
_a6d=_987.currentEditor;
}
if(item.run){
item.run();
}else{
if(item.action){
if(dojo.isString(item.action)){
this._loadActionClass(item);
}
item.action.run(_a6d);
}else{
if(item.method&&_a6d&&_a6d[item.method] instanceof Function){
_a6d[item.method](arg);
}else{
if(item.commandID){
_987.executeCommand(item.commandID);
}
}
}
}
},showView:function(_a6e,_a6f,_a70){
var d=new _99e();
try{
var _a71=dijit.byId("mainBody"),view=_987.getExtension("davinci.view",_a6e),_a72=dojo.byId("mainBody"),_a73=_9cf.activePerspective,_a74=_987.getExtension("davinci.perspective",_a73),_a75="left",cp1;
dojo.some(_a74.views,function(view){
if(view.viewID==_a6e){
_a75=view.position;
return true;
}
});
_a72.tabs=_a72.tabs||{};
_a72.tabs.perspective=_a72.tabs.perspective||{};
if(_a75=="right"&&!_a72.tabs.perspective.right){
_a71.addChild(_a72.tabs.perspective.right=new _995({"class":"davinciPaletteContainer",style:"width: "+_9a6+"px;",id:"right_mainBody",minSize:_9a6,region:"right",gutters:false,splitter:true}));
_a72.tabs.perspective.right.startup();
_9a8.right_mainBody={expandToSize:340,initialExpandToSize:340};
}
if(_a75=="left"&&!_a72.tabs.perspective.left){
_a71.addChild(_a72.tabs.perspective.left=new _995({"class":"davinciPaletteContainer",style:"width: "+_9a6+"px;",id:"left_mainBody",minSize:_9a6,region:"left",gutters:false,splitter:true}));
_a72.tabs.perspective.left.startup();
_9a8["left_mainBody"]={expandToSize:318,initialExpandToSize:318};
}
if(_a75==="left"||_a75==="right"){
_a75+="-top";
}
var _a76=_a75;
if(!_a72.tabs.perspective[_a75]){
_a76=_a75.split("-");
var _a77=_a76[0],_a78=_a71,_a79="davinciPalette ",_a7a="";
if(_a76[1]&&(_a77=="left"||_a77=="right")){
_a78=_a72.tabs.perspective[_a77];
_a77=_a76[1];
if(_a76[1]=="top"){
_a77="center";
_a79+="davinciTopPalette";
}else{
_a7a="height:30%;";
_a79+="davinciBottomPalette";
}
}else{
if(_a77=="bottom"){
_a7a="height:80px;";
_a79+="davinciBottomPalette";
}
}
cp1=_a72.tabs.perspective[_a75]=new _99a({region:_a77,id:"palette-tabcontainer-"+_a75,tabPosition:_a76[0]+"-h",tabStrip:false,"class":_a79,style:_a7a,splitter:_a77!="center",controllerWidget:"dijit.layout.TabController"});
_a78.addChild(cp1);
dojo.connect(cp1,"selectChild",this,function(tab){
if(tab&&tab.domNode){
var tc=tab.getParent();
if(!this._showViewAddChildInProcess&&!tc._maqDontExpandCollapse){
if(tc._maqLastSelectedChild==tab){
this._expandCollapsePaletteContainer(tab);
}else{
this.expandPaletteContainer(tab.domNode);
}
}
tc._maqLastSelectedChild=tab;
}
}.bind(this));
}else{
cp1=_a72.tabs.perspective[_a75];
}
if(dojo.some(cp1.getChildren(),function(_a7b){
return _a7b.id==view.id;
})){
return;
}
this.instantiateView(view).then(function(tab){
this._showViewAddChildInProcess=true;
if(!_a70){
cp1.addChild(tab);
}
this._showViewAddChildInProcess=false;
var _a7c=tab.controlButton;
if(_a7c&&_a7c.domNode){
_a7c.domNode.title=view.title+" "+_9a2.palette;
}
if(_a6f){
cp1.selectChild(tab);
}
d.resolve(tab);
}.bind(this));
}
catch(ex){
console.error("Error loading view: "+view.id);
console.error(ex);
}
return d;
},instantiateView:function(view){
var d=new _99e(),tab=dijit.byId(view.id);
if(tab){
d.resolve(tab);
}else{
_986([view.viewClass],function(_a7d){
var _a7e={title:view.title,id:view.id,closable:false,view:view};
if(view.iconClass){
_a7e.iconClass=view.iconClass;
}
if(!_9cf.palettes){
_9cf.palettes={};
}
d.resolve((_9cf.palettes[view.viewClass]=new (_a7d||_988)(_a7e),_9cf.palettes[view.viewClass]));
});
}
return d;
},hideView:function(_a7f){
for(var _a80 in mainBody.tabs.perspective){
if(_a80=="left"||_a80=="right"){
_a80+="-top";
}
if(!mainBody.tabs.perspective[_a80]){
continue;
}
var _a81=mainBody.tabs.perspective[_a80].getChildren();
var _a82=false;
for(var i=0;i<_a81.length&&!_a82;i++){
if(_a81[i].id==_a7f){
mainBody.tabs.perspective[_a80].removeChild(_a81[i]);
_a81[i].destroyRecursive(false);
}
}
}
},toggleView:function(_a83){
var _a84=dojo.byId(_a83);
if(_a84){
_9cf.hideView(_a83);
}else{
_9cf.showView(_a83,true);
}
},openEditor:function(_a85,_a86){
try{
var _a87=_a85.fileName,_a88;
if(typeof _a87=="string"){
_a88=_a87.substr(_a87.lastIndexOf(".")+1);
}else{
_a88=_a87.getExtension();
_a87=_a87.getPath();
}
var _a89=dijit.byId(_9a9(_a87)),_a8a=dijit.byId("editors_container");
if(_a89){
_a8a.selectChild(_a89);
var _a8b=_a89.editor;
if(_a85.startOffset){
_a8b.select(_a85);
}
return;
}
var _a8c=_a85.editorCreateCallback;
var _a8d=_987.getExtensions("davinci.editor",function(_a8e){
if(typeof _a8e.extensions=="string"){
_a8e.extensions=_a8e.extensions.split(",");
}
return dojo.some(_a8e.extensions,function(e){
return e.toLowerCase()==_a88.toLowerCase();
});
});
var _a8f=_a8d[0];
if(_a8d.length>1){
dojo.some(_a8d,function(_a90){
_a8f=_a90;
return _a90.isDefault;
});
}
_9cf._createEditor(_a8f,_a87,_a85,_a86).then(function(_a91){
if(_a8c){
_a8c.call(window,_a91);
}
if(!_a85.noSelect){
_987.currentEditor=_a91;
}
},function(_a92){
console.error("Error opening editor for filename: "+_a87,_a92);
});
}
catch(ex){
console.error("Exception opening editor for filename: "+_a85&&_a85.fileName);
console.error(ex);
}
},_createEditor:function(_a93,_a94,_a95,_a96){
var d=new _99e();
var _a97=_a94.split("/").pop();
var _a98=_a95&&_a95.fileName&&_a95.fileName.extension?"."+_a95.fileName.extension:"";
_a97+=(_a98==".rev"?_a98:"");
dojo.query(".loading").orphan();
var _a99=dijit.byId("editorsStackContainer"),_a9a=dijit.byId("editors_container");
if(_a99&&_a9a){
_a99.selectChild(_a9a);
_9cf.mainStackContainer.selectChild(_9cf.mainBorderContainer);
}
var _a9b=dijit.byId(_9a9(_a94)),_a9c=dijit.byId("editors_container"),_a9d=dijit.byId("davinci_file_tabs"),_a9e=false,_a9f=null;
if(!_a9b){
_a9e=true;
var _aa0=_9a9(_a94);
var _aa1=_9ab(_aa0);
_a9b=new _989({title:_a97,id:_aa0,"class":"EditorContainer",isDirty:_a95.isDirty});
_a9f=new _998({title:_a97,closable:true,id:_aa1});
_a9f.onClose=function(tc,tab){
var _aa2=tab.id;
var _aa3=_9ad(_aa2);
var _aa4=dijit.byId(_aa3);
var _aa5=dijit.byId("editors_container");
function _aa6(){
_aa4._skipDirtyCheck=true;
_aa4.onClose.apply(_aa4,[_aa5,_aa4]);
tc.removeChild(tab);
tab.destroyRecursive();
};
function _aa7(){
_aa4.editor.save();
_aa6();
};
if(_aa5&&_aa4){
if(_aa4.editor.isDirty){
var _aa8=_aa4.editor.getOnUnloadWarningMessage();
if(!_aa8){
_aa8=dojo.string.substitute(_99c.fileHasUnsavedChanges,[_aa4._getTitle()]);
}
_9cf.showDialog({title:_aa4._getTitle(),content:_aa8,style:{width:300},okLabel:_9a4.save,okCallback:dojo.hitch(this,_aa7),hideLabel:null,submitOnEnter:true,extendLabels:[_9a4.discard],extendCallbacks:[dojo.hitch(this,_aa6)]});
}else{
_aa6();
}
}
};
}
if(!_a93){
_a93={editorClass:"davinci/ui/TextEditor",id:"davinci.ui.TextEditor"};
}
if(_a9e){
_a9c.addChild(_a9b);
_a9d.addChild(_a9f);
}
if(!_9cf.hideEditorTabs){
var _aa9=dojo.query(".dijitTabButtonIcon",_a9b.controlButton.domNode);
dojo.addClass(_aa9[0],"tabButtonLoadingIcon");
dojo.removeClass(_aa9[0],"dijitNoIcon");
}
if(!_a95.noSelect){
_a9c.selectChild(_a9b);
}
if(!_a95.initializationTime){
_9cf._state.activeEditor=_a94;
}
_a9b.setEditor(_a93,_a94,true,_a95.fileName,_a9b.domNode,_a96).then(function(_aaa){
if(_a95.startLine){
_a9b.editor.select(_a95);
}
if(!_a95.noSelect){
if(_9cf._state.editors.indexOf(_a94)===-1){
_9cf._state.editors.push(_a94);
}
_9cf._switchEditor(_a9b.editor,_a95.startup);
}
if(!_9cf.hideEditorTabs){
dojo.removeClass(_aa9[0],"tabButtonLoadingIcon");
dojo.addClass(_aa9[0],"dijitNoIcon");
}
setTimeout(function(){
_a9b.resize();
},100);
d.resolve(_a9b.editor);
},function(_aab){
if(!_9cf.hideEditorTabs){
dojo.removeClass(_aa9[0],"tabButtonLoadingIcon");
dojo.addClass(_aa9[0],"tabButtonErrorIcon");
}
d.reject(_aab);
});
return d;
},createPopup:function(args){
var _aac=args.partID,_aad=args.domNode,_aae=args.context,_aaf=args.openCallback;
var o=this.getActionSets(_aac);
var _ab0=o.clonedActionSets;
var _ab1=o.actionSets;
if(_ab0.length>0){
var _ab2=_9cf._createMenuTree(_ab0,true);
_9cf._initActionsKeys(_ab1,args);
var _ab3=_9cf._createMenu(_ab2,_aae);
if(_ab3&&_aad){
_ab3.bindDomNode(_aad);
}
_ab3._widgetCallback=_aaf;
_ab3._partID=_aac;
return _ab3;
}
},getActionSets:function(_ab4){
var _ab5=[];
_987.getExtension("davinci.actionSetPartAssociations",function(_ab6){
return _ab6.parts.some(function(part){
if(part==_ab4){
_ab5.push(_ab6.targetID);
return true;
}
});
});
var _ab7;
var _ab8=[];
if(_ab5.length){
_ab7=_987.getExtensions("davinci.actionSets",function(_ab9){
return _ab5.some(function(_aba){
return _aba==_ab9.id;
});
});
if(_ab7.length){
_ab7.forEach(function(_abb){
var _abc=_99d.getLibraryActions(_abb.id);
if(_abc.length){
_abb=lang.mixin({},_abb);
_abb.actions=_abb.actions.concat(_abc);
}
_ab8.push(_abb);
});
}
}
return {actionSets:_ab7,clonedActionSets:_ab8};
},_initActionsKeys:function(_abd,args){
var _abe=args.keysDomNode||args.domNode,keys={},_abf;
dojo.forEach(_abd,function(_ac0){
dojo.forEach(_ac0.actions,function(_ac1){
if(_ac1.keySequence){
keys[_ac1.keySequence]=_ac1;
_abf=true;
}
});
});
if(_abf){
var _ac2=args.context;
dojo.connect(_abe,"onkeydown",function(e){
var seq=_9cf._keySequence(e),_ac3=keys[seq];
if(_ac3){
if(_ac3.action.shouldShow&&!_ac3.action.shouldShow(_ac2)){
return;
}
if(_ac3.action.isEnabled(_ac2)){
_9cf._runAction(_ac3,_ac2);
}
}
});
}
},_initKeys:function(){
var keys={all:[]};
var _ac4=_987.getExtensions("davinci.keyBindings");
dojo.forEach(_ac4,function(_ac5){
var _ac6=_ac5.contextID||"all";
var _ac7=keys[_ac6];
if(!_ac7){
_ac7=keys[_ac6]=[];
}
_ac7[_ac5.sequence]=_ac5.commandID;
});
_9cf.keyBindings=keys;
},handleKey:function(e){
if(!_9cf.keyBindings){
return;
}
var seq=_9cf._keySequence(e);
var cmd;
if(_9cf.currentContext&&_9cf.keyBindings[_9cf.currentContext]){
cmd=_9cf.keyBindings[_9cf.currentContext][seq];
}
if(!cmd){
cmd=_9cf.keyBindings.all[seq];
}
if(cmd){
_987.executeCommand(cmd);
return true;
}
},_keySequence:function(e){
var seq=[];
if(window.event){
if(window.event.ctrlKey){
seq.push("M1");
}
if(window.event.shiftKey){
seq.push("M2");
}
if(window.event.altKey){
seq.push("M3");
}
}else{
if(e.ctrlKey||(e.modifiers==2)||(e.modifiers==3)||(e.modifiers>5)){
seq.push("M1");
}
if(e.shiftKey||(e.modifiers>3)){
seq.push("M2");
}
if(e.modifiers){
if(e.altKey||(e.modifiers%2)){
seq.push("M3");
}
}else{
if(e.altKey){
seq.push("M3");
}
}
}
var _ac8=String.fromCharCode(e.keyCode);
if(/[A-Z0-9]/.test(_ac8)){
}else{
var _ac9={46:"del",114:"f3"};
_ac8=_ac9[e.keyCode]||"xxxxxxxxxx";
}
_ac8=_ac8.toUpperCase();
if(_ac8==" "){
_ac8="' '";
}
seq.push(_ac8);
return seq.join("+");
},setActionScope:function(_aca,_acb){
_9cf.actionScope[_aca]=_acb;
},findView:function(_acc){
var _acd=dijit.byId(_acc);
if(_acd){
return _acd;
}
},_switchEditor:function(_ace,_acf){
var _ad0=_987.currentEditor;
_987.currentEditor=_ace;
_9cf._state.activeEditor=_ace?_ace.fileName:null;
this._removeFocusContainerChildren();
this._showEditorTopPanes();
try{
dojo.publish("/davinci/ui/editorSelected",[{editor:_ace,oldEditor:_ad0}]);
}
catch(ex){
console.error(ex);
}
_9cf._updateTitle(_ace);
setTimeout(function(){
if(_ace&&_ace.visualEditor&&_ace.visualEditor.context&&_ace.visualEditor.context.isActive()){
_ace.visualEditor.context.getTopWidgets().forEach(function(_ad1){
if(_ad1.resize){
_ad1.resize();
}
});
}
this._repositionFocusContainer();
}.bind(this),1000);
all(this._showViewPromises).then(function(){
if(_ace&&_ace.focus){
_ace.focus();
}
this._rearrangePalettes(_ace);
this._expandCollapsePaletteContainers(_ace);
}.bind(this));
if(!_acf){
_9cf.saveState=true;
}
},_rearrangePalettes:function(_ad2){
var _ad3,_ad4,_ad5;
if(_ad2){
var _ad6=_987.getExtensions("davinci.editor",function(_ad7){
return _ad2?(_ad7.id===_ad2.editorID):false;
});
if(_ad6&&_ad6.length>0){
var _ad8=_ad6[0];
_ad3=_ad8.palettePerspective;
}
_ad4=_ad2._rightPaletteExpanded;
_ad5=_ad2._leftPaletteExpanded;
}else{
_ad3=_987.initialPerspective||"davinci.ui.main";
}
if(_ad3){
var _ad9=_987.getExtension("davinci.perspective",_ad3);
if(!_ad9){
_987.handleError(dojo.string.substitute(_99c.perspectiveNotFound,[_ad8.palettePerspective]));
}
var _ada=_ad9.views;
dojo.forEach(_ada,function(_adb){
var _adc=_adb.viewID;
var _add=_adb.position;
if(_add.indexOf("bottom")<0){
_add+="-top";
}
var tab=dijit.byId(_adc);
if(tab){
var _ade=tab.getParent();
var _adf=mainBody.tabs.perspective[_add];
if(_ade!=_adf){
if(_ade){
_ade.removeChild(tab);
}
if(!_adb.hidden){
_adf.addChild(tab);
_ade=_adf;
}
}
if(_ade){
if(_adb.hidden){
_ade.removeChild(tab);
}else{
if(_adb.selected){
_ade._maqDontExpandCollapse=true;
_ade.selectChild(tab);
delete _ade._maqDontExpandCollapse;
}
}
}
}
});
}
if(_ad2){
if(_ad2.hasOwnProperty("_rightPaletteExpanded")){
_ad2._rightPaletteExpanded=_ad4;
}
if(_ad2.hasOwnProperty("_leftPaletteExpanded")){
_ad2._leftPaletteExpanded=_ad5;
}
}
},_nearlyCollapsed:function(_ae0){
var _ae1=dojo.style(_ae0,"width");
if(typeof _ae1=="string"){
_ae1=parseInt(_ae1);
}
return _ae1<(_9a6+_9a7);
},_expandCollapsePaletteContainer:function(tab){
if(!tab||!tab.domNode){
return;
}
var _ae2=davinci.Workbench.findPaletteContainerNode(tab.domNode);
if(!_ae2.id){
return;
}
var _ae3=_ae2._maqExpanded;
var _ae4;
if(this._nearlyCollapsed(_ae2)){
_ae3=false;
_ae4=(_9a8[_ae2.id].expandToSize>=(_9a6+_9a7))?_9a8[_ae2.id].expandToSize:_9a8[_ae2.id].initialExpandToSize;
}
if(_ae3){
this.collapsePaletteContainer(_ae2);
}else{
this.expandPaletteContainer(_ae2,{expandToSize:_ae4});
}
},_expandCollapsePaletteContainers:function(_ae5,_ae6){
var _ae7=dijit.byId("left_mainBody");
var _ae8=dijit.byId("right_mainBody");
if(!_ae5){
if(_ae7){
this.collapsePaletteContainer(_ae7.domNode,_ae6);
}
if(_ae8){
this.collapsePaletteContainer(_ae8.domNode,_ae6);
}
}else{
var _ae9=_987.getExtensions("davinci.editor",function(_aea){
return _aea.id===_ae5.editorID;
});
if(_ae9&&_ae9.length>0){
var _aeb=_ae9[0].expandPalettes;
var _aec;
if(_ae7){
if(_ae5&&_ae5.hasOwnProperty("_leftPaletteExpanded")){
_aec=_ae5._leftPaletteExpanded;
}else{
_aec=(_aeb&&_aeb.indexOf("left")>=0);
}
if(_aec){
this.expandPaletteContainer(_ae7.domNode,_ae6);
}else{
this.collapsePaletteContainer(_ae7.domNode,_ae6);
}
}
if(_ae8){
if(_ae5&&_ae5.hasOwnProperty("_rightPaletteExpanded")){
_aec=_ae5._rightPaletteExpanded;
}else{
_aec=(_aeb&&_aeb.indexOf("right")>=0);
}
if(_aec){
this.expandPaletteContainer(_ae8.domNode,_ae6);
}else{
this.collapsePaletteContainer(_ae8.domNode,_ae6);
}
}
}
}
},_updateTitle:function(_aed){
var _aee=_9cf._baseTitle;
if(_aed){
_aee=_aee+" - ";
if(_aed.isDirty){
_aee=_aee+"*";
}
_aee=_aee+_aed.fileName;
}
dojo.doc.title=_aee;
},_editorTabClosed:function(page){
if(!davinci.Workbench._editorTabClosing[page.id]){
davinci.Workbench._editorTabClosing[page.id]=true;
if(page&&page.editor&&page.editor.fileName){
var _aef=page.id;
var _af0=_9ab(_aef);
var _af1=dijit.byId("davinci_file_tabs");
var _af2=dijit.byId(_af0);
var i=_9cf._state.editors.indexOf(page.editor.fileName);
if(i!=-1){
_9cf._state.editors.splice(i,1);
}
_9cf.saveState=true;
if(!davinci.Workbench._shadowTabClosing[_af0]){
_af1.removeChild(_af2);
_af2.destroyRecursive();
}
}
var _af3=dijit.byId("editors_container").getChildren();
if(!_af3.length){
_9cf._switchEditor(null);
this._expandCollapsePaletteContainers(null);
var _af4=dijit.byId("editorsStackContainer");
var _af5=dijit.byId("editorsWelcomePage");
if(_af4&&_af5){
_af4.selectChild(_af5);
}
this._hideEditorTopPanes();
}
delete davinci.Workbench._editorTabClosing[page.id];
}
},_shadowTabClosed:function(page){
if(!davinci.Workbench._shadowTabClosing[page.id]){
davinci.Workbench._shadowTabClosing[page.id]=true;
var _af6=page.id;
var _af7=_9ad(_af6);
if(!davinci.Workbench._editorTabClosing[_af7]){
var _af8=dijit.byId(_af7);
var _af9=dijit.byId("editors_container");
if(_af9&&_af8){
_af9.removeChild(_af8);
_af8.destroyRecursive();
}
}
delete davinci.Workbench._shadowTabClosing[page.id];
}
},getActiveProject:function(){
if(!_9cf._state){
_9cf._state=_987.getWorkbenchState();
}
var _afa=dojo.queryToObject(dojo.doc.location.search.substr((dojo.doc.location.search[0]==="?"?1:0))).project;
if(_afa){
_9cf.loadProject(_afa);
}
if(_9cf._state.hasOwnProperty("project")){
return _9cf._state.project;
}
return _9cf._DEFAULT_PROJECT;
},setActiveProject:function(_afb){
if(!_9cf._state){
_9cf._state={};
}
_9cf._state.project=_afb;
_9cf.saveState=true;
},workbenchStateCustomPropGet:function(_afc){
if(typeof _afc=="string"){
return _9cf._state[_afc];
}
},workbenchStateCustomPropSet:function(_afd,_afe){
if(typeof _afd=="string"){
if(typeof _afe=="undefined"){
delete _9cf._state[_afd];
}else{
_9cf._state[_afd]=_afe;
}
_9cf.saveState=true;
}
},clearWorkbenchState:function(){
_9cf._state={};
return _9cf.updateWorkbenchState();
},updateWorkbenchState:function(){
delete _9cf.saveState;
return xhr.put({url:"cmd/setWorkbenchState",putData:JSON.stringify(_9cf._state),handleAs:"text"});
},_autoSave:function(){
var _aff=_9cf._lastAutoSave;
var _b00=false;
function _b01(_b02){
if(_b02.isReadOnly||!_b02.isDirty){
return;
}
var _b03=_b02.lastModifiedTime;
if(_b03&&_b03>_aff){
try{
_b02.save(true);
}
catch(ex){
console.error("Error while autosaving file:"+ex);
_b00=true;
}
}
};
if(_9cf.editorTabs){
dojo.forEach(_9cf.editorTabs.getChildren(),_b01);
}
if(!_b00){
_9cf._lastAutoSave=Date.now();
}
},setupGlobalKeyboardHandler:function(){
var _b04=_987.getExtensions("davinci.actionSets");
dojo.forEach(_b04,function(_b05){
if(_b05.id=="davinci.ui.main"||_b05.id=="davinci.ui.editorActions"){
dojo.forEach(_b05.actions,function(_b06){
if(_b06.keyBinding){
_987.registerKeyBinding(_b06.keyBinding,_b06);
}
});
}
});
},findPaletteContainerNode:function(node){
var _b07;
var n=node;
while(n&&n.tagName!="BODY"){
if(dojo.hasClass(n,"davinciPaletteContainer")){
_b07=n;
break;
}
n=n.parentNode;
}
return _b07;
},collapsePaletteContainer:function(node,_b08){
var _b09=davinci.Workbench.findPaletteContainerNode(node);
if(_b09&&_b09.id){
var id=_b09.id;
var _b0a=dojo.style(_b09,"width");
var _b0b=dijit.byNode(_b09);
var _b0c=dojo.query("[role=tablist]",_b09);
if(_b0b&&_b0c.length>0){
var _b0d=_b0c[0];
var _b0e=dojo.marginBox(_b0d);
var _b0f=_b0b.getParent();
if(_b0f&&_b0f.resize&&_b0e&&_b0e.w){
if(!this._nearlyCollapsed(_b09)&&(!_b08||!_b08.dontPreserveWidth)){
_9a8[id].expandToSize=_b0a;
}
_b09.style.width=_b0e.w+"px";
_b0f.resize();
_b0b._isCollapsed=true;
}
}
dojo.removeClass(_b09,"maqPaletteExpanded");
_b09._maqExpanded=false;
davinci.Workbench._repositionFocusContainer();
var _b10=_987.currentEditor;
if(_b10){
if(_b09.id=="left_mainBody"){
_b10._leftPaletteExpanded=false;
}else{
if(_b09.id=="right_mainBody"){
_b10._rightPaletteExpanded=false;
}
}
}
}
},expandPaletteContainer:function(node,_b11){
var _b12=_b11&&_b11.expandToSize;
var _b13=davinci.Workbench.findPaletteContainerNode(node);
if(_b13&&_b13.id){
var id=_b13.id;
var _b14=dijit.byNode(_b13);
if(_b12){
_9a8[id].expandToSize=_b12;
}
if(_b14&&_9a8[id].expandToSize){
var _b15=_b14.getParent();
if(_b15&&_b15.resize){
_b13.style.width=_9a8[id].expandToSize+"px";
_b15.resize();
delete _b14._isCollapsed;
}
}
dojo.addClass(_b13,"maqPaletteExpanded");
_b13._maqExpanded=true;
davinci.Workbench._repositionFocusContainer();
var _b16=_987.currentEditor;
if(_b16){
if(_b13.id=="left_mainBody"){
_b16._leftPaletteExpanded=true;
}else{
if(_b13.id=="right_mainBody"){
_b16._rightPaletteExpanded=true;
}
}
}
}
},_repositionFocusContainer:function(){
var _b17=dojo.byId("editors_container");
var _b18=dojo.byId("focusContainer");
if(_b17&&_b18){
var _b19=_987.currentEditor;
var box;
if(_b19&&_b19.getFocusContainerBounds){
box=_b19.getFocusContainerBounds();
}else{
box=_9a3.getBorderBoxPageCoords(_b17);
}
if(box){
_b18.style.left=box.l+"px";
_b18.style.top=box.t+"px";
_b18.style.width=box.w+"px";
_b18.style.height=box.h+"px";
if(_b19&&_b19.getContext){
var _b1a=_b19.getContext();
if(_b1a&&_b1a.updateFocusAll){
_b1a.updateFocusAll();
}
}
}
}
},_hideShowEditorTopPanes:function(_b1b){
var _b1c=dijit.byId("davinci_app");
var _b1d=dijit.byId("davinci_file_tabs");
var _b1e=dijit.byId("davinci_toolbar_pane");
_b1d.domNode.style.display=_b1b;
_b1e.domNode.style.display=_b1b;
_b1c.resize();
},_hideEditorTopPanes:function(){
this._hideShowEditorTopPanes("none");
},_showEditorTopPanes:function(){
this._hideShowEditorTopPanes("block");
},_removeFocusContainerChildren:function(){
davinci.Workbench.focusContainer.innerHTML="";
},_XX_last_member:true};
var _a5c=_99f(Menu,{menuOpened:function(_b1f){
},_openMyself:function(_b20){
this.menuOpened(_b20);
var open;
try{
var _b21=document.getElementById("menuOverlayDiv");
if(!_b21){
_b21=dojo.create("div",{id:"menuOverlayDiv",style:"left:0px; top:0px; width:100%; height:100%; position:absolute; z-index:10;"},document.body);
}
if(this.adjustPosition){
var _b22=this.adjustPosition(_b20);
open=dijit.popup.open;
dijit.popup.open=function(args){
args.x+=_b22.x;
args.y+=_b22.y;
open.call(dijit.popup,args);
};
}
this.onClose=function(){
var _b23=document.getElementById("menuOverlayDiv");
if(_b23){
_b23.parentNode.removeChild(_b23);
}
}.bind(this);
this.inherited(arguments);
}
finally{
if(open){
dijit.popup.open=open;
}
}
}});
window.setInterval(function(){
if(_9cf.saveState){
_9cf.updateWorkbenchState();
}
},1000);
dojo.setObject("davinci.Workbench",_9cf);
return _9cf;
});
},"dijit/form/_SearchMixin":function(){
define("dijit/form/_SearchMixin",["dojo/data/util/filter","dojo/_base/declare","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/query","dojo/sniff","dojo/string","dojo/when","../registry"],function(_b24,_b25,_b26,keys,lang,_b27,has,_b28,when,_b29){
return _b25("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_abortQuery:function(){
if(this.searchTimer){
this.searchTimer=this.searchTimer.remove();
}
if(this._queryDeferHandle){
this._queryDeferHandle=this._queryDeferHandle.remove();
}
if(this._fetchHandle){
if(this._fetchHandle.abort){
this._cancelingQuery=true;
this._fetchHandle.abort();
this._cancelingQuery=false;
}
if(this._fetchHandle.cancel){
this._cancelingQuery=true;
this._fetchHandle.cancel();
this._cancelingQuery=false;
}
this._fetchHandle=null;
}
},_processInput:function(evt){
if(this.disabled||this.readOnly){
return;
}
var key=evt.charOrCode;
if(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT){
return;
}
var _b2a=false;
this._prev_key_backspace=false;
switch(key){
case keys.DELETE:
case keys.BACKSPACE:
this._prev_key_backspace=true;
this._maskValidSubsetError=true;
_b2a=true;
break;
default:
_b2a=typeof key=="string"||key==229;
}
if(_b2a){
if(!this.store){
this.onSearch();
}else{
this.searchTimer=this.defer("_startSearchFromInput",1);
}
}
},onSearch:function(){
},_startSearchFromInput:function(){
this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g,"\\$1"));
},_startSearch:function(text){
this._abortQuery();
var _b2b=this,_b27=lang.clone(this.query),_b2c={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_b28.substitute(this.queryExpr,[text]),q,_b2d=function(){
var _b2e=_b2b._fetchHandle=_b2b.store.query(_b27,_b2c);
if(_b2b.disabled||_b2b.readOnly||(q!==_b2b._lastQuery)){
return;
}
when(_b2e,function(res){
_b2b._fetchHandle=null;
if(!_b2b.disabled&&!_b2b.readOnly&&(q===_b2b._lastQuery)){
when(_b2e.total,function(_b2f){
res.total=_b2f;
var _b30=_b2b.pageSize;
if(isNaN(_b30)||_b30>res.total){
_b30=res.total;
}
res.nextPage=function(_b31){
_b2c.direction=_b31=_b31!==false;
_b2c.count=_b30;
if(_b31){
_b2c.start+=res.length;
if(_b2c.start>=res.total){
_b2c.count=0;
}
}else{
_b2c.start-=_b30;
if(_b2c.start<0){
_b2c.count=Math.max(_b30+_b2c.start,0);
_b2c.start=0;
}
}
if(_b2c.count<=0){
res.length=0;
_b2b.onSearch(res,_b27,_b2c);
}else{
_b2d();
}
};
_b2b.onSearch(res,_b27,_b2c);
});
}
},function(err){
_b2b._fetchHandle=null;
if(!_b2b._cancelingQuery){
console.error(_b2b.declaredClass+" "+err.toString());
}
});
};
lang.mixin(_b2c,this.fetchProperties);
if(this.store._oldAPI){
q=qs;
}else{
q=_b24.patternToRegExp(qs,this.ignoreCase);
q.toString=function(){
return qs;
};
}
this._lastQuery=_b27[this.searchAttr]=q;
this._queryDeferHandle=this.defer(_b2d,this.searchDelay);
},constructor:function(){
this.query={};
this.fetchProperties={};
},postMixInProperties:function(){
if(!this.store){
var list=this.list;
if(list){
this.store=_b29.byId(list);
}
}
this.inherited(arguments);
}});
});
},"url:davinci/ui/widgets/templates/NewFile.html":"<div class=\"fileDialog\" dojoAttachPoint=\"_fileDialog\">\n\t<div class=\"dijitDialogPaneContentArea\">\n\t  <div dojoAttachPoint=\"additionalMessage\" class=\"maqDialogMessage\" style=\"display: none\">\n\t  </div>\n\n\t\t<table class=\"fileFolderTable\">\n\t\t\t<tr class='fileNameRow'>\n\t\t\t\t<td class=\"fileDialogLabelCell\">\n\t\t\t\t\t<label>${fileFieldLabel}:</label>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<input dojoType=\"dijit.form.TextBox\" type=\"text\" dojoAttachPoint=\"fileDialogFileName\"></input>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr class='folderNameRow'>\n\t\t\t\t<td class=\"fileDialogLabelCell\">\n\t\t\t\t\t<label>${folderFieldLabel}</label>\n\t\t\t\t</td>\n\t\t\t\t<td dojoAttachPoint=\"fileDialogWhereDropDownCell\">\n\t\t\t\t\t<!-- DropDownButton goes here -->\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span dojoAttachPoint=\"fileDialogDetailsArrow\">\n\t\t\t\t\t\t<span class='folder_details_arrow folder_details_show_arrow'>&nbsp;</span>\n\t\t\t\t\t\t<span class='folder_details_arrow folder_details_hide_arrow'>&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<div class=\"folderContainer\">\n\t\t\t<div dojoType=\"dijit.layout.ContentPane\">\n\t\t\t\t<div class=\"fileDialogTreeWidget\" dojoAttachPoint=\"fileTree\" dojoType=\"dijit.Tree\" showRoot=\"false\" model=\"system.resource\" getIconClass=\"davinci.ui.Resource.getResourceIcon\"\n\t\t\t\t\tgetRowClass=\"davinci.ui.Resource.getResourceClass\" labelAttr=\"name\" childrenAttrs=\"children\" persist=\"false\"></div>\n\t\t\t</div>\n\t\t\t<div class='folderContainerButtonRow'><button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"__newFolderButton\" dojoAttachEvent=\"onClick:_newFolder\">${newFolderLabel}</button></div>\n\t\t</div>\n\t\t\n\t\t<div dojoAttachPoint=\"dialogSpecificOptionsDiv\"></div>\n\t</div>\n\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<span dojoAttachPoint=\"dialogSpecificButtonsSpan\" class=\"dialogSecondaryButtons\"></span>\n\t\t<span class=\"fileDialogStdButtons\">\n\t\t\t<button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"__okButton\" class=\"maqPrimaryButton\" type=\"submit\">${finishButtonLabel}</button>\n\t\t\t<button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"__cancelButton\" dojoAttachEvent=\"onClick:cancelButton\" class=\"maqSecondaryButton\">${cancelButtonLabel}</button>\n\t\t</span>\n\t</div>\n\t\n</div>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n","davinci/ve/actions/MoveBackwardAction":function(){
define("davinci/ve/actions/MoveBackwardAction",["dojo/_base/declare","./_ReorderAction","davinci/commands/CompoundCommand","davinci/ve/commands/ReparentCommand"],function(_b32,_b33,_b34,_b35){
return _b32("davinci.ve.actions.MoveBackwardAction",[_b33],{name:"MoveBackward",iconClass:"editActionIcon editMoveBackwardIcon",run:function(_b36){
_b36=this.fixupContext(_b36);
if(!_b36){
return;
}
var _b37=(_b36&&_b36.getSelection)?_b36.getSelection():[];
if(_b37.length===0){
return;
}
if(!this.selectionSameParentAllAbsoluteAdjacent(_b37)){
return;
}
var _b38;
var _b39=_b37[0].getParent();
var _b3a=_b39.getChildren();
var _b3b=this.getAbsoluteSiblings(_b37[0]);
var _b3c=new _b34();
var _b3d=_b37.slice(0);
for(var j=_b3b.length-1;j>=0;j--){
_b38=_b3b[j];
var _b3e=_b3d.indexOf(_b38);
if(_b3e>=0){
_b3d.splice(_b3e,1);
}else{
if(_b3d.length===0){
break;
}
}
}
var _b3f=_b3a.indexOf(_b38);
for(var i=_b3b.length-1;i>=0;i--){
_b38=_b3b[i];
if(_b37.indexOf(_b38)>=0){
_b3c.add(new _b35(_b38,_b39,_b3f));
}
}
_b36.getCommandStack().execute(_b3c);
},isEnabled:function(_b40){
_b40=this.fixupContext(_b40);
var _b41=(_b40&&_b40.getSelection)?_b40.getSelection():[];
if(_b41.length===0){
return false;
}
if(!this.selectionSameParentAllAbsoluteAdjacent(_b41)){
return false;
}
var _b42=this.getAbsoluteSiblings(_b41[0]);
for(var j=0;j<_b41.length;j++){
var _b43=_b41[j];
if(_b42.indexOf(_b43)>(_b41.length-1)){
return true;
}
}
return false;
}});
});
},"davinci/ve/palette/PaletteFolder":function(){
define("davinci/ve/palette/PaletteFolder",["dojo/_base/declare","dijit/_WidgetBase","dojo/dom-class","dojo/fx","davinci/Runtime","davinci/ve/metadata"],function(_b44,_b45,_b46,fx,_b47,_b48){
return _b44("davinci.ve.palette.PaletteFolder",_b45,{icon:"",displayName:"",paletteId:"",palette:null,preset:null,presetId:null,presetClassName:null,_type:"",_isOpen:false,_openSubsection:null,buildRendering:function(){
this.palette=dijit.byId(this.paletteId);
var div=this.domNode=this.palette.folderTemplate.cloneNode(true);
if(this.presetClassName){
_b46.add(div,this.presetClassName);
}
var _b49="PaletteFolder__"+this.presetId+"__"+this.section.id;
if(this.subsection){
_b49+="__"+this.subsection.id;
}
dojo.attr(div,"selType",_b49);
var a=div.firstChild;
dojo.attr(a,"tabIndex","0");
a.onclick=this.palette.nop;
var img=a.firstChild;
img.src=this.iconBase64?this.iconBase64:this.icon;
a.appendChild(dojo.doc.createTextNode(this.displayName));
div._paletteFolder=this;
this._type=(this.subsections?"subsection_container":(this.subsection?"subsection":"simple"));
if(this._type=="subsection"){
_b46.add(div,"PaletteFolderSubsection");
}
this._children=[];
},postCreate:function(){
this.connect(this.domNode,"onmouseover","folderMouseOverHandler");
this.connect(this.domNode,"onmouseout","folderMouseOutHandler");
this.connect(this.domNode,"onclick","folderClickHandler");
},startup:function(){
},isFocusable:function(){
return true;
},focus:function(){
dijit.focus(this.domNode);
},addChild:function(node){
var _b4a=this.palette.getChildren();
for(var i=0,len=_b4a.length;i<len;i++){
var _b4b=_b4a[i];
if(_b4b!=this){
continue;
}
this.palette.addChild(node,i+1);
return true;
}
return false;
},_paletteItemGroupInfo:function(_b4c,_b4d){
var obj={};
var idx=_b4d;
var _b4e=_b4c[idx];
var _b4f=_b4e._paletteItemGroup;
do{
if(_b4e._paletteGroupSelected){
obj.selectedIndex=idx;
}
idx++;
if(idx>=_b4c.length){
break;
}
_b4e=_b4c[idx];
}while(_b4e.declaredClass=="davinci.ve.palette.PaletteItem"&&_b4e._paletteItemGroup===_b4f);
if(typeof obj.selectedIndex!="number"){
obj.selectedIndex=_b4d;
_b4c[_b4d]._paletteGroupSelected=true;
}
obj.endIndex=idx-1;
return obj;
},folderClickHandler:function(evt){
this.showHideFolderContents();
},showHideFolderContents:function(_b50){
if(!_b47.currentEditor||_b47.currentEditor.declaredClass!="davinci.ve.PageEditor"||!_b47.currentEditor.getContext){
return;
}
var _b51=this.palette.getChildren();
for(var i=0,len=_b51.length;i<len;){
var _b52=_b51[i];
if(_b52==this){
if(this.domNode.style.display=="none"){
fx.wipeIn({node:this.domNode,duration:100}).play();
}
if(this._type=="subsection_container"){
this._isOpen=typeof _b50=="boolean"?_b50:!this._isOpen;
for(var j=i+1;j<len;j++){
var _b53=_b51[j];
if(_b53.declaredClass=="davinci.ve.palette.PaletteFolder"){
if(_b53._type!="subsection"){
break;
}
if(_b53._children.length==0){
_b53.domNode.style.display="none";
_b53.isOpen=false;
}else{
if(this._isOpen){
fx.wipeIn({node:_b53.id,duration:100}).play();
_b53._isOpen=(_b53==_b53.subsection_container._openSubsection);
}else{
fx.wipeOut({node:_b53.id,duration:100}).play();
_b53.isOpen=false;
}
}
}else{
if(this._isOpen&&_b53.PaletteFolderSubsection._isOpen){
fx.wipeIn({node:_b53.id,duration:100,onEnd:function(node){
setTimeout(function(){
node.style.height="";
},1);
}.bind(this,_b53.domNode)}).play();
}else{
_b53.domNode.style.display="none";
}
}
}
i=j;
}else{
this._isOpen=typeof _b50=="boolean"?_b50:!this._isOpen;
if(this._type=="subsection"){
this.subsection_container._openSubsection=this._isOpen?this:null;
}
for(var j=i+1;j<len;){
var _b53=_b51[j];
if(_b53.declaredClass!="davinci.ve.palette.PaletteItem"){
break;
}
var obj=this._paletteItemGroupInfo(_b51,j);
for(var k=j;k<=obj.endIndex;k++){
var _b54=_b51[k];
var _b55=_b48.getWidgetDescriptorForType(_b54.type);
var show;
if(_b55.category=="custom"){
show=true;
}else{
var _b56=_b55&&_b55.collection;
show=false;
if(_b54.preset&&_b54.preset.collections){
var _b57=_b54.preset.collections;
for(var co=0;co<_b57.length;co++){
var _b58=_b57[co];
if(_b58.id&&_b58.id===_b56){
show=_b58.show;
break;
}
}
}
}
if(k==obj.selectedIndex&&show){
if(this._isOpen){
fx.wipeIn({node:_b54.id,duration:100,onEnd:function(node){
setTimeout(function(){
node.style.height="";
},1);
}.bind(this,_b54.domNode)}).play();
}else{
fx.wipeOut({node:_b54.id,duration:100}).play();
}
}else{
_b54.domNode.style.display="none";
}
}
j=k;
}
i=j;
}
}else{
if(_b52.declaredClass=="davinci.ve.palette.PaletteItem"&&_b52.domNode.style.display!="none"){
fx.wipeOut({node:_b52.id,duration:100}).play();
}
if(_b52.declaredClass=="davinci.ve.palette.PaletteFolder"&&(_b52._type=="simple"||_b52._type=="subsection")){
_b52._isOpen=false;
}
if(_b52.declaredClass=="davinci.ve.palette.PaletteFolder"&&_b52._type=="subsection_container"){
if(_b52!=this.subsection_container){
_b52._isOpen=false;
}
}
if(_b52.declaredClass=="davinci.ve.palette.PaletteFolder"&&_b52._type=="subsection"&&!_b52.subsection_container._isOpen&&_b52.domNode.style.display!="none"){
fx.wipeOut({node:_b52.id,duration:100}).play();
_b52._isOpen=false;
}
i++;
}
}
return false;
},folderMouseOverHandler:function(evt){
dojo.removeClass(this.domNode,"dojoyPaletteFolderLow");
dojo.addClass(this.domNode,"dojoyPaletteFolderHi");
},folderMouseOutHandler:function(evt){
dojo.removeClass(this.domNode,"dojoyPaletteFolderHi");
dojo.addClass(this.domNode,"dojoyPaletteFolderLow");
}});
});
},"davinci/ve/tools/PasteTool":function(){
define("davinci/ve/tools/PasteTool",["dojo/_base/declare","./CreateTool","../widget","../metadata","../../commands/CompoundCommand","../commands/AddCommand","../commands/MoveCommand","../commands/StyleCommand","dojo/Deferred","dojo/promise/all"],function(_b59,_b5a,_b5b,_b5c,_b5d,_b5e,_b5f,_b60,_b61,all){
return _b59("davinci.ve.tools.PasteTool",_b5a,{constructor:function(data){
this.inherited(arguments);
this._position_prop=null;
var d=data[0];
if(d&&d.properties){
var _b62=_b5b.parseStyleValues(d.properties.style);
this._position_prop=_b5b.retrieveStyleProperty(_b62,"position","");
}
},_create:function(args){
var _b63=args.index,_b64,_b65,_b66=new _b5d(),_b67,_b68=[],_b69=new _b61(),_b6a;
var _b6a=this._data.map(function(d){
var _b6b=new _b61();
var _b6c=[];
if(!this._loadType(d,_b6c)){
_b6b.reject();
return _b6b;
}
all(_b6c).then(function(){
var _b6d=_b5b.parseStyleValues(d.properties&&d.properties.style);
if(this._position_prop=="absolute"){
var left=parseInt(_b5b.retrieveStyleProperty(_b6d,"left","0px"));
var top=parseInt(_b5b.retrieveStyleProperty(_b6d,"top","0px"));
if(_b64){
_b65={x:left+_b64.x,y:top+_b64.y};
}else{
if(args.position){
_b65=args.position;
_b64={x:args.position.x-left,y:args.position.y-top};
}else{
console.warn("PasteTool.js _create - no value for args.position");
_b65={x:left,y:top};
_b64={x:0,y:0};
}
}
}
dojo.withDoc(this._context.getDocument(),function(){
var _b6e=function(_b6f){
if(_b63!==undefined&&_b63>=0){
_b63++;
}
_b68.push(_b6f);
if(_b65){
var _b70=this._context.getPreference("absoluteWidgetsZindex");
_b66.add(new _b60(_b6f,[{position:"absolute"},{"z-index":_b70}]));
var _b71=new _b5f(_b6f,_b65.x,_b65.y,_b67,null,null,_b67);
if(!_b67){
_b67=_b71;
}
_b66.add(_b71);
}
_b6b.resolve();
}.bind(this);
d.context=this._context;
_b5c.getHelper(d.type,"tool").then(function(_b72){
var w,_b73,_b74=[];
if(_b72){
_b73=new _b72(d);
}
if(_b73&&_b73.addPasteCreateCommand){
var _b75={parent:args.parent||this._context.getContainerNode(),position:_b65,index:_b63};
_b73.addPasteCreateCommand(_b66,_b75).then(function(w){
if(!w){
_b6b.reject();
return _b6b;
}
_b6e(w);
});
}else{
w=_b5b.createWidget(d);
if(!w){
_b6b.reject();
return _b6b;
}
_b66.add(new _b5e(w,args.parent||this._context.getContainerNode(),_b63));
this.checkAddToCurrentState(_b66,w);
_b6e(w);
}
}.bind(this));
}.bind(this));
}.bind(this));
return _b6b;
}.bind(this));
all(_b6a).then(function(){
if(!_b66.isEmpty()){
this._context.getCommandStack().execute(_b66);
setTimeout(function(){
_b68.forEach(function(w,i){
this._context.select(w,i>0);
}.bind(this));
}.bind(this),0);
}
_b69.resolve();
}.bind(this));
return _b69;
},createWithFlowLayout:function(){
return this._position_prop!="absolute";
}});
});
},"davinci/ve/views/SwitchingStyleView":function(){
define("davinci/ve/views/SwitchingStyleView",["dojo/_base/declare","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common","dijit/layout/TabContainer","dijit/layout/ContentPane","davinci/Runtime","davinci/workbench/WidgetLite","davinci/ve/widgets/HTMLStringUtil","davinci/ve/widgets/WidgetToolBar","davinci/ve/widgets/Cascade","davinci/ve/widgets/CommonProperties","davinci/ve/widgets/WidgetProperties","davinci/ve/widgets/EventSelection"],function(_b76,_b77,_b78,_b79,_b7a,_b7b,_b7c,_b7d,_b7e,_b7f,_b80,_b81,_b82){
return _b76("davinci.ve.views.SwitchingStyleView",[_b7c],{_editor:null,_widget:null,_subWidget:null,_titleBarDiv:"<div class='palette_titleBarDiv'><span class='paletteCloseBox'></span><span class='titleBarDivTitle'></span></div>",constructor:function(_b83,_b84){
dojo.subscribe("/davinci/ui/editorSelected",dojo.hitch(this,this._editorSelected));
dojo.subscribe("/davinci/ui/widgetSelected",dojo.hitch(this,this._widgetSelectionChanged));
dojo.subscribe("/davinci/states/state/changed",dojo.hitch(this,this._stateChanged));
dojo.subscribe("/maqetta/appstates/state/changed",dojo.hitch(this,this._stateChanged));
dojo.subscribe("/davinci/ui/initialPerspectiveReady",dojo.hitch(this,this._initialPerspectiveReady));
dojo.subscribe("/davinci/workbench/ready",dojo.hitch(this,this._workbenchReady));
},pageTemplate:[{key:"widgetSpecific",className:"maqPropertySection page_editor_only",addCommonPropertiesAtTop:false,html:"<div dojoType='davinci.ve.widgets.WidgetProperties'></div>"},{key:"events",className:"maqPropertySection page_editor_only",addCommonPropertiesAtTop:false,pageTemplate:{html:"<div dojoType='davinci.ve.widgets.EventSelection'></div>"}},{key:"layout",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"width",type:"multi",target:["width"],values:["","auto","100%","200px","10em"]},{display:"height",type:"multi",target:["height"],values:["","auto","100%","200px","10em"]},{html:"&nbsp;"},{key:"showMinMax",display:"&nbsp;&nbsp;&nbsp;",type:"toggleSection",pageTemplate:[{display:"min-height",type:"multi",target:["min-height"],rowClass:"propertiesSectionHidden"},{display:"max-height",type:"multi",target:["max-height"],rowClass:"propertiesSectionHidden"},{display:"min-width",type:"multi",target:["min-width"],rowClass:"propertiesSectionHidden"},{display:"max-width",type:"multi",target:["max-width"],rowClass:"propertiesSectionHidden"},{html:"&nbsp;",rowClass:"propertiesSectionHidden"}]},{display:"position",type:"combo",target:["position"],values:["","absolute","fixed","relative","static"]},{display:"left",type:"multi",target:["left"],values:["","0px","1em"]},{display:"top",type:"multi",target:["top"],values:["","0px","1em"]},{display:"right",type:"multi",target:["right"],values:["","0px","1em"]},{display:"bottom",type:"multi",target:["bottom"],values:["","0px","1em"]},{display:"display",type:"combo",target:["display"],values:["","none","block","inline","inline-block"]},{display:"opacity",type:"multi",target:["opacity"],values:["0","0.5","1.0"]},{display:"box-shadow",type:"text",target:["box-shadow"],value:["","none","1px 1px rgba(0,0,0,.5)"]},{display:"float",type:"combo",target:["float"],values:["","none","left","right"]},{display:"clear",type:"combo",target:["clear"],values:["","none","left","right","both"]},{display:"overflow",type:"combo",target:["overflow"],values:["","visible","hidden","scroll","auto"]},{display:"z-index",type:"multi",target:["z-index"],values:["","auto","0","1","100","-1","-100"]},{display:"box-sizing",type:"combo",target:["box-sizing","-webkit-box-sizing","-ms-box-sizing","-moz-box-sizing"],values:["","content-box","border-box"]}]},{key:"padding",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"<b>(padding)</b>",type:"multi",target:["padding"],values:["","0px","1em"]},{key:"showtrbl",display:"&nbsp;&nbsp;&nbsp;",type:"toggleSection",pageTemplate:[{display:"padding-top",type:"multi",target:["padding-top"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"},{display:"padding-right",type:"multi",target:["padding-right"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"},{display:"padding-bottom",type:"multi",target:["padding-bottom"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"},{display:"padding-left",type:"multi",target:["padding-left"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"}]}]},{key:"margins",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"<b>(margin)</b>",type:"multi",target:["margin"],values:["","0px","1em"]},{key:"showtrbl",display:"&nbsp;&nbsp;&nbsp;",type:"toggleSection",pageTemplate:[{display:"margin-top",type:"multi",target:["margin-top"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"},{display:"margin-right",type:"multi",target:["margin-right"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"},{display:"margin-bottom",type:"multi",target:["margin-bottom"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"},{display:"margin-left",type:"multi",target:["margin-left"],values:["","0px","1em"],rowClass:"propertiesSectionHidden"}]}]},{key:"background",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"background-color",type:"background",target:["background-color"],colorswatch:true},{display:"background-image",type:"background",target:["background-image"],values:["","none"]},{display:"background-repeat",type:"background",values:["","repeat","repeat-x","repeat-y","no-repeat"],target:["background-repeat"]},{display:"background-position",type:"background",target:["background-position"],values:["","0px 0px","0% 0%","left top","center center","right bottom"]},{display:"background-size",type:"background",target:["background-size"],values:["","auto","contain","cover","100%"]},{display:"background-origin",type:"background",target:["background-origin"],values:["","border-box","padding-box","content-box"]},{display:"background-clip",type:"background",target:["background-clip"],values:["","border-box","padding-box","content-box"]}]},{key:"border",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"<b>(border)</b>",type:"multi",target:["border"],values:["","none","1px solid black"]},{display:"show",type:"combo",values:["none","props","sides","all"],id:"properties_show_select",onchange:function(_b85){
if(typeof _b85!="number"){
return;
}
var _b86=function(_b87,_b88,last,_b89,end){
for(var k=_b88;k<=last;k++){
var _b8a=_b87[k];
var _b8b=dojo.byId(_b8a.rowId);
if(k>=_b89&&k<=end){
dojo.removeClass(_b8b,"propertiesSectionHidden");
}else{
dojo.addClass(_b8b,"propertiesSectionHidden");
}
}
};
if(this.pageTemplate){
var _b8c=this.pageTemplate[_b85];
var _b8d;
if(_b8c&&_b8c.id){
_b8d=dojo.byId(_b8c.id).value;
}
if(dojo.isString(_b8d)){
if(_b8d==="none"){
_b86(this.pageTemplate,2,20,-1,-1);
}else{
if(_b8d==="sides"){
_b86(this.pageTemplate,2,20,2,5);
}else{
if(_b8d==="props"){
_b86(this.pageTemplate,2,20,6,8);
}else{
if(_b8d==="all"){
_b86(this.pageTemplate,2,20,9,20);
}
}
}
}
}
}
}},{display:"border-top",type:"multi",target:["border-top"],values:["","none","1px solid black"],rowClass:"propertiesSectionHidden"},{display:"border-right",type:"multi",target:["border-right"],values:["","none","1px solid black"],rowClass:"propertiesSectionHidden"},{display:"border-bottom",type:"multi",target:["border-bottom"],values:["","none","1px solid black"],rowClass:"propertiesSectionHidden"},{display:"border-left",type:"multi",target:["border-left"],values:["","none","1px solid black"],rowClass:"propertiesSectionHidden"},{display:"border-width",type:"multi",target:["border-width"],values:["","1px","1em"],rowClass:"propertiesSectionHidden"},{display:"border-style",type:"multi",target:["border-style"],values:["","none","solid","dotted","dashed"],rowClass:"propertiesSectionHidden"},{display:"border-color",type:"color",target:["border-color"],rowClass:"propertiesSectionHidden"},{display:"border-top-width",type:"multi",target:["border-top-width"],values:["","1px","1em"],rowClass:"propertiesSectionHidden"},{display:"border-top-style",type:"multi",target:["border-top-style"],values:["","none","solid","dotted","dashed"],rowClass:"propertiesSectionHidden"},{display:"border-top-color",type:"color",target:["border-top-color"],rowClass:"propertiesSectionHidden"},{display:"border-right-width",type:"multi",target:["border-right-width"],values:["","1px","1em"],rowClass:"propertiesSectionHidden"},{display:"border-right-style",type:"multi",target:["border-right-style"],values:["","none","solid","dotted","dashed"],rowClass:"propertiesSectionHidden"},{display:"border-right-color",type:"color",target:["border-right-color"],rowClass:"propertiesSectionHidden"},{display:"border-bottom-width",type:"multi",target:["border-bottom-width"],values:["","1px","1em"],rowClass:"propertiesSectionHidden"},{display:"border-bottom-style",type:"multi",target:["border-bottom-style"],values:["","none","solid","dotted","dashed"],rowClass:"propertiesSectionHidden"},{display:"border-bottom-color",type:"color",target:["border-bottom-color"],rowClass:"propertiesSectionHidden"},{display:"border-left-width",type:"multi",target:["border-left-width"],values:["","1px","1em"],rowClass:"propertiesSectionHidden"},{display:"border-left-style",type:"multi",target:["border-left-style"],values:["","none","solid","dotted","dashed"],rowClass:"propertiesSectionHidden"},{display:"border-left-color",type:"color",target:["border-left-color"],rowClass:"propertiesSectionHidden"},{display:"border-collapse",type:"combo",target:["border-collapse"],values:["","separate","collapse"]},{display:"<b>(border-radius)</b>",type:"multi",target:["border-radius","-moz-border-radius"],values:["","0px","6px"]},{key:"showDetails",display:"",type:"toggleSection",pageTemplate:[{display:"border-top-left-radius",type:"multi",target:["border-top-left-radius","-moz-border-radius-topleft"],values:["","0px","6px"],rowClass:"propertiesSectionHidden"},{display:"border-top-right-radius",type:"multi",target:["border-top-right-radius","-moz-border-radius-topright"],values:["","0px","6px"],rowClass:"propertiesSectionHidden"},{display:"border-bottom-right-radius",type:"multi",target:["border-bottom-right-radius","-moz-border-radius-bottomright"],values:["","0px","6px"],rowClass:"propertiesSectionHidden"},{display:"border-bottom-left-radius",type:"multi",target:["border-bottom-left-radius","-moz-border-radius-bottomleft"],values:["","0px","6px"],rowClass:"propertiesSectionHidden"}]}]},{key:"fontsAndText",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"font",type:"text",target:["font"]},{display:"font-family",type:"font",target:["font-family"]},{display:"size",type:"multi",target:["font-size"],values:["","100%","1em","10px","10pt"]},{display:"color",type:"color",target:["color"]},{display:"font-weight",type:"combo",target:["font-weight"],values:["","normal","bold"]},{display:"font-style",type:"combo",target:["font-style"],values:["","normal","italic"]},{display:"text-decoration",type:"combo",target:["text-decoration"],values:["","none","underline","line-through"]},{display:"text-align",type:"combo",target:["text-align"],values:["","left","center","right","justify"]},{display:"vertical-align",type:"combo",target:["vertical-align"],values:["","baseline","top","middle","bottom"]},{display:"white-space",type:"combo",target:["white-space"],values:["","normal","nowrap","pre","pre-line","pre-wrap"]},{display:"text-indent",type:"multi",target:["text-indent"],values:["","0","1em","10px"]},{display:"line-height",type:"multi",target:["line-height"],values:["","normal","1.2","120%"]}]},{key:"shapesSVG",className:"maqPropertySection",addCommonPropertiesAtTop:true,pageTemplate:[{display:"stroke",type:"color",target:["stroke"]},{display:"stroke-width",type:"multi",target:["stroke-width"],values:["","1","2","3","4","5","10"]},{display:"fill",type:"color",target:["fill"]}]}],buildRendering:function(){
this.domNode=dojo.doc.createElement("div");
dojo.addClass(this.domNode,"propertiesContent");
var _b8e="";
_b8e+=this._titleBarDiv;
_b8e+="<div class='propertiesToolBar' dojoType='davinci.ve.widgets.WidgetToolBar'></div>";
_b8e+="<div dojoType='davinci.ve.widgets.WidgetProperties'></div>";
_b8e+="<div class='propScrollableArea'>";
_b8e+="<table class='propRootDetailsContainer'>";
_b8e+="<tr>";
_b8e+="<td class='propPaletteRoot'>";
var _b8f=_b77;
for(var i=0;i<this.pageTemplate.length;i++){
this.pageTemplate[i].title=_b8f[this.pageTemplate[i].key]?_b8f[this.pageTemplate[i].key]:"Key not found";
if(this.pageTemplate[i].pageTemplate){
for(var j=0;j<this.pageTemplate[i].pageTemplate.length;j++){
if(this.pageTemplate[i].pageTemplate[j].key){
this.pageTemplate[i].pageTemplate[j].display+=_b8f[this.pageTemplate[i].pageTemplate[j].key]?_b8f[this.pageTemplate[i].pageTemplate[j].key]:"Key not found";
}
}
}
}
this.domNode.innerHTML=_b8e;
this.inherited(arguments);
},_widgetValuesChanged:function(_b90){
var _b91=this._currentPropSection;
if(_b91){
var _b92=false;
for(var _b93=0;_b93<this.pageTemplate.length;_b93++){
if(this.pageTemplate[_b93].key==_b91){
_b92=true;
break;
}
}
if(_b92){
var _b94=this._getVisibleCascade(_b93);
for(var i=0;i<_b94.length;i++){
_b94[i]._widgetValuesChanged(_b90);
}
}
}
},_getVisibleCascade:function(_b95){
if(_b95){
return this.pageTemplate[_b95]["cascade"];
}
var _b96=[];
var _b97=this._currentPropSection;
if(_b97){
for(var i=0;i<this.pageTemplate.length;i++){
if(this.pageTemplate[i].key==_b97){
_b96=_b96.concat(this.pageTemplate[i]["cascade"]);
break;
}
}
}
return _b96;
},_updatePaletteValues:function(_b98){
if(!this._editor){
return;
}
var _b99=_b98[0];
this._widget=_b99;
this._subwidget=_b99&&_b99.subwidget;
this.setReadOnly(!(this._widget||this._subwidget));
var _b9a=this._getVisibleCascade();
for(var i=0;i<_b9a.length;i++){
_b9a[i]._widgetSelectionChanged(_b98);
}
},_widgetSelectionChanged:function(_b9b){
this._updatePaletteValues(_b9b);
},_stateChanged:function(){
var _b9c=this._widget?[this._widget]:[];
this._updatePaletteValues(_b9c);
},_widgetPropertiesChanged:function(_b9d){
if((!this._widget)||(this._widget.type===_b9d[0].type)){
this._updatePaletteValues(_b9d);
}
},_titlePaneOpen:function(_b9e){
var _b9f=this._getVisibleCascade(_b9e);
for(var i=0;i<_b9f.length;i++){
_b9f[i]._editorSelected({"editor":this._editor});
}
},startup:function(){
this.domNode.style.height="100%";
this._editor=_b7b.currentEditor;
this.inherited(arguments);
for(var i=0;i<this.pageTemplate.length;i++){
var _ba0=this.pageTemplate[i];
if(_ba0.pageTemplate){
for(var j=0;j<_ba0.pageTemplate.length;j++){
var _ba1=_ba0.pageTemplate[j];
if(_ba1.onchange&&_ba1.id){
dojo.connect(dojo.byId(_ba1.id),"onchange",dojo.hitch(_ba0,_ba1.onchange,j));
}
}
}
}
for(var v=0;v<this.pageTemplate.length;v++){
this.pageTemplate[v]["cascade"]=[];
}
this.setReadOnly(true);
this.onEditorSelected();
dojo.subscribe("/davinci/ui/widgetValuesChanged",dojo.hitch(this,this._widgetValuesChanged));
dojo.subscribe("/davinci/ui/widgetPropertiesChanged",dojo.hitch(this,this._widgetPropertiesChanged));
},setReadOnly:function(_ba2){
for(var v=0;v<this.pageTemplate.length;v++){
var page=this.pageTemplate[v]["pageTemplate"];
if(!page){
continue;
}
for(var i=0;i<page.length;i++){
var _ba3=page[i]["widget"];
if(_ba3){
_ba3.set("readOnly",_ba2);
}else{
var node=page[i].domNode;
if(node){
dojo.attr(node,"disabled",_ba2);
}
}
}
}
},_modelEntryById:function(id){
for(var v=0;v<this.pageTemplate.length;v++){
var page=this.pageTemplate[v]["pageTemplate"];
if(!page){
continue;
}
for(var i=0;i<page.length;i++){
var _ba4=page[i]["id"];
if(id==_ba4){
return page[i];
}
}
}
},_editorSelected:function(_ba5){
this._editor=_ba5.editor;
this.onEditorSelected(this._editor);
var _ba6=this.getParent();
var _ba7=_ba6.selectedChildWidget;
var _ba8=false;
var _ba9=dojo.query(".maqPropertySection",_ba6.domNode);
if(this._editor){
if(this._editor.declaredClass!="davinci.ve.PageEditor"&&this._editor.declaredClass!="davinci.ve.themeEditor.ThemeEditor"){
_ba9.forEach(function(_baa){
var _bab=dijit.byNode(_baa);
_bab.controlButton.domNode.style.display="none";
if(_bab==_ba7){
_ba8=true;
}
});
}else{
_ba9.forEach(function(_bac){
var _bad=dijit.byNode(_bac);
_bad.controlButton.domNode.style.display="";
});
if(this._editor.declaredClass=="davinci.ve.themeEditor.ThemeEditor"){
var _bae=dojo.query(".page_editor_only",_ba6.domNode);
_bae.forEach(function(_baf){
var _bb0=dijit.byNode(_baf);
_bb0.controlButton.domNode.style.display="none";
if(_bb0==_ba7){
_ba8=true;
}
});
}
}
}else{
_ba9.forEach(function(_bb1){
var _bb2=dijit.byNode(_bb1);
_bb2.controlButton.domNode.style.display="";
});
_ba8=true;
}
if(_ba8){
this._selectFirstVisibleTab();
}
},onEditorSelected:function(){
this._widget=null;
this._subWidget=null;
this._updateToolBars();
if(this._oldClassName){
dojo.removeClass(this.domNode.parentNode.parentNode,this._oldClassName);
}
if(!this._editor){
return;
}
if(this._editor){
this._oldClassName=this._editor.editorID.replace(/\./g,"_");
dojo.addClass(this.domNode.parentNode.parentNode,this._oldClassName);
}
var _bb3=this._currentPropSection;
var _bb4=dojo.query(".propSectionButton",this.domNode);
for(var i=0;i<_bb4.length;i++){
var _bb5=_bb4[i];
if(this._editor&&this._editor.supports&&this._editor.supports("propsect_"+this.pageTemplate[i].key)){
dojo.removeClass(_bb5,"dijitHidden");
}else{
dojo.addClass(_bb5,"dijitHidden");
if(_bb3==this.pageTemplate[i].key){
_b7d.showRoot();
}
}
}
var _bb6=[];
for(var i=0;i<this.pageTemplate.length;i++){
var _bb7=this.pageTemplate[i]["cascade"];
if(_bb7){
_bb6=_bb6.concat(_bb7);
}else{
}
}
for(var i=0;i<_bb6.length;i++){
var _bb7=_bb6[i];
if(_bb7._editorSelected){
_bb7._editorSelected({"editor":this._editor});
}
}
},_destroyContent:function(){
var _bb8=(this.containerNode||this.domNode);
dojo.forEach(dojo.query("[widgetId]",_bb8).map(dijit.byNode),function(w){
w.destroy();
});
while(_bb8.firstChild){
dojo._destroyElement(_bb8.firstChild);
}
dojo.forEach(this._tooltips,function(t){
t.destroy();
});
this._tooltips=undefined;
},sectionTitleFromKey:function(key){
for(var i=0;i<this.pageTemplate.length;i++){
if(this.pageTemplate[i].key==key){
return this.pageTemplate[i].title;
}
}
},_initialPerspectiveReady:function(){
if(!this._alreadySplitIntoMultipleTabs){
var _bb9=this.getParent();
dojo.addClass(_bb9.domNode,"propRootDetailsContainer");
dojo.addClass(_bb9.domNode,"propertiesContent");
for(var i=0;i<this.pageTemplate.length;i++){
var key=this.pageTemplate[i].key;
var _bba=this.pageTemplate[i].title;
var _bbb=this.pageTemplate[i].className;
if(!_bbb){
_bbb="";
}
var _bbc=this._titleBarDiv;
_bbc+="<div class='propertiesToolBar' dojoType='davinci.ve.widgets.WidgetToolBar'></div>";
_bbc+="<div class='cascadeBackButtonDiv'><button onclick='davinci.ve.widgets.HTMLStringUtil.showSection(\""+key+"\",\""+_bba+"\")'>"+_bba+" "+_b77.properties+"</button></div>";
var _bbd=_b7d.generateTemplate(this.pageTemplate[i]);
var _bbe=_bbc+_bbd;
if(i==0){
cp=this;
cp.set("title",_bba);
dojo.addClass(cp.domNode,_bbb);
}else{
var cp=new _b7a({title:_bba,content:_bbe,"class":_bbb});
_bb9.addChild(cp);
}
cp._maqPropGroup=this.pageTemplate[i].key;
var _bbf=dojo.query(".paletteCloseBox",cp.domNode);
if(_bbf.length>0){
var _bc0=_bbf[0];
dojo.connect(_bc0,"click",this,function(_bc1){
davinci.Workbench.collapsePaletteContainer(_bc1.currentTarget);
});
}
}
for(var v=0;v<this.pageTemplate.length;v++){
this.pageTemplate[v]["cascade"]=[];
var page=this.pageTemplate[v]["pageTemplate"];
if(!page){
continue;
}
for(var i=0;i<page.length;i++){
var id=page[i]["id"];
var _bc2=dijit.byId(id);
if(_bc2){
page[i]["widget"]=_bc2;
}else{
_bc2=dojo.byId(id);
if(_bc2){
page[i]["domNode"]=_bc2;
}
}
}
var _bc3=this.pageTemplate[v].id;
var _bc4=dojo.query("#"+_bc3+" .CascadeTop");
_bc4.forEach(function(_bc5){
return function(p){
var _bc6=dijit.byId(p.id);
_bc5["cascade"].push(_bc6);
};
}(this.pageTemplate[v]));
}
dojo.connect(_bb9,"selectChild",this,function(tab){
if(tab.controlButton.domNode.style.display=="none"){
if(!this._recursiveSelectChildInProcess){
this._recursiveSelectChildInProcess=true;
this._selectFirstVisibleTab();
delete this._recursiveSelectChildInProcess;
return;
}
}
if(tab._maqPropGroup){
this._currentPropSection=tab._maqPropGroup;
var _bc7=(this._editor&&this._editor.getContext)?this._editor.getContext():null;
var _bc8=(_bc7&&_bc7.getSelection)?_bc7.getSelection():[];
this._updatePaletteValues(_bc8);
_b7d._initSection(this._currentPropSection);
}
});
this._alreadySplitIntoMultipleTabs=true;
}
},_workbenchReady:function(){
this._updateToolBars();
},_updateToolBars:function(){
var _bc9=dojo.query(".propertiesToolBar");
_bc9.forEach(function(_bca){
if(this._editor&&this._editor.declaredClass=="davinci.ve.PageEditor"){
dojo.removeClass(_bca,"dijitHidden");
_bca.style.display="";
}else{
dojo.addClass(_bca,"dijitHidden");
}
}.bind(this));
},_selectFirstVisibleTab:function(){
var _bcb=this.getParent();
var _bcc=_bcb.getChildren();
for(var i=0;i<_bcc.length;i++){
var cp=_bcc[i];
if(cp.controlButton.domNode.style.display!="none"){
_bcb._maqDontExpandCollapse=true;
_bcb.selectChild(cp);
delete _bcb._maqDontExpandCollapse;
break;
}
}
}});
});
},"davinci/ui/widgets/FileFieldDialog":function(){
require({cache:{"url:davinci/ui/widgets/templates/FileFieldDialog.html":"<div>\n\t<div style='float:right;'>\n\t\t<button type='button' style='font-size:.75em;float:right;' dojoType=\"dijit.form.Button\" dojoAttachPoint=\"button\" dojoAttachEvent=\"onClick:_showFileSelectionDialog\">...</button>\n\t</div>\n\t<div style='margin-right:35px;'>\n\t\t<input style='width:100%;' type='text' dojoType=\"dijit.form.TextBox\" dojoAttachPoint=\"textField\" dojoAttachEvent=\"onChange:_onChange\"></input>\n\t</div>\n</div>\n\n"}});
define("davinci/ui/widgets/FileFieldDialog",["dojo/_base/declare","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","davinci/Workbench","davinci/ui/widgets/OpenFile","dijit/form/Button","davinci/model/Path","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/FileFieldDialog.html","dijit/form/TextBox",],function(_bcd,_bce,_bcf,_bd0,_bd1,_bd2,_bd3,Path,_bd4,_bd5,_bd6){
var _bd7="davinci_ui_widgets_filefielddialog_generated";
var _bd8=0;
var _bd9=function(){
return _bd7+(_bd8++);
};
return _bcd("davinci.ui.widgets.FileFieldDialog",[_bce,_bcf,_bd0],{templateString:_bd6,widgetsInTemplate:true,_fileSelectionDialog:null,_showFileSelectionDialog:function(){
var _bda=function(){
var tree=_bdb.fileTree;
if(tree.selectedItem){
var _bdc=tree.selectedItem.getPath();
var path=new Path(_bdc);
var _bdd=path.relativeTo(new Path(this._baseLocation),true).toString();
this.textField.set("value",_bdd);
this._onChange();
}
};
var _bdb=new _bd2({finishButtonLabel:_bd4.select});
_bd1.showModal(_bdb,_bd4.selectFile,{width:275,height:220},dojo.hitch(this,_bda),true);
},_setBaseLocationAttr:function(_bde){
this._baseLocation=_bde;
},_setValueAttr:function(_bdf){
if(this.value!=_bdf){
this.value=_bdf;
this.textField.set("value",_bdf);
}
},_setDisabledAttr:function(_be0){
this.textField.set("disabled",_be0);
this.button.set("disabled",_be0);
this.inherited(arguments);
},_setIntermediateChangesAttr:function(_be1){
this.textField.set("intermediateChanges",_be1);
this.inherited(arguments);
},_onChange:function(){
var _be2=this.textField.get("value");
if(this.value!=_be2){
this.value=_be2;
this.textField.set("value",this.value);
this.onChange(_be2);
}
},onChange:function(_be3){
},_getValueAttr:function(){
return this.textField.get("value");
}});
});
},"dijit/form/SimpleTextarea":function(){
define("dijit/form/SimpleTextarea",["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_be4,_be5,has,_be6){
return _be4("dijit.form.SimpleTextarea",_be6,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){
if(!this.value&&this.srcNodeRef){
this.value=this.srcNodeRef.value;
}
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
if(has("ie")&&this.cols){
_be5.add(this.textbox,"dijitTextAreaCols");
}
},filter:function(_be7){
if(_be7){
_be7=_be7.replace(/\r/g,"");
}
return this.inherited(arguments);
},_onInput:function(e){
if(this.maxLength){
var _be8=parseInt(this.maxLength);
var _be9=this.textbox.value.replace(/\r/g,"");
var _bea=_be9.length-_be8;
if(_bea>0){
var _beb=this.textbox;
if(_beb.selectionStart){
var pos=_beb.selectionStart;
var cr=0;
if(has("opera")){
cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;
}
this.textbox.value=_be9.substring(0,pos-_bea-cr)+_be9.substring(pos-cr);
_beb.setSelectionRange(pos-_bea,pos-_bea);
}else{
if(this.ownerDocument.selection){
_beb.focus();
var _bec=this.ownerDocument.selection.createRange();
_bec.moveStart("character",-_bea);
_bec.text="";
_bec.select();
}
}
}
}
this.inherited(arguments);
}});
});
},"davinci/version":function(){
define("davinci/version",[],"10");
},"davinci/ve/commands/EventCommand":function(){
define("davinci/ve/commands/EventCommand",["dojo/_base/declare","davinci/ve/widget"],function(_bed,_bee){
return _bed("davinci.ve.commands.EventCommand",null,{name:"EventCommand",constructor:function(_bef,_bf0){
this._oldId=(_bef?_bef.id:undefined);
this._properties=(_bf0||{});
},setContext:function(_bf1){
this._context=_bf1;
},execute:function(){
if(!this._oldId||!this._properties){
return;
}
var _bf2=_bee.byId(this._oldId);
this._oldProps=_bf2.properties||{};
_bf2.setProperties(this._properties,true);
if(_bf2.isHtmlWidget){
var node=_bf2.domNode;
for(var name in this._properties){
if(!this._properties[name]){
node.removeAttribute(name);
}
}
}
this._newId=this._oldId;
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_bf2]]);
},undo:function(){
if(!this._newId){
return;
}
var _bf3=_bee.byId(this._newId);
var _bf4=_bf3.domNode;
var _bf5=_bf3._srcElement;
for(var _bf6 in this._properties){
if(!this._oldProps[_bf6]){
_bf4.removeAttribute(_bf6);
_bf5.removeAttribute(_bf6);
}
}
_bf3.setProperties(this._oldProps);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_bf3]]);
}});
});
},"davinci/ve/ve.plugin":function(){
define("davinci/ve/ve.plugin",["require"],function(_bf7){
return {id:"davinci.ve","davinci.view":[{id:"Palette",title:"Palette",viewClass:"davinci/ve/palette/HtmlWidgets",iconClass:"paletteIcon paletteIconWidgets"},{id:"states",title:"Scenes",viewClass:"davinci/ve/views/StatesView",iconClass:"paletteIcon paletteIconStates"},{id:"object",title:"Object",viewClass:"davinci/ve/views/ObjectView"},{id:"style",title:"",viewClass:"davinci/ve/views/SwitchingStyleView"}],"davinci.perspective":[{id:"pageDesign",title:"Page Design",views:[{viewID:"davinci.ve.Palette",position:"left",selected:true},{viewID:"davinci.ui.outline",position:"left"},{viewID:"davinci.ve.style",position:"right"},{viewID:"davinci.ui.comment",position:"right",hidden:true},{viewID:"davinci.ve.states",position:"right-bottom",selected:true},{viewID:"davinci.ui.navigator",position:"left-bottom",selected:true},{viewID:"davinci.review.reviewNavigator",position:"left-bottom"}]}],"davinci.editor":[{id:"HTMLPageEditor",name:"HTML Visual Editor",extensions:["html","htm","php"],isDefault:true,editorClass:"davinci/ve/PageEditor",palettePerspective:"davinci.ve.pageDesign",expandPalettes:["left"]}],"davinci.actionSets":[{id:"cutCopyPaste",visible:true,actions:[{label:"Cut",keySequence:"M1+X",iconClass:"editActionIcon editCutIconSmall",action:"davinci/ve/actions/CutAction",menubarPath:"davinci.edit/cut"},{label:"Copy",keySequence:"M1+C",iconClass:"editActionIcon editCopyIconSmall",action:"davinci/ve/actions/CopyAction",menubarPath:"davinci.edit/cut"},{keySequence:"M1+V",iconClass:"editActionIcon editPasteIconSmall",label:"Paste",action:"davinci/ve/actions/PasteAction",menubarPath:"davinci.edit/cut"},{keySequence:"DEL",iconClass:"editActionIcon editDeleteIconSmall",label:"Delete",action:"davinci/ve/actions/DeleteAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon selectParentIconSmall",label:"Select parent",action:"davinci/ve/actions/SelectParentAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon selectAncestorIconSmall",label:"Select ancestor...",action:"davinci/ve/actions/SelectAncestorAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon unselectAllIconSmall",label:"Unselect all",action:"davinci/ve/actions/UnselectAllAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Surround with &lt;A&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"a",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Surround with &lt;DIV&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"div",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Surround with &lt;SPAN&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"span",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveToFrontIconSmall",label:"Move to front",action:"davinci/ve/actions/MoveToFrontAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveForwardIconSmall",label:"Move forward",action:"davinci/ve/actions/MoveForwardAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveBackwardIconSmall",label:"Move backward",action:"davinci/ve/actions/MoveBackwardAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon moveToBackIconSmall",label:"Move to back",action:"davinci/ve/actions/MoveToBackAction",menubarPath:"davinci.edit/cut"},{iconClass:"editActionIcon",label:"Manage States...",action:"davinci/ve/actions/ManageStates",menubarPath:"davinci.edit/cut"}]}],"davinci.viewActions":[{viewContribution:{targetID:"davinci.ve.outline",actions:[{id:"design",iconClass:"designModeIcon editActionIcon",radioGroup:"displayMode",method:"switchDisplayMode",label:"Widgets",toolbarPath:"displayMode"},{id:"source",iconClass:"sourceModeIcon editActionIcon",method:"switchDisplayMode",radioGroup:"displayMode",label:"Source",toolbarPath:"displayMode"}]}},{viewContribution:{targetID:"davinci.ve.states",actions:[{id:"addState",iconClass:"viewActionIcon addStateIcon",action:"davinci/ve/actions/AddState",label:"Add state",toolbarPath:"states1"},{id:"removeState",iconClass:"viewActionIcon removeStateIcon",action:"davinci/ve/actions/RemoveState",label:"Remove state",toolbarPath:"states1"},{id:"modifyState",iconClass:"viewActionIcon modifyStateIcon",action:"davinci/ve/actions/ModifyState",label:"Modify state",toolbarPath:"states1"},{id:"manageStates",className:"manageStatesButton",iconClass:"viewActionIcon manageStatesIcon",action:"davinci/ve/actions/ManageStates",label:"For currently selected widgets, manage widget visibility for different states",toolbarPath:"states1"},{id:"NewWidgetsCurrentState",className:"newWidgetsCurrentStateButton",iconClass:"viewActionIcon newWidgetsCurrentStateIcon",action:"davinci/ve/actions/NewWidgetsCurrentState",label:"Toggle whether new widgets go to Background or current state",toolbarPath:"states2"},{id:"highlightBaseWidgets",className:"highlightBaseWidgetsButton",iconClass:"viewActionIcon highlightBaseWidgetsIcon",action:"davinci/ve/actions/HighlightBaseWidgets",label:"When in custom state, highlight widgets from Background state",toolbarPath:"states2"}]}}],"davinci.actionSetPartAssociations":[{targetID:"davinci.ve.cutCopyPaste",parts:["davinci.ve.visualEditor","davinci.ve.VisualEditorOutline"]}],"davinci.editorActions":{editorContribution:{targetID:"davinci.ve.HTMLPageEditor",actions:[{id:"savecombo",className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",type:"ComboButton",run:function(){
_bf7(["../Workbench"],function(_bf8){
_bf7("../ui/Resource").save();
});
},isEnabled:function(_bf9){
return _bf7("../Workbench").getOpenEditor();
},menu:[{iconClass:"saveIcon",run:function(){
_bf7("../ui/Resource").save();
},isEnabled:function(_bfa){
return _bf7("../Workbench").getOpenEditor();
},label:"Save",keyBinding:{accel:true,charOrCode:"s",allowGlobal:true}},{iconClass:"saveAsIcon",run:function(){
_bf7("../ui/Resource").saveAs("html");
},isEnabled:function(_bfb){
return _bf7("../Workbench").getOpenEditor();
},label:"Save As",keyBinding:{accel:true,shift:true,charOrCode:"s",allowGlobal:true}},{id:"saveasdijit",iconClass:"saveAsDijitIcon",run:function(){
return _bf7(["davinci/de/resource"],function(r){
r.createDijiFromNewDialog();
});
},isEnabled:function(_bfc){
return _bf7("../Workbench").getOpenEditor();
},label:"Save As Widget"},]},{id:"undo",iconClass:"editActionIcon undoIcon",action:"davinci/actions/UndoAction",label:"Undo",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"z"}},{id:"redo",iconClass:"editActionIcon redoIcon",action:"davinci/actions/RedoAction",label:"Redo",toolbarPath:"undoredo",keyBinding:{accel:true,shift:true,charOrCode:"z"}},{id:"cut",label:"Cut",iconClass:"editActionIcon editCutIcon",action:"davinci/ve/actions/CutAction",toolbarPath:"cutcopypaste",keyBinding:{accel:true,charOrCode:"x"}},{id:"copy",label:"Copy",iconClass:"editActionIcon editCopyIcon",action:"davinci/ve/actions/CopyAction",toolbarPath:"cutcopypaste",keyBinding:{accel:true,charOrCode:"c"}},{label:"Paste",iconClass:"editActionIcon editPasteIcon",action:"davinci/ve/actions/PasteAction",toolbarPath:"cutcopypaste",keyBinding:{accel:true,charOrCode:"v"}},{id:"delete",iconClass:"editActionIcon editDeleteIcon",label:"Delete",action:"davinci/ve/actions/DeleteAction",toolbarPath:"delete",keyBinding:{charOrCode:[dojo.keys.DELETE,dojo.keys.BACKSPACE]}},{id:"openBrowser",iconClass:"openBrowserIcon",className:"davinciFloatRight openBrowser",run:function(){
_bf7(["../Workbench"],function(_bfd){
var _bfe=_bfd.getOpenEditor();
if(_bfe&&_bfe.resourceFile){
_bfe.previewInBrowser();
}else{
console.error("ERROR. Cannot launch browser window. No editor info.");
}
});
},label:"Preview in Browser",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"0",allowGlobal:true}},{id:"documentSettings",iconClass:"documentSettingsIcon",className:"documentSettings davinciFloatRight",label:"Document settings",toolbarPath:"undoredo",type:"DropDownButton",menu:[{id:"theme",iconClass:"selectThemeIcon",className:"davinciFloatRight",action:"davinci/actions/SelectThemeAction",label:"Switch theme"},{id:"chooseDevice",iconClass:"deviceIcon",className:"davinciFloatRight",action:"davinci/ve/actions/ChooseDeviceAction",label:"Choose device"},{id:"rotateDevice",iconClass:"rotateIcon",className:"davinciFloatRight",action:"davinci/ve/actions/RotateDeviceAction",label:"Rotate device"},{iconClass:"editActionIcon",label:"Select parent",action:"davinci/ve/actions/SelectParentAction"},{iconClass:"editActionIcon",label:"Select ancestor...",action:"davinci/ve/actions/SelectAncestorAction"},{iconClass:"editActionIcon",label:"Unselect all",action:"davinci/ve/actions/UnselectAllAction"},{iconClass:"editActionIcon",label:"Move to front",action:"davinci/ve/actions/MoveToFrontAction"},{iconClass:"editActionIcon",label:"Move forward",action:"davinci/ve/actions/MoveForwardAction"},{iconClass:"editActionIcon",label:"Move backward",action:"davinci/ve/actions/MoveBackwardAction"},{iconClass:"editActionIcon",label:"Move to back",action:"davinci/ve/actions/MoveToBackAction"},{iconClass:"editActionIcon",label:"Surround with &lt;A&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"a"},{iconClass:"editActionIcon",label:"Surround with &lt;DIV&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"div"},{iconClass:"editActionIcon",label:"Surround with &lt;SPAN&gt;",action:"davinci/ve/actions/SurroundAction",surroundWithTagName:"span"},{iconClass:"editActionIcon",label:"Manage States...",action:"davinci/ve/actions/ManageStates",menubarPath:"davinci.edit/cut"}]},{id:"stickynote",iconClass:"stickynoteIcon",action:"davinci/actions/StickyNoteAction",label:"Add note",toolbarPath:"stickynote"},{id:"layout",className:"maqLabelButton davinciFloatRight maqLayoutDropDownButton",showLabel:true,label:"Flow",toolbarPath:"undoredo",type:"DropDownButton",menu:[{label:"Flow",iconClass:"flowLayoutIcon",method:"selectLayoutFlow"},{label:"Absolute",iconClass:"absoluteLayoutIcon",method:"selectLayoutAbsolute"}]},{id:"sourcecombo",className:"maqLabelButton davinciFloatRight maqSourceComboButton",showLabel:true,label:"Source",action:"davinci/ve/actions/ViewSourceAction",toolbarPath:"undoredo",type:"ComboButton",menu:[{keyBinding:{accel:true,charOrCode:"2",allowGlobal:true},iconClass:"editActionIcon sourceModeIcon sourceMenuIcon",action:"davinci/ve/actions/ViewSourceMenuAction",label:"Source only"},{keyBinding:{accel:true,charOrCode:"3",allowGlobal:true},iconClass:"editActionIcon splitVerticalIcon sourceMenuIcon",action:"davinci/ve/actions/ViewSplitVMenuAction",label:"Split Vertically"},{keyBinding:{accel:true,charOrCode:"4",allowGlobal:true},iconClass:"editActionIcon splitHorizontalIcon sourceMenuIcon",action:"davinci/ve/actions/ViewSplitHMenuAction",label:"Split Horizontally"}]},{id:"design",showLabel:true,className:"maqLabelButton davinciFloatRight maqDesignButton",action:"davinci/ve/actions/ViewDesignAction",label:"Design",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"1",allowGlobal:true}},{id:"closeactiveeditor",run:function(){
_bf7(["../Workbench"],function(_bff){
_bff.closeActiveEditor();
});
},keyBinding:{accel:true,shift:true,charOrCode:"w",allowGlobal:true}},{id:"showWidgetsPalette",run:function(){
var tab=dijit.byId("davinci.ve.Palette");
if(tab){
var _c00=tab.getParent();
if(_c00){
_c00.selectChild(tab);
}
}
},keyBinding:{meta:true,charOrCode:"p",allowGlobal:true}}]}},"davinci.preferences":[{name:"Visual Editor",id:"editorPrefs",category:"davinci.html.general",pane:"davinci/ve/prefs/HTMLEditPreferences",defaultValues:{"flowLayout":true,"snap":true,"showPossibleParents":false,"cssOverrideWarn":true,"absoluteWidgetsZindex":900,"widgetPaletteLayout":"icons"}}],"davinci.dnd":[{parts:["davinci.ui.navigator"],dragSource:function(_c01){
if(_c01.elementType=="File"){
return (/gif|jpeg|jpg|png|svg|json/i).test(_c01.getExtension());
}
},dragHandler:"davinci/ve/palette/ImageDragSource"}],"davinci.fileType":[{extension:"theme",iconClass:"themeFileIcon",type:"text"}],"davinci.defaultEditorActions":{editorContribution:{actions:[{id:"save",run:function(){
_bf7("../Workbench").getOpenEditor().save();
},isEnabled:function(_c02){
return true;
},className:"maqLabelButton",showLabel:true,label:"Save",toolbarPath:"save",keyBinding:{accel:true,charOrCode:"s"}},{id:"undo",iconClass:"editActionIcon undoIcon",action:"davinci/actions/UndoAction",label:"Undo",toolbarPath:"undoredo",keyBinding:{accel:true,charOrCode:"z"}},{id:"redo",iconClass:"editActionIcon redoIcon",action:"davinci/actions/RedoAction",label:"Redo",toolbarPath:"undoredo",keyBinding:{accel:true,shift:true,charOrCode:"z"}}]}}};
});
},"davinci/ui/ModelEditor":function(){
define("davinci/ui/ModelEditor",["dojo/_base/declare","../Runtime","./TextEditor","../commands/SourceChangeCommand"],function(_c03,_c04,_c05,_c06){
return _c03(_c05,{constructor:function(_c07,_c08){
this.subscribe("/davinci/ui/selectionChanged",this.selectModel);
},colorize:function(text){
return null;
},setContent:function(_c09,_c0a){
this.inherited(arguments);
this.model.fileName=_c09;
this.model.setText(_c0a);
},getHoverText:function(x,y){
var _c0b=this.convertMouseToLine(x,y);
var _c0c=this.model.findChildAtPosition({startOffset:_c0b.row,endOffset:_c0b.col});
return _c0c.getLabel();
},handleChange:function(text){
this.inherited(arguments);
var _c0d=this.model.getText();
var _c0e=_c04.currentEditor;
if(_c0e&&_c0e.getCommandStack){
var _c0f=_c0e.getCommandStack();
var _c10=new _c06({model:this.model,oldText:_c0d,newText:text});
_c0f.execute(_c10);
}else{
this.model.setText(text);
dojo.publish("/davinci/ui/modelChanged",[{newModel:this.model}]);
}
},selectModel:function(_c11,_c12){
if(this.publishingSelect||(_c12&&this!=_c12)){
return;
}
if(_c11.length&&_c11[0].model){
var _c13=_c11[0].model;
if(_c13.elementType){
var sobj=this.model.mapPositions(_c13);
this.select(sobj);
}
}
},selectionChange:function(_c14){
var _c15=this.model.mapPositions(this.model);
var diff=this.model.endOffset-_c15.endOffset;
var _c16={startOffset:_c14.startOffset+diff,endOffset:_c14.endOffset+diff-1};
var _c17=this.model.findChildAtPosition(_c16);
_c14.model=_c17;
if(_c17!=this._selectedModel){
try{
this.publishingSelect=true;
dojo.publish("/davinci/ui/selectionChanged",[[_c14],this]);
}
finally{
this.publishingSelect=false;
}
}
this._selectedModel=_c17;
},getSyntaxPositions:function(text,_c18){
this.model.setText(text);
if(this.model.getSyntaxPositions){
return this.model.getSyntaxPositions(_c18).sort(function(a,b){
if(a.line!=b.line){
return a.line-b.line;
}
return a.col-b.col;
});
}
},save:function(){
this.model.setText(this.getText());
this.inherited(arguments);
},getErrors:function(){
return this.model.errors||[];
}});
});
},"davinci/ve/widgets/Cascade":function(){
define("davinci/ve/widgets/Cascade",["dojo/_base/declare","../../workbench/WidgetLite","../../workbench/Preferences","../../Workbench","../../html/CSSModel","../../library","../../Theme","../../html/CSSRule","../States","dojo/i18n!../nls/ve","system/resource"],function(_c19,_c1a,_c1b,_c1c,_c1d,_c1e,_c1f,_c20,_c21,_c22,_c23){
var _c24=_c19("davinci.ve.widgets.Cascade",[_c1a],{target:null,targetField:null,toggleClasses:null,_regex_combinators:/[\s\~\+\>]+/,_regex_not_pseudoclass:/(.*)\:not\((.*)\)(.*)/,_regex_pseudoelement:/(.*)(\:\:[^\:\.\#\[]*)(.*)/,_regex_id:/(.*)(\#[^\:\.\#\[]*)(.*)/,_regex_class:/(.*)(\.[^\:\.\#\[]*)(.*)/,_regex_attribute:/(.*)(\[[^\]]*\])(.*)/,_regex_pseudoclass:/(.*)(\:[^\:\.\#\[]*)(.*)/,_regex_univeral:/(.*)(\*[^\:\.\#\[]*)(.*)/,constructor:function(_c25,_c26){
this.subscriptions=[];
this.publishing={};
this._radioGroupName="davinci_ve_widgets_Cascade"+(davinci.ve.widgets.Cascade.__id++);
this._handles=[];
this.inherited(arguments);
},buildRendering:function(){
this.domNode=dojo.doc.createElement("div");
this.container=dojo.doc.createElement("div");
dojo.addClass(this.container,"showCascade");
this.domNode.appendChild(this.container);
this.topDiv=dojo.create("div",{"class":"cascadeTopDiv"},this.container);
this.cascadeTableDiv=dojo.create("div",{"class":"cascadeTableDiv"},this.container);
dojo.removeClass(this.container,"showAllValues");
if(!dojo.isArray(this.target)){
this.target=[this.target];
}
dojo.addClass(this.domNode,"CascadeTop");
this.inherited(arguments);
},startup:function(){
var _c27=dijit.byId(this.targetField);
if(_c27){
_c27._cascade=this;
this._getFieldValue=function(){
return _c27.get("value");
};
this._setFieldValue=function(_c28,loc){
if(!_c27.set){
return;
}
this._value=_c28||"";
this._loc=loc;
if(_c27._setBaseLocationAttr){
_c27.set("baseLocation",(loc&&loc.getPath)?loc.getPath():null);
}
_c27.set("value",this._value,true);
};
dojo.connect(_c27,"onChange",this,"_onFieldChange");
dojo.connect(_c27,"onFocus",this,"_onFieldFocus");
dojo.connect(_c27,"onBlur",this,"_onFieldBlur");
}else{
var node=dojo.byId(this.targetField);
this._getFieldValue=function(){
return dojo.attr(node,"value");
};
this._setFieldValue=function(_c29,_c2a){
this._value=_c29||"";
this._loc=_c2a;
dojo.attr(node,"value",this._value);
};
dojo.connect(node,"onchange",this,"_onFieldChange",true);
dojo.connect(node,"onfocus",this,"_onFieldFocus",true);
dojo.connect(node,"onblur",this,"_onFieldBlur",true);
}
this._value=this._getFieldValue();
this._started=true;
},_canModifyRule:function(_c2b){
if(!_c2b||!_c2b.getCSSFile){
return true;
}
var _c2c=_c2b.getCSSFile();
if(!_c2c){
return true;
}
var _c2d=_c23.findResource(_c2c.url);
return !_c2d.readOnly();
},_onFieldChange:function(){
var _c2e=function(arr1,arr2){
if(!arr1&&!arr2){
return true;
}
if((!arr1&&arr2)||(arr1&&!arr2)){
return false;
}
if(arr1.length!=arr2.length){
return false;
}
for(var i=0;i<arr1.length;i++){
if(arr1[i]!==arr2[i]){
return false;
}
}
return true;
};
if(this.context){
this.context.blockChange(false);
}
if(this._value==this._getFieldValue()&&_c2e(this._valueArray,this._valueArrayNew)){
return;
}
if(this._values.length<1){
return;
}
if(this._getFieldValue()=="(overrides)"){
if(this._setFieldValue){
this._setFieldValue("(overrides)",null);
}
return;
}
if(typeof this._targetValueIndex!="number"){
return;
}
var _c2f=_c1b.getPreferences("davinci.ve.editorPrefs",_c1c.getProject());
if(this._widget&&this.target&&this.target.length>0){
var _c30=this.target[0];
var _c31=this._widget.getContext();
var _c32;
if(_c31){
_c32=_c31.cascadeBatch;
}
if(_c32){
var _c33=_c32.askUserResponse;
if(_c32.deferreds){
var _c34=_c32.deferreds;
}
}
}
function _c35(){
if(_c30&&_c34&&_c34[_c30]){
_c34[_c30].resolve();
}
};
function _c36(that){
that._value=that._getFieldValue();
that._valueArray=that._valueArrayNew;
var _c37=(that._valueArray&&dojo.isArray(that._valueArray)&&that._valueArray.length>0)?that._valueArray:that._value;
that._changeValue(that._targetValueIndex,_c37);
};
if(_c33===false){
this._setFieldValue(this._value,this._loc);
_c35();
}else{
if(_c33===true){
_c36(this);
_c35();
}else{
var _c38=false;
var _c39=null;
var _c3a=_c22;
if(this._values[this._targetValueIndex].readOnly&&this._editor.editorID!="davinci.themeEdit.ThemeEditor"){
var _c3b="<a href='app/docs/index.html#CreatingStyleRulesWithAppCss' target='_blank'>"+_c3a.creatingStyleRules+"</a>";
var _c39=_c3a.propChangeCannotComplete+"<br><br>"+dojo.string.substitute(_c3a.toChangeProperty,[_c3b])+"<br/><br/>";
davinci.Workbench.showMessage(_c3a.errorModifyingValue,_c39,{width:350},dojo.hitch(this,function(){
_c35();
return true;
}));
if(_c32){
_c32.askUserResponse=false;
}
this._setFieldValue(this._value,this._loc);
}else{
if((this._values[this._targetValueIndex].type=="theme"||this._values[this._targetValueIndex].proposalTarget=="theme")&&_c2f.cssOverrideWarn&&this._editor.supports("MultiPropTarget")){
require(["davinci/ve/widgets/ChangeWillModify"],dojo.hitch(this,function(_c3c){
function _c3d(){
if(_c32){
_c32.askUserResponse=true;
}
_c36(this);
_c35();
if(cwm.checkbox.get("checked")){
_c2f.cssOverrideWarn=false;
_c1b.savePreferences("davinci.ve.editorPrefs",null,_c2f);
}
};
var cwm=new _c3c();
var _c3e=davinci.Workbench.showDialog({title:"",content:cwm,style:{width:350},okCallback:dojo.hitch(this,_c3d),okLabel:null,hideCancel:null,submitOnEnter:true});
dojo.connect(_c3e,"onCancel",dojo.hitch(this,function(){
if(_c32){
_c32.askUserResponse=false;
}
this._setFieldValue(this._value,this._loc);
_c35();
if(cwm.checkbox.get("checked")){
_c2f.cssOverrideWarn=false;
_c1b.savePreferences("davinci.ve.editorPrefs",null,_c2f);
}
}));
}));
}else{
_c36(this);
_c35();
}
}
}
}
},_changeValue:function(_c3f,_c40){
var _c41=undefined;
if(this._whichStateInputElement&&this._whichStateInputElement.checked){
_c41=this._whichState;
}
var _c42=this._values[_c3f];
var _c43=[];
for(var i=0;i<this.target.length;i++){
if(dojo.isArray(_c40)){
for(var k=0;k<_c40.length;k++){
var a={};
a[this.target[i]]=_c40[k];
_c43.push(a);
}
}else{
var a={};
a[this.target[i]]=_c40;
_c43.push(a);
}
}
this._dirtyCascadeList=true;
if(_c42.type=="element.style"){
if(this.target[0]=="position"&&_c43.length==1){
if(_c43[0]["position"]=="absolute"){
var _c44=this.context.getPreference("absoluteWidgetsZindex");
_c43.push({"z-index":_c44});
}else{
_c43.push({"z-index":""});
}
}
dojo.publish("/davinci/ui/styleValuesChange",[{values:_c43,appliesTo:"inline",applyToWhichStates:_c41}]);
}else{
dojo.publish("/davinci/ui/styleValuesChange",[{values:_c43,appliesTo:_c42,applyToWhichStates:_c41}]);
}
},_getAttribStyleValue:function(){
return this.context.getStyleAttributeValues(this._widget);
},_getShortHands:function(){
if(this._shorthands){
return this._shorthands;
}
this._shorthands=[];
for(var i=0;i<this.target.length;i++){
this._buildShortHands(this.target[i]);
}
return this._shorthands;
},_buildShortHands:function(_c45){
var _c46=false;
for(var j=0;j<_c1d.shorthand.length;j++){
if(_c45==_c1d.shorthand[j][0]){
_c46=true;
break;
}
}
if(_c46){
var _c47=_c1d.shorthand[j][1];
for(var i=0;i<_c47.length;i++){
var _c48=false;
for(var j=0;j<this._shorthands.length&&!_c48;j++){
if(this._shorthands[j]==_c47[i]){
_c48=true;
}
}
if(!_c48){
this._shorthands.push(_c47[i]);
}
this._buildShortHands(_c47[i]);
}
}
return this._shorthands;
},_onChangeOverride:function(e){
alert(_c22.valueIsOverriden);
return false;
},_getSelector:function(_c49,_c4a){
var _c4b=this.context.getThemeMeta();
if(!_c4b){
return [];
}
var _c4c="Normal";
var _c4d=_c4b.loader.getType(_c49),_c4e=_c4b.metadata.getStyleSelectors(_c4d,_c4c);
if(_c4e){
for(var name in _c4e){
for(var i=0;i<_c4e[name].length;i++){
for(var s=0;s<_c4a.length;s++){
if(_c4a[s]==_c4e[name][i]){
return name;
}
}
}
}
}
},_getMetaTargets:function(_c4f,_c50){
var name=this._getSelector(_c4f,_c50),_c51=this.context.getModel().getRule(name);
return _c51.filter(function(rule){
return rule.getSelectorText()==name;
});
},_getSelectionCssRules:function(_c52){
this.context._cssCache=this.context._cssCache||{};
var _c53=function(node){
return node.id+"_"+node.className;
};
var _c54=this.context.getSelection();
if(!_c52&&!_c54.length){
return {rules:null,matchLevels:null};
}
var _c55=_c52||_c54[0].domNode||_c54[0],_c56=_c53(_c55);
if(_c54.length){
var _c57=this.context._cssCache[_c56]=this.context.model.getMatchingRules(_c55,true);
if(this.context.cssFiles){
this.context.cssFiles.forEach(function(file){
file.getMatchingRules(_c55,_c57.rules,_c57.matchLevels);
});
}
_c57.rules.forEach(function(rule){
var _c58=dojo.hitch(rule,"onChange",this,function(){
delete this.context._cssCache[_c56];
connect.unsubscribe(_c58);
});
},this);
return _c57;
}
return {rules:null,matchLevels:null};
},_getAllRules:function(){
function _c59(rule){
if(rule&&rule.parent&&rule.parent.url){
var url=rule.parent.url;
if(/^themes\//.test(url)||/\/themes\//.test(url)){
return "theme";
}else{
return "queried";
}
}
};
var _c5a=[];
if(this._editor.editorID!="davinci.themeEdit.ThemeEditor"){
var _c5b=this._getDefaultSelection();
if(this._editor.supports("inline-style")&&(_c5b=="element.style")){
var _c5c=this._getAttribStyleValue();
var _c5d=null;
for(var _c5e=0;_c5e<_c5c.length;_c5e++){
var _c5f=_c5c[_c5e];
for(var t=0;t<this.target.length;t++){
var name=this.target[t];
if(_c5f[name]!==undefined){
_c5d=_c5f[name];
}
}
}
_c5a.push({rule:_c5c,value:_c5d,matchLevel:"element.style",type:"element.style"});
}
var v=this._getSelectionCssRules(this._topWidgetDom);
if(v&&v.rules){
for(var i=0;i<v.rules.length;i++){
var s="";
var rule=v.rules[i];
for(var j=0;j<rule.selectors.length;j++){
if(j!=0){
s+=", ";
}
s+=rule.selectors[j].getLabel();
}
var _c60=_c59(rule);
_c5a.push({rule:v.rules[i],ruleString:s,matchLevel:v.matchLevels[i],type:_c60});
}
}
var _c61=this._addDeltaRules(this._widget,_c5a);
var _c62=this._getClasses(this._widget);
var _c63=0;
for(var i=0;i<_c62.length;i++){
var _c64=_c62[i];
if(typeof _c64=="string"&&_c64.length>0){
var _c65=this._getClassSelector(_c64);
_c65.forEach(function(_c66){
var _c67=false;
for(var j=0;j<_c5a.length;j++){
if(this._compareSelectors(_c5a[j].ruleString,_c66)){
_c5a[j].className=_c64;
_c67=true;
break;
}
}
if(!_c67){
var _c68=this._computeMatchLevelSelector(_c66);
_c5a.splice(_c63,0,{rule:null,ruleString:_c66,targetFile:this.targetFile,className:_c64,value:null,matchLevel:_c68,type:"proposal"});
_c63++;
}
}.bind(this));
}
}
}
if(this._editor.editorID=="davinci.themeEdit.ThemeEditor"){
v=this._editor._getCssRules(this._widget,this._editor._selectedSubWidget,this._editor._currentState);
if(v){
var t=[];
for(var x=v.length-1;x>-1;--x){
t.push(v[x]);
}
v=t;
}
}else{
if(this._widget){
v=this._getMetaTargets(this._widget,this.target);
}else{
v=[];
}
}
for(var i=0;i<v.length;i++){
var _c69=false;
for(var k=0;!_c69&&k<_c5a.length;k++){
if(_c5a[k].rule==v[i]){
_c69=true;
_c5a[k].type="theme";
}
}
if(!_c69){
_c5a.push({rule:v[i],matchLevel:"theme",type:"theme"});
}
}
return _c5a;
},_buildCssRuleset:function(){
var _c6a=this._getAllRules();
this._values=[];
this._hasOverride=false;
var _c6b=this.target[0];
var _c6c=this._getShortHands();
for(var i=0;i<_c6a.length;i++){
var rule=_c6a[i].rule;
if(rule){
for(var k=0;k<_c6c.length;k++){
if(_c6a[i].type!="element.style"&&_c6a[i].rule.getProperty(_c6c[k])!=null){
_c6a[i].shorthand=_c6c[k];
var prop=rule.getProperty(_c6c[k]);
_c6a[i].value=prop&&prop.value;
this._hasOverride=true;
}else{
if(_c6a[i].type=="element.style"&&dojo.indexOf(_c6a[i].rule,_c6c[k])>-1){
_c6a[i].shorthand=_c6c[k];
var _c6d=dojo.indexOf(_c6a[i].rule,_c6c[k]);
_c6a[i].value=rule[_c6d];
this._hasOverride=true;
}
}
}
if(!_c6a[i].shorthand&&_c6a[i].type!="element.style"){
_c6a[i].value=this._getRuleTargetValue(rule);
}else{
if(!_c6a[i].shorthand&&_c6a[i].type=="element.style"){
for(var kk=0;kk<rule.length;kk++){
if(rule[kk].hasOwnProperty(this.target[0])){
_c6a[i].value=rule[kk][this.target[0]];
}
}
}
}
}else{
}
}
_c6a=this._sortRules(_c6a);
this._addClasses(_c6a);
this._values=_c6a;
},_sortRules:function(_c6e){
var _c6f=[];
for(var i=0;i<_c6e.length;i++){
var _c70=false;
if(_c6e[i].type=="element.style"){
_c6f.splice(0,0,_c6e[i]);
_c70=true;
}
for(var k=0;!_c70&&k<_c6f.length;k++){
if(_c6f[k].matchLevel!="element.style"&&_c6f[k].matchLevel<_c6e[i].matchLevel){
_c70=true;
_c6f.splice(k,0,_c6e[i]);
}
}
if(!_c70){
_c6f.push(_c6e[i]);
}
}
return _c6f;
},_addClasses:function(_c71){
var _c72=null;
var _c73=false;
for(var i=0;i<_c71.length;i++){
_c71[i].extraClass=[];
if(_c73){
_c71[i].extraClass.push("cssShorthandOverRidden");
}
if(_c71[i].value||(_c71[i].type!="element.style"&&this._getRuleTargetValue(_c71[i].rule))){
_c73=true;
}else{
if(!_c71[i].value&&_c71[i].type!="element.style"){
_c71[i].extraClass.push("hiddenCascadeNode");
}
}
if(_c71[i].type=="element.style"&&!_c71[i].value){
_c71[i].extraClass.push("elementStyleNode");
}
if(!this._canModifyRule(_c71[i].rule)){
_c71[i].extraClass.push("readOnlyRule");
_c71[i].readOnly=true;
}
}
},_updateCascadeList:function(){
if(this._setFieldValue){
this._setFieldValue("",null);
}
if(!this._widget||!this._widget.domNode){
dojo.addClass(this.container,"dijitHidden");
return;
}
dojo.removeClass(this.container,"dijitHidden");
this._buildCssRuleset();
function _c74(_c75){
return function(){
return this._onChange({target:_c75});
};
};
function _c76(_c77){
return function(){
return this._onChangeRemove({target:_c77});
};
};
this._destroy();
var _c78=dojo.doc.createElement("table");
dojo.addClass(_c78,"cascadeTable");
var row=null;
var _c79=null;
row=dojo.doc.createElement("tr");
row.className="propApplyToLabelRow";
_c79=dojo.doc.createElement("td");
_c79.colSpan="3";
_c79.innerHTML=_c22.applyToWhich;
_c79.className="propApplyToLabelCell";
row.appendChild(_c79);
_c78.appendChild(row);
this._radio=[];
for(var i=0;i<this._values.length;i++){
var _c7a=this._formatRuleString(this._values[i]);
this._radio.push(dojo.create("input",{type:"radio",name:this._radioGroupName}));
row=dojo.doc.createElement("tr");
for(var j=0;j<this._values[i].extraClass.length;j++){
dojo.addClass(row,this._values[i].extraClass[j]);
}
_c79=dojo.doc.createElement("td");
row.appendChild(_c79);
dojo.addClass(_c79,"cascadeSpacer");
_c79=dojo.doc.createElement("td");
dojo.addClass(_c79,"cascadeButton");
_c79.appendChild(this._radio[this._radio.length-1]);
row.appendChild(_c79);
_c79=dojo.doc.createElement("td");
dojo.addClass(_c79,"cascadText");
_c79.innerHTML="<div class='cascadeRuleText'>"+_c7a+"</div>";
if(!this._values[i].shorthand){
this._handles.push(dojo.connect(this._radio[this._radio.length-1],"onclick",this,_c74(i)));
}else{
this._handles.push(dojo.connect(this._radio[this._radio.length-1],"onclick",this,"_onChangeOverride"));
}
if(this._values[i].shorthand){
_c79.innerHTML+="<div>"+this._values[i].shorthand+":"+this._values[i].value+";"+"</div>";
}else{
if(this._values[i].value){
var _c7b="";
for(var j=0;j<this.target.length;j++){
_c7b+=this.target[j]+(j-1==this.target.length?",":"");
}
_c79.innerHTML+="<div class='ruleValue'>"+this.target[0]+":"+this._values[i].value+";"+"</div>";
}
}
row.appendChild(_c79);
_c79=dojo.doc.createElement("td");
dojo.addClass(_c79,"cascadRemove");
var _c7c=dojo.doc.createElement("button");
if(this._values[i].readOnly){
dojo.attr(_c7c,"disabled","true");
}
dojo.addClass(_c7c,"cascadeRemoveButton");
_c79.appendChild(_c7c);
this._handles.push(dojo.connect(_c7c,"onclick",this,_c76(i)));
row.appendChild(_c79);
_c79=dojo.doc.createElement("td");
_c79.className="cascadeSpacer";
row.appendChild(_c79);
_c78.appendChild(row);
}
this._widgetState=this._whichStateInputElement=undefined;
var _c7d=_c22;
var node=this._widget.domNode;
var _c7e=_c21.getStatesListCurrent(node);
for(var i=0;i<_c7e.length;i++){
if(_c7e[i]){
var _c7f=_c7e[i];
row=dojo.doc.createElement("tr");
row.className="propWhichStateRow";
_c79=dojo.doc.createElement("td");
_c79.colSpan="3";
var _c80=dojo.create("input",{type:"checkbox",checked:false,className:"propWhichStateInput"});
this._whichState=_c7f;
this._whichStateInputElement=_c80;
_c79.appendChild(_c80);
var _c81=dojo.create("label",{className:"propWhichStateLabel"});
_c81.innerHTML=dojo.string.substitute(_c7d.onlyApplyToState,[_c7f]);
_c79.appendChild(_c81);
_c79.className="propWhichStateCell";
row.appendChild(_c79);
_c78.appendChild(row);
break;
}
}
this.cascadeTableDiv.appendChild(_c78);
this._updateFieldValue();
},selectRule:function(rule){
for(var i=0;i<this._values.length;i++){
if(rule!="element.style"&&this._values[i].rule==rule){
dojo.removeClass(this._radio[i].parentNode.parentNode,"hiddenCascadeNode");
dojo.attr(this._radio[i],"checked",true);
this._onChange({target:i});
break;
}else{
if(rule=="element.style"&&this._values[i].type=="element.style"){
dojo.removeClass(this._radio[i].parentNode.parentNode,"hiddenCascadeNode");
dojo.attr(this._radio[i],"checked",true);
this._onChange({target:i});
break;
}
}
}
},selectRuleBySelector:function(_c82){
if(_c82=="element.style"){
this._targetValueIndex=0;
if(this._values.length>0){
dojo.attr(this._radio[0],"checked",true);
if(this._values[0].shorthand){
dojo.addClass(this._radio[0].parentNode.parentNode,"cssShorthandOverRidden");
}else{
var loc=this._getBaseLocation();
this._setFieldValue(this._values[0].value,loc);
}
}
return;
}
for(var i=0;i<this._values.length;i++){
if(this._values[i].type!="element.style"&&this._values[i].rule&&this._values[i].rule.hasSelector(_c82)){
dojo.removeClass(this._radio[i].parentNode.parentNode,"hiddenCascadeNode");
dojo.attr(this._radio[i],"checked",true);
this._onChange({target:i});
break;
}
}
},_isTarget:function(t){
if(t==="$std_10"){
return true;
}
for(var i=0;i<this.target.length;i++){
if(this.target[i]==t){
return true;
}
}
return false;
},_targetIsRootProperty:function(){
var _c83=["left","top","right","bottom"];
for(var i=0;i<this.target.length;i++){
if(_c83.indexOf(this.target[i])>-1){
return true;
}
}
return false;
},_updateFieldValue:function(){
function _c84(_c85){
if(_c85&&_c85.rule&&_c85.rule.getCSSFile){
return _c23.findResource(_c85.rule.getCSSFile().url).readOnly();
}else{
return false;
}
};
if(this._widget==null){
this._setFieldValue("",this._getBaseLocation());
}
var _c86=this._getDefaultSelection();
this._targetValueIndex=0;
var _c87=false;
var _c88=false;
for(var i=0;i<this._values.length;i++){
var _c89=(this._editor.editorID=="davinci.ve.HTMLPageEditor");
var _c8a=(this._editor.editorID=="davinci.themeEdit.ThemeEditor");
if((this._values[i].value&&!_c87&&_c8a)||(this._values[i].value&&!_c87&&_c89&&!this._values[i].readOnly)||(!_c87&&!_c88&&this._values[i].type!="element.style"&&this._values[i].rule&&this._values[i].rule.hasSelector(_c86))||(_c86=="element.style"&&this._values[i].type=="element.style")){
var _c8b=this._values[i].type=="element.style"?"element.style":this._values[i].rule;
this.selectRule(_c8b);
if(this._values[i].value){
_c87=true;
}
_c88=true;
}else{
if(_c87&&!_c88){
dojo.addClass(this._radio[i].parentNode.parentNode,"cssOverRidden");
}
}
}
if(!_c87&&!_c88&&_c89){
this.selectRuleBySelector("element.style");
}
},_getThemeMetaDataByWidget:function(_c8c){
var _c8d=this.context.getThemeMeta();
if(!_c8d){
return null;
}
var _c8e=_c8d.loader.getType(_c8c);
var meta=_c8d.loader.getMetaData(_c8e);
var _c8f=false;
var _c90=(typeof _c8e=="string")?_c8e.split("."):null;
if(_c90&&_c90[0]=="html"){
_c8f=true;
}
if(!meta&&this.context.cssFiles&&!_c8f){
for(var i=0;i<this.context.cssFiles.length;i++){
var _c91=_c1f.getThemeByCssFile(this.context.cssFiles[i]);
if(_c91){
var _c92=_c1e.getThemeMetadata(_c91);
meta=_c92.loader.getMetaData(_c8e);
if(meta){
break;
}
}
}
}
return meta;
},_getDefaultSelection:function(){
var _c93="Normal";
if(this._editor.editorID=="davinci.themeEdit.ThemeEditor"){
_c93=_c93||_c21.getState();
}
var meta=this._getThemeMetaDataByWidget(this._widget);
if(!meta||!meta.states){
return "element.style";
}
if(this._targetIsRootProperty()){
return "element.style";
}
if(meta&&meta.states[_c93]&&meta.states[_c93].elements){
var md=meta.states[_c93].elements;
for(var name in md){
for(var p=0;p<md[name].length;p++){
if(this._isTarget(md[name][p])){
if(name=="$root"){
return "element.style";
}else{
return name;
}
}
}
}
}
if(meta&&meta.states[_c93]){
var _c94=this.context.getThemeMeta();
if(_c94){
var _c95=_c94.loader.getType(this._widget);
var md=_c94.metadata.getStyleSelectors(_c95,_c93,null);
if(md){
for(var name in md){
for(var c=0;c<md[name].length;c++){
if(this._isTarget(md[name][c])){
if(meta.rootSelectors){
for(var i=0;i<meta.rootSelectors.length;i++){
if(name==meta.rootSelectors[i]){
return "element.style";
}
}
}
return name;
}
}
}
}
}
}
return null;
},_addDeltaRules:function(_c96,_c97){
var _c98="Normal";
var _c99=-1;
var _c9a=[];
var _c9b=this.context._getCssFiles();
var _c9c=(_c9b&&_c9b.length>0)?_c9b[0].url:null;
var _c9d=false;
if(_c9c){
var file=_c23.findResource(_c9c);
_c9d=file._readOnly;
}
if(this._editor.editorID=="davinci.themeEdit.ThemeEditor"){
_c98=_c98||_c21.getState();
}
var meta=this._getThemeMetaDataByWidget(_c96);
if(meta&&meta.states[_c98]&&meta.states[_c98].selectors){
var md=meta.states[_c98].selectors;
for(var name in md){
var _c9e=false;
for(var i=0;i<_c97.length;i++){
var r=_c97[i];
if(r.type==="element.style"){
_c99=i;
}
if(r.type==="theme"&&r.ruleString===name&&(r.rule.parent.relativeURL==this.context._themeUrl||r.rule.parent.url==_c9c)){
_c9e=true;
break;
}
}
if(!_c9e){
var _c9f=this._computeMatchLevelSelector(name);
if(_c9c&&!_c9d){
_c9a.push({rule:null,ruleString:name,targetFile:_c9c,className:null,value:null,matchLevel:_c9f,type:"proposal"});
}
if(this.context._themeUrl&&!this.context.theme.getFile().readOnly()){
_c9a.push({rule:null,ruleString:name,targetFile:this.context._themeUrl,className:null,value:null,matchLevel:_c9f,type:"proposal",proposalTarget:"theme"});
}
}
}
}
var n=_c99+1;
_c9a.forEach(function(item){
_c97.splice(n++,0,item);
});
return _c97;
},_getRuleTargetValue:function(rule){
var _ca0=null;
if(rule){
for(var i=0;!_ca0&&i<this.target.length;i++){
_ca0=rule.getProperties(this.target[i]);
}
}
if(_ca0!=null){
if(_ca0.length>1){
var _ca1=[];
for(var i=0;i<_ca0.length;i++){
_ca1.push(_ca0[i].value);
}
return _ca1;
}else{
if(_ca0.length==1){
return _ca0[0].value;
}
}
}
return null;
},_onChangeRemove:function(_ca2){
var _ca3=_ca2.target;
this._changeValue(_ca3,null);
this._updateCascadeList();
},_onChange:function(_ca4){
var loc=null;
if(this._values[_ca4.target].type=="element.style"){
loc=this._getBaseLocation();
}else{
if(this._values[_ca4.target].type=="proposal"){
var _ca5=this.context.getModel();
var _ca6=_ca5.find({elementType:"CSSFile",relativeURL:this._values[_ca4.target].targetFile},true);
var _ca7=this.context._getCssFiles();
if(_ca6){
loc=_c23.findResource(_ca6.url);
}else{
if(_ca7[0].url==this._values[_ca4.target].targetFile){
loc=_c23.findResource(_ca7[0].url);
}
}
}else{
loc=_c23.findResource(this._values[_ca4.target].rule.getCSSFile().url);
}
}
this._setFieldValue(this._values[_ca4.target].value||"",loc);
this._targetValueIndex=_ca4.target;
},_widgetValuesChanged:function(_ca8){
if(this._dirtyCascadeList){
this._updateCascadeList();
this._dirtyCascadeList=false;
}else{
var _ca9=this._getShortHands();
var _caa=_ca8.values;
for(var name in _caa){
for(var i=0;i<_ca9.length;i++){
if(_ca9[i]==name){
this._updateCascadeList();
return;
}
}
}
}
},_formatRuleString:function(r){
var _cab=_c22;
if(r.type=="element.style"){
return "element.style";
}
var s="";
if(r.type=="proposal"){
if(r.className){
s+=dojo.string.substitute(_cab.newRule,[r.className,r.targetFile]);
}else{
s+=dojo.string.substitute(_cab.newThemeRule,[r.targetFile]);
}
s+=r.ruleString;
}else{
var rule=r.rule;
if(r.className){
s+=dojo.string.substitute(_cab.existingRule,[r.className,this.targetFile]);
}else{
if(r.type=="theme"){
s+="["+r.type+"] ";
}
}
if(r.ruleString){
s+=r.ruleString;
}else{
for(var i=0;i<rule.selectors.length;i++){
if(i!=0){
s+=", ";
}
s+=rule.selectors[i].getLabel();
}
}
var file=rule.searchUp("CSSFile");
if(file){
s+="  ("+file.url||file.relativeURL;
}
if(r.property){
s+=dojo.string.substitute(_cab.line,[r.property.startLine]);
}else{
s+=dojo.string.substitute(_cab.line,[rule.startLine||_cab.propUndefined]);
}
}
return s;
},_getWidgetTopDom:function(_cac,_cad){
var _cae=this._getSelector(_cac,_cad);
var _caf=function(_cb0,rule){
if(rule.matches(_cb0)){
return _cb0;
}
for(var i=0;i<_cb0.children.length;i++){
return _caf(_cb0.children[i],rule);
}
};
if(_cae){
var rule=new _c20();
rule.setText(_cae+"{}");
return _caf(_cac.domNode||_cac,rule);
}
return null;
},_widgetSelectionChanged:function(_cb1){
var _cb2=_cb1[0];
this._widget=_cb2;
if(this._widget){
this.context=_cb2.getContext();
this.targetFile=this.context.getAppCssRelativeFile();
this._editor=this.context.editor;
this._topWidgetDom=this._getWidgetTopDom(this._widget,this.target)||this._widget.domNode||this._widget;
}else{
this._topWidgetDom=null;
}
this._updateCascadeList();
},_getBaseLocation:function(){
return _c23.findResource(this._editor.getContext().getDocumentLocation());
},_editorSelected:function(_cb3){
this._editor=_cb3.editor;
var _cb4;
if(this._editor&&this._editor.getContext){
_cb4=this._editor.getContext();
}
if(_cb4&&this._editor.supports("style")){
this.context=_cb4;
this.targetFile=_cb4.getAppCssRelativeFile();
var v=_cb4.getSelection();
if(v.length>0){
this._widgetSelectionChanged(v);
}else{
this._widgetSelectionChanged([]);
}
}else{
this.context=null;
this._widget=null;
if(this._setFieldValue){
this._setFieldValue("",null);
}
}
this._updateCascadeList();
},_onFieldFocus:function(){
if(this.context){
this.context.blockChange(true);
}
},_destroy:function(){
var _cb5=(this.cascadeTableDiv);
dojo.forEach(dojo.query("[widgetId]",_cb5).map(dijit.byNode),function(w){
w.destroy();
});
while(_cb5.firstChild){
dojo._destroyElement(_cb5.firstChild);
}
dojo.forEach(this._handles,dojo.disconnect);
this._handles=[];
},_onFieldBlur:function(){
if(this.context){
this.context.blockChange(false);
}
},_getClasses:function(_cb6){
var _cb7=_cb6.getClassNames("class")||"";
_cb7=_cb7.split(" ");
for(var i=0;i<_cb7.length;i++){
for(var j=i+1;j<_cb7.length;j++){
if(_cb7[j]==_cb7[i]){
_cb7.splice(j,1);
}
}
}
return _cb7;
},_getRelativeMetaTargetSelector:function(_cb8){
var _cb9=this.context.getThemeMeta();
if(!_cb9){
return [];
}
var _cba="Normal";
var _cbb=this.context.getSelection();
if(!_cbb.length){
return [];
}
_cbb=_cbb[0];
var _cbc=_cb9.loader.getType(_cbb);
return _cb9.metadata.getRelativeStyleSelectorsText(_cbc,_cba,null,_cb8,this.context.getTheme().className);
},_getClassSelector:function(_cbd){
var rel=this._getRelativeMetaTargetSelector(this.target);
var text=rel.length?rel[0]:"";
var _cbe=this.context.model.find({elementType:"HTMLElement",tag:"body"},true),id=_cbe.find({elementType:"HTMLAttribute",name:"id"},true);
bodyId=id.value;
var _cbf=this.context.getTheme();
var _cc0=[];
if(!_cbf){
return _cc0;
}
var _cc1=_cbf.className;
var _cc2=text.split(",");
_cc2.forEach(function(_cc3){
_cc3=_cc3.trim();
_cc0.push("#"+bodyId+"."+_cc1+" ."+_cbd+_cc3);
}.bind(this));
return _cc0;
},_computeMatchLevelSelector:function(_cc4){
var _cc5=_cc4.split(this._regex_combinators);
var _cc6=0;
for(var i=0;i<_cc5.length;i++){
var ss=_cc5[i];
while(true){
var _cc7=ss.match(this._regex_not_pseudoclass);
if(_cc7!=null){
_cc6+=this._computeMatchLevelSimpleSelector(_cc7[2]);
ss=_cc7[1]+_cc7[3];
}else{
break;
}
}
_cc6+=this._computeMatchLevelSimpleSelector(ss);
}
return _cc6;
},_computeMatchLevelSimpleSelector:function(ss){
var _cc8=0;
do{
var _cc9=false;
function _cca(_ccb,_ccc){
var _ccd=ss.match(_ccb);
if(_ccd!=null){
_cc9=true;
_cc8+=_ccc;
ss=_ccd[1]+_ccd[3];
}
};
_cca(this._regex_pseudoelement,1);
if(!_cc9){
_cca(this._regex_id,100);
_cca(this._regex_class,10);
_cca(this._regex_attribute,10);
_cca(this._regex_pseudoclass,10);
_cca(this._regex_univeral,0);
}
}while(_cc9);
if(ss.length>0){
_cc8+=1;
}
return _cc8;
},_compareSelectors:function(_cce,_ccf){
if((!_cce||!_ccf)&&_cce!=_ccf){
return false;
}
var _cd0=_cce.split(this._regex_combinators);
var _cd1=_ccf.split(this._regex_combinators);
if(_cd0.length!=_cd0.length){
return false;
}
for(var i=0;i<_cd0.length;i++){
var ss1=_cd0[i];
var ss2=_cd1[i];
if(ss1!=ss2){
return false;
}
}
return true;
},_compareSimpleSelectors:function(ss1,ss2){
}});
return dojo.mixin(_c24,{__id:0});
});
},"davinci/html/ui/ImageViewer":function(){
define("davinci/html/ui/ImageViewer",[],function(){
var _cd2=function(_cd3){
this.element=_cd3;
};
_cd2.prototype={isReadOnly:true,save:function(){
},getDefaultContent:function(){
},supports:function(_cd4){
return false;
},setContent:function(_cd5,_cd6){
this.fileName=_cd5;
this.element.innerHTML="<div style='overflow:auto'>"+"<img src='"+encodeURI(this.resourceFile.getURL())+"'/>"+"</div>";
this.dirty=false;
},destroy:function(){
},getOnUnloadWarningMessage:function(){
return null;
}};
return _cd2;
});
},"davinci/review/model/resource/Folder":function(){
define("davinci/review/model/resource/Folder",["dojo/_base/declare","davinci/model/resource/Resource","davinci/review/model/resource/File","dojo/_base/xhr","dojo/date/stamp"],function(_cd7,_cd8,_cd9,xhr,_cda){
return _cd7("davinci.review.model.resource.Folder",_cd8,{isDraft:false,closed:false,width:0,height:0,constructor:function(proc){
dojo.mixin(this,proc);
this.elementType="ReviewVersion";
this.dueDate=this.dueDate=="infinite"?this.dueDate:_cda.fromISOString(this.dueDate);
},getChildrenSync:function(_cdb,sync){
this.getChildren(_cdb);
},getChildren:function(_cdc,_cdd){
if(this._isLoaded){
_cdc.call(null,this.children);
}else{
if(this._loading){
this._loading.then(function(){
_cdc.call(null,this.children);
}.bind(this),_cdd);
}else{
var _cde=this.designerId||"";
this._loading=xhr.get({url:"cmd/listReviewFiles",handleAs:"json",content:{designer:_cde,version:this.timeStamp}}).then(function(_cdf,_ce0){
this.children=_cdf.map(function(file){
return new _cd9(file.path,this);
},this);
this._isLoaded=true;
_cdc.call(null,this.children);
delete this._loading;
}.bind(this),_cdd);
}
}
},getPath:function(){
if(this.parent){
return this.parent.getPath()+"/"+this.timeStamp;
}
return this.timeStamp;
}});
});
},"url:davinci/ui/widgets/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"toggleNode\" class=\"dijitInline dvOutlineToggleNode dvOutlineVisibility dvOutlineVisibilityOn\" dojoAttachEvent=\"onclick:_onToggleClick\"></div\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow dijitInline\" role=\"presentation\"\n\t\t><div data-dojo-attach-point=\"indentNode\" class=\"dijitInline\"></div\n\t\t><img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"expandoNode\" class=\"dijitTreeExpando\" role=\"presentation\"\n\t\t><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"\n\t\t></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" data-dojo-attach-point=\"iconNode\" class=\"dijitIcon dijitTreeIcon\" role=\"presentation\"\n\t\t\t/><img src=\"${_blankGif}\" alt=\"\" class=\"treeReadOnlyLabelNode\" role=\"presentation\"\n\t\t\t/><span data-dojo-attach-point=\"labelNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","dojox/grid/_RowSelector":function(){
define("dojox/grid/_RowSelector",["dojo/_base/declare","./_View"],function(_ce1,_ce2){
return _ce1("dojox.grid._RowSelector",_ce2,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){
this.inherited("buildRendering",arguments);
this.scrollboxNode.style.overflow="hidden";
this.headerNode.style.visibility="hidden";
},getWidth:function(){
return this.viewWidth||this.defaultWidth;
},buildRowContent:function(_ce3,_ce4){
var w=this.contentWidth||0;
_ce4.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";
},renderHeader:function(){
},updateRow:function(){
},resize:function(){
this.adaptHeight();
},adaptWidth:function(){
if(!("contentWidth" in this)&&this.contentNode&&this.contentNode.offsetWidth>0){
this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;
}
},doStyleRowNode:function(_ce5,_ce6){
var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];
if(this.grid.rows.isOver(_ce5)){
n.push("dojoxGridRowbarOver");
}
if(this.grid.selection.isSelected(_ce5)){
n.push("dojoxGridRowbarSelected");
}
_ce6.className=n.join(" ");
},domouseover:function(e){
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}});
});
},"orion/editor/textMateStyler":function(){
define("orion/editor/textMateStyler",["orion/editor/regex"],function(_ce7){
var _ce8;
function _ce9(_cea,_ceb,_cec){
var _ced="";
var _cee=_ceb.textView._parent;
var _cef=_cee.ownerDocument;
var _cf0=_ceb._stylesheet=_ceb.util.createElement(_cef,"style");
_cf0.appendChild(_cef.createTextNode(_ceb._styleSheet(_cea,_ced,_ceb.util)));
var head=_cef.getElementsByTagName("head")[0]||_cef.documentElement;
head.appendChild(_cf0);
_ceb.textView.update(true);
};
function _cf1(_cf2,util){
var _cf3;
var _cf4="JavaScript Editor";
var self=this;
_cf2.getPreferences("/settings",2).then(function(_cf5){
var data=_cf5.get(_cf4);
if(data!==undefined){
_cf3=JSON.parse(_cf5.get(_cf4));
if(!_cf3){
return;
}
if(self._stylesheet){
self._stylesheet.parentNode.removeChild(self._stylesheet);
self._stylesheet=null;
}
self._update(_cf3,self,util);
}
});
};
function _cf6(_cf7,_cf8){
var _cf9=[];
for(var _cfa=0;_cfa<_cf7.length;_cfa++){
_cf9[_cf7[_cfa].element]=_cf7[_cfa].value;
}
var _cfb=[];
_cfb.push("");
var _cfc=_cf9["fontFamily"];
if(_cfc==="sans serif"){
_cfc="\"Menlo\", \"Consolas\", \"Vera Mono\", \"monospace\"";
}else{
_cfc="monospace";
}
_cfb.push(_cf8+" .textviewContainer {");
_cfb.push("\background-color:"+_cf9["background"]+";");
_cfb.push("\tfont-family: "+_cfc+";");
_cfb.push("\tfont-size: "+_cf9["fontSize"]+";");
_cfb.push("\tmin-width: 50px;");
_cfb.push("\tmin-height: 50px;");
_cfb.push("\tcolor: "+_cf9["text"]+";");
_cfb.push("}");
_cfb.push(_cf8+" {");
_cfb.push("\tfont-family: "+_cfc+";");
_cfb.push("\tfont-size: "+_cf9["fontSize"]+";");
_cfb.push("\tcolor: "+_cf9["text"]+";");
_cfb.push("}");
_cfb.push(_cf8+" .textview {");
_cfb.push("\tbackground-color: "+_cf9["background"]+";");
_cfb.push("}");
_cfb.push(_cf8+".ruler.annotations{");
_cfb.push("\tbackground-color: "+"white"+";");
_cfb.push("}");
_cfb.push(_cf8+" .ruler {");
_cfb.push("\tbackground-color: "+_cf9["annotationRuler"]+";");
_cfb.push("}");
_cfb.push(_cf8+" .rulerLines {");
_cfb.push("\tcolor: "+_cf9["lineNumber"]+";");
_cfb.push("\tbackground-color: "+_cf9["annotationRuler"]+";");
_cfb.push("}");
_cfb.push(_cf8+" .rulerLines.even {");
_cfb.push("\tcolor: "+_cf9["lineNumber"]+";");
_cfb.push("\tbackground-color: "+_cf9["annotationRuler"]+";");
_cfb.push("}");
_cfb.push(_cf8+" .rulerLines.odd {");
_cfb.push("\tcolor: "+_cf9["lineNumber"]+";");
_cfb.push("\tbackground-color: "+_cf9["annotationRuler"]+";");
_cfb.push("}");
_cfb.push(_cf8+" .annotationLine.currentLine {");
_cfb.push("\tbackground-color: "+_cf9["currentLine"]+";");
_cfb.push("}");
_cfb.push(_cf8+" .entity-name-tag {");
_cfb.push("color: "+_cf9["keyword"]+";");
_cfb.push("}");
return _cfb.join("\n");
};
var _cfd={unsupported:[{regex:/\(\?[ims\-]:/,func:function(_cfe){
return "option on/off for subexp";
}},{regex:/\(\?<([=!])/,func:function(_cff){
return (_cff[1]==="=")?"lookbehind":"negative lookbehind";
}},{regex:/\(\?>/,func:function(_d00){
return "atomic group";
}}],toRegExp:function(str){
function fail(_d01,_d02){
throw new Error("Unsupported regex feature \""+_d01+"\": \""+_d02[0]+"\" at index: "+_d02.index+" in "+_d02.input);
};
function _d03(str){
var _d04="";
var _d05=false;
var len=str.length;
for(var i=0;i<len;){
var chr=str.charAt(i);
if(!_d05&&chr==="#"){
while(i<len&&chr!=="\r"&&chr!=="\n"){
chr=str.charAt(++i);
}
}else{
if(!_d05&&/\s/.test(chr)){
while(i<len&&/\s/.test(chr)){
chr=str.charAt(++i);
}
}else{
if(chr==="\\"){
_d04+=chr;
if(!/\s/.test(str.charAt(i+1))){
_d04+=str.charAt(i+1);
i+=1;
}
i+=1;
}else{
if(chr==="["){
_d05=true;
_d04+=chr;
i+=1;
}else{
if(chr==="]"){
_d05=false;
_d04+=chr;
i+=1;
}else{
_d04+=chr;
i+=1;
}
}
}
}
}
}
return _d04;
};
var _d06="";
var i;
str=_cfd.processGlobalFlag("x",str,function(_d07){
return _d03(_d07);
});
str=_cfd.processGlobalFlag("i",str,function(_d08){
_d06+="i";
return _d08;
});
for(i=0;i<this.unsupported.length;i++){
var _d09;
if((_d09=this.unsupported[i].regex.exec(str))){
fail(this.unsupported[i].func(_d09),_d09);
}
}
return new RegExp(str,_d06);
},processGlobalFlag:function(flag,str,_d0a){
function _d0b(pat,_d0c){
var _d0d=0,len=pat.length,_d0e=-1;
for(var i=_d0c;i<len&&_d0e===-1;i++){
switch(pat.charAt(i)){
case "\\":
i++;
break;
case "(":
_d0d++;
break;
case ")":
_d0d--;
if(_d0d===0){
_d0e=i;
}
break;
}
}
return _d0e;
};
var _d0f="(?"+flag+")",_d10="(?"+flag+":";
if(str.substring(0,_d0f.length)===_d0f){
return _d0a(str.substring(_d0f.length));
}else{
if(str.substring(0,_d10.length)===_d10){
var _d11=_d0b(str,0);
if(_d11<str.length-1){
throw new Error("Only a "+_d10+") group that encloses the entire regex is supported in: "+str);
}
return _d0a(str.substring(_d10.length,_d11));
}
}
return str;
},hasBackReference:function(_d12){
return (/\\\d+/).test(_d12.source);
},getSubstitutedRegex:function(_d13,sub,_d14){
_d14=(typeof _d14==="undefined")?true:false;
var _d15=_d13.source.split(/(\\\d+)/g);
var _d16=[];
for(var i=0;i<_d15.length;i++){
var term=_d15[i];
var _d17=/\\(\d+)/.exec(term);
if(_d17){
var text=sub[_d17[1]]||"";
_d16.push(_d14?_ce7.escape(text):text);
}else{
_d16.push(term);
}
}
return new RegExp(_d16.join(""));
},groupify:function(_d18,_d19){
var _d1a=1,_d1b=2,_d1c=3,_d1d=4;
var src=_d18.source,len=src.length;
var _d1e=[],_d1f=0,_d20=[],_d21=1,_d22=1;
var _d23=[],_d24={},_d25={};
for(var i=0;i<len;i++){
var _d26=_d1e[_d1e.length-1];
var chr=src.charAt(i);
switch(chr){
case "(":
if(_d26===_d1d){
_d1e.pop();
_d23.push(")");
_d20[_d20.length-1].end=i;
}
var _d27=(i+2<len)?(src.charAt(i+1)+""+src.charAt(i+2)):null;
if(_d27==="?:"||_d27==="?="||_d27==="?!"){
var _d28;
if(_d27==="?:"){
_d28=_d1a;
}else{
_d28=_d1c;
_d1f++;
}
_d1e.push(_d28);
_d20.push({start:i,end:-1,type:_d28});
_d23.push(chr);
_d23.push(_d27);
i+=_d27.length;
}else{
_d1e.push(_d1b);
_d20.push({start:i,end:-1,type:_d1b,oldNum:_d21,num:_d22});
_d23.push(chr);
if(_d1f===0){
_d25[_d22]=null;
}
_d24[_d21]=_d22;
_d21++;
_d22++;
}
break;
case ")":
var _d29=_d1e.pop();
if(_d29===_d1c){
_d1f--;
}
_d20[_d20.length-1].end=i;
_d23.push(chr);
break;
case "*":
case "+":
case "?":
case "}":
var op=chr;
var prev=src.charAt(i-1),_d2a=i-1;
if(chr==="}"){
for(var j=i-1;src.charAt(j)!=="{"&&j>=0;j--){
}
prev=src.charAt(j-1);
_d2a=j-1;
op=src.substring(j,i+1);
}
var _d2b=_d20[_d20.length-1];
if(prev===")"&&(_d2b.type===_d1b||_d2b.type===_d1d)){
_d23.splice(_d2b.start,0,"(");
_d23.push(op);
_d23.push(")");
var _d2c={start:_d2b.start,end:_d23.length-1,type:_d1d,num:_d2b.num};
for(var k=0;k<_d20.length;k++){
_d29=_d20[k];
if(_d29.type===_d1b||_d29.type===_d1d){
if(_d29.start>=_d2b.start&&_d29.end<=_d2a){
_d29.start+=1;
_d29.end+=1;
_d29.num=_d29.num+1;
if(_d29.type===_d1b){
_d24[_d29.oldNum]=_d29.num;
}
}
}
}
_d20.push(_d2c);
_d22++;
break;
}else{
}
default:
if(chr!=="|"&&_d26!==_d1b&&_d26!==_d1d){
if(_d1f===0){
_d1e.push(_d1d);
_d20.push({start:i,end:-1,type:_d1d,num:_d22});
_d23.push("(");
_d25[_d22]=null;
_d22++;
}
}
_d23.push(chr);
if(chr==="\\"){
var peek=src.charAt(i+1);
_d23.push(peek);
i+=1;
}
break;
}
}
while(_d1e.length){
_d1e.pop();
_d23.push(")");
}
var _d2d=new RegExp(_d23.join(""));
var _d2e={};
_d19=_d19||_d24;
for(var prop in _d19){
if(_d19.hasOwnProperty(prop)){
_d2e[prop]="\\"+_d19[prop];
}
}
_d2d=this.getSubstitutedRegex(_d2d,_d2e,false);
return [_d2d,_d24,_d25];
},complexCaptures:function(_d2f){
if(!_d2f){
return false;
}
for(var prop in _d2f){
if(_d2f.hasOwnProperty(prop)){
if(prop!=="0"){
return true;
}
}
}
return false;
}};
function _d30(obj){
var c;
if(obj instanceof Array){
c=new Array(obj.length);
for(var i=0;i<obj.length;i++){
c[i]=_d30(obj[i]);
}
}else{
c={};
for(var prop in obj){
if(Object.prototype.hasOwnProperty.call(obj,prop)){
var _d31=obj[prop];
if(typeof _d31==="object"&&_d31!==null){
c[prop]=_d30(_d31);
}else{
c[prop]=_d31;
}
}
}
}
return c;
};
function _d32(_d33,_d34,_d35,_d36,util){
this.initialize(_d33,_d36);
this.grammar=_d30(_d34);
this.externalGrammars=_d35?_d30(_d35):[];
this._styles={};
this._tree=null;
this._allGrammars={};
this.preprocess(this.grammar);
this._updateStylesheet=_cf1;
this._update=_ce9;
this._styleSheet=_cf6;
this.util=util;
};
_d32.prototype={initialize:function(_d37,_d38,util){
this.textView=_d37;
this.textView.stylerOptions=this;
var self=this;
if(this.textView&&_d38){
_d38.startup().then(function(core){
_ce8=core.preferences;
self.preferences=_ce8;
self._updateStylesheet(_ce8,util);
self.storageKey=_ce8.listenForChangedSettings(self._listener.onStorage);
});
}
this._listener={onModelChanged:function(e){
self.onModelChanged(e);
},onDestroy:function(e){
self.onDestroy(e);
},onLineStyle:function(e){
self.onLineStyle(e);
},onStorage:function(e){
self.onStorage(e);
}};
_d37.addEventListener("ModelChanged",this._listener.onModelChanged);
_d37.addEventListener("Destroy",this._listener.onDestroy);
_d37.addEventListener("LineStyle",this._listener.onLineStyle);
_d37.redrawLines();
},onDestroy:function(e){
this.destroy();
},onStorage:function(e){
if(e.key===this.storageKey){
this._updateStylesheet(this.preferences);
}
},destroy:function(){
if(this.textView){
this.textView.removeEventListener("ModelChanged",this._listener.onModelChanged);
this.textView.removeEventListener("Destroy",this._listener.onDestroy);
this.textView.removeEventListener("LineStyle",this._listener.onLineStyle);
this.textView=null;
}
this.grammar=null;
this._styles=null;
this._tree=null;
this._listener=null;
},preprocess:function(_d39){
var _d3a=[_d39];
for(;_d3a.length!==0;){
var rule=_d3a.pop();
if(rule._resolvedRule&&rule._typedRule){
continue;
}
rule._resolvedRule=this._resolve(rule);
rule._typedRule=this._createTypedRule(rule);
this.addStyles(rule.name);
this.addStyles(rule.contentName);
this.addStylesForCaptures(rule.captures);
this.addStylesForCaptures(rule.beginCaptures);
this.addStylesForCaptures(rule.endCaptures);
if(rule._resolvedRule!==rule){
_d3a.push(rule._resolvedRule);
}
if(rule.patterns){
for(var i=0;i<rule.patterns.length;i++){
_d3a.push(rule.patterns[i]);
}
}
}
},addStyles:function(_d3b){
if(_d3b&&!this._styles[_d3b]){
this._styles[_d3b]=[];
var _d3c=_d3b.split(".");
for(var i=0;i<_d3c.length;i++){
this._styles[_d3b].push(_d3c.slice(0,i+1).join("-"));
}
}
},addStylesForCaptures:function(_d3d){
for(var prop in _d3d){
if(_d3d.hasOwnProperty(prop)){
var _d3e=_d3d[prop].name;
this.addStyles(_d3e);
}
}
},ContainerRule:(function(){
function _d3f(rule){
this.rule=rule;
this.subrules=rule.patterns;
};
_d3f.prototype.valueOf=function(){
return "aa";
};
return _d3f;
}()),BeginEndRule:(function(){
function _d40(rule){
this.rule=rule;
this.beginRegex=_cfd.toRegExp(rule.begin);
this.endRegex=_cfd.toRegExp(rule.end);
this.subrules=rule.patterns||[];
this.endRegexHasBackRef=_cfd.hasBackReference(this.endRegex);
var _d41=_cfd.complexCaptures(rule.captures);
var _d42=_cfd.complexCaptures(rule.beginCaptures)||_cfd.complexCaptures(rule.endCaptures);
this.isComplex=_d41||_d42;
if(this.isComplex){
var bg=_cfd.groupify(this.beginRegex);
this.beginRegex=bg[0];
this.beginOld2New=bg[1];
this.beginConsuming=bg[2];
var eg=_cfd.groupify(this.endRegex,this.beginOld2New);
this.endRegex=eg[0];
this.endOld2New=eg[1];
this.endConsuming=eg[2];
}
};
_d40.prototype.valueOf=function(){
return this.beginRegex;
};
return _d40;
}()),MatchRule:(function(){
function _d43(rule){
this.rule=rule;
this.matchRegex=_cfd.toRegExp(rule.match);
this.isComplex=_cfd.complexCaptures(rule.captures);
if(this.isComplex){
var mg=_cfd.groupify(this.matchRegex);
this.matchRegex=mg[0];
this.matchOld2New=mg[1];
this.matchConsuming=mg[2];
}
};
_d43.prototype.valueOf=function(){
return this.matchRegex;
};
return _d43;
}()),_createTypedRule:function(rule){
if(rule.match){
return new this.MatchRule(rule);
}else{
if(rule.begin){
return new this.BeginEndRule(rule);
}else{
return new this.ContainerRule(rule);
}
}
},_resolve:function(rule){
var _d44=rule;
if(rule.include){
if(rule.begin||rule.end||rule.match){
throw new Error("Unexpected regex pattern in \"include\" rule "+rule.include);
}
var name=rule.include;
if(name.charAt(0)==="#"){
_d44=this.grammar.repository&&this.grammar.repository[name.substring(1)];
if(!_d44){
throw new Error("Couldn't find included rule "+name+" in grammar repository");
}
}else{
if(name==="$self"){
_d44=this.grammar;
}else{
if(name==="$base"){
throw new Error("Include \"$base\" is not supported");
}else{
_d44=this._allGrammars[name];
if(!_d44){
for(var i=0;i<this.externalGrammars.length;i++){
var _d45=this.externalGrammars[i];
if(_d45.scopeName===name){
this.preprocess(_d45);
this._allGrammars[name]=_d45;
_d44=_d45;
break;
}
}
}
}
}
}
}
return _d44;
},ContainerNode:(function(){
function _d46(_d47,rule){
this.parent=_d47;
this.rule=rule;
this.children=[];
this.start=null;
this.end=null;
};
_d46.prototype.addChild=function(_d48){
this.children.push(_d48);
};
_d46.prototype.valueOf=function(){
var r=this.rule;
return "ContainerNode { "+(r.include||"")+" "+(r.name||"")+(r.comment||"")+"}";
};
return _d46;
}()),BeginEndNode:(function(){
function _d49(_d4a,rule,_d4b){
this.parent=_d4a;
this.rule=rule;
this.children=[];
this.setStart(_d4b);
this.end=null;
this.endMatch=null;
if(rule.endRegexHasBackRef){
this.endRegexSubstituted=_cfd.getSubstitutedRegex(rule.endRegex,_d4b);
}else{
this.endRegexSubstituted=null;
}
};
_d49.prototype.addChild=function(_d4c){
this.children.push(_d4c);
};
_d49.prototype.getIndexInParent=function(node){
return this.parent?this.parent.children.indexOf(this):-1;
};
_d49.prototype.setStart=function(_d4d){
this.start=_d4d.index;
this.beginMatch=_d4d;
};
_d49.prototype.setEnd=function(_d4e){
if(_d4e&&typeof (_d4e)==="object"){
var _d4f=_d4e;
this.endMatch=_d4f;
this.end=_d4f.index+_d4f[0].length;
}else{
var _d50=_d4e;
this.endMatch=null;
this.end=_d50;
}
};
_d49.prototype.shiftStart=function(_d51){
this.start+=_d51;
this.beginMatch.index+=_d51;
};
_d49.prototype.shiftEnd=function(_d52){
this.end+=_d52;
if(this.endMatch){
this.endMatch.index+=_d52;
}
};
_d49.prototype.valueOf=function(){
return "{"+this.rule.beginRegex+" range="+this.start+".."+this.end+"}";
};
return _d49;
}()),push:function(_d53,_d54){
if(!_d54){
return;
}
for(var i=_d54.length;i>0;){
_d53.push(_d54[--i]);
}
},exec:function(_d55,text,_d56){
var _d57=_d55.exec(text);
if(_d57){
_d57.index+=_d56;
}
_d55.lastIndex=0;
return _d57;
},afterMatch:function(_d58){
return _d58.index+_d58[0].length;
},getEndMatch:function(node,text,_d59){
if(node instanceof this.BeginEndNode){
var rule=node.rule;
var _d5a=node.endRegexSubstituted||rule.endRegex;
if(!_d5a){
return null;
}
return this.exec(_d5a,text,_d59);
}
return null;
},initialParse:function(){
var last=this.textView.getModel().getCharCount();
var root=new this.ContainerNode(null,this.grammar._typedRule);
this._tree=root;
this.parse(this._tree,false,0);
},onModelChanged:function(e){
var _d5b=e.addedCharCount,_d5c=e.addedLineCount,_d5d=e.removedCharCount,_d5e=e.removedLineCount,_d5f=e.start;
if(!this._tree){
this.initialParse();
}else{
var _d60=this.textView.getModel();
var _d61=_d60.getCharCount();
var rs=_d60.getLineEnd(_d60.getLineAtOffset(_d5f)-1);
var fd=this.getFirstDamaged(rs,rs);
rs=rs===-1?0:rs;
var _d62;
if(fd){
_d62=this.parse(fd,true,rs,_d5f,_d5b,_d5d);
}else{
_d62=_d61;
}
this.textView.redrawRange(rs,_d62);
}
},getFirstDamaged:function(_d63,end){
if(_d63<0){
return this._tree;
}
var _d64=[this._tree];
var _d65=null;
while(_d64.length){
var n=_d64.pop();
if(!n.parent||this.isDamaged(n,_d63,end)){
if(n instanceof this.BeginEndNode){
_d65=n;
}
for(var i=0;i<n.children.length;i++){
_d64.push(n.children[i]);
}
}
}
return _d65||this._tree;
},isDamaged:function(n,_d66,end){
return (n.start<=end&&n.end>_d66);
},parse:function(_d67,_d68,rs,_d69,_d6a,_d6b){
var _d6c=this.textView.getModel();
var _d6d=_d6c.getLineStart(_d6c.getLineCount()-1);
var eof=_d6c.getCharCount();
var _d6e=this.getInitialExpected(_d67,rs);
var re=-1;
if(_d68){
_d67.repaired=true;
_d67.endNeedsUpdate=true;
var _d6f=_d67.children[_d67.children.length-1];
var _d70=_d6a-_d6b;
var _d71=_d6f?_d6c.getLineEnd(_d6c.getLineAtOffset(_d6f.end+_d70)):-1;
var _d72=_d6c.getLineEnd(_d6c.getLineAtOffset(_d69+_d6b));
re=Math.max(_d71,_d72);
}
re=(re===-1)?eof:re;
var _d73=_d6e;
var node=_d67;
var _d74=false;
var pos=rs;
var _d75=-1;
while(node&&(!_d68||(pos<re))){
var _d76=this.getNextMatch(_d6c,node,pos);
if(!_d76){
pos=(pos>=_d6d)?eof:_d6c.getLineStart(_d6c.getLineAtOffset(pos)+1);
}
var _d77=_d76&&_d76.match,rule=_d76&&_d76.rule,_d78=_d76&&_d76.isSub,_d79=_d76&&_d76.isEnd;
if(_d78){
pos=this.afterMatch(_d77);
if(rule instanceof this.BeginEndRule){
_d74=true;
if(_d68&&rule===_d73.rule&&node===_d73.parent){
var _d7a=_d73;
_d7a.setStart(_d77);
_d7a.repaired=true;
_d7a.endNeedsUpdate=true;
node=_d7a;
_d73=this.getNextExpected(_d73,"begin");
}else{
if(_d68){
this.prune(node,_d73);
_d68=false;
}
var _d7b=new this.BeginEndNode(node,rule,_d77);
node.addChild(_d7b);
node=_d7b;
}
}else{
}
}else{
if(_d79||pos===eof){
if(node instanceof this.BeginEndNode){
if(_d77){
_d74=true;
_d75=Math.max(_d75,node.end);
node.setEnd(_d77);
pos=this.afterMatch(_d77);
if(_d68&&node===_d73&&node.parent===_d73.parent){
node.repaired=true;
delete node.endNeedsUpdate;
_d73=this.getNextExpected(_d73,"end");
}else{
if(_d68){
this.prune(node,_d73);
_d68=false;
}
}
}else{
node.setEnd(eof);
delete node.endNeedsUpdate;
}
}
node=node.parent;
}
}
if(_d68&&pos>=re&&!_d74){
this.prune(_d67,_d6e);
_d68=false;
}
}
this.removeUnrepairedChildren(_d67,_d68,rs);
this.cleanup(_d68,_d67,rs,re,eof,_d6a,_d6b);
if(_d68){
return Math.max(_d75,pos);
}else{
return pos;
}
},removeUnrepairedChildren:function(node,_d7c,_d7d){
if(_d7c){
var _d7e=node.children;
var _d7f=-1;
for(var i=0;i<_d7e.length;i++){
var _d80=_d7e[i];
if(!_d80.repaired&&this.isDamaged(_d80,_d7d,Number.MAX_VALUE)){
_d7f=i;
break;
}
}
if(_d7f!==-1){
node.children.length=_d7f;
}
}
},cleanup:function(_d81,_d82,rs,re,eof,_d83,_d84){
var i,node,_d85;
if(_d81){
var _d86=_d83-_d84;
var _d87=this.getIntersecting(re-_d86+1,eof);
_d85=this.getIntersecting(rs,re);
for(i=0;i<_d87.length;i++){
node=_d87[i];
if(!node.repaired&&node instanceof this.BeginEndNode){
node.shiftEnd(_d86);
node.shiftStart(_d86);
}
}
for(i=0;i<_d85.length;i++){
node=_d85[i];
if(node.repaired&&node.endNeedsUpdate){
node.shiftEnd(_d86);
}
delete node.endNeedsUpdate;
delete node.repaired;
}
}else{
_d85=this.getIntersecting(rs,re);
for(i=0;i<_d85.length;i++){
delete _d85[i].repaired;
}
}
},getNextMatch:function(_d88,node,pos,_d89){
var _d8a=_d88.getLineAtOffset(pos);
var _d8b=_d88.getLineEnd(_d8a);
var line=_d88.getText(pos,_d8b);
var _d8c=[],_d8d=[],_d8e=[],_d8f=[];
this.push(_d8c,node.rule.subrules);
while(_d8c.length){
var next=_d8c.length?_d8c.pop():null;
var _d90=next&&next._resolvedRule._typedRule;
if(_d90 instanceof this.ContainerRule&&_d8d.indexOf(_d90)===-1){
_d8d.push(_d90);
this.push(_d8c,_d90.subrules);
continue;
}
if(_d90&&_d89&&!(_d90.matchRegex)){
continue;
}
var _d91=_d90&&this.exec(_d90.matchRegex||_d90.beginRegex,line,pos);
if(_d91){
_d8e.push(_d91);
_d8f.push(_d90);
}
}
var _d92=Number.MAX_VALUE,_d93=-1;
for(var i=0;i<_d8e.length;i++){
var _d94=_d8e[i];
if(_d94.index<_d92){
_d92=_d94.index;
_d93=i;
}
}
if(!_d89){
var _d95=node;
var _d96=this.getEndMatch(node,line,pos);
if(_d96){
var _d97=_d95.rule.applyEndPatternLast;
var _d98=_d93===-1||(_d96.index<_d92)||(!_d97&&_d96.index===_d92);
if(_d98){
return {isEnd:true,rule:_d95.rule,match:_d96};
}
}
}
return _d93===-1?null:{isSub:true,rule:_d8f[_d93],match:_d8e[_d93]};
},getInitialExpected:function(node,rs){
var i,_d99;
if(node===this._tree){
for(i=0;i<node.children.length;i++){
_d99=node.children[i];
if(_d99.start>=rs){
return _d99;
}
}
}else{
if(node instanceof this.BeginEndNode){
if(node.endMatch){
var _d9a=node.endMatch.index;
for(i=0;i<node.children.length;i++){
_d99=node.children[i];
if(_d99.start>=rs){
break;
}
}
if(_d99&&_d99.start<_d9a){
return _d99;
}
}else{
}
}
}
return node;
},getNextExpected:function(_d9b,_d9c){
var node=_d9b;
if(_d9c==="begin"){
var _d9d=node.children[0];
if(_d9d){
return _d9d;
}else{
return node;
}
}else{
if(_d9c==="end"){
var _d9e=node.parent;
if(_d9e){
var _d9f=_d9e.children[_d9e.children.indexOf(node)+1];
if(_d9f){
return _d9f;
}else{
return _d9e;
}
}
}
}
return null;
},prune:function(node,_da0){
var _da1=_da0.parent===node;
if(_da1){
node.children.length=_da0.getIndexInParent();
}else{
if(node instanceof this.BeginEndNode){
node.endMatch=null;
node.end=null;
}
}
if(node.parent){
node.parent.children.length=node.getIndexInParent()+1;
}
},onLineStyle:function(e){
function _da2(r1,r2){
return r1.start-r2.start;
};
if(!this._tree){
this.initialParse();
}
var _da3=e.lineStart,_da4=this.textView.getModel(),_da5=_da4.getLineEnd(e.lineIndex);
var rs=_da4.getLineEnd(_da4.getLineAtOffset(_da3)-1);
var node=this.getFirstDamaged(rs,rs);
var _da6=this.getLineScope(_da4,node,_da3,_da5);
e.ranges=this.toStyleRanges(_da6);
e.ranges.sort(_da2);
},getLineScope:function(_da7,node,_da8,end){
var pos=_da8;
var _da9=this.getInitialExpected(node,_da8);
var _daa=[],gaps=[];
while(node&&(pos<end)){
var _dab=this.getNextMatch(_da7,node,pos);
if(!_dab){
break;
}
var _dac=_dab&&_dab.match,rule=_dab&&_dab.rule,_dad=_dab&&_dab.isSub,_dae=_dab&&_dab.isEnd;
if(_dac.index!==pos){
gaps.push({start:pos,end:_dac.index,node:node});
}
if(_dad){
pos=this.afterMatch(_dac);
if(rule instanceof this.BeginEndRule){
this.addBeginScope(_daa,_dac,rule);
node=_da9;
_da9=this.getNextExpected(_da9,"begin");
}else{
this.addMatchScope(_daa,_dac,rule);
}
}else{
if(_dae){
pos=this.afterMatch(_dac);
this.addEndScope(_daa,_dac,rule);
_da9=this.getNextExpected(_da9,"end");
node=node.parent;
}
}
}
if(pos<end){
gaps.push({start:pos,end:end,node:node});
}
var _daf=this.getInheritedLineScope(gaps,_da8,end);
return _daa.concat(_daf);
},getInheritedLineScope:function(gaps,_db0,end){
var _db1=[];
for(var i=0;i<gaps.length;i++){
var gap=gaps[i];
var node=gap.node;
while(node){
var rule=node.rule.rule;
var name=rule.name,_db2=rule.contentName;
var _db3=_db2||name;
if(_db3){
this.addScopeRange(_db1,gap.start,gap.end,_db3);
break;
}
node=node.parent;
}
}
return _db1;
},addBeginScope:function(_db4,_db5,_db6){
var rule=_db6.rule;
this.addCapturesScope(_db4,_db5,(rule.beginCaptures||rule.captures),_db6.isComplex,_db6.beginOld2New,_db6.beginConsuming);
},addEndScope:function(_db7,_db8,_db9){
var rule=_db9.rule;
this.addCapturesScope(_db7,_db8,(rule.endCaptures||rule.captures),_db9.isComplex,_db9.endOld2New,_db9.endConsuming);
},addMatchScope:function(_dba,_dbb,_dbc){
var rule=_dbc.rule,name=rule.name,_dbd=rule.captures;
if(_dbd){
this.addCapturesScope(_dba,_dbb,_dbd,_dbc.isComplex,_dbc.matchOld2New,_dbc.matchConsuming);
}else{
this.addScope(_dba,_dbb,name);
}
},addScope:function(_dbe,_dbf,name){
if(!name){
return;
}
_dbe.push({start:_dbf.index,end:this.afterMatch(_dbf),scope:name});
},addScopeRange:function(_dc0,_dc1,end,name){
if(!name){
return;
}
_dc0.push({start:_dc1,end:end,scope:name});
},addCapturesScope:function(_dc2,_dc3,_dc4,_dc5,_dc6,_dc7){
if(!_dc4){
return;
}
if(!_dc5){
this.addScope(_dc2,_dc3,_dc4[0]&&_dc4[0].name);
}else{
var _dc8={1:0};
var sum=0;
for(var num=1;_dc3[num]!==undefined;num++){
if(_dc7[num]!==undefined){
sum+=_dc3[num].length;
}
if(_dc3[num+1]!==undefined){
_dc8[num+1]=sum;
}
}
var _dc9=_dc3.index;
for(var _dca=1;_dc4[_dca];_dca++){
var _dcb=_dc4[_dca].name;
var _dcc=_dc6[_dca];
var _dcd=_dc9+_dc8[_dcc];
if(typeof _dc3[_dcc]!=="undefined"){
var _dce=_dcd+_dc3[_dcc].length;
this.addScopeRange(_dc2,_dcd,_dce,_dcb);
}
}
}
},getIntersecting:function(_dcf,end){
var _dd0=[];
var _dd1=this._tree?[this._tree]:[];
while(_dd1.length){
var n=_dd1.pop();
var _dd2=false;
if(n instanceof this.ContainerNode){
_dd2=true;
}else{
if(this.isDamaged(n,_dcf,end)){
_dd2=true;
_dd0.push(n);
}
}
if(_dd2){
var len=n.children.length;
for(var i=0;i<len;i++){
_dd1.push(n.children[i]);
}
}
}
return _dd0.reverse();
},toStyleRanges:function(_dd3){
var _dd4=[];
for(var i=0;i<_dd3.length;i++){
var _dd5=_dd3[i];
var _dd6=this._styles[_dd5.scope];
if(!_dd6){
throw new Error("styles not found for "+_dd5.scope);
}
var _dd7=_dd6.join(" ");
_dd4.push({start:_dd5.start,end:_dd5.end,style:{styleClass:_dd7}});
}
return _dd4;
}};
return {RegexUtil:_cfd,TextMateStyler:_d32};
});
},"davinci/ui/widgets/OpenFile":function(){
require({cache:{"url:davinci/ui/widgets/templates/OpenFile.html":"<div class=\"fileDialog\">\n\t<div class=\"dijitDialogPaneContentArea folderContainer\">\n\t\t<div dojoType=\"dijit.layout.ContentPane\" dojoAttachPoint=\"contentpane\">\n\t\t<div class=\"fileDialogTreeWidget\" dojoAttachPoint=\"fileTree\" dojoType=\"dijit.Tree\" model=\"system.resource\" persist=\"false\" labelAttr=\"name\" childrenAttrs=\"children\" dojoAttachEvent=\"onDblClick:_onDblClick,onKeyPress:_onKeyPress\"></div>\n\t\t</div>\n\t</div>\n\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachEvent=\"onClick:_okButton\" class=\"maqPrimaryButton\" type=\"submit\">${finishButtonLabel}</button>\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachEvent=\"onClick:_cancelButton\" class=\"maqSecondaryButton\">${cancelButtonLabel}</button>\n\t</div>\n</div>\n"}});
define("davinci/ui/widgets/OpenFile",["dojo/_base/declare","dijit/_Templated","dijit/_Widget","davinci/library","system/resource","davinci/workbench/Preferences","davinci/Runtime","davinci/Workbench","dijit/Menu","dijit/MenuItem","davinci/model/Path","dijit/form/DropDownButton","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/OpenFile.html","dijit/form/Button","dijit/form/TextBox","dijit/form/RadioButton","dijit/layout/ContentPane","dijit/Tree"],function(_dd8,_dd9,_dda,_ddb,_ddc,_ddd,_dde,_ddf,Menu,_de0,Path,_de1,_de2,_de3,_de4){
return _dd8("davinci.ui.widgets.OpenFile",[_dda,_dd9],{widgetsInTemplate:true,templateString:dojo.cache("davinci.ui.widgets","templates/OpenFile.html","<div class=\"fileDialog\">\n\t<div class=\"dijitDialogPaneContentArea folderContainer\">\n\t\t<div dojoType=\"dijit.layout.ContentPane\" dojoAttachPoint=\"contentpane\">\n\t\t<div class=\"fileDialogTreeWidget\" dojoAttachPoint=\"fileTree\" dojoType=\"dijit.Tree\" model=\"system.resource\" persist=\"false\" labelAttr=\"name\" childrenAttrs=\"children\" dojoAttachEvent=\"onDblClick:_onDblClick,onKeyPress:_onKeyPress\"></div>\n\t\t</div>\n\t</div>\n\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachEvent=\"onClick:_okButton\" class=\"maqPrimaryButton\" type=\"submit\">${finishButtonLabel}</button>\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachEvent=\"onClick:_cancelButton\" class=\"maqSecondaryButton\">${cancelButtonLabel}</button>\n\t</div>\n</div>\n"),fileDialogFileName:null,fileDialogParentFolder:null,postMixInProperties:function(){
dojo.mixin(this,_de2);
dojo.mixin(this,_de3);
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
this.fileTree.watch("selectedItem",dojo.hitch(this,this._updateFields));
if(!this._value){
this._setValueAttr(this._getForcedRootAttr());
}
},startup:function(){
this.fileTree.startup();
},_setValueAttr:function(_de5){
if(_de5==this._value){
return;
}
this._value=_de5;
this.fileTree.set("selectedItems",[_de5]);
},_getForcedRootAttr:function(){
return this._forcedRoot||_ddc.findResource(_ddf.getProject());
},_setForcedRootAttr:function(_de6){
this._forcedRoot=_de6;
},_updateFields:function(){
var _de7=this.fileTree.get("selectedItems");
var _de8=(_de7!=null&&_de7.length>0)?_de7[0]:null;
dojo.attr(this._okButton,"disabled",true);
if(_de8!=null&&_de8.elementType=="File"){
dojo.attr(this._okButton,"disabled",false);
}
},_okButton:function(){
var _de9=this.fileTree.get("selectedItems");
this.value=_de9[0];
},_onDblClick:function(item){
this._okButton();
this.onExecute();
},_onKeyPress:function(e){
if(e.which==dojo.keys.ENTER){
this._okButton();
this.onExecute();
}
},_getValueAttr:function(){
return this.value;
},_cancelButton:function(){
this.onClose();
},resize:function(_dea){
this.contentpane.resize(_dea);
},onExecute:function(){
},onClose:function(){
}});
});
},"davinci/html/HTMLModel":function(){
define("davinci/html/HTMLModel",["dojo/_base/declare","davinci/model/Model"],function(_deb,_dec){
if(!davinci.html){
davinci.html={};
}
davinci.html._noFormatElements={span:true,b:true,it:true};
davinci.html.escapeXml=function(_ded){
if(!_ded){
return _ded;
}
return _ded.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;");
};
davinci.html.unEscapeXml=function(_dee){
if(!_dee||typeof _dee!=="string"){
return _dee;
}
return _dee.replace(/&quot;/g,"\"").replace(/&gt;/g,">").replace(/&lt;/g,"<").replace(/&amp;/g,"&");
};
return _deb("davinci.html.HTMLModel",_dec,{});
});
},"dojox/form/uploader/Base":function(){
define("dojox/form/uploader/Base",["dojo/dom-form","dojo/dom-style","dojo/dom-construct","dojo/dom-attr","dojo/has","dojo/_base/declare","dojo/_base/event","dijit/_Widget","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin"],function(_def,_df0,_df1,_df2,has,_df3,_df4,_df5,_df6,_df7){
has.add("FormData",function(){
return !!window.FormData;
});
has.add("xhr-sendAsBinary",function(){
var xhr=window.XMLHttpRequest&&new window.XMLHttpRequest();
return xhr&&!!xhr.sendAsBinary;
});
has.add("file-multiple",function(){
return !!({"true":1,"false":1}[_df2.get(document.createElement("input",{type:"file"}),"multiple")]);
});
return _df3("dojox.form.uploader.Base",[_df5,_df6,_df7],{getForm:function(){
if(!this.form){
var n=this.domNode;
while(n&&n.tagName&&n!==document.body){
if(n.tagName.toLowerCase()=="form"){
this.form=n;
break;
}
n=n.parentNode;
}
}
return this.form;
},getUrl:function(){
if(this.uploadUrl){
this.url=this.uploadUrl;
}
if(this.url){
return this.url;
}
if(this.getForm()){
this.url=this.form.action;
}
return this.url;
},connectForm:function(){
this.url=this.getUrl();
if(!this._fcon&&!!this.getForm()){
this._fcon=true;
this.connect(this.form,"onsubmit",function(evt){
_df4.stop(evt);
this.submit(this.form);
});
}
},supports:function(what){
switch(what){
case "multiple":
if(this.force=="flash"||this.force=="iframe"){
return false;
}
return has("file-multiple");
case "FormData":
return has(what);
case "sendAsBinary":
return has("xhr-sendAsBinary");
}
return false;
},getMimeType:function(){
return "application/octet-stream";
},getFileType:function(name){
return name.substring(name.lastIndexOf(".")+1).toUpperCase();
},convertBytes:function(_df8){
var kb=Math.round(_df8/1024*100000)/100000;
var mb=Math.round(_df8/1048576*100000)/100000;
var gb=Math.round(_df8/1073741824*100000)/100000;
var _df9=_df8;
if(kb>1){
_df9=kb.toFixed(1)+" kb";
}
if(mb>1){
_df9=mb.toFixed(1)+" mb";
}
if(gb>1){
_df9=gb.toFixed(1)+" gb";
}
return {kb:kb,mb:mb,gb:gb,bytes:_df8,value:_df9};
}});
});
},"davinci/ve/actions/ViewSplitVMenuAction":function(){
define("davinci/ve/actions/ViewSplitVMenuAction",["dojo/_base/declare","davinci/ve/actions/ContextAction"],function(_dfa,_dfb){
return _dfa("davinci.ve.actions.ViewSplitVMenuAction",[_dfb],{run:function(_dfc){
_dfc=this.fixupContext(_dfc);
if(_dfc&&_dfc.editor&&_dfc.editor.switchDisplayModeSplitVertical){
_dfc.editor.switchDisplayModeSplitVertical();
}
}});
});
},"davinci/ui/widgets/TransformTreeMixin":function(){
define("davinci/ui/widgets/TransformTreeMixin",["dijit/Tree"],function(tree){
var _dfd=dijit.Tree.prototype.postCreate;
dijit.Tree.prototype.postCreate=function(){
var _dfe=dijit.Tree.prototype._onItemChildrenChange;
dijit.Tree.prototype._onItemChildrenChange=function(_dff,_e00){
if(this.transforms){
this.transforms.forEach(function(_e01){
_e00=_e01(_e00);
});
}
_dfe.apply(this,[_dff,_e00]);
};
var _e02=this.model.getChildren;
this.model.getChildren=dojo.hitch(this,function(_e03,_e04,_e05){
var _e06=_e04;
if(this.transforms){
_e06=dojo.hitch(this,function(_e07){
this.transforms.forEach(function(_e08){
_e07=_e08(_e07);
});
_e04(_e07);
});
}
_e02.apply(this.model,[_e03,_e06,_e05]);
});
_dfd.apply(this);
};
});
},"davinci/workbench/EditorContainer":function(){
define("davinci/workbench/EditorContainer",["require","dojo/_base/declare","dojo/_base/connect","./_ToolbaredContainer","../Runtime","../ve/metadata","../ve/utils/GeomUtils","dojo/Deferred","dojo/i18n!./nls/workbench"],function(_e09,_e0a,_e0b,_e0c,_e0d,_e0e,_e0f,_e10,_e11){
var _e12={},_e13={};
return _e0a(_e0c,{constructor:function(args){
},postCreate:function(){
this.subscribe("/davinci/ui/editorSelected",function(_e14){
if(_e14.editor==this.editor){
this.updateToolbars();
}
});
this.subscribe("/davinci/ui/widgetSelected",this.updateToolbars);
this.subscribe("/davinci/workbench/ready",this.updateToolbars);
},layout:function(){
this.titleBarDiv.style.display="none";
this.toolbarDiv.style.display="none";
this.inherited(arguments);
},resize:function(){
this.inherited(arguments);
if(this.editor&&this.editor.editor&&this.editor.editor.getTextView){
this.editor.editor.getTextView().resize();
}
},setEditor:function(_e15,_e16,_e17,file,_e18,_e19){
var d=new _e10();
this.editorExtension=_e15;
_e09([_e15.editorClass],function(_e1a){
try{
var _e1b=this.editor=new _e1a(this.containerNode,_e16);
var _e1c=function(){
if(_e1b.setRootElement){
_e1b.setRootElement(_e18);
}
this.containerNode=_e1b.domNode||this.containerNode;
if(typeof _e15.editorClassName=="string"){
dojo.addClass(this.domNode,_e15.editorClassName);
}
_e1b.editorID=_e15.id;
_e1b.isDirty=!_e1b.isReadOnly&&this.isDirty;
this._createToolbar(_e15.editorClass);
if(!_e17){
_e17=_e1b.getDefaultContent();
_e1b.isDirty=!_e1b.isReadOnly&&file.isNew;
_e1b.lastModifiedTime=Date.now();
}
if(!_e17){
_e17="";
}
_e1b.resourceFile=file;
_e1b.fileName=_e16;
var _e1d="editors_container";
if(davinci.Workbench._state.activeEditor==_e16){
_e1b.setContent(_e16,_e17,_e19);
this._setupKeyboardHandler(_e1b);
}else{
var _e1e=dojo.subscribe(_e1d+"-selectChild",this,function(args){
if(_e1b==args.editor){
dojo.unsubscribe(_e1e);
_e1b.setContent(_e16,_e17);
this._setupKeyboardHandler(_e1b);
}
});
}
_e1b.editorContainer=this;
this.setDirty(_e1b.isDirty);
}.bind(this);
(_e1b.deferreds||new _e10().resolve()).then(function(){
if(_e17===true){
return file.getContent().then(function(_e1f){
_e17=_e1f;
});
}
return new _e10().resolve();
}).then(function(){
_e1c();
d.resolve(_e1b);
},function(e){
d.reject(e);
});
}
catch(e){
d.reject(e);
}
}.bind(this));
return d;
},setDirty:function(_e20){
var _e21=this._getTitle();
this.lastModifiedTime=Date.now();
this.isDirty=_e20;
var _e22=_e09("../Workbench");
_e22.editorTabs.setTitle(this,_e21);
},_getTitle:function(){
var _e23=this.attr("title");
return _e23;
},save:function(_e24){
this.editor.save(_e24);
this.setDirty(_e24);
},_close:function(_e25,_e26){
dojo.publish("/davinci/ui/EditorClosing",[{editor:_e25}]);
var _e27=true;
if(_e26&&_e25&&_e25.isDirty){
var _e28=_e25.getOnUnloadWarningMessage();
if(!_e28){
_e28=dojo.string.substitute(_e11.fileHasUnsavedChanges,[this._getTitle()]);
}
_e27=confirm(_e28);
}
if(_e27){
this._isClosing=true;
if(_e25.removeWorkingCopy){
_e25.removeWorkingCopy();
}else{
if(_e25.getFileEditors){
_e25.getFileEditors().forEach(function(_e29){
if(_e29.isReadOnly){
return;
}
_e29.resourceFile.removeWorkingCopy();
});
}else{
if(_e25.resourceFile){
_e25.resourceFile.removeWorkingCopy();
}
}
}
}
return _e27;
},onClose:function(){
var _e2a=!this._skipDirtyCheck;
return this._close(this.editor,_e2a);
},forceClose:function(_e2b,_e2c){
this._close(_e2b,_e2c);
var _e2d=this.getParent();
if(_e2d){
_e2d.removeChild(this);
this.destroyRecursive();
}
},_getViewActions:function(){
var _e2e=this.editorExtension.id;
var _e2f=[];
var _e30=_e0d.getExtensions("davinci.editorActions",function(ext){
if(_e2e==ext.editorContribution.targetID){
_e2f.push(ext.editorContribution);
return true;
}
});
if(_e2f.length==0){
var _e30=_e0d.getExtension("davinci.defaultEditorActions",function(ext){
_e2f.push(ext.editorContribution);
return true;
});
}
var _e31=_e0e.getLibraryActions("davinci.editorActions",_e2e);
_e2f=dojo.clone(_e2f);
if(_e2f.length>0&&_e31.length){
dojo.forEach(_e31,function(_e32){
var _e33=_e09("../Workbench");
if(_e32.action){
_e33._loadActionClass(_e32);
}
if(_e32.menu){
for(var i=0;i<_e32.menu.length;i++){
var _e34=_e32.menu[0];
if(_e34.action){
_e33._loadActionClass(_e34);
}
}
}
_e2f[0].actions.push(_e32);
});
}
return _e2f;
},_getViewContext:function(){
return this.editor;
},_setupKeyboardHandler:function(_e35){
var _e36=function(o){
if(!this.keyBindings){
this.keyBindings=[];
}
this.keyBindings.push(o);
}.bind(this);
this._getViewActions().forEach(function(_e37){
_e37.actions.forEach(function(_e38){
if(_e38.keyBinding){
_e36({keyBinding:_e38.keyBinding,action:_e38});
}
if(_e38.menu){
_e38.menu.forEach(function(_e39){
if(_e39.keyBinding){
_e36({keyBinding:_e39.keyBinding,action:_e39});
}
},this);
}
},this);
},this);
_e0b.connect(_e35,"handleKeyEvent",this,"_handleKeyDown");
},_handleKeyDown:function(e,_e3a){
var _e3b=this._handleKey(e,_e3a);
if(!_e3b&&!_e3a){
_e0d.handleKeyEvent(e);
}
},_handleKey:function(e,_e3c){
if(!this.keyBindings){
return false;
}
var _e3d=this.keyBindings.some(function(_e3e){
if(_e3c&&!_e3e.keyBinding.allowGlobal){
return;
}
if(_e0d.isKeyEqualToEvent(_e3e.keyBinding,e)){
var _e3f=_e09("../Workbench");
_e3f._runAction(_e3e.action,this.editor,_e3e.action.id);
return true;
}
},this);
if(_e3d){
dojo.stopEvent(e);
}
return _e3d;
},destroy:function(){
this.inherited(arguments);
if(this.editor){
this.editor.destroy();
}
delete this.editor;
},_updateToolbar:function(_e40){
function _e41(_e42,_e43){
var _e44=true;
if(_e42&&_e42.action&&_e42.action[_e43]){
_e44=_e42.action[_e43]();
}else{
if(_e42&&_e42[_e43]){
_e44=_e42[_e43]();
}
}
return _e44;
};
function _e45(_e46,_e47){
var _e48=_e41(_e47,"shouldShow");
if(_e48){
dojo.removeClass(_e46.domNode,"maqHidden");
}else{
dojo.addClass(_e46.domNode,"maqHidden");
}
};
function _e49(_e4a,_e4b){
var _e4c=_e41(_e4b,"isEnabled");
_e4a.set("disabled",!_e4c);
};
function _e4d(_e4e,_e4f){
_e41(_e4f,"updateStyling");
};
if(_e40&&this.editor){
var _e50=this.editor.getContext?this.editor.getContext():null;
if(_e50){
var _e51=_e40.getChildren();
for(var i=0;i<_e51.length;i++){
var _e52=_e51[i];
_e45(_e52,_e52._maqAction);
_e49(_e52,_e52._maqAction);
_e4d(_e52,_e52._maqAction);
var menu=_e52.dropDown;
if(menu){
var _e53=menu.getChildren();
for(var j=0;j<_e53.length;j++){
var _e54=_e53[j];
_e45(_e54,_e54._maqAction);
_e49(_e54,_e54._maqAction);
_e4d(_e54,_e54._maqAction);
}
}
}
}
}
},updateToolbars:function(){
if(this.editor==_e0d.currentEditor){
var _e55=this.getToolbarDiv();
if(_e55){
_e55.innerHTML="";
}
var _e56=this.toolbarCreated(this.editorExtension.editorClass);
if(_e55&&_e56&&_e56.domNode){
_e55.appendChild(_e56.domNode);
}
var _e57=dojo.query("#davinci_toolbar_container .dijitToolbar")[0];
var _e58=_e57?dijit.byNode(_e57):null;
this._updateToolbar(_e58);
}
},_createToolbar:function(_e59){
if(this.toolbarCreated(_e59)||_e12[_e59]){
return;
}
_e12[_e59]=true;
this.inherited(arguments);
},getToolbarDiv:function(){
return dojo.byId("davinci_toolbar_container");
},toolbarCreated:function(_e5a,_e5b){
if(arguments.length>1){
_e13[_e5a]=_e5b;
}
return _e13[_e5a];
}});
});
},"orion/editor/annotations":function(){
define("orion/editor/annotations",["i18n!orion/editor/nls/messages","orion/editor/eventTarget"],function(_e5c,_e5d){
function _e5e(_e5f,end,_e60){
this.start=_e5f;
this.end=end;
this._projectionModel=_e60;
this.html=this._expandedHTML;
this.style=this._expandedStyle;
this.expanded=true;
};
_e5e.prototype={_expandedHTML:"<div class='annotationHTML expanded'></div>",_expandedStyle:{styleClass:"annotation expanded"},_collapsedHTML:"<div class='annotationHTML collapsed'></div>",_collapsedStyle:{styleClass:"annotation collapsed"},collapse:function(){
if(!this.expanded){
return;
}
this.expanded=false;
this.html=this._collapsedHTML;
this.style=this._collapsedStyle;
var _e61=this._projectionModel;
var _e62=_e61.getBaseModel();
this._projection={start:_e62.getLineStart(_e62.getLineAtOffset(this.start)+1),end:_e62.getLineEnd(_e62.getLineAtOffset(this.end),true)};
_e61.addProjection(this._projection);
},expand:function(){
if(this.expanded){
return;
}
this.expanded=true;
this.html=this._expandedHTML;
this.style=this._expandedStyle;
this._projectionModel.removeProjection(this._projection);
}};
function _e63(){
};
_e63.ANNOTATION_ERROR="orion.annotation.error";
_e63.ANNOTATION_WARNING="orion.annotation.warning";
_e63.ANNOTATION_TASK="orion.annotation.task";
_e63.ANNOTATION_BREAKPOINT="orion.annotation.breakpoint";
_e63.ANNOTATION_BOOKMARK="orion.annotation.bookmark";
_e63.ANNOTATION_FOLDING="orion.annotation.folding";
_e63.ANNOTATION_CURRENT_BRACKET="orion.annotation.currentBracket";
_e63.ANNOTATION_MATCHING_BRACKET="orion.annotation.matchingBracket";
_e63.ANNOTATION_CURRENT_LINE="orion.annotation.currentLine";
_e63.ANNOTATION_CURRENT_SEARCH="orion.annotation.currentSearch";
_e63.ANNOTATION_MATCHING_SEARCH="orion.annotation.matchingSearch";
_e63.ANNOTATION_READ_OCCURRENCE="orion.annotation.readOccurrence";
_e63.ANNOTATION_WRITE_OCCURRENCE="orion.annotation.writeOccurrence";
var _e64={};
_e63.registerType=function(type,_e65){
var _e66=_e65;
if(typeof _e66!=="function"){
_e66=function(_e67,end,_e68){
this.start=_e67;
this.end=end;
if(_e68){
this.title=_e68;
}
};
_e66.prototype=_e65;
}
_e66.prototype.type=type;
_e64[type]=_e66;
return type;
};
_e63.createAnnotation=function(type,_e69,end,_e6a){
return new (this.getType(type))(_e69,end,_e6a);
};
_e63.getType=function(type){
return _e64[type];
};
function _e6b(type,_e6c){
var _e6d=type.lastIndexOf(".");
var _e6e=type.substring(_e6d+1);
var _e6f={title:_e5c[_e6e],style:{styleClass:"annotation "+_e6e},html:"<div class='annotationHTML "+_e6e+"'></div>",overviewStyle:{styleClass:"annotationOverview "+_e6e}};
if(_e6c){
_e6f.lineStyle={styleClass:"annotationLine "+_e6e};
}else{
_e6f.rangeStyle={styleClass:"annotationRange "+_e6e};
}
_e63.registerType(type,_e6f);
};
_e6b(_e63.ANNOTATION_ERROR);
_e6b(_e63.ANNOTATION_WARNING);
_e6b(_e63.ANNOTATION_TASK);
_e6b(_e63.ANNOTATION_BREAKPOINT);
_e6b(_e63.ANNOTATION_BOOKMARK);
_e6b(_e63.ANNOTATION_CURRENT_BRACKET);
_e6b(_e63.ANNOTATION_MATCHING_BRACKET);
_e6b(_e63.ANNOTATION_CURRENT_SEARCH);
_e6b(_e63.ANNOTATION_MATCHING_SEARCH);
_e6b(_e63.ANNOTATION_READ_OCCURRENCE);
_e6b(_e63.ANNOTATION_WRITE_OCCURRENCE);
_e6b(_e63.ANNOTATION_CURRENT_LINE,true);
_e63.registerType(_e63.ANNOTATION_FOLDING,_e5e);
function _e70(){
};
_e70.addMixin=function(_e71){
var _e72=_e70.prototype;
for(var p in _e72){
if(_e72.hasOwnProperty(p)){
_e71[p]=_e72[p];
}
}
};
_e70.prototype={addAnnotationType:function(type){
if(!this._annotationTypes){
this._annotationTypes=[];
}
this._annotationTypes.push(type);
},getAnnotationTypePriority:function(type){
if(this._annotationTypes){
for(var i=0;i<this._annotationTypes.length;i++){
if(this._annotationTypes[i]===type){
return i+1;
}
}
}
return 0;
},getAnnotationsByType:function(_e73,_e74,end){
var iter=_e73.getAnnotations(_e74,end);
var _e75,_e76=[];
while(iter.hasNext()){
_e75=iter.next();
var _e77=this.getAnnotationTypePriority(_e75.type);
if(_e77===0){
continue;
}
_e76.push(_e75);
}
var self=this;
_e76.sort(function(a,b){
return self.getAnnotationTypePriority(a.type)-self.getAnnotationTypePriority(b.type);
});
return _e76;
},isAnnotationTypeVisible:function(type){
return this.getAnnotationTypePriority(type)!==0;
},removeAnnotationType:function(type){
if(!this._annotationTypes){
return;
}
for(var i=0;i<this._annotationTypes.length;i++){
if(this._annotationTypes[i]===type){
this._annotationTypes.splice(i,1);
break;
}
}
}};
function _e78(_e79){
this._annotations=[];
var self=this;
this._listener={onChanged:function(_e7a){
self._onChanged(_e7a);
}};
this.setTextModel(_e79);
};
_e78.prototype={addAnnotation:function(_e7b){
if(!_e7b){
return;
}
var _e7c=this._annotations;
var _e7d=this._binarySearch(_e7c,_e7b.start);
_e7c.splice(_e7d,0,_e7b);
var e={type:"Changed",added:[_e7b],removed:[],changed:[]};
this.onChanged(e);
},getTextModel:function(){
return this._model;
},getAnnotations:function(_e7e,end){
var _e7f=this._annotations,_e80;
var i=0;
var skip=function(){
while(i<_e7f.length){
var a=_e7f[i++];
if((_e7e===a.start)||(_e7e>a.start?_e7e<a.end:a.start<end)){
return a;
}
if(a.start>=end){
break;
}
}
return null;
};
_e80=skip();
return {next:function(){
var _e81=_e80;
if(_e81){
_e80=skip();
}
return _e81;
},hasNext:function(){
return _e80!==null;
}};
},modifyAnnotation:function(_e82){
if(!_e82){
return;
}
var _e83=this._getAnnotationIndex(_e82);
if(_e83<0){
return;
}
var e={type:"Changed",added:[],removed:[],changed:[_e82]};
this.onChanged(e);
},onChanged:function(e){
return this.dispatchEvent(e);
},removeAnnotations:function(type){
var _e84=this._annotations;
var _e85,i;
if(type){
_e85=[];
for(i=_e84.length-1;i>=0;i--){
var _e86=_e84[i];
if(_e86.type===type){
_e84.splice(i,1);
}
_e85.splice(0,0,_e86);
}
}else{
_e85=_e84;
_e84=[];
}
var e={type:"Changed",removed:_e85,added:[],changed:[]};
this.onChanged(e);
},removeAnnotation:function(_e87){
if(!_e87){
return;
}
var _e88=this._getAnnotationIndex(_e87);
if(_e88<0){
return;
}
var e={type:"Changed",removed:this._annotations.splice(_e88,1),added:[],changed:[]};
this.onChanged(e);
},replaceAnnotations:function(_e89,add){
var _e8a=this._annotations,i,_e8b,_e8c,_e8d=[];
if(_e89){
for(i=_e89.length-1;i>=0;i--){
_e8c=_e89[i];
_e8b=this._getAnnotationIndex(_e8c);
if(_e8b<0){
continue;
}
_e8a.splice(_e8b,1);
_e8d.splice(0,0,_e8c);
}
}
if(!add){
add=[];
}
for(i=0;i<add.length;i++){
_e8c=add[i];
_e8b=this._binarySearch(_e8a,_e8c.start);
_e8a.splice(_e8b,0,_e8c);
}
var e={type:"Changed",removed:_e8d,added:add,changed:[]};
this.onChanged(e);
},setTextModel:function(_e8e){
if(this._model){
this._model.removeEventListener("Changed",this._listener.onChanged);
}
this._model=_e8e;
if(this._model){
this._model.addEventListener("Changed",this._listener.onChanged);
}
},_binarySearch:function(_e8f,_e90){
var high=_e8f.length,low=-1,_e91;
while(high-low>1){
_e91=Math.floor((high+low)/2);
if(_e90<=_e8f[_e91].start){
high=_e91;
}else{
low=_e91;
}
}
return high;
},_getAnnotationIndex:function(_e92){
var _e93=this._annotations;
var _e94=this._binarySearch(_e93,_e92.start);
while(_e94<_e93.length&&_e93[_e94].start===_e92.start){
if(_e93[_e94]===_e92){
return _e94;
}
_e94++;
}
return -1;
},_onChanged:function(_e95){
var _e96=_e95.start;
var _e97=_e95.addedCharCount;
var _e98=_e95.removedCharCount;
var _e99=this._annotations,end=_e96+_e98;
var _e9a=0;
if(!(0<=_e9a&&_e9a<_e99.length)){
return;
}
var e={type:"Changed",added:[],removed:[],changed:[],textModelChangedEvent:_e95};
var _e9b=_e97-_e98,i;
for(i=_e9a;i<_e99.length;i++){
var _e9c=_e99[i];
if(_e9c.start>=end){
_e9c.start+=_e9b;
_e9c.end+=_e9b;
e.changed.push(_e9c);
}else{
if(_e9c.end<=_e96){
}else{
if(_e9c.start<_e96&&end<_e9c.end){
_e9c.end+=_e9b;
e.changed.push(_e9c);
}else{
_e99.splice(i,1);
e.removed.push(_e9c);
i--;
}
}
}
}
if(e.added.length>0||e.removed.length>0||e.changed.length>0){
this.onChanged(e);
}
}};
_e5d.EventTarget.addMixin(_e78.prototype);
function _e9d(view,_e9e){
this._view=view;
this._annotationModel=_e9e;
var self=this;
this._listener={onDestroy:function(e){
self._onDestroy(e);
},onLineStyle:function(e){
self._onLineStyle(e);
},onChanged:function(e){
self._onAnnotationModelChanged(e);
}};
view.addEventListener("Destroy",this._listener.onDestroy);
view.addEventListener("postLineStyle",this._listener.onLineStyle);
_e9e.addEventListener("Changed",this._listener.onChanged);
};
_e9d.prototype={destroy:function(){
var view=this._view;
if(view){
view.removeEventListener("Destroy",this._listener.onDestroy);
view.removeEventListener("LineStyle",this._listener.onLineStyle);
this.view=null;
}
var _e9f=this._annotationModel;
if(_e9f){
_e9f.removeEventListener("Changed",this._listener.onChanged);
_e9f=null;
}
},_mergeStyle:function(_ea0,_ea1){
if(_ea1){
if(!_ea0){
_ea0={};
}
if(_ea0.styleClass&&_ea1.styleClass&&_ea0.styleClass!==_ea1.styleClass){
_ea0.styleClass+=" "+_ea1.styleClass;
}else{
_ea0.styleClass=_ea1.styleClass;
}
var prop;
if(_ea1.style){
if(!_ea0.style){
_ea0.style={};
}
for(prop in _ea1.style){
if(!_ea0.style[prop]){
_ea0.style[prop]=_ea1.style[prop];
}
}
}
if(_ea1.attributes){
if(!_ea0.attributes){
_ea0.attributes={};
}
for(prop in _ea1.attributes){
if(!_ea0.attributes[prop]){
_ea0.attributes[prop]=_ea1.attributes[prop];
}
}
}
}
return _ea0;
},_mergeStyleRanges:function(_ea2,_ea3){
if(!_ea2){
_ea2=[];
}
var _ea4,i;
for(i=0;i<_ea2.length&&_ea3;i++){
var _ea5=_ea2[i];
if(_ea3.end<=_ea5.start){
break;
}
if(_ea3.start>=_ea5.end){
continue;
}
_ea4=this._mergeStyle({},_ea5.style);
_ea4=this._mergeStyle(_ea4,_ea3.style);
var args=[];
args.push(i,1);
if(_ea3.start<_ea5.start){
args.push({start:_ea3.start,end:_ea5.start,style:_ea3.style});
}
if(_ea3.start>_ea5.start){
args.push({start:_ea5.start,end:_ea3.start,style:_ea5.style});
}
args.push({start:Math.max(_ea5.start,_ea3.start),end:Math.min(_ea5.end,_ea3.end),style:_ea4});
if(_ea3.end<_ea5.end){
args.push({start:_ea3.end,end:_ea5.end,style:_ea5.style});
}
if(_ea3.end>_ea5.end){
_ea3={start:_ea5.end,end:_ea3.end,style:_ea3.style};
}else{
_ea3=null;
}
Array.prototype.splice.apply(_ea2,args);
}
if(_ea3){
_ea4=this._mergeStyle({},_ea3.style);
_ea2.splice(i,0,{start:_ea3.start,end:_ea3.end,style:_ea4});
}
return _ea2;
},_onAnnotationModelChanged:function(e){
if(e.textModelChangedEvent){
return;
}
var view=this._view;
if(!view){
return;
}
var self=this;
var _ea6=view.getModel();
function _ea7(_ea8){
for(var i=0;i<_ea8.length;i++){
if(!self.isAnnotationTypeVisible(_ea8[i].type)){
continue;
}
var _ea9=_ea8[i].start;
var end=_ea8[i].end;
if(_ea6.getBaseModel){
_ea9=_ea6.mapOffset(_ea9,true);
end=_ea6.mapOffset(end,true);
}
if(_ea9!==-1&&end!==-1){
view.redrawRange(_ea9,end);
}
}
};
_ea7(e.added);
_ea7(e.removed);
_ea7(e.changed);
},_onDestroy:function(e){
this.destroy();
},_onLineStyle:function(e){
var _eaa=this._annotationModel;
var _eab=e.textView.getModel();
var _eac=_eaa.getTextModel();
var _ead=e.lineStart;
var end=e.lineStart+e.lineText.length;
if(_eac!==_eab){
_ead=_eab.mapOffset(_ead);
end=_eab.mapOffset(end);
}
var _eae=_eaa.getAnnotations(_ead,end);
while(_eae.hasNext()){
var _eaf=_eae.next();
if(!this.isAnnotationTypeVisible(_eaf.type)){
continue;
}
if(_eaf.rangeStyle){
var _eb0=_eaf.start;
var _eb1=_eaf.end;
if(_eac!==_eab){
_eb0=_eab.mapOffset(_eb0,true);
_eb1=_eab.mapOffset(_eb1,true);
}
e.ranges=this._mergeStyleRanges(e.ranges,{start:_eb0,end:_eb1,style:_eaf.rangeStyle});
}
if(_eaf.lineStyle){
e.style=this._mergeStyle({},e.style);
e.style=this._mergeStyle(e.style,_eaf.lineStyle);
}
}
}};
_e70.addMixin(_e9d.prototype);
return {FoldingAnnotation:_e5e,AnnotationType:_e63,AnnotationTypeList:_e70,AnnotationModel:_e78,AnnotationStyler:_e9d};
});
},"davinci/ve/widgets/WidgetToolBar":function(){
require({cache:{"url:davinci/ve/widgets/templates/WidgetToolBar.html":"<div class=\"propertiesTitleBar\" style=\"display: none\">\n\t<div class='propertiesWidgetDescription'>\n\t\t<span class='propertiesWidgetDescriptionFor'>${veNLS.toolBarFor}</span>\n\t\t<span data-dojo-attach-point=\"descNode\">${veNLS.noSelection}</span>\n\t</div>\n\n\t<div class=\"propertiesTitleBarPropertiesContainer\">\n\t\t<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\" class=\"propertiesTitleBarProperties property_table_stretchable\">\n\t\t\t<colgroup><col style=\"width:10px;\"><col class=\"gap02\"><col class=\"gap03\"><col style=\"width:10px;\"><col style=\"width:6px;\"></colgroup>\n\t\t\t<tbody>\n\t\t\t\t<tr class=\"cssPropertySection\">\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td class=\"propertyDisplayName\">${veNLS.toolBarClass}&nbsp;</td>\n\t\t\t\t\t<td class=\"propertyInputField\">\n\t\t\t\t\t  <input data-dojo-type=\"dijit.form.ComboBox\" data-dojo-attach-point=\"classComboBox\" label=\"\" data-dojo-attach-event=\"onChange:_onChangeClassAttribute,onFocus:_onFieldFocus,onBlur:_onFieldBlur\" style=\"width: 100%\" searchAttr=\"name\"/>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td nowrap=\"true\" class=\"propertyExtra\"></td>\n\t\t\t\t\t<td></td>\n\t\t\t\t</tr>\n\t\n\t\t\t\t<tr class=\"cssPropertySection\">\n\t\t\t\t\t<td></td>\n\t\t\t\t\t<td class=\"propertyDisplayName\">${veNLS.toolBarId}&nbsp;</td>\n\t\t\t\t\t<td class=\"propertyInputField\">\n\t\t\t\t\t  <input data-dojo-type=\"dijit.form.ValidationTextBox\" data-dojo-attach-point=\"idTextBox\" label=\"\" data-dojo-attach-event=\"onChange:_onChangeIDAttribute,onKeyPress:_onKeyPress,onFocus:_onFieldFocus,onBlur:_onFieldBlur\" style=\"width: 100%\"/>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td nowrap=\"true\" class=\"propertyExtra\"></td>\n\t\t\t\t\t<td></td>\n\t\t\t\t</tr>\n\t\t\t</tbody>\n\t\t</table>\n\t</div>\n</div>\n"}});
define("davinci/ve/widgets/WidgetToolBar",["dojo/_base/declare","dijit/_Templated","dijit/_Widget","davinci/Runtime","davinci/workbench/ViewLite","davinci/ve/commands/ModifyCommand","dijit/form/ComboBox","dijit/form/ValidationTextBox","dijit/form/TextBox","dojo/store/Memory","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common","davinci/ve/widget","dojo/text!./templates/WidgetToolBar.html",],function(_eb2,_eb3,_eb4,_eb5,_eb6,_eb7,_eb8,_eb9,_eba,_ebb,_ebc,_ebd,_ebe,_ebf){
return _eb2("davinci.ve.widgets.WidgetToolBar",[_eb6,_eb4,_eb3],{templateString:_ebf,widgetsInTemplate:true,descNode:null,idTextBox:null,classComboBox:null,widgetDescStart:"",widgetDescUnselectEnd:"",_oldIDName:null,_oldClassName:null,veNLS:_ebc,postCreate:function(){
this.idTextBox.validator=dojo.hitch(this,function(_ec0,_ec1){
this.invalidMessage=null;
if(!_ec0||!this._widget||this.changing){
return true;
}
var w=_ebe.byId(_ec0);
if(w&&w!==this._widget){
this.invalidMessage=_ebc.idAlreadyUsed;
return false;
}
return true;
});
dojo.subscribe("/davinci/ui/widget/replaced",dojo.hitch(this,this._widgetReplaced));
},initialize:function(){
this._editor=_eb5.currentEditor;
if(this._editor&&this._editor.visualEditor&&this._editor.visualEditor.context){
var _ec2=this._editor.visualEditor.context.getSelection();
if(_ec2.length==0){
this._widget=null;
}else{
this._widget=_ec2[0];
}
}else{
this._widget=null;
}
this.onWidgetSelectionChange();
},onEditorSelected:function(){
this.initialize();
if(this._editor&&this._editor.editorID=="davinci.ve.HTMLPageEditor"){
this.domNode.style.display="block";
}else{
this.domNode.style.display="none";
}
},_widgetReplaced:function(_ec3,_ec4){
if(this._widget===_ec4){
this._widget=_ec3;
this.onWidgetSelectionChange();
}
},onWidgetSelectionChange:function(){
var _ec5="";
if(this._widget){
_ec5=_ebe.getLabel(this._widget);
this.context=this._widget.getContext();
this.classComboBox.set("disabled",false);
this.idTextBox.attr("disabled",false);
}else{
this.descNode.innerHTML=_ebc.noSelection;
dojo.removeClass(this.domNode,"propertiesSelection");
this.context=null;
this.classComboBox.set("value","");
this.classComboBox.set("disabled",true);
this.idTextBox.attr("value","");
this.idTextBox.attr("disabled",true);
return;
}
this.changing=true;
this._oldIDName=null;
this._oldClassName=null;
dojo.addClass(this.domNode,"propertiesSelection");
this.descNode.innerHTML=_ec5;
if(this._editor&&this._editor.declaredClass==="davinci.ve.PageEditor"){
var _ec6=this._widget._srcElement;
if(_ec6){
var _ec7=[];
var _ec8=this._widget.getContext().getModel().getDocumentElement();
if(_ec8){
var _ec9={visit:function(node){
if(node.elementType=="HTMLElement"&&node.tag!="body"&&node.tag!="html"){
var c=node.getAttribute("class");
if(c){
var _eca=dojo.trim(c).split(" ");
dojo.forEach(_eca,dojo.hitch(this,function(_ecb){
if(dojo.indexOf(this.classes,_ecb)==-1){
this.classes.push(_ecb);
}
}));
}
}
},classes:[]};
_ec8.visit(_ec9);
dojo.forEach(_ec9.classes,function(_ecc){
_ec7.push({name:_ecc});
});
}
var _ecd=new _ebb({data:_ec7});
this.classComboBox.set("store",_ecd);
var _ece=_ec6.getAttribute("class");
var _ecf=(_ece&&dojo.trim(_ece))||"";
this.classComboBox.set("value",_ecf);
this._oldClassName=_ecf;
var _ed0=this._widget.getId();
var _ed1=(_ed0&&dojo.trim(_ed0))||"";
this._oldIDName=_ed1;
this.idTextBox.attr("value",_ed1);
}
}
this.changing=false;
},_onChangeIDAttribute:function(){
if(!this._widget||this.changing){
return;
}
var _ed2=this.idTextBox;
if(!_ed2||!_ed2.isValid()){
return;
}
if(this.context){
this.context.blockChange(false);
}
var _ed3=_ed2.attr("value");
if(_ed3!==this._oldIDName){
this._oldIDName=_ed3;
var _ed4={};
_ed4["id"]=_ed3;
var _ed5=new _eb7(this._widget,_ed4,null);
dojo.publish("/davinci/ui/widgetPropertiesChanges",[{source:this._editor.editor_id,command:_ed5}]);
}
},_onChangeClassAttribute:function(){
if(!this._widget||this.changing){
return;
}
var _ed6=this.classComboBox;
if(!_ed6){
return;
}
if(this.context){
this.context.blockChange(false);
}
var _ed7=_ed6.attr("value");
if(_ed7!==this._oldClassName){
this._oldClassName=_ed7;
var _ed8={};
_ed8["class"]=_ed7;
var _ed9=new davinci.ve.commands.ModifyCommand(this._widget,_ed8,null);
dojo.publish("/davinci/ui/widgetPropertiesChanges",[{source:this._editor.editor_id,command:_ed9}]);
}
},_onFieldFocus:function(){
if(this.context){
this.context.blockChange(true);
}
},_onFieldBlur:function(){
if(this.context){
this.context.blockChange(false);
}
},_onKeyPress:function(e){
if(e.keyCode==dojo.keys.ENTER){
this._onChangeIDAttribute();
}
}});
});
},"davinci/ve/widgets/ColorPicker":function(){
define("davinci/ve/widgets/ColorPicker",["dojo/_base/declare","dijit/_WidgetBase","dijit/form/ComboBox","davinci/ve/widgets/ColorStore","davinci/ve/widgets/ColorPickerFlat","dijit/TooltipDialog","dojo/i18n!davinci/ve/nls/ve","dijit/popup"],function(_eda,_edb,_edc,_edd,_ede,_edf,_ee0){
var _ee1=_eda("davinci.ve.widgets.ColorPicker",[_edb],{numberDelta:1,insertPosition:9,data:null,postCreate:function(){
this.inherited(arguments);
this.domNode.removeAttribute("data-dojo-type");
this.domNode.removeAttribute("dojoType");
this._statics=["",davinci.ve.widgets.ColorPicker.divider,_ee0.colorPicker,_ee0.removeValue];
this._run={};
if(!this.data){
this.data=[{value:this._statics[0]},{value:this._statics[2],run:this._chooseColorValue},{value:this._statics[3],run:function(){
this.set("value","");
}},{value:this._statics[1]},{value:"transparent"},{value:"black"},{value:"white"},{value:"red"},{value:"green"},{value:"blue"}];
}else{
this.data.push({value:davinci.ve.widgets.ColorPicker.divider});
this.data.push({value:_ee0.removeValue,run:function(){
this.set("value","");
}});
}
var _ee2=[];
for(var i=0;i<this.data.length;i++){
_ee2.push(this.data[i].value);
if(this.data[i].run){
this._run[this.data[i].value]=this.data[i].run;
}
}
this._store=new _edd({values:_ee2,noncolors:this._statics});
this._dropDown=new _edc({store:this._store,required:false,autoComplete:false,labelType:"html",labelAttr:"label",style:"width:100%"});
dojo.connect(this._dropDown,"onChange",this,"_onChange");
var top=dojo.doc.createElement("div");
dojo.addClass(top,"colorPicker");
this._selectedColor=dojo.doc.createElement("div");
this._selectedColor.innerHTML="&nbsp;";
dojo.addClass(this._selectedColor,"colorPickerSelected");
dojo.connect(this._selectedColor,"onclick",dojo.hitch(this,function(_ee3){
this._chooseColorValue();
}));
top.appendChild(this._selectedColor);
var _ee4=dojo.doc.createElement("div");
dojo.addClass(_ee4,"colorPickerComboContainer");
_ee4.appendChild(this._dropDown.domNode);
top.appendChild(_ee4);
this._colorPickerFlat=new _ede({});
this.domNode.appendChild(top);
},_chooseColorValue:function(){
this._dropDown.set("value",this._value,true);
var _ee5=this._colorPickerFlat;
var _ee6=new _edf({id:"maqetta_prop_tooltip_color_picker",title:_ee0.selectColor,content:_ee5});
dijit.popup.moveOffScreen(_ee6.domNode);
var _ee7=false;
var _ee8=function(_ee9){
return function(){
if(_ee7){
_ee7=false;
dijit.popup.close(_ee6);
}
};
}(this);
_ee6.connect(_ee5,"onCancel",dojo.hitch(this,_ee8));
_ee6.connect(_ee5,"onClose",dojo.hitch(this,_ee8));
var _eea=dijit.byNode(dojo.query("[widgetId]",_ee6.domNode)[0]);
var _eeb=function(_eec){
return function(){
if(this._isReadOnly){
return;
}
dijit.popup.open({parent:_eec._dropDown,popup:_ee6,around:_eec._dropDown.domNode,orient:_eec.isLeftToRight()?{"BL":"TL","BR":"TR","TL":"BL","TR":"BR"}:{"BR":"TR","BL":"TL","TR":"BR","TL":"BL"},onClose:function(){
if(!_eea.canceled){
var _eed=_eec._dropDown.get("value");
_eec._dropDown.set("value",_eea.get("value"));
}
_ee8();
_ee6.destroy();
}});
_ee7=true;
dijit.focus(_ee6.containerNode);
};
};
if(this._value in dojo.Color.named){
var _eee=dojo.colorFromString(this._value);
_ee5.set("value",_eee.toHex());
}else{
_ee5.set("value",this._value||"",true);
}
_eeb(this)();
},_setReadOnlyAttr:function(_eef){
this._isReadOnly=_eef;
this._dropDown.set("disabled",_eef);
},onChange:function(_ef0){
},_getValueAttr:function(){
return this._dropDown.get("value");
},_setValueAttr:function(_ef1,_ef2){
this._dropDown.set("value",_ef1,true);
dojo.style(this._selectedColor,"backgroundColor",_ef1);
if(_ef1 in dojo.Color.named){
var v=dojo.colorFromString(_ef1);
this._colorPickerFlat.set("value",v.toHex(),_ef2);
}else{
this._colorPickerFlat.set("value",_ef1,_ef2);
}
this._onChange(_ef1,_ef2);
},_onChange:function(_ef3,_ef4){
if(_ef3 in this._run){
dojo.hitch(this,this._run[_ef3])();
}else{
if(_ef3==davinci.ve.widgets.ColorPicker.divider){
this._dropDown.set("value",this._store.getItemNumber(0));
}else{
if(!this._store.contains(_ef3)){
this._store.insert(this.insertPosition,_ef3);
dojo.style(this._selectedColor,"backgroundColor",_ef3);
}else{
dojo.style(this._selectedColor,"backgroundColor",_ef3);
}
}
}
if(this._value!=_ef3&&!(_ef3 in this._run)){
this._value=_ef3;
if(!_ef4){
this.onChange(_ef3);
}
}
}});
return dojo.mixin(_ee1,{divider:"---"});
});
},"davinci/workbench/Explorer":function(){
define("davinci/workbench/Explorer",["dojo/_base/declare","dojo/dom-class","dojo/dom-construct","davinci/workbench/ViewPart","davinci/Workbench","davinci/Runtime","dijit/registry","dijit/form/Button","dijit/form/DropDownButton","dijit/DropDownMenu","dijit/MenuItem","dijit/MenuSeparator","dijit/Tree","dojo/mouse","system/resource","davinci/ui/dnd/DragSource","davinci/ui/Resource","davinci/ui/widgets/TransformTreeMixin","davinci/ui/widgets/ProjectToolbar","davinci/ui/NewProjectTemplate","davinci/ui/ManageProjectTemplates","davinci/ui/Rename","davinci/ui/Download","davinci/ui/DownloadSelected","davinci/ui/UserLibraries","dojo/i18n!davinci/ve/nls/common","dojo/i18n!davinci/ui/nls/ui"],function(_ef5,_ef6,_ef7,_ef8,_ef9,_efa,_efb,_efc,_efd,_efe,_eff,_f00,Tree,_f01,_f02,_f03,_f04,_f05,_f06,_f07,_f08,_f09,_f0a,_f0b,_f0c,_f0d,_f0e){
return _ef5("davinci.workbench.Explorer",_ef8,{toolbarID:"workbench.Explorer",getActionsID:function(){
return "davinci.workbench.Explorer";
},postCreate:function(){
this.inherited(arguments);
_ef6.add(this.toolbarDiv,"ExplorerToolbar");
var _f0f=_efa.getExtensions("davinci.dnd",function(_f10){
return dojo.some(_f10.parts,function(item){
return item=="davinci.ui.navigator";
})&&_f10.dragSource;
});
var _f11=system.resource;
var _f12=_ef5(Tree,{_createTreeNode:function(args){
var _f13=this.inherited(arguments);
if(_f0f&&args.item){
_f0f.forEach(function(_f14){
if(_f14.dragSource(args.item)){
var ds=new _f03(_f13.domNode,"component",_f13);
ds.targetShouldShowCaret=true;
ds.returnCloneOnFailure=false;
require([_f14.dragHandler],function(_f15){
ds.dragHandler=new _f15(args.item);
this.connect(ds,"initDrag",function(e){
if(ds.dragHandler.initDrag){
ds.dragHandler.initDrag(e);
}
});
this.connect(ds,"onDragStart",function(e){
ds.dragHandler.dragStart(e);
});
this.connect(ds,"onDragEnd",function(e){
ds.dragHandler.dragEnd(e);
});
}.bind(this));
}
},this);
}
return _f13;
}});
var tree=this.tree=new _f12({showRoot:false,persist:false,cookieName:"maqExplorer",model:_f11,id:"resourceTree",labelAttr:"name",childrenAttrs:"children",getIconClass:davinci.ui.Resource.getResourceIcon,getRowClass:davinci.ui.Resource.getResourceClass,transforms:[system.resource.alphabeticalSort],isMultiSelect:true});
dojo.style(tree.domNode,{width:"100%","overflow-x":"hidden",position:"absolute",bottom:0,top:"7px"});
var down=tree.dndController.onMouseDown,_f16=function(_f17,_f18){
if(_f01.isRight(_f18)){
var w=dijit.getEnclosingWidget(_f18.target);
if(this.tree.get("selectedItems").indexOf(w.item)===-1){
this.tree.set("selectedItems",[w.item]);
}
}
var stop=dojo.stopEvent;
dojo.stopEvent=function(){
};
try{
_f17.call(tree.dndController,_f18);
}
finally{
dojo.stopEvent=stop;
}
};
tree.dndController.onMouseDown=dojo.hitch(null,_f16,down);
var _f19=dojo.doc.createElement("div");
_f19.appendChild(tree.domNode);
this.setContent(_f19);
this.attachToolbar();
tree.startup();
dojo.connect(tree,"onDblClick",dojo.hitch(this,this._dblClick));
tree.watch("selectedItems",dojo.hitch(this,function(prop,_f1a,_f1b){
var _f1c=dojo.map(_f1b,function(item){
return {resource:item};
});
this._updateToolbarIcons(_f1c);
this.publish("/davinci/ui/selectionChanged",[_f1c,this]);
}));
_ef9.createPopup({partID:"davinci.ui.navigator",domNode:this.tree.domNode,openCallback:function(_f1d){
var w=dijit.getEnclosingWidget(_f1d.target);
if(w&&w.item){
var _f1e=tree.get("selectedNodes");
if(dojo.indexOf(_f1e,w)==-1){
tree.set("selectedNodes",[w]);
}
}
}});
var o=_ef9.getActionSets("davinci.ui.navigator");
var _f1f=o.clonedActionSets;
if(_f1f){
dojo.forEach(_f1f[0].actions,dojo.hitch(this,function(_f20){
if(_f20.keyBinding){
if(!this.keyBindings){
this.keyBindings=[];
}
this.keyBindings.push({keyBinding:_f20.keyBinding,action:_f20});
}
}));
}
dojo.connect(tree.domNode,"onkeypress",this,"_onKeyPress");
},attachToolbar:function(){
this.inherited(arguments);
var _f21=dojo.doc.createElement("div");
_f21.className="explorerHeaderProjectDiv";
var _f22=dojo.doc.createElement("table");
_f22.className="explorerHeaderProjectTable";
_f21.appendChild(_f22);
var tr=dojo.doc.createElement("tr");
_f22.appendChild(tr);
var td0=_ef7.create("td",{"class":"explorerHeaderProjectCol0",innerHTML:_f0e.projectColon});
tr.appendChild(td0);
var td1=_ef7.create("td",{"class":"explorerHeaderProjectCol1"});
tr.appendChild(td1);
var td2=_ef7.create("td",{"class":"explorerHeaderProjectCol2"});
tr.appendChild(td2);
var _f23=new davinci.ui.widgets.ProjectToolbar({});
td1.appendChild(_f23.domNode);
var _f24=this.toolbarDiv.children[0];
this.toolbarDiv.insertBefore(_f21,_f24);
dojo.connect(_f23,"onChange",function(){
_ef9.loadProject(this.value);
});
var _f25=new _efc({"class":"ExplorerNewProjectButton",iconClass:"ExplorerNewProjectIcon",title:_f0e.createProject,showLabel:false,onClick:function(){
require(["davinci/ui/Resource"],function(r){
r.newProject();
});
}.bind(this)});
td2.appendChild(_f25.domNode);
var menu=new _efe({style:"display: none;"});
menu.addChild(new _eff({id:"ExplorerCreateProject",label:_f0e.createProjectMenuItem,iconClass:"",onClick:function(){
require(["davinci/ui/Resource"],function(r){
r.newProject();
});
}.bind(this)}));
menu.addChild(new _eff({id:"ExplorerDeleteProject",label:_f0e.deleteProjectMenuItem,iconClass:"",onClick:function(){
this._deleteProject();
}.bind(this)}));
menu.addChild(new _eff({id:"ExplorerRenameProject",label:_f0e.renameProjectMenuItem,iconClass:"",onClick:function(){
this._renameProject();
}.bind(this)}));
menu.addChild(new _f00());
menu.addChild(new _eff({id:"ExplorerSaveAsProjectTemplate",label:_f0e.saveAsProjectTemplateMenuItem,iconClass:"",onClick:function(){
var _f26=new _f07({});
_ef9.showModal(_f26,_f0e.saveAsProjectTemplate,{width:"330px"},null,true);
}.bind(this)}));
menu.addChild(new _eff({id:"ExplorerManageProjectTemplates",label:_f0e.manageProjectTemplatesMenuItem,iconClass:"",onClick:function(){
var _f27=new _f08({});
_ef9.showModal(_f27,_f0e.manageProjectTemplates,{},null,true,function(){
_f27.onShow.call(_f27);
});
}.bind(this)}));
var _f25=new _efd({"class":"ExplorerDropDownButton",iconClass:"ExplorerDropDownIcon",title:_f0e.ProjectMenu,showLabel:false,dropDown:menu});
td2.appendChild(_f25.domNode);
},_updateToolbarIcons:function(_f28){
var _f29=false;
for(var i=0;i<_f28.length;i++){
var _f2a=_f28[i].resource;
if(!_f2a){
return;
}
if(_f2a.readOnly()){
_f29=true;
}
}
var _f2b=document.querySelector(".FilesToolbarDeleteFile");
var _f2c=_efb.byNode(_f2b);
var _f2d=document.querySelector(".FilesToolbarDeleteFileIcon");
if(_f2c&&_f2d){
if(_f29||_f28.length==0){
_ef6.add(_f2d,"FilesToolbarDeleteFileIconDisabled");
_f2c.set("disabled",true);
}else{
_ef6.remove(_f2d,"FilesToolbarDeleteFileIconDisabled");
_f2c.set("disabled",false);
}
}
var _f2e=document.querySelector(".FilesToolbarRenameFile");
var _f2f=_efb.byNode(_f2e);
var _f30=document.querySelector(".FilesToolbarRenameFileIcon");
if(_f2f&&_f30){
if(_f29||_f28.length!=1){
_ef6.add(_f30,"FilesToolbarRenameFileIconDisabled");
_f2f.set("disabled",true);
}else{
_ef6.remove(_f30,"FilesToolbarRenameFileIconDisabled");
_f2f.set("disabled",false);
}
}
},_deleteProject:function(){
var _f31=null;
_f02.listProjects(function(_f32){
_f31=_f32.map(function(_f33){
return _f33.name;
});
}.bind(this));
if(!_f31||_f31.length<2){
alert(_f0e.deleteOnlyProjectError);
return;
}
var _f34=null;
var _f35=_ef9.getProject();
var _f36=false;
for(var i=0;i<_f31.length;i++){
if(_f31[i]==_f35){
_f36=true;
if(_f34){
break;
}
}else{
_f34=_f31[i];
if(_f36){
break;
}
}
}
var _f37=dojo.string.substitute(_f0e.areYouSureDeleteProject,[_f35]);
_f37+="\n\n"+_f0e.NoteOperationNotUndoable+"\n";
if(!confirm(_f37)){
return;
}
var _f38=_f02.findResource(_f35);
_f38.deleteResource().then(function(){
_ef9.loadProject(_f34);
});
},_renameProject:function(){
var _f39=_ef9.getProject();
var _f3a=null;
_f02.listProjects(function(_f3b){
_f3a=_f3b.map(function(_f3c){
return _f3c.name;
});
}.bind(this));
var _f3d=new _f09({value:_f39,invalid:_f3a});
_ef9.showModal(_f3d,_f0e.renameProjectDialogTitle,{height:110,width:200},function(){
var _f3e=_f3d.get("cancel");
if(!_f3e){
var _f3f=_f3d.get("value");
if(_f3f==_f39){
return;
}
var _f40=_f02.findResource(_f39);
_f40.rename(_f3f).then(function(){
_ef9.loadProject(_f3f);
});
}
return true;
});
},destroy:function(){
this.inherited(arguments);
},_dblClick:function(node){
if(node.elementType=="File"){
_ef9.openEditor({fileName:node,content:node.getText(),isDirty:node.isDirty()});
}
},_onKeyPress:function(e){
var _f41=dojo.some(this.keyBindings,dojo.hitch(this,function(_f42){
if(_efa.isKeyEqualToEvent(_f42.keyBinding,e)){
davinci.Workbench._runAction(_f42.action);
return true;
}
}));
if(_f41){
dojo.stopEvent(e);
}
return _f41;
}});
});
},"dojox/grid/_Layout":function(){
define("dojox/grid/_Layout",["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_f43,_f44,_f45,lang,_f46){
return _f44("dojox.grid._Layout",null,{constructor:function(_f47){
this.grid=_f47;
},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_f48,_f49,_f4a,_f4b,_f4c){
var _f4d=this.structure[_f48].cells[0];
var _f4e=this.structure[_f49].cells[0];
var cell=null;
var _f4f=0;
var _f50=0;
for(var i=0,c;c=_f4d[i];i++){
if(c.index==_f4a){
_f4f=i;
break;
}
}
cell=_f4d.splice(_f4f,1)[0];
cell.view=this.grid.views.views[_f49];
for(i=0,c=null;c=_f4e[i];i++){
if(c.index==_f4b){
_f50=i;
break;
}
}
if(!_f4c){
_f50+=1;
}
_f4e.splice(_f50,0,cell);
var _f51=this.grid.getCell(this.grid.getSortIndex());
if(_f51){
_f51._currentlySorted=this.grid.getSortAsc();
}
this.cells=[];
_f4a=0;
var v;
for(i=0;v=this.structure[i];i++){
for(var j=0,cs;cs=v.cells[j];j++){
for(var k=0;c=cs[k];k++){
c.index=_f4a;
this.cells.push(c);
if("_currentlySorted" in c){
var si=_f4a+1;
si*=c._currentlySorted?1:-1;
this.grid.sortInfo=si;
delete c._currentlySorted;
}
_f4a++;
}
}
}
_f45.forEach(this.cells,function(c){
var _f52=c.markup[2].split(" ");
var _f53=parseInt(_f52[1].substring(5));
if(_f53!=c.index){
_f52[1]="idx=\""+c.index+"\"";
c.markup[2]=_f52.join(" ");
}
});
this.grid.setupHeaderMenu();
},setColumnVisibility:function(_f54,_f55){
var cell=this.cells[_f54];
if(cell.hidden==_f55){
cell.hidden=!_f55;
var v=cell.view,w=v.viewWidth;
if(w&&w!="auto"){
v._togglingColumn=_f46.getMarginBox(cell.getHeaderNode()).w||0;
}
v.update();
return true;
}else{
return false;
}
},addCellDef:function(_f56,_f57,_f58){
var self=this;
var _f59=function(_f5a){
var w=0;
if(_f5a.colSpan>1){
w=0;
}else{
w=_f5a.width||self._defaultCellProps.width||self.defaultWidth;
if(!isNaN(w)){
w=w+"em";
}
}
return w;
};
var _f5b={grid:this.grid,subrow:_f56,layoutIndex:_f57,index:this.cells.length};
if(_f58&&_f58 instanceof _f43.grid.cells._Base){
var _f5c=lang.clone(_f58);
_f5b.unitWidth=_f59(_f5c._props);
_f5c=lang.mixin(_f5c,this._defaultCellProps,_f58._props,_f5b);
return _f5c;
}
var _f5d=_f58.type||_f58.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_f43.grid.cells.Cell;
if(lang.isString(_f5d)){
_f5d=lang.getObject(_f5d);
}
_f5b.unitWidth=_f59(_f58);
return new _f5d(lang.mixin({},this._defaultCellProps,_f58,_f5b));
},addRowDef:function(_f5e,_f5f){
var _f60=[];
var _f61=0,_f62=0,_f63=true;
for(var i=0,def,cell;(def=_f5f[i]);i++){
cell=this.addCellDef(_f5e,i,def);
_f60.push(cell);
this.cells.push(cell);
if(_f63&&cell.relWidth){
_f61+=cell.relWidth;
}else{
if(cell.width){
var w=cell.width;
if(typeof w=="string"&&w.slice(-1)=="%"){
_f62+=window.parseInt(w,10);
}else{
if(w=="auto"){
_f63=false;
}
}
}
}
}
if(_f61&&_f63){
_f45.forEach(_f60,function(cell){
if(cell.relWidth){
cell.width=cell.unitWidth=((cell.relWidth/_f61)*(100-_f62))+"%";
}
});
}
return _f60;
},addRowsDef:function(_f64){
var _f65=[];
if(lang.isArray(_f64)){
if(lang.isArray(_f64[0])){
for(var i=0,row;_f64&&(row=_f64[i]);i++){
_f65.push(this.addRowDef(i,row));
}
}else{
_f65.push(this.addRowDef(0,_f64));
}
}
return _f65;
},addViewDef:function(_f66){
this._defaultCellProps=_f66.defaultCell||{};
if(_f66.width&&_f66.width=="auto"){
delete _f66.width;
}
return lang.mixin({},_f66,{cells:this.addRowsDef(_f66.rows||_f66.cells)});
},setStructure:function(_f67){
this.fieldIndex=0;
this.cells=[];
var s=this.structure=[];
if(this.grid.rowSelector){
var sel={type:_f43._scopeName+".grid._RowSelector"};
if(lang.isString(this.grid.rowSelector)){
var _f68=this.grid.rowSelector;
if(_f68=="false"){
sel=null;
}else{
if(_f68!="true"){
sel["width"]=_f68;
}
}
}else{
if(!this.grid.rowSelector){
sel=null;
}
}
if(sel){
s.push(this.addViewDef(sel));
}
}
var _f69=function(def){
return ("name" in def||"field" in def||"get" in def);
};
var _f6a=function(def){
if(lang.isArray(def)){
if(lang.isArray(def[0])||_f69(def[0])){
return true;
}
}
return false;
};
var _f6b=function(def){
return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_f69(def))));
};
if(lang.isArray(_f67)){
var _f6c=false;
for(var i=0,st;(st=_f67[i]);i++){
if(_f6b(st)){
_f6c=true;
break;
}
}
if(!_f6c){
s.push(this.addViewDef({cells:_f67}));
}else{
for(i=0;(st=_f67[i]);i++){
if(_f6a(st)){
s.push(this.addViewDef({cells:st}));
}else{
if(_f6b(st)){
s.push(this.addViewDef(st));
}
}
}
}
}else{
if(_f6b(_f67)){
s.push(this.addViewDef(_f67));
}
}
this.cellCount=this.cells.length;
this.grid.setupHeaderMenu();
}});
});
},"davinci/ui/SaveAsWidgetForm":function(){
require({cache:{"url:davinci/ui/templates/SaveAsWidgetForm.html":"<div class='dvSaveAsWidgetForm'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<p class=\"dvSawfDesc\">${descriptionString}</p>\n\t\t<p>\n\t\t\t<span class=\"dvSawfLabel\">${nameString}:</span>\n\t\t\t<input dojoType='dijit.form.ValidationTextBox' dojoAttachPoint=\"nameInputNode\" trim=\"true\"\n\t\t\t\t\tpromptMessage=\"${namePromptString}\"></input>\n\t\t</p>\n\t\t<p>\n\t\t\t<span class=\"dvSawfLabel\"><span class=\"dvRequired\">*</span>${idString}:</span>\n\t\t\t<input dojoType='dijit.form.ValidationTextBox' dojoAttachPoint=\"idInputNode\" trim=\"true\"\n\t\t\t\t\trequired=\"true\" intermediateChanges=\"true\" promptMessage=\"${idPromptString}\"></input>\n\t\t</p>\n\t\t<p>\n\t\t\t<span class=\"dvSawfLabel\">${versionString}:</span>\n\t\t\t<input dojoType='dijit.form.ValidationTextBox' dojoAttachPoint=\"versionInputNode\"\n\t\t\t\t\ttrim=\"true\"></input>\n\t\t</p>\n\t\t<h4 class=\"dvRequired\">*${requiredString}</h4>\n\t\n\t\t<div dojoType=\"dijit.TitlePane\" title=\"${metadataTitle}\" open=\"false\">\n\t\t\t<textarea dojoType=\"dijit.form.SimpleTextarea\" dojoAttachPoint=\"textareaNode\" name=\"metadata\"\n\t\t\t\t\trows=\"15\" cols=\"50\" intermediateChanges=\"true\">${initialTextareaContent}</textarea>\n\t\t</div>\n\t</div>\n  <div class=\"dijitDialogPaneActionBar\">\n    <button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"buttonSave\" class=\"maqPrimaryButton\" type=\"submit\" disabled=\"true\">${saveString}</button>\n    <button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"buttonCancel\" type=\"button\" class=\"maqSecondaryButton\">${cancelString}</button>\n  </div>\n</div>\n"}});
define("davinci/ui/SaveAsWidgetForm",["dojo/_base/declare","dijit/_Templated","dijit/_Widget","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/SaveAsWidgetForm.html"],function(_f6d,_f6e,_f6f,_f70,_f71,_f72){
return dojo.declare("davinci.ui.SaveAsWidgetForm",[_f6f,_f6e],{templateString:_f72,widgetsInTemplate:true,postMixInProperties:function(){
var nls=_f71;
this.descriptionString=nls.sawfDesc;
this.nameString=nls.name;
this.idString=nls.id;
this.versionString=nls.version;
this.requiredString=nls.required;
this.saveString=nls.save;
this.cancelString=nls.cancel;
this.metadataTitle=nls.sawfMetadataTitle;
this.namePromptString=nls.sawfNamePrompt;
this.idPromptString=nls.sawfIdPrompt;
this.initialTextareaContent=dojo.toJson(this.metadata,true);
},postCreate:function(){
this.inherited(arguments);
var _f73=["nameInputNode","idInputNode","versionInputNode","textareaNode"];
dojo.forEach(_f73,function(item){
this.connect(this[item],"onChange",function(){
this._onChange(item,arguments[0]);
});
},this);
this.idInputNode.regExp="[a-zA-Z]+://[^\\s]+";
this.connect(this.buttonCancel,"onClick",function(){
dijit.byId(this.parentId).hide();
});
},_onChange:function(name,_f74){
switch(name){
case "nameInputNode":
this.metadata.name=_f74;
break;
case "idInputNode":
this.metadata.id=_f74;
break;
case "versionInputNode":
this.metadata.version=_f74;
break;
case "textareaNode":
try{
this.metadata=dojo.fromJson(_f74);
this._invalidMetadata=false;
}
catch(e){
this._invalidMetadata=true;
}
break;
}
if(name!=="textareaNode"){
this.textareaNode.set("value",dojo.toJson(this.metadata,true));
}
this.buttonSave.set("disabled",!this._isValid());
},_isValid:function(){
return this.idInputNode.isValid()&&!this._invalidMetadata;
}});
});
},"dojo/data/util/filter":function(){
define("dojo/data/util/filter",["../../_base/lang"],function(lang){
var _f75={};
lang.setObject("dojo.data.util.filter",_f75);
_f75.patternToRegExp=function(_f76,_f77){
var rxp="^";
var c=null;
for(var i=0;i<_f76.length;i++){
c=_f76.charAt(i);
switch(c){
case "\\":
rxp+=c;
i++;
rxp+=_f76.charAt(i);
break;
case "*":
rxp+=".*";
break;
case "?":
rxp+=".";
break;
case "$":
case "^":
case "/":
case "+":
case ".":
case "|":
case "(":
case ")":
case "{":
case "}":
case "[":
case "]":
rxp+="\\";
default:
rxp+=c;
}
}
rxp+="$";
if(_f77){
return new RegExp(rxp,"mi");
}else{
return new RegExp(rxp,"m");
}
};
return _f75;
});
},"dojo/dnd/common":function(){
define("dojo/dnd/common",["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_f78,_f79,lang,dom){
var _f7a=lang.getObject("dojo.dnd",true);
_f7a.getCopyKeyState=_f78.isCopyKey;
_f7a._uniqueId=0;
_f7a.getUniqueId=function(){
var id;
do{
id=_f79._scopeName+"Unique"+(++_f7a._uniqueId);
}while(dom.byId(id));
return id;
};
_f7a._empty={};
_f7a.isFormElement=function(e){
var t=e.target;
if(t.nodeType==3){
t=t.parentNode;
}
return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;
};
return _f7a;
});
},"davinci/ui/UserLibraries":function(){
require({cache:{"url:davinci/ui/templates/UserLibraries.html":"<div class='userLibDialog'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div dojoAttachPoint=\"_tableDiv\"></div>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' type='submit' dojoAttachEvent='onClick:okButton' label='${modify}' class=\"maqPrimaryButton\"></button> \n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button> \n\t</div> \n</div>"}});
define("davinci/ui/UserLibraries",["dojo/_base/declare","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dojo/promise/all","../Workbench","dijit/form/Button","dijit/form/TextBox","dijit/form/RadioButton","dijit/MenuItem","dijit/Menu","../library","dijit/form/ComboBox","dojo/i18n!./nls/ui","dojo/i18n!dijit/nls/common","../model/Path","system/resource","../ve/RebuildPage","dojo/text!./templates/UserLibraries.html","../Theme"],function(_f7b,_f7c,_f7d,_f7e,all,_f7f,_f80,_f81,_f82,_f83,Menu,_f84,_f85,_f86,_f87,Path,_f88,_f89,_f8a,_f8b){
return _f7b([_f7c,_f7d,_f7e],{postMixInProperties:function(){
dojo.mixin(this,_f87);
dojo.mixin(this,_f86);
this.inherited(arguments);
},_tableDiv:null,templateString:_f8a,buildRendering:function(){
this.inherited(arguments);
this._handles=[];
this._allLibs=_f84.getInstalledLibs();
this._userLibs=_f84.getUserLibs(this.getResourceBase());
var _f8c=["<table cellspacing='0' cellpadding='0' width='100%'>","<tr><td class='header'></td><td class='header'>{library}</td><td class='header'>{version}</td><td class='header'>{workspaceLocation}</td></tr>","<tr></tr>"];
this.libraries={};
this._allLibs.forEach(function(lib,i){
lib.initRoot=this._getLibRoot(lib.id,lib.version);
var name=lib.id;
lib.checked=false;
if(this._getUserLib(lib.id,lib.version)){
lib.checked=true;
}
var _f8d="";
var _f8e=lib.checked||lib.required?"checked":"";
if(lib.required){
_f8c.push("<tr style='display:none'>");
}else{
_f8c.push("<tr>");
}
_f8c.push("<td class='columna'><input type='checkbox' libItemCheck='"+i+"'"+_f8e+"></input></td>");
_f8c.push("<td class='columnb'>"+name+"</td>");
_f8c.push("<td class='columnc'>"+lib.version+"</td>");
if(lib.initRoot){
_f8c.push("<td class='columnd'><input type='text' value='"+lib.initRoot+"' libItemPath='"+i+"'></input></td>");
}else{
_f8c.push("<td class='columnd'></td>");
}
_f8c.push("</tr>");
},this);
_f8c.push("</table>");
var html=dojo.replace(_f8c.join(""),_f86);
dojo.place(html,this._tableDiv);
},getResourceBase:function(){
if(_f7f.singleProjectMode()){
return _f88.getRoot().getName();
}
},_destroy:function(){
var _f8f=this.domNode;
dojo.forEach(dojo.query("[widgetId]",_f8f).map(dijit.byNode),function(w){
w.destroy();
});
while(_f8f.firstChild){
dojo._destroyElement(_f8f.firstChild);
}
this.topDiv=dojo.doc.createElement("div");
this.container.appendChild(this.topDiv);
dojo.forEach(this._handles,dojo.disconnect);
this._handles=[];
},_getLibRoot:function(id,_f90){
var _f91;
if(!this._userLibs.some(function(lib){
if(lib.id==id&&lib.version==_f90){
_f91=lib.root;
return true;
}
})){
this._allLibs.some(function(lib){
if(lib.id==id&&lib.version==_f90){
_f91=lib.root;
return true;
}
});
}
return _f91;
},_getUserLib:function(id,_f92){
return this._userLibs.some(function(lib){
return lib.id==id&&lib.version==_f92;
});
},_makeChange:function(_f93){
if(_f93.length){
var isOk=_f84.modifyLib(_f93);
var _f94=[];
for(var i=0;i<_f93.length;i++){
var _f95=new Path(_f93[i].base);
var _f96=_f94.some(function(path){
return path.equals(_f95);
});
if(!_f96){
_f94.push(_f95);
}
}
dojo.subscribe("/davinci/ui/libraryChanged",this,function(){
_f88.findResourceAsync("*.html",true,this.getResourceBase(),true).then(function(_f97){
var _f98=new _f89(),_f99=[];
_f97.forEach(function(page){
if(_f8b.isThemeHTML(page)){
return;
}
_f99.push(_f98.rebuildSource(page.getContentSync(),page).then(function(_f9a){
page.setContents(_f9a,false);
}));
});
all(_f99).then(function(){
this.onClose();
});
}.bind(this));
});
_f94.forEach(function(path){
var loc=path.toString();
_f88.resourceChanged("reload",loc);
_f84.themesChanged(loc);
});
dojo.publish("/davinci/ui/libraryChanged/start");
}
},_processChanges:function(){
var _f9b=[];
function _f9c(id,_f9d){
for(var i=0;i<_f9b.length;i++){
if(_f9b[i].id==id&&_f9b[i].version==_f9d){
return _f9b[i];
}
}
};
dojo.query("[libItemCheck]",this.domNode).forEach(function(node){
var _f9e=parseInt(dojo.attr(node,"libItemCheck")),_f9f=dojo.attr(node,"checked"),lib=this._allLibs[_f9e];
if(lib.checked!=_f9f){
var item=_f9c(lib.id,lib.version);
if(!item){
item={id:lib.id,version:lib.version};
_f9b.push(item);
}
item.installed=_f9f;
item.base=this.getResourceBase();
}
},this);
dojo.query("[libItemPath]",this.domNode).forEach(function(node){
var _fa0=parseInt(dojo.attr(node,"libItemPath")),_fa1=dojo.attr(node,"value"),lib=this._allLibs[_fa0];
if(lib.initRoot!=_fa1){
var item=_f9c(lib.id,lib.version);
if(!item){
item={id:lib.id,version:lib.version};
_f9b.push(item);
}
item.path=_fa1;
item.oldPath=lib.initRoot;
item.base=this.getResourceBase();
}
},this);
this._makeChange(_f9b);
},okButton:function(){
this._processChanges();
},cancelButton:function(){
this.onClose();
},_rewriteDojo:function(){
var _fa2=dojo.attr(this.__rewriteDojo,"checked");
dojo.attr(this.__rewriteDojoURL,"disabled",!_fa2);
}});
});
},"dojox/timing/doLater":function(){
define("dojox/timing/doLater",["./_base"],function(dxt){
dojo.experimental("dojox.timing.doLater");
dxt.doLater=function(_fa3,_fa4,_fa5){
if(_fa3){
return false;
}
var _fa6=dxt.doLater.caller,args=dxt.doLater.caller.arguments;
_fa5=_fa5||100;
_fa4=_fa4||dojo.global;
setTimeout(function(){
_fa6.apply(_fa4,args);
},_fa5);
return true;
};
return dxt.doLater;
});
},"url:davinci/ve/template.html":"<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\" />\n<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n<title>Untitled</title>\n</head>\n<body>\n</body>\n</html>\n","dijit/tree/ForestStoreModel":function(){
define("dijit/tree/ForestStoreModel",["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_fa7,_fa8,_fa9,lang,_faa){
return _fa8("dijit.tree.ForestStoreModel",_faa,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_fab){
this.root={store:this,root:true,id:_fab.rootId,label:_fab.rootLabel,children:_fab.rootChildren};
},mayHaveChildren:function(item){
return item===this.root||this.inherited(arguments);
},getChildren:function(_fac,_fad,_fae){
if(_fac===this.root){
if(this.root.children){
_fad(this.root.children);
}else{
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_faf){
this.root.children=_faf;
_fad(_faf);
}),onError:_fae});
}
}else{
this.inherited(arguments);
}
},isItem:function(_fb0){
return (_fb0===this.root)?true:this.inherited(arguments);
},fetchItemByIdentity:function(_fb1){
if(_fb1.identity==this.root.id){
var _fb2=_fb1.scope||_fa9.global;
if(_fb1.onItem){
_fb1.onItem.call(_fb2,this.root);
}
}else{
this.inherited(arguments);
}
},getIdentity:function(item){
return (item===this.root)?this.root.id:this.inherited(arguments);
},getLabel:function(item){
return (item===this.root)?this.root.label:this.inherited(arguments);
},newItem:function(args,_fb3,_fb4){
if(_fb3===this.root){
this.onNewRootItem(args);
return this.store.newItem(args);
}else{
return this.inherited(arguments);
}
},onNewRootItem:function(){
},pasteItem:function(_fb5,_fb6,_fb7,_fb8,_fb9){
if(_fb6===this.root){
if(!_fb8){
this.onLeaveRoot(_fb5);
}
}
this.inherited(arguments,[_fb5,_fb6===this.root?null:_fb6,_fb7===this.root?null:_fb7,_fb8,_fb9]);
if(_fb7===this.root){
this.onAddToRoot(_fb5);
}
},onAddToRoot:function(item){
},onLeaveRoot:function(item){
},_requeryTop:function(){
var _fba=this.root.children||[];
this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_fbb){
this.root.children=_fbb;
if(_fba.length!=_fbb.length||_fa7.some(_fba,function(item,idx){
return _fbb[idx]!=item;
})){
this.onChildrenChange(this.root,_fbb);
}
})});
},onNewItem:function(item,_fbc){
this._requeryTop();
this.inherited(arguments);
},onDeleteItem:function(item){
if(_fa7.indexOf(this.root.children,item)!=-1){
this._requeryTop();
}
this.inherited(arguments);
},onSetItem:function(item,_fbd,_fbe,_fbf){
this._requeryTop();
this.inherited(arguments);
}});
});
},"davinci/html/CSSFile":function(){
define("davinci/html/CSSFile",["dojo/_base/declare","dojo/_base/lang","davinci/html/CSSElement","davinci/html/CSSRule","davinci/html/CSSSelector","system/resource"],function(_fc0,lang,_fc1,_fc2,_fc3,_fc4){
return _fc0("davinci.html.CSSFile",_fc1,{constructor:function(args){
this.elementType="CSSFile";
lang.mixin(this,args);
if(!this.options){
this.options={xmode:"style",css:true,expandShorthand:false};
}
var txt=null;
if(this.url&&this.loader){
txt=this.loader(this.url);
}else{
if(this.url){
_fc4.findResourceAsync(this.url).then(function(file){
file.getContent().then(function(txt){
this.setText(txt);
}.bind(this));
this.setDirty(file.isDirty());
}.bind(this));
}
}
if(txt){
this.setText(txt);
}
},save:function(_fc5){
return _fc4.findResourceAsync(this.url).then(function(file){
return file.setContents(this.getText(),_fc5);
}.bind(this));
},close:function(){
this.visit({visit:function(node){
if(node.elementType=="CSSImport"){
node.close();
}
}});
require(["dojo/_base/connect"],function(_fc6){
_fc6.publish("davinci/model/closeModel",[this]);
});
},addRule:function(_fc7){
var rule=new _fc2();
rule.setText(_fc7);
this.addChild(rule);
this.setDirty(true);
return rule;
},setText:function(text){
var _fc8=this.children;
this.children=[];
var _fc9=require("davinci/html/CSSParser").parse(text,this);
if(_fc9.errors.length>0){
}
this.errors=_fc9.errors;
if(this.errors.length>0&&this.errors[this.errors.length-1].isException){
this.children=_fc8;
}
if(this.includeImports){
this.children.forEach(function(_fca){
if(_fca.elementType=="CSSImport"){
_fca.load();
}
});
}
this.onChange();
},getText:function(_fcb){
_fcb=_fcb||{};
_fcb.indent=0;
return this.children.map(function(_fcc){
return _fcc.getText(_fcb);
}).join("");
},getCSSFile:function(){
return this;
},getID:function(){
return this.fileName;
},getMatchingRules:function(_fcd,_fce,_fcf){
_fcd=this._convertNode(_fcd);
_fce=_fce||[];
_fcf=_fcf||[];
for(var i=0;i<this.children.length;i++){
var _fd0=this.children[i];
if(_fd0.elementType=="CSSRule"){
var _fd1=_fd0.matches(_fcd);
if(_fd1){
var _fd2=false;
for(var j=0;j<_fcf.length;j++){
if(_fd1>=_fcf[j]){
_fce.splice(j,0,_fd0);
_fcf.splice(j,0,_fd1);
_fd2=true;
break;
}
}
if(!_fd2){
_fce.splice(0,0,_fd0);
_fcf.splice(0,0,_fd1);
}
}
}else{
if(_fd0.elementType=="CSSImport"&&_fd0.cssFile){
_fd0.cssFile.getMatchingRules(_fcd,_fce,_fcf);
}
}
}
return _fce;
},getRule:function(_fd3){
var _fd4;
if(!_fd3){
return [];
}
var _fd5=_fc3.parseSelectors(_fd3);
for(var i=0;i<this.children.length;i++){
var _fd6=this.children[i];
if(_fd6.elementType=="CSSRule"){
if(_fd6.matchesSelectors(_fd5)){
_fd4=_fd6;
break;
}
}else{
if(_fd6.elementType=="CSSImport"&&_fd6.cssFile){
_fd4=_fd6.cssFile.getRule(_fd5)||_fd4;
}
}
}
return _fd4;
},getRules:function(_fd7){
var _fd8=_fc3.parseSelectors(_fd7);
var _fd9=[];
for(var i=0;i<this.children.length;i++){
var _fda=this.children[i];
if(_fda.elementType=="CSSRule"){
if(_fda.matchesSelectors(_fd8)){
_fd9.push(_fda);
}
}else{
if(_fda.elementType=="CSSImport"&&_fda.cssFile){
_fd9=_fd9.concat(_fda.cssFile.getRules(_fd8));
}
}
}
return _fd9;
},getStyleValue:function(_fdb,_fdc){
var _fdd=[];
var _fde=[];
_fdc=this._convertNode(_fdc);
this.getMatchingRules(_fdc,_fdd,_fde);
function _fdf(_fe0){
var _fe1=0;
var _fe2,prop;
for(var i=0;i<_fdd.length;i++){
if((prop=_fdd[i].getProperty(_fe0))){
if(_fde[i]>_fe1){
_fe2=prop;
_fe1=_fde[i];
}
}
}
return _fe2;
};
if(typeof _fdb=="string"){
_fdb=[_fdb];
}
return _fdb.map(function(name){
return _fdf(name);
});
}});
});
},"dijit/form/TimeTextBox":function(){
define("dijit/form/TimeTextBox",["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_fe3,keys,lang,_fe4,_fe5){
return _fe3("dijit.form.TimeTextBox",_fe5,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_fe4,_selector:"time",value:new Date(""),_onKey:function(evt){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
switch(evt.keyCode){
case keys.ENTER:
case keys.TAB:
case keys.ESCAPE:
case keys.DOWN_ARROW:
case keys.UP_ARROW:
break;
default:
this.defer(function(){
var val=this.get("displayedValue");
this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";
if(this._opened){
this.closeDropDown();
}
this.openDropDown();
});
}
}});
});
},"dijit/Menu":function(){
define("dijit/Menu",["require","dojo/_base/array","dojo/_base/declare","dojo/_base/event","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_fe6,_fe7,_fe8,_fe9,dom,_fea,_feb,_fec,keys,lang,on,has,win,_fed,pm,_fee,_fef){
if(has("dijit-legacy-requires")){
_fef(0,function(){
var _ff0=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];
_fe6(_ff0);
});
}
return _fe8("dijit.Menu",_fee,{constructor:function(){
this._bindings=[];
},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){
if(this.contextMenuForWindow){
this.bindDomNode(this.ownerDocumentBody);
}else{
_fe7.forEach(this.targetNodeIds,this.bindDomNode,this);
}
this.inherited(arguments);
},_iframeContentWindow:function(_ff1){
return _fed.get(this._iframeContentDocument(_ff1))||this._iframeContentDocument(_ff1)["__parent__"]||(_ff1.name&&win.doc.frames[_ff1.name])||null;
},_iframeContentDocument:function(_ff2){
return _ff2.contentDocument||(_ff2.contentWindow&&_ff2.contentWindow.document)||(_ff2.name&&win.doc.frames[_ff2.name]&&win.doc.frames[_ff2.name].document)||null;
},bindDomNode:function(node){
node=dom.byId(node,this.ownerDocument);
var cn;
if(node.tagName.toLowerCase()=="iframe"){
var _ff3=node,_ff4=this._iframeContentWindow(_ff3);
cn=win.body(_ff4.document);
}else{
cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);
}
var _ff5={node:node,iframe:_ff3};
_fea.set(node,"_dijitMenu"+this.id,this._bindings.push(_ff5));
var _ff6=lang.hitch(this,function(cn){
var _ff7=this.selector,_ff8=_ff7?function(_ff9){
return on.selector(_ff7,_ff9);
}:function(_ffa){
return _ffa;
},self=this;
return [on(cn,_ff8(this.leftClickToOpen?"click":"contextmenu"),function(evt){
_fe9.stop(evt);
self._scheduleOpen(this,_ff3,{x:evt.pageX,y:evt.pageY});
}),on(cn,_ff8("keydown"),function(evt){
if(evt.shiftKey&&evt.keyCode==keys.F10){
_fe9.stop(evt);
self._scheduleOpen(this,_ff3);
}
})];
});
_ff5.connects=cn?_ff6(cn):[];
if(_ff3){
_ff5.onloadHandler=lang.hitch(this,function(){
var _ffb=this._iframeContentWindow(_ff3);
cn=win.body(_ffb.document);
_ff5.connects=_ff6(cn);
});
if(_ff3.addEventListener){
_ff3.addEventListener("load",_ff5.onloadHandler,false);
}else{
_ff3.attachEvent("onload",_ff5.onloadHandler);
}
}
},unBindDomNode:function(_ffc){
var node;
try{
node=dom.byId(_ffc,this.ownerDocument);
}
catch(e){
return;
}
var _ffd="_dijitMenu"+this.id;
if(node&&_fea.has(node,_ffd)){
var bid=_fea.get(node,_ffd)-1,b=this._bindings[bid],h;
while((h=b.connects.pop())){
h.remove();
}
var _ffe=b.iframe;
if(_ffe){
if(_ffe.removeEventListener){
_ffe.removeEventListener("load",b.onloadHandler,false);
}else{
_ffe.detachEvent("onload",b.onloadHandler);
}
}
_fea.remove(node,_ffd);
delete this._bindings[bid];
}
},_scheduleOpen:function(_fff,_1000,_1001){
if(!this._openTimer){
this._openTimer=this.defer(function(){
delete this._openTimer;
this._openMyself({target:_fff,iframe:_1000,coords:_1001});
},1);
}
},_openMyself:function(args){
var _1002=args.target,_1003=args.iframe,_1004=args.coords;
this.currentTarget=_1002;
if(_1004){
if(_1003){
var ifc=_feb.position(_1003,true),_1005=this._iframeContentWindow(_1003),_1006=_feb.docScroll(_1005.document);
var cs=_fec.getComputedStyle(_1003),tp=_fec.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_1003,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_1003,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_1003,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_1003,cs.borderTopWidth):0);
_1004.x+=ifc.x+left-_1006.x;
_1004.y+=ifc.y+top-_1006.y;
}
}else{
_1004=_feb.position(_1002,true);
_1004.x+=10;
_1004.y+=10;
}
var self=this;
var _1007=this._focusManager.get("prevNode");
var _1008=this._focusManager.get("curNode");
var _1009=!_1008||(dom.isDescendant(_1008,this.domNode))?_1007:_1008;
function _100a(){
if(self.refocus&&_1009){
_1009.focus();
}
pm.close(self);
};
pm.open({popup:this,x:_1004.x,y:_1004.y,onExecute:_100a,onCancel:_100a,orient:this.isLeftToRight()?"L":"R"});
this.focus();
this._onBlur=function(){
this.inherited("_onBlur",arguments);
pm.close(this);
};
},destroy:function(){
_fe7.forEach(this._bindings,function(b){
if(b){
this.unBindDomNode(b.node);
}
},this);
this.inherited(arguments);
}});
});
},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n","davinci/ve/actions/ViewSplitHMenuAction":function(){
define("davinci/ve/actions/ViewSplitHMenuAction",["dojo/_base/declare","davinci/ve/actions/ContextAction"],function(_100b,_100c){
return _100b("davinci.ve.actions.ViewSplitHMenuAction",[_100c],{run:function(_100d){
_100d=this.fixupContext(_100d);
if(_100d&&_100d.editor&&_100d.editor.switchDisplayModeSplitHorizontal){
_100d.editor.switchDisplayModeSplitHorizontal();
}
}});
});
},"dijit/form/MappedTextBox":function(){
define("dijit/form/MappedTextBox",["dojo/_base/declare","dojo/dom-construct","./ValidationTextBox"],function(_100e,_100f,_1010){
return _100e("dijit.form.MappedTextBox",_1010,{postMixInProperties:function(){
this.inherited(arguments);
this.nameAttrSetting="";
},_setNameAttr:null,serialize:function(val){
return val.toString?val.toString():"";
},toString:function(){
var val=this.filter(this.get("value"));
return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";
},validate:function(){
this.valueNode.value=this.toString();
return this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
this.valueNode=_100f.place("<input type='hidden'"+(this.name?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");
},reset:function(){
this.valueNode.value="";
this.inherited(arguments);
}});
});
},"davinci/ui/ThemeSetsDialog":function(){
require({cache:{"url:davinci/ui/templates/ThemeSetsDialog.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table style=\"width: 90%\">\n\t\t\t<tr>\n\t\t\t\t\t<td style=\"width:40%; vertical-align: top;\">\n\t\t\t\t\t\t\t<table> \n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td style=\" vertical-align: top;\" >\n\t\t\t\t\t\t\t\t\t\t\t\t\t<label>${uiNLS.themeSets}</label><select  id=\"theme_select_themeset_theme_select\" name=\"theme_select_themeset_theme_select\" size=\"10\" style=\"margin-bottom: 5px; width: 190px;\" ></select>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<div id=\"toolbar1\" data-dojo-type=\"dijit.Toolbar\" class=\"toolbaredContainer_toolbarDiv davinciToolbar\">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div data-dojo-type=\"dijit.form.Button\" id=\"theme_select_themeset_add\" data-dojo-props=\"iconClass:'viewActionIcon addThemeSetIcon', showLabel:false \">${uiNLS.addThemeSet}</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<span data-dojo-type=\"dijit.ToolbarSeparator\"></span>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<div data-dojo-type=\"dijit.form.Button\" id=\"theme_select_themeset_delete\" data-dojo-props=\"iconClass:'viewActionIcon removeThemeSetIcon', showLabel:false \">${uiNLS.deleteThemeSet}</div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t </div>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t<td><div style=\"border-right: 1px solid #ccc; width: 1px; height: 250px; margin-left: 10px; margin-top: 10px;\"></div></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td></td><td></td>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t</td>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<table style=\"width: 100%; margin-left:10px; margin-right:10px;\">\n\t\t\t\t\t\t\t\t\t<tr><td colspan=\"2\">${uiNLS.currentlySelectedThemeSet}</td><tr>\n\t\t\t\t\t\t\t\t\t<tr><td style=\"width: 18%;\">${uiNLS.themeSetName}</td><td style=\"text-align: center;\"><input dojoType=\"dijit.form.TextBox\" id=\"theme_select_themeset_theme_select_textbox\" readonly= \"true\" style=\"width: 175px;\" ></input><input type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_select_rename_button\" label=\"Rename\" style=\"margin-left: 5px;\"></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t<div style=\"border-top: 1px solid; top: 231px; border-top-color: #ccc; left: 429px; width: 300px; height: 11px; margin-top: 6px; margin-left:10px;\"></div>\n\t\t\t\t\t\t\t<table style=\"margin-left: 15px; width: 100%;\">\n\t\t\t\t\t\t\t\t\t<tr><td style=\"width: 139px;\">${uiNLS.desktopTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_desktop_theme_select\"type=\"text\"  style=\"width: 175px;\"  ></select></td></tr>\n\t\t\t\t\t\t\t\t\t<tr><td>${uiNLS.mobileTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_mobile_theme_select\"type=\"text\"  style=\"width: 175px;\" ></select></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t\t<table id=\"theme_select_devices_table\" style=\"margin-left:30px; border-collapse: separate; border-spacing: 0 0; width: 100%\">\n\t\t\t\t\t\t\t<tr><td style=\"width: 129px;\">${uiNLS.android}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_android_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.blackberry}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_blackberry_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.ipad}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_ipad_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.iphone}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_iphone_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t<tr><td>${uiNLS.other}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_other_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t\t\t\t\t</table>\n\t\t\n\t\t\t\t\t </td>\n\t\t\t </tr>\n\t\t</table>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_ok_button\" label=\"${uiNLS.save}\" class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_cancel_button\" label=\"${commonNLS.buttonCancel}\" class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n","url:davinci/ui/templates/ThemeSetsRenameDialog.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t${uiNLS.themeSetName} <input data-dojo-type=\"dijit.form.ValidationTextBox\" data-dojo-props=\"regExp:'[a-zA-z0-9_]+', required:true, invalidMessage:'Invalid Text.'\" id=\"theme_select_themeset_rename_textbox\" style=\"width: 175px;\"/>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_set_rename_ok_button\" label=\"${uiNLS.renameButtonLabel}\" class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_set_rename_cancel_button\" label=\"${commonNLS.buttonCancel}\" class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n"}});
define("davinci/ui/ThemeSetsDialog",["dojo/_base/declare","davinci/ui/Dialog","dijit/_Widget","dijit/_Templated","davinci/workbench/Preferences","davinci/Workbench","davinci/library","dojo/text!./templates/ThemeSetsDialog.html","dojo/text!./templates/ThemeSetsRenameDialog.html","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","davinci/Theme","dijit/form/ValidationTextBox","dijit/form/Button","dijit/Toolbar"],function(_1011,_1012,_1013,_1014,_1015,_1016,_1017,_1018,_1019,uiNLS,_101a,Theme){
_1011("davinci.ui.ThemeSetsDialogWidget",[_1013,_1014],{templateString:_1018,widgetsInTemplate:true,uiNLS:uiNLS,commonNLS:_101a});
_1011("davinci.ui.ThemeSetsDialogRenameWidget",[_1013,_1014],{templateString:_1019,widgetsInTemplate:true,uiNLS:uiNLS,commonNLS:_101a});
return dojo.declare("davinci.ui.ThemeSetsDialog",null,{constructor:function(){
this._connections=[];
this._dialog=new _1012({id:"manageThemeSets",title:uiNLS.themeSetsDialog,contentStyle:{width:580}});
dojo.connect(this._dialog,"onCancel",this,"onClose");
this._dojoThemeSets=Theme.getThemeSets(_1016.getProject());
if(!this._dojoThemeSets){
this._dojoThemeSets=Theme.dojoThemeSets;
Theme.saveThemeSets(_1016.getProject(),this._dojoThemeSets);
}
if(!this._dojoThemeSets.themeSets[0]){
this._dojoThemeSets.themeSets.push(dojo.clone(Theme.custom_themeset));
Theme.saveThemeSets(_1016.getProject(),this._dojoThemeSets);
}
this._dojoThemeSets=dojo.clone(this._dojoThemeSets);
this._dialog.attr("content",new davinci.ui.ThemeSetsDialogWidget({}));
this._connections.push(dojo.connect(dojo.byId("theme_select_themeset_theme_select"),"onchange",this,"onChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_themeset_add"),"onClick",this,"addThemeSet"));
this._connections.push(dojo.connect(dijit.byId("theme_select_themeset_delete"),"onClick",this,"deleteThemeSet"));
this._connections.push(dojo.connect(dijit.byId("theme_select_rename_button"),"onClick",this,"renameThemeSet"));
this._connections.push(dojo.connect(dijit.byId("theme_select_desktop_theme_select"),"onChange",this,"onDesktopChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_mobile_theme_select"),"onChange",this,"onMobileChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_ok_button"),"_onSubmit",this,"onOk"));
this._connections.push(dojo.connect(dijit.byId("theme_select_cancel_button"),"onClick",this,"onClose"));
this._connections.push(dojo.connect(dijit.byId("theme_select_android_select"),"onChange",this,"onAndroidThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_blackberry_select"),"onChange",this,"onBlackberryThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_ipad_select"),"onChange",this,"oniPadThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_iphone_select"),"onChange",this,"oniPhoneThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_other_select"),"onChange",this,"onOtherThemeChange"));
this.addThemeSets();
this._selectedThemeSet=this._dojoThemeSets.themeSets[0];
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value",this._selectedThemeSet.name);
this.addThemes(this._selectedThemeSet);
this._dialog.show();
},addThemeSets:function(){
var _101b=dojo.byId("theme_select_themeset_theme_select");
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
var c=dojo.doc.createElement("option");
c.innerHTML=this._dojoThemeSets.themeSets[i].name;
c.value=this._dojoThemeSets.themeSets[i].name;
if(i===0){
c.selected="1";
}
_101b.appendChild(c);
}
},addThemes:function(_101c){
this._themeData=_1017.getThemes(_1016.getProject(),this.workspaceOnly);
var _101d=dijit.byId("theme_select_desktop_theme_select");
_101d.options=[];
var _101e=dijit.byId("theme_select_android_select");
_101e.options=[];
var _101f=dijit.byId("theme_select_blackberry_select");
_101f.options=[];
var _1020=dijit.byId("theme_select_ipad_select");
_1020.options=[];
var _1021=dijit.byId("theme_select_iphone_select");
_1021.options=[];
var _1022=dijit.byId("theme_select_other_select");
_1022.options=[];
var _1023=dijit.byId("theme_select_mobile_theme_select");
_101d.options=[];
_1023.options=[];
_1023.addOption({value:Theme.default_theme,label:Theme.default_theme});
this._themeCount=this._themeData.length;
for(var i=0;i<this._themeData.length;i++){
var opt={value:this._themeData[i].name,label:this._themeData[i].name};
if(this._themeData[i].type==="dojox.mobile"){
_1023.addOption(opt);
_101e.addOption(opt);
_101f.addOption(opt);
_1020.addOption(opt);
_1021.addOption(opt);
_1022.addOption(opt);
}else{
_101d.addOption(opt);
}
}
_101d.attr("value",_101c.desktopTheme);
for(var d=0;d<_101c.mobileTheme.length;d++){
var _1024=_101c.mobileTheme[d].device.toLowerCase();
switch(_1024){
case "android":
_101e.attr("value",_101c.mobileTheme[d].theme);
break;
case "blackberry":
_101f.attr("value",_101c.mobileTheme[d].theme);
break;
case "ipad":
_1020.attr("value",_101c.mobileTheme[d].theme);
break;
case "iphone":
_1021.attr("value",_101c.mobileTheme[d].theme);
break;
case "other":
_1022.attr("value",_101c.mobileTheme[d].theme);
break;
}
}
if(Theme.singleMobileTheme(_101c)){
_1023.attr("value",_101c.mobileTheme[_101c.mobileTheme.length-1].theme);
}else{
_1023.attr("value",Theme.default_theme);
this.onMobileChange(Theme.default_theme);
}
},addThemeSet:function(e){
var _1025;
if(this._selectedThemeSet){
_1025=dojo.clone(this._selectedThemeSet);
}else{
_1025=dojo.clone(Theme.default_themeset);
}
var _1026=_1025.name;
var _1027=0;
for(var n=0;n<this._dojoThemeSets.themeSets.length;n++){
if(this._dojoThemeSets.themeSets[n].name==_1026){
_1027++;
_1026=_1025.name+"_"+_1027;
n=-1;
}
}
_1025.name=_1026;
this._dojoThemeSets.themeSets.push(_1025);
var _1028=dojo.byId("theme_select_themeset_theme_select");
var c=dojo.doc.createElement("option");
c.innerHTML=_1025.name;
c.value=_1025.name;
_1028.appendChild(c);
},deleteThemeSet:function(e){
var _1029=dojo.byId("theme_select_themeset_theme_select");
var node=_1029[_1029.selectedIndex];
if(!node){
return;
}
for(var n=0;n<this._dojoThemeSets.themeSets.length;n++){
if(this._dojoThemeSets.themeSets[n].name==node.value){
this._dojoThemeSets.themeSets.splice(n,1);
break;
}
}
this._selectedThemeSet=null;
_1029.removeChild(node);
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value","");
var _102a=dijit.byId("theme_select_rename_button");
var _102b=dijit.byId("theme_select_desktop_theme_select");
var _102c=dijit.byId("theme_select_mobile_theme_select");
var _102d=dijit.byId("theme_select_android_select");
var _102e=dijit.byId("theme_select_blackberry_select");
var _102f=dijit.byId("theme_select_ipad_select");
var _1030=dijit.byId("theme_select_iphone_select");
var _1031=dijit.byId("theme_select_other_select");
_102a.set("disabled",true);
_102b.set("disabled",true);
_102c.set("disabled",true);
_102d.set("disabled",true);
_102e.set("disabled",true);
_102f.set("disabled",true);
_1030.set("disabled",true);
_1031.set("disabled",true);
},renameThemeSet:function(e){
var _1032=uiNLS;
var loc=_101a;
var _1033=dojo.byId("theme_select_themeset_theme_select");
this._renameDialog=new _1012({id:"rename",title:_1032.renameThemeSet,contentStyle:{width:300},content:new davinci.ui.ThemeSetsDialogRenameWidget({})});
this._renameDialog._themesetConnections=[];
this._renameDialog._themesetConnections.push(dojo.connect(dijit.byId("theme_set_rename_ok_button"),"onClick",this,"onOkRename"));
this._renameDialog._themesetConnections.push(dojo.connect(dijit.byId("theme_set_rename_cancel_button"),"onClick",this,"onCloseRename"));
this._renameDialog._themesetConnections.push(dojo.connect(this._renameDialog,"onCancel",this,"onCloseRename"));
this._renameDialog.show();
var _1034=dijit.byId("theme_select_themeset_rename_textbox");
_1034.attr("value",this._selectedThemeSet.name);
dijit.selectInputText(_1034);
},onOkRename:function(e){
var _1035=dijit.byId("theme_select_themeset_rename_textbox").attr("value");
if(_1035){
for(var n=0;n<this._dojoThemeSets.themeSets.length;n++){
if(this._dojoThemeSets.themeSets[n].name==_1035){
alert("Theme set name already use");
return;
}
}
var _1036=dojo.byId("theme_select_themeset_theme_select");
var node=_1036[_1036.selectedIndex];
var _1037=this._selectedThemeSet.name;
node.innerHTML=_1035;
node.value=_1035;
this._selectedThemeSet.name=_1035;
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value",this._selectedThemeSet.name);
}
this.onCloseRename(e);
},onCloseRename:function(e){
while(connection=this._renameDialog._themesetConnections.pop()){
dojo.disconnect(connection);
}
this._renameDialog.destroyDescendants();
this._renameDialog.destroy();
delete this._renameDialog;
},onClick:function(e){
e.target.setAttribute("selected",false);
var _1038=dojo.byId("theme_select_themeset_theme_select");
_1038.setAttribute("value",this._selectedThemeSet.name);
},onChange:function(e){
var name=e.target[e.target.selectedIndex].value;
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
if(this._dojoThemeSets.themeSets[i].name==name){
this._selectedThemeSet=this._dojoThemeSets.themeSets[i];
this.addThemes(this._dojoThemeSets.themeSets[i]);
dijit.byId("theme_select_themeset_theme_select_textbox").attr("value",this._selectedThemeSet.name);
var _1039=dijit.byId("theme_select_rename_button");
var _103a=dijit.byId("theme_select_desktop_theme_select");
var _103b=dijit.byId("theme_select_mobile_theme_select");
_1039.set("disabled",false);
_103a.set("disabled",false);
_103b.set("disabled",false);
break;
}
}
},onDesktopChange:function(e){
this._selectedThemeSet.desktopTheme=e;
},onMobileChange:function(e){
var _103c=dijit.byId("theme_select_android_select");
var _103d=dijit.byId("theme_select_blackberry_select");
var _103e=dijit.byId("theme_select_ipad_select");
var _103f=dijit.byId("theme_select_iphone_select");
var _1040=dijit.byId("theme_select_other_select");
function _1041(_1042,value,_1043){
switch(_1042){
case "android":
_103c.attr("value",value);
_103c.set("disabled",_1043);
break;
case "blackberry":
_103d.attr("value",value);
_103d.set("disabled",_1043);
break;
case "ipad":
_103e.attr("value",value);
_103e.set("disabled",_1043);
break;
case "iphone":
_103f.attr("value",value);
_103f.set("disabled",_1043);
break;
case "other":
_1040.attr("value",value);
_1040.set("disabled",_1043);
break;
}
};
if((e==="(device-specific)")){
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
var _1044=this._selectedThemeSet.mobileTheme[d].device.toLowerCase();
_1041(_1044,this._selectedThemeSet.mobileTheme[d].theme,false);
}
}else{
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
var _1044=this._selectedThemeSet.mobileTheme[d].device.toLowerCase();
this._selectedThemeSet.mobileTheme[d].theme=e;
_1041(_1044,this._selectedThemeSet.mobileTheme[d].theme,true);
}
}
},onDeviceThemeChange:function(_1045,e){
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
if(this._selectedThemeSet.mobileTheme[d].device.toLowerCase()===_1045.toLowerCase()){
this._selectedThemeSet.mobileTheme[d].theme=e;
break;
}
}
},onAndroidThemeChange:function(e){
this.onDeviceThemeChange("android",e);
},onBlackberryThemeChange:function(e){
this.onDeviceThemeChange("blackberry",e);
},oniPadThemeChange:function(e){
this.onDeviceThemeChange("ipad",e);
},oniPhoneThemeChange:function(e){
this.onDeviceThemeChange("iphone",e);
},onOtherThemeChange:function(e){
this.onDeviceThemeChange("other",e);
},onOk:function(e){
Theme.saveThemeSets(_1016.getProject(),this._dojoThemeSets);
this.onClose(e);
},onClose:function(e){
while(connection=this._connections.pop()){
dojo.disconnect(connection);
}
this._dialog.destroyDescendants();
this._dialog.destroy();
delete this._dialog;
},onDeleteThemeSet:function(e){
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
if(this._dojoThemeSets.themeSets[i].name===this._currentThemeSet.name){
var _1046=this._dojoThemeSets.themeSets[i-1].name;
var cb=dijit.byId("theme_select");
cb.store.fetchItemByIdentity({identity:this._dojoThemeSets.themeSets[i].name,onItem:function(item){
cb.store.deleteItem(item);
cb.store.save();
}});
this._dojoThemeSets.themeSets.splice(i,1);
this._currentThemeSet=null;
cb.attr("value",_1046);
break;
}
}
}});
});
},"dojox/grid/util":function(){
define("dojox/grid/util",["../main","dojo/_base/lang","dojo/dom"],function(dojox,lang,dom){
var dgu=lang.getObject("grid.util",true,dojox);
dgu.na="...";
dgu.rowIndexTag="gridRowIndex";
dgu.gridViewTag="gridView";
dgu.fire=function(ob,ev,args){
var fn=ob&&ev&&ob[ev];
return fn&&(args?fn.apply(ob,args):ob[ev]());
};
dgu.setStyleHeightPx=function(_1047,_1048){
if(_1048>=0){
var s=_1047.style;
var v=_1048+"px";
if(_1047&&s["height"]!=v){
s["height"]=v;
}
}
};
dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];
dgu.keyEvents=["keyup","keydown","keypress"];
dgu.funnelEvents=function(_1049,_104a,_104b,_104c){
var evts=(_104c?_104c:dgu.mouseEvents.concat(dgu.keyEvents));
for(var i=0,l=evts.length;i<l;i++){
_104a.connect(_1049,"on"+evts[i],_104b);
}
};
dgu.removeNode=function(_104d){
_104d=dom.byId(_104d);
_104d&&_104d.parentNode&&_104d.parentNode.removeChild(_104d);
return _104d;
};
dgu.arrayCompare=function(inA,inB){
for(var i=0,l=inA.length;i<l;i++){
if(inA[i]!=inB[i]){
return false;
}
}
return (inA.length==inB.length);
};
dgu.arrayInsert=function(_104e,_104f,_1050){
if(_104e.length<=_104f){
_104e[_104f]=_1050;
}else{
_104e.splice(_104f,0,_1050);
}
};
dgu.arrayRemove=function(_1051,_1052){
_1051.splice(_1052,1);
};
dgu.arraySwap=function(_1053,inI,inJ){
var cache=_1053[inI];
_1053[inI]=_1053[inJ];
_1053[inJ]=cache;
};
return dgu;
});
},"davinci/review/actions/_ReviewNavigatorCommon":function(){
define("davinci/review/actions/_ReviewNavigatorCommon",["dojo/_base/declare","davinci/actions/Action"],function(_1054,_1055){
var _1056=_1054("davinci.review.actions._ReviewNavigatorCommon",[_1055],{_getSelection:function(_1057){
var _1058=null;
if(_1057.getSelection){
_1058=_1057.getSelection();
}else{
var _1059=dijit.byId("davinci.review.reviewNavigator");
_1058=_1059.getSelection();
}
return _1058;
},shouldShow:function(_105a){
return true;
}});
return _1056;
});
},"url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,_popupStateNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","dojox/grid/_RowManager":function(){
define("dojox/grid/_RowManager",["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_105b,lang,_105c){
var _105d=function(_105e,_105f){
if(_105e.style.cssText==undefined){
_105e.setAttribute("style",_105f);
}else{
_105e.style.cssText=_105f;
}
};
return _105b("dojox.grid._RowManager",null,{constructor:function(_1060){
this.grid=_1060;
},linesToEms:2,overRow:-2,prepareStylingRow:function(_1061,_1062){
return {index:_1061,node:_1062,odd:Boolean(_1061&1),selected:!!this.grid.selection.isSelected(_1061),over:this.isOver(_1061),customStyles:"",customClasses:"dojoxGridRow"};
},styleRowNode:function(_1063,_1064){
var row=this.prepareStylingRow(_1063,_1064);
this.grid.onStyleRow(row);
this.applyStyles(row);
},applyStyles:function(inRow){
var i=inRow;
i.node.className=i.customClasses;
var h=i.node.style.height;
_105d(i.node,i.customStyles+";"+(i.node._style||""));
i.node.style.height=h;
},updateStyles:function(_1065){
this.grid.updateRowStyles(_1065);
},setOverRow:function(_1066){
var last=this.overRow;
this.overRow=_1066;
if((last!=this.overRow)&&(lang.isString(last)||last>=0)){
this.updateStyles(last);
}
this.updateStyles(this.overRow);
},isOver:function(_1067){
return (this.overRow==_1067&&!_105c.contains(this.grid.domNode,"dojoxGridColumnResizing"));
}});
});
},"davinci/actions/LogoutAction":function(){
define("davinci/actions/LogoutAction",["dojo/_base/declare","./Action","dojo/i18n!davinci/ui/nls/ui"],function(_1068,_1069,uiNls){
return _1068("davinci.actions.LogoutAction",_1069,{run:function(){
dojo.xhrPost({url:"../logout",handleAs:"text",headers:{"Content-Type":"application/x-www-form-urlencoded","Orion-Version":"1"},postData:"",load:function(_106a,_106b){
location.href="welcome";
}.bind(this),});
},isEnabled:function(_106c){
return true;
}});
});
},"davinci/js/ui/JavaScriptOutline":function(){
define("davinci/js/ui/JavaScriptOutline",["dojo/_base/declare","davinci/js/ui/JSOutlineModel","davinci/ui/widgets/DavinciModelTreeModel"],function(_106d,_106e,_106f){
return _106d("davinci.js.ui.JavaScriptOutline",null,{constructor:function(model){
this._jsModel=model;
},getModel:function(){
this._model=new _106e(this._jsModel);
return this._model;
}});
});
},"davinci/ve/actions/MoveToBackAction":function(){
define("davinci/ve/actions/MoveToBackAction",["dojo/_base/declare","./_ReorderAction","davinci/commands/CompoundCommand","davinci/ve/commands/ReparentCommand"],function(_1070,_1071,_1072,_1073){
return _1070("davinci.ve.actions.MoveToBackAction",[_1071],{name:"MoveToBack",iconClass:"editActionIcon editMoveToBackIcon",run:function(_1074){
_1074=this.fixupContext(_1074);
if(!_1074){
return;
}
var _1075=(_1074&&_1074.getSelection)?_1074.getSelection():[];
if(_1075.length===0){
return;
}
if(!this.selectionSameParentAllAbsolute(_1075)){
return;
}
var _1076=_1075[0].getParent();
var _1077=this.getAbsoluteSiblings(_1075[0]);
var _1078=new _1072();
for(var i=_1077.length-1;i>=0;i--){
var _1079=_1077[i];
if(_1075.indexOf(_1079)>=0){
_1078.add(new _1073(_1079,_1076,0));
}
}
_1074.getCommandStack().execute(_1078);
},isEnabled:function(_107a){
_107a=this.fixupContext(_107a);
var _107b=(_107a&&_107a.getSelection)?_107a.getSelection():[];
if(_107b.length===0){
return false;
}
if(!this.selectionSameParentAllAbsolute(_107b)){
return false;
}
var _107c=this.getAbsoluteSiblings(_107b[0]);
for(var j=0;j<_107b.length;j++){
var _107d=_107b[j];
if(_107c.indexOf(_107d)>(_107b.length-1)){
return true;
}
}
return false;
}});
});
},"dojo/dnd/Moveable":function(){
define("dojo/dnd/Moveable",["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(array,_107e,event,lang,dom,_107f,_1080,on,topic,touch,dnd,Mover,win){
var _1081=_107e("dojo.dnd.Moveable",[_1080],{handle:"",delay:0,skip:false,constructor:function(node,_1082){
this.node=dom.byId(node);
if(!_1082){
_1082={};
}
this.handle=_1082.handle?dom.byId(_1082.handle):null;
if(!this.handle){
this.handle=this.node;
}
this.delay=_1082.delay>0?_1082.delay:0;
this.skip=_1082.skip;
this.mover=_1082.mover?_1082.mover:Mover;
this.events=[on(this.handle,touch.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];
},markupFactory:function(_1083,node,Ctor){
return new Ctor(node,_1083);
},destroy:function(){
array.forEach(this.events,function(_1084){
_1084.remove();
});
this.events=this.node=this.handle=null;
},onMouseDown:function(e){
if(this.skip&&dnd.isFormElement(e)){
return;
}
if(this.delay){
this.events.push(on(this.handle,touch.move,lang.hitch(this,"onMouseMove")),on(this.handle,touch.release,lang.hitch(this,"onMouseUp")));
this._lastX=e.pageX;
this._lastY=e.pageY;
}else{
this.onDragDetected(e);
}
event.stop(e);
},onMouseMove:function(e){
if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){
this.onMouseUp(e);
this.onDragDetected(e);
}
event.stop(e);
},onMouseUp:function(e){
for(var i=0;i<2;++i){
this.events.pop().remove();
}
event.stop(e);
},onSelectStart:function(e){
if(!this.skip||!dnd.isFormElement(e)){
event.stop(e);
}
},onDragDetected:function(e){
new this.mover(this.node,e,this);
},onMoveStart:function(mover){
topic.publish("/dnd/move/start",mover);
_107f.add(win.body(),"dojoMove");
_107f.add(this.node,"dojoMoveItem");
},onMoveStop:function(mover){
topic.publish("/dnd/move/stop",mover);
_107f.remove(win.body(),"dojoMove");
_107f.remove(this.node,"dojoMoveItem");
},onFirstMove:function(){
},onMove:function(mover,_1085){
this.onMoving(mover,_1085);
var s=mover.node.style;
s.left=_1085.l+"px";
s.top=_1085.t+"px";
this.onMoved(mover,_1085);
},onMoving:function(){
},onMoved:function(){
}});
return _1081;
});
},"orion/editor/regex":function(){
define("orion/editor/regex",[],function(){
function _1086(str){
return str.replace(/([\\$\^*\/+?\.\(\)|{}\[\]])/g,"\\$&");
};
function parse(str){
var _1087=/^\s*\/(.+)\/([gim]{0,3})\s*$/.exec(str);
if(_1087){
return {pattern:_1087[1],flags:_1087[2]};
}
return null;
};
return {escape:_1086,parse:parse};
});
},"url:davinci/ui/templates/ChooseDevice.html":"<div>\n  <select dojoType=\"dijit.form.Select\" dojoAttachPoint=\"select\" style=\"width: 100%\">\n  </select>\n</div>\n","dojo/store/util/QueryResults":function(){
define("dojo/store/util/QueryResults",["../../_base/array","../../_base/lang","../../_base/Deferred"],function(array,lang,_1088){
var _1089=function(_108a){
if(!_108a){
return _108a;
}
if(_108a.then){
_108a=lang.delegate(_108a);
}
function _108b(_108c){
if(!_108a[_108c]){
_108a[_108c]=function(){
var args=arguments;
return _1088.when(_108a,function(_108d){
Array.prototype.unshift.call(args,_108d);
return _1089(array[_108c].apply(array,args));
});
};
}
};
_108b("forEach");
_108b("filter");
_108b("map");
if(!_108a.total){
_108a.total=_1088.when(_108a,function(_108e){
return _108e.length;
});
}
return _108a;
};
lang.setObject("dojo.store.util.QueryResults",_1089);
return _1089;
});
},"url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"onclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\">\n\t<img role=\"presentation\" alt=\"\" src=\"${_blankGif}\" class=\"dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","dijit/form/CheckBox":function(){
require({cache:{"url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"onclick:_onClick\"\n/></div>\n"}});
define("dijit/form/CheckBox",["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom"],function(_108f,_1090,_1091,has,query,ready,_1092,_1093,_1094){
if(has("dijit-legacy-requires")){
ready(0,function(){
var _1095=["dijit/form/RadioButton"];
_108f(_1095);
});
}
return _1090("dijit.form.CheckBox",[_1092,_1093],{templateString:_1094,baseClass:"dijitCheckBox",_setValueAttr:function(_1096,_1097){
if(typeof _1096=="string"){
this.inherited(arguments);
_1096=true;
}
if(this._created){
this.set("checked",_1096,_1097);
}
},_getValueAttr:function(){
return (this.checked?this.value:false);
},_setIconClassAttr:null,postMixInProperties:function(){
this.inherited(arguments);
this.checkedAttrSetting=this.checked?"checked":"";
},_fillContent:function(){
},_onFocus:function(){
if(this.id){
query("label[for='"+this.id+"']").addClass("dijitFocusedLabel");
}
this.inherited(arguments);
},_onBlur:function(){
if(this.id){
query("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");
}
this.inherited(arguments);
}});
});
},"davinci/ui/widgets/ThemeSetSelection":function(){
require({cache:{"url:davinci/ui/widgets/templates/ThemeSetSelection.html":"<div>\n  <div class=\"dijitDialogPaneContentArea\">\n\t\t<table style=\"width: 100%; padding-left:10px; padding-right:10px;\">\n\t\t\t<tr>\n\t\t\t\t<td style=\"\" NOWRAP>${uiNLS.themeSet}</td>\n\t\t\t\t<td style=\"width: 100%; text-align: center;\"><select dojoType=\"dijit.form.Select\" id=\"theme_select_themeset_theme_select\" type=\"text\" style=\"width: 175px;\" ></select></td>\n\t\t\t</tr>\n\t\t</table>\n\t\n\t\t<div style=\"border-top: 1px solid black; top: 231px; border-top-color: #ccc; left: 429px; width: 300px; height: 11px; margin-top: 6px; padding-left:10px;\"></div>\n\t\t<table style=\"padding-left: 15px; width: 100%;\">\n\t\t\t<tr><td style=\"width: 139px;\">${uiNLS.desktopTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_desktop_theme_select\"type=\"text\"  style=\"width: 175px;\"  ></select></td></tr>\n\t\t\t<tr><td>${uiNLS.mobileTheme}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_mobile_theme_select\"type=\"text\"  style=\"width: 175px;\" ></select></td></tr>\n\t\t</table>\n\t\t<table id=\"theme_select_devices_table\" style=\"padding-left:30px; border-collapse: separate; border-spacing: 0 0; width: 100%\">\n\t\t\t<tr><td style=\"width: 139px;\">${uiNLS.android}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_android_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t<tr><td>${uiNLS.blackberry}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_blackberry_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t<tr><td>${uiNLS.ipad}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_ipad_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t<tr><td>${uiNLS.iphone}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_iphone_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t\t<tr><td>${uiNLS.other}</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_other_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>\n\t\t</table>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_ok_button\" label=\"${uiNLS.select}\" class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType=\"dijit.form.Button\" id=\"theme_select_cancel_button\" label=\"${commonNLS.buttonCancel}\" class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>\n"}});
define("davinci/ui/widgets/ThemeSetSelection",["dojo/_base/declare","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","davinci/library","system/resource","davinci/workbench/Preferences","davinci/Runtime","davinci/Workbench","davinci/ve/commands/ChangeThemeCommand","davinci/ui/Dialog","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dijit/form/Button","dijit/form/Select","davinci/Theme","dojo/text!./templates/ThemeSetSelection.html",],function(_1098,_1099,_109a,_109b,_109c,_109d,_109e,_109f,_10a0,_10a1,_10a2,uiNLS,_10a3,_10a4,_10a5,Theme,_10a6){
_1098("davinci.ui.widgets.ThemeSetSelectionWidget",[_1099,_109a,_109b],{templateString:_10a6,widgetsInTemplate:true,uiNLS:uiNLS,commonNLS:_10a3});
return _1098("davinci.ui.widgets.ThemeSetSelection",null,{workspaceOnly:false,_connections:[],_selectedThemeSet:null,constructor:function(args){
dojo.safeMixin(this,args);
},buildRendering:function(){
var _10a7=uiNLS;
this._dialog=new _10a2({title:_10a7.selectTheme,contentStyle:{width:372}});
dojo.connect(this._dialog,"onCancel",this,"onClose");
var _10a8=null;
if(!this.newFile){
_10a8=_10a0.getOpenEditor().getContext();
}
var _10a9=Theme.getThemeSet(_10a8);
if(!_10a9){
_10a9=Theme.dojoThemeSets.themeSets[0];
}
this._selectedThemeSet=_10a9;
this._dialog.attr("content",new davinci.ui.widgets.ThemeSetSelectionWidget({}));
this._connections.push(dojo.connect(dijit.byId("theme_select_themeset_theme_select"),"onChange",this,"onChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_desktop_theme_select"),"onChange",this,"onDesktopChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_mobile_theme_select"),"onChange",this,"onMobileChange"));
this._connections.push(dojo.connect(this._dialog,"onExecute",this,"onOk"));
this._connections.push(dojo.connect(dijit.byId("theme_select_cancel_button"),"onClick",this,"onClose"));
this._connections.push(dojo.connect(dijit.byId("theme_select_android_select"),"onChange",this,"onAndroidThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_blackberry_select"),"onChange",this,"onBlackberryThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_ipad_select"),"onChange",this,"oniPadThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_iphone_select"),"onChange",this,"oniPhoneThemeChange"));
this._connections.push(dojo.connect(dijit.byId("theme_select_other_select"),"onChange",this,"onOtherThemeChange"));
this.addThemeSets();
var _10aa=dijit.byId("theme_select_themeset_theme_select");
_10aa.attr("value",_10a9.name);
this._dialog.show();
},addThemeSets:function(){
this._dojoThemeSets=Theme.getThemeSets(_10a0.getProject());
if(!this._dojoThemeSets){
this._dojoThemeSets=Theme.dojoThemeSets;
}
this._dojoThemeSets=dojo.clone(this._dojoThemeSets);
if(this._selectedThemeSet.name==Theme.none_themeset_name){
this._dojoThemeSets.themeSets.unshift(this._selectedThemeSet);
}else{
this._dojoThemeSets.themeSets.unshift(Theme.none_themeset);
}
var _10ab=dijit.byId("theme_select_themeset_theme_select");
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
opt={value:this._dojoThemeSets.themeSets[i].name,label:this._dojoThemeSets.themeSets[i].name};
_10ab.addOption(opt);
}
},addThemes:function(_10ac){
this._themeData=_109c.getThemes(_10a0.getProject(),this.workspaceOnly);
var _10ad=dijit.byId("theme_select_desktop_theme_select");
_10ad.options=[];
var _10ae=dijit.byId("theme_select_android_select");
_10ae.options=[];
var _10af=dijit.byId("theme_select_blackberry_select");
_10af.options=[];
var _10b0=dijit.byId("theme_select_ipad_select");
_10b0.options=[];
var _10b1=dijit.byId("theme_select_iphone_select");
_10b1.options=[];
var _10b2=dijit.byId("theme_select_other_select");
_10b2.options=[];
var _10b3=dijit.byId("theme_select_mobile_theme_select");
_10ad.options=[];
_10b3.options=[];
_10b3.addOption({value:Theme.default_theme,label:Theme.default_theme});
this._themeCount=this._themeData.length;
for(var i=0;i<this._themeData.length;i++){
var opt={value:this._themeData[i].name,label:this._themeData[i].name};
if(this._themeData[i].type==="dojox.mobile"){
_10b3.addOption(opt);
_10ae.addOption(opt);
_10af.addOption(opt);
_10b0.addOption(opt);
_10b1.addOption(opt);
_10b2.addOption(opt);
}else{
_10ad.addOption(opt);
}
}
_10ad.attr("value",_10ac.desktopTheme);
for(var d=0;d<_10ac.mobileTheme.length;d++){
var _10b4=_10ac.mobileTheme[d].device.toLowerCase();
switch(_10b4){
case "android":
_10ae.attr("value",_10ac.mobileTheme[d].theme);
break;
case "blackberry":
_10af.attr("value",_10ac.mobileTheme[d].theme);
break;
case "ipad":
_10b0.attr("value",_10ac.mobileTheme[d].theme);
break;
case "iphone":
_10b1.attr("value",_10ac.mobileTheme[d].theme);
break;
case "other":
_10b2.attr("value",_10ac.mobileTheme[d].theme);
break;
}
}
if(Theme.singleMobileTheme(_10ac)){
_10b3.attr("value",_10ac.mobileTheme[_10ac.mobileTheme.length-1].theme);
}else{
_10b3.attr("value",Theme.default_theme);
}
},onChange:function(e){
for(var i=0;i<this._dojoThemeSets.themeSets.length;i++){
if(this._dojoThemeSets.themeSets[i].name==e){
this.addThemes(this._dojoThemeSets.themeSets[i]);
this._selectedThemeSet=this._dojoThemeSets.themeSets[i];
break;
}
}
var _10b5=dijit.byId("theme_select_mobile_theme_select");
var _10b6=dijit.byId("theme_select_desktop_theme_select");
var _10b7=dijit.byId("theme_select_android_select");
var _10b8=dijit.byId("theme_select_blackberry_select");
var _10b9=dijit.byId("theme_select_ipad_select");
var _10ba=dijit.byId("theme_select_iphone_select");
var _10bb=dijit.byId("theme_select_other_select");
if(e===Theme.none_themeset_name){
_10b5.set("disabled",false);
_10b6.set("disabled",false);
_10b7.set("disabled",false);
_10b8.set("disabled",false);
_10b9.set("disabled",false);
_10ba.set("disabled",false);
_10bb.set("disabled",false);
}else{
_10b5.set("disabled",true);
_10b6.set("disabled",true);
_10b7.set("disabled",true);
_10b8.set("disabled",true);
_10b9.set("disabled",true);
_10ba.set("disabled",true);
_10bb.set("disabled",true);
}
},onDesktopChange:function(e){
this._selectedThemeSet.desktopTheme=e;
},onDeviceThemeChange:function(_10bc,e){
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
if(this._selectedThemeSet.mobileTheme[d].device.toLowerCase()===_10bc.toLowerCase()){
this._selectedThemeSet.mobileTheme[d].theme=e;
break;
}
}
},onAndroidThemeChange:function(e){
this.onDeviceThemeChange("android",e);
},onBlackberryThemeChange:function(e){
this.onDeviceThemeChange("blackberry",e);
},oniPadThemeChange:function(e){
this.onDeviceThemeChange("ipad",e);
},oniPhoneThemeChange:function(e){
this.onDeviceThemeChange("iphone",e);
},onOtherThemeChange:function(e){
this.onDeviceThemeChange("other",e);
},onMobileChange:function(e){
if(this._selectedThemeSet.name!=Theme.none_themeset_name){
return;
}
var _10bd=dijit.byId("theme_select_android_select");
var _10be=dijit.byId("theme_select_blackberry_select");
var _10bf=dijit.byId("theme_select_ipad_select");
var _10c0=dijit.byId("theme_select_iphone_select");
var _10c1=dijit.byId("theme_select_other_select");
if((e==="(device-specific)")&&(this._selectedThemeSet.name===Theme.none_themeset_name)){
_10bd.set("disabled",false);
_10be.set("disabled",false);
_10bf.set("disabled",false);
_10c0.set("disabled",false);
_10c1.set("disabled",false);
}else{
for(var d=0;d<this._selectedThemeSet.mobileTheme.length;d++){
var _10c2=this._selectedThemeSet.mobileTheme[d].device.toLowerCase();
this._selectedThemeSet.mobileTheme[d].theme=e;
switch(_10c2){
case "android":
_10bd.attr("value",e);
_10bd.set("disabled",true);
break;
case "blackberry":
_10be.attr("value",e);
_10be.set("disabled",true);
break;
case "ipad":
_10bf.attr("value",e);
_10bf.set("disabled",true);
break;
case "iphone":
_10c0.attr("value",e);
_10c0.set("disabled",true);
break;
case "other":
_10c1.attr("value",e);
_10c1.set("disabled",true);
break;
}
}
}
},updateDeviceThemes:function(){
for(var i=0;i<this._selectedThemeSet.mobileTheme.length;i++){
var _10c3;
switch(this._selectedThemeSet.mobileTheme[i].device.toLowerCase()){
case "android":
_10c3=dijit.byId("theme_select_android_select");
break;
case "blackberry":
_10c3=dijit.byId("theme_select_blackberry_select");
break;
case "ipad":
_10c3=dijit.byId("theme_select_ipad_select");
break;
case "iphone":
_10c3=dijit.byId("theme_select_iphone_select");
break;
default:
_10c3=dijit.byId("theme_select_other_select");
}
this._selectedThemeSet.mobileTheme[i].theme=_10c3.attr("value");
}
},_changeTheme:function(){
debugger;
var e=_10a0.getOpenEditor();
if(e&&e.getContext){
e.getContext().getCommandStack().execute(new _10a1(newTheme,e.getContext()));
}
},_onChange:function(){
var _10c4=uiNLS;
var loc=_10a3;
var _10c5=this._getValueAttr();
if(_10c5==null||this._blockChange){
return;
}
this.value=_10c5;
this._cookieName="maqetta_"+_10c5.name+"_"+_10c5.version;
var _10c6=dojo.cookie(this._cookieName);
if(this.dojoVersion&&_10c5.version!==this.dojoVersion&&!_10c6){
this._warnDiv.innerHTML="<table>"+"<tr><td></td><td>"+_10c4.themeVersionMessage+"</td><td></td></tr>"+"<tr><td></td><td align=\"center\"><button data-dojo-type=\"dijit.form.Button\" type=\"button\" id=\"davinci.ui.widgets.ThemeSelection.ok\">"+loc.buttonOk+"</button><button data-dojo-type=\"dijit.form.Button\" type=\"button\" id=\"davinci.ui.widgets.ThemeSelection.cancel\">"+loc.buttonCancel+"</button></td><td></td></tr>"+"</table>";
var ok=dijit.byId("davinci.ui.widgets.ThemeSelection.ok");
var _10c7=dijit.byId("davinci.ui.widgets.ThemeSelection.cancel");
dojo.connect(ok,"onClick",this,"_warnOk");
dojo.connect(_10c7,"onClick",this,"_warnCancel");
}else{
this.onChange();
}
},_warnOk:function(){
dojo.cookie(this._cookieName,"true");
this._destroy();
this.onChange();
},_warnCancel:function(){
this._destroy();
this.onClose();
},_destroy:function(){
var ok=dijit.byId("davinci.ui.widgets.ThemeSelection.ok");
dojo.disconnect(ok);
ok.destroy();
var _10c8=dijit.byId("davinci.ui.widgets.ThemeSelection.cancel");
dojo.disconnect(_10c8);
_10c8.destroy();
},onOk:function(e){
this.onClose(e);
if(!this.newFile){
var e=_10a0.getOpenEditor();
if(e&&e.getContext){
e.getContext().getCommandStack().execute(new _10a1(this._selectedThemeSet,e.getContext()));
}
}
},onClose:function(e){
while(connection=this._connections.pop()){
dojo.disconnect(connection);
}
this._dialog.destroyRecursive();
delete this._dialog;
},_getTemplate:function(){
var _10c9=uiNLS;
var loc=_10a3;
var _10ca=""+"<table style=\"width: 100%; margin-left:10px; margin-right:10px;\">"+"<tr><td style=\"width: 18%;\">"+_10c9.themeSet+"</td><td style=\"text-align: center;\"><select dojoType=\"dijit.form.Select\" id=\"theme_select_themeset_theme_select\" type=\"text\" style=\"width: 175px;\" ></select></td></tr>"+"</table>"+"<div style=\"border-top: 1px solid black; top: 231px; border-top-color: #ccc; left: 429px; width: 300px; height: 11px; margin-top: 6px; margin-left:10px;\"></div>"+"<table style=\"margin-left: 15px; width: 100%;\">"+"<tr><td>"+_10c9.desktopTheme+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_desktop_theme_select\"type=\"text\"  style=\"width: 175px;\"  ></select></td></tr>"+"<tr><td>"+_10c9.mobileTheme+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_mobile_theme_select\"type=\"text\"  style=\"width: 175px;\" ></select></td></tr>"+"</table>"+"<table id=\"theme_select_devices_table\" style=\"margin-left:30px; border-collapse: separate; border-spacing: 0 0; width: 100%\">"+"<tr><td style=\"width: 139px;\">"+_10c9.android+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_android_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>"+"<tr><td>"+_10c9.blackberry+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_blackberry_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>"+"<tr><td>"+_10c9.ipad+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_ipad_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>"+"<tr><td>"+_10c9.iphone+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_iphone_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>"+"<tr><td>"+_10c9.other+"</td><td><select dojoType=\"dijit.form.Select\" id=\"theme_select_other_select\" type=\"text\"  style=\"width: 150px;\"></select></td></tr>"+"</table>"+"<table style=\"width:100%; margin-top: 10px;\">"+"<tr><td style=\"text-align:right; width:80%;\"><input type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_select_ok_button\" label=\""+loc.buttonOk+"\"></input></td><td><input type=\"button\" dojoType=\"dijit.form.Button\" id=\"theme_select_cancel_button\" label=\""+loc.buttonCancel+"\"></input></td></tr>"+"</table>"+"";
return _10ca;
}});
});
},"dijit/form/Textarea":function(){
define("dijit/form/Textarea",["dojo/_base/declare","dojo/dom-style","./_ExpandingTextAreaMixin","./SimpleTextarea"],function(_10cb,_10cc,_10cd,_10ce){
return _10cb("dijit.form.Textarea",[_10ce,_10cd],{baseClass:"dijitTextBox dijitTextArea dijitExpandingTextArea",cols:"",buildRendering:function(){
this.inherited(arguments);
_10cc.set(this.textbox,{overflowY:"hidden",overflowX:"auto",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"});
}});
});
},"orion/editor/rulers":function(){
define("orion/editor/rulers",["i18n!orion/editor/nls/messages","orion/editor/annotations","orion/editor/tooltip","orion/editor/util"],function(_10cf,_10d0,_10d1,util){
function Ruler(_10d2,_10d3,_10d4,_10d5){
this._location=_10d3||"left";
this._overview=_10d4||"page";
this._rulerStyle=_10d5;
this._view=null;
var self=this;
this._listener={onTextModelChanged:function(e){
self._onTextModelChanged(e);
},onAnnotationModelChanged:function(e){
self._onAnnotationModelChanged(e);
}};
this.setAnnotationModel(_10d2);
};
Ruler.prototype={getAnnotations:function(_10d6,_10d7){
var _10d8=this._annotationModel;
if(!_10d8){
return [];
}
var model=this._view.getModel();
var start=model.getLineStart(_10d6);
var end=model.getLineEnd(_10d7-1);
var _10d9=model;
if(model.getBaseModel){
_10d9=model.getBaseModel();
start=model.mapOffset(start);
end=model.mapOffset(end);
}
var _10da=[];
var _10db=this.getAnnotationsByType(_10d8,start,end);
for(var i=0;i<_10db.length;i++){
var _10dc=_10db[i];
var _10dd=_10d9.getLineAtOffset(_10dc.start);
var _10de=_10d9.getLineAtOffset(Math.max(_10dc.start,_10dc.end-1));
for(var _10df=_10dd;_10df<=_10de;_10df++){
var _10e0=_10df;
if(model!==_10d9){
var ls=_10d9.getLineStart(_10df);
ls=model.mapOffset(ls,true);
if(ls===-1){
continue;
}
_10e0=model.getLineAtOffset(ls);
}
if(!(_10d6<=_10e0&&_10e0<_10d7)){
continue;
}
var _10e1=this._mergeAnnotation(_10da[_10e0],_10dc,_10df-_10dd,_10de-_10dd+1);
if(_10e1){
_10da[_10e0]=_10e1;
}
}
}
if(!this._multiAnnotation&&this._multiAnnotationOverlay){
for(var k in _10da){
if(_10da[k]._multiple){
_10da[k].html=_10da[k].html+this._multiAnnotationOverlay.html;
}
}
}
return _10da;
},getAnnotationModel:function(){
return this._annotationModel;
},getLocation:function(){
return this._location;
},getOverview:function(){
return this._overview;
},getRulerStyle:function(){
return this._rulerStyle;
},getView:function(){
return this._view;
},getWidestAnnotation:function(){
return null;
},setAnnotationModel:function(_10e2){
if(this._annotationModel){
this._annotationModel.removEventListener("Changed",this._listener.onAnnotationModelChanged);
}
this._annotationModel=_10e2;
if(this._annotationModel){
this._annotationModel.addEventListener("Changed",this._listener.onAnnotationModelChanged);
}
},setMultiAnnotation:function(_10e3){
this._multiAnnotation=_10e3;
},setMultiAnnotationOverlay:function(_10e4){
this._multiAnnotationOverlay=_10e4;
},setView:function(view){
if(this._onTextModelChanged&&this._view){
this._view.removeEventListener("ModelChanged",this._listener.onTextModelChanged);
}
this._view=view;
if(this._onTextModelChanged&&this._view){
this._view.addEventListener("ModelChanged",this._listener.onTextModelChanged);
}
},onClick:function(_10e5,e){
},onDblClick:function(_10e6,e){
},onMouseMove:function(_10e7,e){
var _10e8=_10d1.Tooltip.getTooltip(this._view);
if(!_10e8){
return;
}
if(_10e8.isVisible()&&this._tooltipLineIndex===_10e7){
return;
}
this._tooltipLineIndex=_10e7;
var self=this;
_10e8.setTarget({y:e.clientY,getTooltipInfo:function(){
return self._getTooltipInfo(self._tooltipLineIndex,this.y);
}});
},onMouseOver:function(_10e9,e){
this.onMouseMove(_10e9,e);
},onMouseOut:function(_10ea,e){
var _10eb=_10d1.Tooltip.getTooltip(this._view);
if(!_10eb){
return;
}
_10eb.setTarget(null);
},_getTooltipInfo:function(_10ec,y){
if(_10ec===undefined){
return;
}
var view=this._view;
var model=view.getModel();
var _10ed=this._annotationModel;
var _10ee=[];
if(_10ed){
var start=model.getLineStart(_10ec);
var end=model.getLineEnd(_10ec);
if(model.getBaseModel){
start=model.mapOffset(start);
end=model.mapOffset(end);
}
_10ee=this.getAnnotationsByType(_10ed,start,end);
}
var _10ef=this._getTooltipContents(_10ec,_10ee);
if(!_10ef){
return null;
}
var info={contents:_10ef,anchor:this.getLocation()};
var rect=view.getClientArea();
if(this.getOverview()==="document"){
rect.y=view.convert({y:y},"view","document").y;
}else{
rect.y=view.getLocationAtOffset(model.getLineStart(_10ec)).y;
}
view.convert(rect,"document","page");
info.x=rect.x;
info.y=rect.y;
if(info.anchor==="right"){
info.x+=rect.width;
}
return info;
},_getTooltipContents:function(_10f0,_10f1){
return _10f1;
},_onAnnotationModelChanged:function(e){
var view=this._view;
if(!view){
return;
}
var model=view.getModel(),self=this;
var _10f2=model.getLineCount();
if(e.textModelChangedEvent){
var start=e.textModelChangedEvent.start;
if(model.getBaseModel){
start=model.mapOffset(start,true);
}
var _10f3=model.getLineAtOffset(start);
view.redrawLines(_10f3,_10f2,self);
return;
}
function _10f4(_10f5){
for(var i=0;i<_10f5.length;i++){
if(!self.isAnnotationTypeVisible(_10f5[i].type)){
continue;
}
var start=_10f5[i].start;
var end=_10f5[i].end;
if(model.getBaseModel){
start=model.mapOffset(start,true);
end=model.mapOffset(end,true);
}
if(start!==-1&&end!==-1){
view.redrawLines(model.getLineAtOffset(start),model.getLineAtOffset(Math.max(start,end-1))+1,self);
}
}
};
_10f4(e.added);
_10f4(e.removed);
_10f4(e.changed);
},_mergeAnnotation:function(_10f6,_10f7,_10f8,_10f9){
if(!_10f6){
_10f6={};
}
if(_10f8===0){
if(_10f6.html&&_10f7.html){
if(_10f7.html!==_10f6.html){
if(!_10f6._multiple&&this._multiAnnotation){
_10f6.html=this._multiAnnotation.html;
}
}
_10f6._multiple=true;
}else{
_10f6.html=_10f7.html;
}
}
_10f6.style=this._mergeStyle(_10f6.style,_10f7.style);
return _10f6;
},_mergeStyle:function(_10fa,style){
if(style){
if(!_10fa){
_10fa={};
}
if(_10fa.styleClass&&style.styleClass&&_10fa.styleClass!==style.styleClass){
_10fa.styleClass+=" "+style.styleClass;
}else{
_10fa.styleClass=style.styleClass;
}
var prop;
if(style.style){
if(!_10fa.style){
_10fa.style={};
}
for(prop in style.style){
if(!_10fa.style[prop]){
_10fa.style[prop]=style.style[prop];
}
}
}
if(style.attributes){
if(!_10fa.attributes){
_10fa.attributes={};
}
for(prop in style.attributes){
if(!_10fa.attributes[prop]){
_10fa.attributes[prop]=style.attributes[prop];
}
}
}
}
return _10fa;
}};
_10d0.AnnotationTypeList.addMixin(Ruler.prototype);
function _10fb(_10fc,_10fd,_10fe,_10ff,_1100){
Ruler.call(this,_10fc,_10fd,"page",_10fe);
this._oddStyle=_10ff||{style:{backgroundColor:"white"}};
this._evenStyle=_1100||{style:{backgroundColor:"white"}};
this._numOfDigits=0;
};
_10fb.prototype=new Ruler();
_10fb.prototype.getAnnotations=function(_1101,_1102){
var _1103=Ruler.prototype.getAnnotations.call(this,_1101,_1102);
var model=this._view.getModel();
for(var _1104=_1101;_1104<_1102;_1104++){
var style=_1104&1?this._oddStyle:this._evenStyle;
var _1105=_1104;
if(model.getBaseModel){
var _1106=model.getLineStart(_1105);
_1105=model.getBaseModel().getLineAtOffset(model.mapOffset(_1106));
}
if(!_1103[_1104]){
_1103[_1104]={};
}
_1103[_1104].html=(_1105+1)+"";
if(!_1103[_1104].style){
_1103[_1104].style=style;
}
}
return _1103;
};
_10fb.prototype.getWidestAnnotation=function(){
var _1107=this._view.getModel().getLineCount();
return this.getAnnotations(_1107-1,_1107)[_1107-1];
};
_10fb.prototype._onTextModelChanged=function(e){
var start=e.start;
var model=this._view.getModel();
var _1108=model.getBaseModel?model.getBaseModel().getLineCount():model.getLineCount();
var _1109=(_1108+"").length;
if(this._numOfDigits!==_1109){
this._numOfDigits=_1109;
var _110a=model.getLineAtOffset(start);
this._view.redrawLines(_110a,model.getLineCount(),this);
}
};
function _110b(_110c,_110d,_110e){
Ruler.call(this,_110c,_110d,"page",_110e);
};
_110b.prototype=new Ruler();
function _110f(_1110,_1111,_1112){
Ruler.call(this,_1110,_1111,"document",_1112);
};
_110f.prototype=new Ruler();
_110f.prototype.getRulerStyle=function(){
var _1113={style:{lineHeight:"1px",fontSize:"1px"}};
_1113=this._mergeStyle(_1113,this._rulerStyle);
return _1113;
};
_110f.prototype.onClick=function(_1114,e){
if(_1114===undefined){
return;
}
this._view.setTopIndex(_1114);
};
_110f.prototype._getTooltipContents=function(_1115,_1116){
if(_1116.length===0){
var model=this._view.getModel();
var _1117=_1115;
if(model.getBaseModel){
var _1118=model.getLineStart(_1117);
_1117=model.getBaseModel().getLineAtOffset(model.mapOffset(_1118));
}
return util.formatMessage(_10cf.line,_1117+1);
}
return Ruler.prototype._getTooltipContents.call(this,_1115,_1116);
};
_110f.prototype._mergeAnnotation=function(_1119,_111a,_111b,_111c){
if(_111b!==0){
return undefined;
}
var _111d=_1119;
if(!_111d){
var _111e=3*_111c;
_111d={html:"&nbsp;",style:{style:{height:_111e+"px"}}};
_111d.style=this._mergeStyle(_111d.style,_111a.overviewStyle);
}
return _111d;
};
function _111f(_1120,_1121,_1122){
_110b.call(this,_1120,_1121,_1122);
};
_111f.prototype=new _110b();
_111f.prototype.onClick=function(_1123,e){
if(_1123===undefined){
return;
}
var _1124=this._annotationModel;
if(!_1124){
return;
}
var view=this._view;
var model=view.getModel();
var start=model.getLineStart(_1123);
var end=model.getLineEnd(_1123,true);
if(model.getBaseModel){
start=model.mapOffset(start);
end=model.mapOffset(end);
model=model.getBaseModel();
}
var _1125,iter=_1124.getAnnotations(start,end);
while(!_1125&&iter.hasNext()){
var a=iter.next();
if(!this.isAnnotationTypeVisible(a.type)){
continue;
}
_1125=a;
}
if(_1125&&model.getLineAtOffset(_1125.start)===model.getLineAtOffset(start)){
var _1126=_10d1.Tooltip.getTooltip(this._view);
if(_1126){
_1126.setTarget(null);
}
if(_1125.expanded){
_1125.collapse();
}else{
_1125.expand();
}
this._annotationModel.modifyAnnotation(_1125);
}
};
_111f.prototype._getTooltipContents=function(_1127,_1128){
if(_1128.length===1){
if(_1128[0].expanded){
return null;
}
}
return _110b.prototype._getTooltipContents.call(this,_1127,_1128);
};
_111f.prototype._onAnnotationModelChanged=function(e){
if(e.textModelChangedEvent){
_110b.prototype._onAnnotationModelChanged.call(this,e);
return;
}
var view=this._view;
if(!view){
return;
}
var model=view.getModel(),self=this,i;
var _1129=model.getLineCount(),_112a=_1129;
function _112b(_112c){
for(i=0;i<_112c.length;i++){
if(!self.isAnnotationTypeVisible(_112c[i].type)){
continue;
}
var start=_112c[i].start;
if(model.getBaseModel){
start=model.mapOffset(start,true);
}
if(start!==-1){
_112a=Math.min(_112a,model.getLineAtOffset(start));
}
}
};
_112b(e.added);
_112b(e.removed);
_112b(e.changed);
var _112d=view.getRulers();
for(i=0;i<_112d.length;i++){
view.redrawLines(_112a,_1129,_112d[i]);
}
};
return {Ruler:Ruler,AnnotationRuler:_110b,LineNumberRuler:_10fb,OverviewRuler:_110f,FoldingRuler:_111f};
});
},"dijit/form/DropDownButton":function(){
require({cache:{"url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:_onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode,_popupStateNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n"}});
define("dijit/form/DropDownButton",["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_112e,lang,query,_112f,popup,_1130,_1131,_1132,_1133){
return _112e("dijit.form.DropDownButton",[_1130,_1131,_1132],{baseClass:"dijitDropDownButton",templateString:_1133,_fillContent:function(){
if(this.srcNodeRef){
var nodes=query("*",this.srcNodeRef);
this.inherited(arguments,[nodes[0]]);
this.dropDownContainer=this.srcNodeRef;
}
},startup:function(){
if(this._started){
return;
}
if(!this.dropDown&&this.dropDownContainer){
var _1134=query("[widgetId]",this.dropDownContainer)[0];
this.dropDown=_112f.byNode(_1134);
delete this.dropDownContainer;
}
if(this.dropDown){
popup.hide(this.dropDown);
}
this.inherited(arguments);
},isLoaded:function(){
var _1135=this.dropDown;
return (!!_1135&&(!_1135.href||_1135.isLoaded));
},loadDropDown:function(_1136){
var _1137=this.dropDown;
var _1138=_1137.on("load",lang.hitch(this,function(){
_1138.remove();
_1136();
}));
_1137.refresh();
},isFocusable:function(){
return this.inherited(arguments)&&!this._mouseDown;
}});
});
},"davinci/review/actions/RestartVersionAction":function(){
define("davinci/review/actions/RestartVersionAction",["dojo/_base/declare","./_ReviewNavigatorCommon","davinci/review/actions/PublishAction","davinci/Runtime",],function(_1139,_113a,_113b,_113c){
var _113d=_1139("davinci.review.actions.RestartVersionAction",[_113a],{run:function(_113e){
var _113f=this._getSelection(_113e);
if(!_113f||!_113f.length){
return;
}
var item=_113f[0].resource.elementType=="ReviewFile"?_113f[0].resource.parent:_113f[0].resource;
var _1140=new _113b(item,true);
_1140.run();
},isEnabled:function(_1141){
var _1142=this._getSelection(_1141);
if(!_1142||_1142.length==0){
return false;
}
var item=_1142[0].resource.elementType=="ReviewFile"?_1142[0].resource.parent:_1142[0].resource;
if(item.designerId==_113c.userName){
if(item.closed){
return true;
}
}
return false;
}});
return _113d;
});
},"davinci/ui/Resource":function(){
define("davinci/ui/Resource",["dojo/_base/declare","system/resource","../model/Path","../Runtime","../Workbench","../workbench/Preferences","../ve/RebuildPage","./Rename","./widgets/NewHTMLFileOptions","./widgets/OpenFile","./widgets/NewFolder","./widgets/NewFile","./widgets/AddFiles","./widgets/AddFilesZip","./NewProject","./Dialog","dojo/i18n!./nls/ui","davinci/Theme","dijit/form/Button","dojox/form/uploader/plugins/HTML5",],function(_1143,_1144,Path,_1145,_1146,_1147,_1148,_1149,_114a,_114b,_114c,_114d,_114e,_114f,_1150,_1151,uiNLS,Theme){
var _1152=function(_1153,_1154,type,_1155,_1156,_1157,_1158,_1159){
var _115a=_1158||_115b();
var _115c;
if(_115a){
if(_115a.elementType=="Folder"){
_115c=_115a;
}else{
_115c=_115a.parent;
}
}else{
var base=_1146.getProject();
var prefs=_1147.getPreferences("davinci.ui.ProjectPrefs",base);
if(prefs.webContentFolder!=null&&prefs.webContentFolder!=""){
var _115d=new Path(_1146.getProject()).append(prefs.webContentFolder);
_115c=_1144.findResource(_115d.toString());
}else{
_115c=_1144.findResource(_1146.getProject());
}
}
var _115e=_1157||_115f.getNewFileName("file",_115c,"."+type);
var _1160={newFileName:_115e,fileFieldLabel:_1153,folderFieldLabel:"Where:",finishButtonLabel:_1154,value:_115c,checkFileName:_1161,dialogSpecificClass:_1155,dialogSpecificClassOptions:_1156,optionalMessage:_1159};
return new _114d(_1160);
};
var _1161=function(_1162){
var _1163=_1144.findResource(_1162);
if(_1163){
alert("File already exists!");
}
return !_1163;
};
var _115b=function(){
return (_115f.getSelectedResources()||[])[0];
};
var _115f={newHTMLDialogSpecificClass:"davinci/ui/widgets/NewHTMLFileOptions",newHTMLMobile:function(){
this.newHTML({comptype:"mobile",title:uiNLS.createMobileApplication,dialogSpecificClassOptions:{showDevices:true,showThemeSetsButton:true}});
},newHTMLDesktop:function(){
this.newHTML({comptype:"desktop",title:uiNLS.createDesktopApplication,dialogSpecificClassOptions:{showDevices:false,showThemeSetsButton:true},device:"desktop"});
},newHTMLSketchHiFi:function(){
this.newHTML({comptype:"sketchhifi",title:uiNLS.createSketchHiFi,dialogSpecificClassOptions:{showDevices:false,showThemeSetsButton:true},layout:"absolute",theme:"claro"});
},newHTMLSketchLoFi:function(){
this.newHTML({comptype:"sketchlofi",title:uiNLS.createSketchLoFi,dialogSpecificClassOptions:{showDevices:false,showThemeSetsButton:false},layout:"absolute",theme:"Sketch"});
},newHTML:function(_1164){
var _1165=this.newHTMLDialogSpecificClass;
var _1166=_1164?_1164.dialogSpecificClassOptions:null;
var _1167=_1152(uiNLS.fileName,uiNLS.create,"html",_1165,_1166);
var _1168=function(){
var _1169,_116a;
if(_1167.dialogSpecificWidget){
_1169=_1167.dialogSpecificWidget;
_116a=_1169.getOptions();
}
var _116b=_1167.get("value");
var _116c=_1144.createResource(_116b);
_116c.isNew=true;
_116c.dirtyResource=true;
var text=_1144.createText("HTML",{resource:_116c});
if(text){
_116c.setText(text);
}
var _116d="none";
if(_1164&&_1164.dialogSpecificClassOptions&&_1164.dialogSpecificClassOptions.showDevices){
_116d=_116a?_116a.device:"none";
}
var _116e=(_1164&&_1164.layout)?_1164.layout:true;
_116e=_116e+"";
var theme=(_1164&&_1164.theme)?_1164.theme:null;
var _116f=null;
if(_1164&&_1164.dialogSpecificClassOptions&&_1164.dialogSpecificClassOptions.showThemeSetsButton){
theme=_116a?_116a.theme:null;
_116f=_1167.dialogSpecificWidget?_1167.dialogSpecificWidget._selectedThemeSet:null;
}
var _1170={comptype:_1164.comptype,device:_116d,flowlayout:_116e,theme:theme,themeSet:_116f};
_115f.openResource(_116c,_1170);
var _1171=_1146.workbenchStateCustomPropGet("nhfo");
if(!_1171){
_1171={};
}
var _1172=_1146.getActiveProject();
_1171[_1172]=_116a;
_1146.workbenchStateCustomPropSet("nhfo",_1171);
};
_1146.showModal(_1167,_1164.title,"",_1168,true);
},newCSS:function(){
var _1173=_1152(uiNLS.fileName,uiNLS.create,"css");
var _1174=function(){
var _1175=_1173.get("value");
var _1176=_1144.createResource(_1175);
_1176.isNew=true;
var text=_1144.createText("CSS",{resource:_1176});
if(text){
_1176.setText(text);
}
_115f.openResource(_1176);
};
_1146.showModal(_1173,uiNLS.createNewCSSFile,"",_1174,true);
},selectResource:function(_1177){
var _1178=dijit.byId("resourceTree");
var path=[];
for(var i=_1177;i.parent;i=i.parent){
path.unshift(i);
}
_1178.set("path",path);
},newFolder:function(_1179,_117a){
var _117b=_1179||_115b();
var _117c;
if(_117b){
if(_117b.elementType=="Folder"){
_117c=_117b;
}else{
_117c=_117b.parent;
}
}else{
var base=_1146.getProject();
var prefs=_1147.getPreferences("davinci.ui.ProjectPrefs",base);
if(prefs.webContentFolder!=null&&prefs.webContentFolder!=""){
var _117d=new Path(_1146.getProject()).append(prefs.webContentFolder);
_117c=_1144.findResource(_117d.toString());
}
if(!_117c){
_117c=_1144.findResource(_1146.getProject());
}
}
var _117e=_115f.getNewFileName("folder",_117c);
var _117f={newFileName:_117e,fileFieldLabel:uiNLS.folderName,folderFieldLabel:uiNLS.parentFolder,root:_117c,finishButtonLabel:uiNLS.createFolder,checkFileName:_1161};
var _1180=new _114c(_117f);
var _1181=false;
var _1182;
var _1183=function(){
var _1184=_1180.get("value");
_1182=_1144.createResource(_1184,true);
if(_117a){
_117a(_1182);
}
if(_1182!=null){
_115f.selectResource(_1182);
}
};
_1146.showModal(_1180,uiNLS.createNewFolder,"",_1183,true);
},closeEditor:function(_1185,flush){
var _1186=_1146.getOpenEditor(_1185);
if(_1186!=null){
if(flush){
_1186.save();
}
_1186.editorContainer.forceClose(_1186);
}
return _1186!=null;
},save:function(){
var _1187=_1146.getOpenEditor();
if(_1187){
system.resource.findResourceAsync(_1187.fileName).then(dojo.hitch(this,function(_1188){
if(_1188.readOnly()){
this.saveAs(_1188.getExtension(),uiNLS.savingReadonlyFile);
}else{
_1187.save();
}
}));
}
},saveAs:function(_1189,_118a){
var _118b=_1146.getOpenEditor();
var _118c=_118b.fileName;
var _118d=new Path(_118c).lastSegment();
var _118e=_1144.findResource(_118c);
var _118f=_1152(uiNLS.fileName,uiNLS.save,_1189,null,null,_118d,_118e,_118a);
var _1190=function(){
var _1191=_118f.get("value");
var _1192=_1144.findResource(_118c);
var _1193;
var _1194;
var theme;
if(_118b.editorID=="davinci.html.CSSEditor"){
_1193=_118b.getText();
}else{
_1193=(_118b.model&&_118b.model.getText)?_118b.model.getText():_118b.getText();
}
if(_118b.editorID=="davinci.ve.HTMLPageEditor"){
_1194=Theme.getThemeSet(_118b.visualEditor.context);
theme=_118b.visualEditor.context.theme;
}
var _1195=_1144.findResource(_1191);
_118b.editorContainer.forceClose(_118b);
if(_1195){
_1195.removeWorkingCopy();
_1195.deleteResource();
}
_118b.isDirty=false;
var file=_1144.createResource(_1191);
new _1148().rebuildSource(_1193,file,theme,_1194).then(function(_1196){
file.setContents(_1196).then(function(){
_1146.openEditor({fileName:file});
});
});
};
_1146.showModal(_118f,uiNLS.saveFileAs,"",_1190);
},newJS:function(){
var _1197=_1152(uiNLS.fileName,uiNLS.create,"js");
var _1198=function(){
var _1199=_1197.get("value");
var _119a=_1144.createResource(_1199);
_119a.isNew=true;
var text=_1144.createText("CSS",{resource:_119a});
if(text){
_119a.setText(text);
}
_115f.openResource(_119a);
};
_1146.showModal(_1197,uiNLS.createNewJSFile,"",_1198);
},openFile:function(){
var _119b,_119c=_115b();
if(_119c){
if(_119c.elementType=="Folder"){
_119b=_119c;
}else{
_119b=_119c.parent;
}
}else{
_119b=_1144.findResource(_1146.getProject());
}
var _119d={finishButtonLabel:uiNLS.open};
var _119e=new _114b(_119d);
var _119f=function(){
_115f.openResource(_119e.get("value"));
};
_1146.showModal(_119e,uiNLS.openFile,{width:350,height:250},_119f,true);
},addFiles:function(){
var _11a0=new _114e({selectedResource:_115b()});
_1146.showModal(_11a0,uiNLS.addFiles,{width:350},null);
},addFilesZip:function(){
var _11a1=new _114f({selectedResource:_115b()});
_1146.showModal(_11a1,uiNLS.addFiles,{width:350},null);
},getNewFileName:function(_11a2,_11a3,_11a4){
var _11a5,_11a6;
var count=0;
if(!_11a4){
_11a4="";
}
do{
count++;
if(_11a2==="folder"){
_11a6="folder"+count;
}else{
_11a6="file"+count+_11a4;
}
var _11a7=_11a3.getPath()+"/"+_11a6;
_11a5=_1144.findResource(_11a7);
}while(_11a5);
return _11a6;
},canModify:function(item){
return !item.readOnly();
},newProject:function(){
var _11a8=new _1150({});
_1146.showModal(_11a8,uiNLS.newProject,{"min-width":"330px"},null,true);
},renameAction:function(){
var _11a9=_115f.getSelectedResources();
if(_11a9.length!=1){
return;
}
var _11aa=_11a9[0];
_11aa.parent.getChildren(function(_11ab){
var _11ac=_11ab.map(function(child){
return child.name;
});
var _11ad=new _1149({value:_11aa.name,invalid:_11ac});
_1146.showModal(_11ad,uiNLS.renameDialogTitle,"",function(){
var _11ae=_11ad.attr("cancel");
var _11af=_11ad.attr("value");
if(!_11ae){
var _11b0=_115f.closeEditor(_11aa,true);
_11aa.rename(_11af).then(function(){
if(_11b0){
_115f.openResource(_11aa);
}
});
}
return true;
},true);
},true);
},getResourceIcon:function(item,_11b1){
var _11b2=item.readOnly();
if(item.elementType=="Folder"){
if(_11b2){
return _11b1?"dijitFolderOpened maqettaReadonlyFolderOpened":"dijitFolderClosed maqettaReadonlyFolderClosed";
}else{
return _11b1?"dijitFolderOpened":"dijitFolderClosed";
}
}
if(item.elementType=="File"){
var icon;
fileType=item.getExtension();
extension=_1145.getExtension("davinci.fileType",function(_11b3){
return _11b3.extension==fileType;
});
if(extension){
icon=extension.iconClass;
if(_11b2){
icon+="ReadOnly";
}
}
if(!icon){
icon="dijitLeaf";
if(_11b2){
icon+=" maqettaReadonlyFile";
}
}
return icon;
}
return this.prototype.getIconClass(item,_11b1);
},getResourceClass:function(item){
if(item.readOnly()){
return "readOnlyResource";
}
},deleteAction:function(){
var _11b4=_115f.getSelectedResources(),paths=_11b4.map(function(_11b5){
return _11b5.getPath();
}).join("\n\t");
var _11b6=dojo.string.substitute(uiNLS.areYouSureDelete,[paths]);
_11b6+="\n\n"+uiNLS.NoteOperationNotUndoable+"\n";
if(!confirm(_11b6)){
return;
}
_11b4.forEach(function(_11b7){
_115f.closeEditor(_11b7);
_11b7.deleteResource();
});
},getSelectedResources:function(){
var _11b8=_1145.getSelection();
if(_11b8[0]&&_11b8[0].resource){
return dojo.map(_11b8,function(item){
return item.resource;
});
}
},alphabeticalSortFilter:{filterList:function(list){
return list.sort(function(file1,file2){
return file1.name>file2.name?1:file1.name<file2.name?-1:0;
});
}},foldersFilter:{filterItem:function(item){
if(item.elementType=="File"){
return true;
}
}},openPath:function(path,text){
var _11b9={fileName:path};
if(text){
_11b9.text=text;
}
_1146.openEditor(_11b9);
},openResource:function(_11ba,_11bb){
if(_11ba.elementType=="File"){
_11ba.getContent().then(function(_11bc){
_1146.openEditor({fileName:_11ba,content:_11bc},_11bb);
});
}
}};
return dojo.setObject("davinci.ui.Resource",_115f);
});
},"dojo/regexp":function(){
define("dojo/regexp",["./_base/kernel","./_base/lang"],function(dojo,lang){
var _11bd={};
lang.setObject("dojo.regexp",_11bd);
_11bd.escapeString=function(str,_11be){
return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){
if(_11be&&_11be.indexOf(ch)!=-1){
return ch;
}
return "\\"+ch;
});
};
_11bd.buildGroupRE=function(arr,re,_11bf){
if(!(arr instanceof Array)){
return re(arr);
}
var b=[];
for(var i=0;i<arr.length;i++){
b.push(re(arr[i]));
}
return _11bd.group(b.join("|"),_11bf);
};
_11bd.group=function(_11c0,_11c1){
return "("+(_11c1?"?:":"")+_11c0+")";
};
return _11bd;
});
},"davinci/XPathUtils":function(){
define("davinci/XPathUtils",function(){
function _11c2(node){
this.node=node;
};
var _11c3="__XPATH_UTILS_TEMP_ID__";
_11c2.prototype={name:function(){
return this.node.nodeName;
},parent:function(){
var _11c4=this.node.parentNode;
if(_11c4!==this.node.ownerDocument){
return new _11c2(_11c4);
}
},index:function(){
var tag=this.node.nodeName,_11c5=this.node.parentNode,_11c6=false,elems,idx=0;
if(!_11c5.id){
_11c5.id=_11c3+Date.now();
_11c6=true;
}
elems=_11c5.querySelectorAll("#"+_11c5.id+">"+tag);
if(elems.length>1){
for(var i=0,len=elems.length;i<len;i++){
if(elems[i]===this.node){
idx=i+1;
break;
}
}
}
if(_11c6){
_11c5.id="";
}
return idx;
}};
var _11c7=/(\w+)(?:\[(\d+)\])?/;
return {getXPath:function(node,_11c8){
function _11c9(path,elem){
var tag=elem.name(),_11ca=elem.parent();
if(_11ca){
var idx=elem.index();
if(idx){
tag+="["+idx+"]";
}else{
tag+="["+1+"]";
}
path=tag+(path?"/"+path:"");
return _11c9(path,_11ca);
}
return "/"+tag+"/"+path;
};
_11c8=_11c8||_11c2;
var elem=new _11c8(node);
return _11c9("",elem).toLowerCase();
},toCssPath:function(xpath){
if(xpath.charAt(0)==="/"){
xpath=xpath.substr(1);
}
var str="";
xpath.split("/").forEach(function(path){
var m=path.match(_11c7),tag=m[1],idx=m[2];
str+=(str?">":"")+tag;
if(idx){
str+=":nth-of-type("+idx+")";
}
});
return str;
}};
});
},"davinci/ve/actions/ManageStates":function(){
define("davinci/ve/actions/ManageStates",["dojo/_base/declare","davinci/Runtime","davinci/Workbench","davinci/ve/actions/ContextAction","davinci/workbench/Preferences","dijit/registry","davinci/ve/States","davinci/actions/Action","dojo/i18n!davinci/ve/nls/ve","davinci/ve/actions/_ManageStatesWidget"],function(_11cb,_11cc,_11cd,_11ce,_11cf,_11d0,_11d1,_11d2,veNls,_11d3){
return _11cb("davinci.ve.actions.ManageStates",[_11ce],{run:function(){
var _11d4;
if(_11cc.currentEditor&&_11cc.currentEditor.currentEditor&&_11cc.currentEditor.currentEditor.context){
_11d4=_11cc.currentEditor.currentEditor.context;
}else{
return;
}
var _11d5=_11d1.getFocus(_11d4.rootNode);
if(!_11d5||!_11d5.stateContainerNode){
return;
}
var w=new davinci.ve.actions._ManageStatesWidget({node:_11d5.stateContainerNode});
w._calledBy="ManageStates";
w.okButton.set("label",veNls.updateLabel);
w.updateDialog();
var _11d6=_11cd.showModal(w,veNls.manageStates,{width:400},null,true);
},isEnabled:function(_11d7){
_11d7=this.fixupContext(_11d7);
var e=_11cd.getOpenEditor();
if(e&&_11d7){
if(e.declaredClass=="davinci.ve.PageEditor"){
return (_11d7.getSelection().length>0);
}else{
return false;
}
}else{
return false;
}
},shouldShow:function(_11d8){
_11d8=this.fixupContext(_11d8);
var _11d9=_11d8?_11d8.editor:null;
return (_11d9&&_11d9.declaredClass=="davinci.ve.PageEditor");
}});
});
},"dojox/grid/_FocusManager":function(){
define("dojox/grid/_FocusManager",["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(array,lang,_11da,_11db,event,has,query,util,html){
return _11da("dojox.grid._FocusManager",null,{constructor:function(_11dc){
this.grid=_11dc;
this.cell=null;
this.rowIndex=-1;
this._connects=[];
this._headerConnects=[];
this.headerMenu=this.grid.headerMenu;
this._connects.push(_11db.connect(this.grid.domNode,"onfocus",this,"doFocus"));
this._connects.push(_11db.connect(this.grid.domNode,"onblur",this,"doBlur"));
this._connects.push(_11db.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));
this._connects.push(_11db.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));
this._connects.push(_11db.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));
this._connects.push(_11db.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));
this._connects.push(_11db.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));
this._connects.push(_11db.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));
this._connects.push(_11db.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));
},destroy:function(){
array.forEach(this._connects,_11db.disconnect);
array.forEach(this._headerConnects,_11db.disconnect);
delete this.grid;
delete this.cell;
},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){
this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];
this._initColumnHeaders();
},isFocusCell:function(_11dd,_11de){
return (this.cell==_11dd)&&(this.rowIndex==_11de);
},isLastFocusCell:function(){
if(this.cell){
return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);
}
return false;
},isFirstFocusCell:function(){
if(this.cell){
return (this.rowIndex===0)&&(this.cell.index===0);
}
return false;
},isNoFocusCell:function(){
return (this.rowIndex<0)||!this.cell;
},isNavHeader:function(){
return (!!this._colHeadNode);
},getHeaderIndex:function(){
if(this._colHeadNode){
return array.indexOf(this._findHeaderCells(),this._colHeadNode);
}else{
return -1;
}
},_focusifyCellNode:function(_11df){
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
html.toggleClass(n,this.focusClass,_11df);
if(_11df){
var sl=this.scrollIntoView();
try{
if(has("webkit")||!this.grid.edit.isEditing()){
util.fire(n,"focus");
if(sl){
this.cell.view.scrollboxNode.scrollLeft=sl;
}
}
}
catch(e){
}
}
}
},_delayedCellFocus:function(){
if(this.isNavHeader()||!this.grid.focused){
return;
}
var n=this.cell&&this.cell.getNode(this.rowIndex);
if(n){
try{
if(!this.grid.edit.isEditing()){
html.toggleClass(n,this.focusClass,true);
if(this._colHeadNode){
this.blurHeader();
}
util.fire(n,"focus");
}
}
catch(e){
}
}
},_delayedHeaderFocus:function(){
if(this.isNavHeader()){
this.focusHeader();
}
},_initColumnHeaders:function(){
array.forEach(this._headerConnects,_11db.disconnect);
this._headerConnects=[];
var _11e0=this._findHeaderCells();
for(var i=0;i<_11e0.length;i++){
this._headerConnects.push(_11db.connect(_11e0[i],"onfocus",this,"doColHeaderFocus"));
this._headerConnects.push(_11db.connect(_11e0[i],"onblur",this,"doColHeaderBlur"));
}
},_findHeaderCells:function(){
var _11e1=query("th",this.grid.viewsHeaderNode);
var _11e2=[];
for(var i=0;i<_11e1.length;i++){
var aHead=_11e1[i];
var _11e3=html.hasAttr(aHead,"tabIndex");
var _11e4=html.attr(aHead,"tabIndex");
if(_11e3&&_11e4<0){
_11e2.push(aHead);
}
}
return _11e2;
},_setActiveColHeader:function(_11e5,_11e6,_11e7){
this.grid.domNode.setAttribute("aria-activedescendant",_11e5.id);
if(_11e7!=null&&_11e7>=0&&_11e7!=_11e6){
html.toggleClass(this._findHeaderCells()[_11e7],this.focusClass,false);
}
html.toggleClass(_11e5,this.focusClass,true);
this._colHeadNode=_11e5;
this._colHeadFocusIdx=_11e6;
this._scrollHeader(this._colHeadFocusIdx);
},scrollIntoView:function(){
var info=(this.cell?this._scrollInfo(this.cell):null);
if(!info||!info.s){
return null;
}
var rt=this.grid.scroller.findScrollTop(this.rowIndex);
if(info.n&&info.sr){
if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}
}
}
if(info.r&&info.sr){
if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){
this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);
}else{
if(rt<info.sr.t){
this.grid.setScrollTop(rt);
}
}
}
return info.s.scrollLeft;
},_scrollInfo:function(cell,_11e8){
if(cell){
var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);
return {c:cl,s:sbn,sr:sbnr,n:(_11e8?_11e8:cell.getNode(this.rowIndex)),r:rn};
}
return null;
},_scrollHeader:function(_11e9){
var info=null;
if(this._colHeadNode){
var cell=this.grid.getCell(_11e9);
if(!cell){
return;
}
info=this._scrollInfo(cell,cell.getNode(0));
}
if(info&&info.s&&info.sr&&info.n){
var _11ea=info.sr.l+info.sr.w;
if(info.n.offsetLeft+info.n.offsetWidth>_11ea){
info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;
}else{
if(info.n.offsetLeft<info.sr.l){
info.s.scrollLeft=info.n.offsetLeft;
}else{
if(has("ie")<=7&&cell&&cell.view.headerNode){
cell.view.headerNode.scrollLeft=info.s.scrollLeft;
}
}
}
}
},_isHeaderHidden:function(){
var _11eb=this.focusView;
if(!_11eb){
for(var i=0,cView;(cView=this.grid.views.views[i]);i++){
if(cView.headerNode){
_11eb=cView;
break;
}
}
}
return (_11eb&&html.getComputedStyle(_11eb.headerNode).display=="none");
},colSizeAdjust:function(e,_11ec,delta){
var _11ed=this._findHeaderCells();
var view=this.focusView;
if(!view||!view.header.tableMap.map){
for(var i=0,cView;(cView=this.grid.views.views[i]);i++){
if(cView.header.tableMap.map){
view=cView;
break;
}
}
}
var _11ee=_11ed[_11ec];
if(!view||(_11ec==_11ed.length-1&&_11ec===0)){
return;
}
view.content.baseDecorateEvent(e);
e.cellNode=_11ee;
e.cellIndex=view.content.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
if(view.header.canResize(e)){
var _11ef={l:delta};
var drag=view.header.colResizeSetup(e,false);
view.header.doResizeColumn(drag,null,_11ef);
view.update();
}
},styleRow:function(inRow){
return;
},setFocusIndex:function(_11f0,_11f1){
this.setFocusCell(this.grid.getCell(_11f1),_11f0);
},setFocusCell:function(_11f2,_11f3){
if(_11f2&&!this.isFocusCell(_11f2,_11f3)){
this.tabbingOut=false;
if(this._colHeadNode){
this.blurHeader();
}
this._colHeadNode=this._colHeadFocusIdx=null;
this.focusGridView();
this._focusifyCellNode(false);
this.cell=_11f2;
this.rowIndex=_11f3;
this._focusifyCellNode(true);
}
if(has("opera")){
setTimeout(lang.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);
}else{
this.grid.onCellFocus(this.cell,this.rowIndex);
}
},next:function(){
if(this.cell){
var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;
if(col>cc){
col=0;
row++;
}
if(row>rc){
col=cc;
row=rc;
}
if(this.grid.edit.isEditing()){
var _11f4=this.grid.getCell(col);
if(!this.isLastFocusCell()&&(!_11f4.editable||this.grid.canEdit&&!this.grid.canEdit(_11f4,row))){
this.cell=_11f4;
this.rowIndex=row;
this.next();
return;
}
}
this.setFocusIndex(row,col);
}
},previous:function(){
if(this.cell){
var row=(this.rowIndex||0),col=(this.cell.index||0)-1;
if(col<0){
col=this.grid.layout.cellCount-1;
row--;
}
if(row<0){
row=0;
col=0;
}
if(this.grid.edit.isEditing()){
var _11f5=this.grid.getCell(col);
if(!this.isFirstFocusCell()&&!_11f5.editable){
this.cell=_11f5;
this.rowIndex=row;
this.previous();
return;
}
}
this.setFocusIndex(row,col);
}
},move:function(_11f6,_11f7){
var _11f8=_11f7<0?-1:1;
if(this.isNavHeader()){
var _11f9=this._findHeaderCells();
var _11fa=currentIdx=array.indexOf(_11f9,this._colHeadNode);
currentIdx+=_11f7;
while(currentIdx>=0&&currentIdx<_11f9.length&&_11f9[currentIdx].style.display=="none"){
currentIdx+=_11f8;
}
if((currentIdx>=0)&&(currentIdx<_11f9.length)){
this._setActiveColHeader(_11f9[currentIdx],currentIdx,_11fa);
}
}else{
if(this.cell){
var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_11f6));
if(_11f6){
if(_11f6>0){
if(row>sc.getLastPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));
}
}else{
if(_11f6<0){
if(row<=sc.getPageRow(sc.page)){
this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));
}
}
}
}
var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_11f7));
var cell=this.grid.getCell(col);
while(col>=0&&col<cc&&cell&&cell.hidden===true){
col+=_11f8;
cell=this.grid.getCell(col);
}
if(!cell||cell.hidden===true){
col=i;
}
var n=cell.getNode(row);
if(!n&&_11f6){
if((row+_11f6)>=0&&(row+_11f6)<=rc){
this.move(_11f6>0?++_11f6:--_11f6,_11f7);
}
return;
}else{
if((!n||html.style(n,"display")==="none")&&_11f7){
if((col+_11f7)>=0&&(col+_11f7)<=cc){
this.move(_11f6,_11f7>0?++_11f7:--_11f7);
}
return;
}
}
this.setFocusIndex(row,col);
if(_11f6){
this.grid.updateRow(r);
}
}
}
},previousKey:function(e){
if(this.grid.edit.isEditing()){
event.stop(e);
this.previous();
}else{
if(!this.isNavHeader()&&!this._isHeaderHidden()){
this.grid.domNode.focus();
event.stop(e);
}else{
this.tabOut(this.grid.domNode);
if(this._colHeadFocusIdx!=null){
html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);
this._colHeadFocusIdx=null;
}
this._focusifyCellNode(false);
}
}
},nextKey:function(e){
var _11fb=(this.grid.rowCount===0);
if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){
this.focusHeader();
event.stop(e);
}else{
if(this.isNavHeader()){
this.blurHeader();
if(!this.findAndFocusGridCell()){
this.tabOut(this.grid.lastFocusNode);
}
this._colHeadNode=this._colHeadFocusIdx=null;
}else{
if(this.grid.edit.isEditing()){
event.stop(e);
this.next();
}else{
this.tabOut(this.grid.lastFocusNode);
}
}
}
},tabOut:function(_11fc){
this.tabbingOut=true;
_11fc.focus();
},focusGridView:function(){
util.fire(this.focusView,"focus");
},focusGrid:function(_11fd){
this.focusGridView();
this._focusifyCellNode(true);
},findAndFocusGridCell:function(){
var _11fe=true;
var _11ff=(this.grid.rowCount===0);
if(this.isNoFocusCell()&&!_11ff){
var _1200=0;
var cell=this.grid.getCell(_1200);
if(cell.hidden){
_1200=this.isNavHeader()?this._colHeadFocusIdx:0;
}
this.setFocusIndex(0,_1200);
}else{
if(this.cell&&!_11ff){
if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){
this.grid.scrollToRow(this.rowIndex);
}
this.focusGrid();
}else{
_11fe=false;
}
}
this._colHeadNode=this._colHeadFocusIdx=null;
return _11fe;
},focusHeader:function(){
var _1201=this._findHeaderCells();
var _1202=this._colHeadFocusIdx;
if(this._isHeaderHidden()){
this.findAndFocusGridCell();
}else{
if(!this._colHeadFocusIdx){
if(this.isNoFocusCell()){
this._colHeadFocusIdx=0;
}else{
this._colHeadFocusIdx=this.cell.index;
}
}
}
this._colHeadNode=_1201[this._colHeadFocusIdx];
while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_1201.length&&this._colHeadNode.style.display=="none"){
this._colHeadFocusIdx++;
this._colHeadNode=_1201[this._colHeadFocusIdx];
}
if(this._colHeadNode&&this._colHeadNode.style.display!="none"){
if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){
this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);
this.headerMenu.bindDomNode(this.grid.domNode);
this._contextMenuBindNode=this.grid.domNode;
}
this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_1202);
this._scrollHeader(this._colHeadFocusIdx);
this._focusifyCellNode(false);
}else{
this.findAndFocusGridCell();
}
},blurHeader:function(){
html.removeClass(this._colHeadNode,this.focusClass);
html.removeAttr(this.grid.domNode,"aria-activedescendant");
if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){
var _1203=this.grid.viewsHeaderNode;
this.headerMenu.unBindDomNode(this.grid.domNode);
this.headerMenu.bindDomNode(_1203);
this._contextMenuBindNode=_1203;
}
},doFocus:function(e){
if(e&&e.target!=e.currentTarget){
event.stop(e);
return;
}
if(this._clickFocus){
return;
}
if(!this.tabbingOut){
this.focusHeader();
}
this.tabbingOut=false;
event.stop(e);
},doBlur:function(e){
event.stop(e);
},doContextMenu:function(e){
if(!this.headerMenu){
event.stop(e);
}
},doLastNodeFocus:function(e){
if(this.tabbingOut){
this._focusifyCellNode(false);
}else{
if(this.grid.rowCount>0){
if(this.isNoFocusCell()){
this.setFocusIndex(0,0);
}
this._focusifyCellNode(true);
}else{
this.focusHeader();
}
}
this.tabbingOut=false;
event.stop(e);
},doLastNodeBlur:function(e){
event.stop(e);
},doColHeaderFocus:function(e){
this._setActiveColHeader(e.target,html.attr(e.target,"idx"),this._colHeadFocusIdx);
this._scrollHeader(this.getHeaderIndex());
event.stop(e);
},doColHeaderBlur:function(e){
html.toggleClass(e.target,this.focusClass,false);
},_mouseDown:function(e){
this._clickFocus=dojo.some(this.grid.views.views,function(v){
return v.scrollboxNode===e.target;
});
},_mouseUp:function(e){
this._clickFocus=false;
}});
});
},"davinci/ve/utils/ImageUtils":function(){
define("davinci/ve/utils/ImageUtils",[],function(){
return {ImageUpdateFocus:function(_1204,_1205){
if(_1205&&_1204&&_1204.domNode&&_1204.domNode.tagName==="IMG"){
var conn=dojo.connect(_1204.domNode,"onload",function(){
var _1206=_1205.getSelection();
for(var i=0;i<_1206.length;i++){
if(_1206[i]==_1204){
_1205.updateFocus(_1204,i);
break;
}
}
dojo.disconnect(conn);
});
}
}};
});
},"davinci/review/model/resource/File":function(){
define("davinci/review/model/resource/File",["dojo/_base/declare","davinci/Runtime","davinci/model/resource/File","davinci/model/Path","dojo/Deferred"],function(_1207,_1208,File,Path,_1209){
return _1207("davinci.review.model.resource.File",File,{constructor:function(name,_120a){
this.elementType="ReviewFile";
this.name=name;
this.parent=_120a;
this.extension="rev";
},getLabel:function(){
var path=new Path(this.name);
var _120b=path.getSegments();
var _120c=_1208.getExtension("davinci.editor",function(_120d){
return _120d.id==="davinci.review.CommentReviewEditor";
});
var _120e="."+_120c.extensions;
return label=_120b[_120b.length-1]+_120e;
},getContentSync:function(){
return "";
},getContent:function(){
return new _1209().resolve("");
},removeWorkingCopy:function(){
return;
}});
});
},"dijit/_TimePicker":function(){
require({cache:{"url:dijit/templates/TimePicker.html":"<div id=\"widget_${id}\" class=\"dijitMenu\"\n    ><div data-dojo-attach-point=\"upArrow\" class=\"dijitButtonNode dijitUpArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9650;</div></div\n    ><div data-dojo-attach-point=\"timeMenu,focusNode\" data-dojo-attach-event=\"onclick:_onOptionSelected,onmouseover,onmouseout\"></div\n    ><div data-dojo-attach-point=\"downArrow\" class=\"dijitButtonNode dijitDownArrowButton\" data-dojo-attach-event=\"onmouseenter:_buttonMouse,onmouseleave:_buttonMouse\"\n\t\t><div class=\"dijitReset dijitInline dijitArrowButtonInner\" role=\"presentation\">&#160;</div\n\t\t><div class=\"dijitArrowButtonChar\">&#9660;</div></div\n></div>\n"}});
define("dijit/_TimePicker",["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","./typematic","./_Widget","./_TemplatedMixin","./form/_FormValueWidget","dojo/text!./templates/TimePicker.html"],function(array,ddate,_120f,stamp,_1210,_1211,_1212,event,_1213,keys,lang,has,query,mouse,_1214,_1215,_1216,_1217,_1218){
var _1219=_1210("dijit._TimePicker",[_1215,_1216],{templateString:_1218,baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",visibleRange:"T05:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:stamp.toISOString,setValue:function(value){
_1213.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
this.set("value",value);
},_setValueAttr:function(date){
this._set("value",date);
this._showText();
},_setFilterStringAttr:function(val){
this._set("filterString",val);
this._showText();
},isDisabledDate:function(){
return false;
},_getFilteredNodes:function(start,_121a,_121b,_121c){
var nodes=[],_121d=_121c?_121c.date:this._refDate,n,i=start,max=this._maxIncrement+Math.abs(i),chk=_121b?-1:1,dec=_121b?1:0,inc=1-dec;
do{
i-=dec;
n=this._createOption(i);
if(n){
if((_121b&&n.date>_121d)||(!_121b&&n.date<_121d)){
break;
}
nodes[_121b?"unshift":"push"](n);
_121d=n.date;
}
i+=inc;
}while(nodes.length<_121a&&(i*chk)<max);
return nodes;
},_showText:function(){
var _121e=stamp.fromISOString;
this.timeMenu.innerHTML="";
this._clickableIncrementDate=_121e(this.clickableIncrement);
this._visibleIncrementDate=_121e(this.visibleIncrement);
this._visibleRangeDate=_121e(this.visibleRange);
var _121f=function(date){
return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();
},_1220=_121f(this._clickableIncrementDate),_1221=_121f(this._visibleIncrementDate),_1222=_121f(this._visibleRangeDate),time=(this.value||this.currentFocus).getTime();
this._refDate=new Date(time-time%(_1220*1000));
this._refDate.setFullYear(1970,0,1);
this._clickableIncrement=1;
this._totalIncrements=_1222/_1220;
this._visibleIncrement=_1221/_1220;
this._maxIncrement=(60*60*24)/_1220;
var count=Math.min(this._totalIncrements,10),after=this._getFilteredNodes(0,(count>>1)+1,false),_1223=[],_1224=count-after.length,_1225=this._getFilteredNodes(0,_1224,true,after[0]);
if(_1225.length<_1224&&after.length>0){
_1223=this._getFilteredNodes(after[after.length-1].idx+1,_1224-_1225.length,false,after[after.length-1]);
}
array.forEach(_1225.concat(after,_1223),function(n){
this.timeMenu.appendChild(n);
},this);
if(!_1225.length&&!after.length&&!_1223.length&&this.filterString){
this.filterString="";
this._showText();
}
},constructor:function(){
this.constraints={};
},postMixInProperties:function(){
this.inherited(arguments);
this._setConstraintsAttr(this.constraints);
},_setConstraintsAttr:function(_1226){
lang.mixin(this,_1226);
if(!_1226.locale){
_1226.locale=this.lang;
}
},postCreate:function(){
this.connect(this.timeMenu,mouse.wheel,"_mouseWheeled");
this.own(_1214.addMouseListener(this.upArrow,this,"_onArrowUp",33,250),_1214.addMouseListener(this.downArrow,this,"_onArrowDown",33,250));
this.inherited(arguments);
},_buttonMouse:function(e){
_1211.toggle(e.currentTarget,e.currentTarget==this.upArrow?"dijitUpArrowHover":"dijitDownArrowHover",e.type=="mouseenter"||e.type=="mouseover");
},_createOption:function(index){
var date=new Date(this._refDate);
var _1227=this._clickableIncrementDate;
date.setTime(date.getTime()+_1227.getHours()*index*3600000+_1227.getMinutes()*index*60000+_1227.getSeconds()*index*1000);
if(this.constraints.selector=="time"){
date.setFullYear(1970,0,1);
}
var _1228=_120f.format(date,this.constraints);
if(this.filterString&&_1228.toLowerCase().indexOf(this.filterString)!==0){
return null;
}
var div=this.ownerDocument.createElement("div");
div.className=this.baseClass+"Item";
div.date=date;
div.idx=index;
_1212.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_1228},div);
if(index%this._visibleIncrement<1&&index%this._visibleIncrement>-1){
_1211.add(div,this.baseClass+"Marker");
}else{
if(!(index%this._clickableIncrement)){
_1211.add(div,this.baseClass+"Tick");
}
}
if(this.isDisabledDate(date)){
_1211.add(div,this.baseClass+"ItemDisabled");
}
if(this.value&&!ddate.compare(this.value,date,this.constraints.selector)){
div.selected=true;
_1211.add(div,this.baseClass+"ItemSelected");
if(_1211.contains(div,this.baseClass+"Marker")){
_1211.add(div,this.baseClass+"MarkerSelected");
}else{
_1211.add(div,this.baseClass+"TickSelected");
}
this._highlightOption(div,true);
}
return div;
},_onOptionSelected:function(tgt){
var tdate=tgt.target.date||tgt.target.parentNode.date;
if(!tdate||this.isDisabledDate(tdate)){
return;
}
this._highlighted_option=null;
this.set("value",tdate);
this.onChange(tdate);
},onChange:function(){
},_highlightOption:function(node,_1229){
if(!node){
return;
}
if(_1229){
if(this._highlighted_option){
this._highlightOption(this._highlighted_option,false);
}
this._highlighted_option=node;
}else{
if(this._highlighted_option!==node){
return;
}else{
this._highlighted_option=null;
}
}
_1211.toggle(node,this.baseClass+"ItemHover",_1229);
if(_1211.contains(node,this.baseClass+"Marker")){
_1211.toggle(node,this.baseClass+"MarkerHover",_1229);
}else{
_1211.toggle(node,this.baseClass+"TickHover",_1229);
}
},onmouseover:function(e){
this._keyboardSelected=null;
var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;
if(!_1211.contains(tgr,this.baseClass+"Item")){
return;
}
this._highlightOption(tgr,true);
},onmouseout:function(e){
this._keyboardSelected=null;
var tgr=(e.target.parentNode===this.timeMenu)?e.target:e.target.parentNode;
this._highlightOption(tgr,false);
},_mouseWheeled:function(e){
this._keyboardSelected=null;
event.stop(e);
this[(e.wheelDelta>0?"_onArrowUp":"_onArrowDown")]();
},_onArrowUp:function(count){
if(count===-1){
_1211.remove(this.upArrow,"dijitUpArrowActive");
return;
}else{
if(count===0){
_1211.add(this.upArrow,"dijitUpArrowActive");
}
}
if(!this.timeMenu.childNodes.length){
return;
}
var index=this.timeMenu.childNodes[0].idx;
var divs=this._getFilteredNodes(index,1,true,this.timeMenu.childNodes[0]);
if(divs.length){
this.timeMenu.removeChild(this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);
this.timeMenu.insertBefore(divs[0],this.timeMenu.childNodes[0]);
}
},_onArrowDown:function(count){
if(count===-1){
_1211.remove(this.downArrow,"dijitDownArrowActive");
return;
}else{
if(count===0){
_1211.add(this.downArrow,"dijitDownArrowActive");
}
}
if(!this.timeMenu.childNodes.length){
return;
}
var index=this.timeMenu.childNodes[this.timeMenu.childNodes.length-1].idx+1;
var divs=this._getFilteredNodes(index,1,false,this.timeMenu.childNodes[this.timeMenu.childNodes.length-1]);
if(divs.length){
this.timeMenu.removeChild(this.timeMenu.childNodes[0]);
this.timeMenu.appendChild(divs[0]);
}
},handleKey:function(e){
if(e.keyCode==keys.DOWN_ARROW||e.keyCode==keys.UP_ARROW){
event.stop(e);
if(this._highlighted_option&&!this._highlighted_option.parentNode){
this._highlighted_option=null;
}
var _122a=this.timeMenu,tgt=this._highlighted_option||query("."+this.baseClass+"ItemSelected",_122a)[0];
if(!tgt){
tgt=_122a.childNodes[0];
}else{
if(_122a.childNodes.length){
if(e.keyCode==keys.DOWN_ARROW&&!tgt.nextSibling){
this._onArrowDown();
}else{
if(e.keyCode==keys.UP_ARROW&&!tgt.previousSibling){
this._onArrowUp();
}
}
if(e.keyCode==keys.DOWN_ARROW){
tgt=tgt.nextSibling;
}else{
tgt=tgt.previousSibling;
}
}
}
this._highlightOption(tgt,true);
this._keyboardSelected=tgt;
return false;
}else{
if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){
if(!this._keyboardSelected&&e.keyCode===keys.TAB){
return true;
}
if(this._highlighted_option){
this._onOptionSelected({target:this._highlighted_option});
}
return e.keyCode===keys.TAB;
}
}
return undefined;
}});
return _1219;
});
},"davinci/html/CSSCombinedSelector":function(){
define("davinci/html/CSSCombinedSelector",["dojo/_base/declare","davinci/html/CSSElement"],function(_122b,_122c){
return _122b("davinci.html.CSSCombinedSelector",_122c,{constructor:function(){
this.selectors=[];
this.combiners=[];
this.elementType="CSSCombinedSelector";
},matchesSelector:function(_122d){
if(_122d.elementType==this.elementType){
if(_122d.selectors.length==this.selectors.length){
for(var i=0;i<this.selectors.length;i++){
if(this.combiners[i]!=_122d.combiners[i]){
return false;
}
if(!this.selectors[i].matchesSelector(_122d.selectors[i])){
return false;
}
}
return true;
}
}
},getText:function(_122e){
var s="";
for(var i=0;i<this.selectors.length-1;i++){
s=s+this.selectors[i].getText(_122e);
if(this.combiners[i]!=" "){
s+=" "+this.combiners[i]+" ";
}else{
s+=this.combiners[i];
}
}
s=s+this.selectors[this.selectors.length-1].getText(_122e);
return s;
},matches:function(_122f){
var _1230=this.selectors.length-1;
var _1231=0;
for(var i=0;i<_122f.length;i++){
var _1232;
if((_1232=this.selectors[_1230].matches(_122f,i))>=0){
_1231+=_1232;
_1230--;
if(_1230<0){
return _1231;
}
}
if(i==0&&_1232<0){
return -1;
}
}
},visit:function(_1233){
if(!_1233.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_1233);
}
for(var i=0;i<this.selectors.length;i++){
this.selectors[i].visit(_1233);
}
}
if(_1233.endVisit){
_1233.endVisit(this);
}
},getCSSRule:function(){
return this.parent;
}});
});
},"davinci/ve/palette/Palette":function(){
define("davinci/ve/palette/Palette",["dojo/_base/declare","dojo/_base/lang","dojo/_base/connect","dojo/on","dojo/query","dojo/dom-class","dojo/Deferred","dijit/focus","dijit/_WidgetBase","davinci/Runtime","davinci/Workbench","dijit/_KeyNavContainer","dijit/form/TextBox","dijit/form/DropDownButton","dijit/DropDownMenu","dijit/MenuItem","davinci/ui/dnd/DragSource","davinci/ve/metadata","davinci/library","./PaletteFolder","./PaletteItem","dojo/i18n!davinci/ve/nls/common","davinci/ve/tools/CreateTool","davinci/workbench/Preferences"],function(_1234,Lang,_1235,On,Query,_1236,_1237,_1238,_1239,_123a,_123b,_123c,_123d,_123e,_123f,_1240,_1241,_1242,_1243,_1244,_1245,_1246,_1247,_1248){
return _1234("davinci.ve.palette.Palette",[_1239,_123c],{descriptors:"",_displayShowValue:"block",_presetClassNamePrefix:"maqPaletteSection_",_presetSections:{},_presetCreated:{},raisedItems:[],sunkenItems:[],moreItems:[],helpItems:[],_userWidgetSection:{"id":"$$UserWidgets$$","name":"User Widgets","includes":[]},postMixInProperties:function(){
this._resource=_1246;
},postCreate:function(){
dojo.addClass(this.domNode,"dojoyPalette");
this.refresh();
_1235.subscribe("/davinci/ui/addedCustomWidget",this,"addCustomWidget");
_1235.subscribe("/davinci/preferencesChanged",this,"preferencesChanged");
},addCustomWidget:function(lib){
if(!this._loaded){
return;
}
if(!lib||!lib.$wm||!lib.$wm.widgets||!lib.$wm.widgets.length){
return;
}
var _1249=_123a.currentEditor.getContext();
var _124a=_1249.getCompType();
var _124b=_1248.getPreferences("davinci.ve.editorPrefs",_123b.getProject());
if(_124b.showAllWidgets){
_124a=(_124a=="mobile")?"$ALLMOBILE":"$ALLDESKTOP";
}
var _124c=lib.$wm;
var _124d=lib.$wm.widgets;
var _124e=null;
for(var w=0;w<_124d.length;w++){
var item=_124d[w];
for(var _124f in this._presetSections){
var _1250=null;
var _1251=this._presetSections[_124f];
if(!_1251){
console.error("Palette.js:addCustomWidget - no sections for comptype="+_124f);
}else{
for(var s=0;s<_1251.length;s++){
var _1252=_1251[s];
if(_1252.id=="$$UserWidgets$$"){
_1250=_1252;
break;
}
}
if(!_1250){
_1250=dojo.clone(this._userWidgetSection);
_1250.preset=this._presetSections[_124f];
_1250.presetId=_124f;
_1250.items=[];
_1251.push(_1250);
if(this._presetCreated[_124f]){
var _1253=[_1250];
this._generateCssRules(_1253);
this._createPalette(_1250);
_1250._created=true;
}
}
var _1254="type:"+item.type;
if(_1250.includes.indexOf(_1254)<0){
_1250.includes.push(_1254);
item.$library=_124c;
item.section=_1250;
item._paletteItemGroup=this._paletteItemGroupCount++;
_1250.items.push(item);
var name="custom";
var _1255=null;
var _1256=this.getChildren();
for(var ch=0;ch<_1256.length;ch++){
var child=_1256[ch];
if(child.declaredClass=="davinci.ve.palette.PaletteFolder"){
if(child.presetId==_124f&&child.section.id=="$$UserWidgets$$"){
_1255=child;
break;
}
}
}
if(_1255){
_1255.domNode.style.display="none";
var opt={displayName:item.$library._maqGetString(item.type)||item.$library._maqGetString(item.name)||item.name,description:item.$library._maqGetString(item.type+"_description")||item.$library._maqGetString(item.name+"_description")||item.description||item.type,name:item.name,paletteId:this.id,type:item.type,data:item.data||{name:item.name,type:item.type,properties:item.properties,children:item.children},tool:item.tool,category:name,section:_1250,PaletteFolderSection:_1255,PaletteFolderSubsection:null,_paletteItemGroup:item._paletteItemGroup,_paletteGroupSelected:true};
this._setIconProperties(item,opt);
var _1257=this._createItem(opt,_1255);
_1257.domNode.style.display="none";
if(_124a==_124f){
_124e=_1255;
}
}
}
}
}
}
if(_124e){
_124e.showHideFolderContents(true);
}
},setContext:function(_1258){
this._context=_1258;
this._loadPalette();
this.filterField.set("value","");
this._filter();
this.updatePaletteVisibility();
},refresh:function(){
delete this._loaded;
this._presetSections={};
this._createFolderTemplate();
this._createHeader();
if(this._context){
this._loadPalette();
}
},_loadPalette:function(){
if(this._loaded){
return;
}
var _1259=_1242.getLibrary();
var _125a=_1243.getUserLibs(_123b.getProject());
var _125b={};
function _125c(name,_125d){
for(var n in _1259){
if(_1259.hasOwnProperty(n)){
var lib=_1259[n];
if(lib.name===name&&lib.version===_125d){
var ro={};
ro[name]=_1259[n];
return ro;
}
}
}
return null;
};
_125a.forEach(function(ulib){
var _125e=_125c(ulib.id,ulib.version);
if(_125e){
dojo.mixin(_125b,_125e);
}
});
var _125f=_1243.getCustomWidgets(_123b.getProject());
var _1260=_1243.getCustomWidgetDescriptors();
if(_125f){
dojo.mixin(_125b,_125f);
}
var _1261=[];
for(var name in _125b){
if(_125b.hasOwnProperty(name)){
var lib=_125b[name].$wm;
if(!lib){
continue;
}
dojo.forEach(lib.widgets,function(item){
if(item.category=="untested"||item.hidden){
return;
}
_1261.push(item.type);
});
}
}
this._paletteItemGroupCount=0;
this._widgetPalette=_123a.getSiteConfigData("widgetPalette");
if(!this._widgetPalette){
console.error("widgetPalette.json not defined (in siteConfig folder)");
}else{
var _1262=this._widgetPalette.presets;
if(!_1262||typeof _1262!="object"){
console.warning("No presets defined in widgetPalette.json (in siteConfig folder)");
}else{
for(var p in _1262){
var _1263=_1261.concat();
this._presetSections[p]=[];
var _1264=_1262[p];
var _1265;
var _1266=(typeof _1264.sections=="string")?(this._widgetPalette.defs?this._widgetPalette.defs[_1264.sections]:undefined):_1264.sections;
if(!_1266||!_1266.length){
console.warning("No sections defined for preset "+p+" in widgetPalette.json (in siteConfig folder)");
}else{
var arr=[];
for(var cw in _1260){
var obj=_1260[cw];
if(obj.descriptor){
arr.push({name:cw,value:obj});
}
}
arr.sort(function(a,b){
var aa=a.name.split("/").pop().toLowerCase();
var bb=b.name.split("/").pop().toLowerCase();
return aa<bb?-1:(aa>bb?1:0);
});
var _1267=false;
var _1268,_1269;
for(var j=0;j<arr.length;j++){
if(!_1267){
_1268=dojo.clone(this._userWidgetSection);
_1266=_1266.concat(_1268);
_1267=true;
_1269=_1268.includes;
}
var _126a=arr[j].value.descriptor.widgets;
for(var cw=0;cw<_126a.length;cw++){
var _126b=_126a[cw];
_1269.push("type:"+_126b.type);
}
}
for(var s=0;s<_1266.length;s++){
var _126c=(typeof _1266[s]=="string")?(this._widgetPalette.defs?this._widgetPalette.defs[_1266[s]]:undefined):_1266[s];
var _126d=dojo.clone(_126c);
_126d.preset=_1264;
_126d.presetId=p;
if(_126d.subsections&&_126d.subsections.length){
var _126e=_126d.subsections;
for(var sub=0;sub<_126e.length;sub++){
if(typeof _126e[sub]=="string"){
var _126f=this._widgetPalette.defs?this._widgetPalette.defs[_126e[sub]]:undefined;
if(_126f){
_126e[sub]=dojo.clone(_126f);
}
}
var _1270=_126e[sub];
if(_1270.includes&&_1270.includes.indexOf("$$AllOthers$$")>=0){
_1265=_1270;
}
_1270.preset=_1264;
_1270.presetId=p;
this._createSectionItems(_1270,_1264,_1263);
}
}else{
this._createSectionItems(_126d,_1264,_1263);
if(_126d.includes&&_126d.includes.indexOf("$$AllOthers$$")>=0){
_1265=_126d;
}
}
this._presetSections[p].push(_126d);
}
}
for(var wi=0;wi<_1263.length;wi++){
var _1271=_1263[wi];
if(_1265){
var item=_1242.getWidgetDescriptorForType(_1271);
var _1272=dojo.clone(item);
this._prepareSectionItem(_1272,_1265,this._paletteItemGroupCount);
_1265.items.push(_1272);
this._paletteItemGroupCount++;
}else{
}
}
}
}
}
this._loaded=true;
},_generateCssRules:function(_1273){
var sheet=dojo.doc.styleSheets[0];
if(!sheet){
return;
}
dojo.forEach(_1273,function(_1274){
if(_1274.items){
dojo.forEach(_1274.items,function(item){
var _1275=item.iconBase64||this._getIconUri(item.icon,"ve/resources/images/file_obj.gif");
var _1276="img.davinci_"+item.type.replace(/[\.\/]/g,"_");
var rule="{background-image: url("+_1275+")}";
if(dojo.isIE){
sheet.addRule(_1276,rule);
}else{
sheet.insertRule(_1276+rule,sheet.cssRules.length);
}
},this);
}
},this);
},_createPaletteItemsForComponent:function(_1277,_1278){
if(_1277.items){
var _1279=null;
dojo.forEach(_1277.items,function(item){
if(item.hidden){
return;
}
var opt={displayName:item.$library._maqGetString(item.type)||item.$library._maqGetString(item.name)||item.name,description:item.$library._maqGetString(item.type+"_description")||item.$library._maqGetString(item.name+"_description")||item.description||item.type,name:item.name,paletteId:this.id,type:item.type,data:item.data||{name:item.name,type:item.type,properties:item.properties,children:item.children},category:_1277.name,section:_1277,preset:_1277.preset,presetId:_1277.presetId,presetClassName:_1278.presetClassName,PaletteFolderSection:_1278.PaletteFolderSection,PaletteFolderSubsection:_1278.PaletteFolderSubsection,_paletteItemGroup:item._paletteItemGroup,_paletteGroupSelected:(item._paletteItemGroup!=_1279),_collectionName:(item.$library&&item.$library.collections&&item.$library.collections[item.collection]&&item.$library.collections[item.collection].name)};
this._setIconProperties(item,opt);
this._createItem(opt);
_1279=item._paletteItemGroup;
},this);
}
},_createPalette:function(_127a){
var _127b="ve/resources/images/fldr_obj.gif";
var _127c=_127a.presetId?this._presetClassNamePrefix+_127a.presetId:null;
var opt={paletteId:this.id,icon:this._getIconUri(_127a.icon,_127b),iconBase64:_127a.iconBase64,displayName:_127a.name,section:_127a,subsections:_127a.subsections,subsection_container:null,preset:_127a.preset,presetId:_127a.presetId,presetClassName:_127c};
var _127d=this._createFolder(opt);
_127d.then(function(_127e){
if(_127a.subsections&&_127a.subsections.length){
for(var i=0;i<_127a.subsections.length;i++){
var _127f=_127a.subsections[i];
var opt2={paletteId:this.id,icon:this._getIconUri(_127f.icon,_127b),iconBase64:_127f.iconBase64,displayName:_127f.name,section:_127a,subsection:_127f,subsection_container:_127e,preset:_127a.preset,presetId:_127a.presetId,presetClassName:_127c};
var _1280=this._createFolder(opt2);
_1280.then(function(_1281){
_127e._children.push(_1281);
this._createPaletteItemsForComponent(_127a.subsections[i],{presetClassName:_127c,PaletteFolderSection:_127e,PaletteFolderSubsection:_1281});
}.bind(this));
}
}else{
this._createPaletteItemsForComponent(_127a,{presetClassName:_127c,PaletteFolderSection:_127e,PaletteFolderSubsection:null});
}
}.bind(this));
},_getIconUri:function(uri,_1282){
if(uri){
if(uri.indexOf("http")==0){
return uri;
}
return _123b.location()+uri;
}
return require.toUrl("davinci/"+_1282);
},_createFolder:function(opt){
var _1283=new _1237();
require(["davinci/ve/palette/PaletteFolder"],function(_1284){
var _1284=new _1284(opt);
this.addChild(_1284);
_1283.resolve(_1284);
}.bind(this));
return _1283;
},_createFolderTemplate:function(){
this.folderTemplate=dojo.create("div",{className:"dojoyPaletteCommon dojoyPaletteFolder dojoyPaletteFolderLow",innerHTML:"<a href=\"javascript:void(0)\"><img border=\"0\"/></a>"});
},_createHeader:function(){
var div=dojo.doc.createElement("div");
div.className="dojoyPaletteCommon";
var table=dojo.doc.createElement("table");
table.className="dojoyPaletteHeaderTable";
div.appendChild(table);
var tr=dojo.doc.createElement("tr");
table.appendChild(tr);
var td1=dojo.doc.createElement("td");
td1.className="dojoyPaletteHeaderTableCol1";
tr.appendChild(td1);
var td2=dojo.doc.createElement("td");
td2.className="dojoyPaletteHeaderTableCol2";
tr.appendChild(td2);
var _1285=dojo.doc.createElement("div");
_1285.className="dojoyPaletteFilterContainer";
td1.appendChild(_1285);
var input=dojo.doc.createElement("input");
_1285.appendChild(input);
var _1286=this._resource["filter"]+"...";
this.filterField=new _123d({style:"width: 99%",placeHolder:_1286,"class":"dojoyPaletteFilterTextBox"},input);
dojo.connect(this.filterField,"onKeyUp",this,"_filter");
var _1287=dojo.doc.createElement("div");
_1287.className="dojoyPaletteFilterClearIcon";
_1285.appendChild(_1287);
On(_1287,"click",function(e){
this._clearFilter();
}.bind(this));
var menu=new _123f({style:"display: none;"});
var _1288=new _1240({id:"PaletteMenuShowSuggested",label:_1246.showSuggestedWidgets,iconClass:"dojoyPaletteMenuItemCheckMark",onClick:function(){
this._updateShowAllWidgetsPreference(false);
}.bind(this)});
menu.addChild(_1288);
var _1289=new _1240({id:"PaletteMenuShowAll",label:_1246.showAllWidgets,iconClass:"dojoyPaletteMenuItemCheckMark",onClick:function(){
this._updateShowAllWidgetsPreference(true);
}.bind(this)});
menu.addChild(_1289);
var _128a=new _123e({showLabel:false,dropDown:menu});
td2.appendChild(_128a.domNode);
this.toolbarDiv.appendChild(div);
},_updateShowAllWidgetsPreference:function(_128b){
var id="davinci.ve.editorPrefs";
var base=_123b.getProject();
var _128c=_1248.getPreferences(id,base);
_128c.showAllWidgets=_128b;
_1248.savePreferences(id,base,_128c);
},_updateShowAllWidgetsMenu:function(_128d){
var _128e=_1248.getPreferences("davinci.ve.editorPrefs",_123b.getProject());
var _128f=dijit.byId("PaletteMenuShowSuggested");
var _1290=dijit.byId("PaletteMenuShowAll");
var _1291="dojoyPaletteMenuItemCheckMark";
var _1292="dojoyPaletteMenuItemCheckMark dojoyPaletteMenuItemCheckMarkOff";
if(_128e.showAllWidgets){
_128f.set("iconClass",_1292);
_1290.set("iconClass",_1291);
}else{
_128f.set("iconClass",_1291);
_1290.set("iconClass",_1292);
}
},_clearFilter:function(){
this.filterField.set("value",""),this._filter();
},_filter:function(){
var _1293=_123a.currentEditor.getContext();
var _1294=_1293.getCompType();
var _1295=_1248.getPreferences("davinci.ve.editorPrefs",_123b.getProject());
if(_1295.showAllWidgets){
_1294=(_1294=="mobile")?"$ALLMOBILE":"$ALLDESKTOP";
}
var value=this.filterField.get("value"),re=new RegExp(value,"i"),_1296,_1297={};
var _1298=this._displayShowValue;
function _1299(child){
if(child.declaredClass!="dijit.form.TextBox"){
var style=(child.declaredClass==="davinci.ve.palette.PaletteFolder"&&child.presetId==_1294&&child._children.length>0&&(child._type=="simple"||child._type=="subsection_container"))?"block":"none";
dojo.style(child.domNode,"display",style);
}
};
function _129a(child){
if(child.declaredClass=="dijit.form.TextBox"){
}else{
if(child.declaredClass==="davinci.ve.palette.PaletteFolder"){
dojo.style(child.domNode,"display","none");
}else{
if(child.name&&re.test(child.name)){
if(child.presetId==_1294&&child._paletteGroupSelected&&!_1297[child.type]){
dojo.style(child.domNode,"display",_1298);
_1297[child.type]=true;
}else{
dojo.style(child.domNode,"display","none");
}
}else{
dojo.style(child.domNode,"display","none");
}
}
}
};
if(value===""){
_1296=_1299;
dojo.removeClass(this.domNode,"maqWidgetsFiltered");
dojo.removeClass(this.toolbarDiv,"maqWidgetsToolbarFiltered");
}else{
_1296=_129a;
dojo.addClass(this.domNode,"maqWidgetsFiltered");
dojo.addClass(this.toolbarDiv,"maqWidgetsToolbarFiltered");
}
this.getChildren().forEach(_1296);
},_hasItem:function(type){
var _129b=this.getChildren();
for(var i=0;i<_129b.length;i++){
if(_129b[i].type==type){
return true;
}
}
return false;
},_createItem:function(opt,_129c){
if(opt.section.id!="$$UserWidgets$$"){
var _129d=_1242.queryDescriptor(opt.type,"collection");
var _129e;
if(opt.preset){
_129e=opt.preset.collections;
if(!_129e||!_129e.length){
return;
}
}
if(opt.preset&&opt.preset.exclude){
var _129f=(typeof opt.preset.exclude=="string")?(this._widgetPalette.defs?this._widgetPalette.defs[opt.preset.exclude]:undefined):opt.preset.exclude;
if(_129f&&_129f.indexOf(opt.type)>=0){
return;
}
}
var _12a0=false;
if(_129e&&_129e.length){
for(var i=0;i<_129e.length;i++){
if(_129e[i].id==_129d&&_129e[i].show){
_12a0=true;
break;
}
}
if(!_12a0){
return;
}
}
}
opt.icon=opt.iconLarge;
var node=new _1245(opt);
if(!_129c){
this.addChild(node);
}else{
_129c.addChild(node);
}
if(opt.PaletteFolderSubsection){
opt.PaletteFolderSubsection._children.push(node);
node.domNode.style.display=(opt.PaletteFolderSubsection._isOpen&&node._paletteGroupSelected)?this._displayShowValue:"none";
}else{
if(opt.PaletteFolderSection){
opt.PaletteFolderSection._children.push(node);
node.domNode.style.display=(opt.PaletteFolderSection._isOpen&&node._paletteGroupSelected)?this._displayShowValue:"none";
}
}
var _12a1=Query(".paletteItemImageContainer",node.domNode)[0];
var ds=new _1241(node.domNode,"component",node,_12a1);
ds.targetShouldShowCaret=true;
ds.returnCloneOnFailure=false;
this.connect(ds,"onDragStart",dojo.hitch(this,function(e){
this.onDragStart(e);
}));
this.connect(ds,"onDragEnd",dojo.hitch(this,function(e){
this.onDragEnd(e);
}));
return node;
},_prepareSectionItem:function(item,_12a2,_12a3){
var $wm=_1242.getLibraryMetadataForType(item.type);
item.$library=$wm;
item.section=_12a2;
item._paletteItemGroup=_12a3;
},_createSectionItems:function(_12a4,_12a5,_12a6){
_12a4.items=[];
collections=_12a5.collections;
var _12a7=_12a4.includes;
if(!_12a7||!_12a7.length){
console.warning("No includes property for preset "+p+" in widgetPalette.json (in siteConfig folder)");
return returnItems;
}
for(var inc=0;inc<_12a7.length;inc++){
var _12a8=_12a7[inc];
var _12a9=Lang.isArray(_12a8)?_12a8:[_12a8];
var _12aa=[];
for(var ii=0;ii<_12a9.length;ii++){
var _12ab=_12a9[ii];
var items=[];
if(_12ab.substr(0,5)==="type:"){
var item=_1242.getWidgetDescriptorForType(_12ab.substr(5));
if(item){
items.push(item);
}
}else{
items=_1242.getWidgetsWithTag(_12ab);
}
for(var _12ac=0;_12ac<items.length;_12ac++){
var item=items[_12ac];
var _12ad=dojo.clone(item);
this._prepareSectionItem(_12ad,_12a4,this._paletteItemGroupCount);
_12aa.push(_12ad);
}
}
var _12ae=[];
if(collections&&collections.length){
for(var co=0;co<collections.length;co++){
var _12af=collections[co];
var si=0;
while(si<_12aa.length){
var _12b0=_12aa[si];
if(_12b0.collection==_12af.id){
_12ae.push(_12b0);
_12aa.splice(si,1);
}else{
si++;
}
}
}
for(var si=0;si<_12aa.length;si++){
_12ae.push(_12aa[si]);
}
}else{
_12ae=_12aa;
}
for(var si=0;si<_12ae.length;si++){
var _12b1=_12ae[si];
var idx=_12a6.indexOf(_12b1.type);
if(idx>=0){
_12a6.splice(idx,1);
}
_12a4.items.push(_12b1);
}
this._paletteItemGroupCount++;
}
},updatePaletteVisibility:function(){
if(!_123a.currentEditor||_123a.currentEditor.declaredClass!="davinci.ve.PageEditor"||!_123a.currentEditor.getContext){
return;
}
this._updateShowAllWidgetsMenu();
var _12b2=_123a.currentEditor.getContext();
var _12b3=_12b2.getCompType();
var _12b4=_1248.getPreferences("davinci.ve.editorPrefs",_123b.getProject());
if(_12b4.showAllWidgets){
_12b3=(_12b3=="mobile")?"$ALLMOBILE":"$ALLDESKTOP";
}
this._presetCreated[_12b3]=true;
var _12b5=this._presetClassNamePrefix+_12b3;
if(!_12b4.widgetPaletteLayout||_12b4.widgetPaletteLayout=="icons"){
dojo.addClass(this.domNode,"paletteLayoutIcons");
this._displayShowValue="inline-block";
}else{
dojo.removeClass(this.domNode,"paletteLayoutIcons");
this._displayShowValue="block";
}
var _12b6=[];
var _12b7=this._presetSections[_12b3];
if(!_12b7){
console.error("Palette.js - no sections for comptype="+_12b3);
}else{
for(var s=0;s<_12b7.length;s++){
var _12b8=_12b7[s];
if(!_12b8._created){
var _12b9=[_12b8];
this._generateCssRules(_12b9);
this._createPalette(_12b8);
_12b8._created=true;
}
}
}
var _12ba=this.getChildren();
for(var i=0,len=_12ba.length;i<len;i++){
var child=_12ba[i];
if(child&&child.domNode&&child.presetId){
if(child.declaredClass=="davinci.ve.palette.PaletteFolder"){
if(child.presetId==_12b3){
if(child._children.length==0||child._type=="subsection"){
child.domNode.style.display="none";
}else{
child.domNode.style.display="block";
}
}else{
child.domNode.style.display="none";
}
if(child._type=="subsubsection_container"){
child._openSubsection=null;
}
child._isOpen=false;
}else{
child.domNode.style.display="none";
}
}
}
},preferencesChanged:function(){
var _12bb=_1248.getPreferences("davinci.ve.editorPrefs",_123b.getProject());
var prop=(!_12bb.widgetPaletteLayout||_12bb.widgetPaletteLayout=="icons")?"iconLarge":"icon";
var _12bc=this.getChildren();
for(var ch=0;ch<_12bc.length;ch++){
var child=_12bc[ch];
if(child.declaredClass=="davinci.ve.palette.PaletteItem"){
child.updateImgSrc(child[prop]);
}
}
this.updatePaletteVisibility();
},flattenAll:function(){
for(var i=0;i<this.raisedItems.length;i++){
this.raisedItems[i].flat(this.raisedItems[i].domNode);
}
this.raisedItems=[];
for(var i=0;i<this.sunkenItems.length;i++){
var _12bd=this.sunkenItems[i];
if(_12bd._tooltipDialog){
_12bd.paletteItemMoreCloseCleanup();
_12bd.paletteItemHelpCloseCleanup();
}
_12bd.flat(_12bd.domNode);
_12bd._selectionShowing=false;
}
this.sunkenItems=[];
},removeSelectionAll:function(){
this.flattenAll();
var _12be=Query(".paletteItemSelectionContent",this.domNode);
for(var i=0;i<_12be.length;i++){
var node=_12be[i];
if(node&&node.parentNode){
node.parentNode.innerHTML="";
}
}
},getPaletteItemsSameGroup:function(_12bf){
var _12c0=[];
var _12c1=_12bf._paletteItemGroup;
var _12c2=_12bf;
var _12c3;
while(_12c2&&_12c2._paletteItemGroup){
if(_12c2._paletteItemGroup==_12c1){
_12c3=_12c2;
_12c2=_12c2&&_12c2.domNode&&_12c2.domNode.previousSibling&&_12c2.domNode.previousSibling._paletteItem;
}else{
break;
}
}
_12c2=_12c3;
while(_12c2&&_12c2._paletteItemGroup==_12c1){
_12c0.push(_12c2);
_12c2=_12c2&&_12c2.domNode&&_12c2.domNode.nextSibling&&_12c2.domNode.nextSibling._paletteItem;
}
return _12c0;
},_setIconProperties:function(item,opt){
opt.icon=item.iconBase64||(item.icon&&this._getIconUri(item.icon,"ve/resources/images/file_obj.gif"))||item.iconLargeBase64||(item.iconLarge&&this._getIconUri(item.iconLarge,"ve/resources/images/file_obj.gif"))||this._getIconUri(item.icon,"ve/resources/images/file_obj.gif");
opt.iconLarge=item.iconLargeBase64||(item.iconLarge&&this._getIconUri(item.iconLarge,"ve/resources/images/file_obj.gif"))||item.iconBase64||this._getIconUri(item.icon,"ve/resources/images/file_obj.gif");
},onDragStart:function(e){
this.removeSelectionAll();
this.selectedItem=null;
var data=e.dragSource.data;
_1242.getHelper(data.type,"tool").then(function(_12c4){
var tool=new (_12c4||_1247)(dojo.clone(data.data));
this._context.setActiveTool(tool);
}.bind(this));
this._context.blockChange(false);
if(e._dragClone){
_1236.add(e._dragClone,"paletteDragContainer");
dojo.create("div",{className:"maqCandidateParents"},e._dragClone);
}
this._context.setActiveDragDiv(e._dragClone);
this._dragKeyDownListener=dojo.connect(document,"onkeydown",dojo.hitch(this,function(event){
var tool=this._context.getActiveTool();
if(tool&&tool.onKeyDown){
tool.onKeyDown(event);
}
}));
this._dragKeyUpListener=dojo.connect(document,"onkeyup",dojo.hitch(this,function(event){
var tool=this._context.getActiveTool();
if(tool&&tool.onKeyUp){
tool.onKeyUp(event);
}
}));
},onDragEnd:function(e){
this._context.setActiveTool(null);
this._context.setActiveDragDiv(null);
dojo.disconnect(this._dragKeyDownListener);
dojo.disconnect(this._dragKeyUpListener);
if(_1238.curNode&&_1238.curNode.blur){
_1238.curNode.blur();
}
this.removeSelectionAll();
this.selectedItem=null;
this.flattenAll();
},onDragMove:function(e){
},nop:function(){
return false;
},__dummy__:null});
});
},"orion/editor/editorFeatures":function(){
define("orion/editor/editorFeatures",["i18n!orion/editor/nls/messages","orion/editor/undoStack","orion/editor/keyBinding","orion/editor/rulers","orion/editor/annotations","orion/editor/tooltip","orion/editor/textDND","orion/editor/regex","orion/editor/util"],function(_12c5,_12c6,_12c7,_12c8,_12c9,_12ca,_12cb,_12cc,util){
function _12cd(){
};
_12cd.prototype={createUndoStack:function(_12ce){
var _12cf=_12ce.getTextView();
var _12d0=new _12c6.UndoStack(_12cf,200);
_12cf.setAction("undo",function(){
_12d0.undo();
return true;
},{name:_12c5.undo});
_12cf.setAction("redo",function(){
_12d0.redo();
return true;
},{name:_12c5.redo});
return _12d0;
}};
function _12d1(){
};
_12d1.prototype={createLineNumberRuler:function(_12d2){
return new _12c8.LineNumberRuler(_12d2,"left",{styleClass:"ruler lines"},{styleClass:"rulerLines odd"},{styleClass:"rulerLines even"});
}};
function _12d3(){
};
_12d3.prototype={createFoldingRuler:function(_12d4){
return new _12c8.FoldingRuler(_12d4,"left",{styleClass:"ruler folding"});
}};
function _12d5(){
};
_12d5.prototype={createAnnotationModel:function(model){
return new _12c9.AnnotationModel(model);
},createAnnotationStyler:function(_12d6,view){
return new _12c9.AnnotationStyler(_12d6,view);
},createAnnotationRulers:function(_12d7){
var _12d8=new _12c8.AnnotationRuler(_12d7,"left",{styleClass:"ruler annotations"});
var _12d9=new _12c8.OverviewRuler(_12d7,"right",{styleClass:"ruler overview"});
return {annotationRuler:_12d8,overviewRuler:_12d9};
}};
function _12da(){
};
_12da.prototype={createTextDND:function(_12db,_12dc){
return new _12cb.TextDND(_12db.getTextView(),_12dc);
}};
function _12dd(_12de,_12df,_12e0){
this.editor=_12de;
this.textView=_12de.getTextView();
this.undoStack=_12df;
this._incrementalFindActive=false;
this._incrementalFindSuccess=true;
this._incrementalFindIgnoreSelection=false;
this._incrementalFindPrefix="";
this._searcher=_12e0;
this._lastEditLocation=null;
this.init();
};
_12dd.prototype={init:function(){
var self=this;
this._incrementalFindListener={onVerify:function(e){
var _12e1=self.editor;
var model=_12e1.getModel();
var start=_12e1.mapOffset(e.start),end=_12e1.mapOffset(e.end);
var txt=model.getText(start,end);
var _12e2=self._incrementalFindPrefix;
var match=_12e2.match(new RegExp("^"+_12cc.escape(txt),"i"));
if(match&&match.length>0){
_12e2=self._incrementalFindPrefix+=e.text;
self.editor.reportStatus(util.formatMessage(_12c5.incrementalFind,_12e2));
var _12e3=_12e1.getSelection().start;
var _12e4=_12e1.getModel().find({string:_12e2,start:_12e3,caseInsensitive:_12e2.toLowerCase()===_12e2}).next();
if(_12e4){
self._incrementalFindSuccess=true;
self._incrementalFindIgnoreSelection=true;
_12e1.moveSelection(_12e4.start,_12e4.end);
self._incrementalFindIgnoreSelection=false;
}else{
_12e1.reportStatus(util.formatMessage(_12c5.incrementalFindNotFound,_12e2),"error");
self._incrementalFindSuccess=false;
}
e.text=null;
}else{
}
},onSelection:function(){
if(!self._incrementalFindIgnoreSelection){
self.toggleIncrementalFind();
}
}};
this._lastEditListener={onModelChanged:function(e){
if(self.editor.isDirty()){
self._lastEditLocation=e.start+e.addedCharCount;
}
}};
this.textView.addEventListener("ModelChanged",this._lastEditListener.onModelChanged);
this.textView.setKeyBinding(new _12c7.KeyBinding("k",true),"findNext");
this.textView.setAction("findNext",function(){
if(this._searcher){
var _12e5=this.textView.getSelection();
if(_12e5.start<_12e5.end){
this._searcher.findNext(true,this.textView.getText(_12e5.start,_12e5.end));
}else{
this._searcher.findNext(true);
}
return true;
}
return false;
}.bind(this),{name:_12c5.findNext});
this.textView.setKeyBinding(new _12c7.KeyBinding("k",true,true),"findPrevious");
this.textView.setAction("findPrevious",function(){
if(this._searcher){
var _12e6=this.textView.getSelection();
if(_12e6.start<_12e6.end){
this._searcher.findNext(false,this.textView.getText(_12e6.start,_12e6.end));
}else{
this._searcher.findNext(false);
}
return true;
}
return false;
}.bind(this),{name:_12c5.findPrevious});
this.textView.setKeyBinding(new _12c7.KeyBinding("j",true),"incrementalFind");
this.textView.setAction("incrementalFind",function(){
if(this._searcher&&this._searcher.visible()){
return true;
}
var _12e7=this.editor;
if(!this._incrementalFindActive){
_12e7.setCaretOffset(_12e7.getCaretOffset());
this.toggleIncrementalFind();
}else{
var _12e8=this._incrementalFindPrefix;
if(_12e8.length!==0){
var _12e9;
var _12ea=0;
if(this._incrementalFindSuccess){
_12ea=_12e7.getSelection().start+1;
}
_12e9=_12e7.getModel().find({string:_12e8,start:_12ea,caseInsensitive:_12e8.toLowerCase()===_12e8}).next();
if(_12e9){
this._incrementalFindSuccess=true;
this._incrementalFindIgnoreSelection=true;
_12e7.moveSelection(_12e9.start,_12e9.end);
this._incrementalFindIgnoreSelection=false;
_12e7.reportStatus(util.formatMessage(_12c5.incrementalFind,_12e8));
}else{
_12e7.reportStatus(util.formatMessage(_12c5.incrementalFindNotFound,_12e8),"error");
this._incrementalFindSuccess=false;
}
}
}
return true;
}.bind(this),{name:_12c5.incrementalFindKey});
this.textView.setAction("deletePrevious",function(){
if(this._incrementalFindActive){
var _12eb=this.editor;
var _12ec=this._incrementalFindPrefix;
_12ec=this._incrementalFindPrefix=_12ec.substring(0,_12ec.length-1);
if(_12ec.length===0){
this._incrementalFindSuccess=true;
this._incrementalFindIgnoreSelection=true;
_12eb.setCaretOffset(_12eb.getSelection().start);
this._incrementalFindIgnoreSelection=false;
this.toggleIncrementalFind();
return true;
}
_12eb.reportStatus(util.formatMessage(_12c5.incrementalFind,_12ec));
var _12ed=_12eb.getModel().find({string:_12ec,start:_12eb.getCaretOffset()-_12ec.length-1,reverse:true,caseInsensitive:_12ec.toLowerCase()===_12ec}).next();
if(_12ed){
this._incrementalFindSuccess=true;
this._incrementalFindIgnoreSelection=true;
_12eb.moveSelection(_12ed.start,_12ed.end);
this._incrementalFindIgnoreSelection=false;
}else{
_12eb.reportStatus(util.formatMessage(_12c5.incrementalFindNotFound,_12ec),"error");
}
return true;
}
return false;
}.bind(this));
this.textView.setAction("tab",function(){
if(this.textView.getOptions("readonly")){
return false;
}
if(!this.textView.getOptions("tabMode")){
return;
}
var _12ee=this.editor;
var model=_12ee.getModel();
var _12ef=_12ee.getSelection();
var _12f0=model.getLineAtOffset(_12ef.start);
var _12f1=model.getLineAtOffset(_12ef.end>_12ef.start?_12ef.end-1:_12ef.end);
if(_12f0!==_12f1){
var lines=[];
lines.push("");
for(var i=_12f0;i<=_12f1;i++){
lines.push(model.getLine(i,true));
}
var _12f2=model.getLineStart(_12f0);
var _12f3=model.getLineEnd(_12f1,true);
var _12f4=this.textView.getOptions("tabSize","expandTab");
var text=_12f4.expandTab?new Array(_12f4.tabSize+1).join(" "):"\t";
_12ee.setText(lines.join(text),_12f2,_12f3);
_12ee.setSelection(_12f2===_12ef.start?_12ef.start:_12ef.start+text.length,_12ef.end+((_12f1-_12f0+1)*text.length));
return true;
}
var _12f5=_12ee.getKeyModes();
for(var j=0;j<_12f5.length;j++){
if(_12f5[j].isActive()){
return _12f5[j].tab();
}
}
return false;
}.bind(this));
this.textView.setAction("shiftTab",function(){
if(this.textView.getOptions("readonly")){
return false;
}
if(!this.textView.getOptions("tabMode")){
return;
}
var _12f6=this.editor;
var model=_12f6.getModel();
var _12f7=_12f6.getSelection();
var _12f8=model.getLineAtOffset(_12f7.start);
var _12f9=model.getLineAtOffset(_12f7.end>_12f7.start?_12f7.end-1:_12f7.end);
var _12fa=this.textView.getOptions("tabSize");
var _12fb=new Array(_12fa+1).join(" ");
var lines=[],_12fc=0,_12fd=0;
for(var i=_12f8;i<=_12f9;i++){
var line=model.getLine(i,true);
if(model.getLineStart(i)!==model.getLineEnd(i)){
if(line.indexOf("\t")===0){
line=line.substring(1);
_12fc++;
}else{
if(line.indexOf(_12fb)===0){
line=line.substring(_12fa);
_12fc+=_12fa;
}else{
return true;
}
}
}
if(i===_12f8){
_12fd=_12fc;
}
lines.push(line);
}
var _12fe=model.getLineStart(_12f8);
var _12ff=model.getLineEnd(_12f9,true);
var _1300=model.getLineStart(_12f9);
_12f6.setText(lines.join(""),_12fe,_12ff);
var start=_12fe===_12f7.start?_12f7.start:_12f7.start-_12fd;
var end=Math.max(start,_12f7.end-_12fc+(_12f7.end===_1300+1&&_12f7.start!==_12f7.end?1:0));
_12f6.setSelection(start,end);
return true;
}.bind(this),{name:_12c5.unindentLines});
this.textView.setKeyBinding(new _12c7.KeyBinding(38,false,false,true),"moveLinesUp");
this.textView.setAction("moveLinesUp",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _1301=this.editor;
var model=_1301.getModel();
var _1302=_1301.getSelection();
var _1303=model.getLineAtOffset(_1302.start);
if(_1303===0){
return true;
}
var _1304=model.getLineAtOffset(_1302.end>_1302.start?_1302.end-1:_1302.end);
var _1305=model.getLineCount();
var _1306=model.getLineStart(_1303-1);
var _1307=model.getLineStart(_1303);
var _1308=model.getLineEnd(_1304,true);
var text=model.getText(_1307,_1308);
var _1309=0;
if(_1304===_1305-1){
var _130a=model.getLineEnd(_1303-1);
var _130b=model.getLineEnd(_1303-1,true);
text+=model.getText(_130a,_130b);
_1307=_130a;
_1309=_130b-_130a;
}
this.startUndo();
_1301.setText("",_1307,_1308);
_1301.setText(text,_1306,_1306);
_1301.setSelection(_1306,_1306+text.length-_1309);
this.endUndo();
return true;
}.bind(this),{name:_12c5.moveLinesUp});
this.textView.setKeyBinding(new _12c7.KeyBinding(40,false,false,true),"moveLinesDown");
this.textView.setAction("moveLinesDown",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _130c=this.editor;
var model=_130c.getModel();
var _130d=_130c.getSelection();
var _130e=model.getLineAtOffset(_130d.start);
var _130f=model.getLineAtOffset(_130d.end>_130d.start?_130d.end-1:_130d.end);
var _1310=model.getLineCount();
if(_130f===_1310-1){
return true;
}
var _1311=model.getLineStart(_130e);
var _1312=model.getLineEnd(_130f,true);
var _1313=model.getLineEnd(_130f+1,true)-(_1312-_1311);
var text,_1314=0;
if(_130f!==_1310-2){
text=model.getText(_1311,_1312);
}else{
var _1315=model.getLineEnd(_130f);
text=model.getText(_1315,_1312)+model.getText(_1311,_1315);
_1314+=_1312-_1315;
}
this.startUndo();
_130c.setText("",_1311,_1312);
_130c.setText(text,_1313,_1313);
_130c.setSelection(_1313+_1314,_1313+_1314+text.length);
this.endUndo();
return true;
}.bind(this),{name:_12c5.moveLinesDown});
this.textView.setKeyBinding(new _12c7.KeyBinding(38,true,false,true),"copyLinesUp");
this.textView.setAction("copyLinesUp",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _1316=this.editor;
var model=_1316.getModel();
var _1317=_1316.getSelection();
var _1318=model.getLineAtOffset(_1317.start);
var _1319=model.getLineAtOffset(_1317.end>_1317.start?_1317.end-1:_1317.end);
var _131a=model.getLineStart(_1318);
var _131b=model.getLineEnd(_1319,true);
var _131c=model.getLineCount();
var _131d="";
var text=model.getText(_131a,_131b);
if(_1319===_131c-1){
text+=(_131d=model.getLineDelimiter());
}
var _131e=_131a;
_1316.setText(text,_131e,_131e);
_1316.setSelection(_131e,_131e+text.length-_131d.length);
return true;
}.bind(this),{name:_12c5.copyLinesUp});
this.textView.setKeyBinding(new _12c7.KeyBinding(40,true,false,true),"copyLinesDown");
this.textView.setAction("copyLinesDown",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _131f=this.editor;
var model=_131f.getModel();
var _1320=_131f.getSelection();
var _1321=model.getLineAtOffset(_1320.start);
var _1322=model.getLineAtOffset(_1320.end>_1320.start?_1320.end-1:_1320.end);
var _1323=model.getLineStart(_1321);
var _1324=model.getLineEnd(_1322,true);
var _1325=model.getLineCount();
var _1326="";
var text=model.getText(_1323,_1324);
if(_1322===_1325-1){
text=(_1326=model.getLineDelimiter())+text;
}
var _1327=_1324;
_131f.setText(text,_1327,_1327);
_131f.setSelection(_1327+_1326.length,_1327+text.length);
return true;
}.bind(this),{name:_12c5.copyLinesDown});
this.textView.setKeyBinding(new _12c7.KeyBinding("d",true,false,false),"deleteLines");
this.textView.setAction("deleteLines",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _1328=this.editor;
var _1329=_1328.getSelection();
var model=_1328.getModel();
var _132a=model.getLineAtOffset(_1329.start);
var _132b=model.getLineAtOffset(_1329.end>_1329.start?_1329.end-1:_1329.end);
var _132c=model.getLineStart(_132a);
var _132d=model.getLineEnd(_132b,true);
_1328.setText("",_132c,_132d);
return true;
}.bind(this),{name:_12c5.deleteLines});
this.textView.setKeyBinding(new _12c7.KeyBinding("l",true),"gotoLine");
this.textView.setAction("gotoLine",function(){
var _132e=this.editor;
var model=_132e.getModel();
var line=model.getLineAtOffset(_132e.getCaretOffset());
line=prompt(_12c5.gotoLinePrompty,line+1);
if(line){
line=parseInt(line,10);
_132e.onGotoLine(line-1,0);
}
return true;
}.bind(this),{name:_12c5.gotoLine});
this.textView.setKeyBinding(new _12c7.KeyBinding(190,true),"nextAnnotation");
this.textView.setAction("nextAnnotation",function(){
var _132f=this.editor;
var _1330=_132f.getAnnotationModel();
if(!_1330){
return true;
}
var model=_132f.getModel();
var _1331=_132f.getCaretOffset();
var _1332=_1330.getAnnotations(_1331,model.getCharCount());
while(_1332.hasNext()){
var _1333=_1332.next();
if(_1333.start<=_1331){
continue;
}
if(_1333.type!==_12c9.AnnotationType.ANNOTATION_ERROR&&_1333.type!==_12c9.AnnotationType.ANNOTATION_WARNING&&_1333.type!==_12c9.AnnotationType.ANNOTATION_TASK&&_1333.type!==_12c9.AnnotationType.ANNOTATION_BOOKMARK){
continue;
}
var _1334=_12ca.Tooltip.getTooltip(this.textView);
if(!_1334){
_132f.moveSelection(_1333.start);
return true;
}
var _1335=model.getLineAtOffset(_1333.start);
var view=this.textView;
var _1336=function(){
setTimeout(function(){
_1334.setTarget({getTooltipInfo:function(){
var _1337=view.convert({x:view.getLocationAtOffset(_1333.start).x,y:view.getLocationAtOffset(model.getLineStart(_1335)).y},"document","page");
return {contents:[_1333],x:_1337.x,y:_1337.y+Math.floor(view.getLineHeight(_1335)*1.33)};
}},0);
},0);
};
_132f.moveSelection(_1333.start,_1333.start,_1336);
break;
}
return true;
}.bind(this),{name:_12c5.nextAnnotation});
this.textView.setKeyBinding(new _12c7.KeyBinding(188,true),"previousAnnotation");
this.textView.setAction("previousAnnotation",function(){
var _1338=this.editor;
var _1339=_1338.getAnnotationModel();
if(!_1339){
return true;
}
var model=_1338.getModel();
var _133a=_1338.getCaretOffset();
var _133b=_1339.getAnnotations(0,_133a);
var _133c=null;
while(_133b.hasNext()){
var _133d=_133b.next();
if(_133d.start>=_133a){
continue;
}
if(_133d.type!==_12c9.AnnotationType.ANNOTATION_ERROR&&_133d.type!==_12c9.AnnotationType.ANNOTATION_WARNING&&_133d.type!==_12c9.AnnotationType.ANNOTATION_TASK&&_133d.type!==_12c9.AnnotationType.ANNOTATION_BOOKMARK){
continue;
}
_133c=_133d;
}
if(_133c){
var _133e=model.getLineAtOffset(_133c.start);
var _133f=_12ca.Tooltip.getTooltip(this.textView);
if(!_133f){
_1338.moveSelection(_133c.start);
return true;
}
var view=this.textView;
var _1340=function(){
setTimeout(function(){
_133f.setTarget({getTooltipInfo:function(){
var _1341=view.convert({x:view.getLocationAtOffset(_133c.start).x,y:view.getLocationAtOffset(model.getLineStart(_133e)).y},"document","page");
return {contents:[_133c],x:_1341.x,y:_1341.y+Math.floor(view.getLineHeight(_133e)*1.33)};
}},0);
},0);
};
_1338.moveSelection(_133c.start,_133c.start,_1340);
}
return true;
}.bind(this),{name:_12c5.prevAnnotation});
this.textView.setKeyBinding(new _12c7.KeyBinding("e",true,false,true,false),"expand");
this.textView.setAction("expand",function(){
var _1342=this.editor;
var _1343=_1342.getAnnotationModel();
if(!_1343){
return true;
}
var model=_1342.getModel();
var _1344=_1342.getCaretOffset();
var _1345=model.getLineAtOffset(_1344);
var start=model.getLineStart(_1345);
var end=model.getLineEnd(_1345,true);
if(model.getBaseModel){
start=model.mapOffset(start);
end=model.mapOffset(end);
model=model.getBaseModel();
}
var _1346,iter=_1343.getAnnotations(start,end);
while(!_1346&&iter.hasNext()){
var a=iter.next();
if(a.type!==_12c9.AnnotationType.ANNOTATION_FOLDING){
continue;
}
if(a.expanded){
continue;
}
_1346=a;
}
if(_1346&&!_1346.expanded){
_1346.expand();
_1343.modifyAnnotation(_1346);
}
return true;
}.bind(this),{name:_12c5.expand});
this.textView.setKeyBinding(new _12c7.KeyBinding("c",true,false,true,false),"collapse");
this.textView.setAction("collapse",function(){
var _1347=this.editor;
var _1348=_1347.getAnnotationModel();
if(!_1348){
return true;
}
var model=_1347.getModel();
var _1349=_1347.getCaretOffset();
var _134a=model.getLineAtOffset(_1349);
var start=model.getLineStart(_134a);
var end=model.getLineEnd(_134a,true);
if(model.getBaseModel){
start=model.mapOffset(start);
end=model.mapOffset(end);
model=model.getBaseModel();
}
var _134b,iter=_1348.getAnnotations(start,end);
while(!_134b&&iter.hasNext()){
var a=iter.next();
if(a.type!==_12c9.AnnotationType.ANNOTATION_FOLDING){
continue;
}
_134b=a;
}
if(_134b&&_134b.expanded){
_1347.setCaretOffset(_134b.start);
_134b.collapse();
_1348.modifyAnnotation(_134b);
}
return true;
}.bind(this),{name:_12c5.collapse});
this.textView.setKeyBinding(new _12c7.KeyBinding("e",true,true,true,false),"expandAll");
this.textView.setAction("expandAll",function(){
var _134c=this.editor;
var _134d=_134c.getAnnotationModel();
if(!_134d){
return true;
}
var model=_134c.getModel();
var _134e,iter=_134d.getAnnotations(0,model.getCharCount());
this.textView.setRedraw(false);
while(iter.hasNext()){
_134e=iter.next();
if(_134e.type!==_12c9.AnnotationType.ANNOTATION_FOLDING){
continue;
}
if(!_134e.expanded){
_134e.expand();
_134d.modifyAnnotation(_134e);
}
}
this.textView.setRedraw(true);
return true;
}.bind(this),{name:_12c5.expandAll});
this.textView.setKeyBinding(new _12c7.KeyBinding("c",true,true,true,false),"collapseAll");
this.textView.setAction("collapseAll",function(){
var _134f=this.editor;
var _1350=_134f.getAnnotationModel();
if(!_1350){
return true;
}
var model=_134f.getModel();
var _1351,iter=_1350.getAnnotations(0,model.getCharCount());
this.textView.setRedraw(false);
while(iter.hasNext()){
_1351=iter.next();
if(_1351.type!==_12c9.AnnotationType.ANNOTATION_FOLDING){
continue;
}
if(_1351.expanded){
_1351.collapse();
_1350.modifyAnnotation(_1351);
}
}
this.textView.setRedraw(true);
return true;
}.bind(this),{name:_12c5.collapseAll});
this.textView.setKeyBinding(new _12c7.KeyBinding("q",!util.isMac,false,false,util.isMac),"lastEdit");
this.textView.setAction("lastEdit",function(){
if(typeof this._lastEditLocation==="number"){
this.editor.showSelection(this._lastEditLocation);
}
return true;
}.bind(this),{name:_12c5.lastEdit});
},toggleIncrementalFind:function(){
this._incrementalFindActive=!this._incrementalFindActive;
if(this._incrementalFindActive){
this.editor.reportStatus(util.formatMessage(_12c5.incrementalFind,this._incrementalFindPrefix));
this.textView.addEventListener("Verify",this._incrementalFindListener.onVerify);
this.textView.addEventListener("Selection",this._incrementalFindListener.onSelection);
}else{
this._incrementalFindPrefix="";
this.editor.reportStatus("");
this.textView.removeEventListener("Verify",this._incrementalFindListener.onVerify);
this.textView.removeEventListener("Selection",this._incrementalFindListener.onSelection);
this.textView.setCaretOffset(this.textView.getCaretOffset());
}
},startUndo:function(){
if(this.undoStack){
this.undoStack.startCompoundChange();
}
},endUndo:function(){
if(this.undoStack){
this.undoStack.endCompoundChange();
}
},cancel:function(){
this.toggleIncrementalFind();
},isActive:function(){
return this._incrementalFindActive;
},isStatusActive:function(){
return this._incrementalFindActive;
},lineUp:function(){
if(this._incrementalFindActive){
var _1352=this._incrementalFindPrefix;
if(_1352.length===0){
return false;
}
var _1353=this.editor;
var model=_1353.getModel();
var start;
if(this._incrementalFindSuccess){
start=_1353.getCaretOffset()-_1352.length-1;
}else{
start=model.getCharCount()-1;
}
var _1354=_1353.getModel().find({string:_1352,start:start,reverse:true,caseInsensitive:_1352.toLowerCase()===_1352}).next();
if(_1354){
this._incrementalFindSuccess=true;
this._incrementalFindIgnoreSelection=true;
_1353.moveSelection(_1354.start,_1354.end);
this._incrementalFindIgnoreSelection=false;
_1353.reportStatus(util.formatMessage(_12c5.incrementalFind,_1352));
}else{
_1353.reportStatus(util.formatMessage(_12c5.incrementalFindNotFound,_1352),"error");
this._incrementalFindSuccess=false;
}
return true;
}
return false;
},lineDown:function(){
if(this._incrementalFindActive){
var _1355=this._incrementalFindPrefix;
if(_1355.length===0){
return false;
}
var _1356=this.editor;
var start=0;
if(this._incrementalFindSuccess){
start=_1356.getSelection().start+1;
}
var _1357=_1356.getModel().find({string:_1355,start:start,caseInsensitive:_1355.toLowerCase()===_1355}).next();
if(_1357){
this._incrementalFindSuccess=true;
this._incrementalFindIgnoreSelection=true;
_1356.moveSelection(_1357.start,_1357.end);
this._incrementalFindIgnoreSelection=false;
_1356.reportStatus(util.formatMessage(_12c5.incrementalFind,_1355));
}else{
_1356.reportStatus(util.formatMessage(_12c5.incrementalFindNotFound,_1355),"error");
this._incrementalFindSuccess=false;
}
return true;
}
return false;
},enter:function(){
return false;
}};
function _1358(_1359,_135a,_135b,_135c){
this.editor=_1359;
this.textView=_1359.getTextView();
this.undoStack=_135a;
this.contentAssist=_135b;
this.linkedMode=_135c;
if(this.contentAssist){
this.contentAssist.addEventListener("ProposalApplied",this.contentAssistProposalApplied.bind(this));
}
this.init();
};
_1358.prototype={startUndo:function(){
if(this.undoStack){
this.undoStack.startCompoundChange();
}
},endUndo:function(){
if(this.undoStack){
this.undoStack.endCompoundChange();
}
},init:function(){
this.textView.setAction("lineStart",function(){
var _135d=this.editor;
var model=_135d.getModel();
var _135e=_135d.getCaretOffset();
var _135f=model.getLineAtOffset(_135e);
var _1360=model.getLineStart(_135f);
var _1361=model.getLine(_135f);
var _1362;
for(_1362=0;_1362<_1361.length;_1362++){
var c=_1361.charCodeAt(_1362);
if(!(c===32||c===9)){
break;
}
}
_1362+=_1360;
if(_135e!==_1362){
_135d.setSelection(_1362,_1362);
return true;
}
return false;
}.bind(this));
this.textView.setKeyBinding(new _12c7.KeyBinding(191,true),"toggleLineComment");
this.textView.setAction("toggleLineComment",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _1363=this.editor;
var model=_1363.getModel();
var _1364=_1363.getSelection();
var _1365=model.getLineAtOffset(_1364.start);
var _1366=model.getLineAtOffset(_1364.end>_1364.start?_1364.end-1:_1364.end);
var _1367=true,lines=[],_1368,index;
for(var i=_1365;i<=_1366;i++){
_1368=model.getLine(i,true);
lines.push(_1368);
if(!_1367||(index=_1368.indexOf("//"))===-1){
_1367=false;
}else{
if(index!==0){
var j;
for(j=0;j<index;j++){
var c=_1368.charCodeAt(j);
if(!(c===32||c===9)){
break;
}
}
_1367=j===index;
}
}
}
var text,_1369,_136a;
var _136b=model.getLineStart(_1365);
var _136c=model.getLineEnd(_1366,true);
if(_1367){
for(var k=0;k<lines.length;k++){
_1368=lines[k];
index=_1368.indexOf("//");
lines[k]=_1368.substring(0,index)+_1368.substring(index+2);
}
text=lines.join("");
var _136d=model.getLineStart(_1366);
_1369=_136b===_1364.start?_1364.start:_1364.start-2;
_136a=_1364.end-(2*(_1366-_1365+1))+(_1364.end===_136d+1?2:0);
}else{
lines.splice(0,0,"");
text=lines.join("//");
_1369=_136b===_1364.start?_1364.start:_1364.start+2;
_136a=_1364.end+(2*(_1366-_1365+1));
}
_1363.setText(text,_136b,_136c);
_1363.setSelection(_1369,_136a);
return true;
}.bind(this),{name:_12c5.toggleLineComment});
function _136e(model,start,end){
var open="/*",close="*/";
var _136f=model.getLineAtOffset(start);
var _1370=model.getLineAtOffset(end);
var i,line,_1371,_1372,_1373;
var _1374,_1375;
for(i=_136f;i>=0;i--){
line=model.getLine(i);
_1371=(i===_136f)?start-model.getLineStart(_136f):line.length;
_1372=line.lastIndexOf(open,_1371);
_1373=line.lastIndexOf(close,_1371);
if(_1373>_1372){
break;
}else{
if(_1372!==-1){
_1374=model.getLineStart(i)+_1372;
break;
}
}
}
for(i=_1370;i<model.getLineCount();i++){
line=model.getLine(i);
_1371=(i===_1370)?end-model.getLineStart(_1370):0;
_1372=line.indexOf(open,_1371);
_1373=line.indexOf(close,_1371);
if(_1372!==-1&&_1372<_1373){
break;
}else{
if(_1373!==-1){
_1375=model.getLineStart(i)+_1373;
break;
}
}
}
return {commentStart:_1374,commentEnd:_1375};
};
this.textView.setKeyBinding(new _12c7.KeyBinding(191,true,!util.isMac,false,util.isMac),"addBlockComment");
this.textView.setAction("addBlockComment",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _1376=this.editor;
var model=_1376.getModel();
var _1377=_1376.getSelection();
var open="/*",close="*/",_1378=new RegExp("/\\*"+"|"+"\\*/","g");
var _1379=_136e(model,_1377.start,_1377.end);
if(_1379.commentStart!==undefined&&_1379.commentEnd!==undefined){
return true;
}
var text=model.getText(_1377.start,_1377.end);
if(text.length===0){
return true;
}
var _137a=text.length;
text=text.replace(_1378,"");
var _137b=text.length;
_1376.setText(open+text+close,_1377.start,_1377.end);
_1376.setSelection(_1377.start+open.length,_1377.end+open.length+(_137b-_137a));
return true;
}.bind(this),{name:_12c5.addBlockComment});
this.textView.setKeyBinding(new _12c7.KeyBinding(220,true,!util.isMac,false,util.isMac),"removeBlockComment");
this.textView.setAction("removeBlockComment",function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _137c=this.editor;
var model=_137c.getModel();
var _137d=_137c.getSelection();
var open="/*",close="*/";
var _137e=model.getText(_137d.start,_137d.end);
var _137f,_1380;
var i;
for(i=0;i<_137e.length;i++){
if(_137e.substring(i,i+open.length)===open){
_137f=_137d.start+i;
break;
}
}
for(;i<_137e.length;i++){
if(_137e.substring(i,i+close.length)===close){
_1380=_137d.start+i;
break;
}
}
if(_137f!==undefined&&_1380!==undefined){
_137c.setText(model.getText(_137f+open.length,_1380),_137f,_1380+close.length);
_137c.setSelection(_137f,_1380);
}else{
var _1381=_136e(model,_137d.start,_137d.end);
if(_1381.commentStart===undefined||_1381.commentEnd===undefined){
return true;
}
var text=model.getText(_1381.commentStart+open.length,_1381.commentEnd);
_137c.setText(text,_1381.commentStart,_1381.commentEnd+close.length);
_137c.setSelection(_137d.start-open.length,_137d.end-close.length);
}
return true;
}.bind(this),{name:_12c5.removeBlockComment});
},contentAssistProposalApplied:function(event){
var _1382=event.data.proposal;
if(_1382.positions&&this.linkedMode){
var _1383=[];
for(var i=0;i<_1382.positions.length;++i){
_1383[i]={positions:[{offset:_1382.positions[i].offset,length:_1382.positions[i].length}]};
}
var _1384={groups:_1383,escapePosition:_1382.escapePosition};
this.linkedMode.enterLinkedMode(_1384);
}else{
if(_1382.escapePosition){
this.textView.setCaretOffset(_1382.escapePosition);
}
}
return true;
},cancel:function(){
return false;
},isActive:function(){
return true;
},isStatusActive:function(){
return false;
},lineUp:function(){
return false;
},lineDown:function(){
return false;
},enter:function(){
if(this.textView.getOptions("readonly")){
return false;
}
var _1385=this.editor;
var _1386=_1385.getSelection();
if(_1386.start===_1386.end){
var model=_1385.getModel();
var _1387=model.getLineAtOffset(_1386.start);
var _1388=model.getLine(_1387,true);
var _1389=model.getLineStart(_1387);
var index=0,end=_1386.start-_1389,c;
while(index<end&&((c=_1388.charCodeAt(index))===32||c===9)){
index++;
}
if(index>0){
var _138a=_1388.substring(0,index);
index=end;
while(index<_1388.length&&((c=_1388.charCodeAt(index++))===32||c===9)){
_1386.end++;
}
_1385.setText(model.getLineDelimiter()+_138a,_1386.start,_1386.end);
return true;
}
}
return false;
},tab:function(){
return false;
}};
function _138b(_138c){
this.editor=_138c;
this.textView=_138c.getTextView();
this.linkedModeActive=false;
this.linkedModePositions=[];
this.linkedModeCurrentPositionIndex=0;
this.linkedModeEscapePosition=0;
this.linkedModeListener={onVerify:function(event){
var _138d=false;
var _138e=0;
for(var i=0;i<this.linkedModePositions.length;++i){
var _138f=this.linkedModePositions[i];
if(_138d){
_138f.offset+=_138e;
}else{
if(event.start>=_138f.offset&&event.end<=_138f.offset+_138f.length){
var _1390=_138f.length;
_138f.length=(event.start-_138f.offset)+event.text.length+(_138f.offset+_138f.length-event.end);
_138e=_138f.length-_1390;
_138d=true;
}
}
}
if(_138d){
this.linkedModeEscapePosition+=_138e;
}else{
this.cancel();
}
}.bind(this)};
};
_138b.prototype={enterLinkedMode:function(_1391){
if(this.linkedModeActive){
return;
}
this.linkedModeActive=true;
this.linkedModePositions=[];
for(var i=0;i<_1391.groups.length;++i){
var group=_1391.groups[i];
this.linkedModePositions[i]={offset:group.positions[0].offset,length:group.positions[0].length};
}
this.linkedModeEscapePosition=_1391.escapePosition;
this.linkedModeCurrentPositionIndex=0;
this.selectTextForLinkedModePosition(this.linkedModePositions[this.linkedModeCurrentPositionIndex]);
this.textView.addEventListener("Verify",this.linkedModeListener.onVerify);
this.textView.setKeyBinding(new _12c7.KeyBinding(9),"nextLinkedModePosition");
this.textView.setAction("nextLinkedModePosition",function(){
this.linkedModeCurrentPositionIndex=++this.linkedModeCurrentPositionIndex%this.linkedModePositions.length;
this.selectTextForLinkedModePosition(this.linkedModePositions[this.linkedModeCurrentPositionIndex]);
return true;
}.bind(this));
this.textView.setKeyBinding(new _12c7.KeyBinding(9,false,true),"previousLinkedModePosition");
this.textView.setAction("previousLinkedModePosition",function(){
this.linkedModeCurrentPositionIndex=this.linkedModeCurrentPositionIndex>0?this.linkedModeCurrentPositionIndex-1:this.linkedModePositions.length-1;
this.selectTextForLinkedModePosition(this.linkedModePositions[this.linkedModeCurrentPositionIndex]);
return true;
}.bind(this));
this.editor.reportStatus(_12c5.linkedModeEntered,null,true);
},isActive:function(){
return this.linkedModeActive;
},isStatusActive:function(){
return this.linkedModeActive;
},enter:function(){
this.cancel();
return true;
},cancel:function(_1392){
if(!this.linkedModeActive){
return;
}
this.linkedModeActive=false;
this.textView.removeEventListener("Verify",this.linkedModeListener.onVerify);
this.textView.setKeyBinding(new _12c7.KeyBinding(9),"tab");
this.textView.setKeyBinding(new _12c7.KeyBinding(9,false,true),"shiftTab");
if(!_1392){
this.textView.setCaretOffset(this.linkedModeEscapePosition,false);
}
this.editor.reportStatus(_12c5.linkedModeExited,null,true);
},lineUp:function(){
this.cancel(true);
return false;
},lineDown:function(){
this.cancel(true);
return false;
},selectTextForLinkedModePosition:function(_1393){
this.textView.setSelection(_1393.offset,_1393.offset+_1393.length);
}};
return {UndoFactory:_12cd,LineNumberRulerFactory:_12d1,FoldingRulerFactory:_12d3,AnnotationFactory:_12d5,TextDNDFactory:_12da,TextActions:_12dd,SourceCodeActions:_1358,LinkedMode:_138b};
});
},"dojo/dnd/Avatar":function(){
define("dojo/dnd/Avatar",["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_1394,win,dom,_1395,_1396,_1397,has,query){
return _1394("dojo.dnd.Avatar",null,{constructor:function(_1398){
this.manager=_1398;
this.construct();
},construct:function(){
var a=_1397.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_1399=this.manager.source,node,b=_1397.create("tbody",null,a),tr=_1397.create("tr",null,b),td=_1397.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;
if(has("highcontrast")){
_1397.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);
}
_1397.create("span",{innerHTML:_1399.generateText?this._generateText():""},td);
_1395.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});
for(;i<k;++i){
if(_1399.creator){
node=_1399._normalizedCreator(_1399.getItem(this.manager.nodes[i].id).data,"avatar").node;
}else{
node=this.manager.nodes[i].cloneNode(true);
if(node.tagName.toLowerCase()=="tr"){
var table=_1397.create("table"),tbody=_1397.create("tbody",null,table);
tbody.appendChild(node);
node=table;
}
}
node.id="";
tr=_1397.create("tr",null,b);
td=_1397.create("td",null,tr);
td.appendChild(node);
_1395.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});
}
this.node=a;
},destroy:function(){
_1397.destroy(this.node);
this.node=false;
},update:function(){
_1396.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);
if(has("highcontrast")){
var icon=dom.byId("a11yIcon");
var text="+";
if(this.manager.canDropFlag&&!this.manager.copy){
text="< ";
}else{
if(!this.manager.canDropFlag&&!this.manager.copy){
text="o";
}else{
if(!this.manager.canDropFlag){
text="x";
}
}
}
icon.innerHTML=text;
}
query(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){
node.innerHTML=this.manager.source.generateText?this._generateText():"";
},this);
},_generateText:function(){
return this.manager.nodes.length.toString();
}});
});
},"davinci/ve/palette/ImageDragSource":function(){
define("davinci/ve/palette/ImageDragSource",["dojo/_base/declare","davinci/ve/tools/CreateTool","davinci/ui/dnd/DragManager","davinci/ve/metadata","davinci/model/Path","davinci/Workbench",],function(_139a,_139b,_139c,_139d,Path,_139e){
return _139a("davinci.ve.palette.ImageDragSource",null,{constructor:function(data){
this.data=data;
},initDrag:function(){
var _139f=_139e.getOpenEditor();
if(_139f&&_139f.currentEditor&&_139f.currentEditor.context){
this.context=_139f.currentEditor.context;
_139c.document=this.context.getDocument();
var _13a0=this.context.frameNode;
if(_13a0){
var _13a1=dojo.coords(_13a0);
var _13a2=this.context.getContainerNode();
_139c.documentX=_13a1.x-_13a2.scrollLeft;
_139c.documentY=_13a1.y-_13a2.scrollTop;
}
}else{
this.context=null;
}
},dragStart:function(){
if(this.context){
var _13a3,_13a4=this.context.getPath(),_13a5=new Path(this.data.getPath()),_13a6=_13a5.relativeTo(_13a4,true).toString();
if(this.data.getExtension()==="json"){
_13a3={type:"dojo.data.ItemFileWriteStore",properties:{jsId:"myDataStore",url:_13a6}};
}else{
_13a3={children:[],properties:{src:_13a6},type:"html.img"};
}
_13a3.fileDragCreate=true;
_139d.getHelper(_13a3.type,"tool").then(function(_13a7){
var tool=new (_13a7||_139b)(_13a3);
this.context.setActiveTool(tool);
}.bind(this));
}
},dragEnd:function(){
if(this.context){
this.context.setActiveTool(null);
}
},createDragClone:function(){
var img=dojo.create("img",{src:this.data.getURL()});
dojo.connect(img,"onload",dojo.hitch(this,function(e){
var image=e.target;
var style=image.style;
style.width=image.naturalWidth+"px";
style.height=image.naturalHeight+"px";
}));
return img;
}});
});
},"dojox/grid/_Builder":function(){
define("dojox/grid/_Builder",["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html"],function(dojox,array,lang,win,event,has,_13a8,_13a9,_13aa,util,html){
var dg=dojox.grid;
var _13ab=function(td){
return td.cellIndex>=0?td.cellIndex:array.indexOf(td.parentNode.cells,td);
};
var _13ac=function(tr){
return tr.rowIndex>=0?tr.rowIndex:array.indexOf(tr.parentNode.childNodes,tr);
};
var getTr=function(_13ad,index){
return _13ad&&((_13ad.rows||0)[index]||_13ad.childNodes[index]);
};
var _13ae=function(node){
for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){
}
return n;
};
var _13af=function(_13b0,_13b1){
for(var n=_13b0;n&&_13b1(n);n=n.parentNode){
}
return n;
};
var _13b2=function(_13b3){
var name=_13b3.toUpperCase();
return function(node){
return node.tagName!=name;
};
};
var _13b4=util.rowIndexTag;
var _13b5=util.gridViewTag;
var _13b6=dg._Builder=lang.extend(function(view){
if(view){
this.view=view;
this.grid=view.grid;
}
},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){
var html=[this._table];
if(this.view.viewWidth){
html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));
}
html.push(">");
return html;
},generateCellMarkup:function(_13b7,_13b8,_13b9,_13ba){
var _13bb=[],html;
if(_13ba){
var _13bc=_13b7.index!=_13b7.grid.getSortIndex()?"":_13b7.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";
if(!_13b7.id){
_13b7.id=this.grid.id+"Hdr"+_13b7.index;
}
html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_13bc,"id=\"",_13b7.id,"\""];
}else{
var _13bd=this.grid.editable&&!_13b7.editable?"aria-readonly=\"true\"":"";
html=["<td tabIndex=\"-1\" role=\"gridcell\"",_13bd];
}
if(_13b7.colSpan){
html.push(" colspan=\"",_13b7.colSpan,"\"");
}
if(_13b7.rowSpan){
html.push(" rowspan=\"",_13b7.rowSpan,"\"");
}
html.push(" class=\"dojoxGridCell ");
if(_13b7.classes){
html.push(_13b7.classes," ");
}
if(_13b9){
html.push(_13b9," ");
}
_13bb.push(html.join(""));
_13bb.push("");
html=["\" idx=\"",_13b7.index,"\" style=\""];
if(_13b8&&_13b8[_13b8.length-1]!=";"){
_13b8+=";";
}
html.push(_13b7.styles,_13b8||"",_13b7.hidden?"display:none;":"");
if(_13b7.unitWidth){
html.push("width:",_13b7.unitWidth,";");
}
_13bb.push(html.join(""));
_13bb.push("");
html=["\""];
if(_13b7.attrs){
html.push(" ",_13b7.attrs);
}
html.push(">");
_13bb.push(html.join(""));
_13bb.push("");
_13bb.push(_13ba?"</th>":"</td>");
return _13bb;
},isCellNode:function(_13be){
return Boolean(_13be&&_13be!=win.doc&&html.attr(_13be,"idx"));
},getCellNodeIndex:function(_13bf){
return _13bf?Number(html.attr(_13bf,"idx")):-1;
},getCellNode:function(_13c0,_13c1){
for(var i=0,row;((row=getTr(_13c0.firstChild,i))&&row.cells);i++){
for(var j=0,cell;(cell=row.cells[j]);j++){
if(this.getCellNodeIndex(cell)==_13c1){
return cell;
}
}
}
return null;
},findCellTarget:function(_13c2,_13c3){
var n=_13c2;
while(n&&(!this.isCellNode(n)||(n.offsetParent&&_13b5 in n.offsetParent.parentNode&&n.offsetParent.parentNode[_13b5]!=this.view.id))&&(n!=_13c3)){
n=n.parentNode;
}
return n!=_13c3?n:null;
},baseDecorateEvent:function(e){
e.dispatch="do"+e.type;
e.grid=this.grid;
e.sourceView=this.view;
e.cellNode=this.findCellTarget(e.target,e.rowNode);
e.cellIndex=this.getCellNodeIndex(e.cellNode);
e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);
},findTarget:function(_13c4,inTag){
var n=_13c4;
while(n&&(n!=this.domNode)&&(!(inTag in n)||(_13b5 in n&&n[_13b5]!=this.view.id))){
n=n.parentNode;
}
return (n!=this.domNode)?n:null;
},findRowTarget:function(_13c5){
return this.findTarget(_13c5,_13b4);
},isIntraNodeEvent:function(e){
try{
return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));
}
catch(x){
return false;
}
},isIntraRowEvent:function(e){
try{
var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);
return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);
}
catch(x){
return false;
}
},dispatchEvent:function(e){
if(e.dispatch in this){
return this[e.dispatch](e);
}
return false;
},domouseover:function(e){
if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){
this.lastOverCellNode=e.cellNode;
this.grid.onMouseOver(e);
}
this.grid.onMouseOverRow(e);
},domouseout:function(e){
if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){
this.lastOverCellNode=null;
this.grid.onMouseOut(e);
if(!this.isIntraRowEvent(e)){
this.grid.onMouseOutRow(e);
}
}
},domousedown:function(e){
if(e.cellNode){
this.grid.onMouseDown(e);
}
this.grid.onMouseDownRow(e);
}});
var _13c6=dg._ContentBuilder=lang.extend(function(view){
_13b6.call(this,view);
},_13b6.prototype,{update:function(){
this.prepareHtml();
},prepareHtml:function(){
var _13c7=this.grid.get,cells=this.view.structure.cells;
for(var j=0,row;(row=cells[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
cell.get=cell.get||(cell.value==undefined)&&_13c7;
cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);
if(!this.grid.editable&&cell.editable){
this.grid.editable=true;
}
}
}
},generateHtml:function(_13c8,_13c9){
var html=this.getTableArray(),v=this.view,cells=v.structure.cells,item=this.grid.getItem(_13c9);
util.fire(this.view,"onBeforeRow",[_13c9,cells]);
for(var j=0,row;(row=cells[j]);j++){
if(row.hidden||row.header){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){
m=cell.markup;
cc=cell.customClasses=[];
cs=cell.customStyles=[];
m[5]=cell.format(_13c9,item);
m[1]=cc.join(" ");
m[3]=cs.join(";");
html.push.apply(html,m);
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},decorateEvent:function(e){
e.rowNode=this.findRowTarget(e.target);
if(!e.rowNode){
return false;
}
e.rowIndex=e.rowNode[_13b4];
this.baseDecorateEvent(e);
e.cell=this.grid.getCell(e.cellIndex);
return true;
}});
var _13ca=dg._HeaderBuilder=lang.extend(function(view){
this.moveable=null;
_13b6.call(this,view);
},_13b6.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){
if(this.tableMap){
this.tableMap.mapRows(this.view.structure.cells);
}else{
this.tableMap=new dg._TableMap(this.view.structure.cells);
}
},generateHtml:function(_13cb,_13cc){
var html=this.getTableArray(),cells=this.view.structure.cells;
util.fire(this.view,"onBeforeRow",[-1,cells]);
for(var j=0,row;(row=cells[j]);j++){
if(row.hidden){
continue;
}
html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");
for(var i=0,cell,_13cd;(cell=row[i]);i++){
cell.customClasses=[];
cell.customStyles=[];
if(this.view.simpleStructure){
if(cell.draggable){
if(cell.headerClasses){
if(cell.headerClasses.indexOf("dojoDndItem")==-1){
cell.headerClasses+=" dojoDndItem";
}
}else{
cell.headerClasses="dojoDndItem";
}
}
if(cell.attrs){
if(cell.attrs.indexOf("dndType='gridColumn_")==-1){
cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";
}
}else{
cell.attrs="dndType='gridColumn_"+this.grid.id+"'";
}
}
_13cd=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);
_13cd[5]=(_13cc!=undefined?_13cc:_13cb(cell));
_13cd[3]=cell.customStyles.join(";");
_13cd[1]=cell.customClasses.join(" ");
html.push(_13cd.join(""));
}
html.push("</tr>");
}
html.push("</table>");
return html.join("");
},getCellX:function(e){
var n,x=e.layerX;
if(has("mozilla")||has("ie")>=9){
n=_13af(e.target,_13b2("th"));
x-=(n&&n.offsetLeft)||0;
var t=e.sourceView.getScrollbarWidth();
if(!this.grid.isLeftToRight()){
table=_13af(n,_13b2("table"));
x-=(table&&table.offsetLeft)||0;
}
}
n=_13af(e.target,function(){
if(!n||n==e.cellNode){
return false;
}
x+=(n.offsetLeft<0?0:n.offsetLeft);
return true;
});
return x;
},decorateEvent:function(e){
this.baseDecorateEvent(e);
e.rowIndex=-1;
e.cellX=this.getCellX(e);
return true;
},prepareResize:function(e,mod){
do{
var i=e.cellIndex;
e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);
e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);
}while(e.cellNode&&e.cellNode.style.display=="none");
return Boolean(e.cellNode);
},canResize:function(e){
if(!e.cellNode||e.cellNode.colSpan>1){
return false;
}
var cell=this.grid.getCell(e.cellIndex);
return !cell.noresize&&cell.canResize();
},overLeftResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);
}
var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);
return t;
},overRightResizeArea:function(e){
if(html.hasClass(win.body(),"dojoDndMove")){
return false;
}
if(has("ie")){
var tN=e.target;
if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){
return false;
}
}
if(this.grid.isLeftToRight()){
return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);
}
return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);
},domousemove:function(e){
if(!this.moveable){
var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));
if(c&&!this.canResize(e)){
c="dojoxGridColNoResize";
}
html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));
html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));
if(c){
event.stop(e);
}
}
},domousedown:function(e){
if(!this.moveable){
if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){
this.beginColumnResize(e);
}else{
this.grid.onMouseDown(e);
this.grid.onMouseOverRow(e);
}
}
},doclick:function(e){
if(this._skipBogusClicks){
event.stop(e);
return true;
}
return false;
},colResizeSetup:function(e,_13ce){
var _13cf=html.contentBox(e.sourceView.headerNode);
if(_13ce){
this.lineDiv=document.createElement("div");
var vw=html.position(e.sourceView.headerNode,true);
var _13d0=html.contentBox(e.sourceView.domNode);
var l=e.pageX;
if(!this.grid.isLeftToRight()&&has("ie")<8){
l-=_13aa.getScrollbar().w;
}
html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_13d0.h+_13cf.h)+"px"});
html.addClass(this.lineDiv,"dojoxGridResizeColLine");
this.lineDiv._origLeft=l;
win.body().appendChild(this.lineDiv);
}
var _13d1=[],nodes=this.tableMap.findOverlappingNodes(e.cellNode);
for(var i=0,cell;(cell=nodes[i]);i++){
_13d1.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});
}
var view=e.sourceView;
var adj=this.grid.isLeftToRight()?1:-1;
var views=e.grid.views.views;
var _13d2=[];
for(var j=view.idx+adj,cView;(cView=views[j]);j=j+adj){
_13d2.push({node:cView.headerNode,left:window.parseInt(cView.headerNode.style.left)});
}
var table=view.headerContentNode.firstChild;
var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_13cf.w,table:table,tw:html.contentBox(table).w,spanners:_13d1,followers:_13d2};
return drag;
},beginColumnResize:function(e){
this.moverDiv=document.createElement("div");
html.style(this.moverDiv,{position:"absolute",left:0});
win.body().appendChild(this.moverDiv);
html.addClass(this.grid.domNode,"dojoxGridColumnResizing");
var m=(this.moveable=new _13a9(this.moverDiv));
var drag=this.colResizeSetup(e,true);
m.onMove=lang.hitch(this,"doResizeColumn",drag);
_13a8.connect(m,"onMoveStop",lang.hitch(this,function(){
this.endResizeColumn(drag);
if(drag.node.releaseCapture){
drag.node.releaseCapture();
}
this.moveable.destroy();
delete this.moveable;
this.moveable=null;
html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");
}));
if(e.cellNode.setCapture){
e.cellNode.setCapture();
}
m.onMouseDown(e);
},doResizeColumn:function(_13d3,mover,_13d4){
var _13d5=_13d4.l;
var data={deltaX:_13d5,w:_13d3.w+(this.grid.isLeftToRight()?_13d5:-_13d5),vw:_13d3.vw+_13d5,tw:_13d3.tw+_13d5};
this.dragRecord={inDrag:_13d3,mover:mover,leftTop:_13d4};
if(data.w>=this.minColWidth){
if(!mover){
this.doResizeNow(_13d3,data);
}else{
html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");
}
}
},endResizeColumn:function(_13d6){
if(this.dragRecord){
var _13d7=this.dragRecord.leftTop;
var _13d8=this.grid.isLeftToRight()?_13d7.l:-_13d7.l;
_13d8+=Math.max(_13d6.w+_13d8,this.minColWidth)-(_13d6.w+_13d8);
if(has("webkit")&&_13d6.spanners.length){
_13d8+=html._getPadBorderExtents(_13d6.spanners[0].node).w;
}
var data={deltaX:_13d8,w:_13d6.w+_13d8,vw:_13d6.vw+_13d8,tw:_13d6.tw+_13d8};
this.doResizeNow(_13d6,data);
delete this.dragRecord;
}
html.destroy(this.lineDiv);
html.destroy(this.moverDiv);
html.destroy(this.moverDiv);
delete this.moverDiv;
this._skipBogusClicks=true;
_13d6.view.update();
this._skipBogusClicks=false;
this.grid.onResizeColumn(_13d6.index);
},doResizeNow:function(_13d9,data){
_13d9.view.convertColPctToFixed();
if(_13d9.view.flexCells&&!_13d9.view.testFlexCells()){
var t=_13ae(_13d9.node);
if(t){
(t.style.width="");
}
}
var i,s,sw,f,fl;
for(i=0;(s=_13d9.spanners[i]);i++){
sw=s.width+data.deltaX;
if(sw>0){
s.node.style.width=sw+"px";
_13d9.view.setColWidth(s.index,sw);
}
}
if(this.grid.isLeftToRight()||!has("ie")){
for(i=0;(f=_13d9.followers[i]);i++){
fl=f.left+data.deltaX;
f.node.style.left=fl+"px";
}
}
_13d9.node.style.width=data.w+"px";
_13d9.view.setColWidth(_13d9.index,data.w);
_13d9.view.headerNode.style.width=data.vw+"px";
_13d9.view.setColumnsWidth(data.tw);
if(!this.grid.isLeftToRight()){
_13d9.view.headerNode.scrollLeft=_13d9.scrollLeft+data.deltaX;
}
}});
dg._TableMap=lang.extend(function(rows){
this.mapRows(rows);
},{map:null,mapRows:function(_13da){
var _13db=_13da.length;
if(!_13db){
return;
}
this.map=[];
var row;
for(var k=0;(row=_13da[k]);k++){
this.map[k]=[];
}
for(var j=0;(row=_13da[j]);j++){
for(var i=0,x=0,cell,_13dc,_13dd;(cell=row[i]);i++){
while(this.map[j][x]){
x++;
}
this.map[j][x]={c:i,r:j};
_13dd=cell.rowSpan||1;
_13dc=cell.colSpan||1;
for(var y=0;y<_13dd;y++){
for(var s=0;s<_13dc;s++){
this.map[j+y][x+s]=this.map[j][x];
}
}
x+=_13dc;
}
}
},dumpMap:function(){
for(var j=0,row,h="";(row=this.map[j]);j++,h=""){
for(var i=0,cell;(cell=row[i]);i++){
h+=cell.r+","+cell.c+"   ";
}
}
},getMapCoords:function(inRow,inCol){
for(var j=0,row;(row=this.map[j]);j++){
for(var i=0,cell;(cell=row[i]);i++){
if(cell.c==inCol&&cell.r==inRow){
return {j:j,i:i};
}
}
}
return {j:-1,i:-1};
},getNode:function(_13de,inRow,inCol){
var row=_13de&&_13de.rows[inRow];
return row&&row.cells[inCol];
},_findOverlappingNodes:function(_13df,inRow,inCol){
var nodes=[];
var m=this.getMapCoords(inRow,inCol);
for(var j=0,row;(row=this.map[j]);j++){
if(j==m.j){
continue;
}
var rw=row[m.i];
var n=(rw?this.getNode(_13df,rw.r,rw.c):null);
if(n){
nodes.push(n);
}
}
return nodes;
},findOverlappingNodes:function(_13e0){
return this._findOverlappingNodes(_13ae(_13e0),_13ac(_13e0.parentNode),_13ab(_13e0));
}});
return {_Builder:_13b6,_HeaderBuilder:_13ca,_ContentBuilder:_13c6};
});
},"davinci/model/Path":function(){
define("davinci/model/Path",["dojo/_base/declare"],function(_13e1){
if(typeof davinci.model==="undefined"){
davinci.model={};
}
if(typeof davinci.model.Path==="undefined"){
davinci.model.Path={};
}
var Path=_13e1("davinci.model.Path",null,{constructor:function(path,_13e2,_13e3){
path=path||".";
if(typeof path=="string"){
this.path=path;
this.getSegments();
}else{
this.segments=path;
this.hasLeading=_13e2;
this.hasTrailing=_13e3;
}
},endsWith:function(tail){
var _13e4=dojo.clone(this.segments);
var _13e5=(new Path(tail)).getSegments();
while(_13e5.length>0&&_13e4.length>0){
if(_13e5.pop()!=_13e4.pop()){
return false;
}
}
return true;
},getExtension:function(){
if(!this.extension){
this.extension=this.path.substr(this.path.lastIndexOf(".")+1);
}
return this.extension;
},segment:function(index){
var segs=this.getSegments();
if(segs.length<index){
return null;
}
return segs[index];
},getSegments:function(){
if(!this.segments){
var path=this.path;
this.segments=path.split("/");
if(path.charAt(0)=="/"){
this.hasLeading=true;
}
if(path.charAt(path.length-1)=="/"){
this.hasTrailing=true;
this.segments.pop();
}
this._canonicalize();
}
return this.segments;
},isAbsolute:function(){
return this.hasLeading;
},getParentPath:function(){
if(!this._parentPath){
var _13e6=dojo.clone(this.segments);
_13e6.pop();
this._parentPath=new Path(_13e6,this.hasLeading);
}
return dojo.clone(this._parentPath);
},_clone:function(){
return new Path(dojo.clone(this.segments),this.hasLeading,this.hasTrailing);
},append:function(tail){
tail=tail||"";
if(typeof tail=="string"){
tail=new Path(tail);
}
if(tail.isAbsolute()){
return tail;
}
var _13e7=this.segments;
var _13e8=tail.getSegments();
var _13e9=_13e7.concat(_13e8);
var _13ea=new Path(_13e9,this.hasLeading,tail.hasTrailing);
if(_13e8[0]==".."||_13e8[0]=="."){
_13ea._canonicalize();
}
return _13ea;
},toString:function(){
var _13eb=[];
if(this.hasLeading){
_13eb.push("/");
}
for(var i=0;i<this.segments.length;i++){
if(i>0){
_13eb.push("/");
}
_13eb.push(this.segments[i]);
}
if(this.hasTrailing){
_13eb.push("/");
}
return _13eb.join("");
},removeRelative:function(){
var segs=this.getSegments();
if(segs.length>0&&segs[1]=="."){
return this.removeFirstSegments(1);
}
return this;
},relativeTo:function(base,_13ec){
if(typeof base=="string"){
base=new Path(base);
}
var _13ed=this.segments;
if(this.isAbsolute()){
return this;
}
var _13ee=base.getSegments();
var _13ef=this.matchingFirstSegments(base);
var _13f0=_13ee.length;
if(_13ec){
_13f0=_13f0-1;
}
var _13f1=_13f0-_13ef;
var _13f2=_13f1+_13ed.length-_13ef;
if(_13f2==0){
return davinci.model.Path.EMPTY;
}
var _13f3=[];
for(var i=0;i<_13f1;i++){
_13f3.push("..");
}
for(var i=_13ef;i<_13ed.length;i++){
_13f3.push(_13ed[i]);
}
return new Path(_13f3,false,this.hasTrailing);
},startsWith:function(_13f4){
var count=this.matchingFirstSegments(_13f4);
return _13f4._length()==count;
},_length:function(_13f5){
return this.segments.length;
},matchingFirstSegments:function(_13f6){
var _13f7=this.segments;
var _13f8=_13f6.getSegments();
var max=Math.min(_13f7.length,_13f8.length);
var count=0;
for(var i=0;i<max;i++){
if(_13f7[i]!=_13f8[i]){
return count;
}
count++;
}
return count;
},removeFirstSegments:function(count){
return new Path(this.segments.slice(count,this.segments.length),this.hasLeading,this.hasTrailing);
},removeMatchingLastSegments:function(_13f9){
var match=this.matchingFirstSegments(_13f9);
return this.removeLastSegments(match);
},removeMatchingFirstSegments:function(_13fa){
var match=this.matchingFirstSegments(_13fa);
return this._clone().removeFirstSegments(match);
},removeLastSegments:function(count){
if(!count){
count=1;
}
return new Path(this.segments.slice(0,this.segments.length-count),this.hasLeading,this.hasTrailing);
},lastSegment:function(){
return this.segments[this.segments.length-1];
},firstSegment:function(_13fb){
return this.segments[_13fb||0];
},equals:function(_13fc){
if(this.segments.length!=_13fc.segments.length){
return false;
}
for(var i=0;i<this.segments.length;i++){
if(_13fc.segments[i]!=this.segments[i]){
return false;
}
}
return true;
},_canonicalize:function(){
var doIt;
var _13fd=this.segments;
for(var i=0;i<_13fd.length;i++){
if(_13fd[i]=="."||_13fd[i]==".."){
doIt=true;
break;
}
}
if(doIt){
var stack=[];
for(var i=0;i<_13fd.length;i++){
if(_13fd[i]==".."){
if(stack.length==0){
if(!this.hasLeading){
stack.push(_13fd[i]);
}
}else{
if(".."==stack[stack.length-1]){
stack.push("..");
}else{
stack.pop();
}
}
}else{
if(_13fd[i]!="."||this.segments.length==1){
stack.push(_13fd[i]);
}
}
}
if(stack.length==_13fd.length){
return;
}
this.segments=stack;
}
}});
davinci.model.Path.EMPTY=new Path("");
return Path;
});
},"davinci/ve/utils/GeomUtils":function(){
define("davinci/ve/utils/GeomUtils",["dojo/_base/window","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/sniff"],function(win,_13fe,_13ff,has,sniff){
var _1400=["TABLE","TBODY","TR","TD","TH"];
return {getMarginBoxPageCoords:function(node){
var _1401;
win.withDoc(node.ownerDocument,function(){
var _1402=this.getBorderBoxPageCoords(node);
var _1403=this.getMarginExtents(node);
_1401={l:_1402.l-_1403.l,t:_1402.t-_1403.t,w:_1402.w+_1403.l+_1403.r,h:_1402.h+_1403.t+_1403.b};
}.bind(this));
return _1401;
},getMarginBoxPageCoordsCached:function(node){
if(!node._maqMarginBoxPageCoords){
node._maqMarginBoxPageCoords=this.getMarginBoxPageCoords(node);
}
return node._maqMarginBoxPageCoords;
},getBorderBoxPageCoords:function(node){
var o;
win.withDoc(node.ownerDocument,function(){
if(_1400.indexOf(node.tagName)){
var bcr=node.getBoundingClientRect();
var _1404=this.getScrollLeft(node);
var _1405=this.getScrollTop(node);
o={l:bcr.left+_1404,t:bcr.top+_1405,w:bcr.width,h:bcr.height};
}else{
var l=node.offsetLeft;
var t=node.offsetTop;
var pn=node.parentNode;
var opn=node.offsetParent;
while(pn&&pn.tagName!="BODY"){
if(typeof pn.scrollLeft=="number"&&typeof pn.scrollTop=="number"){
l-=pn.scrollLeft;
t-=pn.scrollTop;
}
if(pn==opn){
var _1406=_13fe.getBorderExtents(opn);
l+=opn.offsetLeft+_1406.l;
t+=opn.offsetTop+_1406.t;
opn=opn.offsetParent;
}
pn=pn.parentNode;
}
o={l:l,t:t,w:node.offsetWidth,h:node.offsetHeight};
}
}.bind(this));
return o;
},getBorderBoxPageCoordsCached:function(node){
if(!node._maqBorderBoxPageCoords){
node._maqBorderBoxPageCoords=this.getBorderBoxPageCoords(node);
}
return node._maqBorderBoxPageCoords;
},getScrollLeft:function(node){
var doc=node&&node.ownerDocument;
if(has("mozilla")){
var win=doc&&doc.defaultView;
return win?win.pageXOffset:0;
}else{
var body=doc&&doc.body;
return body?body.scrollLeft:0;
}
},getScrollTop:function(node){
var doc=node&&node.ownerDocument;
if(has("mozilla")){
var win=doc&&doc.defaultView;
return win?win.pageYOffset:0;
}else{
var body=doc&&doc.body;
return body?body.scrollTop:0;
}
},getMarginExtents:function getMarginExtents(node,_1407){
var s=_1407||_13ff.getComputedStyle(node);
var l,t,r,b;
function px(value){
return parseFloat(value)||0;
};
if(s){
l=px(s.marginLeft);
t=px(s.marginTop);
r=px(s.marginRight);
b=px(s.marginBottom);
}else{
l=t=r=b=0;
}
return {l:l,t:t,r:r,b:b,w:l+r,h:t+b};
},clearGeomCache:function(node){
delete node._maqBorderBoxPageCoords;
delete node._maqMarginBoxPageCoords;
}};
});
},"davinci/ui/NewTheme":function(){
require({cache:{"url:davinci/ui/templates/newtheme.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table>\n\t\t<tr>\n\t\t<td>${themeToClone}:</td><td> <div dojoType=\"davinci.ui.widgets.ThemeSelection\" workspaceOnly=\"false\" dojoAttachPoint = '_themeSelection'></div></td><td><div dojoAttachPoint='_error1'></div></td>\n\t\t</tr>\n\t\t<tr><td colspan='3'><hr></hr></td></tr>\n\t\t<!-- \n\t\t<tr>\n\t\t<td>New Name:</td><td><input style='width:100%' type='select' dojoAttachPoint=\"_themeName\"></input></td><td><div dojoAttachPoint='_error2'></div></td>\n\t\t</tr>\n\t\t<tr>\n\t\t<td>Version:</td><td><input style='width:100%' type='text' dojoAttachPoint=\"_version\"></input></td><td><div dojoAttachPoint='_error3'></div></td>\n\t\t</tr>\n\t\t -->\n\t\t<tr>\n\t\t<td>${newName}:</td><td><input class='templateInput' type='text' \n\t\t\tdojoAttachPoint=\"_selector\"\n\t\t\tdojoType=\"dijit.form.ValidationTextBox\"\n\t\t\trequired=\"true\" \n\t\t\tinvalidMessage='${invalidThemeName}'></input></td><td><div dojoAttachPoint='_error4'></div></td>\n\t\t</tr>\n\t\t</table>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='${create}' class=\"maqPrimaryButton\" type=\"submit\" disabled></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\t\t\n</div>"}});
define("davinci/ui/NewTheme",["dojo/_base/declare","dijit/_TemplatedMixin","dijit/_WidgetBase","dijit/_WidgetsInTemplateMixin","system/resource","../model/Path","../Workbench","../workbench/Preferences","dojo/i18n!./nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/newtheme.html","../Theme","./widgets/ThemeSelection","dijit/form/Button","dijit/form/ValidationTextBox"],function(_1408,_1409,_140a,_140b,_140c,Path,_140d,_140e,uiNLS,_140f,_1410,Theme,_1411,_1412,_1413){
return _1408([_140a,_1409,_140b],{templateString:_1410,_themeSelection:null,_okButton:null,_folder:null,_themeName:null,_folder:null,_version:null,_selector:null,_themeLocation:null,_error1:null,_error2:null,_error3:null,_error4:null,_errorMsg:null,_themeValidator:/^[-]?([_a-z]|[^\0-\237]|\[0-9a-f]{1,6}(\r\n|[ \n\r\t\f])?|\[^\n\r\f0-9a-f])([_a-z0-9-]|[^\0-\237]|\[0-9a-f]{1,6}(\r\n|[ \n\r\t\f])?|\[^\n\r\f0-9a-f])*$/i,postMixInProperties:function(){
var _1414=uiNLS;
var _1415=_140f;
dojo.mixin(this,_1414);
dojo.mixin(this,_1415);
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
dojo.connect(this._themeSelection,"onChange",this,"_baseThemeChanged");
dojo.connect(this._themeSelection,"onChange",this,"_checkValid");
this._selector.validator=dojo.hitch(this,function(value,_1416){
var _1417=this._themeValidator.test(value);
this._okButton.set("disabled",!_1417);
return _1417;
});
},_baseThemeChanged:function(){
this._theme=this._themeSelection.get("value");
},_createTheme:function(){
this._okButton.set("disabled",true);
var _1418=uiNLS;
var _1419=this._themeSelection.get("value");
var _141a=this._selector.get("value");
var _141b=_141a;
var _141c=null;
var base=_141a;
var _141d=this._getThemeLocation();
var r1=_140c.findResource(_141d+"/"+base+".theme");
if(r1){
alert(_1418.themeAlreadyExists);
}else{
this._loading=dojo.create("div",null,dojo.body(),"first");
this._loading.innerHTML=dojo.string.substitute("<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;${0}...</td></tr></table>",[_1418.creatingTheme]);
dojo.addClass(this._loading,"loading");
dojo.style(this._loading,"opacity","0.5");
var _141e=this.getBase();
var a=Theme.CloneTheme(_141b,_141c,_141a,_141d,_1419,true);
a.promise.then(function(_141f){
var _1420=a.themeFile;
if(_1420){
_1420.isNew=false;
return _1420.getContent().then(function(_1421){
_140d.openEditor({fileName:_1420,content:_1421});
});
}else{
throw new Error(_1418.errorCreatingTheme+base);
}
}).otherwise(function(_1422){
var _1423="Uh oh! An error has occurred:<br><b>"+_1422.message+"</b>";
if(_1422.fileName){
_1423+="<br>file: "+_1422.fileName+"<br>line: "+_1422.lineNumber;
}
if(_1422.stack){
_1423+="<br><pre>"+_1422.stack+"</pre>";
}
console.error(_1423);
}).otherwise(function(){
if(this._loading){
this._loading.parentNode.removeChild(this._loading);
delete this._loading;
}
}.bind(this));
}
},getBase:function(){
if(_140d.singleProjectMode()){
return _140d.getProject();
}
},_getThemeLocation:function(){
var _1424=this._selector.get("value");
var base=this.getBase();
var prefs=_140e.getPreferences("davinci.ui.ProjectPrefs",base);
var _1425=new Path(base).append(prefs.themeFolder);
return _1425.append(_1424).toString();
},_checkValid:function(){
var isOk=true;
var _1426=this._themeSelection.get("value");
var _1427=this._selector.get("value");
if(_1426==null||_1426==""||_1427==null||_1427==""){
isOk=false;
}
this._okButton.set("disabled",!isOk);
},okButton:function(){
this._createTheme();
},cancelButton:function(){
this.cancel=true;
this.onClose();
},onClose:function(){
}});
});
},"dijit/InlineEditBox":function(){
require({cache:{"url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\tdata-dojo-attach-event=\"onkeypress: _onKeyPress\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"dijit/form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"dijit/form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n"}});
define("dijit/InlineEditBox",["require","dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/_base/event","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/when","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_1428,array,_1429,_142a,_142b,_142c,_142d,event,i18n,_142e,keys,lang,has,when,fm,_142f,_1430,_1431,_1432,_1433,_1434,_1435,_1436){
var _1437=_1429("dijit._InlineEditor",[_142f,_1430,_1431],{templateString:_1436,postMixInProperties:function(){
this.inherited(arguments);
this.messages=i18n.getLocalization("dijit","common",this.lang);
array.forEach(["buttonSave","buttonCancel"],function(prop){
if(!this[prop]){
this[prop]=this.messages[prop];
}
},this);
},buildRendering:function(){
this.inherited(arguments);
var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_1428(this.editor)):this.editor;
var _1438=this.sourceStyle,_1439="line-height:"+_1438.lineHeight+";",_143a=_142d.getComputedStyle(this.domNode);
array.forEach(["Weight","Family","Size","Style"],function(prop){
var _143b=_1438["font"+prop],_143c=_143a["font"+prop];
if(_143c!=_143b){
_1439+="font-"+prop+":"+_1438["font"+prop]+";";
}
},this);
array.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){
this.domNode.style[prop]=_1438[prop];
},this);
var width=this.inlineEditBox.width;
if(width=="100%"){
_1439+="width:100%;";
this.domNode.style.display="block";
}else{
_1439+="width:"+(width+(Number(width)==width?"px":""))+";";
}
var _143d=lang.delegate(this.inlineEditBox.editorParams,{style:_1439,dir:this.dir,lang:this.lang,textDir:this.textDir});
_143d["displayedValue" in Cls.prototype?"displayedValue":"value"]=this.value;
this.editWidget=new Cls(_143d,this.editorPlaceholder);
if(this.inlineEditBox.autoSave){
_142c.destroy(this.buttonContainer);
}
},postCreate:function(){
this.inherited(arguments);
var ew=this.editWidget;
if(this.inlineEditBox.autoSave){
this.connect(ew,"onChange","_onChange");
this.connect(ew,"onKeyPress","_onKeyPress");
}else{
if("intermediateChanges" in ew){
ew.set("intermediateChanges",true);
this.connect(ew,"onChange","_onIntermediateChange");
this.saveButton.set("disabled",true);
}
}
},startup:function(){
this.editWidget.startup();
this.inherited(arguments);
},_onIntermediateChange:function(){
this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());
},destroy:function(){
this.editWidget.destroy(true);
this.inherited(arguments);
},getValue:function(){
var ew=this.editWidget;
return String(ew.get("displayedValue" in ew?"displayedValue":"value"));
},_onKeyPress:function(e){
if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){
if(e.altKey||e.ctrlKey){
return;
}
if(e.charOrCode==keys.ESCAPE){
event.stop(e);
this.cancel(true);
}else{
if(e.charOrCode==keys.ENTER&&e.target.tagName=="INPUT"){
event.stop(e);
this._onChange();
}
}
}
},_onBlur:function(){
this.inherited(arguments);
if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){
if(this.getValue()==this._resetValue){
this.cancel(false);
}else{
if(this.enableSave()){
this.save(false);
}
}
}
},_onChange:function(){
if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){
fm.focus(this.inlineEditBox.displayNode);
}
},enableSave:function(){
return this.editWidget.isValid?this.editWidget.isValid():true;
},focus:function(){
this.editWidget.focus();
if(this.editWidget.focusNode){
fm._onFocusNode(this.editWidget.focusNode);
if(this.editWidget.focusNode.tagName=="INPUT"){
this.defer(function(){
_1434.selectInputText(this.editWidget.focusNode);
});
}
}
}});
var _143e=_1429("dijit.InlineEditBox",_142f,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_1435,editorWrapper:_1437,editorParams:{},disabled:false,onChange:function(){
},onCancel:function(){
},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){
this.editorParams={};
},postMixInProperties:function(){
this.inherited(arguments);
this.displayNode=this.srcNodeRef;
var _143f={ondijitclick:"_onClick",onmouseover:"_onMouseOver",onmouseout:"_onMouseOut",onfocus:"_onMouseOver",onblur:"_onMouseOut"};
for(var name in _143f){
this.connect(this.displayNode,name,_143f[name]);
}
this.displayNode.setAttribute("role","button");
if(!this.displayNode.getAttribute("tabIndex")){
this.displayNode.setAttribute("tabIndex",0);
}
if(!this.value&&!("value" in this.params)){
this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));
}
if(!this.value){
this.displayNode.innerHTML=this.noValueIndicator;
}
_142b.add(this.displayNode,"dijitInlineEditBoxDisplayMode");
},setDisabled:function(_1440){
_142e.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");
this.set("disabled",_1440);
},_setDisabledAttr:function(_1441){
this.domNode.setAttribute("aria-disabled",_1441?"true":"false");
if(_1441){
this.displayNode.removeAttribute("tabIndex");
}else{
this.displayNode.setAttribute("tabIndex",0);
}
_142b.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_1441);
this._set("disabled",_1441);
},_onMouseOver:function(){
if(!this.disabled){
_142b.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");
}
},_onMouseOut:function(){
_142b.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");
},_onClick:function(e){
if(this.disabled){
return;
}
if(e){
event.stop(e);
}
this._onMouseOut();
this.defer("edit");
},edit:function(){
if(this.disabled||this.editing){
return;
}
this._set("editing",true);
this._savedTabIndex=_142a.get(this.displayNode,"tabIndex")||"0";
if(this.wrapperWidget){
var ew=this.wrapperWidget.editWidget;
ew.set("displayedValue" in ew?"displayedValue":"value",this.value);
}else{
var _1442=_142c.create("span",null,this.domNode,"before");
var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;
this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_142d.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_1442);
if(!this.wrapperWidget._started){
this.wrapperWidget.startup();
}
if(!this._started){
this.startup();
}
}
var ww=this.wrapperWidget;
_142b.add(this.displayNode,"dijitOffScreen");
_142b.remove(ww.domNode,"dijitOffScreen");
_142d.set(ww.domNode,{visibility:"visible"});
_142a.set(this.displayNode,"tabIndex","-1");
when(ww.editWidget.onLoadDeferred,lang.hitch(ww,function(){
this.defer(function(){
this.focus();
this._resetValue=this.getValue();
});
}));
},_onBlur:function(){
this.inherited(arguments);
if(!this.editing){
}
},destroy:function(){
if(this.wrapperWidget&&!this.wrapperWidget._destroyed){
this.wrapperWidget.destroy();
delete this.wrapperWidget;
}
this.inherited(arguments);
},_showText:function(focus){
var ww=this.wrapperWidget;
_142d.set(ww.domNode,{visibility:"hidden"});
_142b.add(ww.domNode,"dijitOffScreen");
_142b.remove(this.displayNode,"dijitOffScreen");
_142a.set(this.displayNode,"tabIndex",this._savedTabIndex);
if(focus){
fm.focus(this.displayNode);
}
},save:function(focus){
if(this.disabled||!this.editing){
return;
}
this._set("editing",false);
var ww=this.wrapperWidget;
var value=ww.getValue();
this.set("value",value);
this._showText(focus);
},setValue:function(val){
_142e.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
return this.set("value",val);
},_setValueAttr:function(val){
val=lang.trim(val);
var _1443=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");
this.displayNode.innerHTML=_1443||this.noValueIndicator;
this._set("value",val);
if(this._started){
this.defer(function(){
this.onChange(val);
});
}
if(this.textDir=="auto"){
this.applyTextDir(this.displayNode,this.displayNode.innerText);
}
},getValue:function(){
_142e.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");
return this.get("value");
},cancel:function(focus){
if(this.disabled||!this.editing){
return;
}
this._set("editing",false);
this.defer("onCancel");
this._showText(focus);
},_setTextDirAttr:function(_1444){
if(!this._created||this.textDir!=_1444){
this._set("textDir",_1444);
this.applyTextDir(this.displayNode,this.displayNode.innerText);
this.displayNode.align=this.dir=="rtl"?"right":"left";
}
}});
_143e._InlineEditor=_1437;
return _143e;
});
},"url:davinci/workbench/templates/Preferences.html":"<div style='width:100%; height: 100%'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div dojoType='dijit.layout.BorderContainer' dojoAttachPoint=\"borderContainer\" style='width:100%; height: 100%' gutters='false' liveSplitters='true' id='preferencesContainer'>\n\t\t\t<div dojoType='dijit.layout.ContentPane' id='pref.TreePane' splitter='true' region='leading' style='width: 200px;' minSize='100' maxSize='300'></div>\n\t\t\t<div dojoType='dijit.layout.ContentPane' region='center' id='pref.RightPane'></div>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<!-- FIXME: we don't have logic to yet implement restoreDefaults() yet. See #627\n\t\t<button dojoType=dijit.form.Button type=\"button\" onclick=\"davinci.workbench.Preferences.restoreDefaults();\"></button>-->\n\t\t<button dojoType=\"dijit.form.Button\" type=\"button\" onclick=\"davinci.workbench.Preferences.save();\" class=\"maqPrimaryButton\" type=\"submit\">${commonStrings.buttonSave}</button>\n\t\t<button dojoType=\"dijit.form.Button\" type=\"button\" onclick=\"davinci.workbench.Preferences.finish();\" class=\"maqSecondaryButton\">${commonStrings.buttonCancel}</button>\n\t</div>\n</div>\n\n\n","davinci/ve/RebaseDownload":function(){
define("davinci/ve/RebaseDownload",["dojo/_base/declare","./RebuildPage","../library"],function(_1445,_1446,_1447){
return _1445(_1446,{constructor:function(libs){
this.libs=libs;
},getLibraryBase:function(id,_1448){
for(var name in this.libs){
var item=this.libs[name];
if(item.id==id&&item.version==_1448){
var d=new Deferred();
d.resolve(item.root);
return d;
}
}
return _1447.getLibRoot(id,_1448)||"";
}});
});
},"dijit/layout/BorderContainer":function(){
define("dijit/layout/BorderContainer",["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./_LayoutWidget","./utils"],function(array,_1449,_144a,_144b,_144c,_144d,_144e,event,keys,lang,on,touch,_144f,_1450,_1451,_1452,_1453){
var _1454=_144a("dijit.layout._Splitter",[_1450,_1451],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeypress:_onKeyPress,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){
this._handlers=[];
},postMixInProperties:function(){
this.inherited(arguments);
this.horizontal=/top|bottom/.test(this.region);
this._factor=/top|left/.test(this.region)?1:-1;
this._cookieName=this.container.id+"_"+this.region;
},buildRendering:function(){
this.inherited(arguments);
_144b.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));
if(this.container.persist){
var _1455=_1449(this._cookieName);
if(_1455){
this.child.domNode.style[this.horizontal?"height":"width"]=_1455;
}
}
},_computeMaxSize:function(){
var dim=this.horizontal?"h":"w",_1456=_144d.getMarginBox(this.child.domNode)[dim],_1457=array.filter(this.container.getChildren(),function(child){
return child.region=="center";
})[0],_1458=_144d.getMarginBox(_1457.domNode)[dim];
return Math.min(this.child.maxSize,_1456+_1458);
},_startDrag:function(e){
if(!this.cover){
this.cover=_144c.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");
}
_144b.add(this.cover,"dijitSplitterCoverActive");
if(this.fake){
_144c.destroy(this.fake);
}
if(!(this._resize=this.live)){
(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");
_144b.add(this.domNode,"dijitSplitterShadow");
_144c.place(this.fake,this.domNode,"after");
}
_144b.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");
if(this.fake){
_144b.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");
}
var _1459=this._factor,_145a=this.horizontal,axis=_145a?"pageY":"pageX",_145b=e[axis],_145c=this.domNode.style,dim=_145a?"h":"w",_145d=_144d.getMarginBox(this.child.domNode)[dim],max=this._computeMaxSize(),min=this.child.minSize||20,_145e=this.region,_145f=_145e=="top"||_145e=="bottom"?"top":"left",_1460=parseInt(_145c[_145f],10),_1461=this._resize,_1462=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;
this._handlers=this._handlers.concat([on(de,touch.move,this._drag=function(e,_1463){
var delta=e[axis]-_145b,_1464=_1459*delta+_145d,_1465=Math.max(Math.min(_1464,max),min);
if(_1461||_1463){
_1462(_1465);
}
_145c[_145f]=delta+_1460+_1459*(_1465-_1464)+"px";
}),on(de,"dragstart",event.stop),on(this.ownerDocumentBody,"selectstart",event.stop),on(de,touch.release,lang.hitch(this,"_stopDrag"))]);
event.stop(e);
},_onMouse:function(e){
var o=(e.type=="mouseover"||e.type=="mouseenter");
_144b.toggle(this.domNode,"dijitSplitterHover",o);
_144b.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);
},_stopDrag:function(e){
try{
if(this.cover){
_144b.remove(this.cover,"dijitSplitterCoverActive");
}
if(this.fake){
_144c.destroy(this.fake);
}
_144b.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");
this._drag(e);
this._drag(e,true);
}
finally{
this._cleanupHandlers();
delete this._drag;
}
if(this.container.persist){
_1449(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});
}
},_cleanupHandlers:function(){
var h;
while(h=this._handlers.pop()){
h.remove();
}
},_onKeyPress:function(e){
this._resize=true;
var _1466=this.horizontal;
var tick=1;
switch(e.charOrCode){
case _1466?keys.UP_ARROW:keys.LEFT_ARROW:
tick*=-1;
case _1466?keys.DOWN_ARROW:keys.RIGHT_ARROW:
break;
default:
return;
}
var _1467=_144d.getMarginSize(this.child.domNode)[_1466?"h":"w"]+this._factor*tick;
this.container._layoutChildren(this.child.id,Math.max(Math.min(_1467,this._computeMaxSize()),this.child.minSize));
event.stop(e);
},destroy:function(){
this._cleanupHandlers();
delete this.child;
delete this.container;
delete this.cover;
delete this.fake;
this.inherited(arguments);
}});
var _1468=_144a("dijit.layout._Gutter",[_1450,_1451],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){
this.inherited(arguments);
this.horizontal=/top|bottom/.test(this.region);
},buildRendering:function(){
this.inherited(arguments);
_144b.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));
}});
var _1469=_144a("dijit.layout.BorderContainer",_1452,{design:"headline",gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_1454,postMixInProperties:function(){
if(!this.gutters){
this.baseClass+="NoGutter";
}
this.inherited(arguments);
},startup:function(){
if(this._started){
return;
}
array.forEach(this.getChildren(),this._setupChild,this);
this.inherited(arguments);
},_setupChild:function(child){
var _146a=child.region;
if(_146a){
this.inherited(arguments);
_144b.add(child.domNode,this.baseClass+"Pane");
var ltr=this.isLeftToRight();
if(_146a=="leading"){
_146a=ltr?"left":"right";
}
if(_146a=="trailing"){
_146a=ltr?"right":"left";
}
if(_146a!="center"&&(child.splitter||this.gutters)&&!child._splitterWidget){
var _146b=child.splitter?this._splitterClass:_1468;
if(lang.isString(_146b)){
_146b=lang.getObject(_146b);
}
var _146c=new _146b({id:child.id+"_splitter",container:this,child:child,region:_146a,live:this.liveSplitters});
_146c.isSplitter=true;
child._splitterWidget=_146c;
_144c.place(_146c.domNode,child.domNode,"after");
_146c.startup();
}
child.region=_146a;
}
},layout:function(){
this._layoutChildren();
},addChild:function(child,_146d){
this.inherited(arguments);
if(this._started){
this.layout();
}
},removeChild:function(child){
var _146e=child.region;
var _146f=child._splitterWidget;
if(_146f){
_146f.destroy();
delete child._splitterWidget;
}
this.inherited(arguments);
if(this._started){
this._layoutChildren();
}
_144b.remove(child.domNode,this.baseClass+"Pane");
_144e.set(child.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});
_144e.set(child.domNode,_146e=="top"||_146e=="bottom"?"width":"height","auto");
},getChildren:function(){
return array.filter(this.inherited(arguments),function(_1470){
return !_1470.isSplitter;
});
},getSplitter:function(_1471){
return array.filter(this.getChildren(),function(child){
return child.region==_1471;
})[0]._splitterWidget;
},resize:function(_1472,_1473){
if(!this.cs||!this.pe){
var node=this.domNode;
this.cs=_144e.getComputedStyle(node);
this.pe=_144d.getPadExtents(node,this.cs);
this.pe.r=_144e.toPixelValue(node,this.cs.paddingRight);
this.pe.b=_144e.toPixelValue(node,this.cs.paddingBottom);
_144e.set(node,"padding","0px");
}
this.inherited(arguments);
},_layoutChildren:function(_1474,_1475){
if(!this._borderBox||!this._borderBox.h){
return;
}
var _1476=array.map(this.getChildren(),function(child,idx){
return {pane:child,weight:[child.region=="center"?Infinity:0,child.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(child.region)?1:-1),idx]};
},this);
_1476.sort(function(a,b){
var aw=a.weight,bw=b.weight;
for(var i=0;i<aw.length;i++){
if(aw[i]!=bw[i]){
return aw[i]-bw[i];
}
}
return 0;
});
var _1477=[];
array.forEach(_1476,function(_1478){
var pane=_1478.pane;
_1477.push(pane);
if(pane._splitterWidget){
_1477.push(pane._splitterWidget);
}
});
var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};
_1453.layoutChildren(this.domNode,dim,_1477,_1474,_1475);
},destroyRecursive:function(){
array.forEach(this.getChildren(),function(child){
var _1479=child._splitterWidget;
if(_1479){
_1479.destroy();
}
delete child._splitterWidget;
});
this.inherited(arguments);
}});
_1469.ChildWidgetProperties={region:"",layoutPriority:0,splitter:false,minSize:0,maxSize:Infinity};
lang.extend(_144f,_1469.ChildWidgetProperties);
_1469._Splitter=_1454;
_1469._Gutter=_1468;
return _1469;
});
},"dojo/dnd/Mover":function(){
define("dojo/dnd/Mover",["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(array,_147a,event,lang,has,win,dom,_147b,_147c,_147d,on,touch,dnd,_147e){
return _147a("dojo.dnd.Mover",[_147d],{constructor:function(node,e,host){
this.node=dom.byId(node);
this.marginBox={l:e.pageX,t:e.pageY};
this.mouseButton=e.button;
var h=(this.host=host),d=node.ownerDocument;
this.events=[on(d,touch.move,lang.hitch(this,"onFirstMove")),on(d,touch.move,lang.hitch(this,"onMouseMove")),on(d,touch.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",event.stop),on(d.body,"selectstart",event.stop)];
_147e.autoScrollStart(d);
if(h&&h.onMoveStart){
h.onMoveStart(this);
}
},onMouseMove:function(e){
_147e.autoScroll(e);
var m=this.marginBox;
this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);
event.stop(e);
},onMouseUp:function(e){
if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){
this.destroy();
}
event.stop(e);
},onFirstMove:function(e){
var s=this.node.style,l,t,h=this.host;
switch(s.position){
case "relative":
case "absolute":
l=Math.round(parseFloat(s.left))||0;
t=Math.round(parseFloat(s.top))||0;
break;
default:
s.position="absolute";
var m=_147b.getMarginBox(this.node);
var b=win.doc.body;
var bs=_147c.getComputedStyle(b);
var bm=_147b.getMarginBox(b,bs);
var bc=_147b.getContentBox(b,bs);
l=m.l-(bc.l-bm.l);
t=m.t-(bc.t-bm.t);
break;
}
this.marginBox.l=l-this.marginBox.l;
this.marginBox.t=t-this.marginBox.t;
if(h&&h.onFirstMove){
h.onFirstMove(this,e);
}
this.events.shift().remove();
},destroy:function(){
array.forEach(this.events,function(_147f){
_147f.remove();
});
var h=this.host;
if(h&&h.onMoveStop){
h.onMoveStop(this);
}
this.events=this.node=this.host=null;
}});
});
},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" role=\"presentation\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" role=\"presentation\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","davinci/ve/actions/AddState":function(){
define("davinci/ve/actions/AddState",["dojo/_base/declare","davinci/Runtime","davinci/Workbench","davinci/workbench/Preferences","davinci/ve/States","davinci/actions/Action","dojo/i18n!davinci/ve/nls/ve","davinci/ve/actions/_AddManageStatesWidget"],function(_1480,_1481,_1482,_1483,_1484,_1485,veNls,_1486){
return _1480("davinci.ve.actions.AddState",[_1485],{run:function(){
var _1487;
if(_1481.currentEditor&&_1481.currentEditor.currentEditor&&_1481.currentEditor.currentEditor.context){
_1487=_1481.currentEditor.currentEditor.context;
}else{
return;
}
var _1488=_1484.getFocus(_1487.rootNode);
if(!_1488||!_1488.stateContainerNode){
return;
}
var w=new davinci.ve.actions._AddManageStatesWidget({node:_1488.stateContainerNode});
w._calledBy="AddState";
_1482.showModal(w,veNls.createNewState,null,null,true);
w.okButton.set("disabled",true);
}});
});
},"davinci/js/JSModel":function(){
define("davinci/js/JSModel",["dojo/_base/declare","davinci/model/Model"],function(_1489,Model){
if(!davinci.js){
davinci.js={};
}
return _1489("davinci.js.JSModel",Model,{});
});
},"davinci/ui/widgets/AddFiles":function(){
require({cache:{"url:davinci/ui/widgets/templates/AddFiles.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<label for=\"fileDialogParentFolder\">${uiNLS.parentFolder}</label>\n\t\t<div data-dojo-attach-point=\"fileDialogParentFolder\"></div>\n\t\t<div style=\"margin: 1em 0 1em 0\">\n\t\t\t<input data-dojo-attach-point=\"uploader\" multiple=\"true\" type=\"file\" data-dojo-type=\"dojox.form.Uploader\"/>\n\t\t</div>\n\t\t<div data-dojo-attach-point=\"filelist\"></div>\n\t\t<div data-dojo-attach-point=\"zipWarning\" style=\"display:none; margin-top: 1em; background:yellow\">${uiNLS.explodeZipWarning}</div>\n\t</div>\n\n  <div class=\"dijitDialogPaneActionBar\">\n  \t<button data-dojo-attach-point=\"uploadBtn\" data-dojo-type=\"dijit/form/Button\" class=\"maqPrimaryButton\">${uiNLS.upload}</button>\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-event='onClick:_cancelButton' class=\"maqSecondaryButton\">${uiNLS.cancelButtonLabel}</button>\n\t</div>\n</div>\n"}});
define("davinci/ui/widgets/AddFiles",["dojo/_base/declare","dijit/_TemplatedMixin","dijit/_WidgetBase","dijit/_WidgetsInTemplateMixin","../../model/Path","system/resource","dojox/form/uploader/FileList","dojox/form/Uploader","dojo/i18n!../nls/ui","dojo/text!./templates/AddFiles.html","dijit/form/Button"],function(_148a,_148b,_148c,_148d,Path,_148e,_148f,_1490,uiNLS,_1491){
return _148a([_148c,_148b,_148d],{templateString:_1491,uiNLS:uiNLS,_getCommand:function(_1492){
return "cmd/addFiles?path="+encodeURIComponent(_1492.getPath());
},postCreate:function(){
var _1493=_148e.getRoot();
if(this.selectedResource){
_1493=this.selectedResource.elementType=="Folder"?this.selectedResource:this.selectedResource.parent;
}
this.fileDialogParentFolder.innerHTML=_1493.getPath();
this.uploader.set("url",this._getCommand(_1493));
new _148f({uploader:this.uploader},this.filelist);
var _1494,_1495=this.uploadBtn;
_1495.set("disabled",true);
var _1496=this.uploader;
dojo.connect(this.uploader,"onChange",function(files){
if(_1494){
dojo.disconnect(_1494);
}
_1494=dojo.connect(_1495,"onClick",null,function(){
_1496.set("disabled",true);
_1496.upload();
});
if(_1495.oldText){
_1495.containerNode.innerText=_1495.oldText;
}
_1495.set("disabled",!files.length);
});
var _1497=function(){
_1496.set("disabled",false);
dojo.disconnect(_1494);
_1495.oldText=_1495.containerNode.innerText;
_1495.containerNode.innerText=uiNLS.done;
_1495.set("disabled",true);
};
dojo.connect(this.uploader,"onComplete",function(_1498){
_1498.forEach(function(data){
var _1499=new Path(_1493.getPath());
_1493._appendFiles([{isDir:false,isLib:false,isNew:false,name:data.file}]);
_1499.append(data.file);
_148e.resourceChanged("updated",_1499.toString());
});
_1497();
});
dojo.connect(this.uploader,"onError",function(args){
alert("Upload error: "+args);
console.error("Upload error: ",args);
_1497();
});
},_cancelButton:function(){
this.onClose();
}});
});
},"davinci/html/CSSSelector":function(){
define("davinci/html/CSSSelector",["require","dojo/_base/declare","davinci/html/CSSElement"],function(_149a,_149b,_149c){
var _149d=_149b("davinci.html.CSSSelector",_149c,{constructor:function(){
this.elementType="CSSSelector";
},matchesSelector:function(_149e){
if(_149e.elementType==this.elementType&&this.id==_149e.id&&this.cls==_149e.cls&&this.element==_149e.element&&this.pseudoRule==_149e.pseudoRule){
return true;
}
},getText:function(_149f){
var s="";
if(this.element){
s=s+this.element;
}
if(this.id){
s=s+"#"+this.id;
}
if(this.cls){
s=s+"."+this.cls;
}
if(this.pseudoRule){
s=s+":"+this.pseudoRule;
}
if(this.pseudoElement){
s=s+"::"+this.pseudoElement;
}
if(this.attribute){
s=s+"["+this.attribute.name;
if(this.attribute.type){
s=s+this.attribute.type+"\""+this.attribute.value+"\"";
}
s=s+"]";
}
return s;
},matches:function(_14a0,index){
var inx=index||0;
var node=_14a0[inx];
var _14a1=0;
var _14a2=false;
if(this.id){
if(this.id!=node.id){
return -1;
}
_14a1+=100;
_14a2=true;
}
if(this.element){
if(this.element=="*"){
_14a2=true;
}else{
if(this.element!=node.tagName){
if(this.element.toUpperCase()!=node.tagName){
return -1;
}
}
_14a1+=1;
_14a2=true;
}
}
if(this.cls&&node.classes){
var _14a3=node.classes;
if(this.cls.indexOf(".")>=0){
var _14a4=this.cls.split(".");
for(var j=0;j<_14a4.length;j++){
var found=false;
for(var i=0;i<_14a3.length;i++){
if(found=(_14a3[i]==_14a4[j])){
break;
}
}
if(!found){
return -1;
}
}
_14a1+=(_14a4.length*10);
_14a2=true;
}else{
var found=false;
for(var i=0;i<_14a3.length;i++){
if(found=((_14a3[i]==this.cls)&&(!this.pseudoRule))){
break;
}
}
if(!found){
return -1;
}
_14a1+=10;
_14a2=true;
}
}
if(!_14a2){
return -1;
}else{
return _14a1;
}
},getCSSRule:function(){
if(this.parent.elementType=="CSSRule"){
return this.parent;
}
return this.parent.parent;
}});
_149d.parseSelectors=function(_14a5){
if(typeof _14a5=="string"){
_14a5=_14a5+"{}";
var _14a6=_149a("davinci/html/CSSFile");
var _14a7=new _14a6();
_14a7.setText(_14a5);
return _14a7.children[0].selectors;
}else{
return _14a5;
}
};
return _149d;
});
},"davinci/ui/OpenThemeDialog":function(){
require({cache:{"url:davinci/ui/templates/OpenThemeDialog.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t${selectTheme}: <div dojoType=\"davinci.ui.widgets.ThemeSelection\" dojoAttachPoint=\"_themeChooser\" value='claro' dojoAttachEvent='onChange:_checkValid' searchWorkspace='true'></div>\n\t</div>\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='${open}' class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>"}});
define("davinci/ui/OpenThemeDialog",["dojo/_base/declare","dijit/_Templated","dijit/_Widget","dojo/i18n!davinci/ui/nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/OpenThemeDialog.html","davinci/ui/widgets/ThemeSelection"],function(_14a8,_14a9,_14aa,uiNLS,_14ab,_14ac){
return _14a8("davinci.ui.OpenThemeDialog",[_14aa,_14a9],{templateString:_14ac,widgetsInTemplate:true,_themeChooser:null,startup:function(){
var _14ad=uiNLS;
this.inherited(arguments);
var value=this._themeChooser.get("numberOfThemes");
if(value<1){
alert(_14ad.noUserThemes);
setTimeout(dojo.hitch(this,function(){
this.destroyRecursive();
this.cancel=true;
this.onClose();
},500));
}
},postMixInProperties:function(){
var _14ae=uiNLS;
var _14af=_14ab;
dojo.mixin(this,_14ae);
dojo.mixin(this,_14af);
this.inherited(arguments);
},_checkValid:function(){
var isOk=true;
var _14b0=this._themeChooser.attr("value");
if(_14b0==null||_14b0==""){
isOk=false;
}
this._okButton.set("disabled",!isOk);
},okButton:function(){
var _14b1=this._themeChooser.attr("value");
davinci.Workbench.openEditor({fileName:_14b1.getFile(),content:_14b1});
},cancelButton:function(){
this.cancel=true;
this.onClose();
}});
});
},"dijit/form/ComboBoxMixin":function(){
require({cache:{"url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode, _popupStateNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\" aria-haspopup=\"true\"\n\t/></div\n></div>\n"}});
define("dijit/form/ComboBoxMixin",["dojo/_base/declare","dojo/_base/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_14b2,_14b3,_14b4,lang,_14b5,_14b6,_14b7,_14b8,_14b9){
return _14b2("dijit.form.ComboBoxMixin",[_14b8,_14b6],{dropDownClass:_14b7,hasDownArrow:true,templateString:_14b9,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){
this._set("hasDownArrow",val);
this._buttonNode.style.display=val?"":"none";
},_showResultList:function(){
this.displayMessage("");
this.inherited(arguments);
},_setStoreAttr:function(store){
if(!store.get){
lang.mixin(store,{_oldAPI:true,get:function(id){
var _14ba=new _14b3();
this.fetchItemByIdentity({identity:id,onItem:function(_14bb){
_14ba.resolve(_14bb);
},onError:function(error){
_14ba.reject(error);
}});
return _14ba.promise;
},query:function(query,_14bc){
var _14bd=new _14b3(function(){
_14be.abort&&_14be.abort();
});
_14bd.total=new _14b3();
var _14be=this.fetch(lang.mixin({query:query,onBegin:function(count){
_14bd.total.resolve(count);
},onComplete:function(_14bf){
_14bd.resolve(_14bf);
},onError:function(error){
_14bd.reject(error);
}},_14bc));
return _14b5(_14bd);
}});
}
this._set("store",store);
},postMixInProperties:function(){
var store=this.params.store||this.store;
if(store){
this._setStoreAttr(store);
}
this.inherited(arguments);
if(!this.params.store&&!this.store._oldAPI){
var clazz=this.declaredClass;
lang.mixin(this.store,{getValue:function(item,attr){
_14b4.deprecated(clazz+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");
return item[attr];
},getLabel:function(item){
_14b4.deprecated(clazz+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");
return item.name;
},fetch:function(args){
_14b4.deprecated(clazz+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");
var shim=["dojo/data/ObjectStore"];
require(shim,lang.hitch(this,function(_14c0){
new _14c0({objectStore:this}).fetch(args);
}));
}});
}
}});
});
},"dijit/form/Select":function(){
require({cache:{"url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,_popupStateNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n"}});
define("dijit/form/Select",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/_base/event","dojo/i18n","dojo/_base/lang","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../Menu","../MenuItem","../MenuSeparator","../Tooltip","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(array,_14c1,_14c2,_14c3,_14c4,event,i18n,lang,has,_14c5,_14c6,Menu,_14c7,_14c8,_14c9,_14ca){
var _14cb=_14c1("dijit.form._SelectMenu",Menu,{autoFocus:true,buildRendering:function(){
this.inherited(arguments);
var o=(this.menuTableNode=this.domNode);
var n=(this.domNode=this.ownerDocument.createElement("div"));
n.style.cssText="overflow-x: hidden; overflow-y: scroll";
if(o.parentNode){
o.parentNode.replaceChild(n,o);
}
_14c3.remove(o,"dijitMenuTable");
n.className=o.className+" dijitSelectMenu";
o.className="dijitReset dijitMenuTable";
o.setAttribute("role","listbox");
n.setAttribute("role","presentation");
n.appendChild(o);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onselectstart",event.stop);
},focus:function(){
var found=false,val=this.parentWidget.value;
if(lang.isArray(val)){
val=val[val.length-1];
}
if(val){
array.forEach(this.parentWidget._getChildren(),function(child){
if(child.option&&(val===child.option.value)){
found=true;
this.focusChild(child,false);
}
},this);
}
if(!found){
this.inherited(arguments);
}
},resize:function(mb){
if(mb){
_14c4.setMarginBox(this.domNode,mb);
if("w" in mb){
this.menuTableNode.style.width="100%";
}
}
}});
var _14cc=_14c1("dijit.form.Select",[_14c5,_14c6],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_14ca,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,_fillContent:function(){
this.inherited(arguments);
if(this.options.length&&!this.value&&this.srcNodeRef){
var si=this.srcNodeRef.selectedIndex||0;
this.value=this.options[si>=0?si:0].value;
}
this.dropDown=new _14cb({id:this.id+"_menu",parentWidget:this});
_14c3.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));
},_getMenuItemForOption:function(_14cd){
if(!_14cd.value&&!_14cd.label){
return new _14c8({ownerDocument:this.ownerDocument});
}else{
var click=lang.hitch(this,"_setValueAttr",_14cd);
var item=new _14c7({option:_14cd,label:_14cd.label||this.emptyLabel,onClick:click,ownerDocument:this.ownerDocument,dir:this.dir,disabled:_14cd.disabled||false});
item.focusNode.setAttribute("role","option");
return item;
}
},_addOptionItem:function(_14ce){
if(this.dropDown){
this.dropDown.addChild(this._getMenuItemForOption(_14ce));
}
},_getChildren:function(){
if(!this.dropDown){
return [];
}
return this.dropDown.getChildren();
},_loadChildren:function(_14cf){
if(_14cf===true){
if(this.dropDown){
delete this.dropDown.focusedChild;
}
if(this.options.length){
this.inherited(arguments);
}else{
array.forEach(this._getChildren(),function(child){
child.destroyRecursive();
});
var item=new _14c7({ownerDocument:this.ownerDocument,label:this.emptyLabel});
this.dropDown.addChild(item);
}
}else{
this._updateSelection();
}
this._isLoaded=false;
this._childrenLoaded=true;
if(!this._loadingStore){
this._setValueAttr(this.value,false);
}
},_refreshState:function(){
if(this._started){
this.validate(this.focused);
}
},startup:function(){
this.inherited(arguments);
this._refreshState();
},_setValueAttr:function(value){
this.inherited(arguments);
_14c2.set(this.valueNode,"value",this.get("value"));
this._refreshState();
},_setDisabledAttr:function(value){
this.inherited(arguments);
this._refreshState();
},_setRequiredAttr:function(value){
this._set("required",value);
this.focusNode.setAttribute("aria-required",value);
this._refreshState();
},_setOptionsAttr:function(_14d0){
this._isLoaded=false;
this._set("options",_14d0);
},_setDisplay:function(_14d1){
var lbl=_14d1||this.emptyLabel;
this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";
},validate:function(_14d2){
var _14d3=this.disabled||this.isValid(_14d2);
this._set("state",_14d3?"":(this._hasBeenBlurred?"Error":"Incomplete"));
this.focusNode.setAttribute("aria-invalid",_14d3?"false":"true");
var _14d4=_14d3?"":this._missingMsg;
if(_14d4&&this.focused&&this._hasBeenBlurred){
_14c9.show(_14d4,this.domNode,this.tooltipPosition,!this.isLeftToRight());
}else{
_14c9.hide(this.domNode);
}
this._set("message",_14d4);
return _14d3;
},isValid:function(){
return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));
},reset:function(){
this.inherited(arguments);
_14c9.hide(this.domNode);
this._refreshState();
},postMixInProperties:function(){
this.inherited(arguments);
this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onselectstart",event.stop);
this.domNode.setAttribute("aria-expanded","false");
if(has("ie")<9){
this.defer(function(){
try{
var s=domStyle.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _14d5=this.domNode.getElementsByTagName("INPUT");
if(_14d5){
for(var i=0;i<_14d5.length;i++){
_14d5[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_setStyleAttr:function(value){
this.inherited(arguments);
_14c3.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);
},isLoaded:function(){
return this._isLoaded;
},loadDropDown:function(_14d6){
this._loadChildren(true);
this._isLoaded=true;
_14d6();
},closeDropDown:function(){
this.inherited(arguments);
if(this.dropDown&&this.dropDown.menuTableNode){
this.dropDown.menuTableNode.style.width="";
}
},destroy:function(_14d7){
if(this.dropDown&&!this.dropDown._destroyed){
this.dropDown.destroyRecursive(_14d7);
delete this.dropDown;
}
this.inherited(arguments);
},_onFocus:function(){
this.validate(true);
this.inherited(arguments);
},_onBlur:function(){
_14c9.hide(this.domNode);
this.inherited(arguments);
this.validate(false);
}});
_14cc._Menu=_14cb;
return _14cc;
});
},"davinci/ve/Snap":function(){
define("davinci/ve/Snap",["davinci/ve/utils/GeomUtils"],function(_14d8){
dojo.getObject("davinci.ve.Snap",true);
return davinci.ve.Snap={updateSnapLinesBeforeTraversal:function(_14d9,rect){
_14d9._snapX=null;
_14d9._snapY=null;
if(_14d9._lastSnapBox){
if(_14d9._lastSnapBox.l==rect.l&&_14d9._lastSnapBox.t==rect.t&&_14d9._lastSnapBox.w==rect.w&&_14d9._lastSnapBox.h==rect.h){
return false;
}
}
snapBox={l:rect.l,t:rect.t,w:rect.w,h:rect.h,c:rect.l+rect.w/2,r:rect.l+rect.w,m:rect.t+rect.h/2,b:rect.t+rect.h};
_14d9._lastSnapBox=snapBox;
return true;
},findSnapOpportunities:function(_14da,_14db,_14dc,_14dd,_14de){
var _14df=75;
var _14e0=_14da._lastSnapBox;
var node=_14db.domNode;
if(node.tagName=="BODY"){
return;
}
var _14e1=null;
var _14e2=_14db.getHelper();
if(_14e2&&_14e2.getMarginBoxPageCoords){
_14e1=_14e2.getMarginBoxPageCoords(_14db);
}else{
_14e1=_14d8.getMarginBoxPageCoordsCached(node);
}
_14e1.x=_14e1.l;
_14e1.y=_14e1.t;
var _14e3=5;
var _14e4=_14da._snapX?_14da._snapX.delta:_14e3+1;
var _14e5=_14da._snapY?_14da._snapY.delta:_14e3+1;
var _14e6={snapRect:{l:_14e1.x,c:_14e1.x+(_14e1.w/2),r:_14e1.x+_14e1.w,t:_14e1.y,m:_14e1.y+(_14e1.h/2),b:_14e1.y+_14e1.h}};
if(_14e2&&_14e2.getSnapInfo){
_14e6=_14e2.getSnapInfo(_14db,_14e6);
}
function snapX(_14e7,_14e8,x,delta){
if(delta<_14e4){
_14da._snapX={type:_14e7,typeRefObj:_14e7,typeCurrObj:_14e8,x:x,widget:_14db,delta:delta};
_14e4=delta;
_14da._snapXLast=_14da._snapX;
}
};
function snapY(_14e9,_14ea,y,delta){
if(delta<_14e5){
_14da._snapY={type:_14e9,typeRefObj:_14e9,typeCurrObj:_14ea,y:y,widget:_14db,delta:delta};
_14e5=delta;
_14da._snapYLast=_14da._snapY;
}
};
var rect=_14e6.snapRect;
var _14eb,_14ec,_14ed,_14ee,_14ef,_14f0,delta;
if(rect){
if(_14dd){
var _14f1=(_14da._snapXLast&&_14da._snapXLast.widget===_14db)?Infinity:_14df;
var _14f2=Math.abs(rect.t-_14e0.t);
var _14f3=Math.abs(rect.t-_14e0.b);
var _14f4=Math.abs(rect.b-_14e0.t);
var _14f5=Math.abs(rect.b-_14e0.b);
if(_14f2<=_14f1||_14f3<=_14f1||_14f4<=_14f1||_14f5<=_14f1){
_14eb=Math.abs(rect.l-_14e0.l);
_14ec=Math.abs(rect.c-_14e0.c);
_14ed=Math.abs(rect.r-_14e0.r);
snapX("left","left",rect.l,_14eb);
snapX("center","center",rect.c,_14ec);
snapX("right","right",rect.r,_14ed);
snapX("left","center",rect.c,Math.abs(rect.c-_14e0.l));
snapX("left","right",rect.r,Math.abs(rect.r-_14e0.l));
snapX("right","left",rect.l,Math.abs(rect.l-_14e0.r));
snapX("right","center",rect.c,Math.abs(rect.c-_14e0.r));
snapX("center","left",rect.l,Math.abs(rect.l-_14e0.c));
snapX("center","right",rect.r,Math.abs(rect.r-_14e0.c));
}
}
if(_14de){
var _14f6=(_14da._snapYLast&&_14da._snapYLast.widget===_14db)?Infinity:_14df;
var _14f7=Math.abs(rect.l-_14e0.l);
var _14f8=Math.abs(rect.l-_14e0.r);
var _14f9=Math.abs(rect.r-_14e0.l);
var _14fa=Math.abs(rect.r-_14e0.r);
if(_14f7<=_14f6||_14f8<=_14f6||_14f9<=_14f6||_14fa<=_14f6){
_14ee=Math.abs(rect.t-_14e0.t);
_14ef=Math.abs(rect.m-_14e0.m);
_14f0=Math.abs(rect.b-_14e0.b);
snapY("top","top",rect.t,_14ee);
snapY("middle","middle",rect.m,_14ef);
snapY("bottom","bottom",rect.b,_14f0);
snapY("top","middle",rect.m,Math.abs(rect.m-_14e0.t));
snapY("top","bottom",rect.b,Math.abs(rect.b-_14e0.t));
snapY("bottom","top",rect.t,Math.abs(rect.t-_14e0.b));
snapY("bottom","middle",rect.m,Math.abs(rect.m-_14e0.b));
snapY("middle","top",rect.t,Math.abs(rect.t-_14e0.m));
snapY("middle","bottom",rect.b,Math.abs(rect.b-_14e0.m));
}
}
}
var _14fb=_14e6.snapPoints;
if(_14fb){
for(var i=0;i<_14fb.length;i++){
var p=_14fb[i];
_14eb=Math.abs(p.x-_14e0.l);
_14ec=Math.abs(p.x-_14e0.c);
_14ed=Math.abs(p.x-_14e0.r);
snapX("point",p.x,_14eb);
snapX("point",p.x,_14ec);
snapX("point",p.x,_14ed);
_14ee=Math.abs(p.y-_14e0.t);
_14ef=Math.abs(p.y-_14e0.m);
_14f0=Math.abs(p.y-_14e0.b);
snapY("point",p.y,_14ee);
snapY("point",p.y,_14ef);
snapY("point",p.y,_14f0);
}
}
},updateSnapLinesAfterTraversal:function(_14fc){
var _14fd=_14fc.getContainerNode();
if(!_14fc._snapLinesDiv){
_14fc._snapLinesDiv=dojo.create("div",{"class":"snaplines",style:"position:absolute;top:0px;left:0px;z-index:1000001;pointer-events:none;"},_14fd);
_14fc._snapLinesDivWidgetX=dojo.create("div",{"class":"snaplinesWidgetX",style:"position:absolute;pointer-events:none;"},_14fc._snapLinesDiv);
_14fc._snapLinesDivAlignX=dojo.create("div",{"class":"snaplinesAlignX",style:"position:absolute;pointer-events:none;"},_14fc._snapLinesDiv);
_14fc._snapLinesDivWidgetY=dojo.create("div",{"class":"snaplinesWidgetY",style:"position:absolute;pointer-events:none;"},_14fc._snapLinesDiv);
_14fc._snapLinesDivAlignY=dojo.create("div",{"class":"snaplinesAlignY",style:"position:absolute;pointer-events:none;"},_14fc._snapLinesDiv);
}
_14fc._snapLinesDiv.style.display="block";
var box;
function _14fe(_14ff,_1500,_1501,_1502){
_1501.style.display="block";
_1502.style.display="block";
var _1503=_1500.getHelper();
if(_1503&&_1503.getMarginBoxPageCoords){
box=_1503.getMarginBoxPageCoords(_1500);
}else{
box=_14d8.getMarginBoxPageCoordsCached(_1500.domNode);
}
box.x=box.l;
box.y=box.t;
box.r=box.x+box.w;
box.b=box.y+box.h;
box.c=box.x+box.w/2;
box.m=box.y+box.h/2;
_1501.style.left=box.x+"px";
_1501.style.top=box.y+"px";
_1501.style.width=box.w+"px";
_1501.style.height=box.h+"px";
_1501.style.backgroundColor="rgba(255,0,255,.05)";
};
var _1504=_14fc._snapLinesDivAlignX.style;
var _1505=_14fc._snapLinesDivWidgetX.style;
if(_14fc._snapX){
var snapX=_14fc._snapX;
_14fe(_14fc,snapX.widget,_14fc._snapLinesDivWidgetX,_14fc._snapLinesDivAlignX);
var t,h;
if(box.y<snapBox.t){
t=box.y;
h=snapBox.t-box.y;
}else{
t=snapBox.t;
h=box.y-snapBox.t;
}
if(snapX.typeCurrObj=="point"){
_1504.left=_14fc._snapX.x+"px";
}else{
if(snapX.typeCurrObj=="left"){
_1504.left=box.x+"px";
}else{
if(snapX.typeCurrObj=="center"){
_1504.left=box.c+"px";
}else{
_1504.left=box.r+"px";
}
}
}
_1504.top=t+"px";
_1504.width="1px";
_1504.height=h+"px";
_1504.backgroundColor="rgba(255,0,255,.75)";
}else{
_1504.display="none";
_1505.display="none";
}
var _1504=_14fc._snapLinesDivAlignY.style;
var _1505=_14fc._snapLinesDivWidgetY.style;
if(_14fc._snapY){
var snapY=_14fc._snapY;
_14fe(_14fc,snapY.widget,_14fc._snapLinesDivWidgetY,_14fc._snapLinesDivAlignY);
var l,w;
if(box.x<snapBox.l){
l=box.x;
w=snapBox.l-box.x;
}else{
l=snapBox.l;
w=box.x-snapBox.l;
}
if(snapY.type=="point"){
_1504.top=snapY.y+"px";
}else{
if(snapY.typeCurrObj=="top"){
_1504.top=box.y+"px";
}else{
if(snapY.typeCurrObj=="middle"){
_1504.top=box.m+"px";
}else{
_1504.top=box.b+"px";
}
}
}
_1504.left=l+"px";
_1504.height="1px";
_1504.width=w+"px";
_1504.backgroundColor="rgba(255,0,255,.75)";
}else{
_1504.display="none";
_1505.display="none";
}
},clearSnapLines:function(_1506){
if(_1506._snapLinesDiv){
_1506._snapLinesDiv.style.display="none";
}
_1506._snapX=_1506._snapY=null;
}};
});
},"dijit/Calendar":function(){
define("dijit/Calendar",["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/event","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(array,date,local,_1507,_1508,_1509,event,_150a,keys,lang,has,_150b,_150c,_150d,_150e,_150f){
var _1510=_1507("dijit.Calendar",[_150b,_150c,_150d],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(value){
_150a.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");
this.set("value",value);
},_createMonthWidget:function(){
return new _1510._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);
},postCreate:function(){
this.inherited(arguments);
this.connect(this.domNode,"onkeydown","_onKeyDown");
this.connect(this.dateRowsNode,"onmouseover","_onDayMouseOver");
this.connect(this.dateRowsNode,"onmouseout","_onDayMouseOut");
this.connect(this.dateRowsNode,"onmousedown","_onDayMouseDown");
this.connect(this.dateRowsNode,"onmouseup","_onDayMouseUp");
},_onMonthSelect:function(_1511){
var date=new this.dateClassObj(this.currentFocus);
date.setDate(1);
date.setMonth(_1511);
var _1512=this.dateModule.getDaysInMonth(date);
var _1513=this.currentFocus.getDate();
date.setDate(Math.min(_1513,_1512));
this._setCurrentFocusAttr(date);
},_onDayMouseOver:function(evt){
var node=_1509.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;
if(node&&((node.dijitDateValue&&!_1509.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){
_1509.add(node,"dijitCalendarHoveredDate");
this._currentNode=node;
}
},_onDayMouseOut:function(evt){
if(!this._currentNode){
return;
}
if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){
return;
}
var cls="dijitCalendarHoveredDate";
if(_1509.contains(this._currentNode,"dijitCalendarActiveDate")){
cls+=" dijitCalendarActiveDate";
}
_1509.remove(this._currentNode,cls);
this._currentNode=null;
},_onDayMouseDown:function(evt){
var node=evt.target.parentNode;
if(node&&node.dijitDateValue&&!_1509.contains(node,"dijitCalendarDisabledDate")){
_1509.add(node,"dijitCalendarActiveDate");
this._currentNode=node;
}
},_onDayMouseUp:function(evt){
var node=evt.target.parentNode;
if(node&&node.dijitDateValue){
_1509.remove(node,"dijitCalendarActiveDate");
}
},handleKey:function(evt){
var _1514=-1,_1515,_1516=this.currentFocus;
switch(evt.keyCode){
case keys.RIGHT_ARROW:
_1514=1;
case keys.LEFT_ARROW:
_1515="day";
if(!this.isLeftToRight()){
_1514*=-1;
}
break;
case keys.DOWN_ARROW:
_1514=1;
case keys.UP_ARROW:
_1515="week";
break;
case keys.PAGE_DOWN:
_1514=1;
case keys.PAGE_UP:
_1515=evt.ctrlKey||evt.altKey?"year":"month";
break;
case keys.END:
_1516=this.dateModule.add(_1516,"month",1);
_1515="day";
case keys.HOME:
_1516=new this.dateClassObj(_1516);
_1516.setDate(1);
break;
case keys.ENTER:
case keys.SPACE:
this.set("value",this.currentFocus);
break;
default:
return true;
}
if(_1515){
_1516=this.dateModule.add(_1516,_1515,_1514);
}
this._setCurrentFocusAttr(_1516);
return false;
},_onKeyDown:function(evt){
if(!this.handleKey(evt)){
event.stop(evt);
}
},onValueSelected:function(){
},onChange:function(value){
this.onValueSelected(value);
},getClassForDate:function(){
}});
_1510._MonthDropDownButton=_1507("dijit.Calendar._MonthDropDownButton",_150f,{onMonthSelect:function(){
},postCreate:function(){
this.inherited(arguments);
this.dropDown=new _1510._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});
},_setMonthAttr:function(month){
var _1517=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,month);
this.dropDown.set("months",_1517);
this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_1517[month.getMonth()]+"</div>";
}});
_1510._MonthDropDown=_1507("dijit.Calendar._MonthDropDown",[_150c,_150e],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_1518){
this.domNode.innerHTML=array.map(_1518,function(month,idx){
return month?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+month+"</div>":"";
}).join("");
},_onClick:function(evt){
this.onChange(_1508.get(evt.target,"month"));
},onChange:function(){
},_onMenuHover:function(evt){
_1509.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");
}});
return _1510;
});
},"davinci/ve/widgets/FontComboBox":function(){
define("davinci/ve/widgets/FontComboBox",["dojo/_base/declare","dijit/form/ComboBox","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common"],function(_1519,_151a){
return _1519("davinci.ve.widgets.FontComboBox",_151a,{_getValueAttr:function(){
if(this.store){
for(var i=0;i<this.store._allValues.length;i++){
var item=this.store._allValues[i];
if(item.name[0]==this.value){
return item.value[0];
}
}
}
return this.value;
},_setValueAttr:function(v){
if(this.store&&v){
this.store.fetch({query:{value:v},onComplete:function(items,_151b){
if(items.length<1){
this.inherited("_setValueAttr",[v]);
}else{
this.inherited("_setValueAttr",[items[0].name[0]]);
this.item=items[0];
}
}.bind(this),onError:function(){
this.inherited("_setValueAttr",[v]);
}.bind(this)});
}else{
this.inherited("_setValueAttr",[v]);
}
}});
});
},"url:davinci/ve/prefs/HtmlEditPreferences.html":"<div>\n\t<table style='margin: 4px;' cellspacing='4'>\n\t\t<tbody>\n\t\t\t<!--\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.flowLayout}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='flowBoxNode'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t-->\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.snapToNearestWidget}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='snapNode'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.showPossibleParents}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='showPossibleParentsNode'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.warnOnCSSOverride}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='cssOverrideWarn'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.absoluteWidgetsZindex}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='absoluteWidgetsZindex'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<!-- FIXME: Disabled for now. Ultimately, UI for this option should go to widget palette\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.widgetPaletteLayout}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='widgetPaletteLayout'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t-->\n\t\t\t<tr>\n\t\t\t\t<td>${_loc.zazl}:</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint='zazl'></div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>","davinci/actions/StickyNoteAction":function(){
define("davinci/actions/StickyNoteAction",["dojo/_base/declare","./Action","../Workbench","davinci/commands/CompoundCommand","../ve/commands/AddCommand","../ve/commands/MoveCommand","../ve/commands/ResizeCommand","../ve/tools/CreateTool","../ve/widget","../ve/metadata"],function(_151c,_151d,_151e,_151f,_1520,_1521,_1522,_1523,_1524,_1525){
return _151c("davinci.actions.StickyNoteAction",_151d,{run:function(_1526){
var e=_151e.getOpenEditor();
var _1527=davinci.ve.metadata.queryDescriptor("html.stickynote");
if(!_1527){
return;
}
var data=dojo.clone(_1527);
data.context=e.getContext();
if(e&&e.getContext){
var _1528=undefined;
dojo.withDoc(e.getContext().getDocument(),function(){
_1528=_1524.createWidget(data);
});
if(!_1528){
return;
}
var _1529=new _151f();
var doc=e.getContext().getDocument();
var _152a=doc.body;
var _152b=e.getContext().getContainerNode();
_1529.add(new _1520(_1528,e.getContext().getContainerNode()));
_1523.prototype.checkAddToCurrentState(_1529,_1528);
_1529.add(new _1521(_1528,50,50));
if(_1528.isLayoutContainer){
var w=args.size&&args.size.w,h=args.size&&args.size.h;
_1529.add(new _1522(_1528,w,h));
}
e.getContext().getCommandStack().execute(_1529);
_1525.getSmartInput(_1528.type).then(function(_152c){
if(_152c&&_152c.displayOnCreate){
e.getContext().select(_1528,null,true);
}else{
e.getContext().select(_1528);
}
}.bind(this));
}
},isEnabled:function(_152d){
var e=_151e.getOpenEditor();
return (e&&e.getContext);
}});
});
},"davinci/ve/commands/ModifyRuleCommand":function(){
define("davinci/ve/commands/ModifyRuleCommand",["dojo/_base/declare","../States","../../html/CSSModel",],function(_152e,_152f,_1530){
var _1531=function(rule,_1532){
rule.removeAllProperties();
_1532.forEach(function(value){
rule.addProperty(value.name,value.value);
});
};
var _1533=function(rule,_1534){
var i,p,prop,_1535=[],_1536=[];
for(i=0;i<_1534.length;i++){
for(var name in _1534[i]){
prop=rule.getProperty(name);
if(prop){
_1536.push(prop);
}
rule.removeProperty(name);
}
}
for(p=0;p<rule.properties.length;p++){
prop=rule.properties[p];
var o={};
o[prop.name]=prop.value;
_1535.push(o);
}
var _1537=_1535.concat(dojo.clone(_1534));
var _1538=function(value){
for(var i=0;i<_1537.length;i++){
if(_1537[i].hasOwnProperty(value)){
return i;
}
}
return -1;
};
var _1539=_1530.shorthand;
var _153a=0;
for(i=0;i<_1539.length;i++){
var index=_1538(_1539[i][0]);
if(index>-1){
var _153b=_1537[index];
_1537.splice(index,1);
_1537.splice(_153a,0,_153b);
_153a++;
}
}
for(p=rule.properties.length-1;p>=0;p--){
prop=rule.properties[p];
if(prop){
_1536.push(rule.getProperty(prop.name));
rule.removeProperty(prop.name);
}
}
for(i=0;i<_1537.length;i++){
for(var name in _1537[i]){
if(_1537[i][name]&&_1537[i][name]!==""){
rule.addProperty(name,_1537[i][name]);
for(var x=0;x<_1536.length;x++){
if(_1536[x].name===name){
var _153c=rule.getProperty(name,_1537[i][name]);
if(_1536[x].comment){
_153c.comment=_1536[x].comment;
}
if(_1536[x].postComment){
_153c.postComment=_1536[x].postComment;
}
_1536.splice(x,1);
break;
}
}
}
}
}
};
return _152e("davinci.ve.commands.ModifyRuleCommand",null,{name:"modify rule",constructor:function(_153d,_153e,_153f){
this.cssRule=_153d;
this.values=_153e;
this.context=_153f;
},execute:function(_1540){
if(!this.context){
this.context=_1540;
}
if(!this.cssRule||!this.values||!this.context){
return;
}
this._oldValues=this.cssRule.getProperties();
_1533(this.cssRule,this.values);
this._setDirty();
},undo:function(){
if(!this.cssRule||!this._oldValues||!this.context){
return;
}
_1531(this.cssRule,this._oldValues);
this._setDirty();
},_setDirty:function(){
var file=this.cssRule.getCSSFile();
file.setDirty(true);
this.context.editor.setDirty(true);
_152f.resetState(this.context.rootNode);
if(this.context._selection){
this.context._forceSelectionChange=true;
}
}});
});
},"davinci/review/widgets/PublishWizard":function(){
require({cache:{"url:davinci/review/widgets/templates/PublishWizard.html":"<div class='publishWizard'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div class='steps'>\n\t\t\t<div dojoAttachPoint=\"navPage1\" dojoAttachEvent=\"onclick:select\" class=\"crumbs current sep\">\n\t\t\t\t<div dojoAttachPoint=\"navPage1Icon\" class=\"done\"></div>\n\t\t\t\t1.${generalInfo}\n\t\t\t</div>\n\t\t\t<div dojoAttachPoint=\"navPage2\" dojoAttachEvent=\"onclick:select\" class=\"crumbs sep\">\n\t\t\t\t<div dojoAttachPoint=\"navPage2Icon\" class=\"todo\"></div>\n\t\t\t\t2.${selectRevFiles}\n\t\t\t</div>\n\t\t\t<div dojoAttachPoint=\"navPage3\" dojoAttachEvent=\"onclick:select\" class=\"crumbs\">\n\t\t\t\t<div dojoAttachPoint=\"navPage3Icon\" class=\"todo\"></div>\n\t\t\t\t3.${addReviewers}\n\t\t\t</div>\n\t\t</div>\n\t\t<div dojoAttachPoint=\"reviewerStackContainer\" class='mainSection'>\n\t\t</div>\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page1Node\">\n\t\t\t<tr>\n\t\t\t\t<td><label for=\"versionTitle\">${title}:</label></td>\n\t\t\t\t<td><input dojoAttachPoint=\"versionTitle\"></input></td>\n\t\t\t\t<td><input dojoAttachPoint=\"receiveEmail\"></input><label class='emailLabel' for=\"receiveEmail\">${notifyMe}</label></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td valign=\"top\"><label for=\"descriptions\">${description}:</label></td>\n\t\t\t\t<td colspan=\"2\"><input dojoAttachPoint=\"descriptions\"></input></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><label>${windowSize}:</label></td>\n\t\t\t\t<td colspan=\"2\"><input dojoAttachPoint=\"desireWidth\"></input><label>*</label><input dojoAttachPoint=\"desireHeight\"/></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><label for=\"dueDate\">${dueDate}:</label></td>\n\t\t\t\t<td><input dojoAttachPoint=\"dueDate\" /></td>\n\t\t\t\t<td class=\"review-tips\"><label>${leaveBlank}</label></td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page2Node\">\n\t\t\t<tr>\n\t\t\t\t<td>${availableFiles}:</td>\n\t\t\t\t<td></td>\n\t\t\t\t<td>${selectedFiles}:</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint=\"sourceTreeNode\" class='sourceTree'>\n\t\t\t\t\t\t\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<a href=\"javascript:void(0);\" dojoAttachEvent=\"onclick:addSelectFiles\"><img src=\"app/davinci/review/resources/img/forward_nav.gif\"/></a>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint=\"targetTreeNode\" class='sourceTree'>\n\t\t\t\t\t\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page3Node\">\n\t\t\t<tr valign=\"top\">\n\t\t\t\t<td align=\"left\" rowspan=2><div class='reviewers'>${reviewers}:</div></td>\n\t\t\t\t<td colspan=2><div dojoAttachPoint=\"userGrid\" class='reviewerList'></div></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td class='reviewerBox'>\n\t\t\t\t\t<div dojoAttachPoint=\"addReviewerCombox\"></div>\n\t\t\t\t</td>\n\t\t\t\t<td align=\"left\"><button dojoAttachPoint=\"addReviewerButton\"></button></td>\n\t\t\t</tr>\n\t\t</table>\n\t</div>\n\n\t\t<div class='dijitDialogPaneActionBar dialogButtonContainerOverride'>\n\t\t\t<div dojoAttachPoint=\"reviewMsg\" class=\"reviewMsg\"></div>\n\t\t\t<a class='cancelButton' href=\"javascript:void(0);\" dojoAttachEvent=\"onclick:onClose\">${buttonCancel}</a>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"saveDt\">${saveAsDraft}</button>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"prev\">&lt ${back}</button>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"next\">${next} &gt</button>\n\t\t\t<button class='maqPrimaryButton' dojoAttachPoint=\"invite\">${publishReview}</button>\n\t\t</div>\n</div>","url:davinci/review/widgets/templates/MailFailureDialogContent.html":"<div>\n<div class='mailFailureInfo'>${inviteNotSent}</div>\n<div class='mailFailureExtraInfo'>${mailFailureMsg}</div>\n<div class='mailFailureContent'>${htmlContent}</div>\n</div>\n"}});
define("davinci/review/widgets/PublishWizard",["dojo/_base/declare","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","dijit/layout/StackContainer","dijit/layout/ContentPane","dijit/form/SimpleTextarea","dijit/form/NumberTextBox","dijit/form/ValidationTextBox","dijit/form/DateTextBox","dijit/form/Button","dijit/form/ComboBox","dojo/data/ItemFileWriteStore","dijit/form/CheckBox","dojox/grid/DataGrid","dojox/data/QueryReadStore","dojox/widget/Toaster","dojox/validate/regexp","dojo/_base/xhr","dojo/string","dojo/fx","dojo/date/stamp","dijit/Tree","dojo/Deferred","dojo/promise/all","system/resource","davinci/Runtime","davinci/Workbench","davinci/model/resource/Folder","davinci/model/resource/File","davinci/review/model/resource/Empty","davinci/review/model/resource/root","dijit/tree/TreeStoreModel","davinci/review/model/store/GeneralReviewReadStore","dojo/i18n!./nls/widgets","dojo/i18n!dijit/nls/common","dojo/text!./templates/PublishWizard.html","dojo/text!./templates/MailFailureDialogContent.html"],function(_1541,_1542,_1543,_1544,_1545,_1546,_1547,_1548,_1549,_154a,_154b,_154c,_154d,_154e,_154f,_1550,_1551,_1552,xhr,_1553,_1554,stamp,Tree,_1555,all,_1556,_1557,_1558,_1559,File,Empty,_155a,_155b,_155c,_155d,_155e,_155f,_1560){
var _1561=_1541(dijit._TreeNode,{postCreate:function(){
this.inherited(arguments);
var _1562=dojo.create("img",{src:"app/dojo/resources/blank.gif","class":"deleteImg"});
dojo.connect(_1562,"onclick",this,dojo.hitch(this,function(){
dojo.publish("/davinci/review/deleteReviewFile",[this.item]);
}));
dojo.place(_1562,this.rowNode,"first");
dojo.style(this.rowNode,{width:"99%"});
dojo.style(this.containerNode,{display:"block"});
}});
var _1563=_1541(Tree,{_createTreeNode:function(args){
return new _1561(args);
}});
return _1541("davinci.review.widgets.PublishWizard",[_1542,_1543],{templateString:_155f,postMixInProperties:function(){
this.inherited(arguments);
dojo.mixin(this,_155d);
dojo.mixin(this,_155e);
},postCreate:function(){
var sc=this.reviewerStackContainer=new _1545({},this.reviewerStackContainer);
var page1=this.page1=new _1546({style:"overflow:hidden;"});
var page2=this.page2=new _1546({style:"overflow:hidden;"});
var page3=this.page3=new _1546({style:"overflow:hidden;"});
this.reviewerStackContainer.addChild(page1);
this.reviewerStackContainer.addChild(page2);
this.reviewerStackContainer.addChild(page3);
this._initPage1();
this._initPage2();
this._initPage3();
this._initButtons();
dojo.place(this.page1Node,page1.domNode);
dojo.place(this.page2Node,page2.domNode);
dojo.place(this.page3Node,page3.domNode);
sc.startup();
this._subs=[dojo.subscribe(sc.id+"-selectChild",dojo.hitch(this,this._onPageSelected)),dojo.subscribe("/davinci/review/publish/valueChanged",dojo.hitch(this,this.updateSubmit)),dojo.subscribe("/davinci/review/deleteReviewFile",dojo.hitch(this,this.delFiles)),dojo.subscribe("/davinci/review/deleteReviewer",dojo.hitch(this,this.delRow))];
},_initPage1:function(){
this.versionTitle=new _1549({onChange:this._onValueChange,required:true},this.versionTitle);
this.receiveEmail=new _154e({checked:true},this.receiveEmail);
this.descriptions=new _1547({style:"width:460px;height:100px;font-family:Verdana, Arial, Helvetica, sans-serif;font-size:100%;"},this.descriptions);
this.desireWidth=new _1548({constraints:{min:0,places:0},value:1024,style:"width:85px"},this.desireWidth);
this.desireHeight=new _1548({constraints:{min:0,places:0},value:768,style:"width:85px"},this.desireHeight);
var _1564=new Date();
this.dueDate=new _154a({onChange:this._onValueChange,type:"text",constraints:{min:new Date(_1564.getFullYear(),_1564.getMonth(),_1564.getDate())}},this.dueDate);
},_initPage2:function(){
var _1565=[];
var _1566=this.fileIndex=1;
this.reviewFiles=_1565;
var _1567=this.sourceTreeModel=new _155b({deferItemLoadingUntilExpand:true,store:new _155c({root:new _1559(_1558.getProject(),null),getLabel:function(item){
var label=item.getName();
if(item.link){
label=label+"  ["+item.link+"]";
}
return label;
}})});
var _1568=function(item){
this.addFiles([item]);
};
var _1569=this.sourceTree=new Tree({id:"reviewWizardSourceTree",persist:false,showRoot:false,model:_1567,labelAttr:"name",getIconClass:dojo.hitch(this,this._getIconClass),isMultiSelect:true,onDblClick:dojo.hitch(this,_1568),transforms:[function(items){
return items.sort(function(a,b){
a=a.name.toLowerCase();
b=b.name.toLowerCase();
return a<b?-1:(a>b?1:0);
});
}]});
this.sourceTreeNode.appendChild(_1569.domNode);
_1569.startup();
var _156a=this.targetTreeModel=new _155b({store:new _155c({root:new Empty(),getLabel:function(item){
var label=item.getName();
if(item.link){
label=label+"  ["+item.link+"]";
}
return label;
}})});
var _156b=this.targetTree=new _1563({id:"reviewWizardTargetTree",showRoot:false,model:_156a,labelAttr:"name",getIconClass:dojo.hitch(this,this._getIconClass),isMultiSelect:true});
this.targetTreeNode.appendChild(_156b.domNode);
_156b.startup();
},_initPage3:function(){
var _156c=function(_156d){
if(!this.photoRepositoryUrl){
this.photoRepositoryUrl=_1557.serverJSONRequest({url:"cmd/getBluePageInfo",handleAs:"text",content:{"type":"photo"},sync:true,});
}
if(this.photoRepositoryUrl===""||this.photoRepositoryUrl=="not-implemented"){
this.photoRepositoryUrl="app/davinci/review/resources/img/profileNoPhoto.gif?";
}
return "<img src=\""+this.photoRepositoryUrl+_156d+"\" width=\"35px\" height=\"35px\" alt=\"User Photo\"></img>";
}.bind(this);
var _156e=function(_156f){
return "<a href=\"javascript:dojo.publish('/davinci/review/deleteReviewer',[])\"><img class=\"delImg\" src=\"app/davinci/review/resources/img/del.gif\"/></a>";
};
var _1570=[{cells:[{name:_155d.user,field:"email",formatter:_156c,width:"70px",styles:"text-align: center;"},{name:_155d.emailAddress,field:"displayName",width:"320px"},{name:_155d.action,field:"action",formatter:_156e,width:"70px",styles:"text-align: center;"}]}];
var _1571={identifier:"email",label:"name",items:[]};
this.userData=_1571.items;
var _1572=new _154d({data:_1571});
this.jsonStore=_1572;
var grid=new _154f({elasticView:"1",store:_1572,structure:_1570,style:"height:100%;width:100%;",canSort:function(index){
if(index==1){
return false;
}
return true;
},canResize:function(){
return false;
},delRow:function(e){
this.removeSelectedRows();
_1572.save();
}});
this.grid=grid;
this.userGrid.appendChild(grid.domNode);
grid.startup();
this.addReviewerButton=new _154b({disabled:true,onClick:dojo.hitch(this,this.addReviewer),label:"<div style='width:75px;height:10px;margin:-6px 0 0 0'>"+_155d.add+"</div>"},this.addReviewerButton);
var _1573=new _1550({url:"cmd/getBluePageInfo",fetch:function(_1574){
var _1575=_1574.query.displayName;
_1575=_1575.substring(0,_1575.length-1);
_1574.serverQuery={searchname:_1575};
return this.inherited("fetch",arguments);
}});
this.addReviewerCombox=new _154c({regExpGen:dojo.hitch(this,this._emailAddress),required:true,store:_1573,searchAttr:"displayName",name:"displayName",autoComplete:false,hasDownArrow:false,highlightMatch:"all",style:"width:220px",onChange:dojo.hitch(this,this._reviewerComboxValueChanged),onKeyUp:dojo.hitch(this,this._updateAddButton),pageSize:10,searchDelay:500,placeHolder:_155d.enterNameOrEmail},this.addReviewerCombox);
},_emailAddress:function(flags){
if(this.addReviewerCombox.item){
return ".*";
}
flags=(typeof flags=="object")?flags:{};
if(typeof flags.allowCruft!="boolean"){
flags.allowCruft=false;
}
flags.allowPort=false;
var _1576="([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";
var _1577=_1576+"@"+_1552.host(flags);
if(flags.allowCruft){
_1577="<?(mailto\\:)?"+_1577+">?";
}
return _1577;
},_initButtons:function(){
this.invite=new _154b({disabled:true,onClick:dojo.hitch(this,function(){
this.publish();
})},this.invite);
this.next=new _154b({onClick:dojo.hitch(this,function(){
this.reviewerStackContainer.forward();
})},this.next);
this.prev=new _154b({onClick:dojo.hitch(this,function(){
this.reviewerStackContainer.back();
})},this.prev);
this.saveDt=new _154b({onClick:dojo.hitch(this,function(){
this.publish(true);
})},this.saveDt);
},_reviewerComboxValueChanged:function(){
if(this.addReviewerCombox.item){
this.addReviewer();
}
},_updateAddButton:function(e){
var valid=this.addReviewerCombox.isValid();
this.addReviewerButton.set("disabled",!valid);
if(e.keyCode==13&&valid){
this.addReviewer();
}
},delRow:function(){
this.grid.delRow();
dojo.publish("/davinci/review/publish/valueChanged");
},addReviewer:function(){
var item=this.addReviewerCombox.item;
var _1578,email,name;
if(item){
_1578=this.addReviewerCombox.value.split(",").join("");
email=item.i.emailaddress;
name=item.i.name;
name=name.split(",").join("");
}else{
name=email=_1578=this.addReviewerCombox.get("value");
}
this.jsonStore.fetchItemByIdentity({identity:email,onItem:function(i){
item=i;
}});
var grid=this.grid;
if(item){
var index=grid.getItemIndex(item);
grid.scrollToRow(index);
var node=grid.getRowNode(index);
dojo.fx.chain([dojo.fadeOut({node:node,duration:300}),dojo.fadeIn({node:node,duration:700}),dojo.fadeOut({node:node,duration:300}),dojo.fadeIn({node:node,duration:700})]).play();
node.removeAttribute("style");
}else{
this.jsonStore.newItem({name:name,email:email,displayName:_1578});
grid.scrollToRow(grid.get("rowCount"));
this.addReviewerCombox.item=null;
this.addReviewerCombox.reset();
this.addReviewerButton.set("disabled",true);
dojo.publish("/davinci/review/publish/valueChanged");
}
},_onValueChange:function(){
dojo.publish("/davinci/review/publish/valueChanged");
},_onPageSelected:function(page){
this.prev.set("disabled",page.isFirstChild);
this.next.set("disabled",page.isLastChild);
dojo.removeClass(this.navPage1,"current");
dojo.removeClass(this.navPage2,"current");
dojo.removeClass(this.navPage3,"current");
if(page==this.page1){
dojo.addClass(this.navPage1,"current");
}
if(page==this.page2){
dojo.addClass(this.navPage2,"current");
}
if(page==this.page3){
dojo.addClass(this.navPage3,"current");
}
},updateSubmit:function(){
var valid=this.versionTitle.isValid()&&this.dueDate.isValid();
var _1579=this.reviewFiles&&this.reviewFiles.length>0;
var _157a=this.userData.length>0;
dojo.removeClass(this.navPage1Icon,valid?"todo":"done");
dojo.addClass(this.navPage1Icon,valid?"done":"todo");
dojo.removeClass(this.navPage2Icon,_1579?"todo":"done");
dojo.addClass(this.navPage2Icon,_1579?"done":"todo");
dojo.removeClass(this.navPage3Icon,_157a?"todo":"done");
dojo.addClass(this.navPage3Icon,_157a?"done":"todo");
this.invite.set("disabled",!(valid&&_1579&&_157a));
var _157b="";
if(!_157a){
_157b=_155d.noReviewersSelected;
}
if(!_1579){
_157b=_155d.noFilesSelected;
}
if(!this.dueDate.isValid()){
_157b=_155d.dueDateIncorrect;
}
if(!this.versionTitle.isValid()){
_157b=_155d.titleRequired;
}
this.reviewMsg.innerHTML=_157b;
},select:function(evt){
var _157c=evt.target;
var _157d=this.reviewerStackContainer;
if(_157c==this.navPage1||_157c==this.navPage1Icon){
_157d.selectChild(this.page1,true);
}else{
if(_157c==this.navPage2||_157c==this.navPage2Icon){
_157d.selectChild(this.page2,true);
}else{
if(_157c==this.navPage3||_157c==this.navPage3Icon){
_157d.selectChild(this.page3,true);
}
}
}
},update:function(){
var _157e=this.targetTreeModel;
_157e.onChildrenChange(_157e.root,_157e.root.children);
},containReviewFile:function(index){
return (this.reviewFiles||[]).some(function(file){
return isNaN(index)?file==index:file.index==index;
});
},getChildrenFiles:function(item){
var _157f=this.reviewFiles||[];
var _1580=this.targetTreeModel;
if(item.elementType=="File"){
if(!this.containReviewFile(item)){
item.index=this.fileIndex++;
_157f.push(item);
var file=new File(item.name,_1580.root);
file.index=item.index;
_1580.root.children.push(file);
}
}else{
if(item.elementType=="Folder"){
item.getChildren(function(_1581){
dojo.forEach(_1581,dojo.hitch(this,function(item){
if(item.elementType=="File"){
this.getChildrenFiles(item);
}
}.bind(this)));
}.bind(this));
}
}
},addSelectFiles:function(){
var _1582=this.sourceTree.get("selectedItems");
this.addFiles(_1582);
},addFiles:function(files){
var _1583=this.sourceTree.get("selectedItems");
if(files){
_1583=files;
}
dojo.forEach(_1583,this.getChildrenFiles,this);
this.update();
dojo.publish("/davinci/review/publish/valueChanged");
},delFiles:function(item){
var _1584=this.reviewFiles,_1585=this.targetTree.get("selectedItems");
if(item){
_1585=[item];
}
dojo.forEach(_1585,dojo.hitch(this,function(item){
if(item.index){
var tmp,i;
for(i=0;i<_1584.length;i++){
if(item.index==_1584[i].index){
tmp=_1584[i];
_1584.splice(i,1);
break;
}
}
if(!tmp){
return;
}
var list=item.parent.children;
for(i=0;i<list.length;i++){
if(item==list[i]){
item.parent.children.splice(i,1);
break;
}
}
this.update(tmp);
}
}));
dojo.publish("/davinci/review/publish/valueChanged");
},_getIconClass:function(item,_1586){
if(item.elementType=="Folder"){
return _1586?"dijitFolderOpened":"dijitFolderClosed";
}
if(item.elementType=="File"){
var icon;
var _1587=item.getExtension();
var _1588=_1557.getExtension("davinci.fileType",function(_1589){
return _1589.extension==_1587;
});
if(_1588){
icon=_1588.iconClass;
}
return icon||"dijitLeaf";
}
return "dijitLeaf";
},initData:function(node,_158a){
var _158b=new _1555();
this.node=node;
this.isRestart=_158a;
if(!node){
xhr.get({url:"cmd/getLatestVersionId"}).then(function(_158c){
this.versionTitle.set("value",dojo.string.substitute(_155d.defaultReviewTitle,[_158c]));
}.bind(this));
}
if(node){
var vName=node.name;
if(_158a){
vName+=" (R)";
}
this.versionTitle.set("value",vName);
if(!this.isRestart){
this.dueDate.set("value",node.dueDate=="infinite"?new Date(""):node.dueDate);
}
this.desireWidth.set("value",node.width===0?"":node.width);
this.desireHeight.set("value",node.height===0?"":node.height);
if(node.description){
this.descriptions.set("value",node.description);
}
this.receiveEmail.set("value",node.receiveEmail);
node.getChildren(function(_158d){
dojo.forEach(_158d,function(item){
var file=_1556.findResource(item.name);
if(file!=null){
this.addFiles([file]);
}
}.bind(this));
for(var i=0;i<node.reviewers.length;i++){
if(node.reviewers[i].email!=node.designerEmail){
var _158e=_1557.getUserDisplayNamePlusEmail({email:node.reviewers[i].email,userId:node.reviewers[i].name});
this.jsonStore.newItem({name:node.reviewers[i].name,email:node.reviewers[i].email,displayName:_158e});
}
}
_158b.resolve();
}.bind(this));
}else{
_158b.resolve();
}
return _158b;
},publish:function(_158f){
var _1590=this.userData.map(function(data){
return data.email;
}).join(",");
var _1591=this.descriptions;
var _1592=_1591.value;
var _1593=this.versionTitle.value;
var _1594=this.dueDate.get("value");
var _1595=_1594?stamp.toISOString(_1594,{zulu:true}):"infinite";
var _1596=this.desireWidth.value||0;
var _1597=this.desireHeight.value||0;
var _1598=dojo.map(this.reviewFiles,function(item){
var path=item.getPath();
if(path.length>2&&path.indexOf("./")==0){
path=path.substring(2);
}
return path;
});
var _1599=this.receiveEmail.get("value")=="on"?"true":"false";
var _159a={isUpdate:this.node&&!this.isRestart,isRestart:this.isRestart,vTime:this.node?this.node.timeStamp:null,emails:_1590,message:_1592,versionTitle:_1593,resources:_1598,desireWidth:_1596,desireHeight:_1597,savingDraft:_158f,dueDate:_1595,receiveEmail:_1599};
if(_1557.currentEditor&&_1557.currentEditor.getContext&&_1557.currentEditor.getContext().getPreference("zazl")){
_159a.zazl=true;
}
var _159b=dojo.objectToQuery(_159a);
xhr.post({url:"cmd/publish"+"?"+_159b,handleAs:"json"}).then(function(_159c){
if(typeof hasToaster=="undefined"){
new _1551({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
if(_159c.length>0){
var _159d=_159c[0];
if(_159d.result=="OK"){
if(_158f){
dojo.publish("/davinci/review/resourceChanged",[{message:_155d.draftSaved,type:"message"},"draft",this.node]);
}else{
if(_159d.emailResult){
if(_159d.emailResult=="OK"){
dojo.publish("/davinci/review/resourceChanged",[{message:_155d.inviteSuccessful,type:"message"},"create",this.node]);
}else{
var _159e=_1553.substitute(_1560,{htmlContent:_159d.emailResult,inviteNotSent:_155d.inviteNotSent,mailFailureMsg:_155d.mailFailureMsg});
dojo.publish("/davinci/review/resourceChanged",[{message:_155d.inviteFailed,type:"warning"},"create",this.node]);
_1558.showMessage(_155d.warning,_159e);
}
}
}
}
}
}.bind(this)).otherwise(function(_159f){
var msg=_159f.responseText;
msg=msg.substring(msg.indexOf("<title>")+7,msg.indexOf("</title>"));
_1557.handleError(_1553.substitute(_155d.errorPublish,[_159f,msg]));
});
this.onClose();
},onClose:function(){
},destroy:function(){
this.inherited(arguments);
this._subs.forEach(dojo.unsubscribe);
delete this._subs;
this.sourceTree.destroyRecursive();
this.targetTree.destroyRecursive();
}});
});
},"davinci/html/ui/CSSOutline":function(){
define("davinci/html/ui/CSSOutline",["dojo/_base/declare","davinci/html/ui/CSSOutlineModel"],function(_15a0,_15a1){
return _15a0("davinci.html.ui.CSSOutline",null,{constructor:function(model){
this._cssModel=model;
},getModel:function(){
this._model=new _15a1(this._cssModel);
return this._model;
}});
});
},"dojox/validate/regexp":function(){
define("dojox/validate/regexp",["dojo/_base/lang","dojo/regexp","dojox/main"],function(lang,_15a2,dojox){
var _15a3=lang.getObject("validate.regexp",true,dojox);
_15a3=dojox.validate.regexp={ipAddress:function(flags){
flags=(typeof flags=="object")?flags:{};
if(typeof flags.allowDottedDecimal!="boolean"){
flags.allowDottedDecimal=true;
}
if(typeof flags.allowDottedHex!="boolean"){
flags.allowDottedHex=true;
}
if(typeof flags.allowDottedOctal!="boolean"){
flags.allowDottedOctal=true;
}
if(typeof flags.allowDecimal!="boolean"){
flags.allowDecimal=true;
}
if(typeof flags.allowHex!="boolean"){
flags.allowHex=true;
}
if(typeof flags.allowIPv6!="boolean"){
flags.allowIPv6=true;
}
if(typeof flags.allowHybrid!="boolean"){
flags.allowHybrid=true;
}
var _15a4="((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
var _15a5="(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]";
var _15a6="(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]";
var _15a7="(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|"+"4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])";
var hexRE="0[xX]0*[\\da-fA-F]{1,8}";
var _15a8="([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}";
var _15a9="([\\da-fA-F]{1,4}\\:){6}"+"((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])";
var a=[];
if(flags.allowDottedDecimal){
a.push(_15a4);
}
if(flags.allowDottedHex){
a.push(_15a5);
}
if(flags.allowDottedOctal){
a.push(_15a6);
}
if(flags.allowDecimal){
a.push(_15a7);
}
if(flags.allowHex){
a.push(hexRE);
}
if(flags.allowIPv6){
a.push(_15a8);
}
if(flags.allowHybrid){
a.push(_15a9);
}
var _15aa="";
if(a.length>0){
_15aa="("+a.join("|")+")";
}
return _15aa;
},host:function(flags){
flags=(typeof flags=="object")?flags:{};
if(typeof flags.allowIP!="boolean"){
flags.allowIP=true;
}
if(typeof flags.allowLocal!="boolean"){
flags.allowLocal=false;
}
if(typeof flags.allowPort!="boolean"){
flags.allowPort=true;
}
if(typeof flags.allowNamed!="boolean"){
flags.allowNamed=false;
}
var _15ab="(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)";
var _15ac="(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)";
var _15ad=flags.allowPort?"(\\:\\d+)?":"";
var _15ae="((?:"+_15ab+"\\.)+"+_15ac+"\\.?)";
if(flags.allowIP){
_15ae+="|"+_15a3.ipAddress(flags);
}
if(flags.allowLocal){
_15ae+="|localhost";
}
if(flags.allowNamed){
_15ae+="|^[^-][a-zA-Z0-9_-]*";
}
return "("+_15ae+")"+_15ad;
},url:function(flags){
flags=(typeof flags=="object")?flags:{};
if(!("scheme" in flags)){
flags.scheme=[true,false];
}
var _15af=_15a2.buildGroupRE(flags.scheme,function(q){
if(q){
return "(https?|ftps?)\\://";
}
return "";
});
var _15b0="(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]+(?:\\?[^?#\\s/]*)?(?:#[A-Za-z][\\w.:-]*)?)?)?";
return _15af+_15a3.host(flags)+_15b0;
},emailAddress:function(flags){
flags=(typeof flags=="object")?flags:{};
if(typeof flags.allowCruft!="boolean"){
flags.allowCruft=false;
}
flags.allowPort=false;
var _15b1="([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+";
var _15b2=_15b1+"@"+_15a3.host(flags);
if(flags.allowCruft){
_15b2="<?(mailto\\:)?"+_15b2+">?";
}
return _15b2;
},emailAddressList:function(flags){
flags=(typeof flags=="object")?flags:{};
if(typeof flags.listSeparator!="string"){
flags.listSeparator="\\s;,";
}
var _15b3=_15a3.emailAddress(flags);
var _15b4="("+_15b3+"\\s*["+flags.listSeparator+"]\\s*)*"+_15b3+"\\s*["+flags.listSeparator+"]?\\s*";
return _15b4;
},numberFormat:function(flags){
flags=(typeof flags=="object")?flags:{};
if(typeof flags.format=="undefined"){
flags.format="###-###-####";
}
var _15b5=function(_15b6){
return _15a2.escapeString(_15b6,"?").replace(/\?/g,"\\d?").replace(/#/g,"\\d");
};
return _15a2.buildGroupRE(flags.format,_15b5);
},ca:{postalCode:function(){
return "([A-Z][0-9][A-Z] [0-9][A-Z][0-9])";
},province:function(){
return "(AB|BC|MB|NB|NL|NS|NT|NU|ON|PE|QC|SK|YT)";
}},us:{state:function(flags){
flags=(typeof flags=="object")?flags:{};
if(typeof flags.allowTerritories!="boolean"){
flags.allowTerritories=true;
}
if(typeof flags.allowMilitary!="boolean"){
flags.allowMilitary=true;
}
var _15b7="AL|AK|AZ|AR|CA|CO|CT|DE|DC|FL|GA|HI|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|"+"NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";
var _15b8="AS|FM|GU|MH|MP|PW|PR|VI";
var _15b9="AA|AE|AP";
if(flags.allowTerritories){
_15b7+="|"+_15b8;
}
if(flags.allowMilitary){
_15b7+="|"+_15b9;
}
return "("+_15b7+")";
}}};
return _15a3;
});
},"url:davinci/ui/widgets/templates/NewFolder.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table>\n\t\t<tr>\n\t\t\t<td class=\"NewProjectDialogLabel\">${uiNLS.parentFolder}</td><td><div class='templateInput'  dojoAttachPoint=\"fileDialogParentFolder\"  ></input></td>\n\t\t</tr>\n\t\t<tr>\n\t\t<td class=\"NewProjectDialogLabel\">${uiNLS.newFolderName}</td><td><input dojoType=\"dijit.form.TextBox\" type=\"text\" dojoAttachPoint=\"folderName\"></input></td><td><div dojoAttachPoint='_error4'></div></td>\n\t\t</tr>\n\t\t</table>\n\t</div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"okButton\" class=\"maqPrimaryButton\" type=\"submit\">${uiNLS.create}</button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:_cancelButton' class=\"maqSecondaryButton\">${uiNLS.cancelButtonLabel}</button>\t\t\n\t</div>\t\t\n</div>","dojo/data/ItemFileReadStore":function(){
define("dojo/data/ItemFileReadStore",["../_base/kernel","../_base/lang","../_base/declare","../_base/array","../_base/xhr","../Evented","./util/filter","./util/simpleFetch","../date/stamp"],function(_15ba,lang,_15bb,array,xhr,_15bc,_15bd,_15be,_15bf){
var _15c0=_15bb("dojo.data.ItemFileReadStore",[_15bc],{constructor:function(_15c1){
this._arrayOfAllItems=[];
this._arrayOfTopLevelItems=[];
this._loadFinished=false;
this._jsonFileUrl=_15c1.url;
this._ccUrl=_15c1.url;
this.url=_15c1.url;
this._jsonData=_15c1.data;
this.data=null;
this._datatypeMap=_15c1.typeMap||{};
if(!this._datatypeMap["Date"]){
this._datatypeMap["Date"]={type:Date,deserialize:function(value){
return _15bf.fromISOString(value);
}};
}
this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};
this._itemsByIdentity=null;
this._storeRefPropName="_S";
this._itemNumPropName="_0";
this._rootItemPropName="_RI";
this._reverseRefMap="_RRM";
this._loadInProgress=false;
this._queuedFetches=[];
if(_15c1.urlPreventCache!==undefined){
this.urlPreventCache=_15c1.urlPreventCache?true:false;
}
if(_15c1.hierarchical!==undefined){
this.hierarchical=_15c1.hierarchical?true:false;
}
if(_15c1.clearOnClose){
this.clearOnClose=true;
}
if("failOk" in _15c1){
this.failOk=_15c1.failOk?true:false;
}
},url:"",_ccUrl:"",data:null,typeMap:null,clearOnClose:false,urlPreventCache:false,failOk:false,hierarchical:true,_assertIsItem:function(item){
if(!this.isItem(item)){
throw new Error(this.declaredClass+": Invalid item argument.");
}
},_assertIsAttribute:function(_15c2){
if(typeof _15c2!=="string"){
throw new Error(this.declaredClass+": Invalid attribute argument.");
}
},getValue:function(item,_15c3,_15c4){
var _15c5=this.getValues(item,_15c3);
return (_15c5.length>0)?_15c5[0]:_15c4;
},getValues:function(item,_15c6){
this._assertIsItem(item);
this._assertIsAttribute(_15c6);
return (item[_15c6]||[]).slice(0);
},getAttributes:function(item){
this._assertIsItem(item);
var _15c7=[];
for(var key in item){
if((key!==this._storeRefPropName)&&(key!==this._itemNumPropName)&&(key!==this._rootItemPropName)&&(key!==this._reverseRefMap)){
_15c7.push(key);
}
}
return _15c7;
},hasAttribute:function(item,_15c8){
this._assertIsItem(item);
this._assertIsAttribute(_15c8);
return (_15c8 in item);
},containsValue:function(item,_15c9,value){
var _15ca=undefined;
if(typeof value==="string"){
_15ca=_15bd.patternToRegExp(value,false);
}
return this._containsValue(item,_15c9,value,_15ca);
},_containsValue:function(item,_15cb,value,_15cc){
return array.some(this.getValues(item,_15cb),function(_15cd){
if(_15cd!==null&&!lang.isObject(_15cd)&&_15cc){
if(_15cd.toString().match(_15cc)){
return true;
}
}else{
if(value===_15cd){
return true;
}
}
});
},isItem:function(_15ce){
if(_15ce&&_15ce[this._storeRefPropName]===this){
if(this._arrayOfAllItems[_15ce[this._itemNumPropName]]===_15ce){
return true;
}
}
return false;
},isItemLoaded:function(_15cf){
return this.isItem(_15cf);
},loadItem:function(_15d0){
this._assertIsItem(_15d0.item);
},getFeatures:function(){
return this._features;
},getLabel:function(item){
if(this._labelAttr&&this.isItem(item)){
return this.getValue(item,this._labelAttr);
}
return undefined;
},getLabelAttributes:function(item){
if(this._labelAttr){
return [this._labelAttr];
}
return null;
},filter:function(_15d1,_15d2,_15d3){
var items=[],i,key;
if(_15d1.query){
var value,_15d4=_15d1.queryOptions?_15d1.queryOptions.ignoreCase:false;
var _15d5={};
for(key in _15d1.query){
value=_15d1.query[key];
if(typeof value==="string"){
_15d5[key]=_15bd.patternToRegExp(value,_15d4);
}else{
if(value instanceof RegExp){
_15d5[key]=value;
}
}
}
for(i=0;i<_15d2.length;++i){
var match=true;
var _15d6=_15d2[i];
if(_15d6===null){
match=false;
}else{
for(key in _15d1.query){
value=_15d1.query[key];
if(!this._containsValue(_15d6,key,value,_15d5[key])){
match=false;
}
}
}
if(match){
items.push(_15d6);
}
}
_15d3(items,_15d1);
}else{
for(i=0;i<_15d2.length;++i){
var item=_15d2[i];
if(item!==null){
items.push(item);
}
}
_15d3(items,_15d1);
}
},_fetchItems:function(_15d7,_15d8,_15d9){
var self=this;
if(this._loadFinished){
this.filter(_15d7,this._getItemsArray(_15d7.queryOptions),_15d8);
}else{
if(this._jsonFileUrl!==this._ccUrl){
_15ba.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
this._ccUrl=this._jsonFileUrl;
this.url=this._jsonFileUrl;
}else{
if(this.url!==this._ccUrl){
this._jsonFileUrl=this.url;
this._ccUrl=this.url;
}
}
if(this.data!=null){
this._jsonData=this.data;
this.data=null;
}
if(this._jsonFileUrl){
if(this._loadInProgress){
this._queuedFetches.push({args:_15d7,filter:lang.hitch(self,"filter"),findCallback:lang.hitch(self,_15d8)});
}else{
this._loadInProgress=true;
var _15da={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};
var _15db=xhr.get(_15da);
_15db.addCallback(function(data){
try{
self._getItemsFromLoadedData(data);
self._loadFinished=true;
self._loadInProgress=false;
self.filter(_15d7,self._getItemsArray(_15d7.queryOptions),_15d8);
self._handleQueuedFetches();
}
catch(e){
self._loadFinished=true;
self._loadInProgress=false;
_15d9(e,_15d7);
}
});
_15db.addErrback(function(error){
self._loadInProgress=false;
_15d9(error,_15d7);
});
var _15dc=null;
if(_15d7.abort){
_15dc=_15d7.abort;
}
_15d7.abort=function(){
var df=_15db;
if(df&&df.fired===-1){
df.cancel();
df=null;
}
if(_15dc){
_15dc.call(_15d7);
}
};
}
}else{
if(this._jsonData){
try{
this._loadFinished=true;
this._getItemsFromLoadedData(this._jsonData);
this._jsonData=null;
self.filter(_15d7,this._getItemsArray(_15d7.queryOptions),_15d8);
}
catch(e){
_15d9(e,_15d7);
}
}else{
_15d9(new Error(this.declaredClass+": No JSON source data was provided as either URL or a nested Javascript object."),_15d7);
}
}
}
},_handleQueuedFetches:function(){
if(this._queuedFetches.length>0){
for(var i=0;i<this._queuedFetches.length;i++){
var fData=this._queuedFetches[i],_15dd=fData.args,_15de=fData.filter,_15df=fData.findCallback;
if(_15de){
_15de(_15dd,this._getItemsArray(_15dd.queryOptions),_15df);
}else{
this.fetchItemByIdentity(_15dd);
}
}
this._queuedFetches=[];
}
},_getItemsArray:function(_15e0){
if(_15e0&&_15e0.deep){
return this._arrayOfAllItems;
}
return this._arrayOfTopLevelItems;
},close:function(_15e1){
if(this.clearOnClose&&this._loadFinished&&!this._loadInProgress){
if(((this._jsonFileUrl==""||this._jsonFileUrl==null)&&(this.url==""||this.url==null))&&this.data==null){
}
this._arrayOfAllItems=[];
this._arrayOfTopLevelItems=[];
this._loadFinished=false;
this._itemsByIdentity=null;
this._loadInProgress=false;
this._queuedFetches=[];
}
},_getItemsFromLoadedData:function(_15e2){
var _15e3=false,self=this;
function _15e4(_15e5){
return (_15e5!==null)&&(typeof _15e5==="object")&&(!lang.isArray(_15e5)||_15e3)&&(!lang.isFunction(_15e5))&&(_15e5.constructor==Object||lang.isArray(_15e5))&&(typeof _15e5._reference==="undefined")&&(typeof _15e5._type==="undefined")&&(typeof _15e5._value==="undefined")&&self.hierarchical;
};
function _15e6(_15e7){
self._arrayOfAllItems.push(_15e7);
for(var _15e8 in _15e7){
var _15e9=_15e7[_15e8];
if(_15e9){
if(lang.isArray(_15e9)){
var _15ea=_15e9;
for(var k=0;k<_15ea.length;++k){
var _15eb=_15ea[k];
if(_15e4(_15eb)){
_15e6(_15eb);
}
}
}else{
if(_15e4(_15e9)){
_15e6(_15e9);
}
}
}
}
};
this._labelAttr=_15e2.label;
var i,item;
this._arrayOfAllItems=[];
this._arrayOfTopLevelItems=_15e2.items;
for(i=0;i<this._arrayOfTopLevelItems.length;++i){
item=this._arrayOfTopLevelItems[i];
if(lang.isArray(item)){
_15e3=true;
}
_15e6(item);
item[this._rootItemPropName]=true;
}
var _15ec={},key;
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
for(key in item){
if(key!==this._rootItemPropName){
var value=item[key];
if(value!==null){
if(!lang.isArray(value)){
item[key]=[value];
}
}else{
item[key]=[null];
}
}
_15ec[key]=key;
}
}
while(_15ec[this._storeRefPropName]){
this._storeRefPropName+="_";
}
while(_15ec[this._itemNumPropName]){
this._itemNumPropName+="_";
}
while(_15ec[this._reverseRefMap]){
this._reverseRefMap+="_";
}
var _15ed;
var _15ee=_15e2.identifier;
if(_15ee){
this._itemsByIdentity={};
this._features["dojo.data.api.Identity"]=_15ee;
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
_15ed=item[_15ee];
var _15ef=_15ed[0];
if(!Object.hasOwnProperty.call(this._itemsByIdentity,_15ef)){
this._itemsByIdentity[_15ef]=item;
}else{
if(this._jsonFileUrl){
throw new Error(this.declaredClass+":  The json data as specified by: ["+this._jsonFileUrl+"] is malformed.  Items within the list have identifier: ["+_15ee+"].  Value collided: ["+_15ef+"]");
}else{
if(this._jsonData){
throw new Error(this.declaredClass+":  The json data provided by the creation arguments is malformed.  Items within the list have identifier: ["+_15ee+"].  Value collided: ["+_15ef+"]");
}
}
}
}
}else{
this._features["dojo.data.api.Identity"]=Number;
}
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
item[this._storeRefPropName]=this;
item[this._itemNumPropName]=i;
}
for(i=0;i<this._arrayOfAllItems.length;++i){
item=this._arrayOfAllItems[i];
for(key in item){
_15ed=item[key];
for(var j=0;j<_15ed.length;++j){
value=_15ed[j];
if(value!==null&&typeof value=="object"){
if(("_type" in value)&&("_value" in value)){
var type=value._type;
var _15f0=this._datatypeMap[type];
if(!_15f0){
throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '"+type+"'");
}else{
if(lang.isFunction(_15f0)){
_15ed[j]=new _15f0(value._value);
}else{
if(lang.isFunction(_15f0.deserialize)){
_15ed[j]=_15f0.deserialize(value._value);
}else{
throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");
}
}
}
}
if(value._reference){
var _15f1=value._reference;
if(!lang.isObject(_15f1)){
_15ed[j]=this._getItemByIdentity(_15f1);
}else{
for(var k=0;k<this._arrayOfAllItems.length;++k){
var _15f2=this._arrayOfAllItems[k],found=true;
for(var _15f3 in _15f1){
if(_15f2[_15f3]!=_15f1[_15f3]){
found=false;
}
}
if(found){
_15ed[j]=_15f2;
}
}
}
if(this.referenceIntegrity){
var _15f4=_15ed[j];
if(this.isItem(_15f4)){
this._addReferenceToMap(_15f4,item,key);
}
}
}else{
if(this.isItem(value)){
if(this.referenceIntegrity){
this._addReferenceToMap(value,item,key);
}
}
}
}
}
}
}
},_addReferenceToMap:function(_15f5,_15f6,_15f7){
},getIdentity:function(item){
var _15f8=this._features["dojo.data.api.Identity"];
if(_15f8===Number){
return item[this._itemNumPropName];
}else{
var _15f9=item[_15f8];
if(_15f9){
return _15f9[0];
}
}
return null;
},fetchItemByIdentity:function(_15fa){
var item,scope;
if(!this._loadFinished){
var self=this;
if(this._jsonFileUrl!==this._ccUrl){
_15ba.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
this._ccUrl=this._jsonFileUrl;
this.url=this._jsonFileUrl;
}else{
if(this.url!==this._ccUrl){
this._jsonFileUrl=this.url;
this._ccUrl=this.url;
}
}
if(this.data!=null&&this._jsonData==null){
this._jsonData=this.data;
this.data=null;
}
if(this._jsonFileUrl){
if(this._loadInProgress){
this._queuedFetches.push({args:_15fa});
}else{
this._loadInProgress=true;
var _15fb={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};
var _15fc=xhr.get(_15fb);
_15fc.addCallback(function(data){
var scope=_15fa.scope?_15fa.scope:_15ba.global;
try{
self._getItemsFromLoadedData(data);
self._loadFinished=true;
self._loadInProgress=false;
item=self._getItemByIdentity(_15fa.identity);
if(_15fa.onItem){
_15fa.onItem.call(scope,item);
}
self._handleQueuedFetches();
}
catch(error){
self._loadInProgress=false;
if(_15fa.onError){
_15fa.onError.call(scope,error);
}
}
});
_15fc.addErrback(function(error){
self._loadInProgress=false;
if(_15fa.onError){
var scope=_15fa.scope?_15fa.scope:_15ba.global;
_15fa.onError.call(scope,error);
}
});
}
}else{
if(this._jsonData){
self._getItemsFromLoadedData(self._jsonData);
self._jsonData=null;
self._loadFinished=true;
item=self._getItemByIdentity(_15fa.identity);
if(_15fa.onItem){
scope=_15fa.scope?_15fa.scope:_15ba.global;
_15fa.onItem.call(scope,item);
}
}
}
}else{
item=this._getItemByIdentity(_15fa.identity);
if(_15fa.onItem){
scope=_15fa.scope?_15fa.scope:_15ba.global;
_15fa.onItem.call(scope,item);
}
}
},_getItemByIdentity:function(_15fd){
var item=null;
if(this._itemsByIdentity){
if(Object.hasOwnProperty.call(this._itemsByIdentity,_15fd)){
item=this._itemsByIdentity[_15fd];
}
}else{
if(Object.hasOwnProperty.call(this._arrayOfAllItems,_15fd)){
item=this._arrayOfAllItems[_15fd];
}
}
if(item===undefined){
item=null;
}
return item;
},getIdentityAttributes:function(item){
var _15fe=this._features["dojo.data.api.Identity"];
if(_15fe===Number){
return null;
}else{
return [_15fe];
}
},_forceLoad:function(){
var self=this;
if(this._jsonFileUrl!==this._ccUrl){
_15ba.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");
this._ccUrl=this._jsonFileUrl;
this.url=this._jsonFileUrl;
}else{
if(this.url!==this._ccUrl){
this._jsonFileUrl=this.url;
this._ccUrl=this.url;
}
}
if(this.data!=null){
this._jsonData=this.data;
this.data=null;
}
if(this._jsonFileUrl){
var _15ff={url:this._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk,sync:true};
var _1600=xhr.get(_15ff);
_1600.addCallback(function(data){
try{
if(self._loadInProgress!==true&&!self._loadFinished){
self._getItemsFromLoadedData(data);
self._loadFinished=true;
}else{
if(self._loadInProgress){
throw new Error(this.declaredClass+":  Unable to perform a synchronous load, an async load is in progress.");
}
}
}
catch(e){
throw e;
}
});
_1600.addErrback(function(error){
throw error;
});
}else{
if(this._jsonData){
self._getItemsFromLoadedData(self._jsonData);
self._jsonData=null;
self._loadFinished=true;
}
}
}});
lang.extend(_15c0,_15be);
return _15c0;
});
},"davinci/review/actions/EditVersionAction":function(){
define("davinci/review/actions/EditVersionAction",["dojo/_base/declare","./_ReviewNavigatorCommon","./PublishAction","../../Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_1601,_1602,_1603,_1604,_1605,nls){
return _1601("davinci.review.actions.EditVersionAction",[_1602],{run:function(_1606){
var _1607=this._getSelection(_1606);
if(!_1607||!_1607.length){
return;
}
var item=_1607[0].resource.elementType=="ReviewFile"?_1607[0].resource.parent:_1607[0].resource;
var _1608=new _1603(item);
_1608.run();
},isEnabled:function(_1609){
var _160a=this._getSelection(_1609);
if(_160a&&_160a.length>0){
var item=_160a[0].resource.elementType=="ReviewFile"?_160a[0].resource.parent:_160a[0].resource;
if(item.designerId==_1604.userName){
return true;
}
}
return false;
}});
});
},"dojox/widget/Toaster":function(){
define("dojox/widget/Toaster",["dojo/_base/declare","dojo/_base/lang","dojo/_base/connect","dojo/_base/fx","dojo/dom-style","dojo/dom-class","dojo/dom-geometry","dijit/registry","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/BackgroundIframe","dojo/fx","dojo/has","dojo/_base/window","dojo/window"],function(_160b,lang,_160c,_160d,_160e,_160f,_1610,_1611,_1612,_1613,_1614,_1615,has,_1616,_1617){
lang.getObject("dojox.widget",true);
var _1618=function(w){
return w.substring(0,1).toUpperCase()+w.substring(1);
};
return _160b("dojox.widget.Toaster",[_1612,_1613],{templateString:"<div class=\"dijitToasterClip\" dojoAttachPoint=\"clipNode\"><div class=\"dijitToasterContainer\" dojoAttachPoint=\"containerNode\" dojoAttachEvent=\"onclick:onSelect\"><div class=\"dijitToasterContent\" dojoAttachPoint=\"contentNode\"></div></div></div>",messageTopic:"",messageTypes:{MESSAGE:"message",WARNING:"warning",ERROR:"error",FATAL:"fatal"},defaultType:"message",positionDirection:"br-up",positionDirectionTypes:["br-up","br-left","bl-up","bl-right","tr-down","tr-left","tl-down","tl-right"],duration:2000,slideDuration:500,separator:"<hr></hr>",postCreate:function(){
this.inherited(arguments);
this.hide();
_1616.body().appendChild(this.domNode);
if(this.messageTopic){
_160c.subscribe(this.messageTopic,this,"_handleMessage");
}
},_handleMessage:function(_1619){
if(lang.isString(_1619)){
this.setContent(_1619);
}else{
this.setContent(_1619.message,_1619.type,_1619.duration);
}
},setContent:function(_161a,_161b,_161c){
_161c=_161c||this.duration;
if(this.slideAnim){
if(this.slideAnim.status()!="playing"){
this.slideAnim.stop();
}
if(this.slideAnim.status()=="playing"||(this.fadeAnim&&this.fadeAnim.status()=="playing")){
setTimeout(lang.hitch(this,function(){
this.setContent(_161a,_161b,_161c);
}),50);
return;
}
}
for(var type in this.messageTypes){
_160f.remove(this.containerNode,"dijitToaster"+_1618(this.messageTypes[type]));
}
_160e.set(this.containerNode,"opacity",1);
this._setContent(_161a);
_160f.add(this.containerNode,"dijitToaster"+_1618(_161b||this.defaultType));
this.show();
var _161d=_1610.getMarginBox(this.containerNode);
this._cancelHideTimer();
if(this.isVisible){
this._placeClip();
if(!this._stickyMessage){
this._setHideTimer(_161c);
}
}else{
var style=this.containerNode.style;
var pd=this.positionDirection;
if(pd.indexOf("-up")>=0){
style.left=0+"px";
style.top=_161d.h+10+"px";
}else{
if(pd.indexOf("-left")>=0){
style.left=_161d.w+10+"px";
style.top=0+"px";
}else{
if(pd.indexOf("-right")>=0){
style.left=0-_161d.w-10+"px";
style.top=0+"px";
}else{
if(pd.indexOf("-down")>=0){
style.left=0+"px";
style.top=0-_161d.h-10+"px";
}else{
throw new Error(this.id+".positionDirection is invalid: "+pd);
}
}
}
}
this.slideAnim=_1615.slideTo({node:this.containerNode,top:0,left:0,duration:this.slideDuration});
this.connect(this.slideAnim,"onEnd",function(nodes,anim){
this.fadeAnim=_160d.fadeOut({node:this.containerNode,duration:1000});
this.connect(this.fadeAnim,"onEnd",function(evt){
this.isVisible=false;
this.hide();
});
this._setHideTimer(_161c);
this.connect(this,"onSelect",function(evt){
this._cancelHideTimer();
this._stickyMessage=false;
this.fadeAnim.play();
});
this.isVisible=true;
});
this.slideAnim.play();
}
},_setContent:function(_161e){
if(lang.isFunction(_161e)){
_161e(this);
return;
}
if(_161e&&this.isVisible){
_161e=this.contentNode.innerHTML+this.separator+_161e;
}
this.contentNode.innerHTML=_161e;
},_cancelHideTimer:function(){
if(this._hideTimer){
clearTimeout(this._hideTimer);
this._hideTimer=null;
}
},_setHideTimer:function(_161f){
this._cancelHideTimer();
if(_161f>0){
this._cancelHideTimer();
this._hideTimer=setTimeout(lang.hitch(this,function(evt){
if(this.bgIframe&&this.bgIframe.iframe){
this.bgIframe.iframe.style.display="none";
}
this._hideTimer=null;
this._stickyMessage=false;
this.fadeAnim.play();
}),_161f);
}else{
this._stickyMessage=true;
}
},_placeClip:function(){
var view=_1617.getBox();
var _1620=_1610.getMarginBox(this.containerNode);
var style=this.clipNode.style;
style.height=_1620.h+"px";
style.width=_1620.w+"px";
var pd=this.positionDirection;
if(pd.match(/^t/)){
style.top=view.t+"px";
}else{
if(pd.match(/^b/)){
style.top=(view.h-_1620.h-2+view.t)+"px";
}
}
if(pd.match(/^[tb]r-/)){
style.left=(view.w-_1620.w-1-view.l)+"px";
}else{
if(pd.match(/^[tb]l-/)){
style.left=0+"px";
}
}
style.clip="rect(0px, "+_1620.w+"px, "+_1620.h+"px, 0px)";
if(has("ie")){
if(!this.bgIframe){
this.clipNode.id=_1611.getUniqueId("dojox_widget_Toaster_clipNode");
this.bgIframe=new _1614(this.clipNode);
}
var _1621=this.bgIframe.iframe;
if(_1621){
_1621.style.display="block";
}
}
},onSelect:function(e){
},show:function(){
_160e.set(this.domNode,"display","block");
this._placeClip();
if(!this._scrollConnected){
this._scrollConnected=_160c.connect(_1617,"onscroll",this,this._placeClip);
}
},hide:function(){
_160e.set(this.domNode,"display","none");
if(this._scrollConnected){
_160c.disconnect(this._scrollConnected);
this._scrollConnected=false;
}
_160e.set(this.containerNode,"opacity",1);
}});
});
},"davinci/html/CSSRule":function(){
define("davinci/html/CSSRule",["dojo/_base/declare","davinci/html/CSSElement","davinci/html/CSSParser","davinci/html/CSSProperty"],function(_1622,_1623,_1624,_1625){
return _1622("davinci.html.CSSRule",_1623,{constructor:function(){
this.elementType="CSSRule";
this.selectors=[];
this.properties=[];
},getText:function(_1626){
var s="";
_1626=_1626||[];
if(this.comment&&!_1626.noComments){
s+=this.comment.getText(_1626);
}
s+=this.getSelectorText(_1626);
s=s+" {";
for(var i=0;i<this.properties.length;i++){
s=s+"\n    "+this.properties[i].getText(_1626);
}
s=s+"\n}\n";
if(this.postComment&&!_1626.noComments){
s+=this.postComment.getText(_1626);
}
return s;
},setText:function(text){
var _1627={xmode:"style",css:true};
var _1628=require("davinci/html/CSSParser").parse(text,this);
dojo.mixin(this,this.children[0]);
var _1629=(this.parent)?this.parent.endOffset:0;
this.startOffset=_1629+1;
this.setDirty(true);
},addProperty:function(name,value){
var _162a=new _1625(name,value,this);
this.properties.push(_162a);
this.setDirty(true);
this.onChange();
},insertProperty:function(name,value,_162b){
var _162c;
_162c=this.getProperty(name);
if(_162c){
this.removeProperty(name);
}
_162c=new _1625(name,value,this);
this.properties.splice(_162b,0,_162c);
this.setDirty(true);
this.onChange();
},getSelectorText:function(_162d){
var s="";
for(var i=0;i<this.selectors.length;i++){
if(i>0){
s=s+", ";
}
s=s+this.selectors[i].getText(_162d);
}
return s;
},matches:function(_162e){
_162e=this._convertNode(_162e);
var _162f;
for(var i=0;i<this.selectors.length;i++){
if((_162f=this.selectors[i].matches(_162e))>=0){
return _162f;
}
}
},visit:function(_1630){
if(!_1630.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_1630);
}
for(var i=0;i<this.selectors.length;i++){
this.selectors[i].visit(_1630);
}
}
if(_1630.endVisit){
_1630.endVisit(this);
}
},hasSelector:function(_1631){
for(var i=0;i<this.selectors.length;i++){
if(this.selectors[i].getLabel()==_1631){
return true;
}
}
return false;
},matchesSelectors:function(_1632){
for(var j=0;j<_1632.length;j++){
for(var i=0;i<this.selectors.length;i++){
if(this.selectors[i].matchesSelector(_1632[j])){
return true;
}
}
}
return false;
},getCSSRule:function(){
return this;
},getLabel:function(){
return this.getSelectorText({});
},getProperty:function(_1633){
for(var i=0;i<this.properties.length;i++){
if(_1633==this.properties[i].name){
return this.properties[i];
}
}
},hasProperty:function(_1634){
for(var i=0;i<this.properties.length;i++){
if(_1634==this.properties[i].name){
return true;
}
}
},getProperties:function(_1635){
var _1636=[];
for(var i=0;i<this.properties.length;i++){
if(!_1635||_1635==this.properties[i].name){
_1636.push(this.properties[i]);
}
}
return _1636;
},setProperty:function(name,value){
var _1637=this.getProperty(name);
if(!value){
this.removeProperty(name);
}else{
if(_1637){
_1637.value=value;
}else{
_1637=new _1625();
_1637.name=name;
_1637.value=value;
this.properties.push(_1637);
_1637.parent=this;
}
}
this.setDirty(true);
this.onChange();
},removeProperty:function(_1638){
for(var i=0;i<this.properties.length;i++){
if(_1638==this.properties[i].name){
this.properties.splice(i,1);
}
}
this.setDirty(true);
this.onChange();
},removeAllProperties:function(){
this.properties=[];
this.setDirty(true);
this.onChange();
},removeStyleValues:function(_1639){
var _163a=[];
for(var i=0;i<this.properties.length;i++){
var found;
for(var j=0;j<_1639.length&&!found;j++){
found=_1639[j]==this.properties[i].name;
}
if(!found){
_163a=this.properties[i];
}
}
this.properties=_163a;
this.setDirty(true);
this.onChange();
}});
});
},"url:davinci/ui/templates/Rename.html":"<div>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<table>\n\t\t\t<tr>\n\t\t\t\t<td class=\"NewProjectDialogLabel\">${renameNewLabel}</td><td><input class='templateInput' type='text' dojoAttachPoint=\"_newName\"></input></td><td><div dojoAttachPoint='_error4'></div></td>\n\t\t\t</tr>\t\t\n\t\t</table>\n\t</div>\n\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType='dijit.form.Button' dojoAttachPoint=\"_okButton\" dojoAttachEvent='onClick:okButton' label='${renameButtonLabel}' class=\"maqPrimaryButton\" type=\"submit\" disabled></button>\n\t\t<button dojoType='dijit.form.Button' dojoAttachEvent='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>","davinci/workbench/ViewPart":function(){
define("davinci/workbench/ViewPart",["dojo/_base/declare","./_ToolbaredContainer","../ve/States","../Runtime"],function(_163b,_163c,_163d,_163e){
return _163b("davinci.workbench.ViewPart",_163c,{constructor:function(_163f,_1640){
this.viewExt=_163f.view;
this.subscriptions=[];
this.publishing={};
},startup:function(){
this.inherited(arguments);
this.domNode.view=this;
if(this.viewExt.startup){
this.viewExt.startup();
}
},subscribe:function(topic,func){
this.subscriptions.push(dojo.subscribe(topic,this,func));
},publish:function(topic,data){
this.publishing[topic]=true;
try{
dojo.publish(topic,data);
}
catch(e){
console.error(e);
}
delete this.publishing[topic];
},destroy:function(){
dojo.forEach(this.subscriptions,dojo.unsubscribe);
delete this.subscriptions;
},_getViewActions:function(){
var _1641=this.toolbarID||this.viewExt.id;
var _1642=[];
_163e.getExtensions("davinci.viewActions",function(ext){
if(_1641==ext.viewContribution.targetID){
_1642.push(ext.viewContribution);
return true;
}
});
return _1642;
}});
});
},"davinci/actions/Action":function(){
define("davinci/actions/Action",["dojo/_base/declare"],function(_1643){
return _1643("davinci.actions.Action",null,{item:null,run:function(_1644){
},isEnabled:function(_1645){
return true;
},getName:function(){
return this.item.label;
}});
});
},"dijit/form/ComboButton":function(){
require({cache:{"url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t/></td></tr></tbody\n></table>\n"}});
define("dijit/form/ComboButton",["dojo/_base/declare","dojo/_base/event","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_1646,event,keys,focus,_1647,_1648){
return _1646("dijit.form.ComboButton",_1647,{templateString:_1648,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyPress:function(evt){
if(evt.charOrCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){
focus.focus(this._popupStateNode);
event.stop(evt);
}
},_onArrowKeyPress:function(evt){
if(evt.charOrCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){
focus.focus(this.titleNode);
event.stop(evt);
}
},focus:function(_1649){
if(!this.disabled){
focus.focus(_1649=="start"?this.titleNode:this._popupStateNode);
}
}});
});
},"davinci/review/actions/CloseVersionAction":function(){
define("davinci/review/actions/CloseVersionAction",["dojo/_base/declare","./_ReviewNavigatorCommon","davinci/Runtime","dojox/widget/Toaster","dojo/i18n!./nls/actions"],function(_164a,_164b,_164c,_164d,nls){
var _164e=_164a("davinci.review.actions.CloseVersionAction",[_164b],{run:function(_164f){
var _1650=this._getSelection(_164f);
if(!_1650||!_1650.length){
return;
}
okToClose=confirm(nls.areYouSureClose);
if(!okToClose){
return;
}
var item=_1650[0].resource.elementType=="ReviewFile"?_1650[0].resource.parent:_1650[0].resource;
dojo.xhrGet({url:"cmd/managerVersion",sync:false,handleAs:"text",content:{"type":"close","vTime":item.timeStamp}}).then(function(_1651){
if(_1651=="OK"){
if(typeof hasToaster=="undefined"){
new _164d({position:"br-left",duration:4000,messageTopic:"/davinci/review/resourceChanged"});
hasToaster=true;
}
dojo.publish("/davinci/review/resourceChanged",[{message:nls.closeSuccessful,type:"message"},"closed",item]);
}
});
},isEnabled:function(_1652){
var _1653=this._getSelection(_1652);
if(!_1653||_1653.length==0){
return false;
}
var item=_1653[0].resource.elementType=="ReviewFile"?_1653[0].resource.parent:_1653[0].resource;
if(item.designerId==_164c.userName){
if(!item.closed&&!item.isDraft){
return true;
}
}
return false;
}});
return _164e;
});
},"dijit/form/RangeBoundTextBox":function(){
define("dijit/form/RangeBoundTextBox",["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_1654,i18n,_1655){
var _1656=_1654("dijit.form.RangeBoundTextBox",_1655,{rangeMessage:"",rangeCheck:function(_1657,_1658){
return ("min" in _1658?(this.compare(_1657,_1658.min)>=0):true)&&("max" in _1658?(this.compare(_1657,_1658.max)<=0):true);
},isInRange:function(){
return this.rangeCheck(this.get("value"),this.constraints);
},_isDefinitelyOutOfRange:function(){
var val=this.get("value");
if(val==null){
return false;
}
var _1659=false;
if("min" in this.constraints){
var min=this.constraints.min;
_1659=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;
}
if(!_1659&&("max" in this.constraints)){
var max=this.constraints.max;
_1659=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;
}
return _1659;
},_isValidSubset:function(){
return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();
},isValid:function(_165a){
return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_165a));
},getErrorMessage:function(_165b){
var v=this.get("value");
if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_165b)){
return this.rangeMessage;
}
return this.inherited(arguments);
},postMixInProperties:function(){
this.inherited(arguments);
if(!this.rangeMessage){
this.messages=i18n.getLocalization("dijit.form","validate",this.lang);
this.rangeMessage=this.messages.rangeMessage;
}
},applyTextDir:function(){
}});
return _1656;
});
},"davinci/model/parser/Tokenizer":function(){
define("davinci/model/parser/Tokenizer",["dojo/_base/declare","davinci/js/JSExpression"],function(_165c,_165d){
return {stringStream:function(_165e){
var _165f="";
var pos=0;
var _1660=0;
var accum="";
function _1661(){
while(pos==_165f.length){
accum+=_165f;
_165f="";
pos=0;
try{
_165f=_165e.next();
}
catch(e){
if(e!=StopIteration){
throw e;
}else{
return false;
}
}
}
return true;
};
return {peek:function(){
if(!_1661()){
return null;
}
return _165f.charAt(pos);
},next:function(){
if(!_1661()){
if(accum.length>0){
throw "End of stringstream reached without emptying buffer ('"+accum+"').";
}else{
throw StopIteration;
}
}
return _165f.charAt(pos++);
},get:function(){
var temp=accum;
accum="";
if(pos>0){
temp+=_165f.slice(0,pos);
_165f=_165f.slice(pos);
pos=0;
}
_1660+=temp.length;
return temp;
},getOffset:function(){
return _1660;
},push:function(str){
_165f=_165f.slice(0,pos)+str+_165f.slice(pos);
_1660-=str.length;
},lookAhead:function(str,_1662,_1663,_1664){
function cased(str){
return _1664?str.toLowerCase():str;
};
str=cased(str);
var found=false;
var _1665=accum,_1666=pos;
if(_1663){
this.nextWhileMatches(/[\s\u00a0]/);
}
while(true){
var end=pos+str.length,left=_165f.length-pos;
if(end<=_165f.length){
found=str==cased(_165f.slice(pos,end));
pos=end;
break;
}else{
if(str.slice(0,left)==cased(_165f.slice(pos))){
accum+=_165f;
_165f="";
try{
_165f=_165e.next();
}
catch(e){
if(e!=StopIteration){
throw e;
}
break;
}
pos=0;
str=str.slice(left);
}else{
break;
}
}
}
if(!(found&&_1662)){
_165f=accum.slice(_1665.length)+_165f;
pos=_1666;
accum=_1665;
}
return found;
},lookAheadRegex:function(regex,_1667){
if(regex.source.charAt(0)!="^"){
throw new Error("Regexps passed to lookAheadRegex must start with ^");
}
while(_165f.indexOf("\n",pos)==-1){
try{
_165f+=_165e.next();
}
catch(e){
if(e!=StopIteration){
throw e;
break;
}
}
}
var _1668=_165f.slice(pos).match(regex);
if(_1668&&_1667){
pos+=_1668[0].length;
}
return _1668;
},more:function(){
return this.peek()!==null;
},applies:function(test){
var next=this.peek();
return (next!==null&&test(next));
},nextWhile:function(test){
var next;
while((next=this.peek())!==null&&test(next)){
this.next();
}
},matches:function(re){
var next=this.peek();
return (next!==null&&re.test(next));
},nextWhileMatches:function(re){
var next;
while((next=this.peek())!==null&&re.test(next)){
this.next();
}
},equals:function(ch){
return ch===this.peek();
},endOfLine:function(){
var next=this.peek();
return next==null||next=="\n";
}};
},tokenizer:function(_1669,state){
function _166a(ch){
return ch!="\n"&&/^[\s\u00a0]*$/.test(ch);
};
var _166b={state:state,take:function(type){
if(typeof (type)=="string"){
type={style:type,type:type};
}
type.offset=_1669.getOffset();
type.content=(type.content||"")+_1669.get();
if(!/\n$/.test(type.content)){
_1669.nextWhile(_166a);
}
type.value=type.content+_1669.get();
return type;
},next:function(){
if(!_1669.more()){
throw StopIteration;
}
var type;
if(_1669.equals("\n")){
_1669.next();
return this.take("whitespace");
}
if(_1669.applies(_166a)){
type="whitespace";
}else{
while(!type){
type=this.state(_1669,function(s){
_166b.state=s;
});
}
}
return this.take(type);
}};
return _166b;
}};
});
},"dojox/html/entities":function(){
define("dojox/html/entities",["dojo/_base/lang"],function(lang){
var dhe=lang.getObject("dojox.html.entities",true);
var _166c=function(str,map){
var _166d,_166e;
if(map._encCache&&map._encCache.regexp&&map._encCache.mapper&&map.length==map._encCache.length){
_166d=map._encCache.mapper;
_166e=map._encCache.regexp;
}else{
_166d={};
_166e=["["];
var i;
for(i=0;i<map.length;i++){
_166d[map[i][0]]="&"+map[i][1]+";";
_166e.push(map[i][0]);
}
_166e.push("]");
_166e=new RegExp(_166e.join(""),"g");
map._encCache={mapper:_166d,regexp:_166e,length:map.length};
}
str=str.replace(_166e,function(c){
return _166d[c];
});
return str;
};
var _166f=function(str,map){
var _1670,_1671;
if(map._decCache&&map._decCache.regexp&&map._decCache.mapper&&map.length==map._decCache.length){
_1670=map._decCache.mapper;
_1671=map._decCache.regexp;
}else{
_1670={};
_1671=["("];
var i;
for(i=0;i<map.length;i++){
var e="&"+map[i][1]+";";
if(i){
_1671.push("|");
}
_1670[e]=map[i][0];
_1671.push(e);
}
_1671.push(")");
_1671=new RegExp(_1671.join(""),"g");
map._decCache={mapper:_1670,regexp:_1671,length:map.length};
}
str=str.replace(_1671,function(c){
return _1670[c];
});
return str;
};
dhe.html=[["&","amp"],["\"","quot"],["<","lt"],[">","gt"],[" ","nbsp"]];
dhe.latin=[["¡","iexcl"],["¢","cent"],["£","pound"],["€","euro"],["¤","curren"],["¥","yen"],["¦","brvbar"],["§","sect"],["¨","uml"],["©","copy"],["ª","ordf"],["«","laquo"],["¬","not"],["­","shy"],["®","reg"],["¯","macr"],["°","deg"],["±","plusmn"],["²","sup2"],["³","sup3"],["´","acute"],["µ","micro"],["¶","para"],["·","middot"],["¸","cedil"],["¹","sup1"],["º","ordm"],["»","raquo"],["¼","frac14"],["½","frac12"],["¾","frac34"],["¿","iquest"],["À","Agrave"],["Á","Aacute"],["Â","Acirc"],["Ã","Atilde"],["Ä","Auml"],["Å","Aring"],["Æ","AElig"],["Ç","Ccedil"],["È","Egrave"],["É","Eacute"],["Ê","Ecirc"],["Ë","Euml"],["Ì","Igrave"],["Í","Iacute"],["Î","Icirc"],["Ï","Iuml"],["Ð","ETH"],["Ñ","Ntilde"],["Ò","Ograve"],["Ó","Oacute"],["Ô","Ocirc"],["Õ","Otilde"],["Ö","Ouml"],["×","times"],["Ø","Oslash"],["Ù","Ugrave"],["Ú","Uacute"],["Û","Ucirc"],["Ü","Uuml"],["Ý","Yacute"],["Þ","THORN"],["ß","szlig"],["à","agrave"],["á","aacute"],["â","acirc"],["ã","atilde"],["ä","auml"],["å","aring"],["æ","aelig"],["ç","ccedil"],["è","egrave"],["é","eacute"],["ê","ecirc"],["ë","euml"],["ì","igrave"],["í","iacute"],["î","icirc"],["ï","iuml"],["ð","eth"],["ñ","ntilde"],["ò","ograve"],["ó","oacute"],["ô","ocirc"],["õ","otilde"],["ö","ouml"],["÷","divide"],["ø","oslash"],["ù","ugrave"],["ú","uacute"],["û","ucirc"],["ü","uuml"],["ý","yacute"],["þ","thorn"],["ÿ","yuml"],["ƒ","fnof"],["Α","Alpha"],["Β","Beta"],["Γ","Gamma"],["Δ","Delta"],["Ε","Epsilon"],["Ζ","Zeta"],["Η","Eta"],["Θ","Theta"],["Ι","Iota"],["Κ","Kappa"],["Λ","Lambda"],["Μ","Mu"],["Ν","Nu"],["Ξ","Xi"],["Ο","Omicron"],["Π","Pi"],["Ρ","Rho"],["Σ","Sigma"],["Τ","Tau"],["Υ","Upsilon"],["Φ","Phi"],["Χ","Chi"],["Ψ","Psi"],["Ω","Omega"],["α","alpha"],["β","beta"],["γ","gamma"],["δ","delta"],["ε","epsilon"],["ζ","zeta"],["η","eta"],["θ","theta"],["ι","iota"],["κ","kappa"],["λ","lambda"],["μ","mu"],["ν","nu"],["ξ","xi"],["ο","omicron"],["π","pi"],["ρ","rho"],["ς","sigmaf"],["σ","sigma"],["τ","tau"],["υ","upsilon"],["φ","phi"],["χ","chi"],["ψ","psi"],["ω","omega"],["ϑ","thetasym"],["ϒ","upsih"],["ϖ","piv"],["•","bull"],["…","hellip"],["′","prime"],["″","Prime"],["‾","oline"],["⁄","frasl"],["℘","weierp"],["ℑ","image"],["ℜ","real"],["™","trade"],["ℵ","alefsym"],["←","larr"],["↑","uarr"],["→","rarr"],["↓","darr"],["↔","harr"],["↵","crarr"],["⇐","lArr"],["⇑","uArr"],["⇒","rArr"],["⇓","dArr"],["⇔","hArr"],["∀","forall"],["∂","part"],["∃","exist"],["∅","empty"],["∇","nabla"],["∈","isin"],["∉","notin"],["∋","ni"],["∏","prod"],["∑","sum"],["−","minus"],["∗","lowast"],["√","radic"],["∝","prop"],["∞","infin"],["∠","ang"],["∧","and"],["∨","or"],["∩","cap"],["∪","cup"],["∫","int"],["∴","there4"],["∼","sim"],["≅","cong"],["≈","asymp"],["≠","ne"],["≡","equiv"],["≤","le"],["≥","ge"],["⊂","sub"],["⊃","sup"],["⊄","nsub"],["⊆","sube"],["⊇","supe"],["⊕","oplus"],["⊗","otimes"],["⊥","perp"],["⋅","sdot"],["⌈","lceil"],["⌉","rceil"],["⌊","lfloor"],["⌋","rfloor"],["〈","lang"],["〉","rang"],["◊","loz"],["♠","spades"],["♣","clubs"],["♥","hearts"],["♦","diams"],["Œ","Elig"],["œ","oelig"],["Š","Scaron"],["š","scaron"],["Ÿ","Yuml"],["ˆ","circ"],["˜","tilde"],[" ","ensp"],[" ","emsp"],[" ","thinsp"],["‌","zwnj"],["‍","zwj"],["‎","lrm"],["‏","rlm"],["–","ndash"],["—","mdash"],["‘","lsquo"],["’","rsquo"],["‚","sbquo"],["“","ldquo"],["”","rdquo"],["„","bdquo"],["†","dagger"],["‡","Dagger"],["‰","permil"],["‹","lsaquo"],["›","rsaquo"]];
dhe.encode=function(str,m){
if(str){
if(!m){
str=_166c(str,dhe.html);
str=_166c(str,dhe.latin);
}else{
str=_166c(str,m);
}
}
return str;
};
dhe.decode=function(str,m){
if(str){
if(!m){
str=_166f(str,dhe.html);
str=_166f(str,dhe.latin);
}else{
str=_166f(str,m);
}
}
return str;
};
return dhe;
});
},"davinci/ui/Download":function(){
require({cache:{"url:davinci/ui/templates/download.html":"<div class='downloadDialog'>\t \n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div style=\"margin-bottom: 20px\">\n\t\t  ${fileName}: <input data-dojo-type='dijit/form/ValidationTextBox' type=\"text\" maxLength='${_fileNameMaxLength}' data-dojo-attach-point=\"__fileName\" value='${_projectName}.zip' data-dojo-props=\"regExp:'${_fileNameValidationRegExp}', required:true, invalidMessage:'${invalidDownloadFileName}'\"></input>\n\t\t</div>\n\t\t\n\t\t<div data-dojo-attach-point=\"_selectionDiv\"></div>\n\t\t<div data-dojo-attach-point=\"_tableDiv\"></div>\n\n\t\t<div style=\"margin-top: 8px\">\n\t\t  Select: <a href=\"javascript:;\" data-dojo-attach-event=\"onclick: _selectAll\">${selectAll}</a> / <a href=\"javascript:;\" data-dojo-attach-event=\"onclick: _selectNone\">${selectNone}</a>\n\t\t</div>\n\n\t\t<div style=\"margin-top: 20px\">\n\t\t\t<input data-dojo-type='dijit/form/CheckBox' type=\"text\" data-dojo-attach-point=\"__fullSource\" data-dojo-props=\"\"></input><span style='padding-left: 3px;'>${downloadFullSource}</span>\n\t\t\t<br>\n\t\t\t<input data-dojo-type='dijit/form/CheckBox' type=\"text\" data-dojo-attach-point=\"__optimize\" data-dojo-props=\"\"></input><span style='padding-left: 3px;'>${optimizeOption}</span>\n\t\t</div>\n  </div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-point=\"_okButton\" data-dojo-attach-event='onClick:okButton' label='${downloadButtonLabel}' class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-event='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>"}});
define("davinci/ui/Download",["dojo/_base/declare","dijit/_TemplatedMixin","dijit/_WidgetBase","dijit/_WidgetsInTemplateMixin","davinci/library","system/resource","dojo/promise/all","dojo/parser","davinci/Workbench","davinci/ve/RebaseDownload","dojo/i18n!./nls/ui","dojo/i18n!dijit/nls/common","dojo/text!./templates/download.html","davinci/Theme","dijit/form/Button","dijit/form/ValidationTextBox","dijit/form/TextBox"],function(_1672,_1673,_1674,_1675,_1676,_1677,all,_1678,_1679,_167a,uiNLS,_167b,_167c,Theme){
return _1672([_1674,_1673,_1675],{templateString:_167c,_fileNameValidationRegExp:"[a-zA-z0-9_.]+",_fileNameMaxLength:50,postMixInProperties:function(){
this._projectName=_1679.getProject();
dojo.mixin(this,uiNLS);
dojo.mixin(this,_167b);
this.inherited(arguments);
},buildRendering:function(){
this.inherited(arguments);
this._buildUITable();
},_buildUITable:function(){
this._handles=[];
this._userLibs=_1676.getUserLibs(this.getRoot());
var _167d=[dojo.replace("<table cellspacing='0' cellpadding='0' width='100%' class='dwnloadLibTable'><tr><td class='header'>{library}</td><td class='header'>{version}</td><td class='header'>{include}<br>{source}</td><td class='header'>{baseLocation}</td></tr><tr><td colspan='4'><hr></hr></td></tr>",uiNLS)];
this.libraries={};
this._userLibs.forEach(function(_167e,i){
_167e.initRoot=this._getLibRoot(_167e.id,_167e.version);
var name=_167e.id;
if(!_167e.initRoot){
return;
}
_167d.push("<tr libPath='"+i+"'");
if(_167e.required){
_167d.push(" style='display:none'");
}
_167d.push(">");
_167d=_167d.concat(["<td class='columna'>"+name+"</td>","<td class='columnb'>"+_167e.version+"</td>","<td class='columnc'><input type='checkbox' data-dojo-type='dijit/form/CheckBox' checked></input></td>","<td class='columnd'><input type='text' data-dojo-type='dijit/form/TextBox' value='"+_167e.initRoot+"'></input></td>","</tr>"]);
},this);
_167d.push("</table>");
dojo.place(_167d.join(""),this._tableDiv);
_1678.parse(this._tableDiv);
},_getLibRoot:function(id,_167f){
var root=undefined;
this._userLibs.some(function(lib){
if(lib.id==id&&lib.version==_167f){
root=lib.root;
return true;
}
});
return root;
},_getLibs:function(){
return dojo.query("tr[libPath]",this.domNode).map(function(row){
var _1680=dijit.byNode(dojo.query(".dijitTextBox",row)[0]),_1681=dijit.byNode(dojo.query(".dijitCheckBox",row)[0]),_1682=parseInt(dojo.attr(row,"libPath")),value=_1681.get("checked"),_1683=_1680.get("value")||this._userLibs[_1682].root;
return {id:this._userLibs[_1682].id,version:this._userLibs[_1682].version,root:_1683,includeSrc:value};
},this);
},getRoot:function(){
if(_1679.singleProjectMode()){
return _1679.getProject();
}
},_getResources:function(){
return [_1679.getProject()];
},_rewriteUrls:function(){
var _1684=[];
this._getResources().forEach(function(file){
var _1685=_1677.findResource(file);
if(_1685.elementType=="Folder"){
_1684=_1684.concat(_1677.findResource("*.html",true,_1685,true));
}else{
if(_1685.extension=="html"){
_1684.push(_1685);
}
}
});
var _1686=new _167a(this._getLibs());
var _1687=_1684.filter(function(res){
return !Theme.isThemeHTML(res);
}).map(function(res){
return _1686.rebuildSource(res.getContentSync(),res).then(function(_1688){
res.setContents(_1688,true);
});
});
return all(_1687);
},_select:function(value){
dojo.query("tr[libPath]",this.domNode).forEach(function(row){
var _1689=dijit.byNode(dojo.query(".dijitCheckBox",row)[0]);
if(_1689){
_1689.set("checked",value);
}
});
return false;
},_selectAll:function(){
this._select(true);
},_selectNone:function(){
this._select(false);
},okButton:function(){
if(this.__fileName.isValid()){
var _168a=dojo.attr(this.__fileName,"value");
if(_168a.slice(-4)!=".zip"){
_168a+=".zip";
}
this._rewriteUrls().then(function(){
var _168b=this._getLibs().filter(function(lib){
return lib.includeSrc;
});
var _168c={};
if(this.__optimize&&this.__optimize.getValue()){
_168c.build="1";
}
if(this.__fullSource&&this.__fullSource.getValue()){
_168c.fullsource="1";
}
setTimeout(function(){
_1677.download(this._getResources(),_168a,this.getRoot(),_168b,_168c);
}.bind(this),300);
}.bind(this));
}
},cancelButton:function(){
this.cancel=true;
this.onClose();
}});
});
},"davinci/ve/widgets/FontDataStore":function(){
define(["dojo/_base/declare","dojo/data/ItemFileReadStore","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common"],function(_168d,_168e){
var _168f=_168d("davinci.ve.widgets.FontDataStore",_168e,{_allValues:[],constructor:function(args){
this.setValues(args.values||davinci.ve.widgets.FontDataStore.fonts);
},setValues:function(_1690){
this._allValues=this._allValues.concat(_1690);
this._jsonData={label:"name",identifier:"value",items:this._allValues};
this._loadFinished=false;
},contains:function(value){
for(var i=0;i<this._allValues.length;i++){
if(this._allValues[i].value==value){
return i;
}
if(this._allValues[i].name==value){
return i;
}
}
return false;
},clearValues:function(){
this._allValues=[];
this._loadFinished=false;
},lookupValue:function(_1691){
var index=this.contains(_1691);
return this._allValues[index].value[0];
}});
return dojo.mixin(_168f,{fonts:[{name:"",value:""},{name:"Arial,Helvetica,sans-serif",value:"Arial,Helvetica,sans-serif"},{name:"'Arial Black,Gadget',sans-serif",value:"'Arial Black,Gadget',sans-serif"},{name:"'Comic Sans MS',cursive",value:"'Comic Sans MS',cursive"},{name:"'Courier New',Courier,monospace",value:"'Courier New',Courier,monospace"},{name:"Geneva,Tahoma,sans-serif",value:"Geneva,Tahoma,sans-serif"},{name:"Georgia,serif",value:"Georgia,serif"},{name:"'Helvetica,Trebuchet MS',sans-serif",value:"'Helvetica,Trebuchet MS',sans-serif"},{name:"Impact,Charcoal,sans-serif",value:"Impact,Charcoal,sans-serif"},{name:"'Lucida Console',Monaco,monospace",value:"'Lucida Console',Monaco,monospace"},{name:"'Lucida Sans Unicode','Lucida Grande',sans-serif",value:"'Lucida Sans Unicode','Lucida Grande',sans-serif"},{name:"'Lucida Console', Monaco, monospace",value:"'Lucida Console', Monaco, monospace"},{name:"'Palatino Linotype','Book Antiqua',Palatino,serif",value:"'Palatino Linotype','Book Antiqua',Palatino,serif"},{name:"Symbol",value:"Symbol"},{name:"Tahoma,Geneva,sans-serif",value:"Tahoma,Geneva,sans-serif"},{name:"'Times New Roman',Times,serif",value:"'Times New Roman',Times,serif"},{name:"'Trebuchet MS',Helvetica,sans-serif",value:"'Trebuchet MS',Helvetica,sans-serif"},{name:"Verdana,Geneva,sans-serif",value:"Verdana,Geneva,sans-serif"},{name:"Webdings",value:"Webdings"},{name:"Wingdings, 'Zapf Dingbats'",value:"Wingdings, 'Zapf Dingbats'"},{name:"'Zapf Dingbats', Wingdings",value:"'Zapf Dingbats', Wingdings"},{name:"sans-serif",value:"sans-serif"},{name:"serif",value:"serif"},{name:"monospace",value:"monospace"},{name:"cursive",value:"cursive"}]});
});
},"preview/loadIndicator":function(){
define("preview/loadIndicator",["dojo/dom-class","dojo/dom-construct","dojo/on"],function(_1692,_1693,on){
return function(win,icon,color){
var _1694;
return [on(win,"DOMContentLoaded",function(e){
var win=e.currentTarget,_1695=e.target;
if(win["require"]){
_1692.add(_1695.body,"loading");
_1694=_1693.create("style",null,_1695.head);
_1694.innerText=".loading{background: url('"+icon+"') no-repeat center "+color+"}";
win["require"](["dojo/ready"],function(){
_1692.remove(_1695.body,"loading");
_1694.parentNode.removeChild(_1694);
});
}
}),on(win,"error",function(e){
var _1696="An error has occurred while previewing "+e.filename+": "+e.message;
console.error(_1696);
if(_1694){
_1694.parentNode.removeChild(_1694);
}
})];
};
});
},"dijit/DialogUnderlay":function(){
define("dijit/DialogUnderlay",["dojo/_base/declare","dojo/dom-attr","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe"],function(_1697,_1698,_1699,_169a,_169b,_169c){
return _1697("dijit.DialogUnderlay",[_169a,_169b],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_setDialogIdAttr:function(id){
_1698.set(this.node,"id",id+"_underlay");
this._set("dialogId",id);
},_setClassAttr:function(clazz){
this.node.className="dijitDialogUnderlay "+clazz;
this._set("class",clazz);
},postCreate:function(){
this.ownerDocumentBody.appendChild(this.domNode);
},layout:function(){
var is=this.node.style,os=this.domNode.style;
os.display="none";
var _169d=_1699.getBox(this.ownerDocument);
os.top=_169d.t+"px";
os.left=_169d.l+"px";
is.width=_169d.w+"px";
is.height=_169d.h+"px";
os.display="block";
},show:function(){
this.domNode.style.display="block";
this.layout();
this.bgIframe=new _169c(this.domNode);
},hide:function(){
this.bgIframe.destroy();
delete this.bgIframe;
this.domNode.style.display="none";
}});
});
},"davinci/ve/ThemeModifier":function(){
define(["dojo/_base/declare","../model/Path","../model/Factory","./utils/URLRewrite","./commands/ModifyRuleCommand","./commands/StyleCommand","dojo/i18n!davinci/ve/nls/common","system/resource"],function(_169e,Path,_169f,_16a0,_16a1,_16a2,_16a3,_16a4){
return _169e("davinci.ve.ThemeModifier",null,{_getCssFiles:function(){
if(this.cssFiles){
return this.cssFiles;
}
this.cssFiles=[];
if(this.themeCssFiles){
var _16a5=this._themePath.getParentPath();
this.cssFiles=this.themeCssFiles.map(function(_16a6){
return _169f.getModel({url:_16a5.append(_16a6).toString(),includeImports:true,});
});
}
return this.cssFiles;
},_getThemeResource:function(_16a7){
var _16a8=this._themePath.getParentPath().append(_16a7).toString();
return system.resource.findResource(_16a8);
},getDeltaRule:function(rule){
var _16a9=null;
var _16aa=this.cssFiles[0];
var _16ab=rule.getSelectorText();
this.cssFiles.forEach(function(file){
var _16ac=file.getRules(_16ab);
if(_16ac.length>0){
_16aa=file;
}
_16ac.forEach(function(r){
if(r.parent.url==file.url){
_16a9=r;
}
}.bind(this));
}.bind(this));
if(!_16a9&&_16aa){
_16a9=_16aa.addRule(_16ab+" {}");
}
return _16a9;
},_markDirty:function(file,_16ad){
if(!this._dirtyResource){
this._dirtyResource={};
}
this._dirtyResource[file]={time:Date.now(),modelObject:_16ad};
this._srcChanged();
},getCommandForStyleChange:function(value){
var _16ae=this,_16af=_16ae.getSelection(),_16b0=_16af.length?_16af[_16af.length-1]:undefined;
if(_16af.length>1){
_16ae.select(_16b0);
}
var _16b1;
if(value.appliesTo=="inline"){
var _16b2=[];
var _16b3=new Path(this.fileName);
for(var i=0;i<value.values.length;i++){
for(var name in value.values[i]){
if(_16a0.containsUrl(value.values[i][name])&&!_16a0.isAbsolute(value.values[i][name])){
var _16b4=new Path(_16a0.getUrl(value.values[i][name]));
if(!_16b4.isAbsolute){
var _16b5=_16b4.relativeTo(_16b3).toString();
var _16b6=_16a0.replaceUrl(value.values[i][name],_16b5);
_16b2.push(a);
}else{
var a={};
a[name]=value.values[i][name];
_16b2.push(a);
}
}else{
var a={};
a[name]=value.values[i][name];
_16b2.push(a);
}
}
}
_16b1=new _16a2(_16b0,_16b2,value.applyToWhichStates);
}else{
var rule;
if(value.appliesTo.type=="proposal"){
var _16b7=_16ae.model.find({elementType:"CSSFile",relativeURL:value.appliesTo.targetFile},true);
if(!_16b7&&_16ae.cssFiles){
for(var i=0;_16ae.cssFiles.length;i++){
if(_16ae.cssFiles[i].url===value.appliesTo.targetFile){
_16b7=_16ae.cssFiles[i];
break;
}
}
if(!_16b7){
return;
}
}
rule=_16b7.addRule(value.appliesTo.ruleString+" {}");
}else{
rule=value.appliesTo.rule;
}
_16b1=new _16a1(rule,value.values,_16ae);
}
return _16b1;
},saveDynamicCssFiles:function(_16b8,_16b9){
var _16ba=[],_16bb={visit:function(node){
if(node.elementType=="CSSFile"&&node.isDirty()){
_16ba.push(node.save(_16b9).then(function(_16bc){
if(!_16b9){
_16a4.findResource(node.url).removeWorkingCopy();
}
node.dirtyResource=_16b9;
return node;
},function(error){
console.error(dojo.string.substitute(_16a3.errorSavingFile,[node.url,error]));
return error;
}));
}
return false;
}};
if(_16b8){
_16b8.forEach(function(file){
file.visit(_16bb);
});
}
return _16ba;
},dirtyDynamicCssFiles:function(_16bd){
var dirty=false;
var _16be={visit:function(node){
if(node.elementType=="CSSFile"&&node.isDirty()){
dirty=true;
}
return dirty;
}};
if(_16bd){
_16bd.forEach(function(file){
if(dirty){
return dirty;
}
file.visit(_16be);
});
}
return dirty;
},close:function(){
if(this.cssFiles){
this.cssFiles.forEach(function(file){
file.close();
require("davinci/model/Factory").closeModel(file);
}.bind(this));
}
delete this.cssFiles;
},destroy:function(){
this.close();
}});
});
},"url:davinci/review/widgets/templates/PublishWizard.html":"<div class='publishWizard'>\n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div class='steps'>\n\t\t\t<div dojoAttachPoint=\"navPage1\" dojoAttachEvent=\"onclick:select\" class=\"crumbs current sep\">\n\t\t\t\t<div dojoAttachPoint=\"navPage1Icon\" class=\"done\"></div>\n\t\t\t\t1.${generalInfo}\n\t\t\t</div>\n\t\t\t<div dojoAttachPoint=\"navPage2\" dojoAttachEvent=\"onclick:select\" class=\"crumbs sep\">\n\t\t\t\t<div dojoAttachPoint=\"navPage2Icon\" class=\"todo\"></div>\n\t\t\t\t2.${selectRevFiles}\n\t\t\t</div>\n\t\t\t<div dojoAttachPoint=\"navPage3\" dojoAttachEvent=\"onclick:select\" class=\"crumbs\">\n\t\t\t\t<div dojoAttachPoint=\"navPage3Icon\" class=\"todo\"></div>\n\t\t\t\t3.${addReviewers}\n\t\t\t</div>\n\t\t</div>\n\t\t<div dojoAttachPoint=\"reviewerStackContainer\" class='mainSection'>\n\t\t</div>\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page1Node\">\n\t\t\t<tr>\n\t\t\t\t<td><label for=\"versionTitle\">${title}:</label></td>\n\t\t\t\t<td><input dojoAttachPoint=\"versionTitle\"></input></td>\n\t\t\t\t<td><input dojoAttachPoint=\"receiveEmail\"></input><label class='emailLabel' for=\"receiveEmail\">${notifyMe}</label></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td valign=\"top\"><label for=\"descriptions\">${description}:</label></td>\n\t\t\t\t<td colspan=\"2\"><input dojoAttachPoint=\"descriptions\"></input></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><label>${windowSize}:</label></td>\n\t\t\t\t<td colspan=\"2\"><input dojoAttachPoint=\"desireWidth\"></input><label>*</label><input dojoAttachPoint=\"desireHeight\"/></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td><label for=\"dueDate\">${dueDate}:</label></td>\n\t\t\t\t<td><input dojoAttachPoint=\"dueDate\" /></td>\n\t\t\t\t<td class=\"review-tips\"><label>${leaveBlank}</label></td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page2Node\">\n\t\t\t<tr>\n\t\t\t\t<td>${availableFiles}:</td>\n\t\t\t\t<td></td>\n\t\t\t\t<td>${selectedFiles}:</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint=\"sourceTreeNode\" class='sourceTree'>\n\t\t\t\t\t\t\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<a href=\"javascript:void(0);\" dojoAttachEvent=\"onclick:addSelectFiles\"><img src=\"app/davinci/review/resources/img/forward_nav.gif\"/></a>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<div dojoAttachPoint=\"targetTreeNode\" class='sourceTree'>\n\t\t\t\t\t\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t</table>\n\t\t\n\t\t<table cellspacing=\"10\" dojoAttachPoint=\"page3Node\">\n\t\t\t<tr valign=\"top\">\n\t\t\t\t<td align=\"left\" rowspan=2><div class='reviewers'>${reviewers}:</div></td>\n\t\t\t\t<td colspan=2><div dojoAttachPoint=\"userGrid\" class='reviewerList'></div></td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td class='reviewerBox'>\n\t\t\t\t\t<div dojoAttachPoint=\"addReviewerCombox\"></div>\n\t\t\t\t</td>\n\t\t\t\t<td align=\"left\"><button dojoAttachPoint=\"addReviewerButton\"></button></td>\n\t\t\t</tr>\n\t\t</table>\n\t</div>\n\n\t\t<div class='dijitDialogPaneActionBar dialogButtonContainerOverride'>\n\t\t\t<div dojoAttachPoint=\"reviewMsg\" class=\"reviewMsg\"></div>\n\t\t\t<a class='cancelButton' href=\"javascript:void(0);\" dojoAttachEvent=\"onclick:onClose\">${buttonCancel}</a>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"saveDt\">${saveAsDraft}</button>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"prev\">&lt ${back}</button>\n\t\t\t<button class='maqSecondaryButton' dojoAttachPoint=\"next\">${next} &gt</button>\n\t\t\t<button class='maqPrimaryButton' dojoAttachPoint=\"invite\">${publishReview}</button>\n\t\t</div>\n</div>","dijit/form/_ToggleButtonMixin":function(){
define("dijit/form/_ToggleButtonMixin",["dojo/_base/declare","dojo/dom-attr"],function(_16bf,_16c0){
return _16bf("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){
var _16c1=this.checked;
this._set("checked",!_16c1);
var ret=this.inherited(arguments);
this.set("checked",ret?this.checked:_16c1);
return ret;
},_setCheckedAttr:function(value,_16c2){
this._set("checked",value);
var node=this.focusNode||this.domNode;
_16c0.set(node,"checked",!!value);
if(value){
node.setAttribute("checked","");
}else{
node.removeAttribute("checked");
}
node.setAttribute(this._aria_attr,String(value));
this._handleOnChange(value,_16c2);
},reset:function(){
this._hasBeenBlurred=false;
this.set("checked",this.params.checked||false);
}});
});
},"davinci/ve/GenericWidget":function(){
define(["dojo/_base/declare","./_Widget"],function(_16c3,_16c4){
return _16c3("davinci.ve.GenericWidget",_16c4,{isGenericWidget:true,constructor:function(_16c5,node,type,_16c6,_16c7){
dojo.attr(node,"dvwidget",type);
if(_16c7){
_16c7.addAttribute("dvwidget",type);
}
},buildRendering:function(){
this.containerNode=this.domNode;
if(this._params){
for(var name in this._params){
this.domNode.setAttribute(name,this._params[name]);
}
this._params=undefined;
}
},_getChildrenData:function(_16c8){
var _16c9=[];
var _16ca=this.domNode.childNodes;
for(var i=0;i<_16ca.length;i++){
var n=_16ca[i];
var d;
switch(n.nodeType){
case 1:
var w=require("davinci/ve/widget").byNode(n);
if(w){
d=w.getData(_16c8);
}
break;
case 3:
d=n.nodeValue.trim();
if(d&&_16c8.serialize){
d=davinci.html.escapeXml(d);
}
break;
case 8:
d="<!--"+n.nodeValue+"-->";
break;
}
if(d){
_16c9.push(d);
}
}
if(_16c9.length===0){
return undefined;
}
return _16c9;
},setProperties:function(_16cb){
var node=this.domNode;
for(var name in _16cb){
if(name==="style"){
dojo.style(node,_16cb[name]);
}else{
if(!_16cb[name]){
node.removeAttribute(name);
}else{
node[name]=_16cb[name];
}
}
}
this.inherited(arguments);
},_attr:function(name,value){
if(arguments.length>1){
this.domNode.setAttribute(name,value);
}else{
return this.domNode.getAttribute(name);
}
},getTagName:function(){
return this.domNode.nodeName.toLowerCase();
}});
});
},"orion/editor/editor":function(){
define("orion/editor/editor",["i18n!orion/editor/nls/messages","orion/editor/keyBinding","orion/editor/eventTarget","orion/editor/tooltip","orion/editor/annotations","orion/editor/util"],function(_16cc,_16cd,_16ce,_16cf,_16d0,util){
var _16d1;
var _16d2="orion.annotation.highlightError";
function _16d3(_16d4){
this._textViewFactory=_16d4.textViewFactory;
this._undoStackFactory=_16d4.undoStackFactory;
this._textDNDFactory=_16d4.textDNDFactory;
this._annotationFactory=_16d4.annotationFactory;
this._foldingRulerFactory=_16d4.foldingRulerFactory;
this._lineNumberRulerFactory=_16d4.lineNumberRulerFactory;
this._contentAssistFactory=_16d4.contentAssistFactory;
this._keyBindingFactory=_16d4.keyBindingFactory;
this._statusReporter=_16d4.statusReporter;
this._domNode=_16d4.domNode;
this._annotationStyler=null;
this._annotationModel=null;
this._annotationRuler=null;
this._lineNumberRuler=null;
this._overviewRuler=null;
this._foldingRuler=null;
this._dirty=false;
this._contentAssist=null;
this._title=null;
this._keyModes=[];
};
_16d3.prototype={destroy:function(){
this.uninstallTextView();
this._textViewFactory=this._undoStackFactory=this._textDNDFactory=this._annotationFactory=this._foldingRulerFactory=this._lineNumberRulerFactory=this._contentAssistFactory=this._keyBindingFactory=this._statusReporter=this._domNode=null;
},getAnnotationModel:function(){
return this._annotationModel;
},getAnnotationRuler:function(){
return this._annotationRuler;
},getAnnotationStyler:function(){
return this._annotationStyler;
},getFoldingRuler:function(){
return this._foldingRuler;
},getLineNumberRuler:function(){
return this._lineNumberRuler;
},getModel:function(){
var model=this._textView.getModel();
if(model.getBaseModel){
model=model.getBaseModel();
}
return model;
},getOverviewRuler:function(){
return this._overviewRuler;
},getTextView:function(){
return this._textView;
},getTitle:function(){
return this._title;
},getKeyModes:function(){
return this._keyModes;
},isDirty:function(){
return this._dirty;
},setAnnotationRulerVisible:function(_16d5){
if(this._annotationRulerVisible===_16d5){
return;
}
this._annotationRulerVisible=_16d5;
if(!this._annotationRuler){
return;
}
var _16d6=this._textView;
if(_16d5){
_16d6.addRuler(this._annotationRuler,0);
}else{
_16d6.removeRuler(this._annotationRuler);
}
},setFoldingRulerVisible:function(_16d7){
if(this._foldingRulerVisible===_16d7){
return;
}
this._foldingRulerVisible=_16d7;
if(!this._foldingRuler){
return;
}
var _16d8=this._textView;
if(!_16d8.getModel().getBaseModel){
return;
}
if(_16d7){
_16d8.addRuler(this._foldingRuler,100);
}else{
_16d8.removeRuler(this._foldingRuler);
}
},setDirty:function(dirty){
if(this._dirty===dirty){
return;
}
this._dirty=dirty;
this.onDirtyChanged({type:"DirtyChanged"});
},setLineNumberRulerVisible:function(_16d9){
if(this._lineNumberRulerVisible===_16d9){
return;
}
this._lineNumberRulerVisible=_16d9;
if(!this._lineNumberRuler){
return;
}
var _16da=this._textView;
if(_16d9){
_16da.addRuler(this._lineNumberRuler,1);
}else{
_16da.removeRuler(this._lineNumberRuler);
}
},setOverviewRulerVisible:function(_16db){
if(this._overviewRulerVisible===_16db){
return;
}
this._overviewRulerVisible=_16db;
if(!this._overviewRuler){
return;
}
var _16dc=this._textView;
if(_16db){
_16dc.addRuler(this._overviewRuler);
}else{
_16dc.removeRuler(this._overviewRuler);
}
},mapOffset:function(_16dd,_16de){
var _16df=this._textView;
var model=_16df.getModel();
if(model.getBaseModel){
_16dd=model.mapOffset(_16dd,_16de);
}
return _16dd;
},getCaretOffset:function(){
return this.mapOffset(this._textView.getCaretOffset());
},getSelection:function(){
var _16e0=this._textView;
var _16e1=_16e0.getSelection();
var model=_16e0.getModel();
if(model.getBaseModel){
_16e1.start=model.mapOffset(_16e1.start);
_16e1.end=model.mapOffset(_16e1.end);
}
return _16e1;
},getText:function(start,end){
var _16e2=this._textView;
var model=_16e2.getModel();
if(model.getBaseModel){
model=model.getBaseModel();
}
return model.getText(start,end);
},_expandOffset:function(_16e3){
var model=this._textView.getModel();
var _16e4=this._annotationModel;
if(!_16e4||!model.getBaseModel){
return;
}
var _16e5=_16e4.getAnnotations(_16e3,_16e3+1);
while(_16e5.hasNext()){
var _16e6=_16e5.next();
if(_16e6.type===_16d0.AnnotationType.ANNOTATION_FOLDING){
if(_16e6.expand){
_16e6.expand();
_16e4.modifyAnnotation(_16e6);
}
}
}
},setCaretOffset:function(_16e7){
var _16e8=this._textView;
var model=_16e8.getModel();
if(model.getBaseModel){
this._expandOffset(_16e7);
_16e7=model.mapOffset(_16e7,true);
}
_16e8.setCaretOffset(_16e7);
},setText:function(text,start,end){
var _16e9=this._textView;
var model=_16e9.getModel();
if(model.getBaseModel){
if(start!==undefined){
this._expandOffset(start);
start=model.mapOffset(start,true);
}
if(end!==undefined){
this._expandOffset(end);
end=model.mapOffset(end,true);
}
}
_16e9.setText(text,start,end);
},setFoldingEnabled:function(_16ea){
this.setFoldingRulerVisible(_16ea);
},setSelection:function(start,end,show){
var _16eb=this._textView;
var model=_16eb.getModel();
if(model.getBaseModel){
this._expandOffset(start);
this._expandOffset(end);
start=model.mapOffset(start,true);
end=model.mapOffset(end,true);
}
_16eb.setSelection(start,end,show);
},moveSelection:function(start,end,_16ec,focus){
end=end||start;
var _16ed=this._textView;
this.setSelection(start,end,false);
var _16ee=_16ed.getTopPixel();
var _16ef=_16ed.getBottomPixel();
var model=this.getModel();
var line=model.getLineAtOffset(start);
var _16f0=_16ed.getLinePixel(line);
if(_16f0<_16ee||_16f0>_16ef){
var _16f1=_16ef-_16ee;
var _16f2=Math.max(0,_16f0-Math.floor((_16f0<_16ee?3:1)*_16f1/4));
var a=new _16d1({node:_16ed,duration:300,curve:[_16ee,_16f2],onAnimate:function(x){
_16ed.setTopPixel(Math.floor(x));
},onEnd:function(){
_16ed.showSelection();
if(focus===undefined||focus){
_16ed.focus();
}
if(_16ec){
_16ec();
}
}});
a.play();
}else{
_16ed.showSelection();
if(focus===undefined||focus){
_16ed.focus();
}
if(_16ec){
_16ec();
}
}
},checkDirty:function(){
this.setDirty(!this._undoStack.isClean());
},reportStatus:function(_16f3,type,_16f4){
if(this._statusReporter){
this._statusReporter(_16f3,type,_16f4);
}
},_getTooltipInfo:function(x,y){
var _16f5=this._textView;
var _16f6=this.getAnnotationModel();
if(!_16f6){
return null;
}
var _16f7=this._annotationStyler;
if(!_16f7){
return null;
}
var _16f8=_16f5.getOffsetAtLocation(x,y);
if(_16f8===-1){
return null;
}
_16f8=this.mapOffset(_16f8);
var _16f9=_16f7.getAnnotationsByType(_16f6,_16f8,_16f8+1);
var _16fa=[];
for(var i=0;i<_16f9.length;i++){
if(_16f9[i].rangeStyle){
_16fa.push(_16f9[i]);
}
}
if(_16fa.length===0){
return null;
}
var pt=_16f5.convert({x:x,y:y},"document","page");
var info={contents:_16fa,anchor:"left",x:pt.x+10,y:pt.y+20};
return info;
},_highlightCurrentLine:function(_16fb,_16fc){
var _16fd=this._annotationModel;
if(!_16fd){
return;
}
var _16fe=this._textView;
var model=_16fe.getModel();
var _16ff=_16fc?model.getLineAtOffset(_16fc.start):-1;
var _1700=model.getLineAtOffset(_16fb.start);
var _1701=_16fb.start===_16fb.end;
var _1702=!_16fc||_16fc.start===_16fc.end;
var start=model.getLineStart(_1700);
var end=model.getLineEnd(_1700);
if(model.getBaseModel){
start=model.mapOffset(start);
end=model.mapOffset(end);
}
var _1703=this._currentLineAnnotation;
if(_16ff===_1700&&_1702&&_1701&&_1703&&_1703.start===start&&_1703.end===end){
return;
}
var _1704=_1703?[_1703]:null;
var add;
if(_1701){
var type=_16d0.AnnotationType.ANNOTATION_CURRENT_LINE;
_1703=_16d0.AnnotationType.createAnnotation(type,start,end);
add=[_1703];
}
this._currentLineAnnotation=_1703;
_16fd.replaceAnnotations(_1704,add);
},installTextView:function(){
this._textView=this._textViewFactory();
if(this._undoStackFactory){
this._undoStack=this._undoStackFactory.createUndoStack(this);
}
if(this._textDNDFactory){
this._textDND=this._textDNDFactory.createTextDND(this,this._undoStack);
}
if(this._contentAssistFactory){
var _1705=this._contentAssistFactory.createContentAssistMode(this);
this._keyModes.push(_1705);
this._contentAssist=_1705.getContentAssist();
}
var _1706=this,_1707=this._textView;
var self=this;
this._listener={onModelChanged:function(e){
self.checkDirty();
},onMouseOver:function(e){
self._listener.onMouseMove(e);
},onMouseMove:function(e){
var _1708=_16cf.Tooltip.getTooltip(_1707);
if(!_1708){
return;
}
_1708.setTarget({x:e.x,y:e.y,getTooltipInfo:function(){
return self._getTooltipInfo(this.x,this.y);
}});
},onMouseOut:function(_1709,e){
var _170a=_16cf.Tooltip.getTooltip(_1707);
if(!_170a){
return;
}
_170a.setTarget(null);
},onSelection:function(e){
self._updateCursorStatus();
self._highlightCurrentLine(e.newValue,e.oldValue);
}};
_1707.addEventListener("ModelChanged",this._listener.onModelChanged);
_1707.addEventListener("Selection",this._listener.onSelection);
_1707.addEventListener("MouseOver",this._listener.onMouseOver);
_1707.addEventListener("MouseOut",this._listener.onMouseOut);
_1707.addEventListener("MouseMove",this._listener.onMouseMove);
if(this._keyBindingFactory){
this._keyBindingFactory(this,this._keyModes,this._undoStack,this._contentAssist);
}
_1707.setKeyBinding(new _16cd.KeyBinding(27),"cancelMode");
_1707.setAction("cancelMode",function(){
var _170b=false;
for(var i=0;i<this._keyModes.length;i++){
if(this._keyModes[i].isActive()){
_170b=this._keyModes[i].cancel()||_170b;
}
}
return _170b;
}.bind(this),{name:_16cc.cancelMode});
_1707.setAction("lineUp",function(){
for(var i=0;i<this._keyModes.length;i++){
if(this._keyModes[i].isActive()){
return this._keyModes[i].lineUp();
}
}
return false;
}.bind(this));
_1707.setAction("lineDown",function(){
for(var i=0;i<this._keyModes.length;i++){
if(this._keyModes[i].isActive()){
return this._keyModes[i].lineDown();
}
}
return false;
}.bind(this));
_1707.setAction("enter",function(){
for(var i=0;i<this._keyModes.length;i++){
if(this._keyModes[i].isActive()){
return this._keyModes[i].enter();
}
}
return false;
}.bind(this));
var _170c=function(_170d,e){
if(_170d===undefined){
return;
}
if(_170d===-1){
return;
}
var view=this.getView();
var _170e=view.getModel();
var _170f=this.getAnnotationModel();
var _1710=_1706.mapOffset(_170e.getLineStart(_170d));
var _1711=_1706.mapOffset(_170e.getLineEnd(_170d));
var _1712=_170f.getAnnotations(_1710,_1711);
var _1713=null;
while(_1712.hasNext()){
var _1714=_1712.next();
if(_1714.type===_16d0.AnnotationType.ANNOTATION_BOOKMARK){
_1713=_1714;
break;
}
}
if(_1713){
_170f.removeAnnotation(_1713);
}else{
_1713=_16d0.AnnotationType.createAnnotation(_16d0.AnnotationType.ANNOTATION_BOOKMARK,_1710,_1711);
_1713.title=undefined;
_170f.addAnnotation(_1713);
}
};
if(this._annotationFactory){
var _1715=_1707.getModel();
if(_1715.getBaseModel){
_1715=_1715.getBaseModel();
}
this._annotationModel=this._annotationFactory.createAnnotationModel(_1715);
if(this._annotationModel){
var _1716=this._annotationStyler=this._annotationFactory.createAnnotationStyler(_1707,this._annotationModel);
if(_1716){
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_CURRENT_SEARCH);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_MATCHING_SEARCH);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_ERROR);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_WARNING);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_MATCHING_BRACKET);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_CURRENT_BRACKET);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_CURRENT_LINE);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_READ_OCCURRENCE);
_1716.addAnnotationType(_16d0.AnnotationType.ANNOTATION_WRITE_OCCURRENCE);
_1716.addAnnotationType(_16d2);
}
}
_1707.annotationModel=this._annotationModel;
var _1717=this._annotationFactory.createAnnotationRulers(this._annotationModel);
var ruler=this._annotationRuler=_1717.annotationRuler;
if(ruler){
ruler.onClick=function(_1718,e){
if(_1718===undefined){
return;
}
if(_1718===-1){
return;
}
var view=this.getView();
var _1719=view.getModel();
var _171a=this.getAnnotationModel();
var _171b=_1706.mapOffset(_1719.getLineStart(_1718));
var _171c=_1706.mapOffset(_1719.getLineEnd(_1718));
var _171d=_171a.getAnnotations(_171b,_171c);
while(_171d.hasNext()){
var _171e=_171d.next();
if(!this.isAnnotationTypeVisible(_171e.type)){
continue;
}
var model=_1706.getModel();
_1706.onGotoLine(model.getLineAtOffset(_171b),_171e.start-_171b,_171e.end-_171b);
break;
}
};
ruler.onDblClick=_170c;
ruler.setMultiAnnotationOverlay({html:"<div class='annotationHTML overlay'></div>"});
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_ERROR);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_WARNING);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_TASK);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_BOOKMARK);
}
this.setAnnotationRulerVisible(true);
ruler=this._overviewRuler=_1717.overviewRuler;
if(ruler){
ruler.onClick=function(_171f,e){
if(_171f===undefined){
return;
}
var _1720=_1707.getModel().getLineStart(_171f);
_1706.moveSelection(_1706.mapOffset(_1720));
};
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_CURRENT_SEARCH);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_MATCHING_SEARCH);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_ERROR);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_WARNING);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_TASK);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_BOOKMARK);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_MATCHING_BRACKET);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_CURRENT_BRACKET);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_CURRENT_LINE);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_READ_OCCURRENCE);
ruler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_WRITE_OCCURRENCE);
}
this.setOverviewRulerVisible(true);
}
if(this._lineNumberRulerFactory){
this._lineNumberRuler=this._lineNumberRulerFactory.createLineNumberRuler(this._annotationModel);
this._lineNumberRuler.onDblClick=_170c;
this.setLineNumberRulerVisible(true);
}
if(this._foldingRulerFactory){
this._foldingRuler=this._foldingRulerFactory.createFoldingRuler(this._annotationModel);
this._foldingRuler.addAnnotationType(_16d0.AnnotationType.ANNOTATION_FOLDING);
this.setFoldingRulerVisible(false);
}
var _1721={type:"TextViewInstalled",textView:_1707};
this.dispatchEvent(_1721);
},uninstallTextView:function(){
var _1722=this._textView;
if(!_1722){
return;
}
_1722.destroy();
this._textView=this._undoStack=this._textDND=this._contentAssist=this._listener=this._annotationModel=this._annotationStyler=this._annotationRuler=this._overviewRuler=this._lineNumberRuler=this._foldingRuler=this._currentLineAnnotation=this._title=null;
this._dirty=false;
this._keyModes=[];
var _1723={type:"TextViewUninstalled",textView:_1722};
this.dispatchEvent(_1723);
},_updateCursorStatus:function(){
var model=this.getModel();
var _1724=this.getCaretOffset();
var _1725=model.getLineAtOffset(_1724);
var _1726=model.getLineStart(_1725);
var _1727=_1724-_1726;
for(var i=0;i<this._keyModes.length;i++){
var mode=this._keyModes[i];
if(mode.isActive()&&mode.isStatusActive&&mode.isStatusActive()){
return;
}
}
this.reportStatus(util.formatMessage(_16cc.lineColumn,_1725+1,_1727+1));
},showProblems:function(_1728){
var _1729=this._annotationModel;
if(!_1729){
return;
}
var _172a=[],add=[];
var model=_1729.getTextModel();
var _172b=_1729.getAnnotations(0,model.getCharCount()),_172c;
while(_172b.hasNext()){
_172c=_172b.next();
if(_172c.type===_16d0.AnnotationType.ANNOTATION_ERROR||_172c.type===_16d0.AnnotationType.ANNOTATION_WARNING){
_172a.push(_172c);
}
}
if(_1728){
for(var i=0;i<_1728.length;i++){
var _172d=_1728[i];
if(_172d){
var _172e=_172d.description.replace(/'/g,"&#39;").replace(/"/g,"&#34;");
var _172f=_172d.line-1;
var _1730=model.getLineStart(_172f);
var _1731=_172d.severity;
var type=_1731==="error"?_16d0.AnnotationType.ANNOTATION_ERROR:_16d0.AnnotationType.ANNOTATION_WARNING;
var start=_1730+_172d.start-1;
var end=_1730+_172d.end;
_172c=_16d0.AnnotationType.createAnnotation(type,start,end,_172e);
add.push(_172c);
}
}
}
_1729.replaceAnnotations(_172a,add);
},showOccurrences:function(_1732){
var _1733=this._annotationModel;
if(!_1733){
return;
}
var _1734=[],add=[];
var model=_1733.getTextModel();
var _1735=_1733.getAnnotations(0,model.getCharCount()),_1736;
while(_1735.hasNext()){
_1736=_1735.next();
if(_1736.type===_16d0.AnnotationType.ANNOTATION_READ_OCCURRENCE||_1736.type===_16d0.AnnotationType.ANNOTATION_WRITE_OCCURRENCE){
_1734.push(_1736);
}
}
if(_1732){
for(var i=0;i<_1732.length;i++){
var _1737=_1732[i];
if(_1737){
var _1738=_1737.line-1;
var _1739=model.getLineStart(_1738);
var start=_1739+_1737.start-1;
var end=_1739+_1737.end;
var type=_1737.readAccess===true?_16d0.AnnotationType.ANNOTATION_READ_OCCURRENCE:_16d0.AnnotationType.ANNOTATION_WRITE_OCCURRENCE;
var _173a=_1737.description;
_1736=_16d0.AnnotationType.createAnnotation(type,start,end,_173a);
add.push(_1736);
}
}
}
_1733.replaceAnnotations(_1734,add);
},showSelection:function(start,end,line,_173b,_173c){
if(typeof (start)==="number"){
if(typeof (end)!=="number"){
end=start;
}
this.moveSelection(start,end);
}else{
if(typeof (line)==="number"){
var model=this.getModel();
var pos=model.getLineStart(line-1);
if(typeof (_173b)==="number"){
pos=pos+_173b;
}
if(typeof (_173c)!=="number"){
_173c=0;
}
this.moveSelection(pos,pos+_173c);
}
}
},setInput:function(title,_173d,_173e,_173f){
this._title=title;
if(this._textView){
if(_173f){
this._undoStack.markClean();
this.checkDirty();
}else{
if(_173d){
this._textView.setText(_173d);
}else{
if(_173e!==null&&_173e!==undefined){
this._textView.setText(_173e);
this._textView.getModel().setLineDelimiter("auto");
this._highlightCurrentLine(this._textView.getSelection());
}
}
this._undoStack.reset();
this.checkDirty();
this._textView.focus();
}
}
this.onInputChanged({type:"InputChanged",title:title,message:_173d,contents:_173e,contentsSaved:_173f});
},onInputChanged:function(_1740){
return this.dispatchEvent(_1740);
},onGotoLine:function(line,_1741,end){
if(this._textView){
var model=this.getModel();
var _1742=model.getLineStart(line);
var start=0;
if(end===undefined){
end=0;
}
if(typeof _1741==="string"){
var index=model.getLine(line).indexOf(_1741);
if(index!==-1){
start=index;
end=start+_1741.length;
}
}else{
start=_1741;
var _1743=model.getLineEnd(line)-_1742;
start=Math.min(start,_1743);
end=Math.min(end,_1743);
}
this.moveSelection(_1742+start,_1742+end);
}
},onDirtyChanged:function(_1744){
return this.dispatchEvent(_1744);
}};
_16ce.EventTarget.addMixin(_16d3.prototype);
_16d1=(function(){
function _16d1(_1745){
this.options=_1745;
};
_16d1.prototype.play=function(){
var _1746=(typeof this.options.duration==="number")?this.options.duration:350,rate=(typeof this.options.rate==="number")?this.options.rate:20,_1747=this.options.easing||this.defaultEasing,_1748=this.options.onAnimate||function(){
},onEnd=this.options.onEnd||function(){
},start=this.options.curve[0],end=this.options.curve[1],range=(end-start);
var _1749,_174a,_174b=-1;
function _174c(){
_174b=(_174b===-1)?new Date().getTime():_174b;
var now=new Date().getTime(),_174d=(now-_174b)/_1746;
if(_174d<1){
var eased=_1747(_174d);
_1749=start+(eased*range);
_1748(_1749);
}else{
clearInterval(_174a);
onEnd();
}
};
_174a=setInterval(_174c,rate);
};
_16d1.prototype.defaultEasing=function(x){
return Math.sin(x*(Math.PI/2));
};
return _16d1;
}());
function bind(_174e){
var fn=this,fixed=Array.prototype.slice.call(arguments,1);
if(fixed.length){
return function(){
return arguments.length?fn.apply(_174e,fixed.concat(Array.prototype.slice.call(arguments))):fn.apply(_174e,fixed);
};
}
return function(){
return arguments.length?fn.apply(_174e,arguments):fn.call(_174e);
};
};
if(!Function.prototype.bind){
Function.prototype.bind=bind;
}
return {Editor:_16d3,util:{bind:bind}};
});
},"davinci/html/ui/HTMLOutline":function(){
define(["dojo/_base/declare","davinci/html/ui/HTMLOutlineModel"],function(_174f,_1750){
return _174f("davinci/html/ui/HTMLOutline",null,{constructor:function(model){
this._htmlModel=model;
},getModel:function(){
this._model=new _1750(this._htmlModel);
return this._model;
}});
});
},"dojo/store/util/SimpleQueryEngine":function(){
define("dojo/store/util/SimpleQueryEngine",["../../_base/array"],function(_1751){
return function(query,_1752){
switch(typeof query){
default:
throw new Error("Can not query with a "+typeof query);
case "object":
case "undefined":
var _1753=query;
query=function(_1754){
for(var key in _1753){
var _1755=_1753[key];
if(_1755&&_1755.test){
if(!_1755.test(_1754[key],_1754)){
return false;
}
}else{
if(_1755!=_1754[key]){
return false;
}
}
}
return true;
};
break;
case "string":
if(!this[query]){
throw new Error("No filter function "+query+" was found in store");
}
query=this[query];
case "function":
}
function _1756(array){
var _1757=_1751.filter(array,query);
var _1758=_1752&&_1752.sort;
if(_1758){
_1757.sort(typeof _1758=="function"?_1758:function(a,b){
for(var sort,i=0;sort=_1758[i];i++){
var _1759=a[sort.attribute];
var _175a=b[sort.attribute];
if(_1759!=_175a){
return !!sort.descending==(_1759==null||_1759>_175a)?-1:1;
}
}
return 0;
});
}
if(_1752&&(_1752.start||_1752.count)){
var total=_1757.length;
_1757=_1757.slice(_1752.start||0,(_1752.start||0)+(_1752.count||Infinity));
_1757.total=total;
}
return _1757;
};
_1756.matches=query;
return _1756;
};
});
},"davinci/actions/UserNameAction":function(){
define(["dojo/_base/declare","davinci/Runtime","./Action","dojo/i18n!davinci/ui/nls/ui"],function(_175b,_175c,_175d,uiNls){
return _175b("davinci.actions.UserNameAction",_175d,{run:function(){
},getName:function(){
var name=_175c.getUserDisplayName();
return uiNls.User+": "+"<i>"+name+"</i>";
}});
});
},"davinci/ve/commands/_hierarchyCommand":function(){
define(["dojo/_base/declare"],function(_175e){
return _175e("davinci.ve.commands._hierarchyCommand",null,{_isRefreshOnDescendantChange:function(_175f){
var _1760;
var w=_175f;
while(w&&w.domNode&&w.domNode.tagName!="BODY"){
var _1761=w.getParent();
if(_1761&&davinci.ve.metadata.queryDescriptor(_1761.type,"refreshOnDescendantChange")){
_1760=_1761;
}
w=_1761;
}
return _1760;
}});
});
},"url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:_onClick,onkeypress:_onButtonKeyPress\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeypress:_onArrowKeyPress\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t/></td></tr></tbody\n></table>\n","davinci/actions/SelectThemeAction":function(){
define(["dojo/_base/declare","./Action","../ui/widgets/ThemeSetSelection","../ve/commands/ChangeThemeCommand","dojo/i18n!davinci/actions/nls/actions","davinci/Workbench"],function(_1762,_1763,_1764,_1765,_1766,_1767){
return _1762("davinci.actions.SelectThemeAction",_1763,{run:function(_1768){
var e=davinci.Workbench.getOpenEditor();
if(e&&e.isDirty){
var _1769=e.getOnUnloadWarningMessage();
if(!_1769){
_1769=dojo.string.substitute(_1766.filesHasUnsavedChanges,[e.fileName]);
}
_1767.showDialog({title:_1766.switchingThemes,content:_1769,style:{width:300},okCallback:dojo.hitch(this,this._okToSwitch),okLabel:_1766.save,hideCancel:null});
}else{
this._okToSwitch();
}
},_okToSwitch:function(){
var e=davinci.Workbench.getOpenEditor();
if(e.isDirty){
e.save();
}
var theme=e.getContext().getTheme();
var _176a=e.getContext().getDojo().version.major+"."+e.getContext().getDojo().version.minor;
this._themeChooser=new _1764({value:theme,workspaceOnly:false,dojoVersion:_176a});
this._themeChooser.buildRendering();
},_changeTheme:function(){
var _176b=this._themeChooser.attr("value");
this._themeChooser.onClose();
this._themeChooser.destroy();
var e=davinci.Workbench.getOpenEditor();
if(e&&e.getContext){
e.getContext().getCommandStack().execute(new _1765(_176b,e.getContext()));
}
}});
});
},"url:dijit/templates/Tree.html":"<div class=\"dijitTree dijitTreeContainer\" role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n</div>\n","dojo/dnd/Manager":function(){
define("dojo/dnd/Manager",["../_base/array","../_base/declare","../_base/event","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(array,_176c,event,lang,win,_176d,_176e,has,keys,on,topic,touch,dnd,_176f,_1770){
var _1771=_176c("dojo.dnd.Manager",[_176e],{constructor:function(){
this.avatar=null;
this.source=null;
this.nodes=[];
this.copy=true;
this.target=null;
this.canDropFlag=false;
this.events=[];
},OFFSET_X:has("touch")?0:16,OFFSET_Y:has("touch")?-64:16,overSource:function(_1772){
if(this.avatar){
this.target=(_1772&&_1772.targetState!="Disabled")?_1772:null;
this.canDropFlag=Boolean(this.target);
this.avatar.update();
}
topic.publish("/dnd/source/over",_1772);
},outSource:function(_1773){
if(this.avatar){
if(this.target==_1773){
this.target=null;
this.canDropFlag=false;
this.avatar.update();
topic.publish("/dnd/source/over",null);
}
}else{
topic.publish("/dnd/source/over",null);
}
},startDrag:function(_1774,nodes,copy){
_176f.autoScrollStart(win.doc);
this.source=_1774;
this.nodes=nodes;
this.copy=Boolean(copy);
this.avatar=this.makeAvatar();
win.body().appendChild(this.avatar.node);
topic.publish("/dnd/start",_1774,nodes,this.copy);
this.events=[on(win.doc,touch.move,lang.hitch(this,"onMouseMove")),on(win.doc,touch.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",event.stop),on(win.body(),"selectstart",event.stop)];
var c="dojoDnd"+(copy?"Copy":"Move");
_176d.add(win.body(),c);
},canDrop:function(flag){
var _1775=Boolean(this.target&&flag);
if(this.canDropFlag!=_1775){
this.canDropFlag=_1775;
this.avatar.update();
}
},stopDrag:function(){
_176d.remove(win.body(),["dojoDndCopy","dojoDndMove"]);
array.forEach(this.events,function(_1776){
_1776.remove();
});
this.events=[];
this.avatar.destroy();
this.avatar=null;
this.source=this.target=null;
this.nodes=[];
},makeAvatar:function(){
return new _1770(this);
},updateAvatar:function(){
this.avatar.update();
},onMouseMove:function(e){
var a=this.avatar;
if(a){
_176f.autoScrollNodes(e);
var s=a.node.style;
s.left=(e.pageX+this.OFFSET_X)+"px";
s.top=(e.pageY+this.OFFSET_Y)+"px";
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
if(has("touch")){
e.preventDefault();
}
},onMouseUp:function(e){
if(this.avatar){
if(this.target&&this.canDropFlag){
var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));
topic.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);
topic.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);
}else{
topic.publish("/dnd/cancel");
}
this.stopDrag();
}
},onKeyDown:function(e){
if(this.avatar){
switch(e.keyCode){
case keys.CTRL:
var copy=Boolean(this.source.copyState(true));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
break;
case keys.ESCAPE:
topic.publish("/dnd/cancel");
this.stopDrag();
break;
}
}
},onKeyUp:function(e){
if(this.avatar&&e.keyCode==keys.CTRL){
var copy=Boolean(this.source.copyState(false));
if(this.copy!=copy){
this._setCopyStatus(copy);
}
}
},_setCopyStatus:function(copy){
this.copy=copy;
this.source._markDndStatus(this.copy);
this.updateAvatar();
_176d.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));
}});
dnd._manager=null;
_1771.manager=dnd.manager=function(){
if(!dnd._manager){
dnd._manager=new _1771();
}
return dnd._manager;
};
return _1771;
});
},"url:davinci/ve/newfile.template.html":"<!DOCTYPE html>\n<!--\n\tTODO: margin:0 is a temporary hack. In previous releases, we always included dojo.css\n\twhich set margin:0, but we now only include dojo.css with the first Dojo widget\n\tadded to the page. That causes scrollbars when page was loaded initially,\n\twhich went want when first Dojo widget was added.\n\tNeed to rethink this whole business of width:100%;height:100%;margin:0\n-->\n<html style=\"height: 100%; width: 100%; margin: 0;\">\n\t<head>\n\t\t<base href=\"{baseUrl}\"/>\n\t\t<meta charset=\"utf-8\"/>\n\t\t<script src=\"{dojoUrl}\" data-dojo-config=\"{dojoConfig}\" {additionalDojoAttrs}></script>\n\t\t<script>\n\t\t\t// base dependencies needed for VE\n\t\t\trequire([\n\t\t\t\t'dojo/parser',\n\t\t\t\t'dojox/html/_base',\n\t\t\t\t'dojo/domReady!'\n\t\t\t\t{additionalModules}\n\t\t\t], top.loading{id});\n\t\t</script>\n\t\t{themeHeadImports}\n\t\t{themeCssFiles}\n\t</head>\n\t<body>\n\t</body>\n</html>\n","url:davinci/ui/widgets/templates/projectToolbar.html":"<div class='projectToolbar'>\t \n\t<table cellSpacing=\"0\" cellPadding=\"0\" border=\"0\" style=\"width:100%\">\n\t<tr>\n\t<td width=\"100%\">\n\t<div class=\"projectSelection\" dojoType=\"davinci.ui.widgets.ProjectSelection\" dojoAttachPoint=\"_projectSelection\"></div>\n\t</td>\n\t</tr>\n\t</table>\n</div>","dojox/grid/DataSelection":function(){
define("dojox/grid/DataSelection",["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_1777,_1778,_1779){
return _1777("dojox.grid.DataSelection",_1779,{constructor:function(grid){
if(grid.keepSelection){
this.preserver=new _1778(this);
}
},destroy:function(){
if(this.preserver){
this.preserver.destroy();
}
},getFirstSelected:function(){
var idx=_1779.prototype.getFirstSelected.call(this);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getNextSelected:function(_177a){
var _177b=this.grid.getItemIndex(_177a);
var idx=_1779.prototype.getNextSelected.call(this,_177b);
if(idx==-1){
return null;
}
return this.grid.getItem(idx);
},getSelected:function(){
var _177c=[];
for(var i=0,l=this.selected.length;i<l;i++){
if(this.selected[i]){
_177c.push(this.grid.getItem(i));
}
}
return _177c;
},addToSelection:function(_177d){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _177d=="number"||typeof _177d=="string"){
idx=_177d;
}else{
idx=this.grid.getItemIndex(_177d);
}
_1779.prototype.addToSelection.call(this,idx);
},deselect:function(_177e){
if(this.mode=="none"){
return;
}
var idx=null;
if(typeof _177e=="number"||typeof _177e=="string"){
idx=_177e;
}else{
idx=this.grid.getItemIndex(_177e);
}
_1779.prototype.deselect.call(this,idx);
},deselectAll:function(_177f){
var idx=null;
if(_177f||typeof _177f=="number"){
if(typeof _177f=="number"||typeof _177f=="string"){
idx=_177f;
}else{
idx=this.grid.getItemIndex(_177f);
}
_1779.prototype.deselectAll.call(this,idx);
}else{
this.inherited(arguments);
}
}});
});
},"davinci/ve/widgets/EventSelection":function(){
define(["dojo/_base/declare","dojo/_base/connect","dojo/dom-class","system/resource","davinci/Runtime","davinci/Workbench","davinci/model/Path","../../workbench/Preferences","../../workbench/ViewLite","../commands/EventCommand","./HTMLStringUtil","../States"],function(_1780,_1781,_1782,_1783,_1784,_1785,Path,_1786,_1787,_1788,_1789,_178a){
var _178b="State:";
var _178c=new RegExp("^"+_178b+".*");
var _178d="davinci.states.setState";
var _178e=/^\s*davinci\.states\.setState\s*\(\s*([\'"])((?:(?!\1).)*)\1\s*\)\s*$/;
var _178f="File:";
var _1790=new RegExp("^"+_178f+".*");
var _1791="location.href";
var _1792=/^\s*location\.href\s*\=\s*([\'"])((?:(?!\1).)*)\1\s*$/;
var _1793=function(root){
var items=[""],_1794=[],_1795=root&&_178a.getAllStateContainers(root);
if(_1795){
_1794=_1795.reduce(function(_1796,_1797){
return _1796.concat(_178a.getStates(_1797));
},[]);
}
for(var i=0;i<_1794.length;i++){
var state=_1794[i];
var _1798=state=="Normal"?"Background":state;
var val=_178b+_1798;
if(items.indexOf(val)<0){
items.push(val);
}
}
var base=_1785.getProject();
var prefs=_1786.getPreferences("davinci.ui.ProjectPrefs",base);
if(prefs.webContentFolder!=null&&prefs.webContentFolder!=""){
var _1799=new Path(base).append(prefs.webContentFolder);
base=_1799.toString();
}
var _179a=_1783.findResource(base);
var _179b=new Path(base).append("samples");
var _179c=_1783.findResource(_179b.toString());
var _179d=new Path(base).append(prefs.themeFolder);
var _179e=_1783.findResource(_179d.toString());
var _179f=new Path(base).append(prefs.widgetFolder);
var _17a0=_1783.findResource(_179f.toString());
var _17a1=[];
function _17a2(_17a3){
_17a3.getChildren(function(_17a4){
for(var i=0;i<_17a4.length;i++){
var child=_17a4[i];
if(child.elementType=="Folder"){
if(!child._readOnly&&child!=_179c&&child!=_179e&&child!=_17a0){
_17a2(child);
}
}else{
if(/^html?$/i.test(child.extension)){
_17a1.push(child);
}
}
}
}.bind(_17a1),function(a,b){
console.error("EventSelection.js: folder.getChildren error");
});
};
_17a2(_179a);
var _17a5=_179a.getPath().toString()+"/";
for(var i=0;i<_17a1.length;i++){
var _17a6=_17a1[i];
var _17a7=_17a6.getPath().toString();
if(_17a7.indexOf(_17a5)==0){
_17a7=_17a7.substr(_17a5.length);
}
var val=_178f+_17a7;
if(items.indexOf(val)<0){
items.push(val);
}
}
return items;
};
var _17a8=function(value){
if(value&&value.match(_178c)){
var state=value.substring(_178b.length);
var _17a9=state=="Background"?"Normal":state;
value=_178d+"('"+_17a9+"')";
}
if(value&&value.match(_1790)){
value=_1791+"='"+value.substring(_178f.length)+"'";
}
return value;
};
var _17aa=function(value){
var match;
if(value){
match=value.match(_178e);
if(match){
var state=match[2];
value=_178b+state;
}
match=value.match(_1792);
if(match){
var _17ab=match[2];
value=_178f+_17ab;
}
}
return value;
};
var _17ac=_1780("davinci.ve.widgets.EventSelection",[_1787],{pageTemplate:[{display:"onclick",target:"onclick",type:"state",hideCascade:true},{display:"ondblclick",target:"ondblclick",type:"state",hideCascade:true},{display:"onmousedown",target:"onmousedown",type:"state",hideCascade:true},{display:"onmouseup",target:"onmouseup",type:"state",hideCascade:true},{display:"onmouseover",target:"onmouseover",type:"state",hideCascade:true},{display:"onmousemove",target:"onmousemove",type:"state",hideCascade:true},{display:"onmouseout",target:"onmouseout",type:"state",hideCascade:true},{display:"onkeypress",target:"onkeypress",type:"state",hideCascade:true},{display:"onkeydown",target:"onkeydown",type:"state",hideCascade:true},{display:"onkeyup",target:"onkeyup",type:"state",hideCascade:true},{display:"onfocus",target:"onfocus",type:"state",hideCascade:true},{display:"onblur",target:"onblur",type:"state",hideCascade:true},{display:"onchange",target:"onchange",type:"state",hideCascade:true}],buildRendering:function(){
this.domNode=dojo.doc.createElement("div");
this.domNode.innerHTML=_1789.generateTable(this.pageTemplate,{zeroSpaceForIncrDecr:true});
_1782.add(this.domNode,"EventSelection");
this.inherited(arguments);
},setReadOnly:function(_17ad){
for(var i=0;i<this.pageTemplate.length;i++){
var _17ae=this.pageTemplate[i].widget;
if(_17ae){
_17ae.set("readOnly",_17ad);
}else{
var node=this.pageTemplate[i].domNode;
if(node){
dojo.attr(node,"disabled",_17ad);
}
}
}
},startup:function(){
this.inherited(arguments);
function _17af(_17b0){
return function(){
return this._onChange({target:_17b0});
};
};
for(var i=0;i<this.pageTemplate.length;i++){
var box=dijit.byId(this.pageTemplate[i].id);
this.pageTemplate[i].widget=box;
_1781.connect(box,"onChange",this,_17af(i));
}
this._buildSelectionValues();
_1781.subscribe("/davinci/ui/context/loaded",dojo.hitch(this,this._buildSelectionValues));
_1781.subscribe("/davinci/states/stored",dojo.hitch(this,this._buildSelectionValues));
_1781.subscribe("/davinci/states/state/added",dojo.hitch(this,this._buildSelectionValues));
_1781.subscribe("/davinci/states/state/removed",dojo.hitch(this,this._updateValues));
_1781.subscribe("/davinci/states/state/renamed",dojo.hitch(this,this._updateValues));
_1781.subscribe("/davinci/ui/widgetPropertiesChanged",dojo.hitch(this,this._widgetPropertiesChanged));
this.setReadOnly(true);
},onEditorSelected:function(){
if(!this._editor||!this._editor.supports("states")){
delete this._editor;
}
this._buildSelectionValues();
},_onChange:function(a){
var index=a.target;
var _17b1=dijit.byId(this.pageTemplate[index].id);
var value=_17b1.get("value");
value=_17a8(value);
var _17b2={};
_17b2[this.pageTemplate[index].target]=value;
var _17b3=new _1788(this._widget,_17b2);
dojo.publish("/davinci/ui/widgetPropertiesChanges",[{source:this._editor.editor_id,command:_17b3}]);
},_getRoot:function(){
var _17b4=this._editor,root;
if(_17b4&&_17b4.getContext){
var _17b5=_17b4.getContext();
root=_17b5&&_17b5.rootNode;
}
return root;
},_updateValues:function(e){
if(!e||!e.node||!e.node._dvWidget){
return;
}
var _17b6=e.node._dvWidget.getContext();
var _17b7=(_17b6&&_17b6.editor);
if(!_17b7||_17b7!=_1784.currentEditor){
return;
}
this._buildSelectionValues();
if(this._widget){
this._setValues();
}
},onWidgetSelectionChange:function(){
if(!this._widget){
this.setReadOnly(true);
this._clearValues();
return;
}else{
this._setValues();
this.setReadOnly(false);
}
},_clearValues:function(){
for(var i=0;i<this.pageTemplate.length;i++){
var box=dijit.byId(this.pageTemplate[i].id);
box.set("value","",false);
}
},_buildSelectionValues:function(){
var root=this._getRoot();
var items=_1793(root);
for(var i=0;i<this.pageTemplate.length;i++){
var box=dijit.byId(this.pageTemplate[i].id);
box.store.clearValues();
box.store.setValues(items);
}
},_setValues:function(){
for(var i=0;i<this.pageTemplate.length;i++){
var name=this.pageTemplate[i].target;
var _17b8=this._widget;
var value="";
if(_17b8.properties&&_17b8.properties[name]){
value=_17b8.properties[name];
}else{
value=_17b8._srcElement.getAttribute(name);
}
value=_17aa(value);
var box=dijit.byId(this.pageTemplate[i].id);
if(box){
box.set("value",value,false);
}
}
},_widgetPropertiesChanged:function(data){
this._updateValues({widget:data[0]});
}});
_17ac.getEventSelectionValues=_1793;
_17ac.getEventScriptFromValue=_17a8;
_17ac.getValueFromEventScript=_17aa;
return _17ac;
});
},"dijit/form/_TextBoxMixin":function(){
define("dijit/form/_TextBoxMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(array,_17b9,dom,event,keys,lang,on,dijit){
var _17ba=_17b9("dijit.form._TextBoxMixin",null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){
return this.parse(this.get("displayedValue"),this.constraints);
},_setValueAttr:function(value,_17bb,_17bc){
var _17bd;
if(value!==undefined){
_17bd=this.filter(value);
if(typeof _17bc!="string"){
if(_17bd!==null&&((typeof _17bd!="number")||!isNaN(_17bd))){
_17bc=this.filter(this.format(_17bd,this.constraints));
}else{
_17bc="";
}
}
}
if(_17bc!=null&&((typeof _17bc)!="number"||!isNaN(_17bc))&&this.textbox.value!=_17bc){
this.textbox.value=_17bc;
this._set("displayedValue",this.get("displayedValue"));
}
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,_17bc);
}
this.inherited(arguments,[_17bd,_17bb]);
},displayedValue:"",_getDisplayedValueAttr:function(){
return this.filter(this.textbox.value);
},_setDisplayedValueAttr:function(value){
if(value==null){
value="";
}else{
if(typeof value!="string"){
value=String(value);
}
}
this.textbox.value=value;
this._setValueAttr(this.get("value"),undefined);
this._set("displayedValue",this.get("displayedValue"));
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,value);
}
},format:function(value){
return value==null?"":(value.toString?value.toString():value);
},parse:function(value){
return value;
},_refreshState:function(){
},onInput:function(){
},__skipInputEvent:false,_onInput:function(evt){
if(this.textDir=="auto"){
this.applyTextDir(this.focusNode,this.focusNode.value);
}
this._processInput(evt);
},_processInput:function(evt){
this._refreshState();
this._set("displayedValue",this.get("displayedValue"));
},postCreate:function(){
this.textbox.setAttribute("value",this.textbox.value);
this.inherited(arguments);
var _17be=function(e){
var _17bf;
if(e.type=="keydown"){
_17bf=e.keyCode;
switch(_17bf){
case keys.SHIFT:
case keys.ALT:
case keys.CTRL:
case keys.META:
case keys.CAPS_LOCK:
case keys.NUM_LOCK:
case keys.SCROLL_LOCK:
return;
}
if(!e.ctrlKey&&!e.metaKey&&!e.altKey){
switch(_17bf){
case keys.NUMPAD_0:
case keys.NUMPAD_1:
case keys.NUMPAD_2:
case keys.NUMPAD_3:
case keys.NUMPAD_4:
case keys.NUMPAD_5:
case keys.NUMPAD_6:
case keys.NUMPAD_7:
case keys.NUMPAD_8:
case keys.NUMPAD_9:
case keys.NUMPAD_MULTIPLY:
case keys.NUMPAD_PLUS:
case keys.NUMPAD_ENTER:
case keys.NUMPAD_MINUS:
case keys.NUMPAD_PERIOD:
case keys.NUMPAD_DIVIDE:
return;
}
if((_17bf>=65&&_17bf<=90)||(_17bf>=48&&_17bf<=57)||_17bf==keys.SPACE){
return;
}
var named=false;
for(var i in keys){
if(keys[i]===e.keyCode){
named=true;
break;
}
}
if(!named){
return;
}
}
}
_17bf=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;
if(!_17bf){
_17bf=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;
}
if(!_17bf){
_17bf=229;
}
if(e.type=="keypress"){
if(typeof _17bf!="string"){
return;
}
if((_17bf>="a"&&_17bf<="z")||(_17bf>="A"&&_17bf<="Z")||(_17bf>="0"&&_17bf<="9")||(_17bf===" ")){
if(e.ctrlKey||e.metaKey||e.altKey){
return;
}
}
}
if(e.type=="input"){
if(this.__skipInputEvent){
this.__skipInputEvent=false;
return;
}
}else{
this.__skipInputEvent=true;
}
var faux={faux:true},attr;
for(attr in e){
if(attr!="layerX"&&attr!="layerY"){
var v=e[attr];
if(typeof v!="function"&&typeof v!="undefined"){
faux[attr]=v;
}
}
}
lang.mixin(faux,{charOrCode:_17bf,_wasConsumed:false,preventDefault:function(){
faux._wasConsumed=true;
e.preventDefault();
},stopPropagation:function(){
e.stopPropagation();
}});
if(this.onInput(faux)===false){
faux.preventDefault();
faux.stopPropagation();
}
if(faux._wasConsumed){
return;
}
this.defer(function(){
this._onInput(faux);
});
};
this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_17be)));
},_blankValue:"",filter:function(val){
if(val===null){
return this._blankValue;
}
if(typeof val!="string"){
return val;
}
if(this.trim){
val=lang.trim(val);
}
if(this.uppercase){
val=val.toUpperCase();
}
if(this.lowercase){
val=val.toLowerCase();
}
if(this.propercase){
val=val.replace(/[^\s]+/g,function(word){
return word.substring(0,1).toUpperCase()+word.substring(1);
});
}
return val;
},_setBlurValue:function(){
this._setValueAttr(this.get("value"),true);
},_onBlur:function(e){
if(this.disabled){
return;
}
this._setBlurValue();
this.inherited(arguments);
},_isTextSelected:function(){
return this.textbox.selectionStart!=this.textbox.selectionEnd;
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
if(this.selectOnClick&&by=="mouse"){
this._selectOnClickHandle=this.connect(this.domNode,"onmouseup",function(){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
if(!this._isTextSelected()){
_17ba.selectInputText(this.textbox);
}
});
this.defer(function(){
if(this._selectOnClickHandle){
this.disconnect(this._selectOnClickHandle);
this._selectOnClickHandle=null;
}
},500);
}
this.inherited(arguments);
this._refreshState();
},reset:function(){
this.textbox.value="";
this.inherited(arguments);
},_setTextDirAttr:function(_17c0){
if(!this._created||this.textDir!=_17c0){
this._set("textDir",_17c0);
this.applyTextDir(this.focusNode,this.focusNode.value);
}
}});
_17ba._setSelectionRange=dijit._setSelectionRange=function(_17c1,start,stop){
if(_17c1.setSelectionRange){
_17c1.setSelectionRange(start,stop);
}
};
_17ba.selectInputText=dijit.selectInputText=function(_17c2,start,stop){
_17c2=dom.byId(_17c2);
if(isNaN(start)){
start=0;
}
if(isNaN(stop)){
stop=_17c2.value?_17c2.value.length:0;
}
try{
_17c2.focus();
_17ba._setSelectionRange(_17c2,start,stop);
}
catch(e){
}
};
return _17ba;
});
},"davinci/html/CSSImport":function(){
define(["dojo/_base/declare","davinci/html/CSSElement","davinci/model/Path","davinci/html/CSSFile"],function(_17c3,_17c4,Path,_17c5){
return _17c3("davinci.html.CSSImport",_17c4,{constructor:function(){
this.elementType="CSSImport";
},getCSSFile:function(){
return this.parent;
},setUrl:function(url){
this.url=url;
},visit:function(_17c6){
if(!_17c6.visit(this)){
for(var i=0;i<this.children.length;i++){
this.children[i].visit(_17c6);
}
if(this.cssFile){
this.cssFile.visit(_17c6);
}
}
if(_17c6.endVisit){
_17c6.endVisit(this);
}
},getText:function(_17c7){
s="@import ";
if(this.isURL){
s+="url(\""+this.url+"\");";
}else{
s+="\""+this.url+"\";";
}
return s;
},close:function(_17c8){
require("davinci/model/Factory").closeModel(this.cssFile);
if(this.connection){
dojo.disconnect(this.connection);
}
delete this.connection;
},load:function(_17c9){
var p=this.parent;
while(p&&!(p.url||p.fileName)){
p=p.parent;
}
var path=new Path(p.url||p.fileName);
path=path.getParentPath().append(this.url);
var myUrl=path.toString();
this.cssFile=require("davinci/model/Factory").getModel({url:myUrl,loader:this.parent.loader,includeImports:this.parent.includeImports||_17c9});
this.cssFile.relativeURL=this.url;
this.connection=dojo.connect(this.cssFile,"onChange",this.parent,"onChange");
}});
});
},"davinci/ui/ProjectTemplates":function(){
define(["dojo/_base/declare","dojo/request/xhr","davinci/Runtime","davinci/Workbench"],function(_17ca,xhr,_17cb,_17cc){
var _17cd={getIncremental:function(_17ce,_17cf){
var _17d0=[];
this._getProjectTemplatesPartial(0,_17ce,_17d0,_17cf);
},_getProjectTemplatesPartial:function(_17d1,_17d2,_17d3,_17d4){
this._getProjectTemplatesSendRequest({offset:_17d1,limit:_17d2},function(_17d5,_17d6,_17d7){
var error=false;
if(_17d7.success){
if(typeof _17d7.totalNumProjectTemplates=="number"&&typeof _17d7.offset=="number"&&typeof _17d7.limit=="number"&&_17d7.offset>=0&&_17d7.limit>=1&&_17d7.projectTemplatesObject&&_17d7.projectTemplatesObject.projectTemplates){
_17d5=_17d5.concat(_17d7.projectTemplatesObject.projectTemplates);
var _17d8=_17d7.offset+_17d7.limit;
var _17d9=(_17d8>=_17d7.totalNumProjectTemplates);
var stop=_17d6(_17d5,_17d7,_17d9);
if(!stop&&!_17d9){
this._getProjectTemplatesPartial(_17d8,_17d2,_17d5,_17d6);
}
}else{
error=false;
}
}else{
error=false;
}
if(error){
console.error("_getProjectTemplatesPartial: unexpected response from server. returnData=");
}
}.bind(this,_17d3,_17d4));
},_getProjectTemplatesSendRequest:function(_17da,_17db){
var _17dc=JSON.stringify(_17da,null,"\t");
xhr.post("cmd/getProjectTemplates",{handleAs:"json",query:{params:_17dc}}).then(function(_17dd){
_17db(_17dd);
},function(err){
console.error("_getProjectTemplatesSendRequest xhr error. err=");
});
},create:function(_17de){
if(!_17de||!_17de.projectTemplateName){
return;
}
var _17df=_17de.projectTemplateName;
var _17e0=_17de.sharingSimple=="all"?"all":"none";
var _17e1=new Date().toISOString();
var _17de={projectTemplateName:_17df,projectToClone:_17cc.getProject(),sharingSimple:_17e0,timestamp:_17e1};
var _17e2=JSON.stringify(_17de,null,"\t");
var data=_17cb.serverJSONRequest({url:"cmd/createProjectTemplate",handleAs:"json",content:{params:_17e2},sync:true});
if(!data||!data.success){
console.error("cmd/createProjectTemplate error:"+data.error);
}
return data;
},modify:function(_17e3){
var _17e4=JSON.stringify(_17e3,null,"\t");
var data=_17cb.serverJSONRequest({url:"cmd/modifyProjectTemplates",handleAs:"json",content:{params:_17e4},sync:true});
if(!data||!data.success){
console.error("cmd/modifyProjectTemplate error:"+data.error);
}
return data;
},deleteTemplates:function(_17e5){
var _17e6=JSON.stringify(_17e5,null,"\t");
var data=_17cb.serverJSONRequest({url:"cmd/deleteProjectTemplates",handleAs:"json",content:{params:_17e6},sync:true});
if(!data||!data.success){
console.error("cmd/deleteProjectTemplate error:"+data.error);
}
return data;
}};
return dojo.setObject("davinci.ui.ProjectTemplates",_17cd);
});
},"davinci/ve/_Widget":function(){
define("davinci/ve/_Widget",["dojo/_base/declare","./metadata","../html/CSSModel","dojox/html/entities","davinci/ve/utils/StyleArray","davinci/ve/utils/GeomUtils"],function(_17e7,_17e8,_17e9,_17ea,_17eb,_17ec){
var _17ed=function(_17ee,_17ef,func){
if(_17ee==_17ef){
return true;
}
if(!_17ee||!_17ef){
return false;
}
if(_17ee.length!=_17ef.length){
return false;
}
for(var i=0;i<_17ee.length;i++){
if(func){
if(!func(_17ee[i],_17ef[i])){
return false;
}
}else{
if(_17ee[i]!=_17ef[i]){
return false;
}
}
}
return true;
};
return _17e7("davinci.ve._Widget",null,{isWidget:true,acceptsHTMLChildren:false,_skipAttrs:["id","style","class","dir","lang","_children"],constructor:function(_17f0,node,type,_17f1){
this.domNode=node;
this.id=node.id;
node._dvWidget=this;
this._params=dojo.mixin({},_17f0);
this.type=type;
this.metadata=_17f1;
},postscript:function(){
var _17f2;
if(this.domNode){
var doc=this.domNode.ownerDocument;
if(doc.body._edit_context){
_17f2=doc.body._edit_context;
}else{
if(doc.body._dvWidget&&doc.body._dvWidget._edit_context){
_17f2=doc.body._dvWidget._edit_context;
}
}
}
if(this.id&&_17f2){
_17f2.widgetHash[this.id]=this;
}
this.buildRendering();
this.postCreate();
},buildRendering:function(){
},postCreate:function(){
},getObjectType:function(){
},getContext:function(){
return this._edit_context;
},getChildren:function(_17f3){
var _17f4=this.getHelper();
if(_17f4&&_17f4.getChildren){
return _17f4.getChildren(this,_17f3);
}
return this._getChildren(_17f3);
},indexOf:function(child){
var _17f5=this.getHelper();
if(_17f5&&_17f5.indexOf){
return _17f5.indexOf(this,child);
}
return dojo.indexOf(this.getChildren(),child);
},_getChildren:function(_17f6){
var _17f7=this.getContainerNode(),_17f8=[];
if(_17f7){
dojo.forEach(_17f7.children,function(node){
if(_17f6){
_17f8.push(require("davinci/ve/widget").getWidget(node));
}else{
var _17f9=node._dvWidget;
if(_17f9){
_17f8.push(_17f9);
}
}
});
}
return _17f8;
},getContainerNode:function(){
var _17fa=this.getHelper();
if(_17fa&&_17fa.getContainerNode){
return _17fa.getContainerNode(this);
}
if(_17e8.getAllowedChild(this.type)[0]!=="NONE"){
return this._getContainerNode();
}
return null;
},_getContainerNode:function(){
return this.domNode;
},getMetadata:function(){
if(!this.metadata){
this.metadata=_17e8.query(this);
}
return this.metadata;
},getHelper:function(){
if(!this._edit_helper){
this._edit_helper=require("davinci/ve/widget").getWidgetHelper(this.type);
}
return this._edit_helper;
},attr:function(name,value){
var _17fb=this._attr.apply(this,arguments);
if(arguments.length>1){
value=this._stringValue(name,value);
this._srcElement.addAttribute(name,value);
}else{
return _17fb;
}
},_attr:function(name,value){
},indexOf:function(child){
var _17fc=this.getHelper();
if(_17fc&&_17fc.indexOf){
return _17fc.indexOf(this,child);
}
return dojo.indexOf(this.getChildren(),child);
},getStyleNode:function(){
return this.styleNode||this.domNode;
},addChild:function(child,index){
var _17fd=this.getContainerNode();
if(_17fd){
if(index===undefined||index===null||index===-1){
this._srcElement.addChild(child._srcElement);
}else{
var _17fe=this.getChildren();
if(index<_17fe.length){
this._srcElement.insertBefore(child._srcElement,_17fe[index]._srcElement);
}else{
this._srcElement.addChild(child._srcElement);
}
}
var _17ff=this.getHelper();
if(_17ff&&_17ff.addChild){
_17ff.addChild(this,child,index);
}else{
this._addChildToDom.apply(this,arguments);
}
}
},_addChildToDom:function(child,index){
var node=child.domNode;
var _1800=this.getContainerNode();
if(index===undefined||index===null||index===-1){
_1800.appendChild(node);
}else{
var _1801=this.getChildren();
if(index<_1801.length){
_1800.insertBefore(node,_1801[index].domNode);
}else{
_1800.appendChild(node);
}
}
},getParent:function(){
return require("davinci/ve/widget").getEnclosingWidget(this.domNode.parentNode)||this.domNode.parentNode;
},getObjectId:function(_1802){
_1802=_1802||this;
var _1803=_1802._edit_object_id;
if(_1803){
return _1803;
}
if(_1802.domNode){
return _1802.domNode.getAttribute("jsId");
}
return undefined;
},addClass:function(_1804){
var _1805=this.getClassNames();
_1805=_1805?_1805.split(/\s+/):[];
if(_1805.indexOf(_1804)!==-1){
return;
}
_1805.push(_1804);
this._srcElement.setAttribute("class",_1805.join(" "));
dojo.addClass(this.domNode,_1804);
},getId:function(){
if(!this.id){
if(!this.domNode.id||!this.type){
return undefined;
}
var id=this.domNode.id;
var base=(this.isHtmlWidget?this.getTagName():this.type).replace(/\./g,"_")+"_";
if(id.length>base.length&&id.substring(0,base.length)==base){
return undefined;
}
}
if(this._srcElement&&this._srcElement._getAttribute("id")&&this._srcElement._getAttribute("id").noPersist){
return undefined;
}
return this.id;
},setMarginBox:function(box){
var node=this.getStyleNode();
if(!node){
return;
}
dojo.marginBox(node,box);
this._updateSrcStyle();
},getMarginBox:function(){
var node=this.domNode;
var box=null;
var _1806=this.getHelper();
if(_1806&&_1806.getMarginBoxPageCoords){
box=_1806.getMarginBoxPageCoords(this);
}else{
box=_17ec.getMarginBoxPageCoords(node);
}
box.l-=_17ec.getScrollLeft(node);
box.t-=_17ec.getScrollTop(node);
box.x=box.l;
box.y=box.t;
return box;
},getStyle:function(_1807){
var _1808=this.getStyleValues(_1807);
if(!_1808){
return "";
}
return this._styleText(_1808);
},_sortStyleValues:function(_1809){
var _180a=dojo.clone(_1809);
function _180b(value){
for(var i=0;i<_180a.length;i++){
if(_180a[i]&&_180a[i].hasOwnProperty(value)){
return i;
}
}
return -1;
};
var _180c=_17e9.shorthand;
var _180d=0;
for(var i=0;i<_180c.length;i++){
var index=_180b(_180c[i][0]);
if(index>-1){
var _180e=_180a[index];
_180a.splice(index,1);
_180a.splice(_180d,0,_180e);
_180d++;
}
}
return _180a;
},_styleText:function(v){
var s="";
if(dojo.isArray(v)){
var _180f=davinci.ve.states.normalizeArray("style",this.domNode,name,v);
for(var i=0;i<_180f.length;i++){
for(var name in _180f[i]){
value=_180f[i][name];
if(value!==undefined&&value!=""&&value!=null){
s+=name+": "+_180f[i][name]+"; ";
}
}
}
}else{
for(var name in v){
value=davinci.ve.states.normalize("style",this.domNode,name,v[name]);
if(value!==undefined&&value!=""&&value!=null){
s+=name+": "+v[name]+"; ";
}
}
}
return s.trim();
},getChildrenData:function(_1810){
_1810=_1810||{identify:true};
var _1811=this.getHelper();
if(_1811&&_1811.getChildrenData){
return _1811.getChildrenData.apply(_1811,[this,_1810]);
}
return this._getChildrenData(_1810);
},_getChildrenData:function(_1812){
return this.getChildren().map(function(w){
return w.getData(_1812);
});
},getClassNames:function(){
return this._srcElement.getAttribute("class")||"";
},_getData:function(_1813){
var data={type:this.type,properties:{}},_1814=require("davinci/ve/widget");
if(_1813.identify){
if(!this._srcElement){
this._srcElement=_1814._createSrcElement(this.domNode);
}
var _1815=this._srcElement._getAttribute("id");
if(_1815&&_1815.noPersist){
data.properties.isTempID=true;
}
data.properties.id=this.id;
}
if((_1813.preserveTagName!==false)&&(this.id)){
data.tagName=this._srcElement.tag;
}
var _1816=_17e8.query(this,"property");
if(this.domNode&&this.domNode.parentNode){
var _1817=_1814.getEnclosingWidget(this.domNode.parentNode);
var _1818=_17e8.query(_1817,"childProperties");
if(_1818){
if(!_1816){
_1816=_1818;
}else{
_1816=dojo.mixin({},_1816,_1818);
}
}
}
if(_1816){
for(var name in _1816){
if(this._skipAttrs.indexOf(name.toLowerCase())!==-1){
continue;
}
var _1819=_1816[name];
var value=this.getPropertyValue(name);
if(value&&value.length){
if(_1819.datatype=="array"){
if(!_17ed(value,_1819.defaultValue)){
data.properties[name]=value;
}
}else{
if(value!=_1819.defaultValue){
data.properties[name]=value;
}
}
}else{
if((_1819.datatype=="boolean"||_1819.datatype=="number")&&value!=_1819.defaultValue){
data.properties[name]=value;
}else{
if(_1819.datatype&&(_1819.datatype.indexOf("dijit")==0||_1819.datatype=="object"&&_1819.isData)){
data.properties[name]=value;
}
}
}
}
}
data.properties.style=this.getStyle(_1813);
var _181a=this.getClassNames(_1813);
if(_181a){
data.properties["class"]=_181a;
}
data.children=this.getChildrenData(_1813);
return data;
},getData:function(_181b){
_181b=_181b||{identify:true,preserveStates:true};
var data,_181c=this.getHelper();
if(_181c&&_181c.getData){
data=_181c.getData.apply(_181c,[this,_181b]);
}else{
data=this._getData(_181b);
}
data.maqAppStates=dojo.clone(this.domNode._maqAppStates);
data.maqDeltas=dojo.clone(this.domNode._maqDeltas);
if(!data.properties){
data.properties={};
}
if(this.properties){
for(var name in this.properties){
if(!(name in data.properties)){
data.properties[name]=this.properties[name];
}
}
}
var _181d=this._srcElement;
var _181e=_181d.attributes;
for(var i=0;i<_181e.length;i++){
var _181f=_181e[i];
if(_181f.name.substr(0,2).toLowerCase()=="on"){
data.properties[_181f.name]=_181f.value;
}else{
if(_181d.tag.toLowerCase()=="a"&&_181f.name.toLowerCase()=="href"){
data.properties[_181f.name]=_181f.value;
}
}
}
return data;
},getPropertyValue:function(name){
if(name==="id"){
return this.getId();
}else{
if(name==="jsId"){
return this.getObjectId();
}
}
var _1820=this.getHelper();
if(_1820&&_1820.getPropertyValue){
return _1820.getPropertyValue(this,name);
}
return this._getPropertyValue(name);
},_getPropertyValue:function(name){
return this.domNode.getAttribute(name);
},getTagName:function(){
return this.domNode.nodeName.toLowerCase();
},getStyleValues:function(){
function _1821(_1822){
for(var j=_1823.length-1;j>=0;j--){
var item=_1823[j];
if(item[_1822]!==undefined){
_1823.splice(j,1);
}
}
};
var style=this.getStyleNode().style;
var text=this._srcElement.getAttribute("style");
var _1823=require("davinci/ve/widget").parseStyleValues(text);
var _1824=this.getParent();
if(style&&_1824&&_1824.dijitWidget&&_1824.dijitWidget.addChild&&!_1824.acceptsHTMLChildren){
_1821("position");
_1821("left");
_1821("top");
}
return _1823;
},getStyleValuesAllStates:function(){
var _1825=this.getStyleValues();
var _1826={"undefined":_1825};
var _1827=this.domNode._maqDeltas;
if(_1827){
for(var state in _1827){
if(_1827[state].style){
if(state=="undefined"){
_1826[state]=_17eb.mergeStyleArrays(_1825,_1827[state].style);
}else{
_1826[state]=_1827[state].style;
}
}
}
}
return _1826;
},_updateSrcStyle:function(){
var _1828=this.getStyle();
if(_1828.length){
this._srcElement.addAttribute("style",_1828);
}else{
this._srcElement.removeAttribute("style");
}
},_getStyleString:function(_1829){
if(!_1829){
return "";
}
var v=this._sortStyleValues(_1829);
var text=this._styleText(v);
return text;
},setStyleValuesCanvas:function(_182a){
if(!_182a){
return;
}
var text=this._getStyleString(_182a);
var _182b=this.getStyleNode();
dojo.attr(_182b,"style",text);
if(this.dijitWidget){
this.dijitWidget.style=text;
}
},setStyleValuesModel:function(_182c){
var text=this._getStyleString(_182c);
if(text.length>0){
this._srcElement.addAttribute("style",text);
}else{
this._srcElement.removeAttribute("style");
}
},setStyleValuesAllStates:function(_182d){
this.domNode._maqDeltas=undefined;
if(_182d){
for(var state in _182d){
var _182e=_182d[state];
if(state==="undefined"){
state=undefined;
}
davinci.ve.states.setStyle(this.domNode,state,_182e,true);
}
}
},isLayout:function(){
return false;
},resize:function(){
},refresh:function(){
var _182f=this.getParent();
if(_182f.dijitWidget){
_182f.refresh();
}else{
if(this.resize){
this.resize();
}
}
},removeChild:function(child){
this._srcElement.removeChild(child._srcElement);
var _1830=this.getHelper();
if(_1830&&_1830.removeChild){
_1830.removeChild(this,child);
}else{
this._removeChildFromDom.apply(this,arguments);
}
},_removeChildFromDom:function(child){
var node=child.domNode;
if(node&&node.parentNode){
node.parentNode.removeChild(node);
}
},setProperties:function(_1831,_1832){
if(!this.properties){
this.properties={};
}
_1832=_1832||false;
if(_1831.id){
this._srcElement.addAttribute("id",_1831.id,_1831.isTempID);
delete _1831.id;
delete _1831.isTempID;
}
if(_1831.isTempID){
delete _1831.isTempID;
}
for(var name in _1831){
var _1833=_1831[name];
if(_1833||typeof _1833=="boolean"||typeof _1833=="number"){
var value=this._stringValue(name,_1833);
if(!_1832){
this.properties[name]=value;
}
this._srcElement.addAttribute(name,value);
}else{
delete this.properties[name];
this._srcElement.removeAttribute(name);
}
}
},startup:function(){
},renderWidget:function(){
},destroyWidget:function(_1834){
var _1835=this.getHelper();
if(_1835&&_1835.destroy){
_1835.destroy(this);
return;
}
if(this.dijitWidget){
this.dijitWidget.destroyRecursive();
}else{
dojo.forEach(this.getChildren(),function(each){
each.destroyWidget();
});
}
},selectChild:function(_1836){
},attach:function(){
var _1837=this.getHelper();
if(_1837&&_1837.create){
_1837.create(this,this._srcElement);
}
},_stringValue:function(_1838,value){
var _1839=this.getMetadata();
var _183a=_1839.property&&_1839.property[_1838];
if(!_183a){
return value;
}
if(_183a.datatype=="object"){
if(value.getObjectId){
value=value.getObjectId();
}else{
var _183b=value._edit_object_id;
if(_183b){
return _183b;
}
if(value.domNode){
return value.domNode.getAttribute("jsId");
}
}
}else{
if(_183a.datatype=="json"){
var _183c=this.getContext();
var dj=_183c&&_183c.getDojo()||dojo;
var _183d=this.getHelper();
if(_183d&&_183d.checkValue){
value=_183d.checkValue(value);
}
if(dj.isObject(value)){
value=dj.toJson(value);
}
}else{
if(_183a.datatype=="string"){
switch(_183a.format){
case "date":
case "time":
if(isFinite(value)){
value=dojo.date.stamp.toISOString(value,{selector:_183a.format});
}
break;
default:
value=_17ea.encode(value);
}
}
}
}
return value;
}});
});
},"url:davinci/ui/templates/download.html":"<div class='downloadDialog'>\t \n\t<div class=\"dijitDialogPaneContentArea\">\n\t\t<div style=\"margin-bottom: 20px\">\n\t\t  ${fileName}: <input data-dojo-type='dijit/form/ValidationTextBox' type=\"text\" maxLength='${_fileNameMaxLength}' data-dojo-attach-point=\"__fileName\" value='${_projectName}.zip' data-dojo-props=\"regExp:'${_fileNameValidationRegExp}', required:true, invalidMessage:'${invalidDownloadFileName}'\"></input>\n\t\t</div>\n\t\t\n\t\t<div data-dojo-attach-point=\"_selectionDiv\"></div>\n\t\t<div data-dojo-attach-point=\"_tableDiv\"></div>\n\n\t\t<div style=\"margin-top: 8px\">\n\t\t  Select: <a href=\"javascript:;\" data-dojo-attach-event=\"onclick: _selectAll\">${selectAll}</a> / <a href=\"javascript:;\" data-dojo-attach-event=\"onclick: _selectNone\">${selectNone}</a>\n\t\t</div>\n\n\t\t<div style=\"margin-top: 20px\">\n\t\t\t<input data-dojo-type='dijit/form/CheckBox' type=\"text\" data-dojo-attach-point=\"__fullSource\" data-dojo-props=\"\"></input><span style='padding-left: 3px;'>${downloadFullSource}</span>\n\t\t\t<br>\n\t\t\t<input data-dojo-type='dijit/form/CheckBox' type=\"text\" data-dojo-attach-point=\"__optimize\" data-dojo-props=\"\"></input><span style='padding-left: 3px;'>${optimizeOption}</span>\n\t\t</div>\n  </div>\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-point=\"_okButton\" data-dojo-attach-event='onClick:okButton' label='${downloadButtonLabel}' class=\"maqPrimaryButton\" type=\"submit\"></button>\n\t\t<button data-dojo-type='dijit/form/Button' data-dojo-attach-event='onClick:cancelButton' label='${buttonCancel}' class=\"maqSecondaryButton\"></button>\n\t</div>\n</div>","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","davinci/ve/tools/_Tool":function(){
define(["dojo/_base/declare","davinci/ve/widget","davinci/ve/metadata","davinci/ve/utils/GeomUtils"],function(_183e,_183f,_1840,_1841){
return _183e("davinci.ve.tools._Tool",null,{_getTarget:function(){
return this._target;
},_setTarget:function(_1842,event){
if(!this._targetOverlays){
this._targetOverlays=[];
}
if(this._matchesTargetOverlay(_1842)){
return;
}
var _1843=this._context.getContainerNode();
var w;
while(_1842&&_1842!=_1843){
w=_183f.getEnclosingWidget(_1842);
if(w&&!w.getContext()){
_1842=w.domNode.parentNode;
w=null;
}else{
if(w&&davinci.ve.metadata.queryDescriptor(w.type,"enablePointerEvents")){
w=null;
break;
}else{
if(w&&w.getContainerNode()){
if(!davinci.ve.metadata.queryDescriptor(w.type,"isControl")){
w=null;
}
}
break;
}
}
}
if(w){
this._target=w;
this._updateTargetOverlays(event);
this._insertTargetOverlays();
}else{
this._removeTargetOverlays();
this._target=null;
}
},_updateTargetOverlays:function(event){
this._removeTargetOverlays();
if(!this._target){
return;
}
var _1844=this._target.domNode;
var _1845=this._getMaxZIndex(_1844);
if(this._targetOverlays){
var _1846=this._target.getHelper();
if(_1846&&_1846.getTargetOverlays){
var _1847=_1846.getTargetOverlays(this._target);
if(_1847&&_1847.length>0){
dojo.forEach(_1847,function(_1848){
var _1849=this._getNewTargetOverlay(_1848,_1848.x,_1848.y,_1848.width,_1848.height,_1845);
this._targetOverlays.push(_1849);
},this);
return;
}
}
var left=_1844.offsetLeft;
var top=_1844.offsetTop;
var width=_1844.offsetWidth;
var _184a=_1844.offsetHeight;
if(event){
var diff;
var _184b=_1841.getBorderBoxPageCoordsCached(_1844);
if(event.pageX<_184b.l){
diff=_184b.l-event.pageX;
left-=diff;
width+=diff;
}
if(event.pageY<_184b.t){
diff=_184b.t-event.pageY;
top-=diff;
_184a+=diff;
}
if(event.pageX>_184b.l+_184b.w){
diff=event.pageX-(_184b.l+_184b.w);
width+=diff;
}
if(event.pageY>_184b.t+_184b.h){
diff=event.pageY-(_184b.t+_184b.h);
_184a+=diff;
}
}
var _184c=this._getNewTargetOverlay(_1844,left,top,width,_184a,_1845);
this._targetOverlays.push(_184c);
}
},_getMaxZIndex:function(_184d){
var _184e=dojo.style(_184d,"zIndex");
dojo.query("*",_184d).forEach(function(node){
var _184f=dojo.style(node,"zIndex");
var _1850=Number(_184f);
var _1851=Number(_184e);
if(!isNaN(_1850)){
if(isNaN(_1851)){
_184e=_184f;
}else{
if(_1850>_1851){
_184e=_184f;
}
}
}
});
return _184e;
},_getNewTargetOverlay:function(_1852,x,y,width,_1853,_1854){
var _1855=this._context.getDojo().create("div",{className:"editFeedback",style:{position:"absolute",opacity:0.1,left:x+"px",top:y+"px",width:width+"px",height:_1853+"px",zIndex:_1854}});
return _1855;
},_insertTargetOverlays:function(){
if(this._targetOverlays&&this._target){
var _1856=this._target.domNode;
var _1857=_1856.parentNode;
dojo.forEach(this._targetOverlays,function(_1858){
_1857.insertBefore(_1858,_1856.nextSibling);
},this);
}
},_removeTargetOverlays:function(){
if(this._targetOverlays&&this._target){
for(var i=this._targetOverlays.length-1;i>=0;i--){
var _1859=this._targetOverlays[i];
dojo.destroy(_1859);
this._targetOverlays.pop();
}
}
},_matchesTargetOverlay:function(_185a){
return dojo.some(this._targetOverlays,function(entry){
return _185a==entry;
},this);
}});
});
},"dijit/form/TextBox":function(){
require({cache:{"url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n"}});
define("dijit/form/TextBox",["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_185b,_185c,_185d,_185e,lang,has,_185f,_1860,_1861,dijit){
var _1862=_185b("dijit.form.TextBox",[_185f,_1860],{templateString:_1861,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){
var type=this.type.toLowerCase();
if(this.templateString&&this.templateString.toLowerCase()=="input"||((type=="hidden"||type=="file")&&this.templateString==this.constructor.prototype.templateString)){
this.templateString=this._singleNodeTemplate;
}
this.inherited(arguments);
},postCreate:function(){
this.inherited(arguments);
if(has("ie")<9){
this.defer(function(){
try{
var s=_185d.getComputedStyle(this.domNode);
if(s){
var ff=s.fontFamily;
if(ff){
var _1863=this.domNode.getElementsByTagName("INPUT");
if(_1863){
for(var i=0;i<_1863.length;i++){
_1863[i].style.fontFamily=ff;
}
}
}
}
}
catch(e){
}
});
}
},_onInput:function(e){
this.inherited(arguments);
if(this.intermediateChanges){
this.defer(function(){
this._handleOnChange(this.get("value"),false);
});
}
},_setPlaceHolderAttr:function(v){
this._set("placeHolder",v);
if(!this._phspan){
this._attachPoints.push("_phspan");
this._phspan=_185c.create("span",{onmousedown:function(e){
e.preventDefault();
},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");
}
this._phspan.innerHTML="";
this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));
this._updatePlaceHolder();
},_updatePlaceHolder:function(){
if(this._phspan){
this._phspan.style.display=(this.placeHolder&&!this.focused&&!this.textbox.value)?"":"none";
}
},_setValueAttr:function(value,_1864,_1865){
this.inherited(arguments);
this._updatePlaceHolder();
},getDisplayedValue:function(){
_185e.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");
return this.get("displayedValue");
},setDisplayedValue:function(value){
_185e.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");
this.set("displayedValue",value);
},_onBlur:function(e){
if(this.disabled){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
if(has("mozilla")){
if(this.selectOnClick){
this.textbox.selectionStart=this.textbox.selectionEnd=undefined;
}
}
},_onFocus:function(by){
if(this.disabled||this.readOnly){
return;
}
this.inherited(arguments);
this._updatePlaceHolder();
}});
if(has("ie")){
_1862.prototype._isTextSelected=function(){
var range=this.ownerDocument.selection.createRange();
var _1866=range.parentElement();
return _1866==this.textbox&&range.text.length>0;
};
dijit._setSelectionRange=_1860._setSelectionRange=function(_1867,start,stop){
if(_1867.createTextRange){
var r=_1867.createTextRange();
r.collapse(true);
r.moveStart("character",-99999);
r.moveStart("character",start);
r.moveEnd("character",stop-start);
r.select();
}
};
}
return _1862;
});
},"davinci/ve/actions/_AddManageStatesWidget":function(){
define(["dojo/_base/declare","dojo/dom-style","dojo/_base/event","dijit/_WidgetBase","dijit/_TemplatedMixin","dijit/_WidgetsInTemplateMixin","davinci/Runtime","davinci/Workbench","davinci/workbench/Preferences","davinci/ve/States","davinci/commands/CompoundCommand","davinci/ve/commands/StyleCommand","davinci/ve/commands/AppStateCommand","davinci/actions/Action","dojo/i18n!davinci/ve/nls/ve","dojo/i18n!dijit/nls/common","dojo/text!./templates/AddState.html","dijit/form/TextBox","dijit/form/Select","dijit/form/CheckBox","dijit/form/Button"],function(_1868,_1869,event,_186a,_186b,_186c,_186d,_186e,_186f,_1870,_1871,_1872,_1873,_1874,veNls,_1875,_1876,_1877,_1878,_1879,_187a){
return _1868("davinci.ve.actions._AddManageStatesWidget",[_186a,_186b,_186c],{templateString:_1876,widgetsInTemplate:true,veNls:veNls,commonNls:_1875,_isValid:function(){
var _187b=this.domNode.querySelector(".addStateNameDiv");
if(_187b){
var _187c=_1869.get(_187b,"display");
if(_187c=="none"){
return true;
}
}
var state=this.input.get("value");
if(!state){
return false;
}else{
if(davinci.ve.states.hasState(this.node,state)){
alert(dojo.string.substitute(veNls.stateNameExists,{name:state}));
return false;
}
}
return true;
},_onKeyPress:function(e){
if(e.keyCode!=dojo.keys.ENTER){
if(this._isValid()){
this.okButton.set("disabled",false);
}else{
this.okButton.set("disabled",true);
}
}
},onOk:function(){
var _187d;
if(_186d.currentEditor&&_186d.currentEditor.currentEditor&&_186d.currentEditor.currentEditor.context){
_187d=_186d.currentEditor.currentEditor.context;
}else{
console.error("_AddManageStatesWidget.js (from "+this._calledBy+" - cannot determine context.");
return;
}
var _187e=_1870.getFocus(_187d.rootNode);
if(!_187e||!_187e.stateContainerNode){
return;
}
var _187f=_1870.getState(_187e.stateContainerNode);
var _1880=this.input.get("value");
var _1881=this._calledBy=="AddState"?_1880:_187f;
if(_1880){
var _187d;
if(_186d.currentEditor&&_186d.currentEditor.currentEditor&&_186d.currentEditor.currentEditor.context){
_187d=_186d.currentEditor.currentEditor.context;
}else{
console.error("AddState.js - cannot determine context.");
return;
}
var _1882=new _1871();
if(_1880){
_1882.add(new _1873({action:"add",state:_1880,stateContainerNode:this.node,context:_187d}));
}
_187d.getCommandStack().execute(_1882);
}
},onCancel:function(){
this.onClose();
}});
});
},"davinci/html/CSSProperty":function(){
define(["dojo/_base/declare","davinci/html/CSSElement"],function(_1883,_1884){
return _1883("davinci.html.CSSProperty",_1884,{constructor:function(name,value,_1885){
this.elementType="CSSProperty";
this.name=name||"";
this.value=value||"";
this.parent=_1885;
this.expanded=[];
this.lengthValues=[];
},getValue:function(){
return this.value;
},getText:function(_1886){
var s="";
if(this.comment&&!_1886.noComments){
s+="\n  "+this.comment.getText(_1886);
}
s+=this.name+" : "+this.value;
if(this.isNotImportant){
s+=" !important";
}
s+=";";
if(this.postComment&&!_1886.noComments){
s+=this.postComment.getText(_1886);
}
return s;
},getCSSRule:function(){
return this.parent;
},addProperty:function(name,value){
var _1887=new CSSProperty(name,value,this);
this.properties.push(_1887);
},getURL:function(){
if(this.url){
var path=new davinci.model.Path(this.getCSSFile().url);
path=path.getParentPath().append(this.url);
return path.toString();
}
}});
});
},"url:davinci/review/widgets/templates/OpenReviewDialog.html":"<div class=\"fileDialog\">\n\t<div class=\"dijitDialogPaneContentArea folderContainer\">\n\t\t<div dojoType=\"dijit.layout.ContentPane\" dojoAttachPoint=\"treeContentPane\">\n\t\t</div>\n\t</div>\n\t\n\t<div class=\"dijitDialogPaneActionBar\">\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachPoint=\"okButton\" dojoAttachEvent=\"onClick:_okButton\" type=\"submit\" class=\"maqPrimaryButton\" disabled=\"disabled\">${finishButtonLabel}</button>\n\t\t<button dojoType=\"dijit.form.Button\" dojoAttachEvent=\"onClick:_cancelButton\" class=\"maqSecondaryButton\">${cancelButtonLabel}</button>\n\t</div>\n</div>\n","davinci/ve/commands/StyleCommand":function(){
define(["dojo/_base/declare","davinci/ve/widget","davinci/ve/utils/StyleArray"],function(_1888,_1889,_188a){
return _1888("davinci.ve.commands.StyleCommand",null,{name:"style",constructor:function(_188b,_188c,_188d){
this._newValues=_188c;
this._id=_188b?_188b.id:undefined;
this._applyToStateIndex=(!_188d||_188d=="Normal"||_188d=="undefined")?"undefined":_188d;
},add:function(_188e){
if(!_188e||_188e._id!=this._id){
return;
}
if(_188e._newValues){
dojo.mixin(this._newValues,_188e._newValues);
}
},execute:function(){
if(!this._id||!this._newValues){
return;
}
var _188f=require("davinci/ve/widget").byId(this._id);
if(!_188f||!_188f.domNode){
return;
}
var _1890=require("davinci/ve/States");
var _1891=_188f.getStyleValuesAllStates();
this._oldStyleValuesAllStates=dojo.clone(_1891);
if(_1891[this._applyToStateIndex]){
_1891[this._applyToStateIndex]=_188a.mergeStyleArrays(_1891[this._applyToStateIndex],this._newValues);
}else{
_1891[this._applyToStateIndex]=this._newValues;
}
var _1892=_1891[this._applyToStateIndex];
for(var i=_1892.length-1;i>=0;i--){
var obj=_1892[i];
var _1893=false;
for(var prop in obj){
var value=obj[prop];
if(value=="$MAQ_DELETE_PROPERTY$"){
delete obj[prop];
}else{
_1893=true;
}
}
if(!_1893){
_1892.splice(i,1);
}
}
_188f.setStyleValuesAllStates(_1891);
var _1894=_1890.getStatesListCurrent(_188f.domNode);
var _1895=_188a.mergeStyleArrays([],_1891["undefined"]);
for(var i=0;i<_1894.length;i++){
if(_1891[_1894[i]]){
_1895=_188a.mergeStyleArrays(_1895,_1891[_1894[i]]);
}
}
_188f.setStyleValuesCanvas(_1895);
_188f.setStyleValuesModel(_1891["undefined"]);
_188f.refresh();
_1890.resetState(_188f.domNode);
dojo.publish("/davinci/ui/widgetPropertiesChanged",[[_188f]]);
},undo:function(){
if(!this._id||!this._oldStyleValuesAllStates){
return;
}
var _1896=require("davinci/ve/widget").byId(this._id);
if(!_1896){
return;
}
var _1897=require("davinci/ve/States");
var _1898=this._oldStyleValuesAllStates;
var _1899=this._applyToSt