/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"davinci/ve/themeEditor/ThemeColor":function(){
define("davinci/ve/themeEditor/ThemeColor",["dojo/_base/declare"],function(_1){
return _1("davinci.ve.themeEditor.ThemeColor",[dojo.Color],{constructor:function(_2){
dojo.safeMixin(this,_2);
},toHsl:function(){
var r=this.r;
var g=this.g;
var b=this.b;
r/=255,g/=255,b/=255;
var _3=Math.max(r,g,b),_4=Math.min(r,g,b);
var h,s,l=(_3+_4)/2;
if(_3==_4){
h=s=0;
}else{
var d=_3-_4;
s=l>0.5?d/(2-_3-_4):d/(_3+_4);
switch(_3){
case r:
h=(g-b)/d+(g<b?6:0);
break;
case g:
h=(b-r)/d+2;
break;
case b:
h=(r-g)/d+4;
break;
}
h/=6;
}
return {h:h,s:s,l:l};
},setHsl:function(h,s,l){
var r,g,b;
if(s==0){
r=g=b=l;
}else{
function _5(p,q,t){
if(t<0){
t+=1;
}
if(t>1){
t-=1;
}
if(t<1/6){
return p+(q-p)*6*t;
}
if(t<1/2){
return q;
}
if(t<2/3){
return p+(q-p)*(2/3-t)*6;
}
return p;
};
var q=l<0.5?l*(1+s):l+s-l*s;
var p=2*l-q;
r=_5(p,q,h+1/3);
g=_5(p,q,h);
b=_5(p,q,h-1/3);
}
this.r=parseInt(r*255);
this.g=parseInt(g*255);
this.b=parseInt(b*255);
if(this.r>255){
this.r=255;
}
if(this.g>255){
this.g=255;
}
if(this.b>255){
this.b=255;
}
return {r:this.r,g:this.g,b:this.b};
},toHsv:function(){
var r=this.r;
var g=this.g;
var b=this.b;
r=r/255,g=g/255,b=b/255;
var _6=Math.max(r,g,b),_7=Math.min(r,g,b);
var h,s,v=_6;
var d=_6-_7;
s=_6==0?0:d/_6;
if(_6==_7){
h=0;
}else{
switch(_6){
case r:
h=(g-b)/d+(g<b?6:0);
break;
case g:
h=(b-r)/d+2;
break;
case b:
h=(r-g)/d+4;
break;
}
h/=6;
}
return {h:h,s:s,v:v};
},setHsv:function(h,s,v){
var r,g,b;
var i=Math.floor(h*6);
var f=h*6-i;
var p=v*(1-s);
var q=v*(1-f*s);
var t=v*(1-(1-f)*s);
switch(i%6){
case 0:
r=v,g=t,b=p;
break;
case 1:
r=q,g=v,b=p;
break;
case 2:
r=p,g=v,b=t;
break;
case 3:
r=p,g=q,b=v;
break;
case 4:
r=t,g=p,b=v;
break;
case 5:
r=v,g=p,b=q;
break;
}
this.r=r*255;
this.g=g*255;
this.b=b*255;
if(this.r>255){
this.r=255;
}
if(this.g>255){
this.g=255;
}
if(this.b>255){
this.b=255;
}
return {r:this.r,g:this.g,b:this.b};
},calculateHighlightColor:function(_8,_9){
var _a=new davinci.ve.themeEditor.ThemeColor(_8);
var _b=new davinci.ve.themeEditor.ThemeColor(_9);
var _c=new davinci.ve.themeEditor.ThemeColor("#FFFFFF");
var _d=_a.toHsl();
var _e=_b.toHsl();
var _f=this.toHsl();
var _10=new Object();
_10.h=_e.h-_d.h;
_10.s=_e.s-_d.s;
_10.l=_e.l-_d.l;
var h=_f.h+_10.h;
var s=_f.s+_10.s;
var l=_f.l+_10.l;
_c.setHsl(h,s,l);
return _c;
},getHoverColor:function(){
var _11=new davinci.ve.themeEditor.ThemeColor(normal);
var _12=new davinci.ve.themeEditor.ThemeColor(highlight);
var _13=new davinci.ve.themeEditor.ThemeColor("#FFFFFF");
var _14=_11.toHsl();
var _15=_12.toHsl();
var _16=this.toHsl();
var _17=new Object();
_17.h=_15.h-_14.h;
_17.s=_15.s-_14.s;
_17.l=_15.l-_14.l;
var h=0.3329565030146425;
var s=1;
var l=0.8588235294117648;
_13.setHsl(h,s,l);
return _13;
}});
});
},"davinci/ve/themeEditor/VisualThemeEditor":function(){
define("davinci/ve/themeEditor/VisualThemeEditor",["dojo/_base/declare","davinci/Workbench","./Context","davinci/workbench/Preferences","davinci/model/Path","davinci/html/HTMLFile","davinci/Theme","dojo/i18n!../nls/ve","dojo/cookie"],function(_18,_19,_1a,_1b,_1c,_1d,_1e,_1f,_20){
return _18([],{constructor:function(_21,_22,_23,_24,_25,_26){
this.THEME_EDITOR_SPEC=1;
this._themeEditor=_21;
this.domNode=_22;
this.theme=_26;
var _27=_25[0];
this.basePath=new _1c(_27.getPath());
this.loadingDiv=dojo.create("div",{className:"loading",innerHTML:dojo.replace("<table><tr><td><span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;{0}</td></tr></table>",["Loading..."])},this.domNode.parentNode,"first");
this._handles=[];
this.context=new _1a({editor:this._themeEditor,visualEditor:this,containerNode:this.domNode,baseURL:encodeURI(_27.getURL()),theme:_26});
dojo.connect(this.context,"onSelectionChange",this,"onSelectionChange");
var _28=_1b.getPreferences("davinci.ve.themeEditor.editorPrefs",_19.getProject());
if(_28){
this.context.setPreferences(_28);
}
dojo.xhrGet({url:encodeURI(_27.getURL()),handleAs:"text",content:{}}).then(dojo.hitch(this,function(_29){
this.setContent("DEFAULT_PAGE",_29,_24);
}));
},onSelectionChange:function(){
},destroy:function(){
},getDefaultContent:function(){
return "";
},getContent:function(){
return this.context.getSource();
},setContent:function(_2a,_2b,_2c){
if(this.theme.specVersion<this.THEME_EDITOR_SPEC){
var _2d="maqetta_"+this.theme.name+"_"+this.theme.specVersion;
var _2e=_20(_2d);
if(!_2e){
_20(_2d,"true");
this.themeVersionWarn();
}
}
if(_2a.toLowerCase().indexOf(".css")>0){
}else{
if(_2a=="DEFAULT_PAGE"){
var _2f=_1e.getThemeLocation();
htmlFile=new _1d();
htmlFile.fileName=_2a;
htmlFile.setText(_2b,true);
var _30=_2f.relativeTo(this.basePath,true);
htmlFile.themeCssFiles=[];
_2c.forEach(function(_31){
htmlFile.themeCssFiles.push(_30.toString()+"/"+this.theme.name+"/"+_31);
}.bind(this));
this.context.model=htmlFile;
if(!this.initialSet){
this.context.deactivate();
this.context._setSource(htmlFile,function(_32){
try{
if(_32 instanceof Error){
throw _32;
}
this.savePoint=0;
var doc=this.context.getDocument();
dojo.some(doc.head.children,function(_33){
if(_33.tagName=="LINK"&&(_33.getAttribute("href").indexOf(this.theme.files[0])>-1)){
doc.head.removeChild(_33);
doc.head.appendChild(_33);
return true;
}
},this);
var _34;
if(this.theme&&this.theme.helper){
_34=_1e.getHelper(this.theme);
if(_34&&_34.preThemeConfig){
_34.preThemeConfig(this.context);
}else{
if(_34&&_34.then){
_34.then(function(_35){
if(_35.helper&&_35.helper.preThemeConfig){
_35.helper.preThemeConfig(this.context);
this.theme.helper=_35.helper;
}
}.bind(this));
}
}
}
this.context.activate();
setTimeout(dojo.hitch(this,function(){
this.context.getTopWidgets().forEach(function(_36){
if(_36.resize){
_36.resize({});
}
});
dojo.publish("/davinci/states/state/changed",[{editorClass:"davinci.themeEditor.ThemeEditor",widget:"$all",newState:"Normal",context:this.context}]);
}),1500);
this.initialSet=true;
var _37=this.context.getDojo().version.major+"."+this.context.getDojo().version.minor;
if(_37!==this.theme.version){
var _38="maqetta_"+this.theme.name+"_"+this.theme.version;
var _39=_20(_38);
if(!_39){
_20(_38,"true");
this.themeVersionWarn(true);
}
}
}
catch(e){
_32=e;
}
finally{
if(_32.errorMessage){
this.loadingDiv.innerHTML=_32.errorMessage;
}else{
if(_32 instanceof Error){
var _3a="Uh oh! An error has occurred:<br><b>"+_32.message+"</b>";
if(_32.fileName){
_3a+="<br>file: "+_32.fileName+"<br>line: "+_32.lineNumber;
}
if(_32.stack){
_3a+="<br><pre>"+_32.stack+"</pre>";
}
this.loadingDiv.innerHTML=_3a;
dojo.addClass(this.loadingDiv,"error");
}else{
if(this.loadingDiv.parentNode){
this.loadingDiv.parentNode.removeChild(this.loadingDiv);
}
delete this.loadingDiv;
}
}
}
},this);
}
}
}
},themeVersionWarn:function(_3b){
var msg=_1f.vteWarningMessage;
if(_3b){
msg=_1f.vteWarningToolkitMessage;
}
_19.showMessage(_1f.vteWarningTitle,msg,{width:250});
},themeVersionError:function(){
_19.showMessage(_1f.vteErrorTitle,_1f.vteErrorMessage,{width:250},dojo.hitch(this,"themeVersionErrorOk"));
},themeVersionErrorOk:function(){
this.context.editor.editorContainer.save(false);
this.context.editor.editorContainer.forceClose(this,true);
return true;
},hotModifyCssRule:function(){
},getOutline:function(){
return null;
}});
});
},"davinci/ve/themeEditor/commands/ThemeEditorCommand":function(){
define(["dojo/_base/declare"],function(_3c){
return _3c("davinci.ve.themeEditor.commands.ThemeEditorCommand",null,{constructor:function(_3d){
dojo.mixin(this,_3d);
},execute:function(){
this.old_selectedWidget=this._themeEditor._selectedWidget;
this.old_selectedSubWidget=this._themeEditor._selectedSubWidget;
this._themeEditor.deselectSubwidget(this.old_selectedWidget,this.old_selectedSubWidget);
this._themeEditor._selectedWidget=this._widget[0];
this._themeEditor._selectedSubWidget=null;
if(this._firstRun){
this.updatePropertiesView(false);
}else{
this.updatePropertiesView(true);
dojo.publish("/davinci/ui/subwidgetSelectionChanged",[{subwidget:this._themeEditor._selectedSubWidget,origin:this.declaredClass}]);
}
this._firstRun=false;
},undo:function(){
this._themeEditor.deselectSubwidget(this._themeEditor._selectedWidget,this._themeEditor._selectedSubWidget);
this._themeEditor._selectedWidget=this.old_selectedWidget;
this._themeEditor._selectedSubWidget=this.old_selectedSubWidget;
this._themeEditor.selectSubwidget(this.old_selectedWidget,this.old_selectedSubWidget);
this.updatePropertiesView(true);
dojo.publish("/davinci/ui/subwidgetSelectionChanged",[{subwidget:this._themeEditor._selectedSubWidget,origin:this.declaredClass}]);
},updatePropertiesView:function(_3e){
if(!this._themeEditor._selectedWidget){
return;
}
var e=[this._themeEditor._selectedWidget];
dojo.publish("/davinci/ui/widgetSelected",[e]);
}});
});
},"davinci/ve/themeEditor/Context":function(){
define(["dojo/_base/declare","dojo/Deferred","../../commands/CommandStack","../widget","./SelectTool","../Context","../../library","../metadata"],function(_3f,_40,_41,_42,_43,_44,_45,_46){
return _3f("davinci.ve.ThemeEditor.Context",[_44],{_bootstrapModules:"dijit/dijit,dijit/dijit-all",constructor:function(_47){
this._id="_edit_context_"+this._contextCount++;
dojo.mixin(this,_47);
if(dojo.isString(this.containerNode)){
this.containerNode=dijit.byId(this.containerNode);
}
this._commandStack=_41(this);
this._defaultTool=new _43();
this._widgetIds=[];
this._objectIds=[];
this._widgets=[];
this._selectionCssRules=[];
},_setSourceData:function(_48){
var _49=[this.getDijit()._WidgetBase,this.getDijit()._TemplatedMixin];
this.getDojo().declare("dijit.davinci.themeEditor.Dialog",_49,{buttonCancel:"cancel",onCancel:function(){
},title:"title",templateString:dojo.cache("dijit","templates/Dialog.html","<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabIndex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n"),attributeMap:dojo.delegate(dijit._Widget.prototype.attributeMap,{title:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}],"aria-describedby":""}),_setTitleAttr:[{node:"titleNode",type:"innerHTML"},{node:"titleBar",type:"attribute"}]});
this.getDojo().declare("dijit.davinci.themeEditor.Tooltip",_49,{templateString:dojo.cache("dijit","templates/Tooltip.html","<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n></div>\n")});
this.setHeader({title:_48.title,metas:_48.metas,scripts:_48.scripts,modules:_48.modules,styleSheets:_48.styleSheets,theme:_48.theme,bodyClasses:_48.bodyClasses,style:_48.style});
content=_48.content||"";
var _4a=this.getContainerNode();
var _4b=this.isActive();
if(_4b){
this.select(null);
dojo.forEach(this.getTopWidgets(),this.detach,this);
}
var _4c=new _40();
dojo.forEach(this.getTopWidgets(),function(w){
if(w.getContext()){
w.destroyWidget();
}
});
_4a.innerHTML=content;
dojo.forEach(dojo.query("*",_4a),function(n){
var _4d=n.getAttribute("data-dojo-type")||n.getAttribute("dojoType")||n.getAttribute("dvwidget");
_4d=_4d&&_4d.replace(/\./g,"/");
this.loadRequires(_4d,false,true);
},this);
this.getGlobal()["require"]("dojo/ready")(function(){
try{
this.getGlobal()["require"]("dojo/parser").parse(_4a);
_4c.resolve();
}
catch(e){
var _4e=this.getDijit();
_4e.registry.forEach(function(w){
w.destroy();
});
this._editorSelectConnection=dojo.subscribe("/davinci/ui/editorSelected",dojo.hitch(this,this._editorSelectionChange));
_4c.reject();
throw e;
}
}.bind(this));
if(_4b){
dojo.query("> *",this.rootNode).map(davinci.ve.widget.getWidget).forEach(this.attach,this);
}
dojo.query(".dvThemeWidget").forEach(this.theme.removeWidgetStyleValues);
return _4c;
},attach:function(_4f){
this.inherited(arguments);
if(!_4f||_4f.internal||!_4f._srcElement){
return;
}
var _50=false;
var _51=_4f.getClassNames();
if(_51&&_51.indexOf("dvThemeWidget")>-1){
_50=true;
}
_4f.dvAttributes={isThemeWidget:_50};
if(_50){
if(this._widgets.indexOf(_4f)===-1){
this._widgets.push(_4f);
}
}
},getThemeMeta:function(){
if(!this._themeMetaCache){
this._themeMetaCache=_45.getThemeMetadata(this.theme);
}
return this._themeMetaCache;
},select:function(_52,add){
if(!_52||_52==this.rootWidget){
this._selectedWidget=null;
if(!add){
this.deselect();
}
return;
}
this._selectedWidget=_52;
var _53=undefined;
var _54=undefined;
if(add&&this._selection){
_54=this._selection.length;
_53=this._selection;
_53.push(_52);
}else{
_53=[_52];
}
var _55=false;
if(!this._selection||this._selection.length>1||_53.length>1||_53[0]!=this._selection[0]){
this._selection=_53;
_55=true;
}
this.updateFocus(_52,_54);
if(_55){
this.onSelectionChange(this.getSelection());
}
},onSelectionChange:function(_56){
if(!this._forceSelectionChange){
this.visualEditor._themeEditor._selectedSubWidget=null;
}
this.inherited(arguments);
},getStyleAttributeValues:function(_57){
return [];
},_restoreStates:function(){
},_configDojoxMobile:function(){
try{
var _58=this.getGlobal()["require"],dm=_58("dojox/mobile"),_59=_58("dojox/mobile/deviceTheme"),_5a=this.getGlobal().dojo.config,ua="none",_5b,_5c,_5d;
_5b=[[".*","",[]]];
_5c=[];
var re=new RegExp("");
_5d=re;
_59.themeMap=_5b;
_5a.mblThemeFiles=_5c;
_5a.mblLoadCompatPattern=_5d;
dm.loadCompatPattern=_5d;
_59.loadDeviceTheme(ua);
}
catch(e){
}
},getPath:function(){
var _5e=this.theme.getFile().getPath();
_5e=_5e.substring(0,_5e.lastIndexOf("/"));
_5e=_5e+"/"+this.theme.themeEditorHtmls[0];
return _5e;
},getFullResourcePath:function(){
return this.visualEditor.basePath;
},widgetAddedOrDeleted:function(){
}});
});
},"davinci/ve/themeEditor/SelectTool":function(){
define("davinci/ve/themeEditor/SelectTool",["dojo/_base/declare","davinci/ve/widget","davinci/ve/tools/SelectTool","davinci/ve/themeEditor/commands/StateChangeCommand"],function(_5f,_60,_61,_62){
return _5f("davinci.ve.themeEditor.SelectTool",[_61],{onMouseDown:function(_63){
var t=_60.getEnclosingWidget(_63.target);
if(_63.target.id.indexOf("enableWidgetFocusFrame_")>-1){
t=_63.target._widget;
}
var _64=(this._getTarget()||t);
while(_64){
if(_64.dvAttributes&&_64.dvAttributes.isThemeWidget&&_64.getContext()){
break;
}
_64=_60.getEnclosingWidget(_64.domNode.parentNode);
}
if(!_64){
var _65=this._context.editor,cmd=new _62({_themeEditor:_65,_widget:_65._selectedWidget,_newState:_65._currentState,_oldState:_65._oldState,_firstRun:true});
setTimeout(function(){
cmd.execute();
},500);
return;
}
var _66=this._context.getSelection();
var _67=navigator.appVersion.indexOf("Macintosh")<0?_63.ctrlKey:_63.metaKey;
if(dojo.indexOf(_66,_64)>=0){
if(_67&&_63.button!==2){
this._context.deselect(_64);
}else{
if(_63.button!==2){
this._context.select(_64);
}
}
}else{
_64.subwidget=null;
this._context.select(_64,false);
_63.stopPropagation();
}
}});
});
},"davinci/ve/themeEditor/commands/StateChangeCommand":function(){
define("davinci/ve/themeEditor/commands/StateChangeCommand",["dojo/_base/declare","davinci/ve/themeEditor/commands/ThemeEditorCommand"],function(_68,_69){
return _68("davinci.ve.themeEditor.commands.StateChangeCommand",[_69],{constructor:function(_6a){
dojo.mixin(this,_6a);
},execute:function(){
this.old_selectedWidget=this._themeEditor._selectedWidget;
this.old_selectedSubWidget=this._themeEditor._selectedSubWidget;
this._themeEditor._currentState=this._newState;
var _6b=null;
var _6c=null;
if(!this._widgets){
this._widgets=this._themeEditor.getContext().getDocument().querySelectorAll(".dvThemeWidget");
}
var _6d=this._widgets;
for(var i=0;i<_6d.length;i++){
this._themeEditor.enableWidget(_6d[i]._dvWidget);
if((!this._oldState)||(this._themeEditor._theme.isStateValid(_6d[i]._dvWidget,this._oldState))){
this._themeEditor._theme.removeWidgetStyleValues(_6d[i]._dvWidget,this._oldState);
}
if(this._themeEditor._theme.isStateValid(_6d[i]._dvWidget,this._newState)){
this._themeEditor._theme.setWidgetStyleValues(_6d[i]._dvWidget,this._newState);
}else{
this._themeEditor.disableWidget(_6d[i]._dvWidget);
}
}
if(!this._firstRun){
this._widget.processingUndoRedo=true;
dojo.publish("/davinci/states/state/changed",[{editorClass:"davinci.themeEditor.ThemeEditor",widget:"$all",newState:this._newState,oldState:this._oldState,origin:this.declaredClass,context:this._themeEditor.context}]);
}
this._firstRun=false;
this.updatePropertiesView();
},undo:function(){
this._themeEditor._selectedWidget=this.old_selectedWidget;
this._themeEditor._selectedSubWidget=this.old_selectedSubWidget;
this._themeEditor._currentState=this._oldState;
var _6e=this._widgets;
for(var i=0;i<_6e.length;i++){
if(!this._themeEditor._theme.isStateValid(_6e[i]._dvWidget,this._newState)){
this._themeEditor.enableWidget(_6e[i]);
}
if(this._themeEditor._theme.isStateValid(_6e[i]._dvWidget,this._oldState)){
this._themeEditor.enableWidget(_6e[i]._dvWidget);
}else{
this._themeEditor.disableWidget(_6e[i]._dvWidget);
}
this._themeEditor._theme.removeWidgetStyleValues(_6e[i]._dvWidget,this._newState);
this._themeEditor._theme.setWidgetStyleValues(_6e[i]._dvWidget,this._oldState);
}
this._widget.processingUndoRedo=true;
this.updatePropertiesView();
dojo.publish("/davinci/states/state/changed",[{editorClass:"davinci.themeEditor.ThemeEditor",widget:"$all",newState:this._oldState,oldState:this._newState,origin:this.declaredClass,context:this._themeEditor.context}]);
}});
});
},"davinci/ve/themeEditor/commands/SubwidgetChangeCommand":function(){
define(["dojo/_base/declare","davinci/ve/themeEditor/commands/ThemeEditorCommand"],function(_6f,_70){
return _6f("davinci.ve.themeEditor.commands.SubwidgetChangeCommand",[_70],{constructor:function(_71){
dojo.mixin(this,_71);
},execute:function(){
this._old__selectedWidget=this._themeEditor._selectedWidget;
this._old_selectedSubWidget=this._themeEditor._selectedSubWidget;
this._themeEditor._selectedSubWidget=this._subwidget;
this.updatePropertiesView();
this._themeEditor.deselectSubwidget(this._old__selectedWidget,this._old_selectedSubWidget);
this._themeEditor.selectSubwidget(this._themeEditor._selectedWidget,this._themeEditor._selectedSubWidget);
if(this._redo){
dojo.publish("/davinci/ui/subwidgetSelectionChanged",[{subwidget:this._themeEditor._selectedSubWidget,origin:this.declaredClass}]);
}else{
this._redo=true;
}
},undo:function(){
this._themeEditor.deselectSubwidget(this._themeEditor._selectedWidget,this._themeEditor._selectedSubWidget);
this._themeEditor.selectSubwidget(this._old__selectedWidget,this._old_selectedSubWidget);
this._themeEditor._selectedWidget=this._old__selectedWidget;
this._themeEditor._selectedSubWidget=this._old_selectedSubWidget;
this.updatePropertiesView();
dojo.publish("/davinci/ui/subwidgetSelectionChanged",[{subwidget:this._themeEditor._selectedSubWidget,origin:this.declaredClass}]);
}});
});
}}});
define("davinci/ve/themeEditor/ThemeEditor",["dojo/_base/declare","../../ui/ModelEditor","./VisualThemeEditor","./metadata/query","./metadata/CSSThemeProvider","./commands/ThemeEditorCommand","./commands/SubwidgetChangeCommand","./commands/StateChangeCommand","dijit/layout/ContentPane","../../commands/CompoundCommand","./ThemeColor","system/resource","../../model/Path","../../Theme","dojo/promise/all","dojo/i18n!../nls/ve","dojox/widget/Toaster",],function(_72,_73,_74,_75,_76,_77,_78,_79,_7a,_7b,_7c,_7d,_7e,_7f,all,_80,_81){
return _72("davinci.ve.themeEditor.ThemeEditor",[_73],{children:[],visualEditor:null,_currentState:"Normal",_dirtyResource:{},_subWidgetSelection:null,_theme:null,_tempRules:{},_subscriptions:[],__DEBUG_TO_CONSOLE:false,_shortHands:["border","padding","margin","background","font","list-style"],constructor:function(_82){
this.inherited(arguments);
var _83=this;
this.editorContainer=dijit.getEnclosingWidget(_82);
this._cp=new _7a({},_82);
this.domNode=this._cp.domNode;
this.domNode.className="ThemeEditor fullPane";
this._loadedCSSConnects=[];
this.subscribe("/davinci/ui/editorSelected",this._editorSelected.bind(this));
this.subscribe("/davinci/ui/context/loaded",this._contextLoaded.bind(this));
this.editorContainer.connect(this.editorContainer,"resize",function(_84){
var _85=dojo.query("iframe",this.domNode)[0];
if(_85&&_85.contentDocument&&_85.contentDocument.body){
var _86=_85.contentDocument.body;
setTimeout(function(){
var _87=this.getContext();
_87.clearCachedWidgetBounds();
_87.updateFocusAll();
}.bind(this),100);
_83._registerScrollHandler();
}
}.bind(this));
},_editorSelected:function(_88){
var _89=this.getContext();
if(this==_88.oldEditor){
_89.hideFocusAll();
}
if(_88.editor&&_88.editor.editorContainer&&(_88.editor.declaredClass=="davinci.ve.PageEditor"||_88.editor.declaredClass=="davinci.ve.themeEditor.ThemeEditor")){
if(this==_88.editor){
this._registerScrollHandler();
}
}
},onResize:function(){
var _8a=this.getContext();
var _8b=this.getSelectedWidget();
_8a.select(_8b,false);
},getSelectionProperties:function(_8c){
if(!this._selectedWidget){
return [{editor:this,widget:null,subwidget:null,cssValues:null,computedCssValues:null,appliesTo:["theme"],context:this.context}];
}
var v=this._getSelectionStyleValues();
var _8d;
var _8e=this._getCssRules();
this._rebaseCssRuleImagesForStylePalette(_8e,v);
var _8f=this._selectedWidget.type;
var _8d=this._theme.getDomNode(this._selectedWidget.domNode,_8f,this._selectedSubWidget);
var _90=dojo.getComputedStyle(_8d);
return {editor:this,widget:this._selectedWidget,subwidget:this._selectedSubWidget,cssValues:v,computedCssValues:_90,appliesTo:["theme"],context:this.context};
},_widgetStateChanged:function(e){
if(!this.isActiveEditor()||!e){
return;
}
if(e.origin&&e.origin.indexOf("davinci.ve.themeEditor.commands.")>-1){
return;
}
var _91=e.widget;
if(_91&&_91.processingUndoRedo){
delete _91.processingUndoRedo;
return;
}
this.getContext().getCommandStack().execute(new _79({_themeEditor:this,_widget:_91,_newState:e.newState,_oldState:e.oldState,_firstRun:true}));
},selectSubwidget:function(_92,_93){
if(!_92||!_93||_93=="WidgetOuterContainer"){
return;
}
var _94=this._theme.getWidgetType(_92);
var _95=this._theme.getDomNode(_92.domNode,_94,_93);
var box=this.getRelativeBox(_95);
var _96=this.getContext().getDocument().createElement("div");
_96.className="editSubwidgetFocusFrame";
_96.id="editSubwidgetFocusFrame";
_96.style.position="absolute";
var _97=2;
_96.style.width=_95.offsetWidth+(_97*2)+"px";
_96.style.height=_95.offsetHeight+(_97*2)+"px";
_96.style.top=(box.t-_97)+"px";
_96.style.left=(box.l-_97)+"px";
_96.style.padding=_97+"px";
_96.style.display="block";
this._selectedWidget.domNode.parentNode.appendChild(_96);
this._subWidgetFocusFrame=_96;
},deselectSubwidget:function(_98,_99){
if(this._subWidgetFocusFrame){
this._subWidgetFocusFrame.parentNode.removeChild(this._subWidgetFocusFrame);
this._subWidgetFocusFrame=null;
}
},_subwidgetSelectionChanged:function(e){
if(e.origin&&e.origin.indexOf("davinci.ve.themeEditor.commands.")>-1){
return;
}
if(!this.isActiveEditor()||!(this._selectedWidget||this._selectedSubWidget)){
return;
}
if(e.subwidget=="WidgetOuterContainer"){
e.subwidget=null;
}
this.getContext().getCommandStack().execute(new _78({_themeEditor:this,_subwidget:e.subwidget}));
},_getSelectionStyleValues:function(){
var _9a=this._getCssRules();
if(_9a.length==0){
return null;
}
var _9b={};
for(var s=0;s<_9a.length;s++){
var _9c=_9a[s];
for(var p=0;p<_9c.properties.length;p++){
_9b[_9c.properties[p].name]=_9c.properties[p].value;
}
}
_9b=this.convertShortHandProps(_9b);
return _9b;
},addShortHandProps:function(_9d){
var _9e=this._shortHands;
var _9f="";
for(a in _9d){
_9f=_9f+" "+a+": "+_9d[a]+";";
}
var e=dojo.doc.createElement("div");
e.style.cssText=_9f;
for(v in _9d){
var _a0=_a1(v);
if(e.style[_a0]){
_9d[v]=e.style[_a0];
}
}
return _9d;
function _a1(str){
return str.replace(/(\-[a-z])/g,function($1){
return $1.toUpperCase().replace("-","");
});
};
},convertShortHandProps:function(_a2){
var _a3=this._shortHands;
for(var x=0;x<_a3.length;x++){
var sh=_a3[x];
if(_a2[sh]){
var e=dojo.doc.createElement("div");
e.style.cssText=sh+": "+_a2[sh]+";";
for(n in e.style){
if(n.indexOf(sh)>-1){
var _a4=_a5(n);
if(e.style[n]){
_a2[_a4]=e.style[n];
}
}
}
}
}
function _a5(str){
return str.replace(/([A-Z])/g,function($1){
return "-"+$1.toLowerCase();
});
};
function _a6(val){
var _a7="";
val=val.split("-");
_a7+=val[0].substring(0,1).toLowerCase()+val[0].substring(1,val[0].length);
for(var c=1;c<val.length;c++){
if(val[c]!="value"){
_a7+=val[c].substring(0,1).toUpperCase()+val[c].substring(1,val[c].length);
}
}
return _a7;
};
return _a2;
},_getCssRules:function(_a8,_a9,_aa){
if(!_a9){
_a9=null;
}
var _ab=this._loadCssSelectors(_a8,_a9,_aa);
var _ac=[];
if(!_ab){
return null;
}
for(var s=0;s<_ab.length;s++){
var _ad=this.getContext()._getCssFiles();
if(_ad){
for(var i=0;i<_ad.length;i++){
var _ae=_ad[i].getRules(_ab[s]);
for(var sn=0;sn<_ae.length;sn++){
var _af=_ae[sn];
if(_af){
var _b0=_af.searchUp("CSSRule");
if(_b0){
_ac.push(_b0);
}
}
}
}
}
}
return _ac;
},focus:function(){
this.onSelectionChange([this.getSelectedWidget()]);
},supports:function(_b1){
var _b2=/^style|states|propsect_layout|propsect_paddingMargins|propsect_background|propsect_border|propsect_fontsAndText$/;
return _b1.match(_b2)?true:false;
},onSelectionChange:function(a){
if(!this.isActiveEditor()||!a||!a[0]){
return;
}
if(this._selectedWidget&&(this._selectedWidget.id==a[0].id)){
return;
}
this.getContext().getCommandStack().execute(new _77({_themeEditor:this,_widget:a,_firstRun:true}));
},getSelectedWidget:function(){
var _b3=this.getContext();
var _b4=_b3.getSelection();
var _b5=(_b4.length>0?_b4[_b4.length-1]:undefined);
if(_b4.length>1){
_b3.select(_b5);
}
return _b5;
},getSelectedSubWidget:function(){
if(this._selectedSubWidget){
return this._selectedSubWidget;
}
},_loadCssSelectors:function(_b6,_b7,_b8){
if(!_b6){
_b6=this._selectedWidget;
if(!_b7){
_b7=this.getSelectedSubWidget();
}
}
if(!_b6){
return null;
}
var _b9=this.metaDataLoader.getType(_b6);
if(!_b9){
return null;
}
var id=_b6.id;
if(id.indexOf("all")===0){
_b9=_b9+".$"+id;
}
if(!_b8){
_b8=this._currentState;
}
if(!_b8){
_b8="Normal";
}
var _ba=[];
if(this.__DEBUG_TO_CONSOLE){
}
var _bb=this._theme.getStyleSelectors(_b9,_b8,_b7);
for(var aa in _bb){
_ba.push(aa);
}
return _ba;
},_addCommandsForValue:function(_bc,_bd,_be,_bf,_c0,_c1){
if(!_bc){
_bc=new _7b();
}
var _c2=[];
var _c3=this.getRules(_bd,_be,_bf);
for(var r=0;r<_c3.length;r++){
var _c4=_c3[r];
if(this._theme.isPropertyVaildForWidgetRule(_c4,_c1,this._selectedWidget,_be,_bf)){
var _c5=this.getContext().getDeltaRule(_c4);
_c2[_c5.getSelectorText()]=_c5;
}
}
for(var _c6 in _c2){
var _c7=_c0.appliesTo.rule;
_c0.appliesTo.rule=null;
cValue=dojo.clone(_c0);
cValue.appliesTo.rule=_c2[_c6];
_c0.appliesTo.rule=_c7;
cValue.values.forEach(function(_c8){
if(_c8[_c1]&&_c8[_c1].indexOf("url('")==0){
var _c9=_c8[_c1].split("'");
var url=_c9[1];
if(url.indexOf("http://")>-1){
return;
}
var _ca=_c7.parent.url.substring(0,_c7.parent.url.lastIndexOf("/"))+"/"+url;
var _cb=_7d.findResource(_ca);
var _cc=new _7e(_cb.getPath());
var _cd=_cc.relativeTo(cValue.appliesTo.rule.parent.url,true);
_c8[_c1]="url('"+_cd+"')";
}
}.bind(this));
_bc.add(this.getContext().getCommandForStyleChange(cValue));
}
return _bc;
},_propertiesChange:function(_ce){
if(!this.isActiveEditor()){
return;
}
var _cf=new _7b();
if(this._selectedWidget.id==="all"){
var _d0=[];
this._oldValues=[];
for(var i=0;i<_ce.values.length;i++){
var _d1=_ce.values[i];
for(var v in _d1){
if(v.indexOf("color")>-1){
_d0[v]=_d1[v];
}
}
}
var _d2=this._theme.getMetadata(this._theme.getWidgetType(this._selectedWidget));
for(var c in _d2.states){
if(c!="Normal"){
var _d3=dojo.clone(_d0);
for(var _d4 in _d3){
var _d5;
var _d6;
if(_d2.states.Normal.defaults&&_d2.states.Normal.defaults.cssPropery){
_d5=_d2.states.Normal.defaults.cssPropery[_d4];
}
if(_d2.states[c].defaults&&_d2.states[c].defaults.cssPropery){
_d6=_d2.states[c].defaults.cssPropery[_d4];
}
var _d7=_d3[_d4];
if(_d5&&_d6&&_d7){
var _d8=new _7c(_d7);
var _d9=_d8.calculateHighlightColor(_d5,_d6);
_d3[_d4]=_d9.toHex();
for(var i=0;i<_ce.values.length;i++){
var _da=_ce.values[i];
for(name in _da){
if(_d3[name]){
_da[name]=_d3[name];
}
}
}
for(var i=0;i<_ce.values.length;i++){
for(var a in _ce.values[i]){
_cf=this._addCommandsForValue(_cf,this._selectedWidget,this._selectedSubWidget,c,_ce,a);
}
}
}
}
}else{
for(var i=0;i<_ce.values.length;i++){
for(var a in _ce.values[i]){
_cf=this._addCommandsForValue(_cf,this._selectedWidget,this._selectedSubWidget,this._currentState,_ce,a);
}
}
}
}
}else{
for(var i=0;i<_ce.values.length;i++){
for(var a in _ce.values[i]){
_cf=this._addCommandsForValue(_cf,this._selectedWidget,this._selectedSubWidget,this._currentState,_ce,a);
}
}
}
if(this._selectedWidget){
this.getContext().getCommandStack().execute(_cf);
}
this.setDirty(true);
},_rebaseCssRuleImagesForStylePalette:function(_db,_dc){
if(!_db){
return _dc;
}
for(var r=0;r<_db.length;r++){
var _dd=_db[r];
for(var a in _dc){
var _de=_dd.getProperty(a);
if(_de){
var url=_de.getURL();
if(url){
_dc[a]=url;
}
}
}
}
return _dc;
},_markDirty:function(_df){
this._dirtyResource[_df]=new Date().getTime();
this._srcChanged();
},_srcChanged:function(){
if(!this.isDirty){
if(this._themeFileContent){
this.resourceFile.setContents(this._themeFileContent,true);
}else{
console.error("ThemeEditor.theme file content empty");
this._themeFileContent=this.resourceFile.getContentSync();
}
}
this.isDirty=true;
this.lastModifiedTime=new Date().getTime();
if(this.editorContainer){
this.editorContainer.setDirty(true);
}
},setDirty:function(_e0){
this.isDirty=_e0;
if(this.editorContainer){
this.editorContainer.setDirty(_e0);
}
},getContext:function(){
return this.visualEditor?this.visualEditor.context:null;
},getOutline:function(){
return this.visualEditor.getOutline();
},getPropertiesView:function(){
return this.visualEditor.getPropertiesView();
},getThemeFile:function(){
return this.theme;
},setContent:function(_e1,_e2){
try{
this._themePath=new davinci.model.Path(_e1);
var t=dojo.isString(_e2)?dojo.fromJson(_e2):_e2;
this.theme=_7f.getTheme(t.name);
this.themeCssFiles=[];
for(var i=0;i<this.theme.files.length;i++){
if(this.theme.files[i].indexOf(".css")>-1){
this.themeCssFiles.push(this.theme.files[i]);
}
}
var _e3=[];
for(var y=0;y<this.theme.themeEditorHtmls.length;y++){
var _e4=this._themePath.getParentPath().append(this.theme.themeEditorHtmls[y]).toString();
_e3.push(system.resource.findResource(_e4));
}
this.visualEditor=new _74(this,this._cp.domNode,_e1,this.themeCssFiles,_e3,this.theme);
this.fileName=_e1;
var _e5=[];
var _e6=this.getContext();
_e6._themePath=this._themePath;
_e6.themeCssFiles=this.themeCssFiles;
for(var i=0;i<this.theme.meta.length;i++){
_e5.push(_e6._getThemeResource(this.theme.meta[i]));
}
this.metaDataLoader=new _75(_e5);
this._theme=new _76(_e5,this.theme);
var _e7=_e6._getCssFiles();
for(var i=0;i<_e7.length;i++){
this._loadedCSSConnects.push(dojo.connect(_e7[i],"onChange",_e6,"_themeChange"));
}
this._themeFileContent=this.resourceFile.getContentSync();
var _e8=this._subscriptions;
_e8.push(dojo.subscribe("/davinci/ui/styleValuesChange",this,"_propertiesChange"));
_e8.push(dojo.subscribe("/davinci/states/state/changed",this,"_widgetStateChanged"));
_e8.push(dojo.subscribe("/davinci/ui/subwidgetSelectionChanged",this,"_subwidgetSelectionChanged"));
dojo.connect(this.visualEditor,"onSelectionChange",this,"onSelectionChange");
}
catch(e){
alert("error loading:"+_e1+e);
}
},getDefaultContent:function(){
},selectModel:function(_e9){
},getFileEditors:function(){
function _ea(_eb,_ec,_ed){
return {lookFor:_eb,urlResolver:_ec,result:_ed,_getObject:function(_ee,_ef,_f0){
return {resourceFile:_ee,getText:function(){
return _ef;
},lastModifiedTime:_f0};
},visit:function(_f1){
if(_f1.elementType=="CSSFile"){
for(var aa in this.lookFor){
if(aa==_f1.url){
var _f2=system.resource.findResource(aa);
this.result.push(this._getObject(_f2,_f1.getText({noComments:false}),this.lookFor[aa]));
break;
}
}
}
return (this.lookFor.length<=0);
}};
};
var _f3=[];
var _f4=this.getContext()._getCssFiles();
var _f5=_ea(this._dirtyResource,this._URLResolver,_f3);
if(_f4){
for(var i=0;i<_f4.length;i++){
_f4[i].visit(_f5);
}
}
_f3.push({resourceFile:this.resourceFile,getText:function(){
return this.resourceFile.getContentSync();
},lastModifiedTime:Date.now()});
return _f3;
},save:function(_f6){
var _f7=this.getContext().saveDynamicCssFiles(this.getContext()._getCssFiles(),_f6);
if(typeof hasToaster=="undefined"){
new _81({position:"br-left",duration:4000,messageTopic:"/davinci/resource/saveError"});
hasToaster=true;
}
all(_f7).then(function(_f8){
for(var i=0;i<_f8.length;i++){
if(_f8[i] instanceof Error){
var _f9=_80.vteErrorSavingResourceMessage+_f8[i];
dojo.publish("/davinci/resource/saveError",[{message:_f9,type:"error"}]);
console.error(_f9);
return;
}
}
if(!_f6){
this.isDirty=false;
}
if(this.editorContainer&&!_f6){
this.editorContainer.setDirty(false);
}
}.bind(this));
},removeWorkingCopy:function(){
},destroy:function(){
if(this._scrollHandler){
dojo.disconnect(this._scrollHandler);
delete this._scrollHandler;
}
this.inherited(arguments);
this.getContext().destroy();
if(this.visualEditor){
this.visualEditor.destroy();
}
this._subscriptions.forEach(dojo.unsubscribe);
if(this._loadedCSSConnects){
dojo.forEach(this._loadedCSSConnects,dojo.disconnect);
delete this._loadedCSSConnects;
}
delete this._tempRules;
},getText:function(){
return dojo.toJson(this.theme,true);
},disableWidget:function(_fa){
if(!_fa){
return;
}
var _fb=this.getContext().getDocument().getElementById("enableWidgetFocusFrame_"+_fa.id);
if(_fb){
_fb.parentNode.removeChild(_fb);
}
this._createFrame(_fa,"disableWidgetFocusFrame_","disableWidgetFocusFrame");
},_createFrame:function(_fc,id,_fd){
if(!_fc){
return;
}
var _fe=this.getContext().getDocument().getElementById(id+_fc.id);
if(_fe){
return;
}
var _ff=_fc;
if(_fc.domNode){
_ff=_fc.domNode;
}
var _fe=this.getContext().getDocument().createElement("div");
dojo.connect(_fe,"onmousedown",this,"editFrameOnMouseDown");
var _100=this.getContext().getContainerNode();
dojo.connect(_100,"onmousedown",this,"canvasOnMouseDown");
_fe.className=_fd;
_fe.id=id+_fc.id;
_fe.style.position="absolute";
var box=this.getRelativeBox(_ff);
_fe.style.top=box.t+"px";
_fe.style.left=box.l+"px";
_fe.style.width=box.w+"px";
_fe.style.height=box.h+"px";
_fe.style.display="block";
_fe._widget=_fc;
_ff.parentNode.appendChild(_fe);
},getRelativeBox:function(_101){
var _102=0;
var _103=0;
var obj=_101;
if(obj.offsetParent){
do{
if(obj.className.indexOf("theming-widget")>-1){
_103=_101.offsetTop;
_102=_101.offsetLeft;
break;
}
_102+=obj.offsetLeft;
_103+=obj.offsetTop;
}while(obj=obj.offsetParent);
}
return {t:_103,l:_102,w:_101.offsetWidth,h:_101.offsetHeight};
},canvasOnMouseDown:function(_104){
var t=davinci.ve.widget.getEnclosingWidget(_104.target);
if(_104.target.id.indexOf("enableWidgetFocusFrame_")>-1){
t=_104.target._widget;
}
var _105=t;
while(_105){
if(_105.dvAttributes&&_105.dvAttributes.isThemeWidget&&_105.getContext()){
return;
}
_105=davinci.ve.widget.getEnclosingWidget(_105.domNode.parentNode);
}
if(this._selectedWidget&&(_104.target.className.indexOf("editFeedback")<0)){
_104.stopPropagation();
var a=[null];
this.getContext().getCommandStack().execute(new _77({_themeEditor:this,_widget:a,_firstRun:true}));
this.getContext().select(null,false);
}
},editFrameOnMouseDown:function(_106){
_106.stopPropagation();
if(this.getContext()._activeTool&&this.getContext()._activeTool.onMouseDown){
this.getContext()._activeTool.onMouseDown(_106);
}
},enableWidget:function(_107){
if(!_107){
return;
}
var _108=this.getContext().getDocument().getElementById("disableWidgetFocusFrame_"+_107.id);
if(_108){
_108.parentNode.removeChild(_108);
}
this._createFrame(_107,"enableWidgetFocusFrame_","enableWidgetFocusFrame");
},getRules:function(_109,_10a,_10b){
var _10c=this._loadCssSelectors(_109,_10a,_10b);
var _10d=[];
for(var s=0;s<_10c.length;s++){
var _10e=false;
var _10f=this.getContext()._getCssFiles();
if(_10f){
for(var i=0;i<_10f.length;i++){
var _110=_10f[i].getRules(_10c[s]);
for(var sn=0;sn<_110.length;sn++){
var _111=_110[sn];
if(_111){
var rule=_111.searchUp("CSSRule");
if(rule){
_10d.push(rule);
_10e=true;
}
}
}
}
}
if(!_10e){
console.warn("[theme editor getRule] Rule not found in theme: "+_10c[s]);
}
}
return _10d;
},_contextLoaded:function(_112){
if(_112==this.getContext()){
this._registerScrollHandler();
}
},_registerScrollHandler:function(){
var _113=this.getContext();
if(!this._scrollHandler){
var _114=this.editorContainer;
var _115=dojo.query("iframe",_114.domNode)[0];
if(_115&&_115.contentDocument&&_115.contentDocument.body){
var _116=_115.contentDocument.body;
this._scrollHandler=dojo.connect(_115.contentDocument,"onscroll",this,function(e){
setTimeout(function(){
_113.clearCachedWidgetBounds();
_113.updateFocusAll();
},100);
});
}
}
}});
});
