var darkModeStylesNodeID = "darkModeStyles";

function addStyleString(str, nodeID) {
	var existingNode = document.getElementById(nodeID);
	if (existingNode != null) {
		existingNode.parentElement.removeChild(existingNode);
	}
	
	var node = document.createElement('style');
	node.id = nodeID;
	node.innerHTML = str;

	// Insert to HEAD before all others, so it will serve as a default, all other
	// specificity rules being equal. This allows clients to provide their own
	// high level body {} rules for example, and supersede ours.
	document.head.insertBefore(node, document.head.firstElementChild);
}

// For dark mode we impose CSS rules to fine-tune our styles for dark
function switchToDarkMode() {
	var darkModeStyles = "body { color: #d2d2d2; background-color: #2d2d2d; } body a:link { color: #4490e2; }";
	addStyleString(darkModeStyles, darkModeStylesNodeID);
}

// For light mode we simply remove the dark mode styles to revert to default colors
function switchToLightMode() {
	var darkModeStyleElement = document.getElementById(darkModeStylesNodeID);
	if (darkModeStyleElement != null) {
		darkModeStyleElement.parentElement.removeChild(darkModeStyleElement);
	}
}
