function net = netinit(net, prior)
%NETINIT Initialise the weights in a network.
%
%	Description
%
%	NET = NETINIT(NET, PRIOR) takes a network data structure NET and sets
%	the weights and biases by sampling from a Gaussian distribution. If
%	PRIOR is a scalar, then all of the parameters (weights and biases)
%	are sampled from a single isotropic Gaussian with inverse variance
%	equal to PRIOR. If PRIOR is a data structure of the kind generated by
%	MLPPRIOR, then the parameters are sampled from multiple Gaussians
%	according to their groupings (defined by the INDEX field) with
%	corresponding variances (defined by the ALPHA field).
%
%	See also
%	MLPPRIOR, NETUNPAK, RBFPRIOR
%

%	Copyright (c) Ian T Nabney (1996-2001)

if isstruct(prior)
    if (isfield(net, 'mask'))
	if find(sum(prior.index, 2)) ~= find(net.mask)
	    error('Index does not match mask');
	end
	sig = sqrt(prior.index*prior.alpha);
	% Weights corresponding to zeros in mask will not be used anyway
	% Set their priors to one to avoid division by zero
	sig = sig + (sig == 0);  
	sig = 1./sqrt(sig);
    else
	sig = 1./sqrt(prior.index*prior.alpha);
    end
    w = sig'.*randn(1, net.nwts); 
elseif size(prior) == [1 1]
  w = randn(1, net.nwts).*sqrt(1/prior);
else
  error('prior must be a scalar or a structure');
end  

if (isfield(net, 'mask'))
    w = w(logical(net.mask));
end
net = netunpak(net, w);

