local hit_effects = require ("__base__/prototypes/entity/hit-effects.lua")
local sounds = require("__base__/prototypes/entity/sounds.lua")


data:extend({
	{
    type = "furnace",
    name = "mega-furnace",
    icon = "__Mega-Furnace__/graphics/icons/mega-furnace.png",
    icon_size = 64, icon_mipmaps = 4,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "mega-furnace"},
    max_health = 850,
    corpse = "electric-furnace-remnants",
    dying_explosion = "electric-furnace-explosion",
    resistances = 
		{
			{type = "fire", percent = 100},
			{type = "acid", percent = 100}
		},
		collision_box = {{-2.2, -2.2}, {2.2, 2.2}},
		selection_box = {{-2.5, -2.5}, {2.5, 2.5}},
    damaged_trigger_effect = hit_effects.entity(),
    module_specification =
	{
		module_slots = 3,
		module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    crafting_categories = {"smelting"},
    result_inventory_size = 1,
    crafting_speed = 10,
    energy_usage = "1.2MW",
    source_inventory_size = 1,
    energy_source =
    {
		type = "electric",
		usage_priority = "secondary-input",
		emissions_per_minute = 0.75
    },
    vehicle_impact_sound = sounds.generic_impact,
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    working_sound =
    {
		sound =
		{
			filename = "__base__/sound/electric-furnace.ogg",
			volume = 0.6
		},
		audible_distance_modifier = 0.6,
		fade_in_ticks = 4,
		fade_out_ticks = 20
    },
    animation = 
	{
		layers =
		{
			{
				filename = "__Mega-Furnace__/graphics/entity/mega-furnace.png",
				priority = "high",
				width = 230,
				height = 230,
				frame_count = 1,
				scale = 0.8,
				shift = util.by_pixel(0,0),
			},
			{
				filename = "__Mega-Furnace__/graphics/entity/lab_shadow.png",
				priority = "high",
				width = 230,
				height = 230,
				frame_count = 1,
				scale = 0.8,
				shift = util.by_pixel(30,0),
				draw_as_shadow = true
			},
			{
				filename = "__Mega-Furnace__/graphics/entity/lab_albedo_ao.png",
				priority = "high",
				width = 230,
				height = 230,
				frame_count = 1,
				scale = 0.8,
				shift = util.by_pixel(0,-14),
			}
		}
	},
    working_visualisations =
    {
		{
		animation = 
			{
			filename = "__Mega-Furnace__/graphics/entity/gr/1.png",
			priority = "high",
			width = 130,
			height = 130,
			frame_count = 10,
			scale =  1.387,
			blend_mode = "additive-soft",
			shift = util.by_pixel(0,0),
			animation_speed = 0.04,
			}
		},
		{
		animation = 
			{
			filename = "__Mega-Furnace__/graphics/entity/gr/mega-furnace.png",
			priority = "high",
			width = 230,
			height = 230,
			frame_count = 1,
			scale = 0.8,
			blend_mode = "additive-soft",
			shift = util.by_pixel(0,0),
			animation_speed = 0.3,
			},
		light = {intensity = 0.4, size = 6, shift = {1.9, 2}, color = {r = 255, g = 69, b = 0}}
		},
		{ 
		light = {intensity = 0.4, size = 6, shift = {-1.9, 2}, color = {r = 255, g = 69, b = 0}}
		},
		{
		light = {intensity = 0.4, size = 7, shift = {0, -1}, color = {r = 255, g = 69, b = 0}}
		}
	},
    fast_replaceable_group = "furnace"
	}
})