﻿if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Categories_Insert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
    drop procedure [dbo].[Categories_Insert]
GO
------------------------------------
-- 功能描述：增加一条记录 
-- 所属表格：Categories[ ]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
DECLARE @CategoryID int -- 类别ID
    SET @CategoryID = 
DECLARE @CategoryName nvarchar(15) -- 类别名称
    SET @CategoryName =  ' '
DECLARE @Description ntext -- 说明
    SET @Description =  ' '
DECLARE @Picture image -- 图片
    SET @Picture = 
 -- 调用存储过程 
 exec [Categories_Insert] @CategoryID,@CategoryName,@Description,@Picture
 */
------------------------------------
CREATE PROCEDURE [Categories_Insert] (
@CategoryID    int = NULL,            -- 类别ID
@CategoryName  nvarchar(15) = NULL,   -- 类别名称
@Description   ntext = NULL,          -- 说明
@Picture       image = NULL           -- 图片

)
AS
INSERT INTO Categories(
	[CategoryName],[Description],[Picture]	 
)VALUES( 
	@CategoryName,@Description,@Picture	
)
SELECT @ID = SCOPE_IDENTITY() -- 返回新加记录的唯一标识
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Categories_Edit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Categories_Edit]
GO
------------------------------------
-- 功能描述：修改一条记录 
-- 所属表格：Categories[]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /* -- 测试代码 --
 -- 参数设置 
DECLARE @CategoryID int -- 类别ID
    SET @CategoryID = 
DECLARE @CategoryName nvarchar(15) -- 类别名称
    SET @CategoryName =  ' '
DECLARE @Description ntext -- 说明
    SET @Description =  ' '
DECLARE @Picture image -- 图片
    SET @Picture = 
 -- 调用存储过程 
 exec [Categories_Edit] @CategoryID,@CategoryName,@Description,@Picture 
 */
------------------------------------
CREATE PROCEDURE [Categories_Edit]
@CategoryID    int = NULL,            -- 类别ID
@CategoryName  nvarchar(15) = NULL,   -- 类别名称
@Description   ntext = NULL,          -- 说明
@Picture       image = NULL           -- 图片

AS 
UPDATE Categories SET 
	 [CategoryName] = @CategoryName, [Description] = @Description, [Picture] = @Picture
WHERE 
	 [CategoryID] = @CategoryID
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Categories_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Categories_Delete]
GO
------------------------------------
-- 功能描述：删除一条记录 
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
 -- 调用存储过程 
DECLARE @ID int
    set @ID=0
 exec [Categories_Delete] @ID
 */
------------------------------------
CREATE PROCEDURE [Categories_Delete]
	@CategoryID int --待删除的主键
AS 
   
	    DELETE FROM [Categories]	    WHERE CategoryID = @CategoryID 
     
     
GO   
     


