﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>    
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>  
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">

    //RowPostPaint绘制行号
    private void dataGridView1_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
    {
    Rectangle rectangle = new Rectangle(e.RowBounds.Location.X,
    e.RowBounds.Location.Y,
    dataGridView1.RowHeadersWidth - 4,
    e.RowBounds.Height);

    TextRenderer.DrawText(e.Graphics, (e.RowIndex + 1).ToString(),
    dataGridView1.RowHeadersDefaultCellStyle.Font,
    rectangle,
    dataGridView1.RowHeadersDefaultCellStyle.ForeColor,
    TextFormatFlags.VerticalCenter | TextFormatFlags.Right);
    }
    //DataBindingComplete绘制行号
    private void dataGridView1_DataBindingComplete(object sender, DataGridViewBindingCompleteEventArgs e) {
    for (int i = 0; i &lt; dataGridView1.Rows.Count; i++) {
                dataGridView1.Rows[i].HeaderCell.Value = (i + 1).ToString();
            }
        }
     
     //利用　CellContextMenuStripNeeded　事件可以设定单元格的右键菜单，尤其但需要右键菜单根据单元格值的变化而变化的时候。
     //在DataGridView使用了DataSource绑定而且是VirtualMode的时候，该事件将不被引发
      private void DataGridView1_CellContextMenuStripNeeded(object sender,DataGridViewCellContextMenuStripNeededEventArgs e){ 
        DataGridView dgv = (DataGridView)sender; 
        if (e.RowIndex &lt; 0) 
        { 
            //　列头的ContextMenuStrip设定 
            e.ContextMenuStrip = this.ContextMenuStrip1; 
        } 
        else if (e.ColumnIndex &lt; 0) 
        { 
            //　行头的ContextMenuStrip设定 
            e.ContextMenuStrip = this.ContextMenuStrip2; 
        } 
        else if (dgv[e.ColumnIndex, e.RowIndex].Value is int) 
        { 
            //　如果单元格值是整数时 
            e.ContextMenuStrip = this.ContextMenuStrip3; 
        } 
    } 
    //RowContextMenuStripNeeded　事件来设定行的右键菜单。 
    private void DataGridView1_RowContextMenuStripNeeded(object sender, DataGridViewRowContextMenuStripNeededEventArgs e) 
    { 
        DataGridView dgv = (DataGridView)sender; 
        //　当"Column1"列是Bool型且为True时、设定其的ContextMenuStrip 
        object boolVal = dgv["Column1", e.RowIndex].Value; 
        Console.WriteLine(boolVal); 
        if (boolVal is bool &amp;&amp; (bool)boolVal) 
        { 
            e.ContextMenuStrip = this.ContextMenuStrip1; 
        } 
    }
          //右键选择行并弹出右键菜单
      private void dataGridView1_CellMouseDown(object sender, DataGridViewCellMouseEventArgs e)
      {
          //点击的是鼠标右键，并且不是表头 
          if (e.Button == System.Windows.Forms.MouseButtons.Right  &amp;&amp; e.ColumnIndex > -1  &amp;&amp; e.RowIndex > -1)  {
    if (this.dataGridView1.CurrentCell != null){
    dataGridView1.CurrentCell.Selected = false;
    }
    dataGridView1.Rows[e.RowIndex].Selected = true;
    dataGridView1.CurrentCell = dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex];
    //弹出右键菜单(不需要设置datagridview的ContxtMenuStrip属性)
    this.contextMenuStrip1.Show(MousePosition.X, MousePosition.Y); //MousePosition.X, MousePosition.Y 是为了让菜单在所选行的位置显示
    }
    }
    //单元格单击和双击
    private void dataGridView1_CellDoubleClick(object sender, DataGridViewCellEventArgs e) {
      if (e.ColumnIndex > -1 &amp;&amp; e.RowIndex > -1) {
        string Id = dataGridView1.Rows[e.RowIndex].Cells["g1Id"].Value.ToString(); 
      }
    }
  </xsl:template> 
</xsl:stylesheet>
