﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:variable name="number" select="1" />
<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<meta http_equiv="Content-Type" content="text/html; charset=UTF-8"/>
<body>
  <style type="text/css">
    html, body
    {
    font-size: 12px;
    padding: 0;
    margin: 0;
    border: 0;
    height: 100%;
    }
    table{border:solid 1px #e0e0e0;}
    th{font-size: 12px;background-color:#f9f9f9;padding:4px;text-align:left;}
    td{font-size: 12px;padding:2px;border-bottom:solid 1px #f1f1f1;}
    .css1 {background-color: #ffffff;}
    .css2 {background-color: #DFFFBF;}
    .tbNameLink{cursor: pointer;color:black;text-decoration:none;}
  </style>
  <script language="javascript">
    function mouseOver(obj){
    if(obj.className="css1")
    obj.className="css2";
    }
    function mouseOut(obj){
    if(obj.className="css2")
    obj.className="css1";
    }
    function showColumns(tbId){
    if(document.getElementById(tbId).style.display=="block"){
    document.getElementById(tbId).style.display="none";
    }else{
    document.getElementById(tbId).style.display="block";
    }
    }
    function showTbIndex(){
    if(document.getElementById("tbx0").style.display=="block"){
    document.getElementById("tbx0").style.display="none";
    }else{
    document.getElementById("tbx0").style.display="block";
    }
    }
    <xsl:text disable-output-escaping="yes">
    <![CDATA[
      function VisibeAll(){
        var cnt = document.getElementById("tbcount").value;    
        for(var i=0;i<=cnt; i++){
            document.getElementById("tbx"+i).style.display="block";
        }
      }
      function HiddenAll(){
        var cnt = document.getElementById("tbcount").value;
        for(var i=0;i<=cnt; i++){
            document.getElementById("tbx"+i).style.display="none";
      }
    }
    ]]>
    </xsl:text> 
  </script>
<center>
  <div style="font-size:20px;margin-top:10px;">项目文档</div>
  <table border="0" width="80%" style="margin-top:10px;">
    <tr >
      <td>项目名称：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/@Name"/>
      </td>
      <td>开发语言：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/@Language"/>
      </td>
      <td>系统结构：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/@ModeType"/>
      </td>
      <td>命名空间：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/@NameSpace"/>
      </td>
    </tr>
    <tr >
      <td>模板名称：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/@UserMouldName"/>
      </td>
      <td>模板文件：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/Template/@File"/>
      </td>       
    </tr>
    <tr >
      <td>数据库类型：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/Database/@DbType"/>
      </td>
      <td>服务器：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/Database/@Server"/>
      </td>
    </tr>
    <tr >
      <td>项目作者：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/Remark/@CreateAuthor"/>
      </td>
      <td>项目日期：</td>
      <td>
        <xsl:value-of select="/MengmaCodeHelper/Project/Remark/@CreateDate"/>
      </td> 
    </tr>
  </table>
  <div style="width:80%;margin-top:10px; text-align:left;">
    <a name="tbIndex"></a>
    <input id="tbcount" type="hidden" >
      <xsl:attribute name="value">
        <xsl:value-of select="count(MengmaCodeHelper/Server/Database/Table)" />
      </xsl:attribute>
    </input>
    <span onclick="VisibeAll()" style="cursor: pointer;color:black;">→展开所有表格</span>
    &#xa0;&#xa0;
    <span onclick="HiddenAll()" style="cursor: pointer;color:black;">→收起所有表格</span>
  </div>
  <table  border="0" width="80%" style="margin-top:5px;">
    <tr>
      <th >
        <span style="cursor: pointer;" onclick="showTbIndex()" title="展开/收起表格索引">表格索引目录,&#xa0;总共&#xa0;<xsl:value-of select="count(MengmaCodeHelper/Server/Database/Table)" />&#xa0;个表格
      </span></th>
    </tr>
  </table>
  <table id="tbx0" border="0" width="80%" style="display:block;border-top:none;">
    <tr>
      <th >表名称</th>
        <th >
          主键</th>
          <th >表备注</th><!--string-length(@Name) - (string-length('log'))-->
    </tr>
    <xsl:for-each select="MengmaCodeHelper/Server/Database/Table">
      <tr class="css1" onMouseOver="mouseOver(this)" onMouseOut="mouseOut(this)">
        <td>
          <a href="#" style="text-decoration:none;" title="点击查看表结构">          
            <xsl:attribute name="href">
              <xsl:value-of select="concat('#',@Name)" />
            </xsl:attribute>
            <xsl:value-of select="position()"/>、<xsl:value-of select="@Name"></xsl:value-of>
          </a>
        </td> 
        <td>
          <xsl:value-of select="@PrimaryKey"></xsl:value-of>
        </td>
        <td>
          <xsl:value-of select="@Remark"></xsl:value-of>
        </td>
      </tr>
    </xsl:for-each>
  </table>  
 
  <xsl:for-each select="MengmaCodeHelper/Server/Database/Table">
    <table border="0" width="80%" style="margin-top:5px;">   
    <tr >
      <th width="360">
        <a href="#tbIndex" title="返回索引" style="margin-right:10px;cursor: pointer;">
          [↑]
        </a>
        <xsl:value-of select="position()"/>.
        <a title="点击展开/隐藏" class="tbNameLink">
           
           <xsl:attribute name="name">
             <xsl:value-of select="@Name" />
           </xsl:attribute>
           <xsl:attribute name="onclick">
             <xsl:value-of select="concat('showColumns(&quot;tbx',position(),'&quot;)')" />
           </xsl:attribute>         
           <xsl:value-of select="@Name"/>    
       </a> 
      </th>
      <th>
       <xsl:value-of select="@Remark"></xsl:value-of>
      </th>
    </tr> 
    </table>
    <table border="0" width="80%" style="display:none;border-top:none;">
      <xsl:attribute name="id">
        <xsl:value-of select="concat('tbx',position())" />
      </xsl:attribute>     
      <tr>
              <th style="width:30px">
                序号
              </th>
              <th style="width:100px">
                别名
              </th>
              <th style="width:100px">
                列名
              </th>
              <th style="width:100px">
                数据类型
              </th>
              <th style="width:60px">
                长度
              </th>
              <th style="width:60px">
                是否主键
              </th>
              <th style="width:60px">
               是否自增
              </th>
              <th style="width:60px">
                允许为空
              </th>
              <th style="width:80px">
                默认值
              </th>
              <th >备注</th>
            </tr>
      <xsl:for-each select="./Column">
              <tr class="css1" onMouseOver="mouseOver(this)" onMouseOut="mouseOut(this)">
                <td>
                  <xsl:value-of select="@No"></xsl:value-of>
                </td>
                <td>
                  <xsl:value-of select="@Caption"></xsl:value-of>
                </td>
                <td>                  
                  <xsl:value-of select="@Name"></xsl:value-of>
                </td>
                <td>
                  <xsl:value-of select="@Datatype"></xsl:value-of>
                </td>                
                <td>
                  <xsl:value-of select="@Length"></xsl:value-of>
                </td>
                <td>
                  
                  <xsl:choose>
                    <xsl:when test="@InPrimaryKey != ''">
                      <xsl:value-of select="@InPrimaryKey"></xsl:value-of>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
                <td> 
                  <xsl:choose>
                    <xsl:when test="@Identity != ''">
                      <xsl:value-of select="@Identity"></xsl:value-of>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
                <td>
                  <xsl:choose>
                    <xsl:when test="@AllowNulls != ''">
                      <xsl:value-of select="@AllowNulls"></xsl:value-of>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                    </xsl:otherwise>
                  </xsl:choose>                  
                </td>
                <td>
                  <xsl:choose>
                    <xsl:when test="@DefaultValue != ''">
                      <xsl:value-of select="@DefaultValue"></xsl:value-of>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                    </xsl:otherwise>
                  </xsl:choose> 
                </td>
                <td>
                  <xsl:value-of select="@Remark"></xsl:value-of>
                </td>
              </tr>
                </xsl:for-each>
     </table>      
  </xsl:for-each>  
</center>
</body>
</html>
</xsl:template>
</xsl:stylesheet>