﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Newtonsoft.Json;
namespace Mammonth.Common {
    /// <summary>
    /// 自定义全局对象
    /// </summary>
    /// <remarks>
    /// 创建：zhaoshunlu@163.com 2013-9-23
    /// </remarks>
    public class Globals {
        /// <summary>
        /// 在线人员列表
        /// </summary>
        public static Hashtable hastbOnLine = new Hashtable();

        /// <summary>
        /// 消息表
        /// </summary>
        public static Hashtable hastbMsg = new Hashtable();

        /// <summary>
        /// 在线人数统计
        /// </summary>
        public static int OnLine = 0;
    }
    /// <summary>
    /// 登录用户信息
    /// 设置全局变量
    /// </summary>
    public class LoginAdminStruct {
        /// <summary>
        /// 登录回话ID
        /// </summary>
        public string SessionID = "";
        /// <summary>
        /// 用户ID
        /// </summary>
        public string UserID;
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName;
        /// <summary>
        /// 用户性别
        /// </summary>
        public string UserSex;
        /// <summary>
        /// 所属权限组ID
        /// </summary>
        public int RightGroupID = 0;

        /// <summary>
        /// 用户个人权限哈希表 (JsonIgnore)
        /// </summary>  
        /// <remarks>
        /// 使用JsonConvert序列化时不序列化此字段，
        /// 为了减少返回的数据，因为用户权限项可能会有很多行记录
        /// </remarks>
        [JsonIgnore]
        public Hashtable UserPower = new Hashtable();

        /// <summary>
        /// 当前指定权限项的权限信息
        /// 根据指定的权限项不同经常变换
        /// </summary>
        public Hashtable AccessPower = new Hashtable();

        /// <summary>
        /// 登录次数
        /// </summary>
        public int LoginCount = 0;
        /// <summary>
        /// 最后登录时间
        /// </summary>
        public string LastLoginTime = "";
        /// <summary>
        /// 最后登录IP
        /// </summary>
        public string LastLoginIP = "";
    }

    public struct OnLineUser {
        public string UserCode;
        public string UserName;
        public string Sex;
        public string CompanyCode;
        public string DepartName;
        public string SessionID;
        public string LoginIP;
        public DateTime LoginTime;
        public OnLineUser(string userCode, string userName, string sex, string companyCode, string departName, string sessionID, string loginIP, DateTime loginTime) {
            UserCode = userCode;
            UserName = userName;
            Sex = sex;
            CompanyCode = companyCode;
            DepartName = departName;
            SessionID = sessionID;
            LoginIP = loginIP;
            LoginTime = loginTime;
        }
    };

    public struct OnLineMsg {
        public string MsgType; //消息类型：所有人,某个人
        public string SessionID;
        public string UserCode;
        public string Context;
        public DateTime TheTime;
        public OnLineMsg(string msgType, string userCode, string sessionID, string context, DateTime theTime) {
            MsgType = msgType;
            UserCode = userCode;  //不在线的也能接收
            SessionID = sessionID;//只是在线的接收
            Context = context;
            TheTime = theTime;
        }
    };
}
