﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace Mammonth.Common {

    /// <summary>
    /// 创建系统运行日记文件类
    /// 记录系统内部异常与调试信息
    /// </summary>
    /// <remarks>
    /// 创建人：zhaoshunlu
    /// 最后修改：2013-11-8
    /// </remarks>
    public class LogHelper {

        /// <summary>
        /// 日记保存文件夹完整物理路径
        /// </summary>
        public static string OutLogPath;

        /// <summary>
        /// 日记保存文件夹       
        /// </summary>
        /// <remarks>修改：2013-11-6</remarks>
        const string errorFolder = "_Error";

        /// <summary>
        /// 创建日记文件
        /// <para>默认保存在“\oa\_Error\”目录下</para>
        /// </summary>     
        /// <param name="logInfo">内容</param>
        /// <param name="source">来源</param>
        /// <param name="method">方法名称，可选参数，</param>
        /// <param name="companyCode">公司编码，可选参数，</param>
        /// <param name="forder">目标文件夹，可选，默认是"oa"</param>
        /// <returns>bool</returns>      
        /// <remarks>
        /// 创建：zhaoshunlu
        /// 维护：zhao 2013-11-8 增加一个可选参数forder
        /// </remarks>
        public static bool CreateLog(string logInfo, string source, string method = "", string companyCode = "", string forder = "oa") {
            if (string.IsNullOrEmpty(OutLogPath)) {

                OutLogPath = System.Configuration.ConfigurationManager.AppSettings["WebRoot"];//站点根目录物理路径如：E:\Mammonth\Mammonth\Mammonth.Web\
              
                if (string.IsNullOrEmpty(OutLogPath))
                    return false;

                if (!OutLogPath.EndsWith("\\")) {
                    OutLogPath += "\\";
                }

                if (!string.IsNullOrEmpty(forder)) {
                    if (forder.StartsWith("\\"))
                        forder = forder.Substring(1);
                    //
                    OutLogPath += forder;
                }

                if (!OutLogPath.EndsWith("\\"))
                    OutLogPath += "\\";

                OutLogPath += errorFolder;

                if (!string.IsNullOrEmpty(companyCode)) {
                    //
                    OutLogPath += "\\" + companyCode;
                }

                //不存在就创建log目录
                if (!System.IO.Directory.Exists(OutLogPath))
                    System.IO.Directory.CreateDirectory(OutLogPath);

            }

            Encoding encoding = Encoding.GetEncoding("utf-8");//
            StreamWriter sw = null;
            try {
                string outFilePath = OutLogPath + "\\" + System.DateTime.Now.ToString("yyyyMMdd") + ".log";
                //if (System.IO.File.Exists(outFilePath)) {
                //    System.IO.File.Delete(outFilePath);
                //} 
                StringBuilder sb = new StringBuilder();
                sb.Append("来源：");
                sb.AppendLine(source);
                if (string.IsNullOrEmpty(method)) {
                    sb.Append("方法：");
                    sb.AppendLine(method);
                }
                sb.Append("日期：");
                sb.AppendLine(System.DateTime.Now.ToString("yyyy-MM-dd HH:ss:mm"));
                sb.Append("信息：");
                sb.AppendLine(logInfo);
                sb.AppendLine("--------");

                sw = new StreamWriter(outFilePath, true, encoding);//文件不存在就创建,true表示追加
                sw.Write(sb.ToString());
                sw.Flush();
                //
                sw.Close();
            } catch { //(Exception ex)
                return false;
            } finally {
                sw = null;
            }
            return true;
        }
      
    }
}
