﻿using System.Data.Entity;
using System.Data.Objects;
using System.ComponentModel.DataAnnotations;
using System.Data.Entity.Infrastructure;
using Northwind.Model.Mapping;
using Northwind.Model;
namespace Northwind.DAL
{
    public class NorthwindContext : System.Data.Entity.DbContext
    {
        static NorthwindContext ()
        {
            Database.SetInitializer<NorthwindContext>(null);
        }

        public NorthwindContext ()
            : base("Name=ConnectionString") //web.config中配置数据库链接键
        {
            //是否启用自动生成代理类:
            //默认 true: 
            //     false:  禁用代理类，将不能通过导航属性访问关联数据。
            this.Configuration.ProxyCreationEnabled = false; 
           
            //是否启用延迟加载:
            //     true:   延迟加载（Lazy Loading）：获取实体时不会加载其导航属性，一旦用到导航属性就会自动加载
            //默认 false:  直接加载（Eager loading）：通过 Include 之类的方法显示加载导航属性，获取实体时会即时加载通过 Include 指定的导航属性
            this.Configuration.LazyLoadingEnabled = true;

            //是否自动监测变化，默认值为 true
            this.Configuration.AutoDetectChangesEnabled = true; 
        }
        //管理员 
        public DbSet<Northwind.Model.Admin> Admins { get; set; }
        //类别 
        public DbSet<Northwind.Model.Categories> Categoriess { get; set; }
        //客户 
        public DbSet<Northwind.Model.Customers> Customerss { get; set; }
        //雇员 
        public DbSet<Northwind.Model.Employees> Employeess { get; set; }
        //订单明细 
        public DbSet<Northwind.Model.OrderDetails> OrderDetailss { get; set; }
        //订单 
        public DbSet<Northwind.Model.Orders> Orderss { get; set; }
        //产品 
        public DbSet<Northwind.Model.Products> Productss { get; set; }
        //地区 
        public DbSet<Northwind.Model.Region> Regions { get; set; }
        //运货商 
        public DbSet<Northwind.Model.Shippers> Shipperss { get; set; }
        //供应商 
        public DbSet<Northwind.Model.Suppliers> Supplierss { get; set; }
        //领域 
        public DbSet<Northwind.Model.Territories> Territoriess { get; set; }

        //通过构建器来覆盖默认约定,使用Fluent API 来修改模型
        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Conventions.Remove<IncludeMetadataConvention>();
            //管理员 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.AdminMap());
            //类别 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.CategoriesMap());
            //客户 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.CustomersMap());
            //雇员 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.EmployeesMap());
            //订单明细 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.OrderDetailsMap());
            //订单 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.OrdersMap());
            //产品 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.ProductsMap());
            //地区 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.RegionMap());
            //运货商 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.ShippersMap());
            //供应商 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.SuppliersMap());
            //领域 
            modelBuilder.Configurations.Add(new Northwind.Model.Mapping.TerritoriesMap());



        }

        //    public static void Update<TEntity>(this DbContext dbContext, Expression<Func<TEntity, object>> propertyExpression, params TEntity[] entities)
        //    where TEntity : EntityBase {
        //        if (propertyExpression == null) throw new ArgumentNullException("propertyExpression");
        //        if (entities == null) throw new ArgumentNullException("entities");
        //        ReadOnlyCollection<MemberInfo> memberInfos = ((dynamic)propertyExpression.Body).Members;
        //        foreach (TEntity entity in entities) {
        //            try {
        //                DbEntityEntry<TEntity> entry = dbContext.Entry(entity);
        //                entry.State = EntityState.Unchanged;
        //                foreach (var memberInfo in memberInfos) {
        //                    entry.Property(memberInfo.Name).IsModified = true;
        //                }
        //            } catch (InvalidOperationException) {
        //                TEntity originalEntity = dbContext.Set<TEntity>().Local.Single(m => m.Id == entity.Id);
        //                ObjectContext objectContext = ((IObjectContextAdapter)dbContext).ObjectContext;
        //                ObjectStateEntry objectEntry = objectContext.ObjectStateManager.GetObjectStateEntry(originalEntity);
        //                objectEntry.ApplyCurrentValues(entity);
        //                objectEntry.ChangeState(EntityState.Unchanged);
        //                foreach (var memberInfo in memberInfos) {
        //                    objectEntry.SetModifiedProperty(memberInfo.Name);
        //                }
        //            }
        //        }
        //    } 
    }
}