﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 管理员（Admin）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class AdminMap : EntityTypeConfiguration<Northwind.Model.Admin>
    {
        /// <summary>
        /// 管理员
        /// </summary>
        public AdminMap()
        {
            // Primary Key           
            this.HasKey(t => t.ID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Admin");
            this.Property(t => t.ID).HasColumnName("ID").HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            this.Property(t => t.Name).HasColumnName("Name").HasMaxLength(50);
            this.Property(t => t.PassWord).HasColumnName("PassWord").HasMaxLength(50).IsRequired();
            this.Property(t => t.Logins).HasColumnName("Logins");
            this.Property(t => t.LastTime).HasColumnName("LastTime");


            // Relationships HasOptional,HasRequired

        }
    }
}
