﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 类别（Categories）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class CategoriesMap : EntityTypeConfiguration<Northwind.Model.Categories>
    {
        /// <summary>
        /// 类别
        /// </summary>
        public CategoriesMap()
        {
            // Primary Key           
            this.HasKey(t => t.CategoryID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Categories");
            this.Property(t => t.CategoryID).HasColumnName("CategoryID").HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            this.Property(t => t.CategoryName).HasColumnName("categoryName").HasMaxLength(15);
            this.Property(t => t.Description).HasColumnName("description");
            this.Property(t => t.Picture).HasColumnName("Picture");


            // Relationships HasOptional,HasRequired

        }
    }
}
