﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 客户（Customers）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class CustomersMap : EntityTypeConfiguration<Northwind.Model.Customers>
    {
        /// <summary>
        /// 客户
        /// </summary>
        public CustomersMap()
        {
            // Primary Key           
            this.HasKey(t => t.CustomerID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Customers");
            this.Property(t => t.CustomerID).HasColumnName("CustomerID");
            this.Property(t => t.CompanyName).HasColumnName("CompanyName").HasMaxLength(40);
            this.Property(t => t.PassWord).HasColumnName("PassWord").HasMaxLength(50);
            this.Property(t => t.ContactName).HasColumnName("ContactName").HasMaxLength(30);
            this.Property(t => t.ContactTitle).HasColumnName("ContactTitle").HasMaxLength(30);
            this.Property(t => t.Address).HasColumnName("Address").HasMaxLength(60);
            this.Property(t => t.City).HasColumnName("City").HasMaxLength(15);
            this.Property(t => t.Region).HasColumnName("Region").HasMaxLength(15);
            this.Property(t => t.PostalCode).HasColumnName("PostalCode").HasMaxLength(10);
            this.Property(t => t.Country).HasColumnName("Country").HasMaxLength(15);
            this.Property(t => t.Phone).HasColumnName("Phone").HasMaxLength(24);
            this.Property(t => t.Fax).HasColumnName("Fax").HasMaxLength(24);


            // Relationships HasOptional,HasRequired

        }
    }
}
