﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 雇员（Employees）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:28
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class EmployeesMap : EntityTypeConfiguration<Northwind.Model.Employees>
    {
        /// <summary>
        /// 雇员
        /// </summary>
        public EmployeesMap()
        {
            // Primary Key           
            this.HasKey(t => t.EmployeeID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Employees");
            this.Property(t => t.EmployeeID).HasColumnName("EmployeeID").HasDatabaseGeneratedOption(DatabaseGeneratedOption.Identity);
            this.Property(t => t.LastName).HasColumnName("LastName").HasMaxLength(20);
            this.Property(t => t.FirstName).HasColumnName("FirstName").HasMaxLength(10);
            this.Property(t => t.Title).HasColumnName("Title").HasMaxLength(30);
            this.Property(t => t.TitleOfCourtesy).HasColumnName("TitleOfCourtesy").HasMaxLength(25);
            this.Property(t => t.BirthDate).HasColumnName("BirthDate");
            this.Property(t => t.HireDate).HasColumnName("HireDate");
            this.Property(t => t.Address).HasColumnName("Address").HasMaxLength(60);
            this.Property(t => t.City).HasColumnName("City").HasMaxLength(15);
            this.Property(t => t.Region).HasColumnName("Region").HasMaxLength(15);
            this.Property(t => t.PostalCode).HasColumnName("PostalCode").HasMaxLength(10);
            this.Property(t => t.Country).HasColumnName("Country").HasMaxLength(15);
            this.Property(t => t.HomePhone).HasColumnName("HomePhone").HasMaxLength(24);
            this.Property(t => t.Extension).HasColumnName("Extension").HasMaxLength(4);
            this.Property(t => t.Photo).HasColumnName("Photo");
            this.Property(t => t.Notes).HasColumnName("Notes");
            this.Property(t => t.ReportsTo).HasColumnName("ReportsTo");
            this.Property(t => t.PhotoPath).HasColumnName("PhotoPath").HasMaxLength(255);


            // Relationships HasOptional,HasRequired

        }
    }
}
