﻿using System.Data.Entity.ModelConfiguration;
using System.ComponentModel.DataAnnotations;

namespace Northwind.Model.Mapping
{
    /// <summary>
    /// 订单明细（Order Details）  
    /// </summary>
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:28
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class OrderDetailsMap : EntityTypeConfiguration<Northwind.Model.OrderDetails>
    {
        /// <summary>
        /// 订单明细
        /// </summary>
        public OrderDetailsMap()
        {
            // Primary Key           
            this.HasKey(t => t.OrderID);
 
            // NotMapped
            this.Ignore(t => t._uid);
            this.Ignore(t => t._index);
            this.Ignore(t => t._state);
            this.Ignore(t => t._tag);
            this.Ignore(t => t._tag2);
            
            //属性赋值检查，如果失败就会抛出如下异常信息：
            //Validation failed for one or more entities. See 'EntityValidationErrors' property for more details.
            //用DbEntityValidationException异常类获取具体的是哪个属性赋值错误
          
            // Properties
            //YourProperties

            // Table & Column Mappings
            this.ToTable("Order Details");
            this.Property(t => t.OrderID).HasColumnName("OrderID");
            this.Property(t => t.ProductID).HasColumnName("ProductID");
            this.Property(t => t.UnitPrice).HasColumnName("UnitPrice").IsRequired();
            this.Property(t => t.Quantity).HasColumnName("Quantity").IsRequired();
            this.Property(t => t.Discount).HasColumnName("Discount").IsRequired();


            // Relationships HasOptional,HasRequired
            //this.HasRequired(t => t.Orders)         // 主表 
            //	.WithMany(m => m.OrderDetailss)             // 一对多 一个Orders可以有多个OrderDetails
            // 	.HasForeignKey(t => t.OrderID);        // 外键 
            //this.HasRequired(t => t.Products)         // 主表 
            //	.WithMany(m => m.OrderDetailss)             // 一对多 一个Products可以有多个OrderDetails
            // 	.HasForeignKey(t => t.ProductID);        // 外键 

        }
    }
}
