﻿// ****************************************************** 
// 文件名称(File Name)：       OrderDetails.cs
// 项目名称(Project Name)：    YourProjectName
// 功能描述(Description)：     订单明细 （数据模型）
// 数据表(Tables)：            Order Details（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
// 作者(Author)：              zhaoshunlu@163.com
// 日期(Create Date)：         2014-10-21 22:17:27
// 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
// 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
// 编码约定：                   命名规则(类名和属性名首字母必须大写)
// 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
//****************************************************** 
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Newtonsoft.Json; //[JsonIgnore]//使用JsonConvert序列化时不序列化此字段

namespace Northwind.Model {

    //保持与架构无关性的POCO类

    //命名规则：类名和属性名首字母必须大写    

    /// <summary>
    /// 订单明细（Order Details）
    /// </summary>               
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class OrderDetails : Northwind.Model._common {
        /// <summary>
        /// 订单明细
        /// </summary>
        public OrderDetails() {
            //不允许null的属性及设置有默认值的属性
			this.OrderID = 0 ;			// 订单ID Not NULL 
			this.ProductID = 0 ;			// 产品ID Not NULL 
			this.UnitPrice = 0 ;			// 单价 Not NULL 
			this.Quantity = 0 ;			// 数量 Not NULL 
			this.Discount = "0" ;			// 折扣 Not NULL 


        }

		/// <summary>
		/// 订单ID (Not NULL)
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "订单ID")]
        public int OrderID {get;set;}
		/// <summary>
		/// 产品ID (Not NULL)
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "产品ID")]
        public int ProductID {get;set;}
		/// <summary>
		/// 单价 (Not NULL)
		/// </summary>
		/// <value>decimal</value>
	    [Display(Name = "单价")]
        public decimal UnitPrice {get;set;}
		/// <summary>
		/// 数量 (Not NULL)
		/// </summary>
		/// <value>Int16</value>
	    [Display(Name = "数量")]
        public Int16 Quantity {get;set;}
		/// <summary>
		/// 折扣 (Not NULL)
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "折扣")]
        public string Discount {get;set;}


	    ///// <summary> 
	    ///// 订单(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Orders Orders {get;set;}
	    ///// <summary> 
	    ///// 产品(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Products Products {get;set;}


        
    }
}