﻿// ****************************************************** 
// 文件名称(File Name)：       Orders.cs
// 项目名称(Project Name)：    YourProjectName
// 功能描述(Description)：     订单 （数据模型）
// 数据表(Tables)：            Orders（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
// 作者(Author)：              zhaoshunlu@163.com
// 日期(Create Date)：         2014-10-21 22:17:27
// 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
// 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
// 编码约定：                   命名规则(类名和属性名首字母必须大写)
// 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
//****************************************************** 
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Newtonsoft.Json; //[JsonIgnore]//使用JsonConvert序列化时不序列化此字段

namespace Northwind.Model {

    //保持与架构无关性的POCO类

    //命名规则：类名和属性名首字母必须大写    

    /// <summary>
    /// 订单（Orders）
    /// </summary>               
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class Orders : Northwind.Model._common {
        /// <summary>
        /// 订单
        /// </summary>
        public Orders() {
            //不允许null的属性及设置有默认值的属性
			this.OrderID = 0 ;			// 订单ID Not NULL 
			//this.EmployeeID = 0 ;
			//this.OrderDate = System.DateTime.Now ;
			//this.RequiredDate = System.DateTime.Now ;
			//this.ShippedDate = System.DateTime.Now ;
			//this.ShipVia = 0 ;
			//this.Freight = 0 ;

			//OrderDetailss = new List<OrderDetails>();  

        }

		/// <summary>
		/// 订单ID (Not NULL)
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "订单ID")]
        public int OrderID {get;set;}
		/// <summary>
		/// 客户ID 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "客户ID")]
        public string CustomerID {get;set;}
		/// <summary>
		/// 雇员ID 
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "雇员ID")]
        public int? EmployeeID {get;set;}
		/// <summary>
		/// 订购日期 
		/// </summary>
		/// <value>System.DateTime</value>
	    [Display(Name = "订购日期")]
        public System.DateTime? OrderDate {get;set;}
		/// <summary>
		/// 发货日期 
		/// </summary>
		/// <value>System.DateTime</value>
	    [Display(Name = "发货日期")]
        public System.DateTime? RequiredDate {get;set;}
		/// <summary>
		/// 到货日期 
		/// </summary>
		/// <value>System.DateTime</value>
	    [Display(Name = "到货日期")]
        public System.DateTime? ShippedDate {get;set;}
		/// <summary>
		/// 运货商ID 
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "运货商ID")]
        public int? ShipVia {get;set;}
		/// <summary>
		/// 运货费 
		/// </summary>
		/// <value>decimal</value>
	    [Display(Name = "运货费")]
        public decimal? Freight {get;set;}
		/// <summary>
		/// 运货商 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "运货商")]
        public string ShipName {get;set;}
		/// <summary>
		/// 货主地址 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "货主地址")]
        public string ShipAddress {get;set;}
		/// <summary>
		/// 货主城市 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "货主城市")]
        public string ShipCity {get;set;}
		/// <summary>
		/// 货主国家 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "货主国家")]
        public string ShipRegion {get;set;}
		/// <summary>
		/// 货主邮政编码 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "货主邮政编码")]
        public string ShipPostalCode {get;set;}
		/// <summary>
		/// 货主国家 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "货主国家")]
        public string ShipCountry {get;set;}


	    ///// <summary> 
	    ///// 订单明细(子表) 
	    ///// </summary> 
	    //public virtual IList<OrderDetails> OrderDetailss {get;set;} 
	    ///// <summary> 
	    ///// 雇员(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Employees Employees {get;set;}
	    ///// <summary> 
	    ///// 运货商(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Shippers Shippers {get;set;}
	    ///// <summary> 
	    ///// 客户(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Customers Customers {get;set;}


        
    }
}