﻿// ****************************************************** 
// 文件名称(File Name)：       Products.cs
// 项目名称(Project Name)：    YourProjectName
// 功能描述(Description)：     产品 （数据模型）
// 数据表(Tables)：            Products（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
// 作者(Author)：              zhaoshunlu@163.com
// 日期(Create Date)：         2014-10-21 22:17:27
// 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
// 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
// 编码约定：                   命名规则(类名和属性名首字母必须大写)
// 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
//****************************************************** 
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Newtonsoft.Json; //[JsonIgnore]//使用JsonConvert序列化时不序列化此字段

namespace Northwind.Model {

    //保持与架构无关性的POCO类

    //命名规则：类名和属性名首字母必须大写    

    /// <summary>
    /// 产品（Products）
    /// </summary>               
    /// <remarks> 
    /// 创建人及日期：zhaoshunlu@163.com 2014-10-21 22:17:27
    /// <para>修改人、日期及内容:</para>
    /// </remarks>
    public class Products : Northwind.Model._common {
        /// <summary>
        /// 产品
        /// </summary>
        public Products() {
            //不允许null的属性及设置有默认值的属性
			this.ProductID = 0 ;			// 产品ID Not NULL 
			this.ProductName = "" ;			// 产品名称 Not NULL 
			//this.SupplierID = 0 ;
			//this.CategoryID = 0 ;
			//this.UnitPrice = 0 ;
			//this.UnitsInStock = 0 ;
			//this.UnitsOnOrder = 0 ;
			//this.ReorderLevel = 0 ;
			this.Discontinued = false ;			// 中止 Not NULL 

			//OrderDetailss = new List<OrderDetails>();  

        }

		/// <summary>
		/// 产品ID (Not NULL)
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "产品ID")]
        public int ProductID {get;set;}
		/// <summary>
		/// 产品名称 (Not NULL)
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "产品名称")]
        public string ProductName {get;set;}
		/// <summary>
		/// 供应商ID 
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "供应商ID")]
        public int? SupplierID {get;set;}
		/// <summary>
		/// 类别ID 
		/// </summary>
		/// <value>int</value>
	    [Display(Name = "类别ID")]
        public int? CategoryID {get;set;}
		/// <summary>
		/// 数量单位 
		/// </summary>
		/// <value>string</value>
	    [Display(Name = "数量单位")]
        public string QuantityPerUnit {get;set;}
		/// <summary>
		/// 单价 
		/// </summary>
		/// <value>decimal</value>
	    [Display(Name = "单价")]
        public decimal? UnitPrice {get;set;}
		/// <summary>
		/// 库存量 
		/// </summary>
		/// <value>Int16</value>
	    [Display(Name = "库存量")]
        public Int16? UnitsInStock {get;set;}
		/// <summary>
		/// 订购量 
		/// </summary>
		/// <value>Int16</value>
	    [Display(Name = "订购量")]
        public Int16? UnitsOnOrder {get;set;}
		/// <summary>
		/// 再订购量 
		/// </summary>
		/// <value>Int16</value>
	    [Display(Name = "再订购量")]
        public Int16? ReorderLevel {get;set;}
		/// <summary>
		/// 中止 (Not NULL)
		/// </summary>
		/// <value>bool</value>
	    [Display(Name = "中止")]
        public bool Discontinued {get;set;}


	    ///// <summary> 
	    ///// 订单明细(子表) 
	    ///// </summary> 
	    //public virtual IList<OrderDetails> OrderDetailss {get;set;} 
	    ///// <summary> 
	    ///// 供应商(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Suppliers Suppliers {get;set;}
	    ///// <summary> 
	    ///// 类别(主表) 
	    ///// </summary> 
	    //[JsonIgnore]
	    //public virtual Categories Categories {get;set;}


        
    }
}