﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Reflection;
using System.IO;
using System.Text;

namespace ITravelSystem.CommonLibs {
    /// <summary>
    /// PortalService 的摘要说明
    /// </summary>
    public class PortalService : IHttpHandler {
 
        #region 固定方法，无需修改
        /// <summary>
        /// web请求处理
        /// </summary>
        /// <param name="context"></param>
        public void ProcessRequest(HttpContext context) {
            string methodName = "", errorMsg = "", errorCode = "";
            //获取操作目标            
            if (!string.IsNullOrEmpty(context.Request["do"])) {
                methodName = context.Request["do"];
            } else if (!string.IsNullOrEmpty(context.Request["method"])) {
                methodName = context.Request["method"];
            } else {
                context.Response.Write("{error:\"没有必须的参数\"}");
                return;
            } 
            //执行目标操作   
            MethodInfo method = this.GetType().GetMethod(methodName);   //获取要执行的方法   
            if (method == null) {
                context.Response.Write("{error:\"没有找到方法" + methodName + "\",code:1100}");
                return;
            }
            //
            try {

                method.Invoke(this, null);      //调用方法

            } catch (Exception ex) {
               
            }  
        } 
        public bool IsReusable {
            get {
                return false;
            }
        }
        #endregion

        /// <summary>
        /// 保存一条记录(表单窗口新建和修改时调用次方法)
        /// </summary>
        public void SavePortalLayout() {
            //数据列        
            string UserName = HttpContext.Current.Request["UserName"];//= "张国强";//请使用UserCode ，应为名称可能会重复
            string UserCode = HttpContext.Current.Request["UserCode"];        
            string jsons = HttpContext.Current.Request["data"];         
 
            //保存布局对象到txt
            //string path = HttpContext.Current.Server.MapPath(string.Format("../_user/{0}", UserCode));
            //string tempFile = context.Request.PhysicalApplicationPath;//后面已经有\符号 如C:\inetpub\wwwroot\MyApplication\
            string path = HttpContext.Current.Request.PhysicalPath;//C:\inetpub\wwwroot\MyApplication\MyPages\default.aspx
            path = path.Substring(0, path.LastIndexOf("\\"));//如：C:\inetpub\wwwroot\MyApplication\MyPages
            path = path.Substring(0, path.LastIndexOf("\\"));//如：C:\inetpub\wwwroot\MyApplication

            if (!System.IO.Directory.Exists(path)) {//如果没有该用户的文件夹，就要新建一个
           
                System.IO.Directory.CreateDirectory(path);
                System.IO.Directory.CreateDirectory(path + "\\layout");
            }
            path =path + string.Format("\\_user\\{0}\\desk.txt", UserCode);

            //创建静态Json数据
            string msg;
            bool bSuccess = CreateJson(jsons, path,out msg);
            if (!bSuccess) {
                HttpContext.Current.Response.Write(msg);
            } else {
                HttpContext.Current.Response.Write("true");
            }           
        }

        /// <summary>
        /// 创建静态预览HTML文件
        /// </summary>     
        /// <param name="templateContext">模板表现形式</param>
        /// <param name="outFilePath">保存路径</param>
        /// <param name="append">是否追加文本 默认false表示不追加</param>
        /// <returns></returns>
        /// <remarks>
        /// creater: zhao        
        /// </remarks>
        public bool CreateJson(string templateContext, string outFilePath, out string msg,bool append = false) {
            msg = "";
            //数据与表现形式
            string OutPutPath =  outFilePath;      
            Encoding encoding = Encoding.GetEncoding("utf-8");//
            StreamWriter sw = null;
            try {                
                sw = new StreamWriter(OutPutPath, append, encoding);//文件不存在就创建,append,false表示不追加
                sw.Write(templateContext);
                sw.Flush();
                //
                sw.Close();
                return true;
            } catch (Exception ex) {
                msg = ex.Message;
                return false;
            } finally {
                if (sw != null)
                    sw = null;
            }
        }
    }
}