﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/"> 
  using System;
  using System.Collections.Generic;
  using System.Data;
  using System.Data.Entity;
  using System.Linq;
  using System.Web;
  using System.Web.Mvc;
  using <xsl:value-of select="$YourNameSpace"/>.Models;	
  using <xsl:value-of select="$YourNameSpace"/>.BLL;	
  namespace <xsl:copy-of select="$YourNameSpace"/>.Controllers {

      /// &lt;summary&gt;
      /// （<xsl:copy-of select="$YourTableName"/>）
      /// &lt;/summary&gt;
      /// &lt;remarks&gt;
      /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
      /// &lt;para&gt;修改人、日期及内容:&lt;/para&gt;
      /// &lt;/remarks&gt;
      public class <xsl:copy-of select="$YourClassName"/>Controller : Controller{        
        
        /// &lt;summary&gt;
        /// 声明接口 
        /// &lt;/summary&gt;
        <xsl:copy-of select="$YourNameSpace"/>.BLL.<xsl:copy-of select="$YourClassName"/>BLL bll = new <xsl:copy-of select="$YourNameSpace"/>.BLL.<xsl:copy-of select="$YourClassName"/>BLL();

        protected override void Dispose(bool disposing) {
          db.Dispose();
          base.Dispose(disposing);
        }
     

        #region 常用查询方法 GetNew()、GetRead()、GetEdit()、GetPage() 
        //
        // GET: /<xsl:copy-of select="$YourClassName"/>/GetNew
        public ActionResult GetNew()
        {
            return View();
        }
		
        /// &lt;summary&gt;
        /// 根据主键获取一个<xsl:copy-of select="$YourClassName"/>对象实体,可以指定属性
        /// &lt;/summary&gt;
        /// &lt;param name=<xsl:copy-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor" /><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public ActionResult GetRead(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>){
            <xsl:copy-of select="$YourClassName"/> model = db.<xsl:copy-of select="$YourClassName"/>s.Find(<xsl:copy-of select="$YourFristKey"/>);
            if (model == null){
                return HttpNotFound();
            }
            return View(model);
        }
		//
        // GET: /<xsl:copy-of select="$YourClassName"/>/Edit/5
        public ActionResult GetEdit(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>)
        {
            <xsl:copy-of select="$YourClassName"/> model = db.<xsl:copy-of select="$YourClassName"/>s.Find(<xsl:copy-of select="$YourFristKey"/>);
            if (model == null){
                return HttpNotFound();
            }
            return View(model);
        }
         
 
  
        /// &lt;summary&gt;
        /// 公用万能的获取分页记录的方法
        /// <para>使用前提:表必须有一个自动增长列ID,但不一定是主键</para>
        /// &lt;/summary&gt;
        /// <param name="TableName">表名</param>
        /// <param name="Fields">要查询的字段集合,查询所有设为空值或者null或者星号"*"</param>
        /// <param name="strWhere">查询的条件,无条件就设为空值或者null</param>
        /// <param name="PageSize">页面大小，每页显示数据行数</param>
        /// <param name="PageIndex">页码，从1开始，第一页是1</param>
        /// <param name="strOrderBy">排序字段，支持多个字段排序,不排序就设为空值或者null</param>
        /// <returns>返回DataSet或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public ActionResult GetPage(string Fields, string strWhere, int PageSize, int PageIndex, string strOrderBy)
        {           
		   return View(db.<xsl:copy-of select="$YourClassName"/>s.ToList());
        }

        #endregion

        #region 常用编辑方法 编辑数据  Insert()、Update()、Delete()
    
        /// &lt;summary&gt;
        /// 添加一条新<xsl:copy-of select="$YourClassName"/>记录
		/// POST: /<xsl:copy-of select="$YourClassName"/>/Insert
        /// &lt;/summary&gt;
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回自动编号，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
		[HttpPost]
        public ActionResult Insert(<xsl:copy-of select="$YourNameSpace"/>.Model.<xsl:copy-of select="$YourClassName"/> model)
        {
           if (ModelState.IsValid) {
                db.<xsl:copy-of select="$YourClassName"/>s.Add(model);
                db.SaveChanges();
                return RedirectToAction("Index");
            } 
            return View(model);
        }

        /// &lt;summary&gt;
        /// 更新一条新<xsl:copy-of select="$YourClassName"/>记录
		/// POST: /<xsl:copy-of select="$YourClassName"/>/Edit/5
        /// &lt;/summary&gt;
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回影响行数，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
		[HttpPost]
        public ActionResult Update(<xsl:copy-of select="$YourNameSpace"/>.Model.<xsl:copy-of select="$YourClassName"/> model) {
          if (ModelState.IsValid) {
                db.Entry(model).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(model);
        }

        /// &lt;summary&gt;
        /// 删除一条或者多条<xsl:copy-of select="$YourClassName"/>记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// &lt;/summary&gt;
        /// <returns>删除成功返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
		    [HttpPost, ActionName("Delete")]
        public ActionResult Delete(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>)
        {
		    <xsl:copy-of select="$YourClassName"/> model = db.<xsl:copy-of select="$YourClassName"/>s.Find(<xsl:copy-of select="$YourFristKey"/>);
          db.<xsl:copy-of select="$YourClassName"/>s.Remove(model);
          db.SaveChanges();
          return RedirectToAction("Index"); 
        }

        #endregion


        #region 你增加的新方法
        //
        //
        #endregion
      }
    }
  </xsl:template>
</xsl:stylesheet>