﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="commonfun.xsl"/>
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
    // ******************************************************
    // 文件名称(File Name)：       <xsl:value-of select="$YourClassName"/>.cs
    // 项目名称(Project Name)：    YourProjectName
    // 功能描述(Description)：      （数据模型）
    // 数据表(Tables)：            t_Administrators（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
    // 作者(Author)：              zhaoshunlu
    // 日期(Create Date)：         2014年02月19日 15:20:55
    // 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
    // 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
    // 编码约定：                   命名规则(类名和属性名首字母必须大写)
    // 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
    //******************************************************
	using System;
  using System.Collections.Generic;
  using System.Data;
  using System.Data.SqlClient;
  using System.Text;
  using System.Security.Cryptography;
  using <xsl:value-of select="$YourNameSpace"/>.Model;
  using Mengma.DBUtility;
  namespace <xsl:value-of select="$YourNameSpace"/>.DAL {

      /// &lt;summary&gt;
      /// （<xsl:value-of select="$YourTableName"/>）
      /// &lt;/summary&gt;
      /// &lt;remarks&gt;
      /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
      /// &lt;para&gt;修改人、日期及内容:&lt;/para&gt;
      /// &lt;/remarks&gt;
      public class <xsl:value-of select="$YourClassName"/>DAL{ 
        
		private string strError = ""; 
                        
        public <xsl:value-of select="$YourClassName"/>DAL() {
          
        }
        
        /// &lt;summary&gt;
        /// 返回DAL最后的底层异常信息    
        ///&lt;/summary&gt;
        /// <returns>异常信息</returns>
        public string GetLastError()
        {
          return strError;
        }

        #region 常规常用方法 查询数据 Exists()、GetModel()、GetList()、GetRecordCount()、GetPage()
        /// &lt;summary&gt;
        /// 是否存在该记录   
        ///&lt;/summary&gt;
        /// &lt;param name=<xsl:value-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <returns>存在返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/> <xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Exists(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:value-of select="$YourFristKey"/>)
        {
          string strSql = "SELECT COUNT(1) FROM [<xsl:value-of select="$YourTableName"/>] WHERE [<xsl:value-of select="$YourFristKey"/>] = @<xsl:value-of select="$YourFristKey"/>";
          SqlParameter[] parameters = { new SqlParameter("@<xsl:value-of select="$YourFristKey"/>", <xsl:value-of select="$YourFristKey"/>) };
          //
          return DbHelperSQL.Exists(strSql, parameters);
        }

        /// &lt;summary&gt;
        /// 根据主键获取一个<xsl:value-of select="$YourClassName"/>对象实体,可以指定属性
        /// &lt;/summary&gt;
        /// &lt;param name=<xsl:value-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor" /><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> GetModel(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:value-of select="$YourFristKey"/>)
        {
          return GetModel(<xsl:value-of select="$YourFristKey"/>, "*");
        }

        /// &lt;summary&gt;
        /// 根据主键获取一个<xsl:value-of select="$YourClassName"/>对象实体,可以指定属性
        /// &lt;/summary&gt;
        /// &lt;param name=<xsl:value-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <param name="Fields">要获取的属性名称,即字段名称，多个以逗号“,”分割，获取所有属性留空或者输入null或者“*”</param>
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> GetModel(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:value-of select="$YourFristKey"/>, string Fields)
        {
          if (string.IsNullOrEmpty(Fields)) Fields = "*";
          string strSql = string.Format("SELECT TOP 1 {0} FROM [<xsl:value-of select="$YourTableName"/>] WHERE [<xsl:value-of select="$YourFristKey"/>] = @<xsl:value-of select="$YourFristKey"/>", Fields);
          SqlParameter[] parameters = { new SqlParameter("@<xsl:value-of select="$YourFristKey"/>", <xsl:value-of select="$YourFristKey"/>) };

          SqlDataReader dr = DbHelperSQL.ExecuteReader(strSql.ToString(), parameters);
          if (dr.HasRows){
            <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> model = new <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/>();
            while (dr.Read()){
              <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
			  <xsl:variable name="Datatype" select="@Datatype"/>			  
			  <xsl:variable name="groupid" select="/MengmaCodeHelper/DataTypeMapping/DataTypes/Item[@name=$Datatype]/@groupid"/>			  
			  <xsl:variable name="titleInfo" select="/MengmaCodeHelper/DataTypeMapping/Mapping/Group[@groupid=$groupid]/DataType/@SetFormat"/>model.<xsl:value-of select="@Property"/> = <xsl:call-template name="string-replace-all"><xsl:with-param name="text" select="$titleInfo"/><xsl:with-param name="replace" select="'{0}'"/><xsl:with-param name="by" select="concat('dr[&quot;',@Name,'&quot;]')"/></xsl:call-template>;
			  </xsl:for-each> 
            }
            dr.Close();
            return model;
          }else{
            dr.Close();
            return null;
          }
        }

        /// &lt;summary&gt;
        /// 获得数据列表
        /// &lt;/summary&gt;
        /// <param name="strWhere">查询条件</param>
        /// <returns>返回DataSet</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(string strWhere)
        {
            return GetList(0, null, strWhere, null);
        }

        /// &lt;summary&gt;
        /// 获得前几行数据
        /// &lt;/summary&gt;
        /// <param name="Top">记录条数</param>
        /// <param name="fileds">查询字段集合，以逗号,隔开</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strOrder">排序方式</param>
        /// <returns>DataSet</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(int Top, string fileds, string strWhere, string strOrder)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("SELECT ");
            if (Top > 0)
            {
            strSql.Append(" TOP ");
            strSql.Append(Top);
            strSql.Append(" ");
            }
            if (!string.IsNullOrEmpty(fileds)){
            strSql.Append(fileds);
            }else{
            strSql.Append(" <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column"> <xsl:value-of select="@Property"/><xsl:if test="position() != last()">,</xsl:if></xsl:for-each>  ");
            }
            strSql.Append(" FROM [<xsl:value-of select="$YourTableName"/>] ");
            if (strWhere.Trim() != "")
            {
            strSql.Append(" WHERE ");
            strSql.Append(strWhere);
            }
            if (!string.IsNullOrEmpty(strOrder))
            {
            strSql.Append(" ORDER BY ");
            strSql.Append(strOrder);
            }
            return DbHelperSQL.Query(strSql.ToString());
        }

        /// &lt;summary&gt;
        /// 获取记录总数
        /// &lt;/summary&gt;
        /// <param name="strWhere">查询条件</param>
        /// <returns>记录总数</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int GetRecordCount(string strWhere){
            string strSql = "SELECT COUNT(1) FROM [<xsl:value-of select="$YourTableName"/>] ";
            if (strWhere.Trim() != "")
                strSql += " WHERE " + strWhere;

            object obj = DbHelperSQL.GetSingle(strSql);
            return (obj == null) ? 0 : Convert.ToInt32(obj);
        }

        /// &lt;summary&gt;
        /// 公用万能的获取分页记录的方法
        /// <para>使用前提:表必须有一个自动增长列ID,但不一定是主键</para>
        /// &lt;/summary&gt;
        /// <param name="TableName">表名</param>
        /// <param name="Fields">要查询的字段集合,查询所有设为空值或者null或者星号"*"</param>
        /// <param name="strWhere">查询的条件,无条件就设为空值或者null</param>
        /// <param name="PageSize">页面大小，每页显示数据行数</param>
        /// <param name="PageIndex">页码，从1开始，第一页是1</param>
        /// <param name="strOrderBy">排序字段，支持多个字段排序,不排序就设为空值或者null</param>
        /// <returns>返回DataSet或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetPage(string Fields, string strWhere, int PageSize, int PageIndex, string strOrderBy)
        {
            //SQL2000使用次方法分页
            //string basdSql = "select top {0} {1} from [<xsl:value-of select="$YourTableName"/>] where ProductID not in(select top {2} ProductID from [Products] {3} {4}) {5} {6}";
            //SQL2005及以上使用次方法分页
            string basdSql = "SELECT TOP {0} * FROM (SELECT ROW_NUMBER() OVER ({1}) AS __RowNumber,{2} FROM [<xsl:value-of select="$YourTableName"/>] {3}) AS T WHERE T.__RowNumber > {4} AND T.__RowNumber &lt;= {5} {6}";

            if (PageSize &lt;= 0) PageSize = 10;
            if (PageIndex &lt;= 0) PageIndex = 1;
            if (string.IsNullOrEmpty(Fields)) Fields = "*";
            strOrderBy = (!string.IsNullOrEmpty(strOrderBy)) ? strOrderBy = " ORDER BY " + strOrderBy : "";
            string strWhere1 = (!string.IsNullOrEmpty(strWhere)) ? strWhere1 = " Where " + strWhere : "";
            //SQL2000使用次方法分页
            //string strWhere2 = (!string.IsNullOrEmpty(strWhere)) ? strWhere2 = " AND " + strWhere : "";
            //string mySql = string.Format(
            //    basdSql,                    //基本SQL命令
            //    PageSize,                   //{0} 页面大小，每页记录行数                   
            //    Fields,                     //{1} 投影字段               
            //    PageSize * (PageIndex - 1), //{2} 要跳过的行数           
            //    strWhere1,                  //{3} 刷选条件  
            //    strOrderBy,                 //{4} 排序字段及方式
            //    strWhere2,                  //{5} 刷选条件
            //    strOrderBy);                //{6} 排序字段及方式

            //SQL2005及以上使用次方法分页
            string strSql = string.Format(
                basdSql,                                //基本SQL命令
                PageSize,                               //{0} 页面大小，每页记录行数         
                strOrderBy,                             //{1} 排序字段及方式
                Fields,                                 //{2} 投影字段                
                strWhere1,                              //{3} 刷选条件
                PageSize * (PageIndex - 1),             //{4} 开始行号
                PageSize * (PageIndex - 1) + PageSize,  //{5} 结束行数
                strOrderBy);                            //{6} 排序字段及方式            

            return DbHelperSQL.Query(strSql);
        }

        #endregion

        #region 常规常用方法 编辑数据  Insert()、Update()、Delete()、

        /// &lt;summary&gt;
        /// 添加一条新<xsl:value-of select="$YourClassName"/>记录
        /// &lt;/summary&gt;
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回自动编号，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Insert(<xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("INSERT INTO [<xsl:value-of select="$YourTableName"/>] (");
            strSql.Append(" <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column"><xsl:if test="@Identity!='√'"><xsl:value-of select="@Property"/><xsl:if test="position() != last()">,</xsl:if></xsl:if></xsl:for-each>");
            strSql.Append(" )VALUES (");
            strSql.Append(" <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column"><xsl:if test="@Identity!='√'">@<xsl:value-of select="@Property"/><xsl:if test="position() != last()">,</xsl:if></xsl:if></xsl:for-each>");
            strSql.Append(" )");
            strSql.Append(";SELECT @@IDENTITY");//返回自动编号

            SqlParameter[] parameters = {
            <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
			<xsl:if test="@Identity!='√'">
              new SqlParameter("@<xsl:value-of select="@Property"/>",  model.<xsl:value-of select="@Property"/>)<xsl:if test="position() != last()">,</xsl:if>
            </xsl:if>
			</xsl:for-each> 
            }; 
            object obj = DbHelperSQL.GetSingle(strSql.ToString(), parameters);
            return (obj == null) ? false : Convert.ToInt32(obj)>0;
        }

        /// &lt;summary&gt;
        /// 更新一条新<xsl:value-of select="$YourClassName"/>记录
        /// &lt;/summary&gt;
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回影响行数，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Update(<xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("UPDATE [<xsl:value-of select="$YourTableName"/>] SET ");
            strSql.Append(" <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column"><xsl:if test="@Identity!='√'"><xsl:value-of select="@Property"/>=@<xsl:value-of select="@Property"/><xsl:if test="position() != last()">,</xsl:if></xsl:if></xsl:for-each>	");
            strSql.Append(" WHERE [<xsl:value-of select="$YourFieldFristKey"/>] = @key_<xsl:value-of select="$YourFristKey"/>");

            SqlParameter[] parameters = {
				<xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
				<xsl:if test="@Identity!='√'">new SqlParameter("@<xsl:value-of select="@Property"/>",  model.<xsl:value-of select="@Property"/>),
				</xsl:if>
				</xsl:for-each> 
                new SqlParameter("@key_<xsl:value-of select="$YourFristKey"/>", model.<xsl:value-of select="$YourFristKey"/>)
            };

            int rows = DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
            return (rows > 0);
        }

        /// &lt;summary&gt;
        /// 删除一条或者多条<xsl:value-of select="$YourClassName"/>记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// &lt;/summary&gt;
        /// <returns>删除成功返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Delete(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:value-of select="$YourFristKey"/>)
        {
          string strSql = "DELETE FROM [<xsl:value-of select="$YourTableName"/>] WHERE [<xsl:value-of select="$YourFieldFristKey"/>] = @<xsl:value-of select="$YourFristKey"/>";
          SqlParameter[] parameters = { new SqlParameter("@<xsl:value-of select="$YourFristKey"/>", <xsl:value-of select="$YourFristKey"/>) };
          //
          int rows = DbHelperSQL.ExecuteSql(strSql, parameters);
		  return (rows > 0);
        }

        /// &lt;summary&gt;
        /// 删除一条或者多条<xsl:value-of select="$YourClassName"/>记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// &lt;/summary&gt;
        /// <param name="AccountIDs">待删除的主键</param>
        /// <returns>返回影响行数，如果等于0就说明删除数据失败了，大于0说明全部或者部分删除成功(因为不是事务操作)</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:value-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:value-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int Deletes(string <xsl:value-of select="$YourFristKey"/>s)
        {          
          string strSql = string.Format("DELETE FROM [<xsl:value-of select="$YourTableName"/>] WHERE [<xsl:value-of select="$YourFieldFristKey"/>] IN ({0})", <xsl:value-of select="$YourFristKey"/>s);
          int rows = DbHelperSQL.ExecuteSql(strSql);
          return rows;
        }
        #endregion

        #region 你增加的新方法
        //
        //
        #endregion
        }
    }
  </xsl:template>
</xsl:stylesheet>