﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="commonfun.xsl"/>
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace <xsl:value-of select="$YourNameSpace"/>.Web.Admin
{
    public partial class <xsl:value-of select="$YourClassName"/>Form : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null &amp;&amp; Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                <xsl:choose>
                <xsl:when test="$YourDataTypeFristKey='int'">
                int id = Convert.ToInt32(strId);
                </xsl:when>
                <xsl:when test="$YourDataTypeFristKey='string'">
                string id = strId;
                </xsl:when>
                <xsl:otherwise>
                string id = strId;
                </xsl:otherwise>
                </xsl:choose> 
                ShowInfo(id);
              }else {
                this.<xsl:value-of select="$YourFristKey"/>TextBox.Text = "0";//新建记录
              }
          }
      }
      /// &lt;summary&gt;
      /// 显示一条 数据，为了修改
      /// &lt;/summary&gt;
      /// &lt;param name="<xsl:value-of select="$YourFristKey"/>"&gt;主键&lt;/param&gt;
      private void ShowInfo(<xsl:value-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:value-of select="$YourFristKey"/>)
      {
          <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> model = new <xsl:value-of select="$YourNameSpace"/>.BLL.<xsl:value-of select="$YourClassName"/>BLL().GetModel(<xsl:value-of select="$YourFristKey"/>);
          if (model != null) {
          <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
            <xsl:variable name="Datatype" select="@Datatype"/>
            <xsl:variable name="groupid" select="/MengmaCodeHelper/DataTypeMapping/DataTypes/Item[@name=$Datatype]/@groupid"/>
                    
            <xsl:variable name="CtrlName" select="/MengmaCodeHelper/DataTypeMapping/Mapping/Group[@groupid=$groupid]/DataType/@CtrlName"/>
            <xsl:call-template name="string-replace-all">
              <xsl:with-param name="text" select="$CtrlName"/>
              <xsl:with-param name="replace" select="'{0}'"/>
              <xsl:with-param name="by" select="@Property"/>
            </xsl:call-template>.<xsl:value-of select="/MengmaCodeHelper/DataTypeMapping/Mapping/Group[@groupid=$groupid]/DataType/@CtrlValueName"/>=model.<xsl:variable name="CtrlSetValue" select="/MengmaCodeHelper/DataTypeMapping/Mapping/Group[@groupid=$groupid]/DataType/@CtrlSetValue"/>
            <xsl:call-template name="string-replace-all">
            <xsl:with-param name="text" select="$CtrlSetValue"/>
            <xsl:with-param name="replace" select="'{0}'"/>
            <xsl:with-param name="by" select="@Property"/>
          </xsl:call-template>;
        </xsl:for-each>            
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// &lt;summary&gt;
      /// 保存一条 数据
      /// &lt;/summary&gt;
      /// &lt;param name="sender"&gt;&lt;/param&gt;
      /// &lt;param name="e"&gt;&lt;/param&gt;
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/> model = new <xsl:value-of select="$YourNameSpace"/>.Model.<xsl:value-of select="$YourClassName"/>();
          //
        <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
        <xsl:variable name="Datatype" select="@Datatype"/>
        <xsl:variable name="groupid" select="/MengmaCodeHelper/DataTypeMapping/DataTypes/Item[@name=$Datatype]/@groupid"/>model.<xsl:value-of select="@Property"/> =<xsl:variable name="CtrlGetValue" select="/MengmaCodeHelper/DataTypeMapping/Mapping/Group[@groupid=$groupid]/DataType/@CtrlGetValue"/>
        <xsl:call-template name="string-replace-all">
          <xsl:with-param name="text" select="$CtrlGetValue"/>
          <xsl:with-param name="replace" select="'{0}'"/>
          <xsl:with-param name="by" select="@Property"/>
        </xsl:call-template>;
        </xsl:for-each>
        string msginfo = "";
        <xsl:value-of select="$YourNameSpace"/>.BLL.<xsl:value-of select="$YourClassName"/>BLL bll = new <xsl:value-of select="$YourNameSpace"/>.BLL.<xsl:value-of select="$YourClassName"/>BLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" &lt;script&gt;alert('保存新增数据成功！');window.location.href='<xsl:value-of select="$YourClassName"/>Form.aspx?id=" + model.<xsl:value-of select="$YourFristKey"/>.ToString() + "';&lt;/script&gt;");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("&lt;script&gt;alert('保存修改数据成功！');window.location.href='<xsl:value-of select="$YourClassName"/>Form.aspx?id=" + model.<xsl:value-of select="$YourFristKey"/>.ToString() + "';&lt;/script&gt;");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("<xsl:value-of select="$YourClassName"/>List.aspx");
    }
  }
}
  </xsl:template>
</xsl:stylesheet>