﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/> 
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>  
  <xsl:template match="/">

  &lt;%@ Page Language="C#" AutoEventWireup="true" CodeBehind="<xsl:value-of select="$YourClassName"/>List.aspx.cs" Inherits="<xsl:value-of select="$YourNameSpace"/>.Web.Admin.<xsl:value-of select="$YourClassName"/>List" %&gt;
<xsl:text disable-output-escaping="yes"><![CDATA[  
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="Contrl/Footer.ascx" TagName="Footer" TagPrefix="uc1" %>
<%@ Register Src="Contrl/Header.ascx" TagName="Header" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <style type="text/css">
        body
        {
            font-size: 12px;
        }
        .dataTable        
        {
            width:100%;
            border:1px solid #cdcdcd;
        }
        .dataTable th       
        {
            background-color:#EFEFEF;
            padding:4px;
        }
         .dataTable td      
        {          
            border-bottom:1px solid #cdcdcd;
            border-right:1px solid #cdcdcd;
            padding:4px;
            overflow:hidden;
            text-overflow:ellipsis;
            white-space:nowrap;
        }
        .chkcolumn        
        { 
             width:40px;
             text-align:center;
        }
        .opcolumn        
        {
             width:120px;
             text-align:center;
        }
        /*分页样式开始*/
         #AspNetPager1        
        {
           height:65px; 
         }
        .paginator
        {
            font: 12px Arial, Helvetica, sans-serif;
            padding: 5px;
            margin: 0px;       
        }
        .paginator a
        {
            padding: 1px 6px;
            border: solid 1px #ddd;
            background: #efefef;
            text-decoration: none;
            margin-right: 2px;
        }
        .paginator a:visited
        {
            padding: 1px 6px;
            border: solid 1px #ddd;
            background: #fff;
            text-decoration: none;
        }
        .paginator .cpb
        {
            padding: 1px 6px;
            font-weight: bold;
            font-size: 13px;
            border: none;
        }
        .paginator a:hover
        {
            color: #fff;
            background: #ffa501;
            border-color: #ffa501;
            text-decoration: none;
        }
        /*分页样式结束*/
    </style>
</head>
<body>

<form id="form1" runat="server">     
<uc2:Header ID="Header1" runat="server" /> 
    <div>
        <br />    
        <!--标准工具栏 -->
        <div style="width: 100%; border-bottom:1px solid #cdcdcd;margin-top:5px;">                                          
                    <div style="float:left;margin-left:16px;margin-top:6px;">关键字：</div>               
                    <div style="float:left;">
                    <asp:TextBox ID="KeywordTextBox" runat="server"></asp:TextBox>                   
                    <asp:Button ID="btnSearch" runat="server" Text="查询" OnClick="btnSearch_Click"></asp:Button>
                    </div>     
                    <div style="float:left;margin-left:6px;">
					]]></xsl:text>
					&lt;input type="button" value="新建" onclick="window.location.href='<xsl:value-of select="$YourClassName"/>Form.aspx'" /&gt;
					<xsl:text disable-output-escaping="yes"><![CDATA[  
					</div>         
                    <div style="float:left;margin-left:16px;margin-top:6px;">
                        <asp:Label ID="errLabel" runat="server" Text=""></asp:Label></div>
        </div>    
    
        <!--数据表格 -->       
        <asp:Repeater ID="Repeater1" runat="server">
            <HeaderTemplate>
                <table class="dataTable">
                   <tr>
                   <th class="chkcolumn"><input type="checkbox" /></th>
                   <th class="opcolumn">操作</th>    
 ]]></xsl:text>              
           <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
					  <th>
              <xsl:value-of select="@Caption"/>
            </th>             
           </xsl:for-each>
      <xsl:text disable-output-escaping="yes">
    <![CDATA[
    </tr>
            </HeaderTemplate>
            <ItemTemplate>
              ]]>
              </xsl:text>
    <tr>
      <td class="chkcolumn">
        <input type="checkbox" />
      </td>
      <td class="opcolumn">
        &lt;a href="<xsl:value-of select="$YourClassName"/>Read.aspx?id=&lt;%# DataBinder.Eval(Container.DataItem,"<xsl:value-of select="$YourFristKey"/>") %&gt;"&gt;查看&lt;/a&gt;
        &lt;a href="<xsl:value-of select="$YourClassName"/>Form.aspx?id=&lt;%# DataBinder.Eval(Container.DataItem,"<xsl:value-of select="$YourFristKey"/>") %&gt;"&gt;修改&lt;/a&gt;
        &lt;a href="<xsl:value-of select="$YourClassName"/>Del.aspx?id=&lt;%# DataBinder.Eval(Container.DataItem,"<xsl:value-of select="$YourFristKey"/>") %&gt;" onclick="if(confirm('确定删除选定行吗？')==false) return false;">删除&lt;/a&gt;
      </td>
      <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
        <td>
          &lt;%#DataBinder.Eval(Container.DataItem,"<xsl:value-of select="@Name"/>")%&gt;</td>
      </xsl:for-each>
    </tr>
   <xsl:text disable-output-escaping="yes">
    <![CDATA[
            </ItemTemplate>
            <FooterTemplate>
                <tr>
                    <td colspan="12">
                        <input type="button" value="删除" disabled="disabled" /> 
                        ]]></xsl:text>
                      &lt;input type="button" value="新建" onclick="window.location.href='<xsl:value-of select="$YourClassName"/>Form.aspx'" /&gt;
                      <xsl:text disable-output-escaping="yes"><![CDATA[    
                    </td>
                </tr>
              </table>
            </FooterTemplate>
        </asp:Repeater>        
        <!--翻页 -->
        <webdiyer:AspNetPager ID="AspNetPager1" runat="server" HorizontalAlign="Left" FirstPageText="<<"
            LastPageText=">>" PrevPageText="<" NextPageText=">" NumericButtonTextFormatString="-{0}-"
            Width="99%" ShowCustomInfoSection="Right" ShowBoxThreshold="2" PageSize="5"
            InputBoxClass="text2" TextAfterInputBox="" OnPageChanging="AspNetPager1_PageChanging"
            UrlPaging="true" CssClass="paginator" CurrentPageButtonClass="cpb" 
            CustomInfoSectionWidth="10%" LayoutType="Div" Wrap="False" 
            CustomInfoHTML="共%PageCount%页，当前为第%CurrentPageIndex%页" />
    </div>
    <uc1:Footer ID="Footer1" runat="server" />
    </form> 
</body>
</html> 
]]>
  </xsl:text>
  </xsl:template>
</xsl:stylesheet>