﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Drawing;
namespace <xsl:value-of select="$YourNameSpace"/>.Web.Admin
{
    public partial class <xsl:value-of select="$YourClassName"/>List : Page
    {

        <xsl:value-of select="$YourNameSpace"/>.BLL.<xsl:value-of select="$YourClassName"/>BLL bll = new <xsl:value-of select="$YourNameSpace"/>.BLL.<xsl:value-of select="$YourClassName"/>BLL();
    <xsl:text disable-output-escaping="yes"><![CDATA[
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                BindData("");
            }
        }

        //搜索
        protected void btnSearch_Click(object sender, EventArgs e)
        {
            StringBuilder strWhere = new StringBuilder();//查询条件
            if (!string.IsNullOrEmpty(KeywordTextBox.Text.Trim())){
     ]]></xsl:text>
           strWhere.AppendFormat(" <xsl:value-of select="$YourFieldFristTitle"/> like '%{0}%'", KeywordTextBox.Text.Trim());//Name 是搜索字段，请修改为实际需要的字段名称
    <xsl:text disable-output-escaping="yes"><![CDATA[
            }
            BindData(strWhere.ToString());
        }

        // 删除          
        protected void btnDelete_Click(object sender, EventArgs e)
        {

        }

        //翻页
        protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
        {
            AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            StringBuilder strWhere = new StringBuilder();//查询条件
            if (!string.IsNullOrEmpty(KeywordTextBox.Text.Trim())){
     ]]></xsl:text>
               strWhere.AppendFormat(" <xsl:value-of select="$YourFristKey"/> like '%{0}%'", KeywordTextBox.Text.Trim());//Name 是搜索字段，请修改为实际需要的字段名称
    <xsl:text disable-output-escaping="yes"><![CDATA[
            }
            //如果查询条件更改了就应该重设 rcount 变量为 0
            //rcount = 0; //保存总记录数量 

            //加载数据
            BindData(strWhere.ToString());
        }
       
        /// <summary>
        /// 保存总记录数量 
        /// </summary>
        int rcount = 0; 
   
        /// <summary>
        /// Repeater数据绑定
        /// </summary>
        public void BindData(string strWhere)
        {
      ]]></xsl:text>

          string strOrder = "<xsl:value-of select="$YourFristKey"/> desc";                 //排序条件
      <xsl:text disable-output-escaping="yes"><![CDATA[
          if (rcount == 0){
              rcount = bll.GetRecordCount(strWhere);
          }
          if (rcount > 0){
              DataSet ds = bll.GetPage("*", strWhere.ToString(), AspNetPager1.PageSize, AspNetPager1.CurrentPageIndex, strOrder);
              AspNetPager1.RecordCount = rcount;//设置总记录数
              //绑定数据源
              Repeater1.DataSource = (ds != null && ds.Tables.Count > 0) ? ds.Tables[0] : null;
              Repeater1.DataBind();

          } else{
            //显示错误信息
            Repeater1.DataSource = null;
            errLabel.Text = bll.GetLastError();
          }
         }
      ]]></xsl:text>
    }
}
  </xsl:template>
</xsl:stylesheet>