﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourTableName" select="'Customers'"/>
  <xsl:variable name="YourClassName" select="'Customers'"/>
  <xsl:variable name="YourNameSpace" select="'ITravelSystem.Passport'"/>
  <xsl:variable name="YourAuthor" select="'zhaoshunlu'"/>
  <xsl:variable name="YourCreatDate" select="'2014-02-24'"/>
  <xsl:template match="/">
    // ******************************************************
    // 文件名称(File Name)：       <xsl:copy-of select="$YourClassName"/>.cs
    // 项目名称(Project Name)：    YourProjectName
    // 功能描述(Description)：      （数据模型）
    // 数据表(Tables)：            t_Administrators（所用到的数据表，视图，存储过程的说明，如关系比较复杂，则应说明哪些是可擦写的，哪些表为只读的）
    // 作者(Author)：              zhaoshunlu
    // 日期(Create Date)：         2014年02月19日 15:20:55
    // 参考文档(Reference)(可选)： （该档所对应的分析文档，设计文檔）
    // 引用(Using) (可选)﹕        （开发的系统中引用其它系统的Dll、对象时，要列出其对应的出处，是否与系统有关﹙不清楚的可以不写﹚，以方便制作安装档）
    // 编码约定：                   命名规则(类名和属性名首字母必须大写)
    // 修改记录(Revision History)：（若档案的所有者改变，则需要有修改人员的名字、修改日期及修改理由）
    //******************************************************
    using System;
    using System.Collections.Generic;
    using Newtonsoft.Json;

    namespace <xsl:copy-of select="$YourNameSpace"/>.Model {

    /// &lt;summary&gt;
    /// （<xsl:copy-of select="$YourTableName"/>）
    /// &lt;/summary&gt;
    /// &lt;remarks&gt;
    /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
    /// &lt;para&gt;修改人、日期及内容:&lt;/para&gt;
    /// &lt;/remarks&gt;
    public class <xsl:copy-of select="$YourClassName"/>{
        public <xsl:copy-of select="$YourClassName"/>() {

        } 
        <xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
          /// &lt;summary&gt;
          /// <xsl:value-of select="@Caption"/><xsl:if test="@AllowNulls != ''">(Not NULL)</xsl:if> 
          /// &lt;/summary&gt; 
          public <xsl:value-of select="@Datatype"/><xsl:text> </xsl:text><xsl:value-of select="@Property"/> { get; set; }
        </xsl:for-each>
        }
   }
  </xsl:template> 
</xsl:stylesheet>