﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'包名'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">

    /*-------------------------------------------------
    *文件名称：<xsl:copy-of select="$YourClassName"/>ServiceImpl.java
    *创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
    *修改人、日期及内容:
    */-------------------------------------------------
    package <xsl:copy-of select="$YourNameSpace"/>.service.impl; 

    import java.util.List;
    import java.util.Map;
    import java.util.HashMap;
    import <xsl:copy-of select="$YourNameSpace"/>.model.<xsl:copy-of select="$YourClassName"/>;
    import <xsl:copy-of select="$YourNameSpace"/>.dao.DaoService;
    import <xsl:copy-of select="$YourNameSpace"/>.service.<xsl:copy-of select="$YourClassName"/>Service;
    import <xsl:copy-of select="$YourNameSpace"/>.utils.StringTools;
    import <xsl:copy-of select="$YourNameSpace"/>.utils.BeanTools;
    import <xsl:copy-of select="$YourNameSpace"/>.utils.PageModel;

    public class <xsl:copy-of select="$YourClassName"/>ServiceImpl implements <xsl:copy-of select="$YourClassName"/>Service {

    private DaoService dao;

    public void setDao(DaoService dao) {
    this.dao = dao;
    }

    @Override
    public Map&lt;String, Object&gt; initAdd(Map&lt;String, Object&gt; param) throws Exception {
		return null;
	}

	@Override
	public void add(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception {
		dao.add(model);
	}

	@Override
	public void delete(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception {
		dao.delete(model);
	}

	@Override
	public Map&lt;String, Object&gt; initUpdate(Map&lt;String, Object&gt; param) throws Exception {
		return null;
	}

	@Override
	public void update(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception {
		dao.update(model);
	}

	@Override
	public Map&lt;String, Object&gt; initAddAll(Map&lt;String, Object&gt; param) throws Exception {
		return null;
	}

	@Override
	public void addAll(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list, Map&lt;String, Object&gt; param) throws Exception {
		BeanTools.checkListItem(list);
		dao.addAll(list);
	}

	@Override
	public void deleteAll(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list, Map&lt;String, Object&gt; param) throws Exception {
		BeanTools.checkListItem(list);
		dao.deleteAll(list);
	}

	@Override
	public Map&lt;String, Object&gt; initMergeAll(Map&lt;String, Object&gt; param) throws Exception {
		return null;
	}

	@Override
	public void mergeAll(List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list, Map&lt;String, Object&gt; param) throws Exception {
		BeanTools.checkListItem(list);
		dao.mergeAll(list);
	}

	@Override
	public <xsl:copy-of select="$YourClassName"/> get(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception {
		return (<xsl:copy-of select="$YourClassName"/>) dao.get(<xsl:copy-of select="$YourClassName"/>.class, model.getEmployeeId());
	}

	@Override
	public List&lt;<xsl:copy-of select="$YourClassName"/>&gt; selectAll(Map&lt;String, Object&gt; param) throws Exception {
		String hql = "from <xsl:copy-of select="$YourClassName"/>";
		return dao.find(hql);
	}

	@Override
	public Map&lt;String, Object&gt; initConditionSelectAll(Map&lt;String, Object&gt; param) throws Exception {
		return null;
	}

	@Override
	public List&lt;<xsl:copy-of select="$YourClassName"/>&gt; conditionSelectAll(<xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception {
		Map&lt;String, Object&gt; paramMap = new HashMap&lt;String, Object&gt;();
		StringBuffer hql = new StringBuffer("from <xsl:copy-of select="$YourClassName"/> model where 1=1 ");

		if (StringTools.notEmpty(model.getEmployeeId())) {
			hql.append("and model.employeeId = :model_employeeId ");
			paramMap.put("model_employeeId", model.getEmployeeId());
		} 

		List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list = dao.find(hql.toString(), paramMap);
		return list;
	}

	@Override
	public Map&lt;String, Object&gt; initPageQuery(Map&lt;String, Object&gt; param) throws Exception {
		return null;
	}

	@Override
	public PageModel pageQuery(PageModel pageModel, <xsl:copy-of select="$YourClassName"/> model, Map&lt;String, Object&gt; param) throws Exception {
		Map&lt;String, Object&gt; paramMap = new HashMap&lt;String, Object&gt;();
		StringBuffer queryHQL = new StringBuffer("from <xsl:copy-of select="$YourClassName"/> model where 1=1 ");
		StringBuffer countHQL = new StringBuffer("select count(*) from <xsl:copy-of select="$YourClassName"/> model where 1=1 ");
		StringBuffer condition = new StringBuffer();
  
		if (StringTools.trimNotEmpty(model.getFirstName())) {
			condition.append("and model.firstName like :model_firstName ");
			paramMap.put("model_firstName", "%" + model.getFirstName().trim() + "%");
		}
  
		queryHQL.append(condition);
		countHQL.append(condition);
		int count = ((Long) dao.findUnique(countHQL.toString(), paramMap)).intValue();
		pageModel.init(count);
		List&lt;<xsl:copy-of select="$YourClassName"/>&gt; list = dao.findLimit(queryHQL.toString(), paramMap, pageModel.getBeginQueryNumber(), pageModel.getPageSize());
		pageModel.setList(list);
		return pageModel;
	}
}
        </xsl:template> 
</xsl:stylesheet>