﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourTableRemark" select="'表格备注'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>    
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>  
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/">
&lt;?php
'-------------------------------------------------
'实体层
'创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
'修改人、日期及内容:
'-------------------------------------------------
class <xsl:copy-of select="$YourClassName"/>Model{

  //成员
<xsl:for-each select="MengmaCodeHelper/Server/Database/Table[@Name=$YourTableName]/Column">
  public $<xsl:value-of select="@Property"/>      //<xsl:value-of select="@Caption"/>
</xsl:for-each>
    
  //构造函数
  public function __construct(){
  
  }
  //析构函数
  public function __destruct()
  {          
  
  }
  
  //__get()方法用来获取私有属性
  private function __get($property_name){
	  if(isset($this->$property_name)){
		  return($this->$property_name);
	  }else{
		  return(NULL);
	  }
  }

  //__set()方法用来设置私有属性
  private function __set($property_name,$value){
	  $this->$property_name=$value;
  }

  //__isset()方法
  private function __isset($nm)
  {
	  //echo"isset()函数测定私有成员时，自动调用";
	  return isset($this->$nm);
  }

  //__unset()方法
  private function __unset($nm){
	  //echo"当在类外部使用unset()函数来删除私有成员时自动调用的";
	  unset($this->$nm);
  }
      
  public function __toString(){
		return "<xsl:copy-of select="$YourClassName"/>Model";
	}
}
?&gt;    
  </xsl:template> 
</xsl:stylesheet>