﻿if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CustomerDemographics_Insert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
    drop procedure [dbo].[CustomerDemographics_Insert]
GO
------------------------------------
-- 功能描述：增加一条记录 
-- 所属表格：CustomerDemographics[ ]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
DECLARE @CustomerTypeID nchar -- 客户类型ID
    SET @CustomerTypeID = 
DECLARE @CustomerDesc ntext -- 客户描述
    SET @CustomerDesc =  ' '
 -- 调用存储过程 
 exec [CustomerDemographics_Insert] @CustomerTypeID,@CustomerDesc
 */
------------------------------------
CREATE PROCEDURE [CustomerDemographics_Insert] (
@CustomerTypeID  nchar = NULL,   -- 客户类型ID
@CustomerDesc    ntext = NULL    -- 客户描述

)
AS
INSERT INTO CustomerDemographics(
	[CustomerDesc]	 
)VALUES( 
	@CustomerDesc	
)
SELECT @ID = SCOPE_IDENTITY() -- 返回新加记录的唯一标识
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CustomerDemographics_Edit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CustomerDemographics_Edit]
GO
------------------------------------
-- 功能描述：修改一条记录 
-- 所属表格：CustomerDemographics[]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /* -- 测试代码 --
 -- 参数设置 
DECLARE @CustomerTypeID nchar -- 客户类型ID
    SET @CustomerTypeID = 
DECLARE @CustomerDesc ntext -- 客户描述
    SET @CustomerDesc =  ' '
 -- 调用存储过程 
 exec [CustomerDemographics_Edit] @CustomerTypeID,@CustomerDesc 
 */
------------------------------------
CREATE PROCEDURE [CustomerDemographics_Edit]
@CustomerTypeID  nchar = NULL,   -- 客户类型ID
@CustomerDesc    ntext = NULL    -- 客户描述

AS 
UPDATE CustomerDemographics SET 
	 [CustomerDesc] = @CustomerDesc
WHERE 
	 [CustomerTypeID] = @CustomerTypeID
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CustomerDemographics_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CustomerDemographics_Delete]
GO
------------------------------------
-- 功能描述：删除一条记录 
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
 -- 调用存储过程 
DECLARE @ID int
    set @ID=0
 exec [CustomerDemographics_Delete] @ID
 */
------------------------------------
CREATE PROCEDURE [CustomerDemographics_Delete]
	@CustomerTypeID nchar --待删除的主键
AS 
   
	    DELETE FROM [CustomerDemographics]	    WHERE CustomerTypeID = @CustomerTypeID 
     
     
GO   
     


