﻿    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace KuGo.Web.Admin
{
    public partial class ProductsForm : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null && Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                
                int id = Convert.ToInt32(strId);
                 
                ShowInfo(id);
              }else {
                this.ProductIDTextBox.Text = "0";//新建记录
              }
          }
      }
      /// <summary>
      /// 显示一条 数据，为了修改
      /// </summary>
      /// <param name="ProductID">主键</param>
      private void ShowInfo(int ProductID)
      {
          KuGo.Model.Products model = new KuGo.BLL.ProductsBLL().GetModel(ProductID);
          if (model != null) {
          ProductIDTextBox.Text=model.ProductID.ToString();
        ProductNameTextBox.Text=model.ProductName;
        SupplierIDTextBox.Text=model.SupplierID.ToString();
        CategoryIDTextBox.Text=model.CategoryID.ToString();
        QuantityPerUnitTextBox.Text=model.QuantityPerUnit;
        UnitPriceTextBox.Text=model.UnitPrice.ToString();
        UnitsInStockTextBox.Text=model.UnitsInStock.ToString();
        UnitsOnOrderTextBox.Text=model.UnitsOnOrder.ToString();
        ReorderLevelTextBox.Text=model.ReorderLevel.ToString();
        DiscontinuedCheckBox.Checked=model.Discontinued;
                    
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// <summary>
      /// 保存一条 数据
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          KuGo.Model.Products model = new KuGo.Model.Products();
          //
        model.ProductID =(ProductIDTextBox.Text !="")? Convert.ToInt32(ProductIDTextBox.Text): 0;
        model.ProductName =ProductNameTextBox.Text;
        model.SupplierID =(SupplierIDTextBox.Text !="")? Convert.ToInt32(SupplierIDTextBox.Text): 0;
        model.CategoryID =(CategoryIDTextBox.Text !="")? Convert.ToInt32(CategoryIDTextBox.Text): 0;
        model.QuantityPerUnit =QuantityPerUnitTextBox.Text;
        model.UnitPrice =(UnitPriceTextBox.Text !="")? Convert.ToInt32(UnitPriceTextBox.Text): 0;
        model.UnitsInStock =(UnitsInStockTextBox.Text !="")? Convert.ToInt32(UnitsInStockTextBox.Text): 0;
        model.UnitsOnOrder =(UnitsOnOrderTextBox.Text !="")? Convert.ToInt32(UnitsOnOrderTextBox.Text): 0;
        model.ReorderLevel =(ReorderLevelTextBox.Text !="")? Convert.ToInt32(ReorderLevelTextBox.Text): 0;
        model.Discontinued =DiscontinuedCheckBox.Checked;
        
        string msginfo = "";
        KuGo.BLL.ProductsBLL bll = new KuGo.BLL.ProductsBLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" <script>alert('保存新增数据成功！');window.location.href='ProductsForm.aspx?id=" + model.ProductID.ToString() + "';</script>");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("<script>alert('保存修改数据成功！');window.location.href='ProductsForm.aspx?id=" + model.ProductID.ToString() + "';</script>");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("ProductsList.aspx");
    }
  }
}
  