﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Kugo.Web
    {
    public partial class _Default : System.Web.UI.Page
    {
        Kugo.BLL.CategoriesBLL bllCategories = new Kugo.BLL.CategoriesBLL();   
        Kugo.BLL.CustomerCustomerDemoBLL bllCustomerCustomerDemo = new Kugo.BLL.CustomerCustomerDemoBLL();   
        Kugo.BLL.CustomerDemographicsBLL bllCustomerDemographics = new Kugo.BLL.CustomerDemographicsBLL();   
        Kugo.BLL.CustomersBLL bllCustomers = new Kugo.BLL.CustomersBLL();   
        Kugo.BLL.EmployeesBLL bllEmployees = new Kugo.BLL.EmployeesBLL();   
        Kugo.BLL.EmployeeTerritoriesBLL bllEmployeeTerritories = new Kugo.BLL.EmployeeTerritoriesBLL();   
        Kugo.BLL.OrderDetailsBLL bllOrderDetails = new Kugo.BLL.OrderDetailsBLL();   
        Kugo.BLL.OrdersBLL bllOrders = new Kugo.BLL.OrdersBLL();   
        Kugo.BLL.ProductsBLL bllProducts = new Kugo.BLL.ProductsBLL();   
        Kugo.BLL.RegionBLL bllRegion = new Kugo.BLL.RegionBLL();   
        Kugo.BLL.ShippersBLL bllShippers = new Kugo.BLL.ShippersBLL();   
        Kugo.BLL.SuppliersBLL bllSuppliers = new Kugo.BLL.SuppliersBLL();   
        Kugo.BLL.TerritoriesBLL bllTerritories = new Kugo.BLL.TerritoriesBLL();   
        

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                
                  BindCategories();//类别
                  BindCustomerCustomerDemo();//客户测试
                  BindCustomerDemographics();//客户统计
                  BindCustomers();//客户
                  BindEmployees();//雇员
                  BindEmployeeTerritories();//雇员领域
                  BindOrderDetails();//订单明细
                  BindOrders();//订单
                  BindProducts();//产品
                  BindRegion();//地区
                  BindShippers();//运货商
                  BindSuppliers();//供应商
                  BindTerritories();//领域 
            }
        }
        
          /// <summary>
          /// 绑定类别
          /// </summary>
          public void BindCategories()
          {
            string strOrder = "CategoryID desc";  //排序条件
            DataSet ds = bllCategories.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepCategories.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepCategories.DataBind();
          }  
        
          /// <summary>
          /// 绑定客户测试
          /// </summary>
          public void BindCustomerCustomerDemo()
          {
            string strOrder = "CustomerID desc";  //排序条件
            DataSet ds = bllCustomerCustomerDemo.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepCustomerCustomerDemo.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepCustomerCustomerDemo.DataBind();
          }  
        
          /// <summary>
          /// 绑定客户统计
          /// </summary>
          public void BindCustomerDemographics()
          {
            string strOrder = "CustomerTypeID desc";  //排序条件
            DataSet ds = bllCustomerDemographics.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepCustomerDemographics.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepCustomerDemographics.DataBind();
          }  
        
          /// <summary>
          /// 绑定客户
          /// </summary>
          public void BindCustomers()
          {
            string strOrder = "CustomerID desc";  //排序条件
            DataSet ds = bllCustomers.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepCustomers.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepCustomers.DataBind();
          }  
        
          /// <summary>
          /// 绑定雇员
          /// </summary>
          public void BindEmployees()
          {
            string strOrder = "EmployeeID desc";  //排序条件
            DataSet ds = bllEmployees.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepEmployees.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepEmployees.DataBind();
          }  
        
          /// <summary>
          /// 绑定雇员领域
          /// </summary>
          public void BindEmployeeTerritories()
          {
            string strOrder = "EmployeeID desc";  //排序条件
            DataSet ds = bllEmployeeTerritories.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepEmployeeTerritories.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepEmployeeTerritories.DataBind();
          }  
        
          /// <summary>
          /// 绑定订单明细
          /// </summary>
          public void BindOrderDetails()
          {
            string strOrder = "OrderID desc";  //排序条件
            DataSet ds = bllOrderDetails.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepOrderDetails.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepOrderDetails.DataBind();
          }  
        
          /// <summary>
          /// 绑定订单
          /// </summary>
          public void BindOrders()
          {
            string strOrder = "OrderID desc";  //排序条件
            DataSet ds = bllOrders.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepOrders.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepOrders.DataBind();
          }  
        
          /// <summary>
          /// 绑定产品
          /// </summary>
          public void BindProducts()
          {
            string strOrder = "ProductID desc";  //排序条件
            DataSet ds = bllProducts.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepProducts.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepProducts.DataBind();
          }  
        
          /// <summary>
          /// 绑定地区
          /// </summary>
          public void BindRegion()
          {
            string strOrder = "RegionID desc";  //排序条件
            DataSet ds = bllRegion.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepRegion.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepRegion.DataBind();
          }  
        
          /// <summary>
          /// 绑定运货商
          /// </summary>
          public void BindShippers()
          {
            string strOrder = "ShipperID desc";  //排序条件
            DataSet ds = bllShippers.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepShippers.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepShippers.DataBind();
          }  
        
          /// <summary>
          /// 绑定供应商
          /// </summary>
          public void BindSuppliers()
          {
            string strOrder = "SupplierID desc";  //排序条件
            DataSet ds = bllSuppliers.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepSuppliers.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepSuppliers.DataBind();
          }  
        
          /// <summary>
          /// 绑定领域
          /// </summary>
          public void BindTerritories()
          {
            string strOrder = "TerritoryID desc";  //排序条件
            DataSet ds = bllTerritories.GetList(6, "*", "", strOrder);
            //绑定数据源
            RepTerritories.DataSource = (ds != null) ? ds.Tables[0] : null;
            RepTerritories.DataBind();
          }  
         
    }
}
  