﻿    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace Kugo.Web.Admin
{
    public partial class SuppliersForm : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null && Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                
                int id = Convert.ToInt32(strId);
                 
                ShowInfo(id);
              }else {
                this.SupplierIDTextBox.Text = "0";//新建记录
              }
          }
      }
      /// <summary>
      /// 显示一条 数据，为了修改
      /// </summary>
      /// <param name="SupplierID">主键</param>
      private void ShowInfo(int SupplierID)
      {
          Kugo.Model.Suppliers model = new Kugo.BLL.SuppliersBLL().GetModel(SupplierID);
          if (model != null) {
          SupplierIDTextBox.Text=model.SupplierID.ToString();
        CompanyNameTextBox.Text=model.CompanyName;
        ContactNameTextBox.Text=model.ContactName;
        ContactTitleTextBox.Text=model.ContactTitle;
        AddressTextBox.Text=model.Address;
        CityTextBox.Text=model.City;
        RegionTextBox.Text=model.Region;
        PostalCodeTextBox.Text=model.PostalCode;
        CountryTextBox.Text=model.Country;
        PhoneTextBox.Text=model.Phone;
        FaxTextBox.Text=model.Fax;
        HomePageTextBox.Text=model.HomePage;
                    
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// <summary>
      /// 保存一条 数据
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          Kugo.Model.Suppliers model = new Kugo.Model.Suppliers();
          //
        model.SupplierID =(SupplierIDTextBox.Text !="")? Convert.ToInt32(SupplierIDTextBox.Text): 0;
        model.CompanyName =CompanyNameTextBox.Text;
        model.ContactName =ContactNameTextBox.Text;
        model.ContactTitle =ContactTitleTextBox.Text;
        model.Address =AddressTextBox.Text;
        model.City =CityTextBox.Text;
        model.Region =RegionTextBox.Text;
        model.PostalCode =PostalCodeTextBox.Text;
        model.Country =CountryTextBox.Text;
        model.Phone =PhoneTextBox.Text;
        model.Fax =FaxTextBox.Text;
        model.HomePage =HomePageTextBox.Text;
        
        string msginfo = "";
        Kugo.BLL.SuppliersBLL bll = new Kugo.BLL.SuppliersBLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" <script>alert('保存新增数据成功！');window.location.href='SuppliersForm.aspx?id=" + model.SupplierID.ToString() + "';</script>");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("<script>alert('保存修改数据成功！');window.location.href='SuppliersForm.aspx?id=" + model.SupplierID.ToString() + "';</script>");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("SuppliersList.aspx");
    }
  }
}
  