/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.prospector.traverse.world.biomes;

import com.libraries.prospector.traverse.config.TraverseConfig;
import com.libraries.prospector.traverse.world.WorldGenConstants;
import java.util.Random;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGlacier
extends Biome
implements WorldGenConstants {
    public static final WorldGenBlockBlob COBBLESTONE_BOULDER_FEATURE = new WorldGenBlockBlob(Blocks.field_150347_e, 1);
    public static final WorldGenIceSpike ICE_SPIKE_FEATURE = new WorldGenIceSpike();
    public final boolean isSpikes;

    public BiomeGlacier(boolean isSpikes) {
        super(BiomeGlacier.getProperties(isSpikes));
        this.isSpikes = isSpikes;
        this.field_76752_A = Blocks.field_150433_aE.func_176223_P();
        this.field_76753_B = Blocks.field_150432_aD.func_176223_P();
        this.field_76760_I.field_76832_z = 1;
        this.field_76760_I.field_189870_A = 4.0f;
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 10, 2, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityPolarBear.class, 1, 1, 2));
        this.field_76761_J.removeIf(spawnentry -> spawnentry.field_76300_b == EntitySkeleton.class);
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 20, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityStray.class, 80, 4, 4));
    }

    public static Biome.BiomeProperties getProperties(boolean isSpikes) {
        Biome.BiomeProperties properties;
        if (isSpikes) {
            properties = new Biome.BiomeProperties("Glacier Spikes");
            properties.func_185399_a("glacier");
        } else {
            properties = new Biome.BiomeProperties("Glacier");
            properties.func_185399_a("ice_flats");
        }
        properties.func_185410_a(0.0f);
        properties.func_185395_b(0.5f);
        properties.func_185411_b();
        properties.func_185398_c(1.5f);
        properties.func_185400_d(0.5f);
        return properties;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int genChance;
        if (!TraverseConfig.disallowBoulders && TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK) && (genChance = rand.nextInt(9)) == 0) {
            int k6 = rand.nextInt(16) + 8;
            int l = rand.nextInt(16) + 8;
            BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, 0, l));
            COBBLESTONE_BOULDER_FEATURE.func_180709_b(worldIn, rand, blockpos);
        }
        if (this.isSpikes && TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ICE) && (genChance = rand.nextInt(3)) == 0) {
            int j = rand.nextInt(16) + 8;
            int k = rand.nextInt(16) + 8;
            ICE_SPIKE_FEATURE.func_180709_b(worldIn, rand, worldIn.func_175645_m(pos.func_177982_a(j, 0, k)));
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenTaiga2(false);
    }
}

