/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.RabbitGui;
import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.Shiftable;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class Button
extends GuiWidget
implements Shiftable {
    protected static final int DISABLED_STATE = 0;
    protected static final int IDLE_STATE = 1;
    protected static final int HOVER_STATE = 2;
    protected boolean drawHoverText = false;
    protected List<String> originalHoverText = new ArrayList<String>();
    protected List<String> hoverText = new ArrayList<String>();
    protected ResourceLocation buttonTexture = new ResourceLocation("textures/gui/widgets.png");
    @LayoutComponent
    protected String text;
    @LayoutComponent
    protected boolean isVisible = true;
    @LayoutComponent
    protected boolean isEnabled = true;
    protected ButtonClickListener onClick;
    protected boolean drawToLeft;

    protected Button() {
    }

    public Button(int xPos, int yPos, int width, int height, String title) {
        super(xPos, yPos, width, height);
        this.text = title;
    }

    public Button addHoverText(String text) {
        this.originalHoverText.add(text);
        return this;
    }

    protected void drawButton(int state) {
        Renderer.drawContinuousTexturedBox(this.getX(), this.getY(), 0, 46 + 20 * state, this.getWidth(), this.getHeight(), 200, 20, 2, 3, 2, 2);
    }

    protected void endRender() {
        GlStateManager.func_179117_G();
        GlStateManager.func_179084_k();
    }

    public ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    public ButtonClickListener getClickListener() {
        return this.onClick;
    }

    public List<String> getHoverText() {
        return this.originalHoverText;
    }

    public String getText() {
        return this.text;
    }

    public boolean isButtonUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            this.prepareRender();
            if (!this.isEnabled()) {
                this.drawButton(0);
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                this.drawButton(2);
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringText(this.hoverText, mouseX - tlineWidth - 20, mouseY + 12);
                    } else {
                        Renderer.drawHoveringText(this.hoverText, mouseX, mouseY + 12);
                    }
                }
            } else {
                this.drawButton(1);
            }
            TextRenderer.renderString(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - 4, this.getText(), TextAlignment.CENTER);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        boolean bl = clicked = this.isButtonUnderMouse(posX, posY) && this.isEnabled() && !overlap;
        if (clicked) {
            if (this.getClickListener() != null) {
                this.getClickListener().onClick(this);
            }
            this.playClickSound();
        }
        return clicked;
    }

    protected void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected void prepareRender() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getButtonTexture());
        GlStateManager.func_179117_G();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    public Button setClickListener(ButtonClickListener onClicked) {
        this.onClick = onClicked;
        return this;
    }

    public Button setCustomTexture(ResourceLocation res) {
        this.buttonTexture = res;
        return this;
    }

    public Button setDoesDrawHoverText(boolean state) {
        this.drawHoverText = state;
        return this;
    }

    public Button setHoverText(List<String> text) {
        this.originalHoverText = text;
        return this;
    }

    @Override
    public Button setId(String id) {
        this.assignId(id);
        return this;
    }

    public Button setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public Button setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    public Button setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public void shiftX(int x) {
        this.setX(this.getX() + x);
    }

    @Override
    public void shiftY(int y) {
        this.setY(this.getY() + y);
    }

    protected void verifyHoverText(int mouseX, int mouseY) {
        int tlineWidth = 0;
        for (String line : this.originalHoverText) {
            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
        }
        int dWidth = RabbitGui.proxy.getCurrentStage().field_146294_l;
        if (tlineWidth + mouseX > dWidth && mouseX + 1 > dWidth / 2) {
            this.drawToLeft = true;
        }
        ArrayList<String> newHoverText = new ArrayList<String>();
        if (this.drawToLeft) {
            for (String line : this.originalHoverText) {
                int lineWidth = TextRenderer.getFontRenderer().func_78256_a(line) + 12;
                if (lineWidth > mouseX) {
                    String newString = "";
                    for (String substring : line.split(" ")) {
                        if (TextRenderer.getFontRenderer().func_78256_a(newString) + TextRenderer.getFontRenderer().func_78256_a(substring) < mouseX - 12) {
                            newString = newString + substring + " ";
                            continue;
                        }
                        newHoverText.add(newString);
                        newString = substring + " ";
                    }
                    newHoverText.add(newString);
                    continue;
                }
                newHoverText.add(line);
            }
        } else {
            for (String line : this.originalHoverText) {
                int lineWidth = TextRenderer.getFontRenderer().func_78256_a(line) + 12;
                if (lineWidth > dWidth - mouseX) {
                    String newString = "";
                    for (String substring : line.split(" ")) {
                        if (TextRenderer.getFontRenderer().func_78256_a(newString) + TextRenderer.getFontRenderer().func_78256_a(substring) < dWidth - mouseX - 12) {
                            newString = newString + substring + " ";
                            continue;
                        }
                        newHoverText.add(newString);
                        newString = substring + " ";
                    }
                    newHoverText.add(newString);
                    continue;
                }
                newHoverText.add(line);
            }
        }
        this.hoverText = newHoverText;
    }

    @FunctionalInterface
    public static interface ButtonClickListener {
        public void onClick(Button var1);
    }
}

