/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.Shiftable;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class CheckBox
extends GuiWidget
implements Shiftable {
    protected static final int WIDTH = 11;
    protected static final int HEIGHT = 11;
    @LayoutComponent
    protected Color checkColor;
    @LayoutComponent
    protected Color textColor;
    protected ResourceLocation buttonTexture = new ResourceLocation("textures/gui/widgets.png");
    @LayoutComponent
    protected boolean isChecked;
    @LayoutComponent
    protected String text;
    @LayoutComponent
    protected boolean isVisible = true;
    @LayoutComponent
    protected boolean isEnabled = true;
    protected CheckBoxStatusChangedListener onStatusChangedListener;

    public CheckBox(int xPos, int yPos, int width, int height, Color checkColor, Color textColor, String title, boolean checked) {
        super(xPos, yPos, width, height);
        this.textColor = textColor;
        this.checkColor = checkColor;
        this.text = title;
        this.isChecked = checked;
    }

    public CheckBox(int xPos, int yPos, int width, int height, String title, boolean checked) {
        this(xPos, yPos, width, height, Color.GREEN, Color.white, title, checked);
    }

    public CheckBox(int xPos, int yPos, String title, boolean checked) {
        this(xPos, yPos, 11, 11, Color.GREEN, Color.white, title, checked);
    }

    public CheckBox(int xPos, int yPos, String title, Color textColor, boolean checked) {
        this(xPos, yPos, 11, 11, Color.GREEN, textColor, title, checked);
    }

    public CheckBox(int xPos, int yPos, String title, Color checkColor, Color textColor, boolean checked) {
        this(xPos, yPos, 11, 11, checkColor, textColor, title, checked);
    }

    void b(ResourceLocation loc) {
        Minecraft.func_71410_x().func_110434_K().func_110581_b(loc);
    }

    protected void drawButton() {
        Renderer.drawContinuousTexturedBox(this.getX(), this.getY(), 0, 46, this.getWidth(), this.getHeight(), 200, 20, 2, 3, 2, 2);
    }

    public ResourceLocation getButtonTexture() {
        return this.buttonTexture;
    }

    public CheckBoxStatusChangedListener getStatusChangedListener() {
        return this.onStatusChangedListener;
    }

    public String getText() {
        return this.text;
    }

    public boolean isButtonUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.prepareRender();
            this.drawButton();
            if (this.isChecked()) {
                Renderer.drawLine(this.getX() + 2, (int)((double)this.getY() + (double)this.getHeight() * 0.66), this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() - 2, this.checkColor, (float)(this.getWidth() / 3));
                Renderer.drawLine(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() - 2, this.getX() + this.getWidth() + 1, this.getY() - 1, this.checkColor, (float)(this.getWidth() / 3));
            }
            TextRenderer.renderString(this.getX() + this.getWidth() + 2, this.getY() + this.getHeight() / 2 - 3, this.getText(), this.textColor);
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        boolean bl = clicked = this.isButtonUnderMouse(posX, posY) && this.isEnabled() && !overlap;
        if (clicked) {
            this.setIsCheckedWithNotify(!this.isChecked());
            this.playClickSound();
        }
        return clicked;
    }

    protected void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected void prepareRender() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getButtonTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
    }

    public CheckBox setCustomTexture(ResourceLocation res) {
        this.buttonTexture = res;
        return this;
    }

    @Override
    public CheckBox setId(String id) {
        this.assignId(id);
        return this;
    }

    public CheckBox setIsChecked(boolean state) {
        this.isChecked = state;
        return this;
    }

    public CheckBox setIsCheckedWithNotify(boolean state) {
        this.setIsChecked(state);
        if (this.getStatusChangedListener() != null) {
            this.getStatusChangedListener().onStatusChanged(this);
        }
        return this;
    }

    public CheckBox setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public CheckBox setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    public CheckBox setStatusChangedListener(CheckBoxStatusChangedListener listener) {
        this.onStatusChangedListener = listener;
        return this;
    }

    public CheckBox setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public void shiftX(int x) {
        this.setX(this.getX() + x);
    }

    @Override
    public void shiftY(int y) {
        this.setY(this.getY() + y);
    }

    @FunctionalInterface
    public static interface CheckBoxStatusChangedListener {
        public void onStatusChanged(CheckBox var1);
    }
}

