/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.display.Picture;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class PictureButton
extends Button {
    private Picture picture;
    private boolean drawButton;

    public PictureButton() {
        this.drawButton = true;
    }

    public PictureButton(int xPos, int yPos, int width, int height, ResourceLocation texture) {
        super(xPos, yPos, width, height, "");
        this.picture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, texture);
        this.drawButton = true;
    }

    public PictureButton(int xPos, int yPos, int width, int height, String texture) {
        super(xPos, yPos, width, height, "");
        this.picture = new Picture(xPos + 1, yPos + 1, width - 2, height - 2, texture);
        this.drawButton = true;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            this.prepareRender();
            if (!this.isEnabled()) {
                if (this.drawButton) {
                    this.drawButton(0);
                }
                this.picture.onDraw(mouseX, mouseY, partialTicks);
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                if (this.drawButton) {
                    this.drawButton(2);
                }
                this.picture.onDraw(mouseX, mouseY, partialTicks);
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringText(this.hoverText, mouseX - tlineWidth - 20, mouseY + 12);
                    } else {
                        Renderer.drawHoveringText(this.hoverText, mouseX, mouseY + 12);
                    }
                }
            } else {
                if (this.drawButton) {
                    this.drawButton(1);
                }
                this.picture.onDraw(mouseX, mouseY, partialTicks);
            }
            this.endRender();
            GlStateManager.func_179121_F();
        }
    }

    public PictureButton setDrawsButton(boolean state) {
        this.drawButton = state;
        return this;
    }

    @Override
    public GuiWidget setHeight(int height) {
        super.setHeight(height);
        this.picture.setY(height - 2);
        return this;
    }

    public PictureButton setPictureTexture(ResourceLocation res) {
        this.picture.setImageTexture(res);
        return this;
    }

    public PictureButton setPictureTexture(String res) {
        this.picture.setImageTexture(res);
        return this;
    }

    @Override
    public void setup() {
        this.registerComponent(this.picture);
    }

    @Override
    public GuiWidget setWidth(int width) {
        super.setWidth(width);
        this.picture.setX(width - 2);
        return this;
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        this.picture.setX(x + 1);
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        this.picture.setY(y + 1);
        return this;
    }
}

