/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.utils.Geometry;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ScrollBar
extends GuiWidget {
    private float scrolled = 0.0f;
    protected int scrollerSize;
    protected boolean isScrolling = false;
    protected boolean visible = true;
    protected OnProgressChanged progressChangedListener = (bar, mod) -> {};
    protected float scrollWeight;
    protected boolean handleMouseWheel;

    public ScrollBar(int xPos, int yPos, int width, int height, int scrollerSize) {
        super(xPos, yPos, width, height);
        this.scrollerSize = scrollerSize;
        this.scrollWeight = 0.05f;
    }

    private void calculateScroller(int mouseY) {
        if (this.isScrolling) {
            float magic = ((float)(mouseY - this.getY() + 2) - 10.0f) / ((float)(this.getY() + this.height - (this.getY() + 2)) - 15.0f);
            this.updateProgress(magic - this.getScrolledAmt());
        }
    }

    private void drawScroller(int xPos, int yPos, int width, int height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"));
        Renderer.drawContinuousTexturedBox(xPos, yPos, this.isScrolling() ? 244 : 232, 0, width, height, 12, 15, 1, 2, 2, 2);
    }

    public float getProgress() {
        return this.getScrolledAmt();
    }

    public OnProgressChanged getProgressChangedListener() {
        return this.progressChangedListener;
    }

    public float getScrolledAmt() {
        return this.scrolled;
    }

    public boolean isScrolling() {
        return this.isScrolling;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        if (this.isVisible()) {
            this.calculateScroller(mouseY);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png"));
            Renderer.drawContinuousTexturedBox(this.getX(), this.getY(), 173, 16, this.width, this.height, 16, 114, 2, 2, 2, 2);
            int scrollerHeight = (int)((float)(this.getY() + 2) + this.getScrolledAmt() * (float)(this.height - 4 - this.scrollerSize));
            this.drawScroller(this.getX() + 2, scrollerHeight, this.width - 4, this.scrollerSize);
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
        this.isScrolling = !overlap && Geometry.isDotInArea(this.getX() + 2, (int)((float)(this.getY() + 2) + this.getScrolledAmt() * (float)(this.height - this.scrollerSize)), this.width - 4, this.scrollerSize, posX, posY);
        return this.isScrolling;
    }

    @Override
    public void onMouseInput() {
        super.onMouseInput();
        if (this.shouldHandleMouseWheel()) {
            double delta = Mouse.getDWheel();
            if (delta < 0.0) {
                this.updateProgress(this.scrollWeight);
            }
            if (delta > 0.0) {
                this.updateProgress(-this.scrollWeight);
            }
        }
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        super.onMouseRelease(mouseX, mouseY);
        this.isScrolling = false;
    }

    private void revalidateScroller() {
        if (this.getScrolledAmt() < 0.0f) {
            this.setScrolledAmt(0.0f);
        }
        if (this.getScrolledAmt() > 1.0f) {
            this.setScrolledAmt(1.0f);
        }
    }

    public ScrollBar setHandleMouseWheel(boolean status) {
        this.handleMouseWheel = status;
        return this;
    }

    public ScrollBar setProgress(float scroll) {
        this.setScrolledAmt(scroll);
        this.revalidateScroller();
        return this;
    }

    public ScrollBar setProgressChangedListener(OnProgressChanged progressChangedListener) {
        this.progressChangedListener = progressChangedListener;
        return this;
    }

    public void setScrolledAmt(float scrolled) {
        this.scrolled = scrolled;
    }

    public ScrollBar setScrollerSize(int size) {
        this.scrollerSize = size;
        return this;
    }

    public ScrollBar setScrollWeight(float newWeight) {
        this.scrollWeight = newWeight;
        return this;
    }

    public ScrollBar setVisiblie(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean shouldHandleMouseWheel() {
        return this.handleMouseWheel;
    }

    public void updateProgress(float modifier) {
        this.setProgress(this.getScrolledAmt() + modifier);
        this.getProgressChangedListener().onProgressChanged(this, modifier);
    }

    public static interface OnProgressChanged {
        public void onProgressChanged(ScrollBar var1, float var2);
    }
}

