/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.utils.Geometry;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class Slider
extends GuiWidget {
    protected float sliderValue = 1.0f;
    protected float sliderMaxValue = 1.0f;
    protected float sliderMinValue = 0.0f;
    protected float scrolled = 0.0f;
    protected int scrollerSize;
    protected boolean isScrolling = false;
    protected boolean visible = true;
    protected OnProgressChanged progressChangedListener = (bar, mod) -> {};
    protected OnMouseReleased mouseReleasedListener = (bar, mod) -> {};
    protected boolean handleMouseWheel;

    public Slider(int xPos, int yPos, int width, int height, int scrollerSize) {
        super(xPos, yPos, width, height);
        this.scrollerSize = scrollerSize;
    }

    private void calculateScroller(int pos) {
        if (this.isScrolling) {
            float magic = ((float)(pos - this.getX() + 2) - 10.0f) / ((float)(this.getX() + this.width - (this.getX() + 2)) - 15.0f);
            this.updateProgress(magic - this.scrolled);
        }
    }

    private void drawScroller(int xPos, int yPos, int width, int height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"));
        Renderer.drawContinuousTexturedBox(xPos, yPos, this.isScrolling() ? 244 : 232, 0, width, height, 12, 15, 1, 2, 2, 2);
    }

    public OnMouseReleased getMouseReleasedListener() {
        return this.mouseReleasedListener;
    }

    public float getProgress() {
        return this.scrolled;
    }

    public OnProgressChanged getProgressChangedListener() {
        return this.progressChangedListener;
    }

    public boolean isScrolling() {
        return this.isScrolling;
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        if (this.isVisible()) {
            this.setHandleMouseWheel(this.isUnderMouse(mouseX, mouseY));
            this.calculateScroller(mouseX);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png"));
            Renderer.drawContinuousTexturedBox(this.getX(), this.getY(), 173, 16, this.width, this.height, 16, 114, 2, 2, 2, 2);
            int scrollerPos = (int)((float)(this.getX() + 2) + this.scrolled * (float)(this.width - 4 - this.scrollerSize));
            this.drawScroller(scrollerPos, this.getY() + 2, this.scrollerSize, this.height - 4);
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
        this.isScrolling = !overlap && Geometry.isDotInArea(this.getX() + 2, (int)((float)(this.getY() + 2) + this.scrolled * (float)(this.height - this.scrollerSize)), this.width - 4, this.scrollerSize, posX, posY);
        return this.isScrolling;
    }

    @Override
    public void onMouseInput() {
        super.onMouseInput();
        if (this.shouldHandleMouseWheel()) {
            double delta = Mouse.getDWheel();
            if (delta < 0.0) {
                this.updateProgress(0.2f);
            }
            if (delta > 0.0) {
                this.updateProgress(-0.2f);
            }
        }
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        super.onMouseRelease(mouseX, mouseY);
        if (this.isScrolling) {
            this.isScrolling = false;
            float magic = ((float)(mouseX - this.getX() + 2) - 10.0f) / ((float)(this.getX() + this.width - (this.getX() + 2)) - 15.0f);
            this.updateProgress(magic - this.scrolled);
            this.getMouseReleasedListener().onMouseReleased(this, this.scrolled);
        }
    }

    private void revalidateScroller() {
        if (this.scrolled < 0.0f) {
            this.scrolled = 0.0f;
        }
        if (this.scrolled > 1.0f) {
            this.scrolled = 1.0f;
        }
    }

    public Slider setHandleMouseWheel(boolean status) {
        this.handleMouseWheel = status;
        return this;
    }

    public Slider setMouseReleasedListener(OnMouseReleased mouseReleasedListener) {
        this.mouseReleasedListener = mouseReleasedListener;
        return this;
    }

    public Slider setProgress(float scroll) {
        this.scrolled = scroll;
        this.revalidateScroller();
        return this;
    }

    public Slider setProgressChangedListener(OnProgressChanged progressChangedListener) {
        this.progressChangedListener = progressChangedListener;
        return this;
    }

    public Slider setScrollerSize(int size) {
        this.scrollerSize = size;
        return this;
    }

    public Slider setVisiblie(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean shouldHandleMouseWheel() {
        return this.handleMouseWheel;
    }

    public void updateProgress(float modifier) {
        this.setProgress(this.scrolled + modifier);
        this.getProgressChangedListener().onProgressChanged(this, this.scrolled);
    }

    public static interface OnProgressChanged {
        public void onProgressChanged(Slider var1, float var2);
    }

    public static interface OnMouseReleased {
        public void onMouseReleased(Slider var1, float var2);
    }
}

