/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.control;

import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@LayoutComponent
public class ToggleButton
extends Button {
    protected boolean toggle;

    protected ToggleButton() {
    }

    public ToggleButton(int xPos, int yPos, int width, int height, String title, boolean toggle) {
        super(xPos, yPos, width, height, title);
        this.toggle = toggle;
    }

    public boolean getToggleState() {
        return this.toggle;
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.prepareRender();
            if (!this.isEnabled()) {
                this.drawButton(0);
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                this.drawButton(2);
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringText(this.hoverText, mouseX - tlineWidth - 20, mouseY + 12);
                    } else {
                        Renderer.drawHoveringText(this.hoverText, mouseX, mouseY + 12);
                    }
                }
            } else if (this.toggle) {
                this.drawButton(1);
            } else {
                this.drawButton(0);
            }
            TextRenderer.renderString(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2 - 4, this.getText(), TextAlignment.CENTER);
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        boolean clicked;
        boolean bl = clicked = this.isButtonUnderMouse(posX, posY) && this.isEnabled() && !overlap;
        if (clicked) {
            if (this.getClickListener() != null) {
                this.getClickListener().onClick(this);
            }
            this.playClickSound();
            this.toggle = !this.toggle;
        }
        return clicked;
    }
}

