/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.control.ScrollBar;
import com.libraries.rabbit.gui.component.control.TextBox;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ChatBox
extends TextBox {
    private ScrollBar scrollBar;
    protected int maxStringLenght = 1000;
    private int listHeight;

    public ChatBox(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
        this.listHeight = height;
    }

    public ChatBox(int xPos, int yPos, int width, int height, String initialText) {
        super(xPos, yPos, width, height, initialText);
        this.listHeight = height;
    }

    @Override
    protected void drawBox() {
        if (this.isVisible()) {
            GlStateManager.func_179094_E();
            int startLine = this.getStartLineY();
            int maxLineAmount = this.height / TextRenderer.getFontRenderer().field_78288_b + startLine;
            List<String> lines = this.getLines();
            ArrayList<String> newlines = new ArrayList<String>();
            int lineCount = 0;
            int maxWidth = this.width - 10;
            for (int i = 0; i < lines.size(); ++i) {
                char[] chars;
                String wholeLine = lines.get(i);
                String line = "";
                for (char c : chars = wholeLine.toCharArray()) {
                    if (TextRenderer.getFontRenderer().func_78256_a(line + c) > maxWidth) {
                        if (lineCount >= startLine && lineCount < maxLineAmount) {
                            newlines.add(line.substring(0, line.lastIndexOf(32)));
                        }
                        line = line.contains(" ") ? line.substring(line.lastIndexOf(32) + 1) : "";
                        ++lineCount;
                    }
                    line = line + c;
                }
                if (lineCount >= startLine && lineCount < maxLineAmount) {
                    newlines.add(line);
                }
                ++lineCount;
            }
            this.listHeight = 5 + lineCount * TextRenderer.getFontRenderer().field_78288_b;
            Renderer.renderChatBubble(this.x, this.y, this.width, Math.min(this.height, this.listHeight), newlines);
            this.scrollBar.setVisiblie(this.listHeight > this.height - 4);
            this.scrollBar.setHandleMouseWheel(this.listHeight > this.height - 4 && this.isUnderMouse(Mouse.getX(), Mouse.getY()));
            this.scrollBar.setScrollerSize(this.getScrollerSize());
            GlStateManager.func_179117_G();
            GlStateManager.func_179121_F();
        }
    }

    public List<String> getLines() {
        char[] chars;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer currentLine = new StringBuffer();
        for (char symbol : chars = this.getText().toCharArray()) {
            if (symbol == '\r' || symbol == '\n') {
                lines.add(currentLine.toString());
                currentLine.delete(0, currentLine.length());
                continue;
            }
            currentLine.append(symbol);
        }
        lines.add(currentLine.toString());
        return lines;
    }

    @Override
    public int getMaxLength() {
        return this.maxStringLenght;
    }

    private int getScrollerSize() {
        return (int)(1.0f * (float)this.height / (float)this.listHeight * (float)(this.height - 4));
    }

    private int getStartLineY() {
        if (this.scrollBar != null) {
            float scrolled = this.scrollBar.getScrolledAmt();
            return MathHelper.func_76123_f((float)(scrolled * (float)this.getHeight() / (float)TextRenderer.getFontRenderer().field_78288_b));
        }
        return 0;
    }

    @Override
    protected boolean handleMouseClick(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        return false;
    }

    @Override
    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }

    @Override
    public void setup() {
        this.scrollBar = new ScrollBar(this.getX() + this.getWidth(), this.getY(), 15, this.getHeight(), 20).setVisiblie(false);
        this.registerComponent(this.scrollBar);
    }

    @Override
    public GuiWidget setX(int x) {
        super.setX(x);
        if (this.scrollBar != null) {
            this.scrollBar.setX(x + this.width);
        }
        return this;
    }

    @Override
    public GuiWidget setY(int y) {
        super.setY(y);
        if (this.scrollBar != null) {
            this.scrollBar.setY(y);
        }
        return this;
    }
}

