/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.google.common.collect.Lists;
import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.display.tabs.Tab;
import com.libraries.rabbit.gui.render.ShaderProgram;
import com.libraries.rabbit.gui.utils.Geometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class Panel
extends GuiWidget {
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("rabbit", null, "shaders/alpha.frag");
    List<GuiWidget> panelComponents = new ArrayList<GuiWidget>();
    private boolean isDragging = false;
    private boolean isResizing = false;
    private boolean canDrag = false;
    private boolean canResize = false;
    private int dragXDelta;
    private int dragYDelta;
    private int resizeXPos;
    private int resizeYPos;
    private boolean isVisible;
    private boolean isFocused;
    private boolean doesDim;
    private int z = 0;

    public Panel(int xPos, int yPos, int width, int height) {
        this(xPos, yPos, width, height, true);
    }

    public Panel(int xPos, int yPos, int width, int height, boolean visible) {
        super(xPos, yPos, width, height);
        this.isVisible = visible;
        this.isFocused = false;
        this.doesDim = false;
    }

    public boolean canDrag() {
        return this.canDrag;
    }

    public boolean canResize() {
        return this.canResize;
    }

    public boolean doesDim() {
        return this.doesDim;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void movePanel(int newX, int newY) {
        float xDelta = this.x - newX;
        float yDelta = this.y - newY;
        if (xDelta == 0.0f && yDelta == 0.0f) {
            return;
        }
        this.panelComponents.forEach(com -> {
            com.setX((int)((float)com.getX() - xDelta));
            com.setY((int)((float)com.getY() - yDelta));
        });
        this.x = newX;
        this.y = newY;
    }

    @Override
    public void onDraw(int xMouse, int yMouse, float partialTicks) {
        if (this.isVisible) {
            if (this.isFocused) {
                if (this.isDragging) {
                    this.movePanel(xMouse - this.dragXDelta, yMouse - this.dragYDelta);
                }
                if (this.isResizing) {
                    this.resize(this.width - (this.resizeXPos - xMouse), this.height - (this.resizeYPos - yMouse));
                    this.resizeXPos = xMouse;
                    this.resizeYPos = yMouse;
                }
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.z);
            boolean shouldDim = false;
            if (this.doesDim) {
                shouldDim = !Geometry.isDotInArea(this.x, this.y, this.width, this.height, xMouse, yMouse);
                for (GuiWidget com2 : this.panelComponents) {
                    if (!com2.isUnderMouse(xMouse, yMouse)) continue;
                    shouldDim = false;
                }
            }
            if (shouldDim && OpenGlHelper.field_148824_g) {
                GL20.glUseProgram((int)SHADER_ALPHA.getProgram());
                GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)0.6f);
            }
            this.panelComponents.forEach(com -> com.onDraw(xMouse, yMouse, partialTicks));
            if (shouldDim) {
                GL20.glUseProgram((int)0);
            }
        }
    }

    @Override
    public void onKeyTyped(char typedChar, int typedIndex) {
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onKeyTyped(typedChar, typedIndex));
        }
    }

    @Override
    public boolean onMouseClicked(int posX, int posY, int mouseButtonIndex, boolean overlap) {
        this.isFocused = this.isUnderMouse(posX, posY);
        if (this.isVisible) {
            if (this.isFocused) {
                super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
                if (this.canDrag) {
                    boolean bl = this.isDragging = !overlap && Geometry.isDotInArea(this.x, this.y + 10, 5, this.height - 10, posX, posY);
                }
                if (this.canResize) {
                    boolean bl = this.isResizing = !overlap && Geometry.isDotInArea((int)((double)(this.x + this.width) - (double)this.width * 0.1), this.height - 10, (int)((double)this.width * 0.1), 10, posX, posY);
                }
                if (this.isDragging) {
                    this.dragXDelta = posX - this.x;
                    this.dragYDelta = posY - this.y;
                }
                if (this.isResizing) {
                    this.resizeXPos = posX;
                    this.resizeYPos = posY;
                }
                this.panelComponents.forEach(com -> {
                    if (com.onMouseClicked(posX, posY, mouseButtonIndex, overlap)) {
                        this.isResizing = false;
                        this.isDragging = false;
                    }
                });
                return true;
            }
            this.panelComponents.forEach(com -> {
                if (com instanceof Tab) {
                    com.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
                }
            });
        }
        return super.onMouseClicked(posX, posY, mouseButtonIndex, overlap);
    }

    @Override
    public void onMouseInput() {
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onMouseInput());
        }
    }

    @Override
    public void onMouseRelease(int mouseX, int mouseY) {
        super.onMouseRelease(mouseX, mouseY);
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onMouseRelease(mouseX, mouseY));
            if (this.isDragging) {
                this.isDragging = false;
            }
            if (this.isResizing) {
                this.isResizing = false;
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.isVisible && this.isFocused) {
            this.panelComponents.forEach(com -> com.onUpdate());
        }
    }

    @Override
    public void registerComponent(IGui component) {
        GuiWidget widget = (GuiWidget)component;
        widget.setX(widget.getX() + this.x);
        widget.setY(widget.getY() + this.y);
        this.panelComponents.add(widget);
    }

    public void resize(int newWidth, int newHeight) {
        float widthDelta = (float)newWidth / (float)this.width;
        float heightDelta = (float)newHeight / (float)this.height;
        this.panelComponents.forEach(com -> {
            if (!(com instanceof Button)) {
                com.setWidth((int)((float)com.getWidth() * widthDelta));
                com.setHeight((int)((float)com.getHeight() * heightDelta));
            }
        });
        this.setSize(newWidth, newHeight);
    }

    public Panel reverseComponents() {
        this.panelComponents = Lists.reverse(this.panelComponents);
        return this;
    }

    public Panel setCanDrag(boolean canDrag) {
        this.canDrag = canDrag;
        return this;
    }

    public void setDimming(boolean doesDim) {
        this.doesDim = doesDim;
    }

    public Panel setFocused(boolean isFocused) {
        this.isFocused = isFocused;
        return this;
    }

    public Panel setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public void setup() {
        this.panelComponents.forEach(com -> com.setup());
    }

    public Panel setVisible(boolean state) {
        if (!state) {
            this.isFocused = false;
        }
        this.isVisible = state;
        return this;
    }

    public Panel setZ(int zPos) {
        this.z = zPos;
        return this;
    }
}

