/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.utils.TextureHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Picture
extends GuiWidget {
    private UUID pictureUUID = UUID.randomUUID();
    private int imageWidth;
    private int imageHeight;

    public Picture(int xPos, int yPos, int width, int height, ResourceLocation texture) {
        super(xPos, yPos, width, height);
        TextureHelper.addStaticTexture(this.pictureUUID, texture);
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b());
            this.setImageWidth(image.getWidth());
            this.setImageHeight(image.getHeight());
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    public Picture(int xPos, int yPos, int width, int height, String textureLocation) {
        super(xPos, yPos, width, height);
        TextureHelper.addTexture(this.pictureUUID, textureLocation);
        if (TextureHelper.isTextureStatic(this.pictureUUID)) {
            try {
                BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(TextureHelper.getStaticTexture(this.pictureUUID)).func_110527_b());
                this.setImageWidth(image.getWidth());
                this.setImageHeight(image.getHeight());
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        } else if (TextureHelper.isTextureDynamic(this.pictureUUID)) {
            try {
                BufferedImage image = ImageIO.read(new URL(textureLocation));
                this.setImageWidth(image.getWidth());
                this.setImageHeight(image.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Picture(int xPos, int yPos, int width, int height, UUID textureId) {
        super(xPos, yPos, width, height);
        this.pictureUUID = textureId;
        if (TextureHelper.isTextureStatic(this.pictureUUID)) {
            try {
                BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(TextureHelper.getStaticTexture(this.pictureUUID)).func_110527_b());
                this.setImageWidth(image.getWidth());
                this.setImageHeight(image.getHeight());
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        } else if (TextureHelper.isTextureDynamic(this.pictureUUID)) {
            this.setImageWidth((Integer)TextureHelper.getDynamicTextureInfo(textureId).getLeft());
            this.setImageHeight((Integer)TextureHelper.getDynamicTextureInfo(textureId).getRight());
        }
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public void onDraw(int xMouse, int yMouse, float partialTicks) {
        super.onDraw(xMouse, yMouse, partialTicks);
        this.renderPicture();
    }

    private void renderPicture() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179117_G();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179112_b((int)770, (int)771);
        TextureHelper.bindTexture(this.pictureUUID);
        Renderer.drawScaledTexturedRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        GlStateManager.func_179121_F();
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public void setImageTexture(ResourceLocation texture) {
        TextureHelper.addStaticTexture(this.pictureUUID, texture);
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b());
            this.setImageWidth(image.getWidth());
            this.setImageHeight(image.getHeight());
        }
        catch (IOException ioex) {
            throw new RuntimeException("Can't get resource", ioex);
        }
    }

    public void setImageTexture(String textureLocation) {
        TextureHelper.addTexture(this.pictureUUID, textureLocation);
        if (TextureHelper.isTextureStatic(this.pictureUUID)) {
            try {
                BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(TextureHelper.getStaticTexture(this.pictureUUID)).func_110527_b());
                this.setImageWidth(image.getWidth());
                this.setImageHeight(image.getHeight());
            }
            catch (IOException ioex) {
                throw new RuntimeException("Can't get resource", ioex);
            }
        } else if (TextureHelper.isTextureDynamic(this.pictureUUID)) {
            this.setImageWidth((Integer)TextureHelper.getDynamicTextureInfo(this.pictureUUID).getLeft());
            this.setImageHeight((Integer)TextureHelper.getDynamicTextureInfo(this.pictureUUID).getRight());
        }
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }
}

