/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display.graph;

import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.awt.Color;
import java.util.stream.DoubleStream;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PieChart
extends GuiWidget {
    protected Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.MAGENTA, Color.GREEN, Color.pink};
    protected int size;
    protected double[] data = new double[0];
    protected double[] angles = new double[0];
    protected String[] titles = new String[0];

    public PieChart(int x, int y, int size, double[] data) {
        this(x, y, size, data, new String[0]);
    }

    public PieChart(int x, int y, int size, double[] data, String[] titles) {
        super(x, y, size, size);
        this.size = size;
        this.data = data;
        this.titles = titles;
        this.initialCalculate();
    }

    public double[] getAngles() {
        return this.angles;
    }

    public double[] getData() {
        return this.data;
    }

    public String[] getTitles() {
        return this.titles;
    }

    protected void initialCalculate() {
        this.angles = new double[this.data.length];
        double total = DoubleStream.of(this.data).sum();
        for (int i = 0; i < this.data.length; ++i) {
            this.angles[i] = this.data[i] / total * 360.0;
        }
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        super.onDraw(mouseX, mouseY, partialTicks);
        double prevAngle = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            Color color = this.colors[i % this.colors.length];
            Renderer.drawFilledArc(this.x + this.width / 2, this.y + this.height / 2, this.size / 2, prevAngle, this.angles[i] + prevAngle, color.getRGB());
            if (i < this.titles.length && this.angles[i] > 0.0) {
                double textAngle = Math.toRadians(prevAngle + this.angles[i] / 2.0);
                int textX = (int)((double)(this.x + this.width / 2) + Math.sin(textAngle) * (double)this.size / 4.0);
                int textY = (int)((double)(this.y + this.height / 2) + Math.cos(textAngle) * (double)this.size / 4.0);
                TextRenderer.renderString(textX, textY -= 5, this.titles[i], TextAlignment.CENTER);
            }
            prevAngle += this.angles[i];
        }
    }

    public PieChart setColors(Color[] colors) {
        this.colors = colors;
        return this;
    }

    public PieChart setData(double[] data) {
        this.data = data;
        this.initialCalculate();
        return this;
    }

    public PieChart setTitles(String[] titles) {
        this.titles = titles;
        return this;
    }
}

