/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.display.tabs;

import com.libraries.rabbit.gui.component.display.tabs.Tab;
import com.libraries.rabbit.gui.render.TextAlignment;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class TextTab
extends Tab {
    private String[] lines;

    public TextTab(int x, int y, int width, int height) {
        this(x, y, width, height, "");
    }

    public TextTab(int x, int y, int width, int height, int angle, String ... lines) {
        super(x, y, width, height, angle);
        this.lines = lines;
        int tabwidth = width;
        for (String line : lines) {
            tabwidth = Math.max(TextRenderer.getFontRenderer().func_78256_a(line) + 8, tabwidth);
        }
        if (angle == 0 || angle == 180) {
            this.width = tabwidth;
            this.height = 8 + 8 * lines.length;
        } else {
            this.height = tabwidth;
            this.width = 8 + 8 * lines.length;
        }
    }

    public TextTab(int x, int y, int width, int height, String ... lines) {
        this(x, y, width, height, 0, lines);
    }

    public List<String> getLines() {
        return Arrays.asList(this.lines);
    }

    @Override
    public void onDraw(int mouseX, int mouseY, float partialTicks) {
        this.beginDrawingTab(mouseX, mouseY, partialTicks);
        if (!this.isHidden) {
            int curYPos = 3;
            if (this.angle == 0) {
                curYPos = this.y + 3;
                for (String line : this.lines) {
                    TextRenderer.renderString((int)((double)this.x + ((double)this.width / 2.0 - (double)TextRenderer.getFontRenderer().func_78256_a(line) / 2.0)), curYPos, line, Color.white);
                    curYPos += 8;
                }
            } else if (this.angle == 180) {
                GlStateManager.func_179109_b((float)(-this.width), (float)0.0f, (float)2.0f);
                for (String line : this.lines) {
                    TextRenderer.renderString((int)((double)this.width / 2.0) - 1, curYPos, line, Color.white, TextAlignment.CENTER);
                    curYPos += 8;
                }
            } else if (this.angle == 90) {
                GlStateManager.func_179109_b((float)(-this.height), (float)0.0f, (float)2.0f);
                curYPos = 4;
                for (String line : this.lines) {
                    TextRenderer.renderString((int)((double)this.height / 2.0), curYPos, line, Color.white, TextAlignment.CENTER);
                    curYPos += 8;
                }
            } else {
                GlStateManager.func_179109_b((float)this.height, (float)0.0f, (float)2.0f);
                curYPos = 4;
                for (String line : this.lines) {
                    TextRenderer.renderString((int)((double)this.height / 2.0), curYPos, line, Color.white, TextAlignment.CENTER);
                    curYPos += 8;
                }
            }
        }
        this.finishDrawingTab(mouseX, mouseY, partialTicks);
        this.drawHoverText(mouseX, mouseY, partialTicks);
    }

    public void setText(String ... lines) {
        this.lines = lines;
        int tabwidth = this.width;
        for (String line : lines) {
            tabwidth = Math.max(TextRenderer.getFontRenderer().func_78256_a(line) + 8, tabwidth);
        }
        this.width = tabwidth;
        this.height = 8 + 8 * lines.length;
    }
}

