/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.grid.entries;

import com.libraries.rabbit.gui.component.control.Button;
import com.libraries.rabbit.gui.component.display.Picture;
import com.libraries.rabbit.gui.component.grid.Grid;
import com.libraries.rabbit.gui.component.grid.entries.GridEntry;
import com.libraries.rabbit.gui.render.Renderer;
import com.libraries.rabbit.gui.render.TextRenderer;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PictureButtonGridEntry
extends Button
implements GridEntry {
    private OnClickListener listener;
    private Picture picture;
    private int imageWidth;
    private int imageHeight;

    public PictureButtonGridEntry(int width, int height, ResourceLocation texture) {
        this(width, height, texture, null);
    }

    public PictureButtonGridEntry(int width, int height, ResourceLocation texture, OnClickListener listener) {
        super(0, 0, width, height, "");
        this.picture = new Picture(0, 0, width - 2, height - 2, texture);
        this.listener = listener;
    }

    public PictureButtonGridEntry(int width, int height, String texture) {
        this(width, height, texture, null);
    }

    public PictureButtonGridEntry(int width, int height, String texture, OnClickListener listener) {
        super(0, 0, width, height, "");
        this.picture = new Picture(0, 0, width - 2, height - 2, texture);
        this.listener = listener;
    }

    public PictureButtonGridEntry(int width, int height, UUID textureId) {
        this(width, height, textureId, null);
    }

    public PictureButtonGridEntry(int width, int height, UUID textureId, OnClickListener listener) {
        super(0, 0, width, height, "");
        this.picture = new Picture(0, 0, width - 2, height - 2, textureId);
        this.listener = listener;
    }

    @Override
    public PictureButtonGridEntry addHoverText(String text) {
        this.originalHoverText.add(text);
        return this;
    }

    @Override
    public List<String> getHoverText() {
        return this.originalHoverText;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public void onClick(Grid grid, int mouseX, int mouseY) {
        if (this.listener != null) {
            this.listener.onClick(this, grid, mouseX, mouseY);
        }
    }

    @Override
    public void onDraw(Grid grid, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        if (this.getX() != posX) {
            this.setX(posX);
            this.picture.setX(posX + 1);
        }
        if (this.getY() != posY) {
            this.setY(posY);
            this.picture.setY(posY + 1);
        }
        if (this.getWidth() != width) {
            this.setWidth(width);
            this.picture.setWidth(width - 2);
        }
        if (this.getHeight() != height) {
            this.setHeight(height);
            this.picture.setHeight(height - 2);
        }
        if (this.isVisible()) {
            this.prepareRender();
            if (!this.isEnabled()) {
                this.drawButton(0);
                this.picture.onDraw(mouseX, mouseY, 0.0f);
            } else if (this.isButtonUnderMouse(mouseX, mouseY)) {
                this.drawButton(2);
                this.picture.onDraw(mouseX, mouseY, 0.0f);
                if (this.drawHoverText) {
                    this.verifyHoverText(mouseX, mouseY);
                    if (this.drawToLeft) {
                        int tlineWidth = 0;
                        for (String line : this.hoverText) {
                            tlineWidth = TextRenderer.getFontRenderer().func_78256_a(line) > tlineWidth ? TextRenderer.getFontRenderer().func_78256_a(line) : tlineWidth;
                        }
                        Renderer.drawHoveringTextInScissoredArea(this.hoverText, mouseX - tlineWidth - 20, mouseY);
                    } else {
                        Renderer.drawHoveringTextInScissoredArea(this.hoverText, mouseX, mouseY);
                    }
                }
            } else {
                this.drawButton(1);
                this.picture.onDraw(mouseX, mouseY, 0.0f);
            }
        }
    }

    public PictureButtonGridEntry setClickListener(OnClickListener onClicked) {
        this.listener = onClicked;
        return this;
    }

    @Override
    public PictureButtonGridEntry setDoesDrawHoverText(boolean state) {
        this.drawHoverText = state;
        return this;
    }

    @Override
    public PictureButtonGridEntry setHoverText(List<String> text) {
        this.originalHoverText = text;
        return this;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public PictureButtonGridEntry setPictureTexture(ResourceLocation res) {
        this.picture.setImageTexture(res);
        return this;
    }

    public PictureButtonGridEntry setPictureTexture(String res) {
        this.picture.setImageTexture(res);
        return this;
    }

    public static interface OnClickListener {
        public void onClick(PictureButtonGridEntry var1, Grid var2, int var3, int var4);
    }
}

