/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.grid.entries;

import com.libraries.rabbit.gui.component.grid.Grid;
import com.libraries.rabbit.gui.component.grid.entries.GridEntry;
import com.libraries.rabbit.gui.render.Renderer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PictureGridEntry
implements GridEntry {
    private OnClickListener listener;
    private ResourceLocation texture;
    private int imageWidth;
    private int imageHeight;

    public PictureGridEntry(int width, int height, ResourceLocation texture) {
        this(width, height, texture, null);
    }

    public PictureGridEntry(int width, int height, ResourceLocation texture, OnClickListener listener) {
        this.texture = texture;
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b());
            this.setImageWidth(image.getWidth());
            this.setImageHeight(image.getHeight());
        }
        catch (IOException ioex) {
            throw new RuntimeException("Can't get resource", ioex);
        }
        this.listener = listener;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public void onClick(Grid grid, int mouseX, int mouseY) {
        if (this.listener != null) {
            this.listener.onClick(this, grid, mouseX, mouseY);
        }
    }

    @Override
    public void onDraw(Grid grid, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        Renderer.drawScaledTexturedRect(posX, posY, width, height);
        GlStateManager.func_179121_F();
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public static interface OnClickListener {
        public void onClick(PictureGridEntry var1, Grid var2, int var3, int var4);
    }
}

