/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.component.list.entries;

import com.google.common.collect.Lists;
import com.libraries.rabbit.gui.component.GuiWidget;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.component.list.DisplayList;
import com.libraries.rabbit.gui.component.list.entries.ListEntry;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class MultiComponentListEntry
implements ListEntry {
    List<Triple<GuiWidget, Integer, Integer>> entryComponents = new ArrayList<Triple<GuiWidget, Integer, Integer>>();
    @LayoutComponent
    protected boolean isEnabled = true;

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void onClick(DisplayList list, int mouseX, int mouseY, int mouseButtonIndex) {
        this.entryComponents.forEach(com -> ((GuiWidget)com.getLeft()).onMouseClicked(mouseX, mouseY, mouseButtonIndex, false));
    }

    @Override
    public void onDraw(DisplayList list, int posX, int posY, int width, int height, int mouseX, int mouseY) {
        this.entryComponents.forEach(com -> {
            ((GuiWidget)com.getLeft()).setX(posX + (Integer)com.getMiddle());
            ((GuiWidget)com.getLeft()).setY(posY + (Integer)com.getRight());
            ((GuiWidget)com.getLeft()).onDraw(mouseX, mouseY, 1.0f);
        });
    }

    @Override
    public void onUpdate() {
        this.entryComponents.forEach(com -> ((GuiWidget)com.getLeft()).onUpdate());
    }

    public MultiComponentListEntry registerComponent(IGui component, int x, int y) {
        this.entryComponents.add((Triple<GuiWidget, Integer, Integer>)new ImmutableTriple((Object)component, (Object)x, (Object)y));
        return this;
    }

    public ListEntry reverseComponents() {
        this.entryComponents = Lists.reverse(this.entryComponents);
        return this;
    }

    @Override
    public ListEntry setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }
}

