/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.layout;

import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.layout.argument.ILayoutArgument;
import com.libraries.rabbit.gui.layout.argument.LayoutArgument;
import com.libraries.rabbit.gui.layout.argument.LayoutCalculatableArgument;
import com.libraries.rabbit.gui.show.IShow;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class LayoutComponentWrapper {
    private Class type;
    private Set<ILayoutArgument> args;

    private static IGui instantiateType(Class type) {
        try {
            Constructor constr = type.getDeclaredConstructor(new Class[0]);
            if (constr != null) {
                constr.setAccessible(true);
            }
            return (IGui)constr.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Can't instantiate " + type.getName() + " with zero-arg constructor");
        }
    }

    public LayoutComponentWrapper(Class type, Set<ILayoutArgument> args) {
        this.type = type;
        this.args = args;
    }

    public IGui create() throws Exception {
        return this.create(null);
    }

    public IGui create(IShow show) throws Exception {
        IGui com = LayoutComponentWrapper.instantiateType(this.type);
        for (ILayoutArgument arg : this.args) {
            Integer value = null;
            if (arg instanceof LayoutArgument) {
                value = (Integer)((LayoutArgument)arg).get();
            } else if (arg instanceof LayoutCalculatableArgument && show != null) {
                value = ((LayoutCalculatableArgument)arg).get(new Pair[0]);
            }
            FieldUtils.writeField((Object)com, (String)arg.fieldName(), value, (boolean)true);
        }
        return com;
    }

    public Set<ILayoutArgument> getArguments() {
        return this.args;
    }

    public Class getType() {
        return this.type;
    }
}

