/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.layout.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.libraries.rabbit.gui.component.IGui;
import com.libraries.rabbit.gui.layout.LayoutComponent;
import com.libraries.rabbit.gui.layout.LayoutComponentWrapper;
import com.libraries.rabbit.gui.layout.LayoutFunctions;
import com.libraries.rabbit.gui.layout.argument.ILayoutArgument;
import com.libraries.rabbit.gui.layout.argument.LayoutArgument;
import com.libraries.rabbit.gui.layout.argument.LayoutCalculatableArgument;
import com.libraries.rabbit.gui.layout.parser.LayoutParser;
import com.libraries.rabbit.gui.show.LayoutShow;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;

@SideOnly(value=Side.CLIENT)
public class JsonLayoutParser
implements LayoutParser {
    private LayoutShow from(JsonElement json) {
        JsonObject layout = json.getAsJsonObject();
        this.parseTitle(layout);
        List<LayoutComponentWrapper> components = this.wrapComponents(this.parseComponents(layout));
        return new LayoutShow(components);
    }

    @Override
    public LayoutShow from(URI path) {
        JsonElement json;
        File file = new File(path);
        try {
            json = new JsonParser().parse((Reader)new FileReader(file));
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Error while parsing " + file.getAbsolutePath());
        }
        return this.from(json);
    }

    private Map<String, Class<?>> getAllowedFields(Class<? extends IGui> type) {
        LayoutComponent config = type.getAnnotation(LayoutComponent.class);
        Validate.notNull((Object)config, (String)"Provided type can't be accessed throught layout", (Object[])new Object[0]);
        HashMap allowedFields = Maps.newHashMap();
        for (Field field : FieldUtils.getAllFields(type)) {
            if (!field.isAnnotationPresent(LayoutComponent.class)) continue;
            allowedFields.put(field.getName(), field.getType());
        }
        return allowedFields;
    }

    private ILayoutArgument getArgument(String fieldName, Class<?> type, JsonElement element) {
        Object value;
        boolean isSimple;
        ILayoutArgument result = null;
        boolean bl = isSimple = ClassUtils.isPrimitiveOrWrapper(type) || type.isAssignableFrom(String.class);
        result = isSimple ? ((value = this.getPrimitiveValue(type, element)) instanceof Expression ? new LayoutCalculatableArgument(fieldName, (Expression)value) : new LayoutArgument<Object>(fieldName, value)) : new LayoutArgument<Object>(fieldName, this.getComplicatedValue(type, element));
        return result;
    }

    private List<ILayoutArgument> getArguments(Map<String, JsonElement> fields, Map<String, Class<?>> allowedFields) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, JsonElement> entry : fields.entrySet()) {
            Class<?> fieldType = allowedFields.get(entry.getKey());
            Validate.notNull(fieldType, (String)(entry.getKey() + " not found in component"), (Object[])new Object[0]);
            result.add(this.getArgument(entry.getKey(), fieldType, entry.getValue()));
        }
        return result;
    }

    private Object getComplicatedValue(Class<?> type, JsonElement element) {
        return new Gson().fromJson(element, type);
    }

    private Object getPrimitiveValue(Class<?> type, JsonElement element) {
        Object result = null;
        if (type.isAssignableFrom(String.class)) {
            result = element.getAsString();
        } else if (type.isAssignableFrom(Integer.TYPE)) {
            try {
                result = Integer.parseInt(element.getAsString());
            }
            catch (NumberFormatException ex) {
                result = new ExpressionBuilder(element.getAsString()).functions(new Function[]{LayoutFunctions.width, LayoutFunctions.height}).build();
            }
        } else if (type.isAssignableFrom(Boolean.TYPE)) {
            result = element.getAsBoolean();
        }
        return result;
    }

    private JsonArray parseComponents(JsonObject layout) {
        return layout.has("components") ? layout.getAsJsonArray("components") : new JsonArray();
    }

    private String parseTitle(JsonObject layout) {
        return layout.has("title") ? layout.get("title").getAsString() : "";
    }

    private LayoutComponentWrapper wrap(JsonObject component) {
        try {
            Map<String, JsonElement> layoutFields = component.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Class<?> componentType = Class.forName(layoutFields.remove("type").getAsString());
            Map<String, Class<?>> allowedFields = this.getAllowedFields(componentType);
            List<ILayoutArgument> layoutArgument = this.getArguments(layoutFields, allowedFields);
            return new LayoutComponentWrapper(componentType, new HashSet<ILayoutArgument>(layoutArgument));
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Can't resolve component type");
        }
    }

    private List<LayoutComponentWrapper> wrapComponents(JsonArray components) {
        return Lists.newArrayList((Iterator)components.iterator()).stream().map(element -> this.wrap(element.getAsJsonObject())).collect(Collectors.toList());
    }
}

