/*
 * Decompiled with CFR 0.152.
 */
package com.libraries.rabbit.gui.utils;

import com.libraries.rabbit.gui.utils.DoubleChangeDispatcher;
import com.libraries.rabbit.gui.utils.DoubleChangeEvent;
import com.libraries.rabbit.gui.utils.DoubleChangeListener;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;

public class DoubleListener
implements DoubleChangeDispatcher {
    private double value;
    private List<DoubleChangeListener> listeners;

    public DoubleListener(double initialState) {
        this.value = initialState;
        this.listeners = new ArrayList<DoubleChangeListener>();
    }

    @Override
    public void addDoubleChangeListener(DoubleChangeListener listener) {
        this.listeners.add(listener);
    }

    private void dispatchEvent() {
        DoubleChangeEvent event = new DoubleChangeEvent(this);
        for (DoubleChangeListener l : this.listeners) {
            this.dispatchRunnableOnEventQueue(l, event);
        }
    }

    private void dispatchRunnableOnEventQueue(DoubleChangeListener listener, DoubleChangeEvent event) {
        EventQueue.invokeLater(() -> listener.stateChanged(event));
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        if (this.value != value) {
            this.value = value;
            this.dispatchEvent();
        }
    }
}

